<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:xs="http://www.w3.org/2001/XMLSchema" 
xmlns="http://www.sec.gov/edgar/document/thirteenf/informationtable"
xmlns:n1="http://www.sec.gov/edgar/document/thirteenf/informationtable"
xmlns:ns1="http://www.sec.gov/edgar/common">
 <xsl:output method="html" 
 doctype-system="http://www.w3.org/TR/html4/strict.dtd" 
 doctype-public="-//W3C//DTD HTML 4.01//EN" 
 indent="yes"/> 
<xsl:template match="/">
<html>
<head>
  <link href="css/13F_print.css" type="text/css" rel="stylesheet"/>
</head>
  <body>
   <div class="content">
    <h2>FORM 13F INFORMATION TABLE </h2>
   <table border="0" class="infoTable" cellpadding="0" cellspacing="0">
      
    <tr>
      <th valign="top" class="infoCol1">Column 1</th>
      <th valign="top" class="infoCol2">Column 2</th>
      <th valign="top" class="infoCol3">Column 3</th>
      <th valign="top" class="infoCol4">Column 4</th>
      <th colspan="3" valign="top" class="infoCol5">Column 5</th>
      <th valign="top" class="infoCol6">Column 6</th>
      <th valign="top" class="infoCol7">Column 7</th>
      <th colspan="3" valign="top" class="infoCol8">Column 8</th>
    </tr>
    <tr>
      <th rowspan="2" class="infoCol1">Name of<br>
        Issuer</br></th>
      <th rowspan="2" class="infoCol2">Title of<br>
        Class</br></th>
      <th rowspan="2" class="infoCol3">CUSIP</th>
      <th rowspan="2" class="infoCol4">Value<br>
        (x$1000)</br></th>
      <th rowspan="2" class="infoCol5a">SHRS or<br>
        PRN AMT</br></th>
      <th rowspan="2" class="infoCol5b">SH /<br>
        PRN</br></th>
      <th rowspan="2" class="infoCol5c">PUT /<br>
        CALL</br></th>
      <th rowspan="2" class="infoCol6">Investment<br>
        DISCRETION</br></th>
      <th rowspan="2" class="infoCol7">Other<br>
        Manager</br></th>
      <th colspan="3" class="infoCol8">Voting Authority</th>
    </tr> 
	<tr>
      <th class="infoCol8a">Sole</th>
      <th class="infoCol8b">Shared</th>
      <th class="infoCol8c"> None</th>
    </tr>
    <xsl:for-each select="informationTable/infoTable">
    <tr>
        <td valign="top" class="infoCol1"><xsl:value-of select="nameOfIssuer"/></td>
        <td valign="top" class="infoCol2"><xsl:value-of select="titleOfClass"/></td>
		<td valign="top" class="infoCol3"><xsl:value-of select="cusip"/></td>
		<td valign="top" class="infoCol4"><xsl:value-of select="value"/></td>	
        <td valign="top" class="infoCol5a"><xsl:value-of select="shrsOrPrnAmt"/></td>
		<td valign="top" class="infoCol5b"><xsl:value-of select="shrsOrPrnAmt/@n1:shrsPrnType"/></td>
        <td valign="top" class="infoCol5c"><xsl:value-of select="putCall"/></td>
		<td valign="top" class="infoCol6"><xsl:value-of select="investmentDiscretion"/></td>
        <td valign="top" class="infoCol7"><xsl:value-of select="otherManager"/></td>
		<td valign="top" class="infoCol8a"><xsl:value-of select="votingAuthority/Sole"/></td>
        <td valign="top" class="infoCol8b"><xsl:value-of select="votingAuthority/Shared"/></td>
        <td valign="top" class="infoCol8c"><xsl:value-of select="votingAuthority/None"/></td>
	</tr>
    </xsl:for-each>
    </table>
	<p>[Repeat as Necessary]</p>
  </div> 	
  </body>
</html>
</xsl:template>
</xsl:stylesheet>

