<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:altova="http://www.altova.com" xmlns:altovaext="http://www.altova.com/xslt-extensions" xmlns:clitype="clitype" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:ix="http://www.xbrl.org/2008/inlineXBRL" xmlns:java="java" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:n1="http://www.sec.gov/edgar/thirteenffiler" xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:sps="http://www.altova.com/StyleVision/user-xpath-functions" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="altova altovaext clitype fn iso4217 ix java link n1 ns1 ns2 sps xbrldi xbrli xlink xs xsi">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:param name="USER"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="altova:nPxPerIn" select="96"/>
	<xsl:template match="/">
		<xsl:variable name="USER" select="document($USER)"/>
		<html>
			<head>
				<title/>
				<meta name="generator" content="Altova StyleVision Enterprise Edition 2012 rel. 2 sp1 (x64) (http://www.altova.com)"/>
				<meta http-equiv="X-UA-Compatible" content="IE=7"/>
				<style type="text/css">
					<xsl:comment>@import  url("css/13F_print.css");</xsl:comment>
				</style>
				<xsl:comment>[if IE]&gt;&lt;STYLE type=&quot;text/css&quot;&gt;.altova-rotate-left-textbox{filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3)} .altova-rotate-right-textbox{filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=1)} &lt;/STYLE&gt;&lt;![endif]</xsl:comment>
				<xsl:comment>[if !IE]&gt;&lt;!</xsl:comment>
				<style type="text/css">.altova-rotate-left-textbox{-webkit-transform: rotate(-90deg) translate(-100%, 0%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(-90deg) translate(-100%, 0%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(-90deg) translate(-100%, 0%); -ms-transform-origin: 0% 0%;}.altova-rotate-right-textbox{-webkit-transform: rotate(90deg) translate(0%, -100%); -webkit-transform-origin: 0% 0%;-moz-transform: rotate(90deg) translate(0%, -100%); -moz-transform-origin: 0% 0%;-ms-transform: rotate(90deg) translate(0%, -100%); -ms-transform-origin: 0% 0%;}</style>
				<xsl:comment>&lt;![endif]</xsl:comment>
				<style type="text/css">@page { margin-left:0.60in; margin-right:0.60in; margin-top:0.79in; margin-bottom:0.79in } @media print { br.altova-page-break { page-break-before: always; } }</style>
			</head>
			<body>
				<xsl:for-each select="$USER">
					<div class="content">
						<h2>
							<span>
								<xsl:text>Form 13F Filer Information</xsl:text>
							</span>
						</h2>
						<div class="form1">
							<table class="formTable">
								<xsl:variable name="altova:CurrContextGrid_0" select="."/>
								<tbody>
									<tr valign="middle">
										<td nowrap="0" valign="middle">
											<div class="fakeBox smallField">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:filer">
																	<xsl:for-each select="ns1:filerId">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
											<span>
												<xsl:text>Filer CIK </xsl:text>
											</span>
										</td>
										<td nowrap="0" valign="middle">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:filer">
																	<xsl:for-each select="ns1:filerCcc">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
											<span>
												<xsl:text>Filer CCC </xsl:text>
											</span>
										</td>
										<td id="fileNumberField" nowrap="0" valign="middle">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:filer">
																	<xsl:for-each select="ns1:filerFileNumber">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
											<span>
												<xsl:text>File Number </xsl:text>
											</span>
										</td>
										<td nowrap="0" valign="middle">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:periodOfReport">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
											<span>
												<xsl:text>Period </xsl:text>
											</span>
										</td>
									</tr>
								</tbody>
							</table>
							<table class="formTable">
								<xsl:variable name="altova:CurrContextGrid_1" select="."/>
								<tbody>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Is this a LIVE or TEST Filing? </xsl:text>
											</span>
										</td>
										<td class="yesNo" nowrap="0">
											<xsl:choose>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:liveTestFlag=&quot;LIVE&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\radio-checked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\radio-checked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:liveTestFlag=&quot;TEST&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\radio-unchecked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\radio-unchecked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
											</xsl:choose>
											<span>
												<xsl:text> LIVE </xsl:text>
											</span>
											<xsl:choose>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:liveTestFlag=&quot;TEST&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\radio-checked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\radio-checked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:liveTestFlag=&quot;LIVE&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\radio-unchecked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\radio-unchecked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
											</xsl:choose>
											<span>
												<xsl:text> TEST</xsl:text>
											</span>
										</td>
									</tr>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Would you like a return copy? </xsl:text>
											</span>
										</td>
										<td class="yesNo" nowrap="0">
											<xsl:choose>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:flags/n1:confirmingCopyFlag=&quot;true&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:flags/n1:confirmingCopyFlag=&quot;false&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
											</xsl:choose>
											<span>
												<xsl:text> YES</xsl:text>
											</span>
										</td>
									</tr>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Is this an electronic copy of an official filing submitted in paper format? </xsl:text>
											</span>
										</td>
										<td class="yesNo" nowrap="0">
											<xsl:choose>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:flags/n1:overrideInternetFlag=&quot;true&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:flags/n1:overrideInternetFlag=&quot;false&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
											</xsl:choose>
											<span>
												<xsl:text> YES</xsl:text>
											</span>
										</td>
									</tr>
								</tbody>
							</table>
							<h3>
								<span>
									<xsl:text>Submission Contact Information</xsl:text>
								</span>
							</h3>
							<table border="0" class="formTable">
								<xsl:variable name="altova:CurrContextGrid_2" select="."/>
								<tbody>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Name </xsl:text>
											</span>
										</td>
										<td nowrap="0">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:contact">
																	<xsl:for-each select="n1:contactName">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
										</td>
									</tr>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Phone</xsl:text>
											</span>
										</td>
										<td nowrap="0">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:contact">
																	<xsl:for-each select="n1:contactPhoneNumber">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
										</td>
									</tr>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Email Address </xsl:text>
											</span>
										</td>
										<td nowrap="0">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:headerData">
															<xsl:for-each select="n1:filerInfo">
																<xsl:for-each select="n1:contact">
																	<xsl:for-each select="n1:contactEmailAddress">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
										</td>
									</tr>
								</tbody>
							</table>
							<h3>
								<span>
									<xsl:text>Notification Information</xsl:text>
								</span>
							</h3>
							<table class="formTable">
								<xsl:variable name="altova:CurrContextGrid_3" select="."/>
								<tbody>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Notify via Filing website only? </xsl:text>
											</span>
										</td>
										<td class="yesNo" nowrap="0">
											<xsl:choose>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:flags/n1:overrideInternetFlag=&quot;true&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
												<xsl:when test="$XML/n1:edgarSubmission/n1:headerData/n1:filerInfo/n1:flags/n1:overrideInternetFlag=&quot;false&quot;">
													<img>
														<xsl:attribute name="src">
															<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
																<xsl:text>file:///</xsl:text>
															</xsl:if>
															<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
														</xsl:attribute>
														<xsl:attribute name="alt"/>
													</img>
												</xsl:when>
											</xsl:choose>
											<span>
												<xsl:text> YES</xsl:text>
											</span>
										</td>
									</tr>
								</tbody>
							</table>
							<p>
								<span>
									<xsl:text>Notification will automatically be sent to the Login CIK, Submission Contact, and Primary Issuers. Specify additional addresses below.</xsl:text>
								</span>
							</p>
							<h3>
								<span>
									<xsl:text>Notification Email Addresses </xsl:text>
								</span>
							</h3>
							<div>
								<table border="1">
									<xsl:variable name="altova:CurrContextGrid_4" select="."/>
									<tbody>
										<xsl:for-each select="$XML">
											<xsl:for-each select="n1:edgarSubmission">
												<xsl:for-each select="n1:headerData">
													<xsl:for-each select="n1:filerInfo">
														<xsl:for-each select="n1:notifications">
															<xsl:for-each select="n1:notificationEmailAddress">
																<tr>
																	<td>
																		<div class="fakeBox">
																			<span>
																				<xsl:text>&#160;</xsl:text>
																			</span>
																			<xsl:apply-templates/>
																		</div>
																	</td>
																</tr>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="content pageBreak">
						<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:amendmentInfo/n1:reasonForNonConfidentiality=&quot;Denied&quot;">
							<div>
								<span>
									<xsl:text>THIS FILING LISTS SECURITIES HOLDINGS REPORTED ON THE FORM 13F FILED ON </xsl:text>
								</span>
								<xsl:for-each select="$XML">
									<xsl:for-each select="n1:edgarSubmission">
										<xsl:for-each select="n1:formData">
											<xsl:for-each select="n1:coverPage">
												<xsl:for-each select="n1:amendmentInfo">
													<xsl:for-each select="n1:dateReported">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
								<span>
									<xsl:text> PURSUANT TO A REQUEST FOR CONFIDENTIAL TREATMENT AND FOR WHICH THAT REQUEST WAS DENIED ON&#160; </xsl:text>
								</span>
								<xsl:for-each select="$XML">
									<xsl:for-each select="n1:edgarSubmission">
										<xsl:for-each select="n1:formData">
											<xsl:for-each select="n1:coverPage">
												<xsl:for-each select="n1:amendmentInfo">
													<xsl:for-each select="n1:dateDeniedExpired">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<span>
										<xsl:text>.</xsl:text>
									</span>
								</xsl:for-each>
							</div>
						</xsl:if>
						<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:amendmentInfo/n1:reasonForNonConfidentiality=&quot;Confidential Treatment Expired&quot;">
							<div>
								<span>
									<xsl:text>THIS FILING LISTS SECURITIES HOLDINGS REPORTED ON THE FORM 13F FILED ON </xsl:text>
								</span>
								<xsl:for-each select="$XML">
									<xsl:for-each select="n1:edgarSubmission">
										<xsl:for-each select="n1:formData">
											<xsl:for-each select="n1:coverPage">
												<xsl:for-each select="n1:amendmentInfo">
													<xsl:for-each select="n1:dateReported">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</xsl:for-each>
								<span>
									<xsl:text>PURSUANT TO A REQUEST FOR CONFIDENTIAL TREATMENT AND FOR WHICH CONFIDENTIAL TREATMENT EXPIRED ON </xsl:text>
								</span>
								<xsl:for-each select="$XML">
									<xsl:for-each select="n1:edgarSubmission">
										<xsl:for-each select="n1:formData">
											<xsl:for-each select="n1:coverPage">
												<xsl:for-each select="n1:amendmentInfo">
													<xsl:for-each select="n1:dateDeniedExpired">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</xsl:for-each>
							</div>
						</xsl:if>
						<h1 class="smaller">
							<span>
								<xsl:text>United States</xsl:text>
							</span>
							<br/>
							<span>
								<xsl:text>Securities and Exchange Commission</xsl:text>
							</span>
							<br/>
							<span class="titleCase">
								<xsl:text>Washington, D.C. 20549</xsl:text>
							</span>
						</h1>
						<h1>
							<span>
								<xsl:text>Form 13F</xsl:text>
							</span>
						</h1>
						<h2>
							<span>
								<xsl:text>Form 13F Cover Page</xsl:text>
							</span>
						</h2>
						<table border="0" class="spanTable">
							<xsl:variable name="altova:CurrContextGrid_5" select="."/>
							<tbody>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Report for the Calendar Year or Quarter Ended: </xsl:text>
										</span>
									</td>
									<td nowrap="0">
										<div class="fakeBoxInline">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:reportCalendarOrQuarter">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
							</tbody>
						</table>
						<table border="0" class="spanTable">
							<xsl:variable name="altova:CurrContextGrid_6" select="."/>
							<tbody>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Check here if Amendment: </xsl:text>
										</span>
										<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:isAmendment=&quot;true&quot;">
											<img>
												<xsl:attribute name="src">
													<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
														<xsl:text>file:///</xsl:text>
													</xsl:if>
													<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
												</xsl:attribute>
												<xsl:attribute name="alt"/>
											</img>
										</xsl:if>
										<span>
											<xsl:text> Amendment Number: </xsl:text>
										</span>
									</td>
									<td nowrap="0">
										<div class="fakeBoxInline">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:amendmentNo">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
							</tbody>
						</table>
						<br/>
						<div style="padding-left:20px; " id="isAmendment">
							<table border="0">
								<xsl:variable name="altova:CurrContextGrid_7" select="."/>
								<tbody>
									<tr>
										<td align="left" nowrap="0" scope="col" valign="top">
											<span>
												<xsl:text>This Amendment (Check only one.):</xsl:text>
											</span>
										</td>
										<td align="left" nowrap="0" scope="col" valign="top">
											<p>
												<xsl:choose>
													<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:amendmentInfo/n1:amendmentType=&quot;RESTATEMENT&quot;">
														<img>
															<xsl:attribute name="src">
																<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
																	<xsl:text>file:///</xsl:text>
																</xsl:if>
																<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
															</xsl:attribute>
															<xsl:attribute name="alt"/>
														</img>
													</xsl:when>
													<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:amendmentInfo/n1:amendmentType=&quot;NEW HOLDINGS&quot;">
														<img>
															<xsl:attribute name="src">
																<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
																	<xsl:text>file:///</xsl:text>
																</xsl:if>
																<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
															</xsl:attribute>
															<xsl:attribute name="alt"/>
														</img>
													</xsl:when>
												</xsl:choose>
												<span>
													<xsl:text> is a restatement. </xsl:text>
												</span>
												<br/>
												<xsl:choose>
													<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:amendmentInfo/n1:amendmentType=&quot;NEW HOLDINGS&quot;">
														<img>
															<xsl:attribute name="src">
																<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
																	<xsl:text>file:///</xsl:text>
																</xsl:if>
																<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
															</xsl:attribute>
															<xsl:attribute name="alt"/>
														</img>
													</xsl:when>
													<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:amendmentInfo/n1:amendmentType=&quot;RESTATEMENT&quot;">
														<img>
															<xsl:attribute name="src">
																<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
																	<xsl:text>file:///</xsl:text>
																</xsl:if>
																<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
															</xsl:attribute>
															<xsl:attribute name="alt"/>
														</img>
													</xsl:when>
												</xsl:choose>
												<span>
													<xsl:text> adds new holdings entries.</xsl:text>
												</span>
											</p>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
						<h3>
							<span>
								<xsl:text>Institutional Investment Manager Filing this Report:</xsl:text>
							</span>
						</h3>
						<table border="0" class="formTable">
							<xsl:variable name="altova:CurrContextGrid_8" select="."/>
							<tbody>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Name:</xsl:text>
										</span>
									</td>
									<td colspan="3" nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:name">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
								<tr valign="bottom">
									<td rowspan="3" nowrap="0">
										<span>
											<xsl:text>Address:</xsl:text>
										</span>
									</td>
									<td colspan="3" nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:address">
																	<xsl:for-each select="ns1:street1">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
								<tr valign="bottom">
									<td colspan="3" nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:address">
																	<xsl:for-each select="ns1:street2">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
								<tr valign="bottom">
									<td nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:address">
																	<xsl:for-each select="ns1:city">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
									<td nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:address">
																	<xsl:for-each select="ns1:stateOrCountry">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
									<td nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:address">
																	<xsl:for-each select="ns1:zipCode">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
							</tbody>
						</table>
						<p>
							<table border="0" class="spanTable">
								<xsl:variable name="altova:CurrContextGrid_9" select="."/>
								<tbody>
									<tr>
										<td nowrap="0">
											<span>
												<xsl:text>Form 13F File Number: </xsl:text>
											</span>
										</td>
										<td nowrap="0">
											<div class="fakeBoxInline">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:formData">
															<xsl:for-each select="n1:coverPage">
																<xsl:for-each select="n1:otherManagersInfo">
																	<xsl:for-each select="n1:otherManager">
																		<xsl:for-each select="n1:form13FFileNumber">
																			<xsl:apply-templates/>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
										</td>
									</tr>
								</tbody>
							</table>
						</p>
						<p class="warning">
							<span>
								<xsl:text>The institutional investment manager filing this report and the person by whom it is signed hereby represent that the person signing the report is authorized to submit it, that all information contained herein is true, correct and complete, and that it is understood that all required items, statements, schedules, lists, and tables, are considered integral parts of this form.</xsl:text>
							</span>
						</p>
						<h3>
							<span>
								<xsl:text>Person Signing this Report on Behalf of Reporting Manager:</xsl:text>
							</span>
						</h3>
						<table border="0" class="formTable">
							<xsl:variable name="altova:CurrContextGrid_10" select="."/>
							<tbody>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Name:</xsl:text>
										</span>
									</td>
									<td nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:signatureBlock">
															<xsl:for-each select="n1:signature">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Title:</xsl:text>
										</span>
									</td>
									<td nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:signatureBlock">
															<xsl:for-each select="n1:title">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Phone: </xsl:text>
										</span>
									</td>
									<td nowrap="0">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:signatureBlock">
															<xsl:for-each select="n1:phone">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
									</td>
								</tr>
							</tbody>
						</table>
						<h3>
							<span>
								<xsl:text>Signature, Place, and Date of Signing:</xsl:text>
							</span>
						</h3>
						<table border="0" class="formTable">
							<xsl:variable name="altova:CurrContextGrid_11" select="."/>
							<tbody>
								<tr>
									<td nowrap="0" valign="top">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:signatureBlock">
															<xsl:for-each select="n1:signature">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
										<span>
											<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; [Signature]</xsl:text>
										</span>
									</td>
									<td class="formtable" nowrap="0" valign="bottom">
										<div class="fakeBox">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:signatureBlock">
															<xsl:for-each select="n1:city">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
											<span>
												<xsl:text>,</xsl:text>
											</span>
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:coverPage">
															<xsl:for-each select="n1:filingManager">
																<xsl:for-each select="n1:address">
																	<xsl:for-each select="ns1:stateOrCountry">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
										<span>
											<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; [City, State]</xsl:text>
										</span>
									</td>
									<td nowrap="0" valign="top">
										<div class="fakeBox dateField">
											<xsl:for-each select="$XML">
												<xsl:for-each select="n1:edgarSubmission">
													<xsl:for-each select="n1:formData">
														<xsl:for-each select="n1:signatureBlock">
															<xsl:for-each select="n1:signatureDate">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:for-each>
										</div>
										<span>
											<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; [Date]</xsl:text>
										</span>
									</td>
								</tr>
							</tbody>
						</table>
						<h3>
							<span>
								<xsl:text>Report Type </xsl:text>
							</span>
							<span class="minutia">
								<xsl:text>(Check only one.)</xsl:text>
							</span>
							<span>
								<xsl:text>:</xsl:text>
							</span>
						</h3>
						<p>
							<xsl:choose>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F HOLDINGS REPORT&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F NOTICE&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F COMBINATION REPORT&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
							</xsl:choose>
							<span>
								<xsl:text> 13F HOLDINGS REPORT. </xsl:text>
							</span>
							<span class="minutia">
								<xsl:text>(Check here if all holdings of this reporting manager are reported in this report.)</xsl:text>
							</span>
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</p>
						<p>
							<xsl:choose>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F NOTICE&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F COMBINATION REPORT&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F HOLDINGS REPORT&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
							</xsl:choose>
							<span>
								<xsl:text> 13F NOTICE. </xsl:text>
							</span>
							<span class="minutia">
								<xsl:text>(Check here if no holdings reported are in this report, and all holdings are reported by other reporting manager(s).)</xsl:text>
							</span>
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</p>
						<p>
							<xsl:choose>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F COMBINATION REPORT&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F NOTICE&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
								<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:reportType=&quot;13F HOLDINGS REPORT&quot;">
									<img>
										<xsl:attribute name="src">
											<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
												<xsl:text>file:///</xsl:text>
											</xsl:if>
											<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
										</xsl:attribute>
										<xsl:attribute name="alt"/>
									</img>
								</xsl:when>
							</xsl:choose>
							<span>
								<xsl:text> 13F COMBINATION REPORT. </xsl:text>
							</span>
							<span class="minutia">
								<xsl:text>(Check here if a portion of the holdings for this reporting manager are reported in this report and a portion are reported by other reporting manager(s).)</xsl:text>
							</span>
						</p>
						<div class="newRecord" id="newName">
							<h3>
								<span>
									<xsl:text>List of Other Managers Reporting for this Manager</xsl:text>
								</span>
							</h3>
							<p class="minutia">
								<span>
									<xsl:text>[If there are no entries in this list, omit this section.]</xsl:text>
								</span>
							</p>
							<table class="spanTable">
								<xsl:variable name="altova:CurrContextGrid_12" select="."/>
								<tbody>
									<tr>
										<td colspan="2" nowrap="0">
											<span>
												<xsl:text>&#160;&#160; Form 13F File Number&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Name</xsl:text>
											</span>
										</td>
										<td nowrap="0"/>
									</tr>
									<tr id="otherManager1">
										<td nowrap="0" valign="top">
											<div>
												<table border="1">
													<xsl:variable name="altova:CurrContextGrid_13" select="."/>
													<tbody>
														<xsl:for-each select="$XML">
															<xsl:for-each select="n1:edgarSubmission">
																<xsl:for-each select="n1:formData">
																	<xsl:for-each select="n1:coverPage">
																		<xsl:for-each select="n1:otherManagersInfo">
																			<xsl:for-each select="n1:otherManager">
																				<xsl:for-each select="n1:form13FFileNumber">
																					<tr>
																						<td>
																							<div class="fakeBoxInline">
																								<xsl:apply-templates/>
																							</div>
																						</td>
																					</tr>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</tbody>
												</table>
											</div>
										</td>
										<td nowrap="0" valign="top">
											<div>
												<table border="1">
													<xsl:variable name="altova:CurrContextGrid_14" select="."/>
													<tbody>
														<xsl:for-each select="$XML">
															<xsl:for-each select="n1:edgarSubmission">
																<xsl:for-each select="n1:formData">
																	<xsl:for-each select="n1:coverPage">
																		<xsl:for-each select="n1:otherManagersInfo">
																			<xsl:for-each select="n1:otherManager">
																				<xsl:for-each select="n1:name">
																					<tr>
																						<td>
																							<div class="fakeBox">
																								<xsl:apply-templates/>
																							</div>
																						</td>
																					</tr>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</tbody>
												</table>
											</div>
										</td>
										<td nowrap="0" valign="top"/>
									</tr>
									<tr id="otherManager2">
										<td nowrap="0" valign="top"/>
										<td nowrap="0" valign="top"/>
										<td nowrap="0" valign="top"/>
									</tr>
								</tbody>
							</table>
							<p class="minutia">
								<span>
									<xsl:text>[Repeat as necessary.]</xsl:text>
								</span>
							</p>
						</div>
						<table class="formTable">
							<xsl:variable name="altova:CurrContextGrid_15" select="."/>
							<tbody>
								<tr>
									<td nowrap="0">
										<span>
											<xsl:text>Do you wish to provide information pursuant to Special Instruction 5? </xsl:text>
										</span>
									</td>
									<td class="yesNo" nowrap="0">
										<span>
											<xsl:text>&#160; </xsl:text>
										</span>
										<xsl:choose>
											<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:provideInfoForInstruction5=&quot;Y&quot;">
												<img>
													<xsl:attribute name="src">
														<xsl:if test="substring(string(&apos;Images\radio-checked.jpg&apos;), 2, 1) = ':'">
															<xsl:text>file:///</xsl:text>
														</xsl:if>
														<xsl:value-of select="translate(string(&apos;Images\radio-checked.jpg&apos;), '&#x5c;', '/')"/>
													</xsl:attribute>
													<xsl:attribute name="alt"/>
												</img>
											</xsl:when>
											<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:provideInfoForInstruction5=&quot;N&quot;">
												<img>
													<xsl:attribute name="src">
														<xsl:if test="substring(string(&apos;Images\radio-unchecked.jpg&apos;), 2, 1) = ':'">
															<xsl:text>file:///</xsl:text>
														</xsl:if>
														<xsl:value-of select="translate(string(&apos;Images\radio-unchecked.jpg&apos;), '&#x5c;', '/')"/>
													</xsl:attribute>
													<xsl:attribute name="alt"/>
												</img>
											</xsl:when>
										</xsl:choose>
										<span>
											<xsl:text> Yes </xsl:text>
										</span>
										<xsl:choose>
											<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:provideInfoForInstruction5=&quot;N&quot;">
												<img>
													<xsl:attribute name="src">
														<xsl:if test="substring(string(&apos;Images\radio-checked.jpg&apos;), 2, 1) = ':'">
															<xsl:text>file:///</xsl:text>
														</xsl:if>
														<xsl:value-of select="translate(string(&apos;Images\radio-checked.jpg&apos;), '&#x5c;', '/')"/>
													</xsl:attribute>
													<xsl:attribute name="alt"/>
												</img>
											</xsl:when>
											<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:coverPage/n1:provideInfoForInstruction5=&quot;Y&quot;">
												<img>
													<xsl:attribute name="src">
														<xsl:if test="substring(string(&apos;Images\radio-checked.jpg&apos;), 2, 1) = ':'">
															<xsl:text>file:///</xsl:text>
														</xsl:if>
														<xsl:value-of select="translate(string(&apos;Images\radio-checked.jpg&apos;), '&#x5c;', '/')"/>
													</xsl:attribute>
													<xsl:attribute name="alt"/>
												</img>
											</xsl:when>
										</xsl:choose>
										<span>
											<xsl:text> No</xsl:text>
										</span>
									</td>
								</tr>
							</tbody>
						</table>
						<div id="si5textbox">
							<h3>
								<span>
									<xsl:text>Additional Information</xsl:text>
								</span>
							</h3>
							<div>
								<xsl:for-each select="$XML">
									<xsl:for-each select="n1:edgarSubmission">
										<xsl:for-each select="n1:formData">
											<xsl:for-each select="n1:coverPage">
												<xsl:for-each select="n1:additionalInformation">
													<textarea style="height:1.19in; width:5.78in; " cols="20" rows="2">
														<xsl:value-of select="string(.)"/>
													</textarea>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
							</div>
						</div>
					</div>
					<div class="content pageBreak">
						<h2>
							<span>
								<xsl:text>Form 13F Summary Page</xsl:text>
							</span>
						</h2>
						<div class="form1">
							<h3>
								<span>
									<xsl:text>Report Summary: </xsl:text>
								</span>
							</h3>
							<table border="0" class="formTable">
								<xsl:variable name="altova:CurrContextGrid_16" select="."/>
								<tbody>
									<tr>
										<td nowrap="0" valign="top">
											<span>
												<xsl:text>Number of Other Included Managers:</xsl:text>
											</span>
										</td>
										<td nowrap="0" valign="top">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:formData">
															<xsl:for-each select="n1:summaryPage">
																<xsl:for-each select="n1:otherIncludedManagersCount">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
										</td>
									</tr>
									<tr>
										<td nowrap="0" valign="top">
											<span>
												<xsl:text>Form 13F Information table Entry Total:</xsl:text>
											</span>
										</td>
										<td nowrap="0" valign="top">
											<div class="fakeBox">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:formData">
															<xsl:for-each select="n1:summaryPage">
																<xsl:for-each select="n1:tableEntryTotal">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
										</td>
									</tr>
									<tr>
										<td nowrap="0" valign="top">
											<span>
												<xsl:text>Form 13F Information table Value Total:</xsl:text>
											</span>
										</td>
										<td nowrap="0" valign="top">
											<div class="fakeBox moneyField">
												<xsl:for-each select="$XML">
													<xsl:for-each select="n1:edgarSubmission">
														<xsl:for-each select="n1:formData">
															<xsl:for-each select="n1:summaryPage">
																<xsl:for-each select="n1:tableValueTotal">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</xsl:for-each>
											</div>
											<span>
												<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
											</span>
											<span class="minutia">
												<xsl:text>(thousands)</xsl:text>
											</span>
										</td>
									</tr>
								</tbody>
							</table>
							<p>
								<xsl:choose>
									<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:isConfidentialOmitted=&quot;true&quot;">
										<img>
											<xsl:attribute name="src">
												<xsl:if test="substring(string(&apos;Images\box-checked.jpg&apos;), 2, 1) = ':'">
													<xsl:text>file:///</xsl:text>
												</xsl:if>
												<xsl:value-of select="translate(string(&apos;Images\box-checked.jpg&apos;), '&#x5c;', '/')"/>
											</xsl:attribute>
											<xsl:attribute name="alt"/>
										</img>
									</xsl:when>
									<xsl:when test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:isConfidentialOmitted=&quot;false&quot;">
										<img>
											<xsl:attribute name="src">
												<xsl:if test="substring(string(&apos;Images\box-unchecked.jpg&apos;), 2, 1) = ':'">
													<xsl:text>file:///</xsl:text>
												</xsl:if>
												<xsl:value-of select="translate(string(&apos;Images\box-unchecked.jpg&apos;), '&#x5c;', '/')"/>
											</xsl:attribute>
											<xsl:attribute name="alt"/>
										</img>
									</xsl:when>
								</xsl:choose>
								<span>
									<xsl:text> Confidential information has been omitted from the public Form 13F report and filed separately with the Commission.</xsl:text>
								</span>
							</p>
							<div class="newRecord  " id="otherManagers">
								<h3>
									<span>
										<xsl:text>List of Other Included Managers:</xsl:text>
									</span>
								</h3>
								<p>
									<span>
										<xsl:text>Provide a numbered list of the name(s) and Form 13F number(s) of all institutional investement managers with respect to which this report is filed, other than the manager filing this report. </xsl:text>
									</span>
								</p>
								<table class="formTable">
									<xsl:variable name="altova:CurrContextGrid_17" select="."/>
									<tbody>
										<tr>
											<td nowrap="0" valign="top">
												<span>
													<xsl:text>&#160;</xsl:text>
												</span>
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<span>
														<xsl:text>&#160; No.</xsl:text>
													</span>
												</xsl:if>
											</td>
											<td nowrap="0" valign="top">
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<span>
														<xsl:text>Form 13F File Number</xsl:text>
													</span>
												</xsl:if>
											</td>
											<td nowrap="0" valign="top">
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<span>
														<xsl:text>Name</xsl:text>
													</span>
												</xsl:if>
											</td>
										</tr>
										<tr>
											<td nowrap="0" valign="top">
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<div>
														<table border="1">
															<xsl:variable name="altova:CurrContextGrid_18" select="."/>
															<tbody>
																<xsl:for-each select="$XML">
																	<xsl:for-each select="n1:edgarSubmission">
																		<xsl:for-each select="n1:formData">
																			<xsl:for-each select="n1:summaryPage">
																				<xsl:for-each select="n1:otherManagers2Info">
																					<xsl:for-each select="n1:otherManager2">
																						<xsl:for-each select="n1:sequenceNumber">
																							<tr>
																								<td>
																									<div class="fakeBox">
																										<xsl:apply-templates/>
																									</div>
																								</td>
																							</tr>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</tbody>
														</table>
													</div>
												</xsl:if>
												<br/>
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<p class="minutia">
														<span>
															<xsl:text>[Repeat as necessary.]</xsl:text>
														</span>
													</p>
												</xsl:if>
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount=&quot;0&quot;">
													<span>
														<xsl:text>&#160;&#160; </xsl:text>
													</span>
													<div>
														<span>
															<xsl:text>NONE</xsl:text>
														</span>
													</div>
												</xsl:if>
												<br/>
											</td>
											<td nowrap="0" valign="top">
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<div>
														<table border="1">
															<xsl:variable name="altova:CurrContextGrid_19" select="."/>
															<tbody>
																<xsl:for-each select="$XML">
																	<xsl:for-each select="n1:edgarSubmission">
																		<xsl:for-each select="n1:formData">
																			<xsl:for-each select="n1:summaryPage">
																				<xsl:for-each select="n1:otherManagers2Info">
																					<xsl:for-each select="n1:otherManager2">
																						<xsl:for-each select="n1:otherManager">
																							<xsl:for-each select="n1:form13FFileNumber">
																								<tr>
																									<td>
																										<div class="fakeBox">
																											<xsl:apply-templates/>
																										</div>
																									</td>
																								</tr>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</tbody>
														</table>
													</div>
												</xsl:if>
												<br/>
												<br/>
												<br/>
												<br/>
											</td>
											<td nowrap="0" valign="top">
												<xsl:if test="$XML/n1:edgarSubmission/n1:formData/n1:summaryPage/n1:otherIncludedManagersCount!=&quot;0&quot;">
													<div>
														<table border="1">
															<xsl:variable name="altova:CurrContextGrid_20" select="."/>
															<tbody>
																<xsl:for-each select="$XML">
																	<xsl:for-each select="n1:edgarSubmission">
																		<xsl:for-each select="n1:formData">
																			<xsl:for-each select="n1:summaryPage">
																				<xsl:for-each select="n1:otherManagers2Info">
																					<xsl:for-each select="n1:otherManager2">
																						<xsl:for-each select="n1:otherManager">
																							<xsl:for-each select="n1:name">
																								<tr>
																									<td>
																										<div class="fakeBox">
																											<xsl:apply-templates/>
																										</div>
																									</td>
																								</tr>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</tbody>
														</table>
													</div>
												</xsl:if>
											</td>
										</tr>
										<tr>
											<td nowrap="0" valign="top"/>
											<td nowrap="0" valign="top"/>
											<td nowrap="0" valign="top"/>
										</tr>
										<tr>
											<td nowrap="0" valign="top"/>
											<td nowrap="0" valign="top"/>
											<td nowrap="0" valign="top"/>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
					</div>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
