<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenafiler" 
	xmlns:p1="http://www.sec.gov/edgar/common">
	
	<xsl:template name="Item4">
		<h3><em>Oath or Affirmation</em></h3>
		I<b>, <em><xsl:value-of select="p:oathSignature/p:signPersonName"/>,</em></b>
		swear (or affirm) that, to the best of my knowledge and belief, the financial report pertaining to the firm of
		<b><em><xsl:value-of select="p:oathSignature/p:entityName"/>,</em></b>
		as of
		<b><em><xsl:value-of select="p:oathSignature/p:signDate"/>,</em></b>
		is true and correct. I further swear (or affirm) that neither the company nor any partner, proprietor, principal officer or director has any proprietary interest in any account classified solely as that of a customer, except as follows:
		<xsl:if test="count(p:oathSignature/p:explanation) &gt; 0">
			<br/>
			<br/>
			<div class="fakeTextBox">
				<xsl:value-of select="p:oathSignature/p:explanation"/>
			</div>						
			<br/>
		</xsl:if>
		
		<table role="presentation"  class="signature" id="oathOrAffirmation">
			<tr>
				<td class="label">Signature</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:oathSignature/p:signature" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">Title</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:oathSignature/p:oathTitle" />
					</div>
				</td>
			</tr>
		</table>
		
		<h3><em>Notary Public</em></h3>
		<table role="presentation"  class="signature" id="notaryPublic">
			<tr>
				<td class="label">
					Checking this box acknowledges that this oath
					or affirmation has been notarized.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(p:oathSignature/p:confirmNotarizedFlag) = 'Y'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	
</xsl:stylesheet>