<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenafiler" 
	xmlns:p1="http://www.sec.gov/edgar/common">
	
	<xsl:template name="Item3">
		<h3><em>Independent Public Accountant</em></h3>
		<table role="presentation"  class="filingInformation" id="accountantIdentification">
			<tr>
				<td class="label">
					Name - <i>if individual, state last, first, and middle name</i>
				</td>
				<td>
					<div class="fakeBox">
						
						<xsl:value-of select="p:accountantIdentification/p:accountantName" />
					</div>
				</td>
			</tr>
			<tr>
				<td	class="label"> Address 1</td>
				<td>
					<div class="fakeBox">
						
						<xsl:value-of select="p:accountantIdentification/p:accountantAddress/p1:street1" />
					</div>
				</td>
			</tr>
			<xsl:if test="count(p:accountantIdentification/p:accountantAddress/p1:street2) &gt; 0">
				<tr>
					<td	class="label"> Address 2</td>
					<td>
						<div class="fakeBox">
							
							<xsl:value-of select="p:accountantIdentification/p:accountantAddress/p1:street2" />
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td	class="label"> City</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:accountantIdentification/p:accountantAddress/p1:city" />
					</div>
				</td>
			</tr>	
			<tr>
				<td	class="label"> State/Country</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p:accountantIdentification/p:accountantAddress/p1:stateOrCountry" />
						</xsl:call-template>						
					</div>
				</td>
			</tr>
			<tr>
				<td	class="label"> Mailing Zip/ Postal Code</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:accountantIdentification/p:accountantAddress/p1:zipCode" />
					</div>
				</td>
			</tr>			
			<tr>
				<td class="label">Check One</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(p:accountantIdentification/p:accountantType) = 'Certified Public Accountant'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
						</xsl:otherwise>
					</xsl:choose>
					 Certified Public Accountant<br/>
					<xsl:choose>
						<xsl:when test="string(p:accountantIdentification/p:accountantType) 
						= 'Certified Public Accountant not resident in United States or any of its possessions'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>
					 Certified Public Accountant not resident in United States or any of its possessions				
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>