<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenafiler" 
	xmlns:p1="http://www.sec.gov/edgar/common">
	
	<xsl:template name="Item1">
		<table role="presentation" class="filingInformation" id="submissionInformation">
			<tr>
				<td class="label">Report for the Period Beginning</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:submissionInformation/p:periodBegin" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">and Ending</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:submissionInformation/p:periodEnd" />
					</div>				
				</td>
			</tr>
			<tr>
				<td class="label">Type of Registrant</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:submissionInformation/p:typeOfRegistrant = 'Broker-dealer'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>Broker-dealer
				</td>
			</tr>
			<xsl:if test="string(p:submissionInformation/p:typeOfRegistrant) = 'Broker-dealer'">
				<tr>
					<td class="label">
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string(p:submissionInformation/p:subTypeOfRegistrant) = 'OTC derivatives dealer'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>OTC derivatives dealer
					</td>
				</tr>
			</xsl:if>
		</table>
	
		<table role="presentation"  class="filingInformation" id="materialWeakness">
			<tr>
				<td><h4><em>Material Weakness</em></h4></td>
			</tr>		
			<tr>
				<td class="label">
					Does this submission include an accountant's report covering the
					compliance report that indentifies one or more material weaknesses?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="string(p:submissionInformation/p:materialWeakness) = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked" />
						</xsl:when>	
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose> Yes &#160;
					<xsl:choose>
						<xsl:when test="string(p:submissionInformation/p:materialWeakness) = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>	
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose> No		
				</td>
			</tr>
			<xsl:if test="$amendmentOrNot = 'X-17A-5/A'">
				<tr>
					<td class="label">
						Please describe what information is being amended with this filing.
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:submissionInformation/p:amendmentDescription"/>
						</div>
					</td>
				</tr>
			</xsl:if>
		</table>	
	</xsl:template>
</xsl:stylesheet>