﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenafiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:import href="util.xsl" />

	<xsl:output 
		method="html" 
		indent="no" 
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
				<style type="text/css">
					.fakeTextBox {
						border-top: 2px solid #999;
						border-right: 1px solid #ccc;
						border-bottom: 1px solid #ccc;
						border-left: 2px solid #999;
						padding: 2px;
						_width: 800px;
						height: auto;
						min-width: 200px;
						min-height: 50px;
						word-wrap: break-word;
						font-size: 0.9em;
						color: blue;
					}
				</style>				
			</head>

			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>

	<!-- Header Template START -->
	<xsl:template name="header" match="p:edgarSubmission/p:headerData">
		<div class="contentwrapper">
			<table id="header">
				<tr>
					<td class="title">Form X-17A-5 Filer Information</td>
					<td rowspan="2" class="center">
						UNITED STATES
						<br />
						SECURITIES AND EXCHANGE COMMISSION
						<br />
						Washington, D.C. 20549
						<br />
						<br />
						ANNUAL AUDITED REPORT
						<br/>
						Form X-17A-5
						<br />
						Part III
						<br/><br/>
						FACING PAGE
						<br/>
						<div style="font-size:.9em;" >
							Information Required of Brokers and Dealers Pursuant to Section 17 of the
							<br/>
							Securities Exchange Act of 1934 and Rule 17a-5 Thereunder
						</div>
					</td>
					<td class="title">OMB APPROVAL</td>
				</tr>	
				<tr>
					<td class="side" style="text-align: center;vertical-align:middle">
						<p>
							FORM <xsl:value-of select="p:submissionType" />
						</p>
					</td>
					<td width="25%" class="side">
						<p style="vertical-align:middle;">OMB Number:&#160;&#160;3235-0123</p>
						<hr></hr>
						<p style="vertical-align:middle;">Estimated average burden hours per response:&#160;12.00</p>
					</td>
				</tr>
			</table>
		</div>
	
		<div id="info">
			<div class="contentwrapper">
				<div class="content">
					<h1><xsl:value-of select="p:submissionType" />: Filer Information</h1>
					<table class="filerInformation">		
						<tr>
							<td class="label">Filer CIK</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="string(p:filerInfo/p:filer/p:filerCredentials/p:filerCik)" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Filer CCC</td>
							<td>
								<div class="fakeBox">				
									<xsl:value-of select="string(p:filerInfo/p:filer/p:filerCredentials/p:filerCcc)" />
								</div>
							</td>
						</tr>				
						<tr>
							<td class="label">
								Is this a LIVE or TEST Filing?
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="count(p:filerInfo/p:liveTestFlag) &gt; 0">
										<xsl:choose>
											<xsl:when test="string(p:filerInfo/p:liveTestFlag) = 'LIVE'">
												<img src="Images/radio-checked.jpg"   alt="checked"   /> LIVE
												<img src="Images/radio-unchecked.jpg" alt="unchecked" /> TEST
											</xsl:when>
										</xsl:choose>
										<xsl:choose>
											<xsl:when test="string(p:filerInfo/p:liveTestFlag) = 'TEST'">
												<img src="Images/radio-unchecked.jpg" alt="unchecked" /> LIVE
												<img src="Images/radio-checked.jpg"   alt="checked"   /> TEST
											</xsl:when>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="unchecked" /> LIVE
										<img src="Images/radio-unchecked.jpg" alt="unchecked" /> TEST
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:if test="count(p:filerInfo/p:flags/p:returnCopyFlag) &gt; 0">
							<tr>
								<td class="label">Would you like a Return Copy?</td>
								<td>
									<xsl:choose>
										<xsl:when test="string(p:filerInfo/p:flags/p:returnCopyFlag) = 'true'">
											<img src="Images/box-checked.jpg" alt="checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="unchecked" />
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="count(p:filerInfo/p:flags/p:confirmingCopyFlag) &gt; 0">
							<tr>
								<td class="label">
									Is this an electronic copy of an official filing submitted in paper format?
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="string(p:filerInfo/p:flags/p:confirmingCopyFlag) = 'true'">
											<img src="Images/box-checked.jpg" alt="checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="unchecked" />
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>				
						<tr>
							<td class="label">Confirming Copy File Number</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:filerInfo/p:filer/p:confirmingCopyNumber"/>
								</div>								
							</td>
						</tr>
						<tr>
							<td><h4><em>Submission Contact Information</em></h4></td>
						</tr>
						<tr>
							<td class="label">Name</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="string(p:filerInfo/p:contact/p:contactName)" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Phone</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="string(p:filerInfo/p:contact/p:contactPhone)" />
								</div>
							</td>
						</tr>

						<tr>
							<td class="label">E-Mail Address</td>
							<td>			
								<div class="fakeBox">
									<xsl:value-of select="p:filerInfo/p:contact/p:contactEmail" />
								</div>
							</td>
						</tr>
					
						<xsl:if test="count(p:filerInfo/p:notifications) &gt; 0">
							<tr>
								<td><h4><em>Notification Information</em></h4></td>
							</tr>
						</xsl:if>
						
						<xsl:if test="count(p:filerInfo/p:flags/p:overrideInternetFlag) &gt; 0">					
							<tr>
								<td class="label">Notify via Filing Website only?</td>
								<td>
									<xsl:choose>
										<xsl:when test="string(p:filerInfo/p:flags/p:overrideInternetFlag) = 'true'">
											<img src="Images/box-checked.jpg" alt="checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="unchecked" />
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</xsl:if>
						
						<xsl:for-each select="p:filerInfo/p:notifications/p:notificationEmail">
							<tr>
								<td class="label">Notification E-mail Address</td>
								<td>
									<div class="fakeBox">
										<xsl:value-of select="." />
									</div>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>

	<xsl:variable name="amendmentOrNot" select="p:edgarSubmission/p:headerData/p:submissionType" />
	
	<xsl:template name="formData" match="p:edgarSubmission/p:formData">
		<div class="content">
			<h1><xsl:value-of select="$amendmentOrNot"/>: Submission Information</h1>
			<div class="form1">
				<xsl:call-template name="Item1" />
			</div>

			<h1><xsl:value-of select="$amendmentOrNot"/>: A. Registrant Identification</h1>
			<div class="form1">
				<xsl:call-template name="Item2" />
			</div>

			<h1><xsl:value-of select="$amendmentOrNot"/>: B. Accountant Identification</h1>
			<div class="form1">
				<xsl:call-template name="Item3" />
			</div>
			
			<h1><xsl:value-of select="$amendmentOrNot"/>: Signature</h1>
			<div class="form1">
				<xsl:call-template name="Item4" />
			</div>			
		</div>		
		
	</xsl:template>
	
	<xsl:template name="documentsData" match="p:edgarSubmission/p:documents/p1:document">
		<div style="display:none;">	
			<xsl:call-template name="InvisibleDocumentsInfo"/>
		</div>
	</xsl:template>
	
	<xsl:include href="X-17A-5_item1.xsl"/>
	<xsl:include href="X-17A-5_item2.xsl"/>
	<xsl:include href="X-17A-5_item3.xsl"/>
	<xsl:include href="X-17A-5_item4.xsl"/>
	<xsl:include href="X-17A-5_documents.xsl"/>
	
	<xsl:include href="SDR_State_Codes.xsl" />
	
</xsl:stylesheet>