﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/nmfp1"
	xmlns:ns3="http://www.sec.gov/edgar/nmfp1common">

	<xsl:import href="util.xsl" />

	<xsl:output 
		method="html" 
		indent="no" 
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
			</head>

			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				<div style="display:none">
					schemaVersion: 
					<xsl:value-of select="string(m1:edgarSubmission/m1:schemaVersion)" />
				</div>
				
				<xsl:call-template name="header" />
				
				<xsl:apply-templates>
					<xsl:with-param name="submissionType"
						select="string(m1:edgarSubmission/m1:headerData/m1:submissionType)"/>
				</xsl:apply-templates>
			</body>
		</html>
	</xsl:template>

	<!-- Header Template START -->
	<xsl:template name="header">
		<div class="contentwrapper">
			<table id="header">
				<tr>
					<td rowspan="2" class="center">
						UNITED STATES
						<br />
						SECURITIES AND EXCHANGE COMMISSION
						<br />
						Washington, D.C. 20549
						<br />
						<br />
						FORM N-MFP
						<br />
						MONTHLY SCHEDULE OF PORTFOLIO HOLDINGS
						<br/>
						OF MONEY MARKET FUNDS
					</td>
				</tr>		
			</table>
		</div>
	</xsl:template>
	<!-- Header Template END -->

	<!-- N-MFP: Filer Information Template START -->
	<xsl:template name="headerData" match="m1:edgarSubmission/m1:headerData">
		<div id="info">
			<div class="contentwrapper">
				<div class="content">
					<h1>N-MFP: Filer Information</h1>
					<table>
						<tr>
							<td class="label">Submission Type</td>
							<td>
								<xsl:choose>
									<xsl:when test="string(m1:submissionType) = 'N-MFP1'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" /> N-MFP1
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> N-MFP1
									</xsl:otherwise>
								</xsl:choose> &#160;
								<xsl:choose>
									<xsl:when test="string(m1:submissionType) = 'N-MFP1/A'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" /> N-MFP1/A
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> N-MFP1/A
									</xsl:otherwise>
								</xsl:choose>							
							</td>
						</tr>					
						<tr>
							<td class="label">CIK</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="string(m1:filerInfo/m1:filer/m1:filerCredentials/m1:cik)" />
								</div>
							</td>
						</tr>
						
						<tr>
							<td class="label">CCC</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of
										select="string(m1:filerInfo/m1:filer/m1:filerCredentials/m1:ccc)" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">
								Test or Live
							</td>
							<td>
								<span class="yesNo">
									<xsl:choose>
										<xsl:when test="count(m1:filerInfo/m1:liveTestFlag) &gt; 0">
											<xsl:choose>
												<xsl:when test="string(m1:filerInfo/m1:liveTestFlag) = 'LIVE'">
													<img src="Images/radio-checked.jpg" alt="radio button checked" />LIVE &#160;
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />TEST
												</xsl:when>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="string(m1:filerInfo/m1:liveTestFlag) = 'TEST'">
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />LIVE &#160;
													<img src="Images/radio-checked.jpg" alt="radio button checked" />TEST
												</xsl:when>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />LIVE &#160;
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />TEST
										</xsl:otherwise>
									</xsl:choose>
								</span>
							</td>
						</tr>			
						<xsl:if test="count(m1:filerInfo/m1:contact/m1:contactName) &gt; 0">
							<tr >
								<td class="label">Contact Information - Name</td>
								<td>
									<div class="fakeBox3">
										<xsl:value-of select="string(m1:filerInfo/m1:contact/m1:contactName)" />
									</div>
								</td>
							</tr>
						</xsl:if>
						<xsl:if test="count(m1:filerInfo/m1:contact/m1:contactPhoneNumber) &gt; 0">
							<tr >
								<td class="label">Contact Information - Phone Number</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="string(m1:filerInfo/m1:contact/m1:contactPhoneNumber)" />
									</div>
								</td>
							</tr>
						</xsl:if>
						<xsl:for-each select="m1:filerInfo/m1:notifications">
							<tr>
								<td class="label">Notification Email Address</td>
								<td>
									<div class="fakeBox">
										<xsl:value-of select="m1:notificationEmailAddress" />
									</div>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td class="label">
								Is this an electronic copy of an official filing submitted in paper format?
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="string(m1:filerInfo/m1:confirmingCopyFlag) = 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text>&#160;</xsl:text>
								<xsl:choose>
									<xsl:when test="string(m1:filerInfo/m1:confirmingCopyFlag) = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
									</xsl:otherwise>
								</xsl:choose>								
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>
	
	<xsl:variable name="submissionType" select="m1:edgarSubmission/m1:headerData/m1:submissionType" />
	<xsl:variable name="masterFundFlagYesNo" select="m1:edgarSubmission/m1:formData/m1:seriesLevelInfo/m1:masterFundFlag" />
	
	<xsl:template name="formData" match="m1:edgarSubmission/m1:formData">
		<h1>N-MFP: Filing Information</h1>
		<xsl:call-template name="Item1"/>
	</xsl:template>

	<xsl:include href="N-MFP1_item1.xsl" />
	<xsl:include href="SDR_State_Codes.xsl" />
</xsl:stylesheet>