<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 7 templates -->
	
<xsl:template name="Item7" >
	<h3><em>Proprietary Interest in Municipal Advisory Client or Solicitee Transactions</em> </h3>
<h3>A. Does applicant or any <em>associated person</em>:</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) buy securities or other investment or derivative products for itself from <em>clients</em> or <em>solicitees</em> in the context of its <em>municipal advisory activities</em>, or sell securities it owns to such <em>clients</em> or <em>solicitees?</em></div>
   <div class="tdStyle1 tditem10col2">
    		<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactBuySellFromClients  = 'Y' or m1:participationInterestMACT/m1:mactBuySellFromClients   = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactBuySellFromClients   = 'N' or m1:participationInterestMACT/m1:mactBuySellFromClients   = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>        
           
   
    </div>
  <div style="clear:both"></div>
</div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) buy or sell for itself securities (other than shares of mutual funds) or other investment or derivative products that the applicant also recommends to such <em>clients</em> or <em>solicitees</em>? </div>
    <div class="tdStyle1 tditem10col2" >
        		<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactBuySellRecommendToClients  = 'Y' or m1:participationInterestMACT/m1:mactBuySellRecommendToClients   = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactBuySellRecommendToClients   = 'N' or m1:participationInterestMACT/m1:mactBuySellRecommendToClients   = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>       
	    
    </div>
  </div>
  <div style="clear:both"></div>
</div>

  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3) enter into derivatives contracts with such <em>clients</em> or <em>solicitees</em>?</div>
    <div class="tdStyle1 tditem10col2" >
            		<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactEnterDerivativesWithClients  = 'Y' or m1:participationInterestMACT/m1:mactEnterDerivativesWithClients   = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactEnterDerivativesWithClients   = 'N' or m1:participationInterestMACT/m1:mactEnterDerivativesWithClients   = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>       
     </div>
  </div>
<div style="clear:both"></div>
</div>

  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(4) recommend securities or other investment or derivative products to such <em>clients</em> or <em>solicitees</em> in which applicant or any <em>associated person</em> has some other proprietary (ownership) interest (other than those mentioned in Items 7-A(1), (2) or (3) above)?</div>
    <div class="tdStyle1 tditem10col2" >
                		<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactRecommendOwnedInterestToClients  = 'Y' or m1:participationInterestMACT/m1:mactRecommendOwnedInterestToClients   = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactRecommendOwnedInterestToClients   = 'N' or m1:participationInterestMACT/m1:mactRecommendOwnedInterestToClients   = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>       
	
     
  </div>
  <div style="clear:both"></div>
</div>
</div>

<h3><em>Sales Interest in Client or Solicitee Transactions</em> </h3>
<h3>B. Does applicant or any <em>associated person</em>:</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) recommend purchases of securities or derivatives to <em>clients</em> or <em>solicitees</em> that are served by the applicant or <em>associated person</em>, for which the applicant or any <em>associated person</em> serves as underwriter, general or managing partner, or purchaser representative?</div>
    <div class="tdStyle1 tditem10col2" >
                    		<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactRecommendToClientsServing  = 'Y' or m1:participationInterestMACT/m1:mactRecommendToClientsServing   = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactRecommendToClientsServing   = 'N' or m1:participationInterestMACT/m1:mactRecommendToClientsServing   = 'n'">
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
  

   </div>
<div style="clear:both"></div>
</div>
</div>

  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) recommend purchases or sales of securities or derivatives to such <em>clients</em> or <em>solicitees</em> in which applicant or any <em>associated person</em> has any other sales interest (other than the receipt of sales commissions as a broker or registered representative of a broker-dealer)?</div>
    <div class="tdStyle1 tditem10col2" >
             	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactRecommendToClientsHavingOtherSalesInterest   = 'Y' or m1:participationInterestMACT/m1:mactRecommendToClientsHavingOtherSalesInterest    = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactRecommendToClientsHavingOtherSalesInterest    = 'N' or m1:participationInterestMACT/m1:mactRecommendToClientsHavingOtherSalesInterest    = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     


   </div>
<div style="clear:both"></div>
</div>
</div>

<h3><em>Investment or Brokerage Discretion</em> </h3>
<h3>C. Does applicant or any <em>associated person</em> have <em>discretionary authority</em> to determine the:</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) securities or other investment or derivative products to be bought or sold for the account of a <em>client</em> or <em>solicitee</em>?</div>
    <div class="tdStyle1 tditem10col2" >
                 	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthBuySellAsMAA   = 'Y' or m1:participationInterestMACT/m1:mactDiscAuthBuySellAsMAA    = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthBuySellAsMAA    = 'N' or m1:participationInterestMACT/m1:mactDiscAuthBuySellAsMAA    = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
	
      </div>
<div style="clear:both"></div>
</div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) amount of securities or other investment or derivative products to be bought or sold for the account of such a <em>client</em> or <em>solicitee</em>?</div>
    <div class="tdStyle1 tditem10col2" >
                     	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthBuySell   = 'Y' or m1:participationInterestMACT/m1:mactDiscAuthBuySell    = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthBuySell    = 'N' or m1:participationInterestMACT/m1:mactDiscAuthBuySell    = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     


    </div>
<div style="clear:both"></div>
</div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3) (a) broker or dealer to be used  
                       for a purchase or sale of securities or other investment or derivative products   
                       for the account of such a <em>client</em> or <em>solicitee</em>?
    </div>
    <div class="tdStyle1 tditem10col2" >
                         	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealer    = 'Y' or m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealer     = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealer     = 'N' or m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealer     = 'n'">
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
 
      
      </div>
<div style="clear:both"></div>
</div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(b) If &quot;Yes,&quot; are any of 
				the brokers or dealers <em>associated persons</em>?
    </div>
    <div class="tdStyle1 tditem10col2" >
                             	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealerAreAP    = 'Y' or m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealerAreAP     = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealerAreAP     = 'N' or m1:participationInterestMACT/m1:mactDiscAuthDetermineBrokerDealerAreAP     = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
  
     
    </div>
<div style="clear:both"></div>
</div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(4) commission rates or other fees to be paid to a broker or dealer for such a <em>client's</em> or <em>solicitee's</em> securities transactions or transactions in other investment or derivative products?</div>
    <div class="tdStyle1 tditem10col2" >
                                 	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthDetermineCommissionToBrokerDealer    = 'Y' or m1:participationInterestMACT/m1:mactDiscAuthDetermineCommissionToBrokerDealer     = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactDiscAuthDetermineCommissionToBrokerDealer     = 'N' or m1:participationInterestMACT/m1:mactDiscAuthDetermineCommissionToBrokerDealer     = 'n'">
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
       

</div>
<div style="clear:both"></div>
</div>
</div>


<h3>D.</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"><strong>(1) Does applicant or any <em>associated person</em> recommend brokers, 
                dealers or <em>investment advisers</em> to <em>clients</em> or <em>solicitees</em> 
                in the context of its <em>municipal advisory activities</em>?</strong>
    </div>

    <div class="tdStyle1 tditem10col2" >
		<xsl:choose>
			<xsl:when
				test="m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClient = 'Y' 
				     or m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClient = 'y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:when>
			<xsl:when
				test="m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClient = 'N' 
				     or m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClient = 'n'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:otherwise>
		</xsl:choose>     
 
</div>
<div style="clear:both"></div>
</div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) If &quot;Yes,&quot; is any such broker, dealer, or 
    	<em>investment adviser</em> an <em>associated person</em>?
    </div>
    <div class="tdStyle1 tditem10col2" >
		<xsl:choose>
			<xsl:when
				test="m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClient = 'Y' 
				     or m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClient = 'y'">
				<xsl:choose>
					<xsl:when
						test="m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClientAreAP = 'Y' 
						      or m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClientAreAP = 'y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							  
					</xsl:when>
					<xsl:when
						test="m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClientAreAP = 'N' 
						      or m1:participationInterestMACT/m1:mactRecommendBrokerDealerToClientAreAP = 'n'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
					</xsl:when>
					<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
				</xsl:choose>     
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:otherwise>
		</xsl:choose>     
</div>
<div style="clear:both"></div>
</div>
</div>
<p><em>In responding to Items 7-E and 7-F below, consider all cash and non-cash compensation 
       that the applicant or an associated person gave or received from any person in exchange 
       for referrals of such clients or solicitees, including any bonus that is based, at 
       least in part, on the number or amount of such referrals.</em> </p>

<h3>E. Does the applicant or any <em>associated person</em>, 
    directly or indirectly, compensate any <em>person</em> for referrals of <em>clients</em> 
    or <em>solicitees</em> in connection with <em>municipal advisory activities</em>?</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"></div>
    <div class="tdStyle1 tditem10col2" >
                  	<xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactCompensateForReferrals = 'Y' 
							     or m1:participationInterestMACT/m1:mactCompensateForReferrals = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactCompensateForReferrals = 'N' 
							     or m1:participationInterestMACT/m1:mactCompensateForReferrals = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
  


</div>
</div>
<div style="clear:both"></div>
</div>
<h3>F. Does the applicant or any <em>associated person</em>, 
    directly or indirectly, receive compensation from any <em>person</em> for referrals of 
    <em>clients</em> or <em>solicitees</em> in connection with <em>municipal advisory 
    activities</em>?</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1" ></div>
    <div class="tdStyle1 tditem10col2" >
              <xsl:choose>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactReceiveCompensationForReferrals   = 'Y' or m1:participationInterestMACT/m1:mactReceiveCompensationForReferrals    = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:participationInterestMACT/m1:mactReceiveCompensationForReferrals   = 'N' or m1:participationInterestMACT/m1:mactReceiveCompensationForReferrals     = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>    
 
</div>
</div>
<div style="clear:both"></div>
</div>
</xsl:template>

</xsl:stylesheet>