<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 5 templates -->
	
<xsl:template name="Item5" >

	<h3>A. Applicant is actively engaged in business in or as a:</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1" ><strong style="font-weight:bold;">&#160;</strong>
    </div>
    <div class="tdStyle1 tditem5col2" >
    	<!-- <strong style="font-weight:bold;"> -->Is Applicant Actively Engaged?<!-- </strong> -->
    	<br />Check all that apply.
    </div>
    <div class="tdStyle1 tditem5col2" >
    	<!-- <strong style="font-weight:bold;"> -->Is this Applicant’s Primary Business(es)?<!-- </strong> -->
    	<br />Check all that apply.
    </div>
<!--     <td width="20%"><strong>Jurisdiction(s) where licensed:</strong></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1" >1. Broker-dealer, municipal securities dealer or government securities broker or dealer</div>
    <div class="tdStyle1 tditem5col2" >
		<xsl:choose> 
			<xsl:when test="m1:otherActivities/m1:brokerDealers/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:brokerDealers/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:brokerDealers/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:brokerDealers/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>
    
    </div>
	<div class="tdStyle1 tditem5col2" >
    	<xsl:choose>
    		<xsl:when test="m1:otherActivities/m1:brokerDealers/m1:isPrimaryBusiness = 'Y' 
    						or m1:otherActivities/m1:brokerDealers/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:brokerDealers/m1:isPrimaryBusiness = 'N' 
						or m1:otherActivities/m1:brokerDealers/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
	</div>
<!--     <td width="20%"><input type="text" name="jurisdiction" id="jurisdiction" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1" >2. Registered representative of a broker-dealer</div>
    <div class="tdStyle1 tditem5col2" >
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:registeredBrokerDealerReps/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:registeredBrokerDealerReps/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:registeredBrokerDealerReps/m1:isActivelyEngaged = 'N' 
						or m1:otherActivities/m1:registeredBrokerDealerReps/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2" >
    	<xsl:choose>
    		<xsl:when test="m1:otherActivities/m1:registeredBrokerDealerReps/m1:isPrimaryBusiness = 'Y' 
    						or m1:otherActivities/m1:registeredBrokerDealerReps/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:registeredBrokerDealerReps/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:registeredBrokerDealerReps/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
	</div>
<!--     <td width="20%"><input type="text" name="jurisdiction2" id="jurisdiction2" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1" >3. Commodity pool operator (whether registered or exempt from registration)</div>
    <div class="tdStyle1 tditem5col2" >
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:commodityPoolOperator/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:commodityPoolOperator/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:commodityPoolOperator/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:commodityPoolOperator/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2" >
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:commodityPoolOperator/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:commodityPoolOperator/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:commodityPoolOperator/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:commodityPoolOperator/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction3" id="jurisdiction3" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">4. Commodity trading advisor (whether registered or exempt from registration)</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:commidityTA/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:commidityTA/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:commidityTA/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:commidityTA/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
		    <xsl:when test="m1:otherActivities/m1:commidityTA/m1:isPrimaryBusiness = 'Y' 
		    				or m1:otherActivities/m1:commidityTA/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:commidityTA/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:commidityTA/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction4" id="jurisdiction4" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">5. Futures commission merchant</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:futuresCommissionMerchant/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:futuresCommissionMerchant/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:futuresCommissionMerchant/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:futuresCommissionMerchant/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:futuresCommissionMerchant/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:futuresCommissionMerchant/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:futuresCommissionMerchant/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:futuresCommissionMerchant/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction5" id="jurisdiction5" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">6. Major swap participant</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:majorSwapParticipant/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:majorSwapParticipant/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:majorSwapParticipant/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:majorSwapParticipant/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:majorSwapParticipant/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:majorSwapParticipant/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:majorSwapParticipant/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:majorSwapParticipant/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction6" id="jurisdiction6" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">7. Major security-based swap participant</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:majorSBSwapParticipant/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:majorSBSwapParticipant/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:majorSBSwapParticipant/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:majorSBSwapParticipant/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:majorSBSwapParticipant/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:majorSBSwapParticipant/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:majorSBSwapParticipant/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:majorSBSwapParticipant/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction7" id="jurisdiction7" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">8. Swap dealer</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:swapDealers/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:swapDealers/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:swapDealers/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:swapDealers/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:swapDealers/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:swapDealers/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:swapDealers/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:swapDealers/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction8" id="jurisdiction8" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">9. Security-based swap dealer</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:swapDealersSecurityBased/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:swapDealersSecurityBased/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:swapDealersSecurityBased/m1:isActivelyEngaged = 'N' 
						or m1:otherActivities/m1:swapDealersSecurityBased/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:swapDealersSecurityBased/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:swapDealersSecurityBased/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:swapDealersSecurityBased/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:swapDealersSecurityBased/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction9" id="jurisdiction9" readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">10. Trust company</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:trustCompany/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:trustCompany/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:trustCompany/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:trustCompany/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:trustCompany/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:trustCompany/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:trustCompany/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:trustCompany/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction10" id="jurisdiction10" readonly="1"/></td> -->

  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">11. Real estate broker, dealer, or agent</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:realEstate/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:realEstate/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:realEstate/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:realEstate/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	    
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:realEstate/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:realEstate/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:realEstate/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:realEstate/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	    
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction11" id="jurisdiction11" readonly="1"/></td> -->
	
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">12. Insurance company, broker, or agent</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:insurance/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:insurance/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:insurance/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:insurance/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	     
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:insurance/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:insurance/m1:isPrimaryBusiness = 'y'">
			<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:insurance/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:insurance/m1:isPrimaryBusiness = 'n'">
			<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	    
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction12" id="jurisdiction12" readonly="1"/></td> -->

  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">13. Banking or thrift institution (including a separately identifiable department or division of a bank)</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:bankingThrift/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:bankingThrift/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:bankingThrift/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:bankingThrift/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:bankingThrift/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:bankingThrift/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:bankingThrift/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:bankingThrift/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	      
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction13" id="jurisdiction13"  readonly="1"/></div> -->
	
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">14. <em>Investment adviser</em>  (including financial planners)</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:investmentAdvisor/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:investmentAdvisor/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:investmentAdvisor/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:investmentAdvisor/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	        
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:investmentAdvisor/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:investmentAdvisor/m1:isPrimaryBusiness = 'y'">
				<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:investmentAdvisor/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:investmentAdvisor/m1:isPrimaryBusiness = 'n'">
				<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	       
  			<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction14" id="jurisdiction14"  readonly="1"/></td> -->
	
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">15. Attorney or law firm (Jurisdiction(s) where licensed)</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'n'">
				<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	        
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:lawyers/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	    
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
  </div>  
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
	<div class="tdStyle1 tditem5col1">
		<br/>
		<span class="minutia">Jurisdiction(s) where licensed (specify)   </span>
		
		<p>
			<div class="fakeBox">
				<xsl:value-of
					select="string(m1:otherActivities/m1:lawyers/m1:licensedJurisdictions)" />
				<span>
					<xsl:text>&#160;</xsl:text>
				</span>
			</div>
		</p>

	</div>

	<div class="tdStyle1 tditem5col2">&#160;</div>
	<div class="tdStyle1 tditem5col2">&#160;</div>
  </div>
  <div style="clear:both"></div>
  <!--<div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;border-top: #999 thin solid;">-->
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;border-top: white thin solid;">
    <div class="tdStyle1 tditem5col1">16. Accountant or accounting firm (Jurisdiction(s) where licensed)</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	         
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:accounting/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
	</div>
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
     <div class="tdStyle1 tditem5col1">
       <p class="minutia">Jurisdiction(s) where licensed (specify)   </p><br></br>    
    <p>
            <div class="fakeBox">
               <xsl:value-of
                        select="string(m1:otherActivities/m1:accounting/m1:licensedJurisdictions)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
        </p>
    </div>
    <div class="tdStyle1 tditem5col2">&#160;</div>
    <div class="tdStyle1 tditem5col2">&#160;</div>
  </div>
  <div style="clear:both"></div>
  <!--<div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;border-top: #999 thin solid;">-->
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;border-top: white thin solid;">
    <div class="tdStyle1 tditem5col1">17. Engineer or engineering firm</div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:engineering/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:engineering/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:engineering/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:engineering/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	         
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:engineering/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:engineering/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:engineering/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:engineering/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	    
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
<!--     <td width="20%"><input type="text" name="jurisdiction14" id="jurisdiction14"  readonly="1"/></td> -->
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle1 tditem5col1">
       <p class="minutia">Jurisdiction(s) where licensed  </p><br></br>    
    <p>
            <div class="fakeBox">
               <xsl:value-of
                        select="string(m1:otherActivities/m1:accounting/m1:licensedJurisdictions)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
        </p>
    </div>
    <div class="tdStyle1 tditem5col2">&#160;</div>
    <div class="tdStyle1 tditem5col2">&#160;</div>
  </div>
  <div style="clear:both"></div>
  
  <!--<div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;border-top: #999 thin solid;">-->
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;border-top: white thin solid;">
    <div class="tdStyle1 tditem5col1">18. Other financial product advisor 
<!--     (specify):<input name="text" type="text" readonly="1"/> -->
   </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'Y' 
							or m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'N' 
							or m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isActivelyEngaged = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	        
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
    <div class="tdStyle1 tditem5col2">
    	<xsl:choose>
			<xsl:when test="m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'Y' 
							or m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'y'">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
			</xsl:when>
			<xsl:when test="m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'N' 
							or m1:otherActivities/m1:otherFinancialProductAdvisor/m1:activelyEngagedPrimaryBusiness/m1:isPrimaryBusiness = 'n'">
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:when>	
    		<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			</xsl:otherwise>
		</xsl:choose>	
    </div>
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
     <div class="tdStyle1 tditem5col1"> 
     <p class="minutia">(specify)  </p><br></br>
     <p>
            <div class="fakeBox">
              
                <xsl:value-of
                        select="string(m1:otherActivities/m1:otherFinancialProductAdvisor/m1:licensedJurisdictions)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
        </p>    
     </div>
    <div class="tdStyle1 tditem5col2">&#160;</div>
    <div class="tdStyle1 tditem5col2">&#160;</div>
  </div> 
<div style="clear:both"></div>  
</div>
<h3>B. Other Business</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle tdLabelStyleBgcolor tditem5col1" style="margin-top:1px;border-bottom:none;" >(1) Is applicant actively engaged in any other business not listed in Part A 
    of this Item (other than engaging in <em>municipal advisory activities</em>)?</div>
    <div class="tdYesNoStyle tditem5col2" style="border-bottom:none;">
    
      <xsl:choose>                
           <xsl:when
				test="m1:isEngagedInOtherNonMAABusiness = 'Y' or m1:isEngagedInOtherNonMAABusiness  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:when>
			<xsl:when
				test="m1:isEngagedInOtherNonMAABusiness = 'N' or m1:isEngagedInOtherNonMAABusiness  = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
			</xsl:when>
			<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:otherwise>
	  </xsl:choose>    
    </div>
  </div>
  <div style="clear:both"></div>
  <div  class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle tdLabelStyleBgcolor tditem5col1" style="margin-top:1px;border-bottom:none;">(2) If &quot;Yes&quot; to <b>Part B-1.</b>, is this other business 
    applicant's primary business?</div>
    <div class="tdYesNoStyle tditem5col2" style="border-bottom:none;">
		<xsl:choose>                
			<xsl:when
				test="m1:isEngagedInOtherNonMAABusiness = 'Y' 
				     or m1:isEngagedInOtherNonMAABusiness  = 'y'">
				<xsl:choose>                
					<xsl:when
						test="m1:controls/m1:isOtherNonMAABuisinesssPrimary = 'Y' 
						     or m1:controls/m1:isOtherNonMAABuisinesssPrimary = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:when>
					<xsl:when
						test="m1:controls/m1:isOtherNonMAABuisinesssPrimary = 'N' 
						     or m1:controls/m1:isOtherNonMAABuisinesssPrimary = 'n'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
					</xsl:when>
					<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
				</xsl:choose>   
			</xsl:when>
			<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:otherwise>
		</xsl:choose>   
   </div>
  </div>
  <div style="clear:both"></div>
  <div class="trStyle" style="width:100%; display:flex; margin-left:0; margin-right:0;">
    <div class="tdStyle tdLabelStyleBgcolor tditem5col1" style="margin-top:1px;border-bottom:none;">(3) If &quot;Yes&quot; to <b>Part B-2.</b>, 
    describe the other business on <b><u>Section 5-B of Schedule D</u></b>.</div>
    <div class="tdYesNoStyleNoBorder" style="margin-left:0; margin-right:0; float:right; width:72%;"></div>
  </div>
  <div style="clear:both"></div>
</div>

</xsl:template>

</xsl:stylesheet>