<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- criminalDisclosureDrp templates -->
	
<xsl:template name="criminalDisclosureDrp" >
 <xsl:for-each select="m1:formData/m1:drpInfo/ns3:criminalDisclosure/ns3:criminalDrp">
   <div class="formDescription">
   <strong>GENERAL INSTRUCTIONS</strong>
        <p>This <b>Disclosure Reporting Page (DRP MA)</b> is an
        		<span
						class="label">
						<xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:baseHeader/ns3:type/n2:add)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>INITIAL</b> <b><em> OR </em></b>
						<xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:baseHeader/ns3:type/n2:amend) &gt; 0">
								
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>AMENDED</b>
					</span>
       response used to report details for affirmative responses to Items 9-A or 9-B of Form  MA.</p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle1 tdLabelStyle1 tdcrmlongtext" style="margin-left:0; margin-right:0;">Check item(s) being responded to:</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
          <div class="tdStyle1 tdLabelStyle1 tdcrmpartbcolOne" style="margin-left:0; margin-right:0;">
          	<span
						class="label">
						<xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-A1']) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>9-A(1)</strong>
						<xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-A2']) &gt; 0">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>9-A(2)</strong>
						<xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-B1']) &gt; 0">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>9-B(1)</strong>
						<xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-B2']) &gt; 0">
								
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<strong>9-B(2)</strong>
					</span>
           </div>
          </div>
		  <div style="clear:both"></div>
        </div>
    </div>
        <div class="guidance"> 
          <div id="helpcrimdrpMA" class="deets">
            <p><strong><u>How to Report an Event or <em>Proceeding</em> on a Criminal Action DRP</u>:</strong> Use a separate DRP for each event or <em>proceeding</em>.  The same event or <em>proceeding</em> may be reported for more than one <em>person</em> or entity using one DRP.  One event may result in more than one affirmative answer to <strong>Items 9-A(1), 9-A(2), 9-B(1), and/or 9-B(2).</strong>  Use this DRP to report all <em>charges</em>, including multiple counts of the same <em>charge</em>, arising out of the same event and filed in one criminal action.  Separate cases arising out of the same event, and unrelated criminal actions, must be reported on separate DRPs.</p>
            <p>              <strong>How to Provide Court Documents:</strong> Applicable court documents (i.e., criminal complaint, information or indictment as well as judgment of conviction or sentencing documents) must be provided electronically if not previously submitted. </p>
<!--             <p><strong>DOCUMENT ATTACHMENT</strong></p> -->
 </div>
        </div>
<!--        <h3><a href="#">Document Attachment</a> (see 13H format). </h3> -->
      <div class="form1">
        <h2>CRIMINAL ACTION DRP PART 1</h2>
        <p>Check all that apply, except where noted:</p>
    <div class="tableStyle" style="margin-left:0; margin-right:0;">
	<div style="width:100%; display:flex; margin-left:0; margin-right:0;">

		<div class="tableRow" style="margin-left:0; margin-right:0;">
			<h2>
				The
				<em>person</em>
				(s) or entity(ies) for whom this DRP is being filed is (are) the:
			</h2>
		</div>
		<div style="clear:both"></div>
	</div>
	<div class="tableRow">
		<div class="tdStyle1 tdLabelStyle1 tdcrmlongtext" style="margin-left:0; margin-right:0;">
			          
			<xsl:choose>
				<xsl:when
					test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicant)&gt; 0">
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
			</xsl:choose>
			Applicant (the
			<em>municipal advisory firm</em>
			)
		</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">

		<div class="tdStyle1 tdLabelStyle1 tdcrmlongtext" style="margin-left:0; margin-right:0;">
			          
			<xsl:choose>
				<xsl:when
					test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicantAndAP)&gt; 0">
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
			</xsl:choose>
			Applicant and one or more
			<em>of the applicant's associated person(s)</em>
		</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">	
		<div class="tdStyle1 tdLabelStyle1 tdcrmlongtext" style="margin-left:0; margin-right:0;">			          
			<xsl:choose>
				<xsl:when
					test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:ap)&gt; 0">
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
			</xsl:choose>
			One or more of applicant's
			<em>associated person(s)</em>
		</div>
	</div>
	<div style="clear:both"></div>
</div>
	<div id="crimApplicant" style="margin-left:0; margin-right:0;">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="tableRow">
				<div style="margin-left:0; margin-right:0;">
					<h3>
						1.
						<strong>
							<u>Applicant</u>
						</strong>
					</h3>
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 tdLabelStyle1 tditem10col1">           (a) Is this DRP an amendment filed for the applicant
					that seeks to remove a previously filed DRP concerning the
					applicant
					from the record?</div>
				<div class="tdStyle1 tditem10col2">
					<xsl:choose>
						<xsl:when
							test="count(ns3:applicantInfo/ns3:drpRemoveReason)&gt; 0">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Yes
					<xsl:choose>
						<xsl:when
							test="count(ns3:applicantInfo/ns3:drpRemoveReason)&gt; 0">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:when>
						<xsl:otherwise>

							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
					</xsl:choose>
					No
				</div>
				<div style="clear:both"></div>
			</div>
			<div style="clear:both"></div>
			<div class="hide tableRow" id="crimRow1b">
				<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">           (b) The reason the DRP should be removed
					is:</div>
			</div>
			<div style="clear:both"></div>
			<div class="hide tableRow" id="crimRow1ba">			
				<div class="tdcrmlongtext">					          
					<xsl:choose>
						<xsl:when
							test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isRegistered)&gt; 0">
							                     
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							                     
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					The applicant is registered or has submitted an application for
					registration that is currently pending and the event or
					<em>proceeding</em>
					was resolved in the applicant’s favor.
				</div>
				<div style="clear:both"></div>			
			</div>		
			<div style="clear:both"></div>			
			<div class="hide tableRow" id="crimRow1bb">	
				<div class="tdcrmlongtext">				          
					<xsl:choose>
						<xsl:when
							test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isFiledError)&gt; 0">
							                     
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							                     
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					The DRP was filed in error.
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdcrmlongtext">				          
					<xsl:choose>
						<xsl:when
							test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isOlderThan10Years)&gt; 0">
							                     
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							                     
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					The event or
					<em>proceeding</em>
					occurred more than ten years ago.
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 tdLabelStyle1 tdcrmlongtext">
					Explain the circumstances:</div>
			</div>
			<!--<div style="clear:both"></div>-->
			<div class="hide tableRow" id="crimexplain22">	
				<div class="tdStyle1 tdLabelStyle1 tditem10col1" >
					<br />
					<!--  <textarea name="textarea4" id="textarea4" cols="52" rows="5"> 
						<xsl:value-of select="string(ns3:applicantInfo/ns3:header/ns3:drpRemoveReason/n2:isFiledError/n2:explainTheCircumstances)" 
						/> </textarea> -->
					<div class="fakeBox">
						<xsl:value-of
							select="string(ns3:applicantInfo/ns3:drpRemoveReason/n2:isFiledError/n2:explainTheCircumstances)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</div>
			</div>
			<div style="clear:both"></div>
		</div>
	</div>
	<div id="crimAP" style="margin-left:0; margin-right:0;">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="tableRow">
				<div class="tdStyle1 tdLabelStyle1 tditem10col1">
					<h3>
						2.
						<b>
							<u>
								<em>Associated Person(s)</em>
							</u>
						</b>
					</h3>
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 tdLabelStyle1 tditem10col1" >
					(a) Does this DRP concern one or more
					<em>associated persons</em>
					?
				</div>
				<div class="tdStyle1 tditem10col2">
					<xsl:choose>
						<xsl:when test="count(ns3:apInfo/ns3:associatedPerson)&gt; 0">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Yes
					<xsl:choose>
						<xsl:when test="count(ns3:apInfo/ns3:associatedPerson)&gt; 0">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:when>
						<xsl:otherwise>

							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
					</xsl:choose>
					No
				</div>
				
			</div>
			<div style="clear:both"></div>
			<div class="hide tableRow" id="crimRow2a1">	
				<div class="tdStyle1 tdLabelStyle1 tditem10col1">
					          
					<label>
						(i) Total number of such
						<em>associated person</em>
						(s):&#160;&#160;
					</label>
				<!-- 
						<input name="textfield24" type="text" class="tinyField" id="textfield30">
		                        <xsl:attribute name="value">
		                <xsl:value-of select="count(ns3:apInfo/ns3:associatedPerson)" />
		                </xsl:attribute>

                    </input>
                    -->
	              <input name="textfield24" type="text" class="tinyField" id="textfield30" >
	               <xsl:choose>
	                <xsl:when test="count(ns3:apInfo/ns3:associatedPerson) &gt; 0" >
	                    <xsl:attribute name="value">
	                          <xsl:value-of select="count(ns3:apInfo/ns3:associatedPerson)" />
	                    </xsl:attribute>
	                </xsl:when>
	                 <xsl:otherwise>
	                       <xsl:attribute name="value">
	                           <xsl:value-of select="." />
	                        </xsl:attribute>
	                    </xsl:otherwise>
	                  </xsl:choose>
	                </input>
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="hide tableRow" id="crimRow2b">								
				<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">(b) Identify each such associated firm and/or natural
					person in the space below:</div>
			</div>
			<div style="clear:both"></div>
		</div>
		<!---->
	</div>

	<div class="hide" id="crimapEntry85">
		<xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
			<div class="record hide" id="newcrimAP22" style="margin-left:0; margin-right:0;">
				<h3> Entry</h3>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div class="tableRow">
					<div class="padded tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">						
							<xsl:choose>
								<xsl:when test="count(ns3:apType/ns3:firmInfo)&gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							<strong>Firm</strong>
							<xsl:choose>
								<xsl:when test="count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							<strong>Natural Person</strong>
						</div>
					</div>
					<div style="clear:both"></div>
					<div class="hide tableRow" id="crimfirm22">
						<div class="padded tdStyle1 tdLabelStyle1 tdcrmlongtext" style="margin-left:0; margin-right:0;">						
							<label for="firm name">
								<!--  <input type="text" name="firm name" readonly="1"> <xsl:attribute 
									name="value"> <xsl:value-of select="string(ns3:header/ns3:firmInfo/ns3:fullFirmName)" 
									/> </xsl:attribute> </input> -->
								<div class="fakeBox">
									<xsl:value-of select="string(ns3:apType/ns3:firmInfo)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</label>
							<label for="firm name">
								<br />
								Full name of the
								<em>associated person</em>.
								Enter all the letters of each name and not initials or other
								abbreviations. If no middle name, enter &quot;NMN&quot; on that
								line.
							</label>
						</div>
					</div>
					<div style="clear:both"></div>
					<div class="hide tableRow" id="crimnp22">
						<div class="tdStyle1 tdFourCol">
							<input type="text" name="lastName" readonly="1" >
								<xsl:attribute name="value">
							<xsl:value-of
									select="string(ns3:apType/ns3:naturalPersonInfo/ns2:lastName)" />
							</xsl:attribute>
							</input>
							<br></br>
							Last Name
						</div>
						<div class="tdStyle1 tdFourCol">
							<input type="text" name="firstName" readonly="1" >
								<xsl:attribute name="value">
							<xsl:value-of
									select="string(ns3:apType/ns3:naturalPersonInfo/ns2:firstName)" />
							</xsl:attribute>
							</input>
							<br></br>
							First Name
						</div>
						<div class="tdStyle1 tdFourCol">
							<input type="text" name="middleName" readonly="1" >
								<xsl:attribute name="value">
							<xsl:value-of
									select="string(ns3:apType/ns3:naturalPersonInfo/ns2:middleName)" />
							</xsl:attribute>
							</input>
							<br></br>
							Middle Name
						</div>
						<div class="tdStyle1 tdFourCol">
							<input type="text" name="suffix01" readonly="1">
								<xsl:attribute name="value">
							<xsl:value-of
									select="string(ns3:apType/ns3:naturalPersonInfo/ns2:suffix)" />
							</xsl:attribute>
							</input>
							<br></br>
							Suffix
						</div>
					</div>
					<div style="clear:both"></div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					</div>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableStyle" style="margin-left:0; margin-right:0;">
							The
							<em>associated person</em>
							is:
							<xsl:choose>
								<xsl:when test="ns3:registrationInfo/ns3:isSECRegistered = 'Y'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							registered with the
							<em>SEC</em>
							<xsl:choose>
								<xsl:when test="ns3:registrationInfo/ns3:isSECRegistered = 'N'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							<label for="Associated Person2">
								not registered with the
								<em>SEC</em>
							</label>
						</div>
					</div>
					<div class="hide" id="crimsecReg22 tableRow">					
						<div style="margin-left:0; margin-right:0;">							          
							<input type="text" name="crimsecRegno22" readonly="1">
								<xsl:attribute name="value">
							<xsl:value-of select="ns3:registrationInfo/ns3:secRegistrationNumber" />
							</xsl:attribute>
							</input>
							<br />
							          
							<em>SEC</em>
							Registration No.
						</div>
						<div style="margin-left:0; margin-right:0;">							          
							<input type="text" name="crd22" readonly="1">
								<xsl:attribute name="value">
									<xsl:call-template name="CRDFormatting">
										<xsl:with-param name="CRD" select="ns3:registrationInfo/ns3:crdNumber" />
									</xsl:call-template> 
								</xsl:attribute>
							</input>
							<br />
							          
							<em>CRD</em>
							No., if any
						</div>
						<div style="margin-left:0; margin-right:0;"></div>
						<div style="margin-left:0; margin-right:0;"></div>
					</div>
					<div id="crimsecReg22" style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div style="margin-left:0; margin-right:0;"></div>
						<div style="margin-left:0; margin-right:0;"></div>
						<div style="margin-left:0; margin-right:0;"></div>
						<div style="margin-left:0; margin-right:0;"></div>
					</div>
				</div>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div class="tableRow">
						<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">
							Is this DRP an amendment that seeks to remove a previously filed
							DRP concerning this
							<em>associated persons</em>
							?
						</div>
						<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
							<xsl:choose>
								<xsl:when test="count(ns3:drpRemovalInformation) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									Yes
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									No
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									Yes
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									No
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
					<div style="clear:both"></div>
				</div>
				<div class="tableStyle hide" id="removecrimdrp22" style="margin-left:0; margin-right:0;">				
					<div class="tableRow">
						<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">The reason the DRP should be removed is:</div>
					</div>
					<div style="clear:both"></div>
					<div class="tableRow">

						<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">
							          
							<xsl:choose>
								<xsl:when
									test="count(ns3:drpRemovalInformation/ns3:apNotAssociated) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							The
							<em>associated persons</em>
							(s) is no longer associated with the advisor.
						</div>
					</div>
					<div style="clear:both"></div>
					<div class="tableRow">

						<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">
							          
							<xsl:choose>
								<xsl:when
									test="count(ns3:drpRemovalInformation/ns3:eventResolved) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							The event or
							<em>proceeding</em>
							was resolved in the
							<em>associated person's</em>
							favor
						</div>
					</div>
					<div style="clear:both"></div>
					<div class="tableRow">

						<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">
							          
							<xsl:choose>
								<xsl:when
									test="count(ns3:drpRemovalInformation/ns3:eventOccurTenYearsAgo) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							The event or
							<em>proceeding</em>
							occurred more than ten years ago.
						</div>
					</div>
					<div style="clear:both"></div>
					<div class="tableRow">
						<div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">							          
							<xsl:choose>
								<xsl:when
									test="count(ns3:drpRemovalInformation/ns3:isFiledError) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							The DRP was filed in error.
						</div>
					</div>					
					<div style="clear:both"></div>
					<div class="hide" id="crimexplain22 tableRow">								
						<div class="tableRow">
							<br />
							Explain the circumstances:
							<br></br>
							<!--           <textarea name="textarea" cols="45" rows="5" readonly="1"> 
								<xsl:value-of select="string(ns3:header/ns3:baseInformation/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" 
								/> </textarea> -->
							<div class="fakeBox">
								<xsl:value-of
									select="string(ns3:drpRemovalInformation/ns3:isFiledError/n2:explainTheCircumstances)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
						<div style="clear:both"></div>
					</div>
					<div style="clear:both"></div>
				</div>

			</div>
		</xsl:for-each>
	</div>
  
  
      <div style="margin-left:0; margin-right:0;">
      <!-- 
       <h3>1. <u>Applicant</u></h3> 
       <u><strong>B. DRP Filed Elsewhere for this Event:</strong> Is an accurate and up-to-date DRP containing the information regarding the applicant or <em>associated person</em> required by this DRP already on file (a) in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, or U4), or (b) in the <em>SEC</em>’s EDGAR system (with a Form MA or Form MA-I)?</u>
      <br />
	  <br />
	  -->
	  <!-- <em><strong>Note: If a Form MA-T is on file that includes disclosures for this event, but does not include all the information required by this DRP, the disclosures on Form MA-T are not considered accurate and up-to-date</strong></em>
            -->
            
       <xsl:for-each select="ns3:applicantInfo">
        <h3> <u>Applicant</u></h3> 
        <br />
        <br />
       <u><strong>B. DRP Filed Elsewhere for this Event:</strong></u>
        <br />
        <br />
        <div class="tableStyle" style="margin-left:0; margin-right:0;">          
          <div class="tableRow">       
          <div class="tdStyle1 tdLabelStyle1 tditem10col1">
           <u>Is an accurate and up-to-date DRP containing the information regarding the applicant or <em>associated person</em> required by this DRP already on file (a) in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, or U4), or (b) in the <em>SEC</em>’s EDGAR system (with a Form MA or Form MA-I)?</u>
          </div>     
           			<div class="tdStyle1 tditem10col2"> 
              <xsl:choose>
					<xsl:when
						test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes	
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes	
						<img src="Images/radio-checked.jpg" alt="radio button checked" />No
					</xsl:otherwise>
				</xsl:choose>   
			</div>
			<div style="clear:both"></div>
          </div>          
		  <div style="clear:both"></div>
        </div>
        
       <xsl:if test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0"> 
        <div class="dented hide" id="crimdrpDisclosure22" style="margin-left:0; margin-right:0;">
          
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
               <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>If the answer is &quot;Yes&quot;, Provide the applicable information indicated below that identifies where the DRP may be found. </strong></div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">                            
			  <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">
			  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing) &gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
									<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label> 1. Form ADV, BD, or U4 Filing</label></div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">              
			  <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">
			  <xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> 2. Form MA Filing</label></div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;">          
			  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label> 3. Form MA-I  Filing</label></div>
            </div>
			<div style="clear:both"></div>
            <!--  <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
              
              <div class="checkbox" style="margin-left:0; margin-right:0;">          <xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 ">
										<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
							<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> 4. Form MA-T Filings</label></div>
            </div>-->
            </div>
          
		  <div class="tableStyle hide" id="advFilingcrim" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
				<div class="tableRow"><h3>1. Form ADV, BD, or U4 Filing:</h3></div>
			  </div>
			  <div style="clear:both"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdLabelStyle1 tditem10col1"> For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information</div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">Name on Registration: 
              <!-- 
                        <input 	type="text" 	name="regisName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:name)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>
               </div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
				  <div class="tdStyle1 tdLabelStyle1 td3cols"><em>CRD</em> No.:
					          <input 	type="text" 	name="iard2" 	readonly="1">
								<xsl:attribute
										name="value">
									<xsl:call-template name="CRDFormatting">
										<xsl:with-param name="CRD" select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:crdNumber)" />
									</xsl:call-template>
								</xsl:attribute>
							</input>
				  </div>
				  <div class="tdStyle1 td3cols">Disclosure Occurrence No.: 
							<input 	type="text" 	name="occurNo2" 	readonly="1">
								<xsl:attribute
										name="value">
								<xsl:value-of
									select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:disclosureNumber)" />
								</xsl:attribute>
							</input>
				  </div>
		    </div>
			<div style="clear:both"></div>
            </div>
          
		  <div class="tableStyle hide" id="maFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow"><h3>2. Form MA Filing:</h3></div>
			<div style="clear:both"></div>
            <div class="tableRow">
              <div class="tdStyle1 tditem10col1"> For a DRP filed on EDGAR with a Form MA, provide the following information:</div>
            </div>
            <div style="clear:both"></div>
			<div class="tableRow">             
              <div class="tdStyle1 tditem10col1">Name on Registration: 
              <!-- 
               <input 	type="text" 	name="regName001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:name)" />
							</xsl:attribute>
						</input>
				  -->
					<div class="fakeBox">
						<xsl:value-of
						   select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:name)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</div>
 	
			</div>
			<div style="clear:both"></div>
			
            <div class="tableRow">
              
              <div class="tdStyle1 tditem10col1">MA Registration Number: 
                          <input 	type="text" 	name="matReg001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
               </div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow" >
              <div class="tdStyle1 tditem10col1">Date of filing that contains the DRP (MM/DD/YYYY): 
                  <input 	type="text" 	name="dateoffiling2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow" >
              <div class="tdStyle1 tditem10col1" >Accession number of the filing: 
                 <input 	type="text" 	name="accessNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
			<div style="clear:both"></div>
			</div>
			<div class="tableStyle hide" id="maiFilingcrim" style="margin-left:0; margin-right:0;">          
				<div class="tableRow">
				<h3>3. Form MA-I Filing:</h3>
				</div>
				<div style="clear:both"></div>
				<div class="tableRow">
                   <div class="tdStyle1 tditem10col1">For a DRP filed on EDGAR with a Form MA-I, provide the following information:</div>
				</div>
				<div style="clear:both"></div>
            <div class="tableRow">  
              <div class="tdStyle1 tditem10col1">Name on Registration: 
              <!-- 
                         <input 	type="text" 	name="regName" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox">
                    <xsl:value-of
                       select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:name)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
               </div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              <div class="tdStyle1 tditem10col1" >MA-I Registration Number: 
                           <input 	type="text" 	name="maiReg" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
              </div>
			  </div>
			  <div style="clear:both"></div>
			  <div class="tableRow">
              <div class="tdStyle1 tditem10col1">Date of filing that contains the DRP (MM/DD/YYYY): 
                <input 	type="text" 	name="dateoffiling3" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
				</div>
				<div style="clear:both"></div>
				<div class="tableRow">
                 <div class="tdStyle1 tditem10col1">Accession number of the filing: 
                 <input     type="text"     name="accessNo"     readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:accessionNumber)" />
                            </xsl:attribute>
                        </input>
                </div>
				</div>
				<div style="clear:both"></div>
            </div>
         <!--  <table class="formTable hide" id="matFilingcrim">
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <div style="width:100%;margin-left:0; margin-right:0;"><h3>4. Form MA-T Filings:</h3></div>
            </div>
            
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <div style="width:100%;margin-left:0; margin-right:0;">For a disclosure filed on the <em>SEC</em> website with a Form MA-T, provide the following information identifying the disclosure on the <em>SEC</em> website at: <a href="https://tts.sec.gov/MATR/index.html"> https://tts.sec.gov/MATR/index.html:</a></div>
            </div>
            
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <div style="width:100%;margin-left:0; margin-right:0;">Name on Registration: --> 
              <!-- 
                          <input 	type="text" 	name="regName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				<!--<div class="fakeBox">
                    <xsl:value-of
                       select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:name)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
              </div>
            </div>
            
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <div style="margin-left:0; margin-right:0;">MA-T Registration Number: 
                         <input 	type="text" 	name="matReg2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
              </div>
             </div>
            
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
             <div style="margin-left:0; margin-right:0;">Date of filing that contains the DRP (MM/DD/YYYY):
                <input 	type="text" 	name="dateoffiling4" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:date)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
        </div>-->
  </div>
  </xsl:if>
  </xsl:for-each><br></br><br/>
  
  <xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
 
  <h3><u>Associated Person(s)</u></h3> 
   <br />
   <br />
        <u><strong>B. DRP Filed Elsewhere for this Event:</strong></u>
   <br />
   <br />
   <div class="tableStyle" style="margin-left:0; margin-right:0;">      
        <div class="tableRow">  
			<div style="margin-left:0; margin-right:0;">
				<u>Is an accurate and up-to-date DRP containing the information regarding the applicant or <em>associated person</em> required by this DRP already on file (a) in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, or U4), or (b) in the <em>SEC</em>’s EDGAR system (with a Form MA or Form MA-I)?</u>
            </div>
            <div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;"> 
              <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes	
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes	
								<img src="Images/radio-checked.jpg" alt="radio button checked" />No
							</xsl:otherwise>
						</xsl:choose>   
            </div>
            </div>
					 
        </div>
        <xsl:if test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
        <div class="dented hide" id="crimdrpDisclosure22">
          
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
                <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>If the answer is &quot;Yes&quot;, Provide the applicable information indicated below that identifies where the DRP may be found. </strong></div>
            </div>
			<div style="clear:both"></div>
          </div>
			<div class="tableStyle hide" id="advFilingcrim" style="margin-left:0; margin-right:0;">           
            <div class="tableRow">
              <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">			  
			  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing) &gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
									<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
						<strong>1. Form ADV, BD, or U4 Filing:</strong> For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information:</div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Name on Registration:
              <!--  
                        <input 	type="text" 	name="regisName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox">
                    <xsl:value-of
                      select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:name)" />
                      
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
               </div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              
              <div class="tdStyle1 tdLabelStyle1 td3cols"><em>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;CRD</em> No.: 
                          <input 	type="text" 	name="iard2" 	readonly="1">
							<xsl:attribute
									name="value">
								<xsl:call-template name="CRDFormatting">
									<xsl:with-param name="CRD" select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:crdNumber)" />
								</xsl:call-template>
							</xsl:attribute>
						</input>
                          </div>
              <div class="tdStyle1 tdLabelStyle1 td3cols">Disclosure Occurrence No.: 
              <input 	type="text" 	name="occurNo2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:disclosureNumber)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
			<div style="clear:both"></div>
            </div>
          
		  <div class="tableStyle hide" id="maFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">              
			  <div class="checkbox tableRow">
			  <xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>
						<strong>2. Form MA Filing:</strong> For a DRP filed on EDGAR with a Form MA, provide the following information:</div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
				<div class="tdStyle1 tdLabelStyle1 tditem10col1">
					&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Name on Registration:
                    <!--  
                         <input 	type="text" 	name="regName001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:name)" />
							</xsl:attribute>
						</input>
					 -->
					 <div class="fakeBox">
	                    <xsl:value-of
	                      select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:name)" />
	    
	                    <span>
	                        <xsl:text>&#160;</xsl:text>
	                    </span>
                </div>
                 </div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;MA Registration Number: 
                          <input 	type="text" 	name="matReg001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:regNumber)" />
								</xsl:attribute>
						</input>
                         </div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
               <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Date of filing that contains the DRP (MM/DD/YYYY): 
                  <input 	type="text" 	name="dateoffiling2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Accession number of the filing: 
                 <input 	type="text" 	name="accessNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
						</input>
                </div>
            </div>
			<div style="clear:both"></div>
            </div>
		<div class="tableStyle hide" id="maiFilingcrim" style="margin-left:0; margin-right:0;">
          <div class="tableRow">              
			  <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">           
				<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose><strong>3. Form MA-I Filing:</strong> For a DRP filed on EDGAR with a Form MA-I, provide the following information:</div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">  
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Name of individual: 
                         <input 	type="text" 	name="regName" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:name)" />
							</xsl:attribute>
						</input>
              </div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;MA-I File Number: 
                           <input 	type="text" 	name="maiReg" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                    </div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Date of filing that contains the DRP (MM/DD/YYYY): 
                <input 	type="text" 	name="dateoffiling3" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
            </div>
			<div style="clear:both"></div>
			<div class="tableRow">
                 <div class="tdStyle1 tdLabelStyle1 tditem10col1">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Accession number of the filing: 
                 <input     type="text"     name="accessNo"     readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:accessionNumber)" />
                            </xsl:attribute>
                        </input>
                </div>
              
            </div>
			<div style="clear:both"></div>
            </div>
         <!--  <table class="formTable hide" id="matFilingcrim">
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
              <td colspan="2" class="checkbox">          <xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 ">
										<img
									src="Imagesbox-checked.jpg" />
							</xsl:when>
							<xsl:otherwise>
							<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  <strong>4. Form MA-T Filings:</strong> For a disclosure filed on the <em>SEC</em> website with a Form MA-T, provide the following information identifying the disclosure on the <em>SEC</em> website at: <a href="https://tts.sec.gov/MATR/index.html"> https://tts.sec.gov/MATR/index.html:</a></div>
            </div>
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
             
              <div style="width:100%;margin-left:0; margin-right:0;">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Name on Registration: 
               --> <!--            
               <input 	type="text" 	name="regName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:name)" />
							</xsl:attribute>
						</input>
					-->
					<!--<div class="fakeBox">
                        <xsl:value-of
                         select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:name)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
                          </div>
            </div>
            <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
             
              <div style="margin-left:0; margin-right:0;">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;MA-T Registration Number: 
                         <input 	type="text" 	name="matReg2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
               </div>
			  </div>
			  <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
                <div style="margin-left:0; margin-right:0;">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Date of filing that contains the DRP (MM/DD/YYYY): 
				   <input 	type="text" 	name="dateoffiling4" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling/n2:date)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
            </div> -->
  </div></xsl:if></xsl:for-each>

      </div>

      <div style="margin-left:0; margin-right:0;"  id="macrimdrpbox2">
      
      <!-- This needs to be fixed so that new DRP button shows-->
      
      <div class="warning" style="margin-left:0; margin-right:0;">

        <div id="warncrimdrp2" class="deets">
          <p><b>Note: The completion of all or any part of this form does not relieve the <em>municipal advisor</em> or <em>associated person</em> of its obligation to update its <em>IARD</em> or <em>CRD</em> records.</b></p>
         </div>
      </div>
      <div id="othercrimDRPs" style="margin-left:0; margin-right:0;">
      
          <div class="recSet hide" >
      </div>
<!--       <h3>Applicant</h3> -->
        <xsl:for-each select="ns3:applicantInfo">
	
		<xsl:choose>
			<xsl:when
			test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
			</xsl:when>
		<xsl:otherwise>
		<h2>CRIMINAL ACTION DRP - PART 2</h2>
        <div class="record hide dented" id="newCDRP" style="margin-left:0; margin-right:0;">
        <h3>1. Firm or Organization  </h3>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">        
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong><b>A.</b> Were<em> charge</em>(s) brought against a firm or organization over which the applicant or <em>associated person</em> exercise(s) (d) <em>control</em>?</strong></div>
            <div class="tdStyle1 tditem10col2">
            <xsl:choose>
						<xsl:when
								test="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargesBroughtAgainstControlled )='Y' ">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                        Yes<xsl:choose>
						<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargesBroughtAgainstControlled ='N' ">
										
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								
							</xsl:when>
							<xsl:otherwise>
										<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                        No</div>
						<div style="clear:both"></div>
		    
		    </div>
			
        <div style="margin-left:0; margin-right:0;" id="crimFirm">
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1 tdLabelStyle1 tditem10col1">
				<strong>
					<b>B.</b>
					If &quot;Yes,&quot; provide the following information:
				</strong>
			</div>
			

		</div>
		<div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdLabelStyle1 tditem10col1">          (1) Enter the firm or organization’s name</div>
		</div>
		<div style="clear:both"></div>      
		<div class="tableRow">
			<div class="tdStyle1 tdLabelStyle1 tditem10col1">
				<!--                      <input type="text" name="organizationName" 
					readonly="1"> <xsl:attribute name="value"> <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:name)" 
					/> </xsl:attribute> </input> -->
				<div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:name)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>
			</div>
			<div style="clear:both"></div>
		</div>
		<div style="clear:both"></div>      
		<div class="tableRow" style="padding-bottom:25px;">
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">           (2) Was the firm or  organization engaged in a <em>municipal  advisor-related or investment-related </em> business?</div>
              <div class="tdStyle1 tditem10col2"><xsl:choose>  
              <xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:isEngagedInMARBusiness='Y' ">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
                Yes<xsl:choose>  
              <xsl:when
								test=" ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:isEngagedInMARBusiness='N' ">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
                No</div>
              </div>
			<div style="clear:both"></div>      
            <div class="tableRow noborder">
                <div class="tdStyle1 tdcrmlongtext">          (3) What was the relationship of the applicant with the firm or organization?  (Include any position or title with the firm  or organization.)</div>
            </div>
			<div style="clear:both"></div>      
            <div class="tableRow">
      
              <div class="tdStyle1 tdLabelStyle1 tditem10col1" >                     
             <!-- 
               <input 	type="text" 	name="textfield6" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:relationshipToCharged)" />
							</xsl:attribute>
						</input>
			 -->
			 <div class="fakeBox">
				<xsl:value-of
					select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:relationshipToCharged)" />
				<span>
					<xsl:text>&#160;</xsl:text>
				</span>
			</div>
			</div>
          </div>
		  <div style="clear:both"></div>      
          </div>
        </div>
        
        <h3>2. Court where Form Charge(s) were Brought:</h3>
        <p class="minutia"><strong><em>(File a separate Criminal Action DRP for charges brought in separate courts and/or separate cases in the same court. If brought in a foreign jurisdiction, provide all the information below in English.)</em></strong></p>
        <p class="minutia">(specify)</p>
        <!-- ////////////////////////////////// -->
         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:fedCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Federal Court<br/>
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:milCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Military Court<br/>
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:stateCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> State Court<br/>  
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:foreignCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Foreign Court<br/>  
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:intnlCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> International Court <br/> 
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:other)&gt; 0">
                                <img src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Other:<br/>
                        <!-- 
                        <input      type="text"     name="text49"   readonly="1">   
                        <xsl:attribute      name="value"> 
                        <xsl:value-of       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)" />
                </xsl:attribute>
                    </input>
                    -->
             <div class="fakeBox">
              
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:other)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
            <br/><br/>
            <!-- //////////////// -->    

<!--start-->
<div class="tableStyle padded" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle1 tditem10col1"><strong>A. Name of the Court:</strong></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tditem10col1" style="margin-left:0; margin-right:0;">            
			<div class="fakeBox">
				<xsl:value-of
					select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
				<span>
					<xsl:text>&#160;</xsl:text>
				</span>
			</div>
            </div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
             <div class="tdStyle1 tditem10col1"><strong>B. Location of the Court</strong></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdjudicialdrpcol1"><label>
              
               <input 	type="text" 		readonly="1" size="60">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street1)" />
							</xsl:attribute>
						</input>
              <br />
              Address 1</label></div>
			</div>
			<div style="clear:both"></div>
            <div class="tableRow">
				<div class="tdStyle1 tdjudicialdrpcol1"><label>
             
                 <input 	type="text" 	 	readonly="1" size="60">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street2)" />
							</xsl:attribute>
						</input>
              <br />
              Address 2</label></div>
            </div>
			<div style="clear:both"></div>
      </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="dented tdStyle1 tdjudicialdrpcol1">
                             <input 	type="text" 	 	readonly="1" size="45">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:city)" />
							</xsl:attribute>
						</input>
              <br />
              City or County
            </div>
            <div class="dented tdStyle1 tdjudicialdrpcol1">						            
            <!-- 
            <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox"> 
                        <span >
                    <xsl:call-template name="stateDescription">
                        <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
                     </xsl:call-template>
                 </span>
                 <span>
                 <xsl:text>&#160;</xsl:text>
                 </span>
              </div>
              <br />
              <label>State/Country</label></div>
			  <!--style="float:right;vertical-align:top;margin-top:-82px; margin-left:0; padding-bottom:32px; margin-right:0;"-->
            <div class="dented tdStyle1 tdjudicialdrpcol1">
               <input 	type="text" 	name="postal code2" 	readonly="1" size="11">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:zipCode)" />
							</xsl:attribute>
						</input>
              <br />
              ZIP +4 Postal Code
            </div>
			<div style="clear:both"></div>
          </div>
          <div class="tableRow">
            <div class="tdStyle1 tdLabelStyle1 tdcrmpartbcolOne"><strong>C. Docket/Case Number:</strong><br />            
				<div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>         
			</div>
          </div>
		  <div style="clear:both"></div>
  </div>
<!--end-->			
		        
       <p> <h3>3. Event Disclosure Detail </h3><span class="minutia">(Use this for both organizational and individual <em>charges</em>): </span></p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">
			<b>A. Date First <em>Charged</em></b> (MM/DD/YYYY): <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:date)" />
							</xsl:attribute>
						</input>    </div>
            
            <div class="tdStyle1 tdTwoCol2">
						<xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:exact) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
              
              Exact
             	<xsl:choose>  
              <xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:explanationInfo/n2:explanation &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
              Explanation </div>
           
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">If not exact, provide explanation<br />
            <!-- 
              <textarea name="explain5" id="explain5" cols="45" rows="2">
              
				
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/ns3:explanationInfo/n2:provideExplanation)" />
							
						
              </textarea>
            -->

            <div class="fakeBox">
                        <xsl:value-of
                         select="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:explanationInfo/n2:provideExplanation" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
             </div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><b>B. Details of Event</b>: Report all <em>charges</em> separately.  For each <em>charge, </em>provide all of the following information.</div>
           
          </div>
		  <div style="clear:both"></div>
        </div>
        <div id="newCrimCharge" class="hide" style="margin-left:0; margin-right:0;">
        
          <div class="boxed" style="margin-left:0; margin-right:0;">
          <xsl:for-each select="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:charges/ns3:charge">
            
			<div class="tableStyle dented" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tditem10col1"><b>(1) <em>Charge</em></b></div>
				   <div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(a) List the <em>charge/charge</em> description:</div>
                         <div class="tdStyle1 tdTwoCol2">
                         <!-- 
                  	 <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:baseInformation/n2:charge)" />
							</xsl:attribute>
						</input> 
					-->
					 <div class="fakeBox" style="min-width:100px;">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:charge)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>   
                </div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg"> (b) Number of Counts: </div>
                <div class="tdStyle1 tdTwoCol2">
					       	 <input 	type="text" 	 	readonly="1" size="5">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:baseInformation/n2:numberOfCounts)" />
							</xsl:attribute>
						</input>  
                </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(c) Check  the applicable box: </div>
                <div class="tdStyle1 tdTwoCol2">
                  
                  	<xsl:choose>  
              <xsl:when
								test=" count(ns3:baseInformation/n2:felonyOrMisdemeanor/n2:felony) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
                  <em>Felony</em>
                     	<xsl:choose>  
              <xsl:when
								test=" count(ns3:baseInformation/n2:felonyOrMisdemeanor/n2:misdemeanor) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose> 
                  <em>Misdemeanor</em></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdCol1Lrg">(d) Plea for this <em>Charge</em></div>
                <div class="tdStyle1 tdTwoCol2">
                <!-- 
                  	 <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:baseInformation/n2:plea)" />
							</xsl:attribute>
						</input> 
						-->
						<div class="fakeBox" style="min-width:100px;">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:plea)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>    
                </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdCol1Lrg">(e) (i) Is  the <em>charge municipal advisor-related?</em></div>               
                <div class="tdStyle1 tdTwoCol2">             	
				<xsl:choose>  
              <xsl:when
								test=" count(ns3:baseInformation/n2:productType) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />Yes<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />                  No
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes<img
									src="Images/radio-checked.jpg" alt="radio button checked" />                  No
									
							</xsl:otherwise>
						</xsl:choose> 
</div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="hide tableRow" id="crimMAProd">
				<div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdCol1Lrg">(e) (ii) If, &quot;Yes,&quot; what is the product type?</div>
                <div class="tdStyle1 tdTwoCol2">
                <!--      	 
                <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:baseInformation/n2:productType)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox" style="min-width:100px;">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:productType)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>      
						</div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdCol1Lrg">(f) (i) Is  the <em>charge investment-related?</em></div>               

                <div class="tdStyle1 tdTwoCol2">   	
				<xsl:choose>  
				  <xsl:when
								test=" count(ns3:baseInformation/n2:investmentProductType) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />Yes<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes<img
									src="Images/radio-checked.jpg" alt="radio button checked" />No
									
							</xsl:otherwise>
						</xsl:choose> 
                </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="hide tableRow" id="crimIRProd">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdCol1Lrg">(f) (ii) If, &quot;Yes,&quot; what is the product type?</div>
                <div class="tdStyle1 tdTwoCol2"> 
                
						<div class="fakeBox" style="min-width:100px;">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:investmentProductType)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>  
                    </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdCol1Lrg">(g) (i) Amended <em>Charge</em>:   Indicate if the original <em>charge</em> was amended or reduced:</div>               
                <div class="tdStyle1 tdTwoCol2"><xsl:choose>  
							<xsl:when
								test=" count(ns3:baseInformation/n2:amendedReducedDate) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>
                  Yes<xsl:choose>   <xsl:when
								test=" count(ns3:baseInformation/n2:amendedReducedDate) &gt; 0">
										
										<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
							
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose> 
                  No</div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="hide tableRow" id="crimamendDate">
               <div style="margin-left:0; margin-right:0;"></div>
               <div class="tdStyle1 tdCol1Lrg">(g) (ii)Provide the date the <em>charge</em> was amended or reduced </div>
               <div class="tdStyle1 tdTwoCol2">
					<input 	type="text"	readonly="1" size="10">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:baseInformation/n2:amendedReducedDate)" />
							</xsl:attribute>
						</input>
				</div>
				<div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
            </div>
             </xsl:for-each>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 tditem10col1"><strong><b>C.<em> Felony Charge</em>(s): </b> </strong></div>
              </div>
			  <div style="clear:both"></div>
              <div class="tableRow">                
                <div class="tdStyle1 tditem10col1">Did any of the <em>charge</em>(s) within the event <em>involve a felony</em>?</div>
                <div class="tdStyle1 tditem10col2">
                <xsl:choose>
                    <xsl:when
                     	test="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:hasFelonyCharges)='Y'">
                      	<img
                      	src="Images/radio-checked.jpg" alt="radio button checked" />Yes
                  	 	<img
                      	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
                     </xsl:when>
                     <xsl:when
                          test="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:hasFelonyCharges)='N'">
                          <img
                          src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
                          <img
                          src="Images/radio-checked.jpg" alt="radio button checked" />No
                     </xsl:when>
                     <xsl:otherwise>
                         <img
                         src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
                         <img
                         src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
                     </xsl:otherwise>
                  </xsl:choose>
              </div>
				  <div style="clear:both"></div>
              </div>
            </div>
            
           
          </div>
         
        </div>
		
      
        
        <h3>4. Current status of the event?</h3>
        <p class="dented">
          <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:status/n1:pending) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
          Pending
  <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:status/n1:onAppeal) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
          On Appeal
  <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:status/n1:final) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
          Final</p>
         
        <p><h3>5. Event Status Date</h3> <span class="minutia">(Complete unless status is pending) (MM/DD/YYYY):</span></p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:date)" />
							</xsl:attribute>
						</input>  
						<xsl:choose> 
                <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:exact ) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
              Exact
             <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:explanationInfo/n2:explanation) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
              Explanation </div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">If not exact, provide explanation<br />
             
              <!-- 
				   <textarea name="explain12" id="explain13" cols="45" rows="2">
              
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/ns3:statusDateInfo/ns3:explanationInfo/ns3:provideExplanation)" />
						
						
              </textarea>
              -->
              <div class="fakeBox">
                        <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:explanationInfo/n2:provideExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
              
              </div>
            </div>
			<div style="clear:both"></div>
        </div>

		
       <div id="crimAppeal" class="hide" style="margin-left:0; margin-right:0;">
         <h3>6. On Appeal – Judicial Review</h3>
        <p class="minutia"><b>If Item 4 On Appeal is checked, to whom was the criminal action appealed?  <em>(If brought in a foreign jurisdiction, provide all the information below in English.)</em>.</b></p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">         
           <div class="tableRow">								
            <div class="tdStyle1 tdLabelStyle1 tditem10col1" style="margin-left:0; margin-right:0;"><p>

            <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:fedCourt) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              
              Federal Court 
              <br />
               <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:milCourt) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Military Court <br />
               <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:stateCourt) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              State Court <br />
              <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:foreignCourt) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Foreign Country Court <br />
              <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:intnlCourt) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              International Court<br />
               <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:other) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Other (specify):
               <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:other) &gt; 0 ">
							<!-- 
              <input 	type="text" 	name="court type" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/n2:other)" />
							</xsl:attribute>
						</input> -->
						<div class="fakeBox">
	                   <xsl:value-of
	                       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:other)" />
	                   <span>
	                        <xsl:text>&#160;</xsl:text>
	                   </span>
	                </div>
				</xsl:when>
						<xsl:otherwise>
						 <input 	type="text" 	name="court type" 	readonly="1"></input>
						 	</xsl:otherwise>
						
			</xsl:choose>
						 
            </p></div>
          </div>
		  <div style="clear:both"></div>
          
          <div class="tableRow">								
            
			<div class="tdStyle1 tdLabelStyle1 tditem10col1" align="left" style="valign:top; margin-left:0; margin-right:0;">
			<label>
            <!-- 
                  <input 	type="text" 	name="court type" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedToCourtName)" />
							</xsl:attribute>
						</input> 
			--> 
			  <div class="fakeBox">
                       <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedToCourtName)" />
                       <span>
                            <xsl:text>&#160;</xsl:text>
                       </span>
                    </div>
              <br />
                 <b>Provide the name of the court</b></label></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div class="tdStyle1 tdLabelStyle1 tditem10col1" align="left"><label>            
			<input 	type="text" 	name="court type" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:date)" />
							</xsl:attribute>
						</input>  
                <b>Date appeal filed (MM/DD/YYYY)</b></label></div>
          </div>
			<div style="clear:both"></div>	
        </div>
		
        <p><b>For Item 7: </b><span class="minutia"><strong>If  Item 4 Final or On Appeal is checked, complete Item 7. For Pending Actions, skip to Item 8.</strong></span></p>
        <h3>7. Disposition Disclosure Detail</h3>
        <p><span class="checkbox"><span class="minutia"><strong>(For each <em>charge</em> provide the following information): </strong></span></span></p>
         <xsl:for-each select="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:charges/ns3:charge">
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">          
			<div style="margin-left:0; margin-right:0;" class="checkbox tdStyle1 tdLabelStyle1 tditem10col1"><strong><strong>A.</strong> First <em>Charge</em></strong></div>
          </div>
		  <div style="clear:both"></div>	
          <div class="tableRow">
            
            <div style="margin-left:0; margin-right:0;" class="checkbox tdStyle1 tdLabelStyle1 tditem10col1"><strong>(1) Disposition of the <em>Charge</em></strong><div class="minutia">Check all that apply.</div></div>
          </div>
		  <div style="clear:both"></div>	
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
<!--             test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Acquitted']) &gt; 0 "> -->
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols">
            	<xsl:choose>
						<xsl:when
							 test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Acquitted']) &gt; 0 ">
							<img src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
				</xsl:choose>
              	Acquitted
           	</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols">
            	<xsl:choose>
					<xsl:when
						test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pled guilty']) &gt; 0 ">
						<img src="Images/box-checked.jpg" alt="checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				Pled Guilty
			</div>
            </div>
			<div style="clear:both"></div>	
          	<div class="tableRow">
	            <div style="margin-left:0; margin-right:0;"></div>
	            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols">
	            	<xsl:choose>
							<xsl:when
								test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Amended']) &gt; 0 ">
								<img src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
					</xsl:choose>
	              	Amended 
	        	</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pled nolo contendere']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Pled  nolo contendere</div>
            </div>
			<div style="clear:both"></div>	
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Convicted']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Convicted</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pled not guilty']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Pled not guilty</div>
            </div>
			<div style="clear:both"></div>	
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Deferred Adjudication']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Deferred Adjudication </div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pre-trial diversion/intervention']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Pretrial diversion/intervention </div>
            </div>
			<div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Dismissed']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Dismissed</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Reduced']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Reduced</div>
            
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Found not guilty']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <em>Found</em> not guilty</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
			Other (specify):
			<xsl:choose>
				<xsl:when
					test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Other']) &gt; 0 ">
					<!-- <input type="text" name="textfield31" readonly="1"> <xsl:attribute 
						name="value"> <xsl:value-of select="string(ns3:dispositionDisclosureDetail/ns3:dispositionType/ns3:otherDisp)" /> 
						</xsl:attribute> </input> 
						-->
					<div class="fakeBox">
						<xsl:value-of
							select="string(ns3:dispositionDisclosureDetail/ns3:dispositionType/ns3:otherDisp)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<input type="text" name="textfield31" readonly="1"></input>
				</xsl:otherwise>
		
			</xsl:choose>
		  </div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tditem10col1"><p>Explanation: <br /><span class="minutia">
              <em>If more  than one disposition is checked, and/or Other is checked, or the above  otherwise does not adequately summarize the disposition of the charge, provide  an explanation. </em></span></p>
              <p>
              <!-- 
                   <textarea name="textarea4" id="textarea4" cols="45" rows="5">
				 
				<xsl:value-of
						select="string(n2:
DisclosureDetail/n2:dispositionType/n2:explanation)" />
				
              </textarea>
              -->
              <div class="fakeBox">
                        <xsl:value-of
                        select="string(ns3:dispositionDisclosureDetail/ns3:dispositionType/ns3:explanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
              </p></div>
            </div>
			<div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 td3cols"><strong>Appealed</strong></div>
            <div style="margin-left:0; margin-right:0;"></div>
           
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Affirmed']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Affirmed</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Vacated / Final']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Vacated / Final</div>
            </div>
		  <div style="clear:both"></div> 
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Vacated &amp; Returned For Further Action']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Vacated &amp; Returned For Further Action</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Other (specify):
              <!--                 
					<input 	type="text" 	name="textfield60" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:dispositionDisclosureDetail/n2:dispositionType/n2:otherAppeal)" />
								
							</xsl:attribute>
						</input> 
                -->
                 <div class="fakeBox">
                        <xsl:value-of
                                select="string(ns3:dispositionDisclosureDetail/ns3:dispositionType/ns3:otherAppeal)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>  
                
                </div>
            </div>
		  <div style="clear:both"></div> 
          <div class="tableRow">
           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>(2) Date</strong></div>
            <div style="margin-left:0; margin-right:0;"></div>
           
          </div>
		  <div style="clear:both"></div> 
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><input 	type="text" 	name="textfield60" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:date)" />
							</xsl:attribute>
						</input> </div>
            <div style="margin-left:0; margin-right:0;"></div>
           
          </div>
		  <div style="clear:both"></div> 
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>(3) Sentence/Penalty:</strong></div>        
            <div style="margin-left:0; margin-right:0;"></div>   
          </div>
          <div style="clear:both"></div> 
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">          Is a sentence or other penalty ordered?</div>            
            <div class="tdStyle1 tditem10col2">
            
            <span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:sentencePenaltyType) &gt; 0">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:sentencePenaltyType) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No
            </span>
            
            </div>
          </div>
		  <div style="clear:both"></div>
		  </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
		   <div class="hide tableRow" id="crimPenalty" style="margin-left:0; margin-right:0;">                    
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">          List each type (e.g., prison, jail, probation, community service, counseling, education, other - specify):<br />
                       
             <textarea name="textarea20" id="textarea20" cols="45" rows="2"></textarea></div>            
          </div>
		  <div style="clear:both"></div>
          </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">            
            <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">(4) Were or are you incarcerated in connection with this sentence? </div>
            <div class="tdStyle1 tditem10col2" >  <span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo) &gt; 0">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No
            
            </span>
            </div>      
          </div>
		  <div style="clear:both"></div>
      </div>
        
		<div class="tableStyle" id="crimIncar" style="margin-left:0; margin-right:0;">
          <div class="tableRow">          
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">Provide the following details:</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">(i) Duration (length of any sentence-suspension, probation, etc.)</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">           
            <div class="tdStyle1 tdFiveCol"><label>
            <!-- 
                        <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:dispositionDisclosureDetail/n2:incarcerationInfo/n2:duration/n2:days)" />
							</xsl:attribute>
						</input>
				-->
				 <div class="fakeBox3">
                        <xsl:value-of
                               select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:duration/n2:days)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>  
              <br />
                        days</label></div>
            <div class="tdStyle1 tdFiveCol"><label>
               <input 	type="text" 	readonly="1" size="5">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:duration/n2:months)" />
							</xsl:attribute>
						</input>
              <br />
              months</label></div>
            <div class="tdStyle1 tdFiveCol"><label>
                    <input 	type="text" 	readonly="1" size="5">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:duration/n2:years)" />
							</xsl:attribute>
						</input>
              <br />
              years</label></div>
            
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">           
            <div class="tdStyle1 tdThreeCol">(ii) Start Date of Penalty</div>
			<div class="tdStyle1 tdFourCol">
                     <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:startDate/n2:date)" />
							</xsl:attribute>
						</input></div>
            <div class="tdStyle1 tdFourCol"><label>
            <xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:startDate/n2:notDetermined) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <em>Not Determined</em></label></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">          
            <div class="tdStyle1 tdThreeCol">(iii) End Date of Penalty</div>
			<div class="tdStyle1 tdFourCol">
               <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:endDate/n2:date)" />
							</xsl:attribute>
						</input></div>
            <div class="tdStyle1 tdFourCol"><label>
              <xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:endDate/n2:notDetermined) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
             <em> Not Determined</em></label></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">(iv) Is  the sentence to be served concurrently with any other sentence?</div>
            <div class="tdStyle1 tditem10col2"><span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:concurrentEndDate) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:concurrentEndDate) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No</span></div><div style="margin-left:0; margin-right:0;"></div>
          </div>
		  <div style="clear:both"></div>
          
		  <div class="tableRow" id="crimsentenceYes" style="margin-left:0; margin-right:0;">
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">
			          If yes, indicate the end date of the concurrent sentence</div>
			<div class="tdStyle1 tdTwoCol2">
                <input 	type="text" 	readonly="1" size="10">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:concurrentEndDate)" />
							</xsl:attribute>
						</input></div>
             
          </div>
          <div style="clear:both"></div>
          <div class="hide tableRow" id="crimsentenceNo">
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">
			(v)  Explanation (Optional):  <br />
            <!-- 
                        <textarea name="textarea2" id="textarea21" cols="45" rows="2">
							<xsl:value-of
								select="string(n2:dispositionDisclosureDetail/n2:incarcerationInfo/n2:explanation)" />
							</textarea>
			-->
			<div class="fakeBox">
                        <xsl:value-of
                        select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:explanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
							
			</div>
            <div style="margin-left:0; margin-right:0;"></div>
            
          </div>
		  <div style="clear:both"></div>
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>(5) Monetary Penalty/Fine</strong></div>              
                   
            <div class="tdStyle1 tditem10col2"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty) &gt; 0 ">
							
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No </div>
          </div>
		  <div style="clear:both"></div>
        </div>
       
      
      <!-- END APPEAL DIV -->
        
		<div class="tableStyle" id="crimMonpenalty" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">Provide the following details in (ii) and (iii), (iv), and (v) below:</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(ii)  Total Penalty/Fine Amount:  </div>
            <div class="tdStyle1 tdTwoCol2" >
          
            <xsl:call-template name="format_to_dollar">
                    <xsl:with-param name="money" select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:totalFine)" />
                </xsl:call-template>
              <!--
            <input  type="text"     readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:totalFine)" />
                            </xsl:attribute>
                        </input>
                    -->
                        </div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
           
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">iii)  Was any portion suspended/reduced?   </div>            
            <div class="tdStyle1 tditem10col2"><span class="yesNo">
			<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount) &gt; 0 ">
							
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No </span></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
           
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">          How much? $</div>
            
            <div class="tdStyle1 tdTwoCol2"> 
            <xsl:call-template name="format_to_dollar">
                    <xsl:with-param name="money" select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount)" />
                </xsl:call-template>
            <!-- 
            <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount)" />
							</xsl:attribute>
						</input>
						 -->
						</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(iv) Final Amount: $</div>
           
            <div class="tdStyle1 tdTwoCol2">
             <xsl:call-template name="format_to_dollar">
                    <xsl:with-param name="money" select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:finalAmount)" />
                </xsl:call-template>
            <!--  
            <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:finalAmount)" />
							</xsl:attribute>
						</input>
			-->
			</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">(v) Was final amount paid in full?</div>         
          
            <div class="tdStyle1 tditem10col2"><span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:paidInFullDate) &gt; 0 ">
							
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:paidInFullDate) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No </span></div>
          </div>
		  <div style="clear:both"></div>
          
           <div class="hide tableRow" id="crimDate2" >
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">          If  Yes,date paid in full </div>
            
            <div class="tdStyle1 tdTwoCol2"><input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:paidInFullDate)" />
							</xsl:attribute>
						</input></div>
          </div>
          <div style="clear:both"></div>
           <div class="hide tableRow" id="crimUnpaid">
		   <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">         Amount unpaid: $</div>            
            <div class="tdStyle1 tdTwoCol2">
             <xsl:call-template name="format_to_dollar">
                    <xsl:with-param name="money" select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:notPaidInfo/n2:amountUNPAID)" />
                </xsl:call-template>
                <!-- 
            <input  type="text"     readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:notPaidInfo/n2:amountUNPAID)" />
                            </xsl:attribute>
                        </input>
                        -->
                        </div>
            </div>
			<div style="clear:both"></div>
            
			<div class="hide tableRow" id="crimUnpaid">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">          And explain the circumstances: $
            <br />
            <!-- 
            <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:notPaidInfo/n2:explanation)" />
							</xsl:attribute>
			</input>
			-->
                <div class="fakeBox">
                        <xsl:value-of
                        select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:notPaidInfo/n2:explanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
			</div>
          </div>
		  <div style="clear:both"></div>
        </div>
         </xsl:for-each>
        <div id="crimSum" class="hide">
          <h3>8. Summary of Circumstances</h3>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
				<div class="minutia tdStyle1 tdcrmlongtext">
              Use this space to provide a brief summary of the circumstances leading to the action, allegation(s), finding(s) and disposition(s), if any.  Include any relevant information on the current action status, and on any terms, conditions, and dates not already provided above, and any other relevant information.  The information must fit within the space provided.</div>
              <div style="margin-left:0; margin-right:0;"></div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdLabelStyle1" style="margin-left:0; margin-right:0;"><label>
              <!-- 
                <input type="text" rows="5"  cols="45">
					<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:summary)" />
							</xsl:attribute>
                </input>
               -->
				<div class="fakeBox">
                        <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:summary)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
              </label></div>
              <div style="margin-left:0; margin-right:0;"></div>
            </div>
			<div style="clear:both"></div>
          </div>
      </div>
        
     
     
     
      
	 </div>
</div>   
</xsl:otherwise>
</xsl:choose>

</xsl:for-each>
<!-- <br></br><br></br><h3>Associated Persons</h3>   -->
   <xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
	<xsl:choose>
		<xsl:when
			test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
		</xsl:when>
		<xsl:otherwise>
				
          <h2>CRIMINAL ACTION DRP - PART 2</h2>
	<div class="record hide dented" id="newCDRP">
		<h3>1. Firm or Organization </h3>
		<div class="tableStyle dented" style="margin-left:0; margin-right:0;">		
			<div clas="tableRow">
				<div class="tdStyle1 tdLabelStyle1 tditem10col1">
					<strong>
						<b>A.</b>
						Were
						<em> charge</em>
						(s) brought against a firm or organization over which the
						applicant or
						<em>associated person</em>
						exercise(s) (d)
						<em>control</em>
						?
					</strong>
				</div>
				<div class="tdStyle1 tditem10col2">
					<xsl:choose>
						<xsl:when
							test="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargesBroughtAgainstControlled )='Y' ">

							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />

						</xsl:otherwise>
					</xsl:choose>
					Yes
					<xsl:choose>
						<xsl:when
							test="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargesBroughtAgainstControlled ='N' ">

							<img src="Images/radio-checked.jpg" alt="radio button checked" />

						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />

						</xsl:otherwise>
					</xsl:choose>
					No
				</div>
			</div>
			<div style="clear:both"></div>
		</div>
		<div id="crimFirm">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div class="tableRow">
					<div class="tdStyle1 tdLabelStyle1 tditem10col1">
						<strong>
							<b>B.</b>
							If &quot;Yes&quot;, provide the following information:
						</strong>
					</div>

				</div>
				<div style="clear:both"></div>
				<div class="tableRow">

					<div class="tdStyle1 tdLabelStyle1 tditem10col1">          (1) Enter the firm or organization’s name</div>

				</div>
				<div style="clear:both"></div>
				<div class="tableRow">
					<div class="tdStyle1 tdLabelStyle1 tditem10col1">
						<!-- <input type="text" name="organizationName" readonly="1"> <xsl:attribute 
							name="value"> <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:name)" 
							/> </xsl:attribute> </input> -->
						<div class="fakeBox">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:name)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</div>


				</div>
				<div style="clear:both"></div>
			<div class="tableRow">
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">           (2) Was the firm or  organization engaged in a <em>municipal  advisor-related or investment-related </em> business?</div>
              <div class="tdStyle1 tditem10col2"><xsl:choose>  
              <xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:isEngagedInMARBusiness='Y' ">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
                Yes<xsl:choose>  
              <xsl:when
								test=" ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:isEngagedInMARBusiness='N' ">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
                No</div>
              </div>
			<div style="clear:both"></div>
            <div class="tableRow">
            
              <div style="width:100%;margin-left:0; margin-right:0;">          (3) What was the relationship of the applicant or the <em>associated person</em> with the firm or organization?  (Include any position or title with the firm  or organization.)</div>
             
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
           
              <div class="tdStyle1 tdLabelStyle1 tditem10col1">  
              <!-- 
              <input 	type="text" 	name="textfield6" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:relationshipToCharged)" />
							</xsl:attribute>
						</input>
					-->
					<div class="fakeBox">
                        <xsl:value-of
                       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:chargedControlInfo/n2:relationshipToCharged)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>	
			  </div>
              
              
              </div>
			  <div style="clear:both"></div>
          </div>
        </div>
        
        <h3>2. Court where Form <em>Charge</em>(s) were Brought:</h3>
        <p class="minutia"><strong><em>(File a separate Criminal Action DRP for charges brought in separate courts and/or separate cases in the same court. If brought in a foreign jurisdiction, provide all the information below in English.)</em></strong></p>
        <p class="minutia">(specify)</p>
         <!-- ////////////////////////////////// -->
         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:fedCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Federal Court<br/>
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:milCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Military Court<br/>
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:stateCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> State Court<br/>  
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:foreignCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Foreign Court<br/>  
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:intnlCourt)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> International Court <br/> 
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:criminalCourt/ns3:other)&gt; 0">
                                <img src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Other:<br/>
                        <!-- 
                        <input      type="text"     name="text49"   readonly="1">   
                        <xsl:attribute      name="value"> 
                        <xsl:value-of       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)" />
                </xsl:attribute>
                    </input>
                    -->
             <div class="fakeBox">
              
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:court/ns3:other)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
            <br/><br/>
            <!-- //////////////// -->
        
		<div class="tableStyle padded" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>A. Name of the Court :</strong></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">
            <!-- 
				 <input 	type="text" 		readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
							</xsl:attribute>
						</input>
			-->
			<div class="fakeBox">
                        <xsl:value-of
                      select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>  
            </div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>B. Location of the Court</strong></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdjudicialdrpcol1"><label>
              
               <input 	type="text" 		readonly="1" size="60">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street1)" />
							</xsl:attribute>
						</input>
              <br />
              <strong>Street Address 1</strong></label></div>
		  </div>
		  <div style="clear:both"></div>
		  <div class="tableRow">
            <div class="tdStyle1 tdjudicialdrpcol1"><label>
             
                 <input 	type="text" 	 	readonly="1" size="60">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street2)" />
							</xsl:attribute>
						</input>
              <br />
              <strong>Street Address 2</strong></label></div>
           </div>
		   <div style="clear:both"></div>
   
      </div>
  <div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div class="tableRow">
                   
			<div class="dented tdStyle1 tdjudicialdrpcol1">
                             <input 	type="text" 	 	readonly="1" size="45">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:city)" />
							</xsl:attribute>
						</input>
              <br />
              <strong>City or County</strong>
              </div>
            <div class="tdStyle1 tdjudicialdrpcol1">       
            <!-- 
            <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
							</xsl:attribute>
						</input>
			-->
			<div class="fakeBox"> 
                        <span >
                    <xsl:call-template name="stateDescription">
                        <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
                     </xsl:call-template>
                 </span>
                 <span>
                 <xsl:text>&#160;</xsl:text>
                 </span>
              </div>
              <br />
              <label><strong>State/Country</strong></label></div>
            <div class="tdStyle1 tdjudicialdrpcol1">
               <input 	type="text" 	name="postal code2" 	readonly="1" size="30">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:zipCode)" />
							</xsl:attribute>
						</input>
              <br />
              <strong>Postal Code</strong>
              </div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><p><strong>C. Docket/Case Number and Case Name:</strong><br />
            <!-- 
				 <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
							</xsl:attribute>
						</input>           
						-->
						<div class="fakeBox">
	                        <xsl:value-of
	                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
	                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div> 
						 </p></div>
          </div>
		  <div style="clear:both"></div>        
  </div>
        
        <h3>3. Event Disclosure Detail</h3> <span class="minutia">(use this for both organizational and individual <em>charges</em>): </span>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg"><b>A. Date First <em>Charged</em>(MM/DD/YYYY)</b>: <input 	type="text" 	 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:date)" />
							</xsl:attribute>
						</input>    </div>
            
            <div class="tdStyle1 tdTwoCol2"> 
						<xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:exact) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
              
              Exact
             	<xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:explanationInfo/n2:explanation) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
              Explanation </div>
           
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">If not exact, provide explanation<br />
            <!-- 
              <textarea name="explain5" id="explain5" cols="45" rows="2">
              
				
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/ns3:explanationInfo/n2:provideExplanation)" />
							
						
              </textarea>
              -->
              <div class="fakeBox">
                   <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:dateFirstCharged/n2:explanationInfo/n2:provideExplanation)" />
                   <span>
                        <xsl:text>&#160;</xsl:text>
                   </span>
                </div>
            </div>
            
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><b>B. Details of Event</b>: Report all <em>charges</em> separately.  For each <em>charge, </em>provide all of the following information.</div>
           
          </div>
		  <div style="clear:both"></div>
        </div>

        <!--good until here-->
		<div id="newCrimCharge" class="hide">
        
          <div class="boxed">
<xsl:for-each select="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:charges/ns3:charge">
            
			<div class="tableStyle dented" style="margin-left:0; margin-right:0;">
				<div class="tableRow">
					<div style="margin-left:0; margin-right:0;"></div>
					<div class="tdStyle1 tdLabelStyle1 tditem10col1"><b>(1) <em>Charge</em></b></div>
                   <div style="margin-left:0; margin-right:0;"></div>
				</div>
				<div style="clear:both"></div>
				<div class="tableRow">
				   <div style="margin-left:0; margin-right:0;"></div>
					<div class="tdStyle1 tdLabelStyle1 tditem10col1">(a) List the <em>charge/charge</em> description:</div>
							 <div style="width:100%;margin-left:0; margin-right:0;">
							 <!-- 
						 <input     type="text"         readonly="1">
								<xsl:attribute
										name="value">
								<xsl:value-of
									select="string(n2:baseInformation/n2:charge)" />
								</xsl:attribute>
							</input> 
						-->
						 <div class="fakeBox">
							<xsl:value-of
									select="string(ns3:baseInformation/n2:charge)" />
							 <span>
							<xsl:text>&#160;</xsl:text>
						  </span>
						</div>   
					</div>
				</div>
				<div style="clear:both"></div>
				<div class="tableRow">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg"> (b) Number of Counts: </div>
                <div class="tdStyle1 tdTwoCol2">
                             <input     type="text"         readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:baseInformation/n2:numberOfCounts)" />
                            </xsl:attribute>
                        </input>  
                </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(c) Check  the applicable box: </div>
                <div class="tdStyle1 tdTwoCol2">
                  
                    <xsl:choose>  
              <xsl:when
                                test=" count(ns3:baseInformation/n2:felonyOrMisdemeanor/n2:felony) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>  
                  <em>Felony</em>
                        <xsl:choose>  
              <xsl:when
                                test=" count(ns3:baseInformation/n2:felonyOrMisdemeanor/n2:misdemeanor) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose> 
                  <em>Misdemeanor</em></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(d) Plea for this <em>Charge</em></div>
                <div class="tdStyle1 tdTwoCol2">
                <!-- 
                     <input     type="text"         readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(n2:baseInformation/n2:plea)" />
                            </xsl:attribute>
                        </input> 
                        -->
                        <div class="fakeBox">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:plea)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>    
                </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="tableRow">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(e) (i) Is  the <em>charge municipal advisor-related?</em></div>               
                <div class="tdStyle1 tdTwoCol2">         <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;">               <xsl:choose>  
              <xsl:when
                                test=" count(ns3:baseInformation/n2:productType) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />Yes<img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />                  No
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes<img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />                  No
                                    
                            </xsl:otherwise>
                        </xsl:choose> 
</div></div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="hide tableRow" id="crimMAProd">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(e) (ii) If, &quot;Yes,&quot; what is the product type?</div>
                <div class="tdStyle1 tdTwoCol2">
                <!--         
                <input  type="text"         readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(n2:baseInformation/n2:productType)" />
                            </xsl:attribute>
                        </input>
                -->
                    <div class="fakeBox">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:productType)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>      
                </div>
				<div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			   <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(f) (i) Is  the <em>charge investment-related?</em></div>               

                <div style="margin-left:0; margin-right:0;">  
				<div class="tdStyle1 tdTwoCol2">      
                <xsl:choose>  
                  <xsl:when
                                test=" count(ns3:baseInformation/n2:investmentProductType) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />Yes<img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes<img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />No
                                    
                            </xsl:otherwise>
                        </xsl:choose> 
                </div>
				</div>
				<div style="margin-left:0; margin-right:0;"></div>
              </div>
              <div style="clear:both"></div>
			  <div class="hide tableRow" id="crimIRProd" >
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(f) (ii) If, &quot;Yes,&quot; what is the product type?</div>
                <div class="tdStyle1 tdTwoCol2"> 
                <!-- 
                  <input    type="text"         readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(n2:baseInformation/n2:investmentProductType)" />
                            </xsl:attribute>
                        </input>
                        -->
                        <div class="fakeBox">
                        <xsl:value-of
                                select="string(ns3:baseInformation/n2:investmentProductType)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>  
                    </div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="tableRow">
                <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(g) (i) Amended <em>Charge</em>:   Indicate if the original <em>charge</em> was amended or reduced:</div>               
                <div style="margin-left:0; margin-right:0;">
				<div class="tdStyle1 tdTwoCol2"><xsl:choose>  
                            <xsl:when
                                test=" count(ns3:baseInformation/n2:amendedReducedDate) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>
                  Yes<xsl:choose>   <xsl:when
                                test=" count(ns3:baseInformation/n2:amendedReducedDate) &gt; 0">
                                        
                                        <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:when>
                            <xsl:otherwise>
                            
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:otherwise>
                        </xsl:choose> 
                  No</div></div><div style="margin-left:0; margin-right:0;"></div>
              </div>
			  <div style="clear:both"></div>
			  <div class="hide tableRow" id="crimamendDate">
               <div style="margin-left:0; margin-right:0;"></div>
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(g) (ii)Provide the date the <em>charge</em> was amended or reduced </div>
                <div class="tdStyle1 tdTwoCol2"> <input    type="text"         readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:baseInformation/n2:amendedReducedDate)" />
                            </xsl:attribute>
                        </input></div>
				<div style="margin-left:0; margin-right:0;"></div>
              </div>
			 </div> <!--tableStyle-->
             </xsl:for-each>
			 
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg"><strong><b>C.<em> Felony Charge</em>(s): </b> </strong></div>
              </div>
              <div class="tableRow">
                
                <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">          Did any of the <em>charge</em>(s) within the event involve a <em>felony</em>?</div>
                <div style="margin-left:0; margin-right:0;">
				<div class="tdStyle1 tdTwoCol2">
						<xsl:choose>
              			<xsl:when
                        test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:charges/n2:charge/n2:baseInformation/n2:felonyOrMisdemeanor/n2:felony) &gt; 0">
                           <img
                           src="Images/radio-checked.jpg" alt="radio button checked" />
                     </xsl:when>
                     <xsl:otherwise>
                        <img
                           src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                     </xsl:otherwise>
                  </xsl:choose>
                  Yes
              		<xsl:choose>
              			<xsl:when
                        test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:charges/n2:charge/n2:baseInformation/n2:felonyOrMisdemeanor/n2:misdemeanor) &gt; 0">
                              <img
                           src="Images/radio-checked.jpg" alt="radio button checked" />
                     </xsl:when>
                     <xsl:otherwise>
                           <img
                           src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                     </xsl:otherwise>
                  </xsl:choose>
                  No
              </div>
				 </div>
              </div>
            </div>
			 
			 <!--end tag-->
			</div> <!--boxed-->
         
        </div> <!--newCrimCharge-->

		<!--good until here2-->
        
        <h3>4. Current Status of the event?</h3>
        <p class="dented">
          <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:status/n1:pending) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
          Pending
  <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:status/n1:onAppeal) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
          On Appeal
  <xsl:choose>  
              <xsl:when
								test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:status/n1:final) &gt; 0">
										
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>  
          Final</p>
         
        <h3>5. Event Status Date
        </h3><span class="minutia">(Complete unless status is pending)(MM/DD/YYYY):</span>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
             <div class="tdStyle1 tdLabelStyle1 tditem10col1">
			 <input     type="text"         readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:date)" />
                            </xsl:attribute>
                        </input>  
                        <xsl:choose> 
                <xsl:when
                                test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:exact ) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>  
              Exact
             <xsl:choose>  
              <xsl:when
                                test=" count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:explanationInfo/n2:explanation) &gt; 0">
                                        
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>  
              Explanation </div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">If not exact, provide explanation<br />
                          
              <div class="fakeBox">
                        <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:statusDateInfo/n2:explanationInfo/n2:provideExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
              
              </div>
          </div>
		  <div style="clear:both"></div>
        </div>
        <p class="minutia">(Complete unless status is pending)</p>
         
       <div id="crimAppeal" class="hide">
         <h3>6. On Appeal – Judicial Review:</h3>
        <p class="minutia"><strong>If Item 4 On Appeal is checked, to whom was the criminal action appealed?  <em>(If brought in a foreign jurisdiction, provide all the information below in English.)</em></strong></p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          
		  <div class="hide tableRow" id="crimamendDate">
            <div style="width:100%;margin-left:0; margin-right:0;"><p>

            <xsl:choose>
                        <xsl:when
                            test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:fedCourt) &gt; 0 ">
                            <img
                                src="Images/radio-checked.jpg" alt="radio button checked" />
                                  
                        </xsl:when>
                        <xsl:otherwise>
                            <img
                                src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                        
            </xsl:choose>
              
              Federal Court 
              <br />
               <xsl:choose>
                        <xsl:when
                            test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:milCourt) &gt; 0 ">
                            <img
                                src="Images/radio-checked.jpg" alt="radio button checked" />
                                  
                        </xsl:when>
                        <xsl:otherwise>
                            <img
                                src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                        
            </xsl:choose>
            Military Court <br />
               <xsl:choose>
                        <xsl:when
                            test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:stateCourt) &gt; 0 ">
                            <img
                                src="Images/radio-checked.jpg" alt="radio button checked" />
                                  
                        </xsl:when>
                        <xsl:otherwise>
                            <img
                                src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                        
            </xsl:choose>
              State Court <br />
              <xsl:choose>
                        <xsl:when
                            test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:foreignCourt) &gt; 0 ">
                            <img
                                src="Images/radio-checked.jpg" alt="radio button checked" />
                                  
                        </xsl:when>
                        <xsl:otherwise>
                            <img
                                src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                        
            </xsl:choose>
              Foreign Country Court <br />
              <xsl:choose>
                        <xsl:when
                            test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:intnlCourt) &gt; 0 ">
                            <img
                                src="Images/radio-checked.jpg" alt="radio button checked" />
                                  
                        </xsl:when>
                        <xsl:otherwise>
                            <img
                                src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                        
            </xsl:choose>
              International Court<br />
               <xsl:choose>
                        <xsl:when
                            test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:other) &gt; 0 ">
                            <img
                                src="Images/radio-checked.jpg" alt="radio button checked" />
                                  
                        </xsl:when>
                        <xsl:otherwise>
                            <img
                                src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                        
            </xsl:choose>
              Other (specify):
               <xsl:choose>
						<xsl:when
							test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:other) &gt; 0 ">
							<!-- 
                         <input 	type="text" 	name="court type" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:criminalCourt/ns3:other)" />
							</xsl:attribute>
						</input>  
						-->
						 <div class="fakeBox">
                                    <xsl:value-of
                                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedTo/ns3:other)" />
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                               </div>
							</xsl:when>
						<xsl:otherwise>
						 <input 	type="text" 	name="court type" 	readonly="1"></input>
						 	</xsl:otherwise>
						
			         </xsl:choose>
						 
                </p>
              </div>
          </div>
          
          <div class="tableRow"> 		
			<div align="left" class="tdStyle1 tdLabelStyle1 tditem10col1"><label>
                  <input 	type="text" 	name="court type" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:appealedToCourtName)" />
							</xsl:attribute>
						</input>  
              <br />
                 <strong>Provide the name of the court</strong></label></div>
          </div>
		  <div style="clear:both"></div>

          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1" >   <input 	type="text" 	name="court type" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:actionAppealedTo/ns3:date)" />
							</xsl:attribute>
						</input>  
              <br />
                <strong>Date Appeal Filed (MM/DD/YYYY):</strong></div>
          </div>
		  <div style="clear:both"></div>

      
        </div>
         <p><b>For Item 7: </b><span class="minutia"><strong>If  Item 4 Final or On Appeal is checked, complete Item 7. For Pending Actions, skip to Item 8.</strong></span></p>
        <h3>7. Disposition Disclosure Detail</h3>
        <p><span class="checkbox"><span class="minutia"><strong>(For each <em>charge</em> provide the following information):</strong> </span></span></p>
         <xsl:for-each select="ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:charges/ns3:charge">
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
		  <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">
            <strong><strong>(a)</strong> First <em>Charge</em></strong></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div class="checkbox tdStyle1 tdLabelStyle1 tditem10col1">(1) <strong>Disposition of the <em>Charge</em> (Check all that apply to this <em>charge</em>.</strong>)</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							 test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Acquitted']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Acquitted</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pled guilty']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Pled Guilty</div>
            </div>
			<div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Amended']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Amended </div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pled nolo contendere']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Pled  nolo contendere</div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Convicted']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Convicted</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pled not guilty']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Pled not guilty</div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Deferred Adjudication']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Deferred Adjudication </div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Pre-trial diversion/intervention']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Pretrial diversion/intervention </div>
            </div>
		  <div style="clear:both"></div>	
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Dismissed']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Dismissed</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Reduced']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Reduced</div>
            
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Found not guilty']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <em>Found</em> not guilty</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
Other (specify):
  <xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:type='Other']) &gt; 0 ">
						<!-- 
	               <input 	type="text" 	name="textfield31" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:dispositionDisclosureDetail/n2:dispositionType/n2:otherDisp)" />
							</xsl:attribute>
						</input> 
						-->
						<div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:dispositionDisclosureDetail/ns3:dispositionType/ns3:otherDisp)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>  
					</xsl:when>
						<xsl:otherwise>
						  <input 	type="text" 	name="textfield31" 	readonly="1"></input>
				  </xsl:otherwise>
						
			</xsl:choose>
  </div>
            </div>
		<div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
						test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Affirmed']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>Appealed</div>
            <div style="margin-left:0; margin-right:0;"></div>
           
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Affirmed']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Affirmed</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Vacated / Final']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Vacated / Final</div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Vacated &amp; Returned For Further Action']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Vacated &amp; Returned For Further Action</div>
            <div class="checkbox tdStyle1 tdLabelStyle1 td3cols"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:dispositionType[ns3:appealType='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Other (specify):
              <!--                 
					<input 	type="text" 	name="textfield60" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(n2:dispositionDisclosureDetail/n2:dispositionType/n2:otherAppeal)" />
							</xsl:attribute>
						</input> 
			 -->
			    <div class="fakeBox">
                        <xsl:value-of
                                select="string(ns3:dispositionDisclosureDetail/ns3:dispositionType/ns3:otherAppeal)" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>  
                
                
                </div>
            </div>
			<div style="clear:both"></div>
            
			<div class="tableRow">
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="checkbox tdStyle1 tditem10col1"><p>Explanation: <br /><span class="minutia">
            <em>If more  than one disposition is checked, and/or Other is checked, or the above  otherwise does not adequately summarize the disposition of the charge, provide  an explanation. </em></span></p>
              <p><em>
              <!-- 
                   <textarea name="textarea4" id="textarea4" cols="45" rows="5">
				 
				<xsl:value-of
						select="string(n2:dispositionDisclosureDetail/n2:dispositionType/n2:explanation)" />
				
              </textarea>
             -->
             <div class="fakeBox">
                   <xsl:value-of
                       select="string(n2:dispositionDisclosureDetail/n2:dispositionType/n2:explanation)" />
                   <span>
                        <xsl:text>&#160;</xsl:text>
                   </span>
                </div>
              </em></p></div>
            </div>
			<div style="clear:both"></div>
          <div class="tableRow">
           
            <div class="tdStyle1 tditem10col1"><strong>(2) Date (MM/DD/YYYY):</strong></div>
            <div style="margin-left:0; margin-right:0;"></div>
           
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div class="tdStyle1 tditem10col1"><input 	type="text" 	name="textfield60" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:date)" />
							</xsl:attribute>
						</input> </div>
            <div style="margin-left:0; margin-right:0;"></div>
           
          </div>
		  <div style="clear:both"></div>
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>(3) Sentence/Penalty:</strong></div>        
            <div style="margin-left:0; margin-right:0;"></div>   
          </div>
          
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">          <strong>Is a sentence or other penalty ordered?</strong></div>            
            <div class="tdStyle1 tditem10col2">
            
            <span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:sentencePenaltyType) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <strong>Yes</strong><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:sentencePenaltyType) &gt; 0">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <strong>No</strong>
            </span>
            
            </div>
          </div></div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="hide tableRow" id="crimPenalty">		  
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">          List each type (e.g., prison, jail, probation, community service, counseling, education, other - specify):<br />
                       <textarea name="textarea20" id="textarea20" cols="45" rows="2"></textarea></div>            
			</div>
          </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1"><strong>(4) Is there an incarceration in connection with this sentence?</strong></div>
            <div class="tdStyle1 tditem10col2">  <span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo) &gt; 0">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <strong>Yes</strong><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              <strong>No</strong>
            
            </span>
            </div>      
          </div>
		  <div style="clear:both"></div>
      </div>
        
	  <div class="tableStyle" id="crimIncar" style="margin-left:0; margin-right:0;">
          <div class="tableRow">          
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">If &quot;Yes&quot;, provide the following details:</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">           
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">(i) Duration (length of any sentence)</div>
          </div>
          <div class="tableRow">           
            <div class="tdStyle1 tdFiveCol"><label>
                        <input 	type="text"  size="5"	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:duration/n2:days)" />
							</xsl:attribute>
						</input>
              <br />
                        days</label></div>
            <div class="tdStyle1 tdFiveCol"><label>
               <input 	type="text" 	size="5" readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:duration/n2:months)" />
							</xsl:attribute>
						</input>
              <br />
              months</label></div>
            <div class="tdStyle1 tdFiveCol"><label>
                    <input 	type="text" size="5" readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:duration/n2:years)" />
							</xsl:attribute>
						</input>
              <br />
              years</label></div>
            <div style="margin-left:0; margin-right:0;"></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">           
            <div class="tdStyle1 tdThreeCol">(ii) Start Date of Penalty (MM/DD/YYYY):</div>
			<div class="tdStyle1 tdFourCol">
                     <input 	type="text" 	size="10" readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:startDate/n2:date)" />
							</xsl:attribute>
						</input></div>
            <div class="tdStyle1 tdFourCol"><label>
            <xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:startDate/n2:notDetermined) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Not Determined</label></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">          
            <div class="tdStyle1 tdThreeCol">(iii) End Date of Penalty (MM/DD/YYYY):</div><div class="tdStyle1 tdFourCol">
               <input 	type="text" size="10"	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:endDate/n2:date)" />
							</xsl:attribute>
						</input></div>
            <div class="tdStyle1 tdFourCol"><label>
              <xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:endDate/n2:notDetermined) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
             Not Determined</label></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
           
            <div class="tdStyle1 tdThreeCol">(iv) Is  the sentence to be served concurrently with any other sentence?</div>
            <div class="tdStyle1 tdFourCol"><span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:concurrentEndDate) &gt; 0 ">
							<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:concurrentEndDate) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No</span></div>
			  <div style="margin-left:0; margin-right:0;"></div>
          </div>
		  <div style="clear:both"></div>
          
		 <div class="hide tableRow" id="crimsentenceYes">
         <div class="tdStyle1 tdThreeCol"> End date of the concurrent sentence (MM/DD/YYYY):</div>
		 <div class="tdStyle1 tdFourCol">
                <input 	type="text" size="10"	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:concurrentEndDate)" />
							</xsl:attribute>
						</input></div>
             
          </div>
		  <div style="clear:both"></div>
          
          <div class="hide tableRow" id="crimsentenceNo"> 
            <div class="tdStyle1 tdThreeCol">(v)  Explanation (Optional):  <br />
            
			<div class="fakeBox">
                   <xsl:value-of
                       select="string(ns3:dispositionDisclosureDetail/ns3:incarcerationInfo/ns3:explanation)" />
                   <span>
                        <xsl:text>&#160;</xsl:text>
                   </span>
                </div>
							</div>
            <div style="margin-left:0; margin-right:0;"></div>
            
          </div>
		  <div style="clear:both"></div>
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
           
            <div class="tdStyle1 tdThreeCol"><strong>(5) Monetary Penalty/Fine:</strong></div>              
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">         
          <div class="tdStyle1 tdThreeCol">
          (i)   Was a monetary penalty/fine imposed?  
          </div>
            <div class="tdStyle1 tdFourCol"><span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty) &gt; 0 ">
							
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No </span></div>
          </div>
        </div>
       
      
      <!-- END APPEAL DIV -->
        
		<div class="tableStyle" id="crimMonpenalty" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">Provide the following details:</div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(ii)  Total Penalty/Fine Amount:  </div>
            <div class="tdStyle1 tdTwoCol2">
            <xsl:call-template name="format_to_dollar">
                    <xsl:with-param name="money" select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:totalFine)" />
                </xsl:call-template>
            <!--
            <input  type="text"     readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:totalFine)" />
                            </xsl:attribute>
                        </input>
                -->
                        </div>
            </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
           
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tditem10col1">(iii)  Was any portion suspended/reduced?   </div>            
            <div class="tdStyle1 tdTwoCol2"><span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount) &gt; 0 ">
							
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No</span></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
           
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">          If &quot;Yes,&quot; how much?</div>
            
            <div style="margin-left:0; margin-right:0;"> <input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:reducedAmount)" />
							</xsl:attribute>
						</input></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(iv) Final Amount: $</div>
           
            <div class="tdStyle1 tdTwoCol2"><input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:finalAmount)" />
							</xsl:attribute>
						</input></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
            <div style="clear:both"></div>
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">(v) Was final amount paid in full?</div>         
          
            <div class="tdStyle1 tdTwoCol2"><span class="yesNo"><xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:paidInFullDate) &gt; 0 ">
							
								<img
								src="Images/radio-checked.jpg" alt="radio button checked" />  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
              Yes<xsl:choose>
						<xsl:when
							test="count(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:paidInFullDate) &gt; 0 ">
							<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
								src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:otherwise>
						
			</xsl:choose>
              No</span></div>
          </div>
		  <div style="clear:both"></div>
          
          <div class="hide tableRow" id="crimDate2"> 
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">          
			If  &quot;Yes,&quot;date paid in full (MM/DD/YYYY):</div>
            
            <div class="tdStyle1 tdTwoCol2">
			<input 	type="text" size="10"	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:paidInFullDate)" />
							</xsl:attribute>
						</input></div>
          </div>
          <div style="clear:both"></div>
          <div class="hide tableRow" id="crimUnpaid"> 
            <div style="margin-left:0; margin-right:0;"></div>
            <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">          Amount unpaid: $</div>            
            <div class="tdStyle1 tdTwoCol2">
			<input 	type="text" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:notPaidInfo/n2:amountUNPAID)" />
							</xsl:attribute>
						</input></div>
          </div>
		  <div style="clear:both"></div>
          <div class="tableRow">
          <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg"> 
          And explain the circumstances:
          </div></div>
                                 
			<div class="hide tableRow" id="crimexplain22">
              <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg"><br />
              <!-- 
                <textarea name="textarea4" id="textarea4" cols="52" rows="5">
				
				<xsl:value-of
						select="string(ns3:applicantInfo/ns3:header/ns3:drpRemoveReason/n2:isFiledError/n2:explainTheCircumstances)" />
				
              </textarea>
              -->
              <div class="fakeBox">
                   <xsl:value-of
                      select="string(ns3:dispositionDisclosureDetail/ns3:monetaryPenalty/n2:paidStatus/n2:notPaidInfo/n2:explanation)" />
                   <span>
                        <xsl:text>&#160;</xsl:text>
                   </span>
                </div>
              </div>
            </div>
			<div style="clear:both"></div>
        </div>
         </xsl:for-each>
        <div id="crimSum" class="hide">
          <h3>8. Summary of Circumstances  </h3>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
			  <div style="width:90%; margin-left:0; margin-right:0;" class="minutia">
					Use this space to provide a brief summary of the circumstances leading to the action, allegation(s), finding(s) and disposition(s), if any.  Include any relevant information on the current action status, and on any terms, conditions, and dates not already provided above, and any other relevant information.  The information must fit within the space provided.</div>
              <div style="margin-left:0; margin-right:0;"></div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdLabelStyle1 tdCol1Lrg">
             <!-- 

                <textarea name="textarea4" id="textarea4" cols="52" rows="5">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:summary)" />
                </textarea>
                -->
				<div class="fakeBox">
                   <xsl:value-of
                      select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:eventDRP/ns3:event/ns3:baseInformation/n2:summary)" />
                   <span>
                        <xsl:text>&#160;</xsl:text>
                   </span>
                </div>
              </div>
              <div style="margin-left:0; margin-right:0;"></div>
            </div>
          </div>
      </div>
        
     
     
     
      
	 </div>
</div>  
</xsl:otherwise>
</xsl:choose> 
</xsl:for-each>
</div></div></div>   
   </xsl:for-each>
</xsl:template>

</xsl:stylesheet>