<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler"	>
	
	
	
	<!-- Item 6 templates -->
	
<xsl:template name="Item6" >
<link href="style.css" rel="stylesheet" type="text/css" />
<link href="MAI_print.css" rel="stylesheet" type="text/css" />
<div id="maiItem6">
  <div class="contentwrapper">
    <div class="content">
      <h1>Item 6 Disclosure Information</h1>
      <div class="form1">
         <p>IF THE ANSWER TO ANY OF THE QUESTIONS IN ITEMS 6A &#8211; 6J AND 6M IS &quot;YES,&quot; PROVIDE DETAILS OF ALL EVENTS OR <em>PROCEEDINGS</em> ON THE APPROPRIATE DISCLOSURE REPORTING PAGES (DRPs).</p>
        
        <p><em>One event or <em>proceeding</em> may result in the requirement to answer &quot;Yes&quot; 
         to more than one question below.</em></p>
        
        <p><em>Refer to the Glossary of Terms for definitions or descriptions of italicized terms.</em></p>
        
        <h2>CRIMINAL ACTION DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to any question below in Item 6A or 6B, 
         complete a <strong>Criminal Action DRP</strong>.</em></p>
        <h3>Item 6A.</h3>
        <p>(1) Has the individual ever:</p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(a) been convicted of any <em>felony</em>, or pled 
             guilty or nolo contendere (&quot;no contest&quot;) to any <em>charge</em> 
              of a <em>felony</em> in a domestic, foreign, or military court?</div>
           <div class="tdStyle1 tditem10col2">             
              	
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion/ns2:isConvictedOfFelony = 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion/ns2:isConvictedOfFelony = 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							
							</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO
				              
            </div>
          </div>
         <div style="clear:both"></div>
         </div>
          <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(b) been <em>charged</em> with any <em>felony</em>?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion/ns2:isChargedWithFelony = 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion//ns2:isChargedWithFelony = 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							
							</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO
				              </div>
          </div>
         <div style="clear:both"></div>
         </div>
        		
        <p>(2) Based upon activities that occurred while the individual exercised 
        <em>control</em> over it, has an organization ever: </p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(a) been convicted of any <em>felony</em> or pled guilty or nolo contendere 
            (&quot;no contest&quot;) in a domestic or foreign court to any <em>charge</em> 
            of a <em>felony?</em></div>
           <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion/ns2:isOrgConvictedOfFelony= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion//ns2:isOrgConvictedOfFelony= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(b) been <em>charged</em> with any <em>felony?</em></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion/ns2:isOrgChargedWithFelony= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:criminalDisclosureCommonQuestion//ns2:isOrgChargedWithFelony= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							
							</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h3>Item 6B.</h3>
        <p>(1) Has the individual ever: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(a) been convicted of any <em>misdemeanor</em> 
             or pled guilty or nolo contendere (&quot;no contest&quot;) in a domestic, 
             foreign or military court to any <em>charge</em> of a <em>misdemeanor involving: 
             municipal advisory activities</em> or a <em>municipal advisor-related</em> or 
             <em>investment-related</em> business or any fraud, false statements or omissions, 
             wrongful taking of property, bribery, perjury, forgery, counterfeiting, extortion, 
             or a conspiracy to commit any of these offenses?</p></div>
            <div class="tdStyle1 tditem10col2"> <xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isConvictedOfMisdemeanor= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isConvictedOfMisdemeanor= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							
							</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">
            <p>(b) been <em>charged</em> with any <em>misdemeanor</em> of the kind described 
             in 6B(1)(a)?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isChargedWithMisdemeanor= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isChargedWithMisdemeanor= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							
							</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        (2) Based upon activities that occurred while the individual exercised 
         <em>control</em> over it, has an organization ever:
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">
            (a) been convicted of any <em>misdemeanor</em> or pled guilty or nolo 
            contendere (&quot;no contest&quot;) in a domestic or foreign court to 
            any <em>charge</em> of a <em>misdemeanor</em> of the kind specified in 6B(1)(a)? </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isOrgConvictedOfMisdemeanor= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isOrgConvictedOfMisdemeanor= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							
							</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">
            (b) been <em>charged</em> with any <em>misdemeanor</em> of the kind 
            specified in 6B(1)(a)?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isOrgChargedWithMisdemeanor= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:criminalDisclosure/n2:isOrgChargedWithMisdemeanor= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>REGULATORY ACTION DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to any question below in Items 6C-6G(1), 
        complete a <strong>Regulatory Action DRP</strong>.</em></p>
        <h3>Item 6C.</h3>
        <p>Has the <em>SEC</em> or the <em>CFTC</em> ever: </p>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(1) <em>found</em> the individual to have made a false statement 
             or omission?</p></div>
            <div class="tdStyle1 tditem10col2"> <xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isMadeFalseStatement= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isMadeFalseStatement= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(2) <em>found</em> the individual to have 
            been <em>involved</em> in a violation of any <em>SEC</em> or <em>CFTC</em> 
            regulation or statute?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isViolatedRegulation= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isViolatedRegulation= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(3) <em>found</em> the individual to have been a 
             cause of a denial, suspension, revocation, or restriction of the authorization 
             of a <em>municipal advisor-related</em> business or <em>investment-related</em> 
             business to operate?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isCauseOfDenial= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isCauseOfDenial= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(4) entered an <em>order</em> against the individual in connection with 
             <em>municipal advisor-related</em> or <em>investment-related</em> activity?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isOrderAgainst= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isOrderAgainst= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(5) imposed a civil money penalty on the individual, or <em>ordered</em> 
             the individual to cease and desist from any activity?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isImposedPenalty= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isImposedPenalty= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(6) <em>found</em> the individual to have willfully violated 
             any provision of the Securities Act of 1933, the Securities Exchange Act of 1934, 
             the <em>Investment Advisers Act</em> of 1940, the Investment Company Act of 1940, 
             the <em>Commodity Exchange Act</em>, or any rule or regulation under any of such 
             Acts, or any of the rules of the <em>MSRB</em>, or <em>found</em> the individal to have been 
             unable to comply with any provision of such Acts, rules or regulations?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isViolatedSecurityAct= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isViolatedSecurityAct= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(7) <em>found</em> the individual to have willfully aided, 
             abetted, counseled, commanded, induced, or procured the violation by any 
             <em>person</em> of any provision of the Securities Act of 1933, the 
             Securities Exchange Act of 1934, the <em>Investment Advisers Act</em> of 1940, 
             the Investment Company Act of 1940, the <em>Commodity Exchange Act</em>, or 
             any rule or regulation under any of such Acts, or any of the rules of the 
             <em>MSRB</em>?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isWillFullyAided= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isWillFullyAided= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(8) <em>found</em> the individual to have failed reasonably 
             to supervise another <em>person</em> subject to his or her supervision, with a view to 
             preventing the violation of any provision of the Securities Act of 1933, the 
             Securities Exchange Act of 1934, the <em>Investment Advisers Act</em> of 1940, 
             the Investment Company Act of 1940, the <em>Commodity Exchange Act</em>, or any 
             rule or regulation under any of such Acts, or any of the rules of the 
             <em>MSRB</em>?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isFailedToSupervise= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isFailedToSupervise= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h3>Item 6D.</h3>
        <p>(1) Has any other <em>federal regulatory agency</em> or any <em>state regulatory agency</em> 
         or <em>foreign financial regulatory authority</em> ever: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(a) <em>found</em> the individual to have made a false statement or 
            omission or to have been dishonest, unfair or unethical? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isUnEthical= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isUnEthical= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(b) <em>found</em> the individual to have been 
             <em>involved</em> in a violation of <em>municipal advisor-related</em> 
             or <em>investment-related</em> regulation(s) or statute(s)? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInViolationOfRegulation= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInViolationOfRegulation= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(c) <em>found</em> the individual to have been a cause of a denial, 
             suspension, revocation, or restriction of the authorization of a 
             <em>municipal advisor-related</em> or <em>investment-related</em> 
             business to operate?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInCauseOfDenial= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInCauseOfDenial= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(d) entered an <em>order</em> against the individual in connection 
            with a <em>municipal advisor-related</em> or <em>investment-related</em> activity? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isOrderAgainstActivity= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isOrderAgainstActivity= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(e) denied, suspended, or revoked the individual's 
            registration or license or otherwise, by <em>order,</em> prevented the individual from 
            associating with a 
            <em>municipal advisor-related</em> or <em>investment-related</em> business or 
            restricted his or her activities?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isDeniedLicense= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isDeniedLicense= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <p>(2) Has the individual ever been subject to any final <em>order</em> of a state 
        securities commission (or any agency or office performing like functions), 
        a state authority that supervises or examines banks, savings associations, 
        or credit unions, a state insurance commission (or any agency or office 
        performing like functions), a <em>federal banking agency,</em> or the 
        National Credit Union Administration, that: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(a) bars the individual from association with an entity regulated by 
            such commission, authority, agency, or office, or from engaging in the business 
            of securities, insurance, banking, savings association activities, or credit union 
            activities; or</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isAssociationBared= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isAssociationBared= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(b) is based on violations of any laws or regulations that 
            prohibit fraudulent, manipulative, or deceptive conduct?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isFinalOrder= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isFinalOrder= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked"/>
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h3>Item 6E.</h3>
        <p>Has any <em>self-regulatory organization</em> or commodities exchange ever: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(1) <em>found</em> the individual to have made a false 
            statement or omission? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundMadeFalseStatement= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundMadeFalseStatement= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(2) <em>found</em> the individual to have been <em>involved</em> 
             in a violation of its rules (other than a violation designated as a 
             <em>&quot;minor rule violation&quot;</em> under a plan approved by 
             the <em>SEC</em>)?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInViolationOfRules= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="
								n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInViolationOfRules= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(3) <em>found</em> the individual to have been a cause of a 
             denial, suspension, revocation, or restriction of the authorization of a 
             <em>municipal advisor-related</em> or <em>investment-related</em> business to 
             operate? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInCauseOfSuspension= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isFoundInCauseOfSuspension= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(4) disciplined the individual by expelling or suspending him or her 
             from membership, barring or suspending the individual's association with its members, or 
             restricting the individual's activities? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isDiscipliend= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isDiscipliend= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(5) <em>found</em> the individual to have willfully violated 
             any provision of the Securities Act of 1933, the Securities Exchange Act of 1934, 
             the <em>Investment Advisers Act</em> of 1940, the Investment Company Act of 1940, 
             the <em>Commodity Exchange Act</em>, or any rule or regulation under any of such 
             Acts, or any of the rules of the <em>MSRB</em>, or <em>found</em> the individual to have been 
             unable to comply with any provision of such Acts, rules or regulations? </p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isWillFullyViolatedSecurityAct= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isWillFullyViolatedSecurityAct= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(6) <em>found</em> the individual to have willfully aided, abetted, 
            counseled, commanded, induced, or procured the violation by any <em>person</em> 
            of any provision of the Securities Act of 1933, the Securities Exchange Act of 
            1934, the <em>Investment Advisers Act</em> of 1940, the Investment Company Act 
            of 1940, the <em>Commodity Exchange Act</em>, or any rule or regulation under 
            any of such Acts, or any of the rules of the <em>MSRB</em>?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isWillFullyAided= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isWillFullyAided= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1"><p>(7) <em>found</em> the individual to have failed reasonably 
            to supervise another <em>person</em> subject to your supervision, with a view to preventing 
            the violation of any provision of the Securities Act of 1933, the 
            Securities Exchange Act of 1934, the <em>Investment Advisers Act</em> of 1940, 
            the Investment Company Act of 1940, the <em>Commodity Exchange Act</em>, or 
            any rule or regulation under any of such Acts, or any of the rules of the 
            <em>MSRB</em>?</p></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isFailedResonably= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:isFailedResonably= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h3>Item 6F. </h3>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">Has the individual ever had an authorization to act as an 
            attorney, accountant or federal contractor that was revoked or suspended?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isAuthorizedToActAttorney= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isAuthorizedToActAttorney= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h3>Item 6G.</h3>
        <p>Has the individual been notified, in writing, that he or she is currently 
        the subject of any: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(1) regulatory complaint or <em> proceeding</em> that could 
            result in a &quot;Yes&quot; answer to any part of 6C, D or E?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isRegulatoryComplaint= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:regulatoryDisclosure/n2:regulatoryDisclosureCommonQuestion/ns2:isRegulatoryComplaint= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>INVESTIGATION DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to Item 6G(2) below, complete an 
        <strong>Investigation DRP</strong>.</em> </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(2) <em>investigation</em> that could result in a &quot;Yes&quot; 
            answer to any part of 6A, B, C, D or E? <em>(If &quot;Yes,&quot; complete the Investigation 
            Disclosure Reporting Page.)</em> </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:investigationDisclosure/n2:isInvestigated= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:investigationDisclosure/n2:isInvestigated= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>CIVIL JUDICIAL ACTION DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to any question below in Item 6H, 
        complete a <strong>Civil Judicial Action DRP</strong>.</em></p>
        <h3>Item 6H.</h3>
        <p>(1) Has any domestic or foreign court ever: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(a) <em>enjoined</em> the individual in connection with any 
             <em>municipal advisor-related</em> or <em>investment-related</em> activity? </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isEnjoined= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isEnjoined= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(b) <em>found</em> that the individual was <em>involved</em> 
            in a violation of any <em>municipal advisor-related</em> or <em>investment-related</em> 
            statute(s) or regulation(s)?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isFoundInViolationOfRegulation= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isFoundInViolationOfRegulation= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(c) dismissed, pursuant to a settlement agreement, a 
            <em>municipal advisor-related</em> or <em>investment-related</em> civil action 
            brought against the individual by a domestic jurisdiction or 
            <em>foreign financial regulatory authority?</em></div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isDismissed= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isDismissed= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(2) Is the individual named in any currently pending civil <em>proceeding</em> that could result in a &quot;Yes&quot; answer to any part of 6H(1)?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isNamedInCivilProceeding= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:civilDisclosure/ns2:isNamedInCivilProceeding= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>CUSTOMER COMPLAINT/ARBITRATION/CIVIL LITIGATION DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to any question below in Item 6I, 
        complete a <strong>Customer Complaint/Arbitration/Civil Litigation DRP.</strong></em></p>
        <h3>Item 6I.</h3>
        (1) Has the individual ever been the subject of a <em>municipal advisor-related</em> 
        or <em>investment-related,</em> customer-initiated (written or oral) complaint that 
        alleged that he or she was <em>involved</em> in fraud, false statements, omissions, theft, 
        embezzlement, wrongful taking of property, bribery, forgery, counterfeiting, extortion, 
        or dishonest, unfair or unethical practices, which:
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(a) is still pending, or; </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isComplaintPending= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isComplaintPending= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(b) was settled?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isComplaintSettled= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isComplaintSettled= 'N'">
									<img
									src="Images/radio-checked.jpg"  alt="radio button checked"/>
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        (2) Has the individual ever been the subject of a <em>municipal advisor-related</em> 
        or <em>investment-related,</em> customer-initiated arbitration or civil litigation 
        that alleged that he or she was <em>involved</em> in fraud, false statements, omissions, 
        theft, embezzlement, wrongful taking of property, bribery, forgery, counterfeiting, 
        extortion, or dishonest, unfair or unethical practices, which:
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(a) is still pending, or;</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isFraudCasePending= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isFraudCasePending= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(b) resulted in an arbitration award or civil judgment 
            against the individual, regardless of amount, or; </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isFraudCaseResultedAward= 'Y'">
								<img
									src="Images/radio-checked.jpg"  alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isFraudCaseResultedAward= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(c) was settled? </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isFraudCaseSettled= 'Y'">
								<img
									src="Images/radio-checked.jpg"  alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:complaintDisclosure/n2:isFraudCaseSettled= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>TERMINATION DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to any question below in Item 6J, 
        complete a <strong>Termination DRP</strong>.</em></p>
        <h3>Item 6J.</h3>
        <p>Has the individual ever voluntarily <em>resigned,</em> been discharged 
        or permitted to <em>resign</em> after allegations were made that accused him or her of: </p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(1) violating <em>municipal advisor-related</em> or 
             <em>investment-related</em> statutes, regulations, rules, or industry standards 
             of conduct? </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:terminationDisclosure/n2:isViloatedIndustryStandard= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:terminationDisclosure/n2:isViloatedIndustryStandard= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(2) fraud or the wrongful taking of property?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:terminationDisclosure/n2:isInvolvedInFraud= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:terminationDisclosure/n2:isInvolvedInFraud= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(3) failure to supervise in connection with 
             <em>municipal advisor-related</em> or <em>investment-related</em> 
             statutes, regulations, rules or industry standards of conduct? </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:terminationDisclosure/n2:isFailedToSupervise= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:terminationDisclosure/n2:isFailedToSupervise= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg"  alt="radio button unchecked"/>
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>FINANCIAL DISCLOSURE</h2>
        <h3>Item 6K.</h3>
        <p>Within the past 10 years:</p>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(1) has the individual made a compromise with creditors, 
             filed a bankruptcy petition or been the subject of an involuntary 
             bankruptcy petition?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isCompromised= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isCompromised= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
          <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(2) based upon events that occurred while the individual 
             exercised <em>control</em> over it, has an organization made a 
             compromise with creditors, filed a bankruptcy petition or been the 
             subject of an involuntary bankruptcy petition?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isBankruptcyPetition= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isBankruptcyPetition= 'N'">
									<img
									src="Images/radio-checked.jpg"  alt="radio button checked"/>
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
           <div class="tablebottom" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">(3) based upon events that occurred while the individual exercised 
            <em>control</em> over it, has a broker or dealer been the subject of an 
            involuntary bankruptcy petition, had a trustee appointed, or had a direct 
            payment procedure initiated under the Securities Investor Protection Act? </div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isTrusteeApointed= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isTrusteeApointed= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h3>Item 6L. </h3>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">Has a bonding company ever denied, paid out on, 
            or revoked a bond for the individual?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isBondRevoked= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:financialDisclosure/n2:isBondRevoked= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>
        <h2>JUDGMENT/LIEN DISCLOSURE</h2>
        <p><em>If the answer is &quot;Yes&quot; to any question below in Item 6M, 
        complete a <strong>Judgment/Lien DRP</strong>.</em></p>
        <h3>Item 6M. </h3>
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
           <div>
               <div class="tdStyle1  tditem10col1">Are there currently any unsatisfied judgments or 
             liens against the individual?</div>
            <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:judgmentLienDisclosure/n2:isLienAgainst= 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="n2:disclosureQuestions/n2:judgmentLienDisclosure/n2:isLienAgainst= 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO </div>
          </div>
         <div style="clear:both"></div>
         </div>        
      </div>
    </div>
  </div>
</div>

</xsl:template>

</xsl:stylesheet>