<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">

	<xsl:template name="Item4"><link href="style.css" rel="stylesheet" type="text/css" />
		
		<div id="maiItem4">
  <div class="contentwrapper">
    <div class="content">
      <h1>Item 4 Employment History</h1>
      <p>Provide complete employment history of the individual for the past 10 years. Include 
       the <em>municipal advisory firm(s)</em> entered in Item 1-B. Enter 
       the following information for each employer. Account for all time, 
       leaving no gaps longer than three months. Include full- and part-time 
       employment, self-employment, military service, and homemaking. Also 
       include statuses such as unemployed, full-time education, extended travel, 
       or other similar statuses. Such statuses should be entered in the space 
       provided below for &quot;Name of <em>Municipal Advisory Firm</em> or Company.&quot; </p>

      <h2>Current Employer</h2>
	  <div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">From:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:startDate" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">To: <em>of Municipal Advisory Firm</em> or Company:</div>
			<div class="tdStyle1 tdTwoCol2Textbox">
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:endDate" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">Name <em>of Municipal Advisory Firm</em> or Company:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:name" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">City: <em>of Municipal Advisory Firm</em> or Company:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:addressInfo/n2:city" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">State/Country: <em>of Municipal Advisory Firm</em> or Company:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:addressInfo/n2:stateOrCountry/ns1:stateOrCountry" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">Postal Code:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:addressInfo/n2:zipCode" />					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1"><em>Municipal Advisor-Related</em> Business?</div>
			<div class="tdStyle1 tdTwoCol2">
							<xsl:choose>
									<xsl:when test="n2:employmentHistory/n2:currentEmployer/n2:isRelatedToMunicipalAdvisor= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when test="n2:employmentHistory/n2:currentEmployer/n2:isRelatedToMunicipalAdvisor = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1"><em>Investment-Related</em> Business?</div>
			<div class="tdStyle1 tdTwoCol2">
				<xsl:choose>
					<xsl:when test="n2:employmentHistory/n2:currentEmployer/n2:isRelatedToInvestment= 'Y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				YES
				<xsl:choose>
					<xsl:when test="n2:employmentHistory/n2:currentEmployer/n2:isRelatedToInvestment = 'N'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />

					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				NO					
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">Position Held:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:employmentHistory/n2:currentEmployer/n2:positionDescription" />				
			</div>
		</div>   <div style="clear:both"></div>
      </div>
       <xsl:if
			test="(count(n2:employmentHistory/n2:priorEmployers/n2:priorEmployer) &gt; 0)">
		 <h2>Prior to the Above</h2>
		 <p>Prior employment history must be entered in reverse chronological order.</p><br />
      <xsl:for-each
			select="n2:employmentHistory/n2:priorEmployers/n2:priorEmployer">
		 <h3>Prior Address</h3>
		 <div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">From (MM/YYYY):</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:startDate" />				
			</div>
		</div>	<div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">To (MM/YYYY):</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:endDate" />				
			</div>
		</div>	<div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">Name of <em>Municipal Advisory Firm</em> or Company:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:name" />			
			</div>
		</div><div style="clear:both"></div>	
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">City:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/n2:city" />				
			</div>
		</div><div style="clear:both"></div>	
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">State/Country: </div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/n2:stateOrCountry/ns1:stateOrCountry" />			
			</div>
		</div><div style="clear:both"></div>	
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">Postal Code:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:addressInfo/n2:zipCode" />				
			</div>
		</div><div style="clear:both"></div>	
		<div class="tableRow">
            <div class="tdStyle1 tdTwoCol1"><em>Municipal Advisor-Related</em> Business?</div>
			<div class="tdStyle1 tdTwoCol2">
				<xsl:choose>
					<xsl:when test="n2:isRelatedToMunicipalAdvisor= 'Y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				YES
				<xsl:choose>
					<xsl:when test="n2:isRelatedToMunicipalAdvisor = 'N'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />

					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				NO				
			</div>
		</div>	<div style="clear:both"></div>
		<div class="tableRow">
            <div class="tdStyle1 tdTwoCol1"><em>Investment-Related</em> Business?</div>
			<div class="tdStyle1 tdTwoCol2"> 
				<xsl:choose>
					<xsl:when test="n2:isRelatedToInvestment= 'Y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				YES
				<xsl:choose>
					<xsl:when test="n2:isRelatedToInvestment = 'N'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				NO			
			</div>
		</div><div style="clear:both"></div>
		<div class="tableRow">
				<div class="tdStyle1 tdTwoCol1">Position Held:</div>
			<div class="tdStyle1 tdTwoCol2Textbox"> 
				<xsl:value-of select="n2:positionDescription" />				
			</div>
		</div><div style="clear:both"></div>
      </div>
      </xsl:for-each>
      </xsl:if>
    </div>
  </div>
</div>

	</xsl:template>

</xsl:stylesheet>