<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">

	<xsl:template name="regulatoryDisclosureDrp">
	
		<div id="drpRegulatory">

			<div class="contentwrapper" style="margin-left:0; margin-right:0;">
				<div class="content" style="margin-left:0; margin-right:0;">

					<xsl:for-each
						select="m1:formData/m1:drpInfo/ns3:regulatoryDisclosure/ns3:regulatoryDrp">
						<div class="form1"  style="margin-left:0; margin-right:0;">
							<div class="formDescription"  style="margin-left:0; margin-right:0;">
								<p><b>GENERAL INSTRUCTIONS</b></p>
								<p>
									This <b>Disclosure Reporting Page (DRP MA)</b> is an
									<span class="label">
										<xsl:choose>
											<xsl:when
												test="count(ns3:headerData/ns3:baseHeader/ns3:type/n2:add)&gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										<b>INITIAL</b> <b><em> OR </em></b>
										<xsl:choose>
											<xsl:when
												test="count(ns3:headerData/ns3:baseHeader/ns3:type/n2:amend) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										<b>AMENDED</b>
									</span>
									response used to report details for affirmative responses to 
									<b>Items 9-C, 9-D, 9-E, 9-F or 9-G</b>
									of Form MA.
								</p>

								<p>Check item(s) being responded to:   </p>
								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-C1'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-C(1)</b>    
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-C2'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-C(2)</b>    
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-C3'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-C(3)</b>  
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-C4'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-C(4)</b>
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-C5'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-C(5)</b>
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-D1'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-D(1)</b>
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-D2'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-D(2)</b>
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-D3'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-D(3)</b> 
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-D4'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-D(4)</b>  
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-D5'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-D(5)</b>
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-E1'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											  <b>9-E(1)</b> 
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-E2'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-E(2)</b> 
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-E3'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-E(3)</b>  
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-E4'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-E(4)</b>
										</div>
										<div class="tdStyle1 tdFiveCol">&#160;</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-F'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-F</b>   
										</div>
										<div class="tdStyle1 tdFiveCol">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-G'])&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											 <b>9-G</b>
										</div>
										<div class="tdStyle1 tdFiveCol">&#160;</div>
										<div class="tdStyle1 tdFiveCol">&#160;</div>
										<div class="tdStyle1 tdFiveCol">&#160;</div>
									</div>
									<div style="clear:both"></div>
								</div>								
								<p>
									<b>
										<u>How to Report an Event or <em>Proceeding</em> on a Regulatory Action
											DRP:</u>
									</b>
									  Use a separate DRP for each event or
									<em>proceeding</em>
									. 
									The same event or
									<em>proceeding</em>
									may be reported for more than one
									<em>person</em>
									or entity using one DRP. One event may result in more than one
									affirmative answer to
									<b>Items 9-C, 9-D, 9-E, 9-F, and/or 9-G.</b>
									 If an
									event gives rise to actions by more than one regulator, provide
									details for
									each action on a separate DRP.
								</p>



								<h1>REGULATORY ACTION DRP PART 1 </h1>

								<p>Check all that apply, except where noted  </p>


								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">

										<div class="tdStyle1">
											<b>
												A.    The
												<em>person</em>(s) or entity(ies) for
												whom this DRP is being filed is (are) the:   
											</b>
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">

										<div class="tdStyle1">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicant)&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Applicant (the
											<em>municipal advisory firm</em>)
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">

										<div class="tdStyle1 ">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicantAndAP)&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Applicant and one or more
											of the applicant's <em>associated person</em>(s)
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">

										<div class="tdStyle1 ">
											<xsl:choose>
												<xsl:when
													test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:ap)&gt; 0">
													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											One or more of applicant's
											<em>associated person</em>(s)
										</div>
									</div>
									<div style="clear:both"></div>
								</div>
								<div style="clear:both"></div>

								<p>
									<b>
										1.
										<u>Applicant</u>
									</b>
								</p>

								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tditem10col1">(a) Is this DRP an amendment filed for the applicant that
											seeks to remove a previously filed DRP concerning the
											applicant from the record?</div>
										<div class="tdStyle1 tditem10col2">
											<xsl:choose>
												<xsl:when
													test="count(ns3:applicantInfo/ns3:drpRemoveReason)&gt; 0">
													<img src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											YES&#160;&#160;&#160;
											<xsl:choose>
												<xsl:when
													test="count(ns3:applicantInfo/ns3:drpRemoveReason)&gt; 0">
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:otherwise>
											</xsl:choose>
											NO
										</div>
									</div>
									
									
									<div class="hide tableRow" id="crimRow1b">

										<div class="tdStyle1 "> (b) If &quot;Yes,&quot; the reason the DRP should be
											removed is:</div>
									</div>
									<div style="clear:both"></div>									
									<div class="hide tableRow" id="crimRow1ba">

										<div class="tdStyle1 ">
											<xsl:choose>
												<xsl:when

	                                                   test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isRegistered)&gt; 0"> 
													<img src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											The applicant is registered or applying for registration and
											the event or
											<em>proceeding</em>
											was resolved in the applicant's favor.
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="hide tableRow" id="crimRow1bb">

										<div class="tdStyle1 ">
											<xsl:choose>
												<xsl:when
													test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isFiledError)&gt; 0">
													<img src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											The DRP was filed in error.
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="hide tableRow" id="crimexplain22">

										<div class="tdStyle1">
											Explain the circumstances:
											<br />
											<div class="fakeBox">
												<xsl:value-of
													select="string(ns3:applicantInfo/ns3:drpRemoveReason/n2:isFiledError/n2:explainTheCircumstances)" />
												<span>
													<xsl:text>&#160;</xsl:text>
												</span>
											</div>
										</div>
									</div>
									<div style="clear:both"></div>
								</div>



								<p>
									<b>
										2. <u>Associated <em>Person</em>(s)</u>
									</b>
								</p>

								<div class="tableStyle" style="margin-left:0; margin-right:0;">          
									<div class="tableRow">             
										<div class="tdStyle1 tditem10col1">    (a) Does this DRP concern one or more <em>associated person</em>s?</div>
										<div class="tdStyle1 tditem10col2">
											<xsl:choose>
												<xsl:when test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:ap)&gt; 0 or count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicantAndAP)&gt; 0">
													<img src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose> Yes&#160;&#160;&#160;   
											<xsl:choose>
												<xsl:when test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:ap)&gt; 0 or count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicantAndAP)&gt; 0">
													<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:otherwise>
											</xsl:choose> No
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="hide tableRow" id="BBB">             
										<div class="tdStyle1"> 
										  <label>&#160;&#160;&#160;&#160;(i)    If &#34;Yes,&#34; indicate the total number of such <em>associated person</em>(s): </label>
										  <input name="textfield24" type="text" class="tinyField" id="textfield30" >
										   <xsl:choose>
											<xsl:when test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:ap)&gt; 0 or count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicantAndAP)&gt; 0">
												<xsl:attribute name="value">
													  <xsl:value-of select="ns3:headerData/ns3:baseHeader/ns3:apDrpFiledCount" />
												</xsl:attribute>
											</xsl:when>
											 <xsl:otherwise>
												   <xsl:attribute name="value">
													   <xsl:value-of select="." />
													</xsl:attribute>
												</xsl:otherwise>
											  </xsl:choose>
											</input>
										</div>
									</div>
									
									<div class="tableRow">
										<div class="tdStyle1">(b)	Identify each such associated firm and/or natural person in the space below:</div>
									</div>
								</div>
								<div class="hide" id="reguapEntry85">
									<xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
										<div class="record hide" id="newreguAP22" style="margin-left:0; margin-right:0;">
											<h3> Entry</h3>
											<div class="hide tableRow" id="reguRow1ba">
												<div class="tdStyle1">
													<xsl:choose>
														<xsl:when test="count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														</xsl:otherwise>
													</xsl:choose>&#160;<b>Firm</b>
												</div>
											</div>
											<div class="hide tableRow" id="crimfirm22">
												<div class="tdStyle1 padded">
													<label for="firm name">Full name of the <em>associated person</em>:</label><br/>
													<div class="fakeBox">
														<xsl:value-of
															select="string(ns3:apType/ns3:firmInfo)" />
														<span>
															<xsl:text>&#160;</xsl:text>
														</span>
													</div>
												</div>
											</div>
											<div class="tableRow">
												<div class="tdStyle1">The <em>associated person</em> is:
													<xsl:choose>
														<xsl:when test="ns3:registrationInfo/ns3:isSECRegistered = 'Y' and count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														</xsl:otherwise>
													</xsl:choose> registered with the <em>SEC</em>
													<xsl:choose>
														<xsl:when test="ns3:registrationInfo/ns3:isSECRegistered = 'N' and count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														</xsl:otherwise>
													</xsl:choose>   
													<label for="Associated Person2">not registered with the <em>SEC</em></label>
												</div>
											</div>   
											<div class="hide tableRow" id="crimsecReg22">
												<div class="tdStyle1 tdTwoCol1"><em>SEC</em> Registration No.
												  <xsl:choose>
														<xsl:when test="count(ns3:apType/ns3:firmInfo)&gt; 0">
															<input  type="text"     name="crimsecRegno22"   readonly="1">
															<xsl:attribute name="value">
																<xsl:value-of select="string(ns3:registrationInfo/ns3:secRegistrationNumber)" />
															</xsl:attribute>
														</input>
													</xsl:when>
													 <xsl:otherwise>
														  <input    type="text"     name="crimsecRegno22"   readonly="1">
															 <xsl:attribute name="value">
																 <xsl:value-of select="'&#160;'" />
															</xsl:attribute>
														 </input>
													  </xsl:otherwise>
												   </xsl:choose>   
												</div>
												<div class="tdStyle1 tdTwoCol2"><em>CRD</em> No., if any
													<xsl:choose>
														<xsl:when test="count(ns3:apType/ns3:firmInfo)&gt; 0">
															<input  type="text"     name="crd22"   readonly="1">
															<xsl:attribute name="value">
																<xsl:call-template name="CRDFormatting">
																	<xsl:with-param name="CRD" select="string(ns3:registrationInfo/ns3:crdNumber)" />
																</xsl:call-template>  
															</xsl:attribute>
														</input>
													</xsl:when>
													 <xsl:otherwise>
														  <input    type="text"     name="crd22"   readonly="1">
															 <xsl:attribute name="value">
																 <xsl:value-of select="'&#160;'" />
															</xsl:attribute>
														 </input>
													  </xsl:otherwise>
												   </xsl:choose>   
												</div>
											</div>
											<div style="clear:both"></div>
											<div class="tableRow">
												<div class="tdStyle1 tditem10col1">Is this DRP an amendment that seeks to remove a previously filed DRP concerning this <em>associated person?</em></div>
												<div class="tdStyle1 tditem10col2">
													<xsl:choose>
														<xsl:when test="count(ns3:drpRemovalInformation)&gt; 0 and count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
															<img src="Images/radio-checked.jpg" alt="radio button checked" />No
														</xsl:otherwise>
													</xsl:choose>   
												</div>
											</div>
											<div style="clear:both"></div>
											<div class="tableRow">
												<div class="tdStyle1">If &quot;Yes,&quot; the reason the DRP should be removed is:</div>
											</div>
											<div style="clear:both"></div>
											<div class="tableRow">
												<div class="tdStyle1">
													<xsl:choose>
														<xsl:when test="count(ns3:drpRemovalInformation/ns3:apNotAssociated)&gt; 0 and count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														</xsl:otherwise>
													</xsl:choose> The <em>associated person</em>(s) is no longer associated with the advisor.</div>
											</div>
											<div style="clear:both"></div>
											<div class="tableRow">
												<div class="tdStyle1">
													<xsl:choose>
														<xsl:when test="count(ns3:drpRemovalInformation/ns3:eventResolved)&gt; 0 and count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														</xsl:otherwise>
													</xsl:choose> The event or <em>proceeding</em> was resolved in the <em>associated person</em>'s favor
												</div>
											</div>
											<div style="clear:both"></div>
											<div class="tableRow">
												<div class="tdStyle1">
													<xsl:choose>
														<xsl:when test="count(ns3:drpRemovalInformation/ns3:isFiledError)&gt; 0 and count(ns3:apType/ns3:firmInfo)&gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														</xsl:otherwise>
													</xsl:choose> The DRP was filed in error. Explain the circumstances:</div>
											</div>
											<div style="clear:both"></div>
											<div class="hide tableRow" id="crimexplain22">
												<div class="tdStyle1">
													<div class="fakeBox">
														<xsl:choose>
															<xsl:when
																test="count(ns3:apType/ns3:firmInfo)&gt; 0">
																<xsl:value-of
																	select="string(ns3:drpRemovalInformation/ns3:isFiledError/n2:explainTheCircumstances)" /> 
																<span>
																	<xsl:text>&#160;</xsl:text>
																</span>
															</xsl:when>
															<xsl:otherwise>
															</xsl:otherwise>
														</xsl:choose>
													</div>
												</div>
											</div>
											<div style="clear:both"></div>
											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="hide tableRow" id="crimRow1bb">           
													<div class="tdStyle1">
														<xsl:choose>
															<xsl:when test="count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															</xsl:otherwise>
														</xsl:choose> <b>Natural person</b>
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1">Full name of the <em>associated person</em>:</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">Enter all the letters of each name and not initials or other abbreviations.<br/> If no middle name, enter NMN on that line.</div>
												</div>
											</div>
											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="hide tableRow" id="crimnp22">
													<div class="tdStyle1 tdFourCol">
														<input type="text" name="firstName" readonly="1">
															<xsl:attribute name="value">
																<xsl:value-of select="string(ns3:apType/ns3:naturalPersonInfo/ns2:firstName)" />
															</xsl:attribute>
														</input><br/> First Name
													</div>
													<div class="tdStyle1 tdFourCol">
														<input type="text" name="middleName" readonly="1">
															<xsl:attribute name="value">
																<xsl:value-of select="string(ns3:apType/ns3:naturalPersonInfo/ns2:middleName)" />
															</xsl:attribute>
														</input><br/> Middle Name
													</div>
													<div class="tdStyle1 tdFourCol">
														<input type="text" name="lastName" readonly="1">
															<xsl:attribute name="value">
																<xsl:value-of select="string(ns3:apType/ns3:naturalPersonInfo/ns2:lastName)" />
															</xsl:attribute>
														</input><br/> Last Name
													</div>
													<div class="tdStyle1 tdFourCol">
														<input type="text"  name="suffix01" readonly="1">
															<xsl:attribute name="value">
																<xsl:value-of select="string(ns3:apType/ns3:naturalPersonInfo/ns2:suffix)" />
															</xsl:attribute>
														</input><br/> Suffix
													</div>
												</div>
												<div style="clear:both"></div>
											</div>
											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">The <em>associated person</em> is:</div>
												</div> 
												<div class="tableRow">
													<div class="tdStyle1 tdTwoCol1">
														<xsl:choose>
															<xsl:when test="ns3:registrationInfo/ns3:isSECRegistered = 'Y' and count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															</xsl:otherwise>
														</xsl:choose> registered with the <em>SEC</em>
													</div>
													<div class="tdStyle1 tdTwoCol2"><em>SEC</em> Registration No.:
														<xsl:choose>
															<xsl:when test="count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<input  type="text"     name="crimsecRegno22"   readonly="1">
																<xsl:attribute name="value">
																	<xsl:value-of select="string(ns3:registrationInfo/ns3:secRegistrationNumber)" />
																</xsl:attribute>
															</input>
														</xsl:when>
														 <xsl:otherwise>
															  <input    type="text"     name="crimsecRegno22"   readonly="1">
																 <xsl:attribute name="value">
																	 <xsl:value-of select="'&#160;'" />
																</xsl:attribute>
															 </input>
														  </xsl:otherwise>
													   </xsl:choose>   
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdTwoCol1">
														<xsl:choose>
															<xsl:when test="ns3:registrationInfo/ns3:isSECRegistered = 'N' and count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															</xsl:otherwise>
														</xsl:choose> not registered with the <em>SEC</em>
													</div>
													<div class="tdStyle1 tdTwoCol2"><em>CRD</em> No., if any:
															<xsl:choose>
															<xsl:when test="count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<input  type="text"     name="crd22"   readonly="1">
																<xsl:attribute name="value">
																	<xsl:call-template name="CRDFormatting">
																		<xsl:with-param name="CRD" select="string(ns3:registrationInfo/ns3:crdNumber)" />
																	</xsl:call-template>  
																</xsl:attribute>
															</input>
														</xsl:when>
														 <xsl:otherwise>
															  <input    type="text"     name="crd22"   readonly="1">
																 <xsl:attribute name="value">
																	 <xsl:value-of select="'&#160;'" />
																</xsl:attribute>
															 </input>
														  </xsl:otherwise>
													   </xsl:choose>   
													</div>
												</div>
												<div style="clear:both"></div>
											</div>
											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1 tditem10col1">Is this DRP an amendment that seeks to remove a previously filed DRP concerning this <em>associated person</em>?
													</div>
													<div class="tdStyle1 tditem10col2">
														<xsl:choose>
															<xsl:when test="count(ns3:drpRemovalInformation)&gt; 0 and count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
																<img src="Images/radio-checked.jpg" alt="radio button checked" />No
															</xsl:otherwise>
														</xsl:choose>   
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1">If &quot;Yes,&quot; the reason the DRP should be removed is:</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<xsl:choose>
															<xsl:when test="count(ns3:drpRemovalInformation/ns3:apNotAssociated)&gt; 0 and count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															</xsl:otherwise>
														</xsl:choose> The <em>associated person</em>(s) is no longer associated with the advisor.</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<xsl:choose>
															<xsl:when test="count(ns3:drpRemovalInformation/ns3:eventResolved)&gt; 0 and count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															</xsl:otherwise>
														</xsl:choose> The event or <em>proceeding</em> was resolved in the <em>associated person</em>'s favor.
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<xsl:choose>
															<xsl:when test="count(ns3:drpRemovalInformation/ns3:isFiledError)&gt; 0 and count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																<img src="Images/radio-checked.jpg" alt="radio button checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															</xsl:otherwise>
														</xsl:choose> The DRP was filed in error. Explain the circumstances:</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:choose>
																<xsl:when
																	test="count(ns3:apType/ns3:naturalPersonInfo)&gt; 0">
																	<xsl:value-of
																		select="string(ns3:drpRemovalInformation/ns3:isFiledError/n2:explainTheCircumstances)" />
																	<span>
																		<xsl:text>&#160;</xsl:text>
																	</span>
																</xsl:when>
																<xsl:otherwise>
																</xsl:otherwise>
															</xsl:choose>
														</div>
													</div>
												</div>
											</div>
										</div>
									</xsl:for-each>
								</div><!--reguapEntry85-->
								<div class="form1">
									<xsl:for-each select="ns3:applicantInfo">
									<p>
                                        <b><u>Applicant</u></b>
                                    </p>
                                    <p>
                                        <b>
                                            <u>B. DRP Filed Elsewhere for This Event:</u>
                                        </b>
                                    </p>
                                        <div class="tableStyle" style="margin-left:0; margin-right:0;">
                                            <div class="tdStyle1 tditem10col1">
                                    <span class="minutia">
                                        <u>
                                            &#160;&#160;&#160;&#160;Is an accurate and up-to-date DRP containing the information
                                            regarding the applicant or
                                            <em>associated person </em>
                                            required by this DRP already on file (a) in the
                                            <em>IARD</em>
                                            or
                                            <em>CRD</em>
                                            system (with a Form ADV, BD, or U4), or (b) in the
                                            <em>SEC</em>'s
                                            EDGAR system (with a Form MA or Form MA-I)?</u>
                                        
                                            </span>
                                            </div>
                                                <div class="tdStyle1 tditem10col2">
                                                    <xsl:choose>
                                                        <xsl:when
                                                            test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
                                                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                            Yes
                                                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                            No
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                            Yes
                                                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                            No
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </div>
											<div style="clear:both"></div>
                                        </div>
 								<xsl:if test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">										
										<div class="dented hide" id="crimdrpDisclosure22">

											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1"><b>If the answer is &quot;Yes,&quot; provide the applicable 
														information indicated below that identifies where the DRP may be found. </b></div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 checkbox">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing) &gt; 0 ">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														<label> 1. Form ADV, BD, or U4 Filing</label>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 checkbox">
														<xsl:choose>
															<xsl:when
																test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 ">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />

															</xsl:otherwise>
														</xsl:choose>
														<label> 2. Form MA Filing</label>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 checkbox">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														<label> 3. Form MA-I Filing</label>
													</div>
												</div>												
											</div>
											<div class="tableStyle hide" id="advFilingcrim" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														<h3>1. Form ADV, BD, or U4 Filing:</h3>
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														For a DRP filed on the
														<em>IARD</em>
														or
														<em>CRD</em>
														system with one of these forms, provide the following
														information:
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:name)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														<br />
														Name on Registration
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1 tdTwoCol1">
														<input type="text" name="iard2" readonly="1">
															<xsl:attribute name="value">
																<xsl:call-template name="CRDFormatting">
																	<xsl:with-param name="CRD" select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:crdNumber)" />
																</xsl:call-template> 
																>
																</xsl:attribute>
														</input>
														<br />
														<em>CRD</em> No123.
													</div>
													<div class="tdStyle1 tdTwoCol2">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:disclosureNumber)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														<br />
														Disclosure Occurrence No.
													</div>

												</div>
												<div style="clear:both"></div>
											</div>
											<div class="tableStyle hide" id="maFilingcrim" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														<h3>2. Form MA Filing:</h3>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">For a DRP filed on EDGAR with a Form MA,
														provide the following information:</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:name)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														<br />
														Name on Registration
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="matReg001" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:regNumber)" />
							</xsl:attribute>
														</input>
														<br />
														MA Registration Number
													</div>
													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="dateoffiling2" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:drpDate)" />
							</xsl:attribute>
														</input>
														<br />
														Date of Filing that contains the DRP (MM/DD/YYYY)
													</div>
													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="accessNo" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
														</input>
														<br />
														Accession number of the filing
													</div>

												</div>
												<div style="clear:both"></div>
											</div>
											<div class="tableStyle hide" id="maiFilingcrim" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														<h3>3. Form MA-I Filing:</h3>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">For a DRP filed on EDGAR with a Form MA-I,
														provide the following information:</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:name)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														<br />
														Name on Registration3123
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="maiReg" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:regNumber)" />
							</xsl:attribute>
														</input>
														<br />
														MA-I Registration Number
													</div>
													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="dateoffiling3" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:drpDate)" />
							</xsl:attribute>
														</input>
														<br />
														Date of Filing that contains the DRP (MM/DD/YYYY)
													</div>

													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="accessNo" readonly="1">
															<xsl:attribute name="value">
                            <xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:accessionNumber)" />
                            </xsl:attribute>
														</input>
														<br />
														Accession number of the filing
													</div>

												</div>
												<div style="clear:both"></div>
											</div>
										</div>
										</xsl:if>
									</xsl:for-each>
									<br></br>
									<xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
										<p>
                                       <b><u>Associated <em>Person</em>(s)</u></b>
                                    </p>
                                    <p>
                                        <b>
                                            <u>B. DRP Filed Elsewhere for This Event:</u>
                                        </b>
                                      </p>
                                        <div class="tableStyle" style="margin-left:0; margin-right:0;">
                                             <div class="tdStyle1 tditem10col1">
                                                <span class="minutia">
                                                    <u>
                                                        &#160;&#160;&#160;&#160;Is an accurate and up-to-date DRP containing the information
                                                        regarding the applicant or
                                                        <em>associated person </em>
                                                        required by this DRP already on file (a) in the
                                                        <em>IARD</em>
                                                        or
                                                        <em>CRD</em>
                                                        system (with a Form ADV, BD, or U4), or (b) in the
                                                        <em>SEC</em>'s
                                                        EDGAR system (with a Form MA or Form MA-I)?</u>
                                                    
                                                </span>
                                                </div>
                                                <div class="tdStyle1 tditem10col2">
                                                    <xsl:choose>
                                                        <xsl:when
                                                            test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
                                                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                            YES
                                                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                            NO
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                            YES
                                                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                            NO
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </div>
											<div style="clear:both"></div>
                                        </div>
                                       <xsl:if test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
										<div class="dented hide">

											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1"><b>If the answer is &quot;Yes,&quot; provide the applicable 
														information indicated below that identifies where the DRP 
														may be found. </b></div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 checkbox">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing) &gt; 0 ">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														<label> 1. Form ADV, BD, or U4 Filing</label>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 checkbox">
														<xsl:choose>
															<xsl:when
																test=" count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 ">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />

															</xsl:otherwise>
														</xsl:choose>
														<label> 2. Form MA Filing</label>
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1 checkbox">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														<label> 3. Form MA-I Filing</label>
													</div>
												</div>
											</div>
											<div class="tableStyle hide" id="advFilingcrim" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														<h3>1. Form ADV, BD, or U4 Filing:</h3>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">
														For a DRP filed on the
														<em>IARD</em>
														or
														<em>CRD</em>
														system with one of these forms, provide the following
														information:
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:name)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														Name on Registration
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 tdTwoCol1">
														<input type="text" name="iard2" readonly="1">
															<xsl:attribute name="value">
																<xsl:call-template name="CRDFormatting">
																	<xsl:with-param name="CRD" select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:crdNumber)" />
																</xsl:call-template> 
															</xsl:attribute>
														</input>
														<br />
														<em>CRD</em> No.
													</div>
													<div class="tdStyle1 tdTwoCol2">
													  <div class="fakeBox">
													    <xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing/n2:disclosureNumber)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
													  </div>
														<br />
														Disclosure Occurrence No.
													</div>

												</div>
												<div style="clear:both"></div>
											</div>
											<div class="tableStyle hide" id="maFilingcrim" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														<h3>2. Form MA Filing:</h3>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">For a DRP filed on EDGAR with a Form MA,
														provide the following information:</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:name)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														Name on Registration
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="matReg001" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:regNumber)" />
							</xsl:attribute>
														</input>
														<br />
														MA Registration Number
													</div>
													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="dateoffiling2" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:drpDate)" />
							</xsl:attribute>
														</input>
														<br />
														Date of Filing that contains the DRP (MM/DD/YYYY)
													</div>
													<div class="tdStyle1 tdThreeCol">
														<input type="text" name="accessNo" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
														</input>
														<br />
														Accession number of the filing
													</div>

												</div>
												<div style="clear:both"></div>
											</div>
											<div class="tableStyle hide" id="maiFilingcrim" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														<h3>3. Form MA-I Filing:</h3>
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">For a DRP filed on EDGAR with a Form MA-I,
														provide the following information:</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1">
														<div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:name)" />
															<span>
																<xsl:text>&#160;</xsl:text>
															</span>
														</div>
														Name on Registration
													</div>
												</div>
												<div class="tableRow">

													<div class="tdStyle1 tdTwoCol1">
														<input type="text" name="maiReg" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:regNumber)" />
							</xsl:attribute>
														</input>
														<br />
														MA-I Registration Number
													</div>
													<div class="tdStyle1 tdTwoCol2">
														<input type="text" name="dateoffiling3" readonly="1">
															<xsl:attribute name="value">
							<xsl:value-of
																select="string(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling/n2:drpDate)" />
							</xsl:attribute>
														</input>
														<br />
														Date of Filing that contains the disclosure
													</div>

												</div>
												<div style="clear:both"></div>
											</div>
										</div>
										</xsl:if>
									</xsl:for-each>
								</div>

								<div>
									        <div id="warncrimdrp2" class="deets">
         </div>
         <strong> </strong>

								</div>

								<xsl:for-each select="ns3:applicantInfo">
								<xsl:choose>
                                     <xsl:when
                                       test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
                                     </xsl:when>
                                      <xsl:otherwise>
                                                
									<br /><br /><h1>REGULATORY ACTION DRP PART 2</h1>

									<p>
										<b>1. Regulatory Action was initiated by:</b>
									</p>
									<p>
										<b>A. Select the Appropriate Item.</b>
										<em> (Select only one. A separate Regulatory Action DRP is
											required for each such regulator or other authority.)</em>
									</p>

									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:sec)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>SEC</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:state)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												State
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:otherFederalAuthority)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Foreign Financial Regulatory Authority</em>
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:cftc)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>CFTC</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:sro)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>SRO</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
                                                    <xsl:when
                                                        test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:other)&gt; 0">

                                                        <img src="Images/box-checked.jpg" alt="checkbox checked" /> Other: (specify)
                                                    </xsl:when>
                                                    <xsl:otherwise>

                                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Other: (specify)
                                                        
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:other)&gt; 0">
                                                        <div class="fakeBox">
									                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:other)" />
									                         <span>
									                             <xsl:text>&#160;</xsl:text>
									                       </span>
									                   </div>
                                                    </xsl:when>
                                                    <xsl:otherwise>

                                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                       
                                                        <input type="text" readonly="1">
                                                        </input>
                                                    </xsl:otherwise>
                                                </xsl:choose>
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:federalBankingAgency)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Federal Banking Agency</em>
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:nationalCUAdmin)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												National Credit Union Administration
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:otherFederalAuthority)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other Federal Authority
											</div>
										</div>
										<div style="clear:both"></div>
									</div>





									<p>
										<b>B. Full name of the individual regulator (if not fully
											identified in Item 1-A.)
											or other authority that initiated the action.</b>
										For a
										<em>foreign financial regulatory
											authority</em>, please provide the full name in English.
									</p>

									<p>
										<div class="fakeBox">
				                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:name)" />
				                         <span>
				                             <xsl:text>&#160;</xsl:text>
				                       </span>
				                   </div>
									</p>


									<p>
										<b>2. Sanction(s) Sought:</b>
										Check all that apply.
									</p>

									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='BarPermanent'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Permanent)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Disgorgement'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Disgorgement
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Restitution'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Restitution
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='BarTemporary'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Temporary / Time Limited)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Expulsion'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Expulsion
											</div>
											<div class="tdStyle1 tdThreeCol">

												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Requalification'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Requalification
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Cease and Desist'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Cease and Desist
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Injunction'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Injunction
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Revocation'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Revocation
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Censure'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Censure
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Prohibition'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prohibition
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Suspension'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Suspension
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='CivilAdminPenaltyFine'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Civil and Administrative Penalty(ies)/Fine(s)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Reprimand'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Reprimand
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Undertaking'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Undertaking
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Denial'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Denial
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Rescission'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Rescission
											</div>
											<div class="tdStyle1 tdThreeCol">&#160;</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Other'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
														<b>Other Sanction(s) Sought</b>
														(list each such additional sanction):
														<br />
														<br />
														<div class="fakeBox">
									                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought/ns3:otherSanctions)" />
									                         <span>
									                             <xsl:text>&#160;</xsl:text>
									                       </span>
									                   </div>
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														<b>Other Sanction(s) Sought</b>
														(list each such additional sanction):
														<br />
														<br />

														<textarea name="textarea" cols="64" rows="6"
															readonly="1">

														</textarea>
													</xsl:otherwise>
												</xsl:choose>

											</div>

										</div>
										<div style="clear:both"></div>
									</div>



									<p>
									</p>

									<p>
										<b>3. Date Initiated</b>
										(MM/DD/YYYY):  
										<input type="text" name="firm name" readonly="1">
											<xsl:attribute name="value">
							                  <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:date)" />
							                  </xsl:attribute>
										</input>
										  
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
												&#160;Exact
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												&#160;Explanation
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:explanationInfo)&gt; 0">
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												&#160;Exact
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
												&#160;Explanation
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												&#160;Exact
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												&#160;Explanation
											</xsl:otherwise>
										</xsl:choose>
										          
									</p>


									<p>If not exact, provide explanation:  </p>

									<p>
										<div class="fakeBox">
                                                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:explanationInfo/n2:provideExplanation)" />
                                                             <span>
                                                                 <xsl:text>&#160;</xsl:text>
                                                           </span>
                                                       </div>
									</p>

									<p>
										<b>4. Regulatory Action was brought in</b>
										<em> (if brought in a foreign jurisdiction, provide all the
											information below in English):</em>
									</p>



									<p style="margin-left: 10px;">
										<b>A. Name of the Administrative <em>Proceeding</em>, <em>Commission</em>/Agency
											Hearing, or other regulatory <em>proceeding</em> or forum: </b>
										<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										  
									</p>

									<div class="tableStyle padded" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1">
												<strong><b>B. Location of the <em>Proceeding</em> / Hearing:  </b></strong>
											</div>
										</div>
										<div class="tableRow">

											<div class="tdStyle1 tdTwoCol1">
												<label>

													<input type="text" readonly="1" size="60">
														<xsl:attribute name="value">
															<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street1)" />
															</xsl:attribute>
													</input>
													<br />
													Street Address 1
												</label>
											</div>
											<div class="tdStyle1 tdTwoCol2">
												<label>

													<input type="text" readonly="1" size="60">
														<xsl:attribute name="value">
							<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street2)" />
							</xsl:attribute>
													</input>
													<br />
													Street Address 2
												</label>
											</div>
										</div>
										<div style="clear:both"></div>
									</div>
									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">

											<div class="tdStyle1 tdThreeCol">
												<label>
													<input type="text" readonly="1" size="37">
														<xsl:attribute name="value">
							<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:city)" />
							</xsl:attribute>
													</input>
													<br />
													City or County
												</label>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<label>
												<div class="fakeBox" style="min-width:235px;"> 
				                                       <span >
				                                            <xsl:call-template name="stateDescription">
				                                                <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
				                                             </xsl:call-template>
				                                        </span>
				                                         <span>
				                                             <xsl:text>&#160;</xsl:text>
				                                         </span>
				                                    </div>
													<br />
													State/Country
												</label>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<input type="text" name="postal code2" readonly="30">
													<xsl:attribute name="value">
														<xsl:value-of
														select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:zipCode)" />
														</xsl:attribute>
												</input>
												<br />
												Postal Code
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">

											<div class="tdStyle1 tdThreeCol">
												<p>
													<b>C. Docket/Case Number:</b>
														<div class="fakeBox">
								                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
								                         <span>
								                             <xsl:text>&#160;</xsl:text>
								                       </span>
								                   </div>
												</p>
											</div>
										</div>
										<div style="clear:both"></div>
									</div>

									<p>
										<b>5. A. Principal Product Type</b>
										(check appropriate item):
									</p>


									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='No Product'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												No Product

											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='AnnuityCharitable'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity – Charitable
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Direct Investment(s) - DPP &amp; LP Interest(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Direct
												Investment – DPP &amp; LP Interest
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='OilAndGas'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Oil
												&amp; Gas
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Annuity(ies) - Fixed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity – Fixed
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='EquipmentLeasing'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equipment Leasing
											</div>
											<div class="tdStyle1 tdThreeCol">

												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Options'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Options
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Annuity(ies) - Variable'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity – Variable
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Equity Listed (Common &amp; Preferred Stock)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Equity
												Listed (Common &amp; Preferred Stock)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Penny Sock(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Penny Stock
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='BankingProduct'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Banking Product
												<br />
												(other than CD)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Equity - OTC'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equity OTC
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='PrimeBankInstrument'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prime Bank Instrument
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='CD(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												CD
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Futures - Commodity'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Futures – Commodity
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Promissory Note'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Promissory Note
											</div>
										</div>
										<div style="clear:both"></div>


										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Commodity Option(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Commodity Option
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Futures - Financial'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Futures – Financial
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Real Estate Security'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Real Estate Security
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Asset Backed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Asset Backed
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Index Option(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Index Option
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Security Futures'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Security Futures
											</div>
										</div>
										<div style="clear:both"></div>


										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Corporate'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Corporate
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Insurance'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Insurance
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Security-based Swap'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Security-based Swap
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Government'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Government
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Investment Contract(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Investment Contract
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Swap'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Swap
											</div>
										</div>
										<div style="clear:both"></div>


										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Municipal'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Municipal
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Money Market Fund(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Money Market Fund
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Unit Investment Trust(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Unit Investment Trust
											</div>
										</div>
										<div style="clear:both"></div>


										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Derivative(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Derivative
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Mutual Fund(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Mutual Fund
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Viatical Settlement'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Viatical Settlement
											</div>
										</div>
										<div style="clear:both"></div>




										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Other'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
														<b>Other Principal Product Type</b> specify:
														<br />
														<br />
														<div class="fakeBox">
                                                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes/n2:productOther)" />
                                                             <span>
                                                                 <xsl:text>&#160;</xsl:text>
                                                           </span>
                                                       </div>
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														<b>Other Principal Product Type</b> specify:
														<br />
														<br />

														<textarea name="textarea" cols="64" rows="6"
															readonly="1">

														</textarea>
													</xsl:otherwise>
												</xsl:choose>

											</div>

										</div>
										<div style="clear:both"></div>
									</div>
									                                                         
									<br />

									  
								<b style="margin-left: 10px;">B.  Other Product Types?</b>
									    
								<span style="margin-left: 10px;">
									<xsl:choose>
										<xsl:when
											test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:otherProductTypes) &gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
											Yes
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											No
										</xsl:when>
										<xsl:when
											test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:otherProductTypes) &gt; 0)
											and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP) &gt; 0">
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											Yes
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
											No
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											Yes
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											No
										</xsl:otherwise>
									</xsl:choose>
									<p>      
										If &quot;Yes,&quot; describe each additional product type:  
									</p>

									<p>
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:otherProductTypes)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>
								</span>

									<p>
										<b>6. Allegations:</b>
										 Describe the allegations related to this regulatory action. 
										(The response must fit within the space provided.)
									</p>

									<p style="margin-left: 10px;">
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:allegationsDescription)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>
									<p>
										<b>7.     Current Status:</b>&#160;&#160;
										          
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:status/n1:pending)&gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												&#160;Pending
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;On Appeal
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;Final
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:status/n1:onAppeal)&gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;Pending
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												&#160;On Appeal
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;Final
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:status/n1:final)&gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;Pending
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;On Appeal
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												&#160;Final
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;Pending
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;On Appeal
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												&#160;Final
											</xsl:otherwise>
										</xsl:choose>
									</p>
									<p>
										<b>8.     Pending:  If you checked Item 7 Pending, provide the
											 following information.  </b>
									</p>
									<p style="margin-left: 10px;">
										<b>A. Date Served: </b>
										The date that notice or other process was served (MM/DD/YYYY):
										<input type="text" readonly="1">
											<xsl:attribute name="value">
							                  <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:date)" />
							                </xsl:attribute>
										</input>
										 
										<xsl:choose>  <!-- foo2 -->
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />

											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
									</p>



									<p style="margin-left: 10px;">If not exact, provide explanation:  </p>
									<p style="margin-left: 10px;">
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>
									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1 tditem10col1">
												<b>B. Limitation or Restrictions:  </b>
												Are there any limitations or restrictions currently in effect?
											</div>
											<div class="tdStyle1 tditem10col2">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:limitationsRestrictions) &gt; 0">
														<img src="Images/radio-checked.jpg" alt="radio button checked" />
														Yes
														<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														No
													</xsl:when>
													<xsl:when
														test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:limitationsRestrictions) &gt; 0)
																and (count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation) &gt; 0)">
														<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														Yes
														<img src="Images/radio-checked.jpg" alt="radio button checked" />
														No
													</xsl:when>
													<xsl:otherwise>
														<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														Yes
														<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
														No
													</xsl:otherwise>
												</xsl:choose>
											</div>
										</div>
										<div style="clear:both"></div>
									</div>
									<p>If the answer is &quot;Yes,&quot; provide details:  </p>
									<p>
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:limitationsRestrictions)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>

									<p>
										<b>9. On Appeal – Administrative or Judicial Review of the
											Regulatory Action:</b>
										If you appealed, provide the following information.
										<br />
										<br />
										<b>A. Name of Regulator or Court Action Appealed To: </b>
										<em>Provide the name of the US regulator (i.e., the SEC, an
											SRO, other), federal court, state court or state regulator,
											or a foreign or international court or regulator to whom you
											appealed. If brought in a foreign jurisdiction, provide all
											the information below in English.</em>
										<br />
										<br />
									
										<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:name)"/>
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                 </div>
										<br />
										<br />
										<b>B. Location of the Regulator or Judicial Court to Whom You
											Appealed:</b>
										<br />
										<br />
										Street Address 1:
										<input type="text" name="RegulatororStreetAddress"
											readonly="1" size="60">
											<xsl:attribute name="value">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street1)" />
											</xsl:attribute>
										</input>

										&#160;&#160;Street Address 2:
										<input type="text" name="RegulatororStreetAddress"
											readonly="1" size="60">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street2)" />
							</xsl:attribute>
										</input>
										<br />
										<br />
                                       <div class="tableStyle" style="margin-left:0; margin-right:0;">
                                       <div class="tableRow">
                                       <div class="tdStyle1 tdThreeCol">
										City or County:
										<input type="text" name="RegulatororCityorCounty"
											readonly="1" size="35">
											<xsl:attribute name="value">
							                     <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:city)" />
							                 </xsl:attribute>
										</input>
                                         </div>
                                         <div class="tdStyle1 tdThreeCol">
										&#160;&#160;State/Country:
										<div class="fakeBox" style="min-width:235px;"> 
                                       <span >
                                            <xsl:call-template name="stateDescription">
                                                <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:stateOrCountry)" />
                                             </xsl:call-template>
                                        </span>
                                         <span>
                                             <xsl:text>&#160;</xsl:text>
                                         </span>
                                       </div>
                                       </div>
										<div class="tdStyle1 tdThreeCol">
										Postal Code:
										<input type="text" name="RegulatororZipCode" readonly="1"
											size="30">
											<xsl:attribute name="value">
						                  	<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:zipCode)" />
							             </xsl:attribute>
							            
										</input>
										 </div>
										</div>
										<div style="clear:both"></div>
									</div>
									</p>


									<p>
										<b>
											C. Docket/Case Name:
										</b>
										<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:docketName)"/>
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										<br />
										<br />

										<b>D. Docket/Case Number:</b>
										<div class="fakeBox">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:docketOrCaseNo)" />
											<span>
												<xsl:text>&#160;</xsl:text>
											</span>
										</div>
										<br />
										<br />
										<b>E. Date Appeal filed </b>
										(MM/DD/YYYY):
										<input type="text" name="RegulatorordocketOrCaseNo"
											readonly="1">
											<xsl:attribute name="value">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:date)" />
											</xsl:attribute>
										</input>

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 

										<p>If not exact, provide explanation:   </p>
										<p>
											<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										</p>

										<b>F. Appeal Details (including status): </b>
										<br />
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:details)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
										<br />
										<br />
										<b> G. Limitation or Restrictions:  </b>
										Are there any limitations or restrictions currently in effect
										while on appeal?
									   <xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:limitationsRestrictions) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:limitationsRestrictions) &gt; 0)
													and (count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation) &gt; 0)">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
							       	<br />
										If the answer is &quot;Yes,&quot; provide details:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:limitationsRestrictions)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div> 

									</p>

									<p>
									<b>If you checked Item 7 Final or On Appeal, complete Items 10 through 13. For Pending Actions, skip to Item 13.</b>
									</p>




									<p>
										<b>10.  A.    Resolution: </b>
										How the action was resolved?
										<em>(Check all the applicable boxes that reflect the most
											recent resolution of the action by a regulator or a court,
											whether or not any part of the resolution is on appeal. If
											any part of the resolution is on appeal, identify in Item
										   10-B which part is currently on appeal.)</em>
									</p>

									<div class="tableStyle" style="margin-left:0; margin-right:0;">

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Acceptance Waiver &amp; Consent (AWC)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Acceptance, Waiver &amp; Consent (AWC)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Dismissed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Dismissed
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Stipulation and Consent'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Stipulation and Consent
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Consent'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Consent
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Judgement Rendered'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Judgment Rendered
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Withdrawn'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Withdrawn
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Decision
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Order'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Order</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Other'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other: (requires explanation)
												<br />


											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision &amp; Order of Offer of Settlement'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Decision
												&amp;
												<em>Order</em>
												of Offer of Settlement
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Settled'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Settled
											</div>
											<div class="tdStyle1 tdThreeCol">&#160;</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Appealed
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<div class="tableStyle"  style="margin-left:0; margin-right:0;">

													<div class="tableRow">
														<div class="tdStyle1">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Affirmed'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Affirmed
														</div>
													</div>
													<div class="tableRow">
														<div class="tdStyle1">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated Nunc Pro Tunc / ab initio'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Vacated Nunc Pro Tunc / ab initio
														</div>
													</div>
													<div class="tableRow">
														<div class="tdStyle1">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated &amp; Returned For Further Action'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>Vacated
															&amp; Returned For Further Action
														</div>
													</div>
													<div class="tableRow">

														<div class="tdStyle1">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated / Final'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Vacated / Final
														</div>
													</div>
													<div class="tableRow">


														<div class="tdStyle1">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Other'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Other: (requires explanation)
														</div>
													</div>
												</div>


											</div>
										</div>
										<div style="clear:both"></div>

									</div>





									<p>
										<b>
											B. Explanation:   </b>
										<em> (If more than one box in Item 10-A. is checked or Item 10-A. otherwise does not adequately summarize the type of resolution, provide an explanation.
										     For example, if you appealed all or part of a resolution by the regulator or court, indicate what is being appealed.)</em>
									</p>
									<p>
										<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:explanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
									</p>
									<p>
										<b>
											C.
											<em>Order</em>:
											  If <em>Order</em> is checked above in Item 10-A.,
										</b>
										does the <em>order</em> constitute a final <em>order</em>
										 based on violations of any laws or regulations that prohibit
										 fraudulent, or deceptive conduct?
										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder = 'Y'">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder = 'N'">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
									</p>




									<p>
										<b>11.  Resolution Date </b>
										(MM/DD/YYYY):
										<input type="text" name="resolutionInformationDate"
											readonly="1">
											<xsl:attribute name="value">
				<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:date) " />
				</xsl:attribute>
										</input>
										 


										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact     
										   
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
									</p>
									<p>
											<em>(For a resolution that is being appealed in part, the
												date to be provided should be the date on which the
												regulator (reviewing a decision by an SRO or an
												Administrative Law Judge) or a court provided its
												resolution.)  </em>
									</p>
										<p>If not exact, provide explanation:   </p>
										<p>
											<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										</p>

									<p><b>12.  Resolution Detail:  </b></p>

									<p>
										<b>
											A. Sanctions: Were any Sanctions <em>Ordered? </em>
										</b>

										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'Y'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										 Yes

										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'N'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										  No	</p>
										 
									<p>
										<b>B.    If &quot;Yes,&quot; check each individual sanction
											below that was <em>ordered</em>:   </b>
										<p>
											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='BarPermanent'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														 Bar (Permanent)
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Disgorgement'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Disgorgement*
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Restitution'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Restitution*
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='BarTemporary'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Bar (Temporary / Time Limited)
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Expulsion'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Expulsion
													</div>
													<div class="tdStyle1 tdThreeCol">

														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Requalification'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Requalification
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Cease and Desist'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Cease and Desist
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Injunction'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Injunction
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Revocation'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Revocation
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Censure'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Censure
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Prohibition'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Prohibition
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Suspension'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Suspension
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='CivilAdminPenaltyFine'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Civil and Administrative Penalty(ies)/Monetary Fine(s)*
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Reprimand'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Reprimand
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Undertaking'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Undertaking
													</div>
												</div>
												<div style="clear:both"></div>


												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Denial'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Denial
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Rescission'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Rescission
													</div>
												</div>
												<div style="clear:both"></div>


											</div>



										</p>


									</p>

									<p>
										<b>&#8226; Monetary Sanction(s):</b>
										Were one or more sanctions <em>ordered</em> that require a monetary payment?  
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) &gt; 0)
													and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details) &gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
										<p>
											 If &quot;Yes,&quot; enter the total amount <em>ordered</em>:
											<xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)">
                                
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
		                        </xsl:call-template>
		                      </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
										</p>
									</p>



									<p>
										 

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Other'])&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										<b>
											Other Sanctions <em>Ordered</em>
											(list each such additional sanction):
										</b>
									</p>

									<p>
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Other'])&gt; 0">
												<div class="fakeBox">
							                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions/ns3:otherSanctions)" />
							                         <span>
							                             <xsl:text>&#160;</xsl:text>
							                       </span>
							                   </div>
											</xsl:when>
											<xsl:otherwise>
												<textarea name="otherSanctions" id="otherSanctions"
													cols="64" rows="6"></textarea>
											</xsl:otherwise>
										</xsl:choose>
									</p>

									<p>
										<br />
									</p>
									<p>
										<b>C.    Sanction Detail
										(Provide the details of the following specific sanctions, if
										checked above in Item 12-B.)</b>

										<p>
											 
											<b>(1)  Barred, <em>Enjoined</em>, or Suspended:</b>
											
											If you checked one or more of these sanctions in Item 12-B.
											above, check the
											applicable box(es) below and provide the corresponding information.
										</p>

										<p>
											       
											<b>(a)  Barred</b>
											 
										</p>
										<p>
											If the applicant or an
											<em>associated person</em>
											received in the above action one or more bars from
											registration capacities, associations, and/or other
											activities, and the terms specify different time periods,
											report each in a separate entry.
										</p>
										<p>
											              (i) Duration (length of time):
											<br />
											<br />

											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Permanent (not limited by length of time).
											<br />
											<br />
											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Temporary / Time Limited. Specify the:

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Days
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
											</input>

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Months
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
											</input>
											<br />
											                                                          
											                               
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Years
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
											</input>

										</p>



										<p>
											              (ii) Start Date (MM/DD/YYYY):

											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:date)" />
</xsl:attribute>
											</input>

											 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:exact)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact        
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation 
											<br />
											<br />

											                 If not exact, provide explanation:
											<br />
											<p>
											<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
						                   </p>
										</p>



										<p>
											              (iii) End Date (MM/DD/YYYY):

											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:date)" />
</xsl:attribute>
											</input>

											 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:exact)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact        
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation 
											<br />
											<br />

											                 If not exact, provide explanation:
											<br />
											<div class="fakeBox">
                                                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo/n2:provideExplanation)" />
                                                 <span>
                                                     <xsl:text>&#160;</xsl:text>
                                               </span>
                                           </div>
										</p>


										<p>
											              (iv) Description: Provide remaining details and
											the registration capacities affected
											<br />
											                    (General Securities Principal, Financial
											Operations Principal, etc.). If none, enter &quot;None&quot;:
										</p>
                                        <div class="fakeBox">
                                                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:description)" />
                                                 <span>
                                                     <xsl:text>&#160;</xsl:text>
                                               </span>
                                           </div>




										<p>
											<b>(b)  <em>Enjoined</em></b>
										</p>
										<p>
											If the applicant or an
											<em>associated person</em>
											received in the above action one or more injunctions from
											registration capacities, associations, and/or other
											activities, and the terms specify different time periods,
											report each in a separate entry.
										</p>
										<p>
											              (i) Duration (length of time):
											<br />
											<br />

											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Permanent (not limited by length of time)
											<br />
											<br />
											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Temporary / Time Limited. Specify the:

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Days
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
											</input>

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Months
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
											</input>
											<br />
											                                                          
											                               
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Years
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
											</input>

										</p>
									</p>


									<p>
										              (ii) Start Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>



									<p>
										              (iii) End Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>


									<p>
										              (iv) Description: Provide remaining details and
										the registration capacities affected
										<br />
										                    (General Securities Principal, Financial
										Operations Principal, etc.). If none, enter &quot;None&quot;:
									</p>
									<div class="fakeBox">
				                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:description)" />
				                         <span>
				                             <xsl:text>&#160;</xsl:text>
				                       </span>
				                   </div>
									<p>
										<b>(c)  Suspended</b>
									</p>
									<p>
										If the applicant or an
										<em>associated person</em>
										received in the above one or more suspensions from
										registration capacities, associations, and/or other
										activities, and the terms specify different time periods,
										report each in a separate entry.
									</p>
									<p>
										              (i) Duration (length of time):
										<br />
										<br />

										                 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Permanent (not limited by length of time)
										<br />
										<br />
										                 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Temporary / Time Limited. Specify the:

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Days
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
										</input>

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Months
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
										</input>
										<br />
										                                                          
										                               
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Years
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
										</input>

									</p>



									<p>
										              (ii) Start Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>



									<p>
										              (iii) End Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>


									<p>
										              (iv) Description: Provide remaining details and
										the registration capacities affected
										<br />
										                    (General Securities Principal, Financial
										Operations Principal, etc.). If none, enter &quot;None&quot;:
									</p>
                                    <div class="fakeBox">
				                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:description)" />
				                         <span>
				                             <xsl:text>&#160;</xsl:text>
				                       </span>
				                   </div>

									<p>
									</p>

									<p>
										<b>(2)   Requalification:</b>
										<br /><br />
										   Was requalification by examination, retraining, or other
										process a condition of a sanction?
										
										                                        
										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'Y'">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										YES
										 
										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'N'">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										NO
									</p>
<p>
If the applicant or an <em>associated person</em> received in the above action one or more requalifications 
in connection with 
registration capacities, associations, and/or other activities, and the terms specify different time 
periods, report each in a separate entry.  
</p>


									<p>If &quot;Yes,&quot; provide the following details: </p>

									<p>
										  (a) Length of time given to requalify, retrain,
										     or complete other process:
										<br />

										                  
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:noTimeSpecified)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										No time period is specified.
										<br />
										<br />
										                 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Time period is specified:

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Days
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
										</input>

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Months
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
										</input>
										<br />
										                                                       
										          
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Years
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
										</input>



									</p>

									<p>
										(b) Type of examination, retraining, or other process
										required:
										<br />
										<br />
										 <div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:typeRequired)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>

									<p>
										 (c)  Was the condition satisfied?     
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												YES
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												NO
											</xsl:when>
											<xsl:when
                                    test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:notSatisfied) &gt; 0">
                                     <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                     YES
                                      <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                     NO
                                 </xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>

										<p>      
											     (1)   If &quot;Yes,&quot; provide the date (MM/DD/YYYY):
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied)" />
</xsl:attribute>
											</input>
										</p>
										<p>            (2)   If &quot;No,&quot; explain the
											circumstances:   </p>

										<p>
											<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:notSatisfied)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										</p>

									</p>


									<p>
										<b>(3)   Monetary Sanction(s): </b>
										If you indicated in Item 12-B above that one or more monetary
										sanctions were <em>ordered</em>, provide the following information.
									</p>

									<p>
										(a) Total Amount <em>Ordered</em>: 
										<xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)">
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
		                        </xsl:call-template>
                               </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
									</p>

									<p> (b) Portion levied against:  </p>

									<xsl:choose>
										<xsl:when
											test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered &gt; 0 ">
											<img src="Images/box-checked.jpg" alt="checkbox checked" />
								
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									<b>Applicant</b>


									<p>
										  (i) Amount <em>Ordered</em>:                 
										<xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered)">
                                
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered" />
		                        </xsl:call-template>
                                </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                         </xsl:choose>
								</p>
									<p>
										  (ii) Was any portion waived? 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="not(count(ns3:drpInfo/ns3:filedDisclosure)&gt; 0)
												and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered) &gt; 0 
												and not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0)">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>

										If &quot;Yes,&quot; how much?     
										<xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion)">
                                
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion" />
		                         </xsl:call-template>
                                </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
										 
									</p>

									<p>
										  (iii) Final Amount:  
										<xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount)">
                                
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount" />
		                         </xsl:call-template>
                                </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
										  
									</p>

									<p>
										  (iv) Was final amount paid in full?    
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied) &gt; 0">
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                Yes
                                                 <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                No
                                            </xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
									</p>

									<p>  
										   If &quot;Yes,&quot; date paid in full (MM/DD/YYYY):
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied)" />
</xsl:attribute>
										</input>
										  
									</p>

									<p>    
										If &quot;No,&quot; explain the circumstances:

										<p>
										<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>  
										</p>

									</p>
                                    <!-- 
                                    Always the Associated Person is uncheced in the Applicant block
                                     -->
                                      <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                      
                                    <b><em>Associated Person</em></b>


                                    <p>
                                          (i) Amount <em>Ordered</em>:
                                         $<input type="text" name="text49" readonly="1">
                                         </input>
                                         
                                    </p>

                                    <p>
                                          (ii) Was any portion waived? 
																	<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
																	Yes
																	<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
																	No

                                        If &quot;Yes,&quot; how much?      $
                                        <input type="text" name="text49" readonly="1">
                                        </input>
                                         
                                    </p>

                                    <p>
                                          (iii) Final Amount:                         $
                                        <input type="text" name="text49" readonly="1">
                                       </input>
                                          
                                    </p>

                                    <p>
                                          (iv) Was final amount paid in full?    
                                        <xsl:choose>
                                            <xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied) &gt; 0">
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                Yes
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                No
                                            </xsl:when>
                                            <xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied) &gt; 0">
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                Yes
                                               <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                No
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                Yes
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                No
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </p>

                                    <p>  
                                           If &quot;Yes,&quot; date paid in full (MM/DD/YYYY):
                                        <input type="text" name="text49" readonly="1">
                                        </input>
                                          
                                    </p>

                                    <p>    
                                        If &quot;No,&quot; explain the circumstances:

                                        <p>
                                                
                                            <textarea name="textarea17" cols="64" rows="6">
                                            </textarea>
                                        </p>

                                    </p>
									<p><b>Provide the information for each additional <em>associated person</em> below:</b></p>
									<p>
										<b>13.  Summary of Circumstances:</b>
									</p>

									<p>
										Use this space to provide a brief summary of the circumstances
										leading to the action, allegation(s), finding(s) and
										disposition(s),
										if any. Include any relevant information on the current action
										status, and on any terms, conditions, and dates not already
										provided
										above, and any other relevant information. The information must fit
										within the space provided.
									</p>

									<p>
									<div class="fakeBox">
				                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:summary)" />
				                         <span>
				                             <xsl:text>&#160;</xsl:text>
				                       </span>
				                   </div>
									</p>
								</xsl:otherwise>
								</xsl:choose>	
								</xsl:for-each>
								<!-- <h3>Associated Persons</h3> -->
								<xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
								<xsl:choose>
                                     <xsl:when
                                       test="count(ns3:drpInfo/ns3:filedDisclosure/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosure/ns3:maiFiling)&gt; 0">
                                     </xsl:when>
                                      <xsl:otherwise>
									<br /><br /><h1>REGULATORY ACTION DRP PART 2</h1>
									
									<p>
										1.     Regulatory Action was initiated by:    
										<em> (Select only one. A separate Regulatory Action DRP is
											required for each such regulator or other authority.)</em>
									</p>

									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:sec)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>SEC</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:state)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												State
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:otherFederalAuthority)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Foreign Financial Regulatory Authority</em>
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:cftc)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>CFTC</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:sro)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>SRO</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:other)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" /> Other: (specify)
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Other: (specify)
														
													</xsl:otherwise>
												</xsl:choose>
												<xsl:choose>
                                                    <xsl:when
                                                        test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:other)&gt; 0">
                                                        <div class="fakeBox">
                                                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:other)" />
                                                             <span>
                                                                 <xsl:text>&#160;</xsl:text>
                                                           </span>
                                                       </div>
                                                    </xsl:when>
                                                    <xsl:otherwise>

                                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                       
                                                        <input type="text" readonly="1">
                                                        </input>
                                                    </xsl:otherwise>
                                                </xsl:choose>
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:federalBankingAgency)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Federal Banking Agency</em>
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:nationalCUAdmin)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												National Credit Union Administration
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:initiator/n2:otherFederalAuthority)&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other Federal Authority
											</div>
										</div>
										<div style="clear:both"></div>
									</div>

									<p>
										<b>B. Full name of the individual regulator (if not fully
											identified in Item 1-A.)
											or other authority that initiated the action.</b>
										For a
										<em>foreign financial regulatory
											authority</em>, please provide the full name in English.
									</p>

									<p>
									  <div class="fakeBox">
							             <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:initiatedBy/n2:name)" />
									  </div>
									</p>


									<p>
										<b>2. Sanction(s) Sought:</b>
										Check all that apply.
									</p>

									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='BarPermanent'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Permanent)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Disgorgement'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Disgorgement
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Restitution'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Restitution
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='BarTemporary'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Temporary / Time Limited)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Expulsion'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Expulsion
											</div>
											<div class="tdStyle1 tdThreeCol">

												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Requalification'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Requalification
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Cease and Desist'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Cease and Desist
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Injunction'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Injunction
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Revocation'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Revocation
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Censure'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Censure
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Prohibition'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prohibition
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Suspension'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Suspension
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='CivilAdminPenaltyFine'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Civil/Administrative Penalty(ies)/Fine(s)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Reprimand'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Reprimand
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Undertaking'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Undertaking
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Denial'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Denial
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Rescission'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Rescission
											</div>
											<div class="tdStyle1 tdThreeCol">&#160;</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought[ns3:sanction='Other'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
														<b>Other Sanction(s) Sought</b>
														(list each such additional sanction):
														<br />
														<br />
														  <div class="fakeBox">
															<xsl:value-of
																select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:sanctionsSought/ns3:otherSanctions)" />
														  </div>
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														<b>Other Sanction(s) Sought</b>
														(list each such additional sanction):
														<br />
														<br />

														<textarea name="textarea" cols="64" rows="6"
															readonly="1">

														</textarea>
													</xsl:otherwise>
												</xsl:choose>

											</div>

										</div>
										<div style="clear:both"></div>
									</div>



									<p>
									</p>

									<p>
										3.
										<b>Date Initiated</b>
										(MM/DD/YYYY):  
										<input type="text" name="firm name" readonly="1">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:date)" />
							</xsl:attribute>
										</input>
										  
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
												Exact
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												Explanation
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:explanationInfo)&gt; 0">
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												Exact
												<img src="Images/box-checked.jpg" alt="checkbox checked" />
												Explanation
											</xsl:when>
										</xsl:choose>
										          
									</p>


									<p>If not exact, provide explanation:  </p>

									<p>
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:dateInitiated/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>

									<p>
										<b>4. Regulatory Action was brought in</b>
										<em>(if brought in a foreign jurisdiction, provide all the
											information below in English):</em>
									</p>



									<p>
										<b>A. Name of the Administrative <em>Proceeding</em>, <em>Commission</em>/Agency
											Hearing, or other regulatory <em>proceeding</em> or forum: </b>
										<div class="fakeBox">
							              <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
										  </div>
									</p>

									<div class="tableStyle padded" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1">
												<strong><b>B. Location of the <em>Proceeding</em> / Hearing:  </b></strong>
											</div>
										</div>
										<div class="tableRow">

											<div class="tdStyle1 tdTwoCol1">
												<label>

													<input type="text" readonly="1" size="60">
														<xsl:attribute name="value">
															<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street1)" />
															</xsl:attribute>
													</input>
													<br />
													Street Address 1
												</label>
											</div>
											<div class="tdStyle1 tdTwoCol2">
												<label>

													<input type="text" readonly="1" size="60">
														<xsl:attribute name="value">
							<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street2)" />
							</xsl:attribute>
													</input>
													<br />
													Street Address 2
												</label>
											</div>
										</div>
										<div style="clear:both"></div>

									</div>
									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">

											<div class="tdStyle1 tdThreeCol">
												<label>
													<input type="text" readonly="1" size="40">
														<xsl:attribute name="value">
							<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:city)" />
							</xsl:attribute>
													</input>
													<br />
													City or County
												</label>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<label>
													<div class="fakeBox" style="min-width:235px;"> 
				                                       <span >
				                                            <xsl:call-template name="stateDescription">
				                                                <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
				                                             </xsl:call-template>
				                                        </span>
				                                         <span>
				                                             <xsl:text>&#160;</xsl:text>
				                                         </span>
				                                    </div>
													<br />
													State/Country
												</label>
											</div>
											<div class="tdStyle1 tdThreeCol">
											
												<input type="text" name="postal code2" readonly="30">
													<xsl:attribute name="value">
														<xsl:value-of
														select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:zipCode)" />
														</xsl:attribute>
												</input>
												
												
												<br />
												Postal Code
											</div>
										</div>
										<div style="clear:both"></div>
									</div>
									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">

											<div class="tdStyle1">
												<p>
													<b>C. Docket/Case Number:</b>
													<div class="fakeBox">
														<xsl:value-of
															select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
														<span>
															<xsl:text>&#160;</xsl:text>
														</span>
													</div>
												</p>
											</div>
										</div>
									</div>
									<p>
										<b>5. A. Principal Product Type</b>
										(check appropriate item):
									</p>


									<div class="tableStyle" style="margin-left:0; margin-right:0;">
										<div class="tableRow">
											<div class="tdStyle1">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='No Product'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												No Product

											</div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='AnnuityCharitable'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity – Charitable
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Direct Investment(s) - DPP &amp; LP Interest(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Direct
												Investment – DPP &amp; LP Interest
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='OilAndGas'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Oil
												&amp; Gas
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Annuity(ies) - Fixed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity – Fixed
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='EquipmentLeasing'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equipment Leasing
											</div>
											<div class="tdStyle1 tdThreeCol">

												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Options'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Options
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Annuity(ies) - Variable'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity – Variable
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Equity Listed (Common &amp; Preferred Stock)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Equity
												Listed (Common &amp; Preferred Stock)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Penny Sock(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Penny Stock
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='BankingProduct'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Banking Product
												<br />
												(other than CD)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Equity - OTC'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equity OTC
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='PrimeBankInstrument'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prime Bank Instrument
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='CD(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												CD
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Futures - Commodity'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Futures – Commodity
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Promissory Note'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Promissory Note
											</div>
										</div>
										<div style="clear:both"></div>


										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Commodity Option(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Commodity Option
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Futures - Financial'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Futures – Financial
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Real Estate Security'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Real Estate Security
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Asset Backed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Asset Backed
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Index Option(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Index Option
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Security Futures'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Security Futures
											</div>
										</div>
										<div style="clear:both"></div>


										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Corporate'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Corporate
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Insurance'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Insurance
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Security-based Swap'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Security-based Swap
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Government'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Government
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Investment Contract(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Investment Contract
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Swap'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Swap
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Debt - Municipal'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Debt – Municipal
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Money Market Fund(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Money Market Fund
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Unit Investment Trust(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Unit Investment Trust
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Derivative(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Derivative
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Mutual Fund(s)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Mutual Fund
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Viatical Settlement'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Viatical Settlement
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes[n2:product='Other'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
														<b>Other Principal Product Type</b> specify:
														<br />
														<br />
														<div class="fakeBox">
								                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:principalProductTypes/n2:productOther)" />
								                         <span>
								                             <xsl:text>&#160;</xsl:text>
								                       </span>
								                   </div>
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														<b>Other Principal Product Type</b> specify:
														<br />
														<br />

														<textarea name="textarea" cols="64" rows="6"
															readonly="1">

														</textarea>
													</xsl:otherwise>
												</xsl:choose>

											</div>

										</div>
										<div style="clear:both"></div>
									</div>
									                                                         
									<br />
									  
									<b>B.  Other Product Types?</b>
									<xsl:choose>
										<xsl:when
											test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:otherProductTypes)&gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
											YES
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											No
										</xsl:when>
										<xsl:when
											test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:otherProductTypes)&gt; 0)
												and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP) &gt; 0">

											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											YES
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
											No
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											YES
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											NO
										</xsl:otherwise>
									</xsl:choose>
									<p>      
									 If &quot;Yes,&quot; describe each additional product type:     
									</p>



									<p>
									  <div class="fakeBox">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:otherProductTypes)" />
									  </div>
									</p>

									<p>
										<b>6. Allegations:</b>
										Describe the allegations related to this regulatory action. 
										(The response must fit within the space provided.)
									</p>



									<p>
									  <div class="fakeBox">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:allegationsDescription)" />
									  </div>
									</p>


									<p>
										<b>7. Current Status:</b>
										          
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/ns2:status/ns1:pending)&gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Pending
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												On Appeal
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Final
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/ns2:status/ns1:onAppeal)&gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Pending
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												On Appeal
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Final
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/ns2:status/ns1:final)&gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Pending
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												On Appeal
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Final
											</xsl:when>

										</xsl:choose>
										 
									</p>


									<p>
										<b>8.     Pending:  If you checked Item 7 Pending, provide the
											following information.  </b>
									</p>
									<p>
										<b>A. Date Served: </b>
										The date that notice or other process was served (MM/DD/YYYY):
										<input type="text" readonly="1">
											<xsl:attribute name="value">
							                  <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:date)" />
							                </xsl:attribute>
										</input>
										 
										<xsl:choose>  <!-- foo2 -->
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />

											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
									</p>



									<p>If not exact, provide explanation:  </p>
									<p>
									  <div class="fakeBox">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo/n2:provideExplanation)" />
									  </div>
									</p>

									<b>B. Limitation or Restrictions:  </b>
									Are there any limitations or restrictions currently in effect?

									<xsl:choose>
										<xsl:when
											test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:limitationsRestrictions)&gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
											YES
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											No
										</xsl:when>
										<xsl:when
											test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:limitationsRestrictions)&gt; 0)
												and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation) &gt; 0">
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											YES
											<img src="Images/radio-checked.jpg" alt="radio button checked" />
											No
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											YES
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											NO
										</xsl:otherwise>
									</xsl:choose>
									<p>If the answer is &quot;Yes,&quot; provide details:  </p>
									<p>
									  <div class="fakeBox">
											<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:pendingInformation/ns3:limitationsRestrictions)" />
									  </div>
									</p>

									<p>
										<b>9. On Appeal – Administrative or Judicial Review of the
											Regulatory Action:</b>
										If you appealed, provide the following information.
										<br />
										<br />
										<b>A. Name of Regulator or Court Action Appealed To: </b>
										<em>Provide the name of the US regulator (i.e., the SEC, an
											SRO, other), federal court, state court or state regulator,
											or a foreign or international court or regulator to whom you
											appealed. If brought in a foreign jurisdiction, provide all
											the information below in English.</em>
										<br />
										<br />
										<input type="text" name="NameofRegulatororCourt"
											readonly="1">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:name)" />
							</xsl:attribute>
										</input>
										<br />
										<br />
										<b>B. Location of the Regulator or Judicial Court to Whom You
											Appealed:</b>
										<br />
										<br />
										Street Address 1:
										<input type="text" name="RegulatororStreetAddress"
											readonly="1">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street1)" />
							</xsl:attribute>
										</input>

										&#160;&#160;Street Address 2:
										<input type="text" name="RegulatororStreetAddress"
											readonly="1">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street2)" />
							</xsl:attribute>
										</input>
										<br />
										<br />
                                        <div class="tableStyle" style="margin-left:0; margin-right:0;">
                                        <div class="tableRow">
                                        <div class="tdStyle1 tdTwoCol1">
										City or County:
										<input type="text" name="RegulatororCityorCounty"
											readonly="1">
											<xsl:attribute name="value">
							                     <xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:city)" />
							                 </xsl:attribute>
										</input>
										</div>
										<div class="tdStyle1 tdTwoCol2">
  
										State/Country:
										<div class="fakeBox"> 
                                       <span >
                                            <xsl:call-template name="stateDescription">
                                                <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:stateOrCountry)" />
                                             </xsl:call-template>
                                        </span>
                                         <span>
                                             <xsl:text>&#160;</xsl:text>
                                         </span>
                                    </div>
										</div>
										</div>
										<div style="clear:both"></div>
										</div>
										<br />
										<br />

										Postal Code:
										<input type="text" name="RegulatororZipCode" readonly="1">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:zipCode)" />
							</xsl:attribute>
										</input>
									</p>


									<p>
										<b>
											C. Docket/Case Name:
										</b>
										<div class="fakeBox">
                                                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:docketName)"/>
                                                 <span>
                                                     <xsl:text>&#160;</xsl:text>
                                               </span>
                                           </div>
										<br />
										<br />

										<b>D. Docket/Case Number:</b>
										<div class="fakeBox">
                                                        <xsl:value-of
                                                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:appealBroughtInInformation/n2:docketOrCaseNo)" />
                                                        <span>
                                                            <xsl:text>&#160;</xsl:text>
                                                        </span>
                                                    </div>
										<br />
										<br />
										<b>E. Date Appeal filed </b>
										(MM/DD/YYYY):
										<input type="text" name="RegulatorordocketOrCaseNo"
											readonly="1">
											<xsl:attribute name="value">
							<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:date)" />
							</xsl:attribute>
										</input>

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 

										<p>If not exact, provide explanation:   </p>
										<p>
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:dateInformation/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
										</p>

										<b>F. Appeal Details (including status): </b>
										<br />
										<br />
										 <div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:details)" />

					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
										<br />
										<br />
										<b> G. Limitation or Restrictions:  </b>
										Are there any limitations or restrictions currently in effect
										while on appeal?

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:limitationsRestrictions)&gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:limitationsRestrictions) &gt; 0)
														and (count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation) &gt; 0)">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
										<br />
										<br />
										If the answer is &quot;Yes,&quot; provide details:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:appealInformation/ns3:limitationsRestrictions)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>

									</p>


									<p>
									<b>
										If you checked Item 7 Final or On Appeal, complete Items 10 through 13. For Pending Actions, skip to Item 13.
									</b>
									</p>



									<p>
										<b>10.  A.    Resolution: </b>
										How the action was resolved?
										<em>(Check all the applicable boxes that reflect the most
											recent resolution of the matter by a regulator or a court,
											whether or not any part of the resolution is on appeal. If
											any part of the resolution is on appeal, identify in Item
										   10-B which part is currently on appeal.)</em>
									</p>

									<div class="tableStyle" style="margin-left:0; margin-right:0;">

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Acceptance Waiver &amp; Consent (AWC)'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Acceptance,
												Waiver &amp; Consent (AWC)
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Dismissed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Dismissed
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Stipulation and Consent'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Stipulation and Consent
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Consent'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Consent
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Judgement Rendered'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Judgment Rendered
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Withdrawn'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Withdrawn
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Decision
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Order'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Order</em>
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Other'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other: (requires explanation)
                                               
											</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision &amp; Order of Offer of Settlement'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Decision
												&amp;
												<em>Order</em>
												of Offer of Settlement
											</div>
											<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Settled'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Settled
											</div>
											<div class="tdStyle1 tdThreeCol">&#160;</div>
										</div>
										<div style="clear:both"></div>

										<div class="tableRow">
											<div class="tdStyle1 ">
												<xsl:choose>
													<xsl:when
														test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0">

														<img src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Appealed
											</div>
										</div>
										<div style="clear:both"></div>
										<div class="tableRow">
											<div class="tdStyle1 ">

												<div class="tableStyle"  style="margin-left:0; margin-right:0;">

													<div class="tableRow">
														<div class="tdStyle1 ">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Affirmed'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Affirmed
														</div>
													</div>
													<div style="clear:both"></div>
													<div class="tableRow">
														<div class="tdStyle1 ">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated Nunc Pro Tunc / ab initio'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Vacated Nunc Pro Tunc / ab initio
														</div>
													</div>
													<div style="clear:both"></div>
													<div class="tableRow">
														<div class="tdStyle1 ">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated &amp; Returned For Further Action'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>Vacated
															&amp; Returned For Further Action
														</div>
													</div>
													<div style="clear:both"></div>
													<div class="tableRow">

														<div class="tdStyle1 ">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated / Final'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Vacated / Final
														</div>
													</div>
													<div style="clear:both"></div>
													<div class="tableRow">


														<div class="tdStyle1 ">
															              
															<xsl:choose>
																<xsl:when
																	test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Other'])&gt; 0">

																	<img src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>

																	<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
															Other: (requires explanation)

														</div>
													</div>
													<div style="clear:both"></div>
												</div>


											</div>
										</div>
										<div style="clear:both"></div>

									</div>





									<p>
										<b>B.    Explanation: </b>
										<em> (If more than one box in Item 10-A. is checked or Item 10-A. otherwise does not adequately summarize the type of resolution, provide an explanation.
										     For example, if you appealed all or part of a resolution by the regulator or court, indicate what is being appealed.)</em>
									</p>
									<p>
									 <div class="fakeBox">
                                                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:explanation)" />
                                                 <span>
                                                     <xsl:text>&#160;</xsl:text>
                                               </span>
                                             </div>
									</p>

									<p>
										<b>
											C.
											<em>Order:</em>
											If
											<em>Order</em>
											is checked above in Item 10-A.,
										</b>
										does the <em>order</em> constitute a final <em>order</em>
										 based on violations of any laws or regulations that prohibit
										 fraudulent, or deceptive conduct?
										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder = 'Y'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder = 'N'">

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
									</p>

									<p>
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:types/ns3:explanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>




									<p>
										<b>11.  Resolution Date </b>
										(MM/DD/YYYY):
										<input type="text" name="resolutionInformationDate"
											readonly="1">
											<xsl:attribute name="value">
				<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:date) " />
				</xsl:attribute>
										</input>
										 


										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact     
										   
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<p>
											<em>(For a resolution that is being appealed in part, the
												date to be provided should be the date on which the
												regulator (reviewing a decision by an SRO or an
												Administrative Law Judge) or a court provided its
												resolution.)  </em>
										</p>
										<p>If not exact, provide explanation:   </p>
										<p>
											<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:date/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>

										</p>



									</p>



									<b>12.  Resolution Detail  </b>


									<p>
										<b>
											A. Sanctions: Were any Sanctions <em>Ordered? </em>
										</b>

										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'Y'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Yes

										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'N'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										 No, none were
										<em>ordered</em>
										.

									</p>



									<p>
										<b>B.    If &quot;Yes,&quot; check each individual sanction
											below that was <em>ordered</em>:   </b>

										<p>

											<div class="tableStyle" style="margin-left:0; margin-right:0;">

												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='BarPermanent'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Bar (Permanent)
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Disgorgement'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Disgorgement*
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Restitution'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Restitution*
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='BarTemporary'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Bar (Temporary / Time Limited)
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Expulsion'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Expulsion
													</div>
													<div class="tdStyle1 tdThreeCol">

														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Requalification'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Requalification
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Cease and Desist'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Cease and Desist
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Injunction'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Injunction
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Revocation'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Revocation
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Censure'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Censure
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Prohibition'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Prohibition
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Suspension'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Suspension
													</div>
												</div>
												<div style="clear:both"></div>
												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='CivilAdminPenaltyFine'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Civil and Administrative Penalty(ies)/Monetary Fine(s)*
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Reprimand'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Reprimand
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Undertaking'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Undertaking
													</div>
												</div>
												<div style="clear:both"></div>

												<div class="tableRow">
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Denial'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Denial
													</div>
													<div class="tdStyle1 tdThreeCol">
														<xsl:choose>
															<xsl:when
																test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Rescission'])&gt; 0">

																<img src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>

																<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Rescission
													</div>
													<div class="tdStyle1 tdThreeCol">&#160;
													</div>
												</div>
												<div style="clear:both"></div>
											</div>
										</p>
									</p>

									<p>
										<b>&#8226; Monetary Sanction(s):</b>
										Were one or more sanctions <em>ordered</em> that require a monetary payment?  

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)&gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:when
												test="not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)&gt; 0)
													and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details)&gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
										<p>
											 If &quot;Yes,&quot; enter the total amount <em>ordered</em>: $
											<xsl:choose>
			                              <xsl:when
			                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)">
			                                
			                                <xsl:call-template name="format_to_dollar">
				                        		<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
				                        	</xsl:call-template>
			                                </xsl:when>
			                             <xsl:otherwise>
			                                     <input     type="text"     name="court type"   readonly="1"></input>
			                              </xsl:otherwise>
			                        
			                         </xsl:choose>
										</p>
									</p>



									<p>
										 

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Other'])&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										<b>
											Other Sanctions <em>Ordered</em>
											(list each such additional sanction):
										</b>
									</p>

									<p>
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions[ns3:sanction='Other'])&gt; 0">
												<div class="fakeBox">
							                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctions/ns3:otherSanctions)" />
							                         <span>
							                             <xsl:text>&#160;</xsl:text>
							                       </span>
							                   </div>
											</xsl:when>
											<xsl:otherwise>
												<textarea name="otherSanctions" id="otherSanctions"
													cols="64" rows="6"></textarea>
											</xsl:otherwise>
										</xsl:choose>
									</p>

									<p>
										<br />
									</p>
									<p>
										<b>C.    Sanction Detail</b>
										(Provide the details of the following specific sanctions, if
										checked above in Item 12-B.)

										<p>
											 
											<b>(1)  Barred, <em>Enjoined</em>, or Suspended:</b>
											 
											If you checked one or more of these sanctions in Item 12-B.
											above, check the
											applicable box(es) below and provide the corresponding information.
										</p>

										<p>
											       
											<b>(a)  Barred</b>
											 
										</p>
										<p>
											If the applicant or an
											<em>associated person</em>
											received in the above action one or more bars from
											registration capacities, associations, and/or other
											activities, and the terms specify different time periods,
											report each in a separate entry.
										</p>

										<p>
											              (i) Duration (length of time):
											<br />
											<br />

											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Permanent (not limited by length of time)
											<br />
											<br />
											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Temporary / Time Limited. Specify the:

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Days
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
											</input>

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Months
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
											</input>
											<br />
											                                                          
											                               
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Years
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
											</input>

										</p>



										<p>
											              (ii) Start Date (MM/DD/YYYY):

											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:date)" />
</xsl:attribute>
											</input>

											 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:exact)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact        
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation 
											<br />
											<br />

											                 If not exact, provide explanation:
											<br />
											   <div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										</p>



										<p>
											              (iii) End Date (MM/DD/YYYY):

											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:date)" />
</xsl:attribute>
											</input>

											 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:exact)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact        
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation 
											<br />
											<br />

											                 If not exact, provide explanation:
											<br />
											  <div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										</p>


										<p>
											              (iv) Description: Provide remaining details and
											the registration capacities affected
											<br />
											                    (General Securities Principal, Financial
											Operations Principal, etc.). If none, enter &quot;None&quot;:
										</p>

										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:description)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>





										<p>
											       
											<b>(b)  <em>Enjoined</em></b>
										</p>
										<p>
											If the applicant or an
											<em>associated person</em>
											received in the above action one or more injunctions from
											registration capacities, associations, and/or other
											activities, and the terms specify different time periods,
											report each in a separate entry.
										</p>

										<p>
											              (i) Duration (length of time):
											<br />
											<br />

											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Permanent (not limited by length of time)
											<br />
											<br />
											                 
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Temporary / Time Limited. Specify the:

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Days
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
											</input>

											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Months
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
											</input>
											<br />
											                                                          
											                               
											<xsl:choose>
												<xsl:when
													test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

													<img src="Images/box-checked.jpg" alt="checkbox checked" />
												</xsl:when>
												<xsl:otherwise>

													<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Years
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
											</input>

										</p>
									</p>


									<p>
										              (ii) Start Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>



									<p>
										              (iii) End Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo/n2:provideExplanation)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>


									<p>
										              (iv) Description: Provide remaining details and
										the registration capacities affected
										<br />
										                    (General Securities Principal, Financial
										Operations Principal, etc.). If none, enter &quot;None&quot;:
									</p>

									<div class="fakeBox">
				                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:description)" />
				                         <span>
				                             <xsl:text>&#160;</xsl:text>
				                       </span>
				                   </div>

									<p>
										       
										<b>(c)  Suspended</b>
									</p>
									<p>
										If the applicant or an
										<em>associated person</em>
										received in the above one or more suspensions from
										registration capacities, associations, and/or other
										activities, and the terms specify different time periods,
										report each in a separate entry.
									</p>

									<p>
										              (i) Duration (length of time):
										<br />
										<br />

										                 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Permanent (not limited by length of time)
										<br />
										<br />
										                 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Temporary / Time Limited. Specify the:

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Days
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
										</input>

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Months
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
										</input>
										<br />
										                                                          
										                               
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Years
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
										</input>

									</p>



									<p>
										              (ii) Start Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
									   <div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
									</p>



									<p>
										              (iii) End Date (MM/DD/YYYY):

										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:date)" />
</xsl:attribute>
										</input>

										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:exact)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact        
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation 
										<br />
										<br />

										                 If not exact, provide explanation:
										<br />
										 <div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo/n2:provideExplanation)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
									</p>


									<p>
										              (iv) Description: Provide remaining details and
										the registration capacities affected
										<br />
										                    (General Securities Principal, Financial
										Operations Principal, etc.). If none, enter &quot;None&quot;:
									</p>

									 <div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:description)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>



									



									<p>
										<b>(2)   Requalification:</b>
										   Was requalification by examination, retraining, or other
										process a condition of a sanction?
										<br></br>
										                                        
										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'Y'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										YES
										 
										<xsl:choose>
											<xsl:when
												test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'N'">

												<img src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										NO
									</p>

<p>
If the applicant or an <em>associated person</em> received in the above action one or more requalifications 
in connection with 
registration capacities, associations, and/or other activities, and the terms specify different time 
periods, report each in a separate entry.  
</p>


									<p>If &quot;Yes,&quot; provide: </p>

									<p>
										  (a) Length of time given to requalify, retrain, or complete
										other process:
										<br />

										                  
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:noTimeSpecified)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										No time period is specified.
										<br />
										<br />
										                 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Time period is specified:

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Days
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
										</input>

										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Months
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
										</input>
										<br />
										                                                       
										          
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

												<img src="Images/box-checked.jpg" alt="checkbox checked" />
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Years
										<input type="text" name="text49" readonly="1">
											<xsl:attribute name="value">
<xsl:value-of
												select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
										</input>



									</p>



									<p>
										(b) Type of examination, retraining, or other process
										required:
										<br />
										<br />
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:typeRequired)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>



									<p>
										 (c)  Was the condition satisfied?     
										 
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied) &gt; 0">
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												YES
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												NO
											</xsl:when>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:notSatisfied) &gt; 0">

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												YES
												<img src="Images/radio-checked.jpg" alt="radio button checked" />
												NO
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												YES
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												NO
											</xsl:otherwise>
										</xsl:choose>
										<p>      
											     (1)   If &quot;Yes,&quot; provide the date (MM/DD/YYYY) 
											<input type="text" name="text49" readonly="1">
												<xsl:attribute name="value">
<xsl:value-of
													select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied)" />
</xsl:attribute>
											</input>
										</p>
										<p>            (2)   If &quot;No,&quot; explain the
											circumstances:   </p>

										<p>
											<div class="fakeBox">
						                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:notSatisfied)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
										</p>


									</p>







									
									


									<p>
										<b>(3)   Monetary Sanction(s): </b>
										If you indicated in Item 12-B above that one or more monetary
										sanctions were <em>ordered</em>, provide the following information.
									</p>



									<p>
										(a) Total Amount <em>Ordered</em>: 
										<xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)">
                                
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
		                         </xsl:call-template>
		                         </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
									</p>

									<p> (b) Portion levied against:  </p>
                                      <!-- 
                                      Always the Applicant is unchecked in the Associated Person Block
                                       -->
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										
									<b>Applicant</b>


									<p>
										  (i) Amount <em>Ordered</em>:                   $
										<input type="text" name="text49" readonly="1">
										</input>
										 
									</p>



									<p>
										  (ii) Was any portion waived?  
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
										            
										If &quot;Yes,&quot; how much?      $
										<input type="text" name="text49" readonly="1">
										</input>
										 
									</p>





									<p>
										  (iii) Final Amount:                         $
										<input type="text" name="text49" readonly="1">
										</input>
										  
									</p>

									<p>
										  (iv) Was final amount paid in full?    
										<xsl:choose>
											<xsl:when
												test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:satisfied/n2:satisfied) &gt; 0">
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												Yes
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												No
											</xsl:otherwise>
										</xsl:choose>
									</p>

									<p>  
										   If &quot;Yes,&quot; date paid in full (MM/DD/YYYY)
										<input type="text" name="text49" readonly="1">
										</input>
										  
									</p>

									<p>    
										If &quot;No,&quot; explain the circumstances:

										<p>
											    
											<textarea name="textarea17" cols="64" rows="6">
											</textarea>

										</p>

									</p>


                                    <xsl:choose>
                                        <xsl:when
                                            test="ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered &gt; 0">
                                            <img src="Images/box-checked.jpg" alt="checkbox checked" />
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <b><em>Associated Person</em></b>


                                    <p>
                                          (i) Amount <em>Ordered</em>: 
                                        <xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered)">
                                
                                 <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered" />
		                         </xsl:call-template>
		                         </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
                                         
                                    </p>



                                    <p>
                                          (ii) Was any portion waived?  
                                        <xsl:choose>
														<xsl:when
															test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0">
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
															Yes
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															No
														</xsl:when>
														<xsl:when
															test="not(count(ns3:drpInfo/ns3:filedDisclosure)&gt; 0)
															and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered) &gt; 0 
															and not(count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0)">
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															Yes
															<img src="Images/radio-checked.jpg" alt="radio button checked" />
															No
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															Yes
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
															No
														</xsl:otherwise>
													</xsl:choose>

                                        If &quot;Yes,&quot; how much?  
                                        <xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion)">
                                
                                 <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion" />
		                         </xsl:call-template>
                                </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
                                         
                                    </p>
                                    <p>
                                          (iii) Final Amount:  
                                       <xsl:choose>
                              <xsl:when
                                 test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount)">
                                
                                
                                <xsl:call-template name="format_to_dollar">
		                        	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount" />
		                         </xsl:call-template>
		                        </xsl:when>
                             <xsl:otherwise>
                                     <input     type="text"     name="court type"   readonly="1"></input>
                              </xsl:otherwise>
                        
                         </xsl:choose>
                                          
                                    </p>

                                    <p>
                                          (iv) Was final amount paid in full?    
                                        <xsl:choose>
                                            <xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied) &gt; 0">
                                                <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                Yes
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                No
                                            </xsl:when>
                                            <xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied) &gt; 0">
                                                  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                Yes
                                              
                                                <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                No
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                Yes
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                No
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </p>

                                    <p>  
                                           If &quot;Yes,&quot; date paid in full (MM/DD/YYYY)
                                        <input type="text" name="text49" readonly="1">
                                            <xsl:attribute name="value">
<xsl:value-of
                                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied)" />
</xsl:attribute>
                                        </input>
                                          
                                    </p>

                                    <p>    
                                        If &quot;No,&quot; explain the circumstances:

                                        <p>
                                          <div class="fakeBox">
						                        <xsl:value-of  select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied)" />
						                         <span>
						                             <xsl:text>&#160;</xsl:text>
						                       </span>
						                   </div>
                                        </p>

                                    </p>

									<p>
										<b>13.  Summary of Circumstances:</b>
									</p>

									<p>
										Use this space to provide a brief summary of the circumstances
										leading to the action, allegation(s), finding(s) and
										disposition(s),
										if any. Include any relevant information on the current action
										status, and on any terms, conditions, and dates not already
										provided
										above, and any other relevant information. The information must fit
										within the space provided.
									</p>

									<p>
										<div class="fakeBox">
					                        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:baseInformation/n2:summary)" />
					                         <span>
					                             <xsl:text>&#160;</xsl:text>
					                       </span>
					                   </div>
									</p>
								</xsl:otherwise>
								</xsl:choose>
								</xsl:for-each>


							</div>
						</div>
					</xsl:for-each>
				</div>
			</div>

		</div>
	</xsl:template>
</xsl:stylesheet>