<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">

<xsl:template name="INVESTIGATION_DRP">
	<link href="style.css" rel="stylesheet" type="text/css" />
	<link href="css/MAI_print.css" rel="stylesheet" type="text/css" />
<xsl:for-each select="n2:drpInfo/ns4:investigationDisclosure/ns4:investigationDrp">
<div id="maiDRPinv">
  <div class="contentwrapper">
    <h1>INVESTIGATION DISCLOSURE REPORTING PAGE (MA-I)</h1>
    <h1>INVESTIGATION DRP  PART 1</h1>
    <p>This <strong>Disclosure Reporting Page (DRP MA-I)</strong> is an 
    <span
						class="label">
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:reponseType/m1:add)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>INITIAL</b> or
						<xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:reponseType/m1:amend) &gt; 0">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<b>AMENDED</b>
					</span>
     response to report details <strong>for an affirmative response to <em>Question 6G(2)</em> on Form MA-I.</strong></p>
    <p>Check the question(s) to which this DRP pertains:</p>
    <strong>6G(2) <em>Investigation</em> that could result in a &quot;Yes&quot; answer to any part of </strong>
    (check all that apply):
    <div class="mainDiv2" style="margin-left:0; margin-right:0;">
	<div border="0" cellspacing="12" style="margin-left:0; margin-right:0;">
      <div style="margin-left:0; margin-right:0;">
        <div class="label1_0" style="margin-left:0; margin-right:0;"><xsl:choose>
							<xsl:when
								test="ns4:investigationQuestions='6A'">
								<img
									 src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
          <strong>6A (Criminal Action Disclosure - <em>Felony</em>)</strong></div>
      </div>
      <div style="margin-left:0; margin-right:0;">
        <div class="label1_0" style="margin-left:0; margin-right:0;"><strong>
          <xsl:choose>
							<xsl:when
								test="ns4:investigationQuestions='6B'">
								<img
									 src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
          6B (Criminal Action Disclosure - <em>Misdemeanor</em>)</strong></div>
      </div>
      <div style="margin-left:0; margin-right:0;">
        <div class="label1_0" style="margin-left:0; margin-right:0;"><strong>
          <xsl:choose>
							<xsl:when
								test="ns4:investigationQuestions='6C'">
								<img
									 src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
          6C (Regulatory Action Disclosure - <em>SEC</em> or <em>CFTC</em>)</strong></div>
      </div>
      <div style="margin-left:0; margin-right:0;">
        <div class="label1_0" style="margin-left:0; margin-right:0;"><strong>
         <xsl:choose>
							<xsl:when
								test="ns4:investigationQuestions='6D'">
								<img
									 src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
          6D (Regulatory Action Disclosure - Other Federal, State, Foreign)</strong></div>
      </div>
      <div style="margin-left:0; margin-right:0;">
        <div class="label1_0" style="margin-left:0; margin-right:0;"><strong>
          <xsl:choose>
							<xsl:when
								test="ns4:investigationQuestions='6E'">
								<img
									 src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
          6E (Regulatory Action Disclosure - <em>SRO</em>)</strong></div>
      </div>
    </div>
	</div>
	
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
    <div style="margin-left:0; margin-right:0;">
      <div class="tableRow noborder">
        <div class="tdStyle1 tditem10col1">Is this DRP an amendment that seeks to remove a previously filed DRP concerning the individual from the record?</div>
        <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'Y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						YES
						<xsl:choose>
							<xsl:when
								test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'N'">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
							<xsl:otherwise>
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						NO</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1">The reason the DRP should be removed is:</div>
        <div class="tdStyle1 tdCrmCol2"><p>
          <label>
            <xsl:choose>
							<xsl:when
								test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
          </label>
The event or <em>proceeding</em> was resolved in the individual's favor.<br />
<xsl:choose>
	<xsl:when
			test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError)&gt; 0">
				<img src="Images/radio-checked.jpg" alt="radio button checked" />
	</xsl:when>
	<xsl:otherwise>
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
	</xsl:otherwise>
</xsl:choose>
The DRP was filed in error.</p></div>
      </div>
            <div class="tableRow">
            <div class="tdStyle1 tdCrmCol1"><br />
              Explain the circumstances:<br>
              </br>
            </div>
            <div class="tdStyle1 tdCrmCol2">
                   <textarea name="textarea4" id="textarea4" cols="52" rows="5">
                
                <xsl:value-of
                        select="string(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError/m1:explainTheCircumstances)" />
                
                    </textarea>
            </div>

			</div>
			<div style="clear:both"></div>
    </div>
	</div>
	
    <p><strong><u>How to Report an Event or <em>Investigation</em> on an <em>Investigation</em> DRP:</u></strong> Complete this <em>Investigation</em> DRP only if you are answering &quot;yes&quot; to Item 6G(2), i.e., that the individual has been notified, in writing, that he or she is currently the subject of an <em>investigation</em>. (If you answered &quot;yes&quot; to Item 6G(1), i.e., that the individual has been notified in writing that he or she is currently the subject of a regulatory complaint or <em>proceeding,</em> complete the Regulatory Action DRP.) Use a separate <em>Investigation</em> DRP for each event or <em>investigation.</em> One event may result in more than one <em>investigation.</em> If an event gives rise to more than one authority <em>investigating</em> the individual, provide the details of each <em>investigation</em> on a separate DRP.</p>
    <p><strong><em><u>Investigation </u></em><u>Concluded Without Formal Action</u></strong>: If the individual has been notified that the <em>investigation</em> has been concluded without formal action, complete items 4 and 5 of this DRP to update. </p>
    <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="tableRow noborder">
        <div class="tditem10col1"><strong><u>DRP On File for This Event</u>:</strong> <u>Is an accurate and up-to-date DRP containing the information regarding the individual required by this DRP already on file (a) in the <em>IARD</em> or <em>CRD</em> system (with a Form ADV, BD, or U4), or (b) in the <em>SEC's</em> EDGAR system (with a Form MA or Form MA-I)?</u></div> 
       <div class="tditem10col2"><xsl:choose>
                                                <xsl:when
                                                      test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0">
                                                      <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                      YES
 
                                                      <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                      NO
                                                </xsl:when>
                                                <xsl:otherwise>
                                                      <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                                      YES
                                                      <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                                      NO
                                                </xsl:otherwise>
                                          </xsl:choose></div>
      </div>
	  <div style="clear:both"></div>
    </div>
	<div style="clear:both"></div>
 <p><u><em>Note: The filer may identify a DRP filed by the individual directly, or filed by another SEC-registrant about the individual as an associated person.</em></u></p>
 <!--    <p><strong><em>Note 2: If a Form MA-T is on file that includes disclosures for this event, but does not include all the information required by this DRP, the disclosures on Form MA-T are not considered accurate and up-to-date.</em></strong></p>
--> 
<xsl:if  test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)&gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling)&gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling)&gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling)&gt; 0">   
    <div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
             <div class="tableRow">
			 <div class="label2_0" style="margin-left:0; margin-right:0;">
             <xsl:choose>
                            <xsl:when
                                test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0">
                                            Provide the applicable information indicated below that identifies where the DRP may be found.
 
                               </xsl:when>
                                  <xsl:otherwise>
                                    
                                   </xsl:otherwise>
             </xsl:choose>
             </div>
			 <!--<div>&#160;</div>-->
             </div>
			 <div style="clear:both"></div>
			 <div class="tableRow">
              <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling) &gt; 0 ">
                                        
                                    <img
                                     src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                    <img
                                     src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   
                <label> 1. Form ADV, BD, or U4 Filing</label></div>
			</div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
                <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test=" count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling)&gt; 0 ">
                                        
                                    <img
                                     src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                     src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>   
                <label> 2. Form MA Filing</label></div>
            </div>
			<div style="clear:both"></div>
            <div class="tableRow">
             
              <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling)&gt; 0">

                                    <img
                                     src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                     src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   
                <label> 3. Form MA-I  Filing</label></div>
            </div>
			<div style="clear:both"></div>
        <!--    <tr>
            
              <td class="checkbox"><xsl:choose>
                        <xsl:when
                                test=" count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling)&gt; 0 ">
                                        <img
                                     src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                            <img
                                     src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>   
              <label> 4. Form MA-T Filing</label></td>   
            </tr>--> 
            <div>
            <div></div></div>
      <div style="margin-left:0; margin-right:0;">
        <div class="label2_0" style="margin-left:0; margin-right:0;"><strong>1. Form ADV, BD, or U4 Filing: For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information:</strong></div>
        <div></div>
      </div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Name on Registration:</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName)" />
				 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><em>CRD</em>  No.:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
			<xsl:call-template name="CRDFormatting">
				<xsl:with-param name="CRD" select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber)" />
			</xsl:call-template>
		</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Disclosure Occurrence No.:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber)" />
				 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="label2_0"><strong>2. Form MA Filing: </strong> For a DRP filed on EDGAR with a Form MA, provide the following information: </div>
        <div></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Name on Registration:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName)" />
		</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>MA Registration Number:</p></div>
       <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber)" />
		 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Date of filing that contains the DRP (MM/DD/YYYY):</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate)" />
		 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Accession number of the filing: </p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber)" />
		 </div>
      </div>
	  <div style="clear:both"></div>
      <div>
        <div class="label2_0" style="margin-left:0; margin-right:0;"><strong>3. Form MA-I Filing:</strong> For a DRP filed on EDGAR with a Form MA-I, provide the following information:</div>
        <div></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Name of Individual: </p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName)" />
		 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>MA-I File Number:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber)" />
		</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Date of filing that contains the DRP (MM/DD/YYYY):</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded" >
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate)" />
		 </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p>Accession number of the filing:</p></div>
        <div class="tdStyle1 tdCrmCol2Textboxpadded">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber)" />
		 </div>
      </div>
	  <div style="clear:both"></div>
     <!--  <tr>
        <td class="label"><strong>4. Form MA-T Filing:</strong> For a disclosure filed on the <em>SEC</em> website with a Form MA-T, provide the following information identifying the disclosure on the <em>SEC</em> website at: <a href="https://tts.sec.gov/MATR/index.html">https: / / tts.sec.gov / MATR / index.html</a>:</td>
        <td></td>
      </tr>
      <tr>
        <td class="label"><p>Name on Registration: </p></td>
        <td class="value">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:matFiling/ns4:filingName)" />
		 </td>
      </tr>
      <tr>
        <td class="label"><p>MA-T Registration Number: </p></td>
       <td class="value">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:matFiling/ns4:registrationNumber)" />
		 </td>
      </tr>
      <tr>
        <td class="label"><p>Date of filing that contains the disclosure (MM/DD/YYYY):</p></td>
        <td class="value">
				<xsl:value-of
					select="string(ns4:baseHeader/ns4:filingInfo/ns4:matFiling/ns4:filingDate)" />
		  </td>
      </tr>--> 
    </div>
  </xsl:if>
    <p class="guidance"><strong>NOTE: The completion of all or any part of this form does not relieve the individual or any <em>municipal advisor</em> with which the individual is associated of the obligation to update any relevant Form MA or <em>IARD</em> or <em>CRD</em> records.</strong></p>
    <xsl:choose>
       <xsl:when
        test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0">
         </xsl:when>
         <xsl:otherwise>
    <h1>INVESTIGATION DRP  PART 2</h1>
    <p><strong>1. <em>Investigation</em> was initiated by:</strong> </p>
    
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="tableRow noborder">
        <div class="tdStyle1 tdTwoCol1 "><strong>A. Notice Received From:</strong>
          <p>Select only one box below. A separate <em>Investigation</em> DRP is required for each notice received from a regulator or other authority.</p></div>
        <div class="tdStyle1 tdTwoCol2"><p><strong>Criminal <em>Investigation</em></strong> </p>
          <div class="mainDiv2"  style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1 td4cols">
				<xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:crimeInvestigationInfo[m1:court='Federal Court']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Federal </div>
              <div class="tdStyle1 td4cols">
                <xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:crimeInvestigationInfo[m1:court='Military Court']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Military</div>
              <div class="tdStyle1 td4cols">
                <xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:crimeInvestigationInfo[m1:court='State Court']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                State  </div>
              <div class="tdStyle1 td4cols">
                <xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:crimeInvestigationInfo[m1:court='Foreign Country Court']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Foreign Country </div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td4cols" >
                <xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:crimeInvestigationInfo[m1:court='International Authority']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
			</xsl:choose>
                International Authority</div>
             <div class="tdStyle1 td4cols">
                <xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:crimeInvestigationInfo[m1:court='Other']) &gt; 0">
					<img	src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
			</xsl:choose>
                Other: (specify)
                <div  style="margin-left:0; margin-right:0;">
                                    <xsl:value-of
                                          select="ns4:drpData/ns4:crimeInvestigationInfo/m1:other" />
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                </div> 
               
                </div>
            </div>
			<div style="clear:both"></div>
			
          </div>
          <p><strong>Regulatory or Other Civil Authority <em>Investigation</em></strong> </p>
          <div class="mainDiv2"  style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1 td3cols50" ><em>
            <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:sec='SEC'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
			</xsl:choose>
                SEC</em>   </div>
              <div class="tdStyle1 td3cols50">
               <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:state='State'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
			</xsl:choose>
                State</div>
              <div class="tdStyle1 td3cols50">
                <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:foreignFRA='Foreign Financial Regulatory Authority'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
			</xsl:choose>
                <em>Foreign Financial Regulatory Authority</em></div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			   <div class="tdStyle1 td3cols50"><em>
                <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:cftc='CFTC'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
                CFTC</em>  </div>
              <div class="tdStyle1 td3cols50"><em>
                <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:sro='SRO'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
                SRO</em>   </div>
			 <div class="tdStyle1 td3cols50">
                <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:otherForeignAuthority='Other Foreign Authority'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
                Other Foreign Authority</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 td3cols50">
                <xsl:choose>
					<xsl:when
					test="ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:otherFederalAuthority='Other Federal Authority'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
                Other Federal Authority </div>
				<div class="tdStyle1 td3cols50">
                <xsl:choose>
					<xsl:when
					   test="count(ns4:drpData/ns4:regulatoryInfo/ns4:initiator/ns4:other) &gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
			</xsl:choose>
                Other: (specify)
                <p><div  style="margin-left:0; margin-right:0;">
					<xsl:value-of 
					select="ns4:drpData/ns4:regulatoryInfo/ns4:other" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div> 
				</p>
                </div>

            </div>
			<div style="clear:both"></div>
			            
          </div></div>
      </div>
	  <div style="clear:both"></div>
      <div>
        <div class="tdinvcol1"><p><strong>B. Full name of the criminal, regulatory or other civil authority that initiated the <em>investigation</em> (unless <em>SEC</em> or <em>CFTC</em> is checked above).</strong></p>
          
          <p class="minutia">For a foreign <em>investigation</em>, please provide the full name in English: </p></div>
        <div class="tdCrmCol2Textbox">
				<xsl:value-of select="string(ns4:drpData/ns4:authorityName)" />
		</div>
      </div>
	  <div style="clear:both"></div>
	  <div class="tableRow ">
        <div class="tdStyle1 tdCrmCol1"><strong>2. Notice Date (MM/DD/YYYY):</strong></div>
        <div class="tdStyle1 tdCrmCol2"><input name="input30" type="text" value="mm/dd/yyyy" class="dateField" readonly="readonly">
        <xsl:attribute name="value">
				<xsl:value-of select="string(ns4:drpData/ns4:noticeDate/m1:date)" />
			</xsl:attribute>
        </input>
        <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:noticeDate/m1:exact)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<label>Exact</label>
						<xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:noticeDate/m1:explanationInfo/m1:explanation) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<label>Explanation</label></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow noborder">
        <div class="tdStyle1 tdCrmCol1"><p>If not exact, provide explanation:</p></div>
       <div class="tdStyle1 tdCrmCol2Textbox">
			<xsl:value-of select="string(ns4:drpData/ns4:noticeDate/m1:explanationInfo/m1:provideExplanation)" />
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><strong>3. Description:</strong></div>
        <div></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><strong>A. Does the individual know the nature of the <em>investigation</em>? </strong></p></div>
        <div class="tdStyle1 tdCrmCol2">
        <xsl:choose>
            <xsl:when
                test="count(ns4:drpData/ns4:investigationNature) &gt; 0">
                <img src="Images/radio-checked.jpg" alt="radio button checked" />YES
                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
            </xsl:when>
            <xsl:when
            		test="not(count(ns4:drpData/ns4:investigationNature) &gt; 0)
            		and (not(count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 
            		or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 
            		or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling) &gt; 0 
            		or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0))">
                 <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
                 <img src="Images/radio-checked.jpg" alt="radio button checked" />NO
             </xsl:when>
             <xsl:otherwise>
                 <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
                 <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
             </xsl:otherwise>
        </xsl:choose>
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow noborder">
        <div class="tdStyle1 tdCrmCol1"><strong> </strong>
          <p><strong>B. If the answer is &quot;Yes,&quot;</strong> describe briefly the nature of the <em>investigation:  </em></p></div>
        <div class="tdStyle1 tdCrmCol2Textbox">
			<xsl:value-of select="string(ns4:drpData/ns4:investigationNature)" />
         </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><strong>4. Product Type(s):</strong> (Select all that apply.)</div>
        <!--<div class="tdStyle1 tdCrmCol2" style="border:1px solid black;">-->
		<div class="tdStyle1 tdCrmCol2" style="border:1px solid white;">
			<div class="tableRow">
              <div class="tdStyle1">
				<xsl:choose>  
					<xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='No Product']) &gt; 0">
					<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				No Product</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			  <div class="tdStyle1 td3cols50">
                <xsl:choose>  
					<xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='AnnuityCharitable']) &gt; 0">
					<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>
				</xsl:choose>
                Annuity-Charitable</div>
              <div class="tdStyle1 td3cols50">
               <xsl:choose>  
				<xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='Direct Investment(s) - DPP &amp; LP Interest(s)']) &gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Direct Investment-DPP &amp; LP Interest </div>
              <div class="tdStyle1 td3cols50">
                <xsl:choose>  
				  <xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='OilAndGas']) &gt; 0">
					<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				 </xsl:when>
				 <xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				 </xsl:otherwise>
				</xsl:choose>
                Oil &amp; Gas</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			  <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Annuity(ies) - Fixed']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Annuity-Fixed   </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='EquipmentLeasing']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Equipment Leasing </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Options']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Options</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Annuity(ies) - Variable']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Annuity-Variable </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Equity Listed (Common &amp; Preferred Stock)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Equity Listed (Common &amp; Preferred Stock)  </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Penny Sock(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Penny Stock</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			  <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='BankingProduct']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Banking Product <br />
                (other than CD)</div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Equity - OTC']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Equity-OTC</div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='PrimeBankInstrument']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Prime Bank Instrument</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Futures - Commodity']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Futures-Commodity</div>
            <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Promissory Note']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Promissory Note</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='CD(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                CD</div>
            <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Futures - Financial']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Futures-Financial  </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Real Estate Security']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Real Estate Security</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 td3cols50">
					<xsl:choose>  
					<xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='Commodity Option(s)']) &gt; 0">
					<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>
					</xsl:choose>
                Commodity Option </div>
              <div class="tdStyle1 td3cols50">
					<xsl:choose>  
					<xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='Index Option(s)']) &gt; 0">
					<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>
					</xsl:choose>
                Index Option </div>
              <div class="tdStyle1 td3cols50">
					<xsl:choose>  
					<xsl:when
					test=" count(ns4:drpData/ns4:productType[ns4:product='Security Futures']) &gt; 0">
					<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
					<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>
					</xsl:choose>
                Security Futures</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Debt - Asset Backed']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Debt-Asset Backed</div>
            <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Insurance']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Insurance </div>
            <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Security-based Swap']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Security-based Swap</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Debt - Corporate']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Debt-Corporate  </div>
            <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Investment Contract(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Investment Contract </div>
            <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Swap']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Swap</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Debt - Government']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Debt-Government     </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Money Market Fund(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Money Market Fund </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Unit Investment Trust(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Unit Investment Trust</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
			<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Debt - Municipal']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Debt-Municipal  </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Mutual Fund(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Mutual Fund   </div>
              <div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Viatical Settlement']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
                Viatical Settlement</div>
			</div><div style="clear:both"></div>
			<div class="tableRow">
     		<div class="tdStyle1 td3cols50">
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Derivative(s)']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Derivative</div>
            <div class="tdStyle1 td3cols50"><strong>
				<xsl:choose>  
				<xsl:when
				test=" count(ns4:drpData/ns4:productType[ns4:product='Other']) &gt; 0">
				<img	 src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
				<img	 src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
				</xsl:choose>
				Other Product Type:</strong> (specify)
                <div class="fakeBox" style="margin-left:0; margin-right:0;">
                    <xsl:value-of 
                    select="string(ns4:drpData/ns4:productType/ns4:productOther)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div> 
                </div>

              
            </div><div style="clear:both"></div>
		  </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow noborder">
        <div class="tdStyle1 tdCrmCol1"><strong>5. Current Status:</strong>
          <p class="minutia">Is the <em>investigation</em> pending? </p></div>
        <div class="tdStyle1 tdCrmCol2">
	        <xsl:choose>
	        		<xsl:when
	                test="count(ns4:drpData/ns4:caseClosedDate/m1:date) &gt; 0">
	                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
	                 <img src="Images/radio-checked.jpg" alt="radio button checked" />NO
	            </xsl:when>
	            <xsl:when
	                test="not(count(ns4:drpData/ns4:caseClosedDate/m1:date) &gt; 0)
	                	and (not(count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 
            		or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 
            		or count(ns4:baseHeader/ns4:filingInfo/ns4:matFiling) &gt; 0 
            		or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0))">
	                <img src="Images/radio-checked.jpg" alt="radio button checked" />YES
	                 <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
	            </xsl:when>
	            <xsl:otherwise>
	                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
	                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
	             </xsl:otherwise>
	        </xsl:choose>
        </div>
      </div>
	  <div style="clear:both"></div>
    </div>
     <div class="guidance">
      <p><strong>If "Yes," skip to Item 7.</strong></p>
      <p><strong>If "No," complete Item 6.</strong></p>
    </div>
    <div  class="mainDiv2" style="margin-left:0; margin-right:0;">
      <div class="tableRow">
        <div class="tdStyle1"><strong>6. Resolution Details:</strong></div>
        <div></div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><strong>A. Date Closed/Resolved (MM/DD/YYYY):</strong></p></div>
        <div class="tdStyle1 tdCrmCol2"><input name="input" type="text" value="mm/dd/yyyy" class="dateField" readonly="readonly">
        <xsl:attribute name="value">
				<xsl:value-of select="string(ns4:drpData/ns4:caseClosedDate/m1:date)" />
    	</xsl:attribute>
        </input>
           <!-- <label>Exact</label>  -->
                        <xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:caseClosedDate/m1:exact)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> <label>Exact</label>
                       <!--  <label>Explanation</label> -->
						<xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:caseClosedDate/m1:explanationInfo/m1:explanation) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose><label>Explanation</label>
</div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow noborder">
        <div class="tdStyle1 tdCrmCol1"><p>Provide explanation:</p></div>
        <div class="tdStyle1 tdCrmCol2Textbox"> 
			<xsl:value-of select="string(ns4:drpData/ns4:caseClosedDate/m1:explanationInfo/m1:provideExplanation)" />
        </div>
      </div>
	  <div style="clear:both"></div>
      <div class="tableRow">
        <div class="tdStyle1 tdCrmCol1"><p><strong>B. How was <em>investigation</em> resolved?</strong> (select appropriate item):</p></div>
        <div class="tdStyle1 tdCrmCol2"><xsl:choose>  
              <xsl:when
				test=" count(ns4:drpData/ns4:investigationResolvedInfo[ns4:resolvedTypes='Closed Without Further Action']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
			 </xsl:when>
			 <xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			 </xsl:otherwise>
			</xsl:choose>
          Closed Without Further Action <br />
          <xsl:choose>  
              <xsl:when
				test=" count(ns4:drpData/ns4:investigationResolvedInfo[ns4:resolvedTypes='Closed - Regulatory Action Initiated']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
			 </xsl:when>
			 <xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			 </xsl:otherwise>
			</xsl:choose>
          Closed - Regulatory Action Initiated <br />
          <xsl:choose>  
              <xsl:when
				test=" count(ns4:drpData/ns4:investigationResolvedInfo[ns4:resolvedTypes='Other (Explain)']) &gt; 0">
				<img	src="Images/radio-checked.jpg" alt="radio button checked" />
			 </xsl:when>
			 <xsl:otherwise>
				<img	src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			 </xsl:otherwise>
			</xsl:choose>
          Other (Explain):<p>  (specify)</p>
          <!-- 
          <p class="value">
			<xsl:value-of select="string(ns4:drpData/ns4:investigationResolvedInfo/ns4:reason)" />
          </p>
          -->
          <div class="fakeBox" style="margin-left:0; margin-right:0;">
                    <xsl:value-of 
                    select="string(ns4:drpData/ns4:investigationResolvedInfo/ns4:reason)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div> 
          </div>
      </div>
	  <div style="clear:both"></div>
      <div style="margin-left:0; margin-right:0;">
        <div class="label2_0" style="margin-left:0; margin-right:0;"><p><strong><u>If you checked &quot;Closed - Regulatory Action Initiated&quot; in Item 6-B, you must promptly complete and file an accurate and up-to-date Regulatory Action DRP (MA-I).</u></strong></p></div>
        <div><strong> </strong></div>
      </div>
      <div class="tableRow noborder">
        <div class="tdStyle1 tdCrmCol1"><strong>7. Summary of Circumstances (Optional):</strong>
          <p>You may use this space to provide a brief summary of the circumstances leading to the <em>investigation</em>, as well as the current status or final disposition and/or finding(s), if any. Include any other relevant information. The information must fit within the space provided.</p></div>
        <div class="tdStyle1 tdCrmCol2Textbox">
			<xsl:value-of select="string(ns4:baseHeader/ns4:summary)" />
        </div>
      </div>
	  <div style="clear:both"></div>
    </div>
    </xsl:otherwise>
    </xsl:choose>
  </div>
  
</div>
	
</xsl:for-each>

</xsl:template>

</xsl:stylesheet>