<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 10 templates -->
	
<xsl:template name="scheduleB" >
   <div class="guidance">
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
          	<div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2">Guidance:  To determine indirect ownsership, see instructions 2 and 3 below.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">1.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>Complete Schedule B only if applicant is submitting an initial application.</b> Schedule B asks for information about the applicant's indirect owners. The applicant must first complete Schedule A, which asks for information about direct owners. For purposes of Schedule B, an &quot;indirect owner&quot; includes any owner of 25% or more of any direct owner listed in Schedule A, and any owner of 25% or more of each such indirect owner going up the chain of ownership. Use Schedule C to amend the information in this schedule.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2">Separate subparts of Schedule B must be completed for: (1) indirect owners that are business entities, and (2) indirect owners who are natural persons, as follows:</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2"><blockquote>
                <p><b>&#8226; Complete Schedule B-1: &quot;Indirect Owners of Applicant - Business Entities,&quot;</b> for owners who are organized as business or other legal entities, such as a corporation, partnership, trust, or limited liability company.</p>
                <p><b>&#8226; Complete Schedule B-2: &quot;Indirect Owners of Applicant - Natural Persons,&quot;</b> for individuals and sole proprietors.</p>
              </blockquote></div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">2.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>With respect to each direct owner listed on Schedule A 1 (business entities), list in either Schedule B-1 or Schedule B-2 below, as applicable:</b></div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2">(a)<b> in the case of a direct owner listed on Schedule A-1 that is a corporation,</b> each of its shareholders that beneficially owns, has the right to vote, or has the power to sell or direct the sale of, 25% or more of a class of a voting security of that corporation;
              <p>For purposes of this Schedule, a <em>person</em> beneficially owns any securities: (i) owned by his/her child, stepchild, grandchild, parent, stepparent, grandparent, spouse, sibling, mother-in-law, father-in-law, son-in-law, daughter-in-law, brother-in-law, or sister-in-law, sharing the same residence; or (ii) that he/she has the right to acquire, within 60 days, through the exercise of any option, warrant, or right to purchase the security. </p></div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2">(b)<b> in the case of a direct owner listed on Schedule A-1 that is a partnership, </b>all general partners and each  limited and special partner that has the right to receive upon dissolution, or has contributed, 25% or more of the partnership's capital;</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2" >(c)<b> in the case of a direct owner listed on Schedule A-1 that is a trust</b>, the trust and each trustee; and </div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2">(d)<b> in the case of a direct owner listed on Schedule A-1 that is a limited liability company (&quot;LLC&quot;),</b> (i) each  member that has the right to receive upon dissolution, or has contributed, 25% or more of the LLC's capital, and (ii) if managed by elected managers, each  elected manager.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">3.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>Continue up the chain of indirect ownership listing all 25% shareholders at each level.</b> Once a public reporting company (a company subject to Sections 12 or 15(d) of the <em>Exchange Act</em>) is reached, no further ownership information need be given.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">4.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>In the DE/FE column in Schedule B-1</b> below, enter &quot;DE&quot; if the indirect owner is a domestic entity, or &quot;FE&quot; if the owner is an entity organized, incorporated or domiciled in a foreign country. Complete the next column by indicating the entity in the chain of ownership in which this indirect owner has an interest.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">5.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>Complete the Status column</b> by entering the indirect owner's status as partner, trustee, elected manager, shareholder, or member. For shareholders or members, indicate the class of securities owned (if more than one is issued).</div>
            </div>
            <div style="clear:both;"></div>
			
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">6.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>Ownership Codes are:</b><br></br>
               
			       <div style="margin-left:0; margin-right:0;padding-left:3pt;padding-right:3pt;padding:8px;vertical-align:top;text-align:left;font-weight:normal;">
				        <div class="tableStyle" style="margin-left:0; margin-right:0;padding-top:5px;">
	                 <div class="tableRow">
                    C - 25% but less than 50%
                    <br/>D - 50% but less than 75%
                    <br/>E - 75% or more
                    <br/>F - Other (general partner, trustee, or elected manager)
                  </div>
                </div>
				<div style="clear:both;"></div>
              </div>
            </div>
			</div>
			
            <div style="clear:both;"></div>		  
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">7.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>(a) In the <em>Control Person</em> column,</b> enter &quot;Yes&quot; in the first sub-column if the <em>person</em> has <em>control</em> as defined in the Glossary of Terms to Form MA, and enter &quot;No&quot; if the <em>person</em> does not have <em>control</em>. Note that under this definition, most executive officers and all 25% owners, general partners, elected managers, and trustees are <em>control persons</em>.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2"><b>(b) In the PR sub-column, for Schedule B-1 only,</b> enter &quot;PR&quot; if the indirect owner is a public reporting company under Sections 12 or 15(d) of the <em>Exchange Act</em>.</div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1">8.</div>
              <div class="tdStyle1 tdscheduleacol2"><b>(a) For Schedule B-1, </b>enter the organization <em>CRD</em> number. If not registered with the <em>CRD</em>, then enter the IRS Tax Number, Employer Identification Number (&quot;EIN&quot;), or Foreign Business Number.
			  </div>
            </div>
            <div style="clear:both;"></div>
            <div class="tableRow">
              <div class="tdStyle1 tdscheduleacol1"></div>
              <div class="tdStyle1 tdscheduleacol2"><b>(b) For Schedule B-2,</b> enter the individual <em>CRD</em> number. If not registered with the <em>CRD</em>, then enter 0000000.</div>
            </div>
            <div style="clear:both;"></div>
          </div>
        </div>
         <br></br>
        <div class="scheduleBox hide" id="schedB1entry">
          <h2>Schedule B-1: Indirect Owners of Applicant – Business Entities</h2>
          <xsl:for-each select="m1:formData/m1:scheduleB/m1:businesses/m1:business">
          <div class="newRecord hide" id="newschedB1">
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1">BUSINESS ENTITY FULL LEGAL NAME:<br/>
               	<div class="fakeBox">
                             <xsl:value-of
                                select="m1:baseInfo/m1:name" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>
                  </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">DE/FE:                   
                  	<span
						class="label">
						<xsl:choose>
							<xsl:when 	
							test="count(m1:baseInfo/m1:deFeNp/m1:de) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
                        DE
						<xsl:choose>
							<xsl:when
								test="count(m1:baseInfo/m1:deFeNp/m1:fe) &gt; 0">
								<img
									   src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						 FE
					</span>
                  </div>
              </div>
            </div>
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1">Entity in Which Interest is Owned: <br/>
                   <div class="fakeBox">
                             <xsl:value-of
                                select="m1:owningEntity" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div> 
                   </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1">Status: <br/>
               	<div class="fakeBox">
                             <xsl:value-of
                                select="m1:baseInfo/m1:baseInformation/m1:titleStatus" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>
                 </div>
              </div>
              </div>
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
               <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Date Title or Status Acquired: 
               		 <input type="text" name="title date2" class="dateField" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInfo/m1:baseInformation/m1:statusAcquired"/>
						</xsl:attribute>
					</input>
                 </div>
              </div>
            </div>  
            <div style="clear:both;"></div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Ownership Code:</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                  <xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
					</xsl:choose>
        	          C-25% but less than 50%
        	   </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                 	<xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  D-50% but less than 75%
                </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                	 <xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  E-75% or more
               	</div>
              </div>
          <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                	<xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='F']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  	F-Other (general partner, trustee, or elected manager)
                </div>
                </div>
                <div style="clear:both;"></div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
               <div class="tdYesNoStyle" style="margin-left:0; margin-right:0; width:100%;"><em>Control Person</em>:
                    <xsl:choose>                
                			<xsl:when
								test="m1:baseInfo/m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
							</xsl:when>
							<xsl:when
								test="m1:baseInfo/m1:baseInformation/m1:isControPerson = 'N' or m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
							</xsl:otherwise>
					</xsl:choose>
               	</div>
              </div>
            </div>   
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0; width:100%;">PR:
				  	<xsl:choose>                
                		<xsl:when
							test="m1:baseInfo/m1:controPersonPR = 'Y' or m1:baseInfo/m1:controPersonPR  = 'y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
						</xsl:when>
						 <xsl:when
							test="m1:baseInfo/m1:controPersonPR = 'N' or m1:baseInfo/m1:controPersonPR  = 'n'">
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
						</xsl:otherwise>
					</xsl:choose>
             	</div>
              </div>
            </div> 
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 lavel" style="margin-left:0; margin-right:0;height:21; width:100%;">Organization <em>CRD</em> Number (If None: IRS Tax No., EIN, or Foreign Business No.)</div>
              </div>
             <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1"><em>CRD</em> No.:<br/>                  
                       <input type="text" name="CRD3" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInfo/m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                  </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">IRS Tax No.:<br/>
                     <input type="text" name="irs tax no2" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInfo/m1:irsNum"/>
						</xsl:attribute>
					</input>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">EIN:<br/>
              		<div class="fakeBox fakeBox5">
                             <xsl:value-of
                                select="m1:baseInfo/m1:empIDNumber" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">Foreign Bus. No.:<br/>
                   <div class="fakeBox fakeBox5">
                             <xsl:value-of
                                select="m1:baseInfo/m1:baseInformation/m1:foreignBusIdNo" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>
                </div>
              </div>
			   <div style="clear:both;"></div>
            </div>
          </div>
          </xsl:for-each>
        </div>
        <div class="scheduleBox hide" id="schedB2entry">
          <h2>Schedule B-2: Indirect Owners of Applicant – Natural Persons</h2>
        <xsl:for-each select="m1:formData/m1:scheduleB/m1:persons/m1:person">
          <div class="newRecord hide" id="newschedB2">
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">NATURAL PERSON FULL LEGAL NAME </div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Enter all the letters of each name and not initials or other abbreviations.  If no middle name, enter NMN on that line.</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:33%;float:left;">Last Name: <br/>
                	<input type="text" name="textfield3" readonly="1" size="75">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInfo/m1:name/ns2:lastName"/>
						</xsl:attribute>
					</input>
                  </div>
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:33%;float:left;">First Name: <br/>
                   <input type="text" name="textfield6" readonly="1" size="75">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInfo/m1:name/ns2:firstName"/>
						</xsl:attribute>
					</input>
<br />
                </div>
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:25%;float:left;">Middle Name: <br/>
                	<input type="text" name="textfield7" readonly="1" size="30">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInfo/m1:name/ns2:middleName"/>
						</xsl:attribute>
					</input>
                </div>
              </div>
			  <div style="clear:both;"></div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Entity in Which Interest is Owned: <br/>
                	<div class="fakeBox">
                             <xsl:value-of
                                select="m1:owningEntity" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                    </div> 
                 </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Status: <br/>
                	<div class="fakeBox">
                             <xsl:value-of
                                select="m1:baseInfo/m1:baseInformation/m1:titleStatus" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                    </div> 
                </div>
               </div>
              </div> 
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
            	<div class="tableRow">
                	<div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Date Title or Status Acquired: 
                		<input type="text" name="title date" class="dateField"	readonly="1">
							<xsl:attribute name="value">
								 <xsl:value-of select="m1:baseInfo/m1:baseInformation/m1:statusAcquired"/>
							</xsl:attribute>
						</input>
                 	</div>
              </div>
              </div>
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Ownership Code:</div>
              </div>
                <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:30%;float:left;padding-top:5px;padding-bottom:5px; padding-right:5px;">
                  <xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
						</xsl:otherwise>
					</xsl:choose>
                	  C-25% but less than 50%
                </div>
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:30%;float:left;padding-top:5px;padding-bottom:5px; padding-right:5px;">
                	 <xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
						</xsl:otherwise>
			    	 </xsl:choose>
                  	D-50% but less than 75%
                </div>
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:30%;float:left;padding-top:5px;padding-bottom:5px; padding-right:28px;"> 
                	<xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
						</xsl:otherwise>
					</xsl:choose>
                  	E-75% or more
                 </div>
                 <div style="clear:both;"></div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 padded" style="margin-left:0; margin-right:0; width:30%;float:left;padding-top:5px;padding-bottom:5px; padding-right:6px;"> 
                	<xsl:choose>
						<xsl:when
							test="count(m1:baseInfo/m1:baseInformation[m1:ownershipCode='F']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
						</xsl:otherwise>
						
					</xsl:choose>
                  	F-Other (general partner, trustee, or elected manager)
                </div>
                 <div style="clear:both;"></div>
              </div>
            </div>
              
             <div class="tableStyle" style="margin-left:0; margin-right:0;">
	              <div class="tableRow">
	                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0; width:100%;"><em>Control Person</em>:
	                	<xsl:choose>                
	                			<xsl:when
									test="m1:baseInfo/m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'y'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
								</xsl:when>
		  					    <xsl:when
									test="m1:baseInfo/m1:baseInformation/m1:isControPerson = 'N' or m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'n'">
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img	src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
								</xsl:otherwise>
						</xsl:choose>
	              		</div>
	              	</div>
            	</div>  
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 lavel" style="margin-left:0; margin-right:0; width:100%;">Individual <em>CRD</em> No. (If None: enter 0000000)</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1"><em>CRD</em> No.: <br/>                 
                       <input type="text" name="CRD8" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInfo/m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                </div>
                <!-- <div class="tdStyle1 tdscheduleagridcrdcol1">SSN:<br/> -->
                     <!-- <input type="text" name="irs tax no2"	readonly="1"> -->
						<!-- <xsl:attribute 	name="value"> -->
							 <!-- <xsl:value-of select="m1:baseInfo/m1:ssNum"/> -->
						<!-- </xsl:attribute> -->
					<!-- </input> -->
                <!-- </div> -->
                <!-- <div class="tdStyle1 tdscheduleagridcrdcol1">DOB: <br/>                    -->
                     <!-- <input type="text" name="employer id no2" readonly="1"> -->
						<!-- <xsl:attribute name="value"> -->
							 <!-- <xsl:value-of select="m1:baseInfo/m1:dob"/> -->
						<!-- </xsl:attribute> -->
					<!-- </input> -->
                <!-- </div> -->
                <!-- <div class="tdStyle1 tdscheduleagridcrdcol1" style="width:160px;">Foreign Business No.: <br/> -->
                   <!-- <div class="fakeBox fakeBox5"> -->
                             <!-- <xsl:value-of -->
                                <!-- select="m1:baseInfo/m1:baseInformation/m1:foreignBusIdNo" /> -->
                         <!-- <span> -->
                        <!-- <xsl:text>&#160;</xsl:text> -->
                       <!-- </span> -->
                       <!-- </div>  -->
                 <!-- </div> -->
              </div>
              <div style="clear:both;"></div>
            </div>			
          </div>
		   
         </xsl:for-each>
        </div>
</xsl:template>

</xsl:stylesheet>
