<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 10 templates -->
	
	<xsl:template name="scheduleA" ><link href="style.css" rel="stylesheet" type="text/css" />
  		<div class="guidance">
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">1.</div>
                <div class="tdStyle1 tdscheduleacol2" ><b>Complete Schedule A only if submitting an initial application.</b> Schedule A asks for information about the applicant's direct owners and executive officers. Use Schedule C to amend this information.</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2">Guidance: To determine direct ownership and executive officer status, see instruction 2 below.</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2">Separate subparts of Schedule A must be completed for: (1) direct owners that are business entities, and (2) direct owners and executive officers who are natural persons, as follows:</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2">
                <blockquote>
                  <p><b>&#8226; Complete Schedule A-1: &quot;Direct Owners of Applicant - Business Entities,&quot;</b> for owners that are organized as a business or other legal entity, such as a corporation, partnership, trust, or limited liability company.</p>
                  <p><b>&#8226; Complete Schedule A-2: &quot;Direct Owners and Executive Officers of Applicant - Natural Persons,&quot;</b> for owners who are individuals, including sole proprietors, and for executive officers. </p>
                </blockquote>
                </div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">2.</div>
                <div class="tdStyle1 tdscheduleacol2"><b>List in either Schedule A-1 or Schedule A-2 below, or both, as applicable, the full names of:</b></div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(a) If applicant is organized as a corporation,</b> each shareholder that is a direct owner of 5% or more of a class of the applicant's voting securities, unless applicant is a public reporting company (a company subject to Sections 12 or 15(d) of the <em>Exchange Act</em>). Direct owners include any <em>person</em> that owns, beneficially owns, has the right to vote, or has the power to sell or direct the sale of, 5% or more of a class of the applicant's voting securities. For purposes of this Schedule, a <em>person</em> beneficially owns any securities:  (i) owned by his/her child, stepchild, grandchild, parent, stepparent, grandparent, spouse, sibling, mother-in-law, father-in-law, son-in-law, daughter-in-law, brother-in-law, or sister-in-law, sharing the same residence; or (ii) that he/she has the right to acquire, within 60 days, through the exercise of any option, warrant, or right to purchase the security;</div>
              </div>			  
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(b) If the applicant is organized as a partnership,</b> all general partners and each limited and special partner that has the right to receive upon dissolution, or has contributed, 5% or more of the applicant's capital;</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(c) In the case of a trust,</b> a <em>person</em> that directly owns 5% or more of a class of the applicant's voting securities, or that has the right to receive upon dissolution, or has contributed, 5% or more of the applicant's capital, the trust and each trustee; </div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(d) If the applicant is organized as a limited liability company (&quot;LLC&quot;),</b> (i) each member that has the right to receive upon dissolution, or has contributed, 5% or more of the applicant's capital, and (ii) if managed by elected managers, all elected managers; and</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(e) Each Chief Executive Officer, Chief Financial Officer, Chief Operations Officer, Chief Legal Officer, <em>Chief Compliance Officer</em>, director and any other individuals with similar status or functions (applies in Schedule A-2 only).</b></div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">3.</div>
                <div class="tdStyle1 tdscheduleacol2"><b>In the DE/FE column of Schedule A-1 below,</b> enter &quot;DE&quot; if the owner is a domestic entity, or &quot;FE&quot; if the owner is an entity organized, incorporated or domiciled in a foreign country.</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">4.</div>
                <div class="tdStyle1 tdscheduleacol2"><b>Complete the Title or Status column</b> by entering <em>board</em>/management titles; status as partner, trustee, sole proprietor, elected manager, shareholder, or member. For shareholders or members, indicate the class of securities owned (if more than one is issued). In the next column indicate the date that the title or status was acquired.</div>
              </div>
			  
			  
			  <div style="clear:both;"></div>
              <div class="tableRow">
	              <div class="tdStyle1 tdscheduleacol1">5.</div>
	              <div class="tdStyle1 tdscheduleacol2"><b>Ownership Codes are:</b><br></br>
									  
					<div style="margin-left:0; margin-right:0;padding-left:3pt;padding-right:3pt;padding:8px;vertical-align:top;text-align:left;font-weight:normal;">
	                <div class="tableStyle" style="margin-left:0; margin-right:0;padding-top:5px;">					
	                  <div class="tableRow">
	                    NA - less than 5%
								<br/>A - 5% but less than 10%
								<br/>B - 10% but less than 25%
								<br/>C - 25% but less than 50%
								<br/>D - 50% but less than 75%
								<br/>E - 75% or more
						
					  </div>
					</div>
					<div style="clear:both;"></div>
					</div>
					 
				  </div>
				  
			  </div>
			 
			 
			 
			 
			 
			  <div style="clear:both;"></div>
			  <div class="tableRow">
              	<div class="tdStyle1 tdscheduleacol1">6. </div>
                <div class="tdStyle1 tdscheduleacol2"><b>(a) In the <em>Control Person</em> column,</b> enter &quot;Yes&quot; in the first sub-column if the <em>person</em> has <em>control</em> as defined in the Glossary of Terms to Form MA, and enter &quot;No&quot; if the <em>person</em> does not have <em>control</em>. Note that under this definition, most executive officers and all 25% owners, general partners, elected managers, and trustees are <em>control persons</em>. </div>
              </div>
			  <div style="clear:both;"></div>
              <br></br>
              <div class="tableRow">
              	<div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(b) In the PR sub-column (Schedule A-1 only)</b> enter &quot;PR&quot; if the owner is a public reporting company under Section 12 or 15(d) of the <em>Exchange Act</em>.</div>
              </div>
			  <div style="clear:both;"></div>
              <br></br>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">7. </div>
                <div class="tdStyle1 tdscheduleacol2"><b>(a)  For Schedule A-1, </b> enter the organization <em>CRD</em> number. If not registered with the <em>CRD</em>, then enter the IRS Tax Number, Employer Identification Number (&quot;EIN&quot;), or Foreign Business Number.</div>
              </div>
			  <div style="clear:both;"></div>
              <br></br>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1"></div>
                <div class="tdStyle1 tdscheduleacol2"><b>(b) For Schedule A-2,</b> enter the individual <em>CRD</em> number. If not registered with the <em>CRD</em>, then enter 0000000.</div>
              </div>
			  <div style="clear:both;"></div>
              <br></br>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">8. </div>
                <div class="tdStyle1 tdscheduleacol2"><b>Does applicant have any indirect owners to be reported on Schedule B?</b>
		            <span class="yesNo">&#160;&#160;
		            <xsl:choose>                
		                <xsl:when
							test="m1:formData/m1:controls/m1:hasScheduleB = 'Y'">
							<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						<xsl:when
							test="m1:formData/m1:controls/m1:hasScheduleB = 'N'">
							<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No			  
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No</xsl:otherwise>
					</xsl:choose>
					</span>
            	</div>
               </div>
			   <div style="clear:both;"></div>
		    </div>
        </div>
        <br></br>
        <div class="scheduleBox hide" id="schedA1entry">
          <h2>Schedule A-1: <b>Direct Owners of Applicant </b> - Business Entities</h2>
       <xsl:for-each select="m1:formData/m1:scheduleA/m1:businesses/m1:business">
          <div class="newRecord hide" id="newschedA1">
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
		        <div class="tdStyle1">BUSINESS ENTITY FULL LEGAL NAME:<br/>
               		<div class="fakeBox">
	                         <xsl:value-of select="m1:name" />
	                     <span>
	                    <xsl:text>&#160;</xsl:text>
	                   </span>
	                   </div>             
                  </div>
              </div>
            </div>
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">DE/FE:                  
                  <span
						class="label">
						<xsl:choose>
							<xsl:when 	
							test="count(m1:deFeNp/m1:de) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
                        DE
						<xsl:choose>
							<xsl:when
								test="count(m1:deFeNp/m1:fe) &gt; 0">
								<img
									   src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
    					 FE
					</span>
                  </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
               <div class="tableRow">  
                	<div class="tdStyle1">Title or Status:<br/>
                      <div class="fakeBox">
                             <xsl:value-of
                                select="m1:baseInformation/m1:titleStatus" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>  
                  </div>
                  </div>
                <div class="tableRow">	
                	<div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Date Title or Status Acquired: 
                		<input type="text" name="title date2" class="dateField"	readonly="1">
							<xsl:attribute name="value">
								 <xsl:value-of select="m1:baseInformation/m1:statusAcquired"/>
							</xsl:attribute>
						</input>
                  	</div>
                  </div>	
              </div>
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Ownership Code:</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                  <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='NA']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
						</xsl:choose>
			                  NA - less than 5%</div>
							  
			                <div class="tdStyle1 tdscheduleagridcol1">
			                 <xsl:choose>
									<xsl:when
										test="count(m1:baseInformation[m1:ownershipCode='B']) &gt; 0 ">
										<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
											  
									</xsl:when>
									<xsl:otherwise>
									<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
									
						</xsl:choose>
			                  B - 10% but less than 25%</div>
							  
			                <div class="tdStyle1 tdscheduleagridcol1"> 
							<xsl:choose>
									<xsl:when
										test="count(m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
										<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
											  
									</xsl:when>
									<xsl:otherwise>
									<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
									
						</xsl:choose>
			                  D - 50% but less than 75%
			      </div>				  
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
				<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='A']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						</xsl:choose>
			                  A - 5% but less than 10%
			         </div>
			         <div class="tdStyle1 tdscheduleagridcol1"> 
			                <xsl:choose>
								<xsl:when
									test="count(m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
			                  C - 25% but less than 50%
			        </div>
                	<div class="tdStyle1 tdscheduleagridcol1">
						<xsl:choose>
								<xsl:when 
									test="count(m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
						</xsl:choose>
		                  E - 75% or more
				</div>
              </div>
			  <div style="clear:both;"></div>
            </div>
               <div style="clear:both;"></div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0; width:100%;"><em>Control Person</em>:
				  <xsl:choose>                
                		<xsl:when
							test="m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInformation/m1:isControPerson  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						 <xsl:when
							test="m1:baseInformation/m1:isControPerson = 'N' or m1:baseInformation/m1:isControPerson  = 'n'">
								<img 	src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
					</xsl:choose>
                  </div>
              </div>
              </div>
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0; width:100%;">PR:
                	<xsl:choose>                
                		<xsl:when
							test="m1:controPersonPR = 'Y' or m1:controPersonPR  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:when>
						 <xsl:when
							test="m1:controPersonPR = 'N' or m1:controPersonPR  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> Yes<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						</xsl:otherwise>
					</xsl:choose>
                  </div>
              </div>
            </div>
           
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 lavel" style="margin-left:0; margin-right:0;height:21; width:100%;"><strong>Organization <em>CRD</em> No. (If None: IRS Tax No., EIN, or Foreign Business No.)</strong></div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1"><em>CRD</em> No.:  <br/>                  
                       <input 	type="text" 	name="CRD3" 		readonly="1" size="18">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                  </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">IRS Tax No.: <br/>
                     <input 	type="text" 	name="irs tax no2" 		readonly="1" size="18">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:irsNum"/>
						</xsl:attribute>
					</input>
                   </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">EIN:  <br/>
                    <div class="fakeBox fakeBox5">
                        <xsl:value-of
                                select="m1:empIDNumber" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                      </span>
                    </div>  
              	</div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">Foreign Bus. No.: <br/>
                      <div class="fakeBox fakeBox5">
                             <xsl:value-of
                                select="m1:baseInformation/m1:foreignBusIdNo" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>  
                  </div>
              </div>
			   <div style="clear:both;"></div>
            </div>
          </div>
           </xsl:for-each>
         
        </div>
        <div class="scheduleBox hide" id="schedA2entry">
          <h2><b>Schedule A-2: Direct Owners and Executive Officers of Applicant – Natural Persons</b></h2>
         <xsl:for-each select="m1:formData/m1:scheduleA/m1:persons/m1:person">
          <div class="newRecord hide" id="newschedA2">
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">NATURAL PERSON FULL LEGAL NAME</div>
              </div>
               <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Enter all the letters of each name and not initials or other abbreviations. If no middle name, enter NMN on that line.</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdThreeCol">Last Name:<br />
                   <input 	type="text" 	name="textfield3" 		readonly="1" size="30">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:name/ns2:lastName"/>
						</xsl:attribute>
					</input>
                  
                  </div>
                <div class="tdStyle1 tdThreeCol">First Name: <br />
                    <input 	type="text" 	name="textfield3" 		readonly="1" size="30">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:name/ns2:firstName"/>
						</xsl:attribute>
					</input>
                    <br />
                   </div>
                <div class="tdStyle1 tdThreeCol">Middle Name:<br/>
                	<input 	type="text" name="textfield3" readonly="1" size="30">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:name/ns2:middleName"/>
						</xsl:attribute>
					</input>
                  </div>
              </div>
			  
            </div>
			<div style="clear:both;"></div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1">Title or Status: <br/>
               	<div class="fakeBox">
                             <xsl:value-of
                                select="m1:baseInformation/m1:titleStatus" />
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>  
               </div>
               </div>
			   <div style="clear:both;"></div>
               <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Date Title or Status Acquired: 
                <input 	type="text" 	name="title date" 	class="dateField"	readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:statusAcquired"/>
						</xsl:attribute>
					</input>
                  <label><br />
                    </label></div>
              </div>
			  <div style="clear:both;"></div>
              </div>
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Ownership Code:</div>
              </div>
                <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                  <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='NA']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
                  NA - less than 5%</div>
                <div class="tdStyle1 tdscheduleagridcol1">
                 <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='B']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
                  B - 10% but less than 25%</div>
                <div class="tdStyle1 tdscheduleagridcol1"> 
				<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
                  D - 50% but less than 75%</div>
              </div>
			   <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
				<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='A']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
                  A - 5% but less than 10%</div>
                <div class="tdStyle1 tdscheduleagridcol1"> 
				<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
                  C - 25% but less than 50%</div>
                <div class="tdStyle1 tdscheduleagridcol1">
				<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
							<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
								  
						</xsl:when>
						<xsl:otherwise>
						<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
						
				</xsl:choose>
                  E - 75% or more
				</div>
              </div>
			   <div style="clear:both;"></div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
                <!-- td><p><em>Control Person</em>:</p></div-->
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0; width:100%;"><em>Control Person</em>:
                      <xsl:choose>                
                <xsl:when
							test="m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInformation/m1:isControPerson  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> NO
								  
						</xsl:when>
						 <xsl:when
							test="m1:baseInformation/m1:isControPerson = 'N' or m1:baseInformation/m1:isControPerson  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
								  
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO</xsl:otherwise>
					</xsl:choose>
		          </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0; width:100%;">Individual <em>CRD</em> No. (If None: enter 0000000):</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1"><em>CRD</em> No.:<br />                  
                       <input type="text" name="CRD8" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                   </div>
                <!-- <div class="tdStyle1 tdscheduleagridcrdcol1">SSN: <br />                     -->
                     <!-- <input type="text" name="irs tax no2" 	readonly="1"> -->
						<!-- <xsl:attribute 			name="value"> -->
							 <!-- <xsl:value-of select="m1:ssNum"/> -->
						<!-- </xsl:attribute> -->
					<!-- </input>                    -->
                    <!-- </div> -->
                <!-- <div class="tdStyle1 tdscheduleagridcrdcol1">DOB:<br />                   -->
                     <!-- <input type="text" name="employer id no2" 	readonly="1"> -->
						<!-- <xsl:attribute 			name="value"> -->
							 <!-- <xsl:value-of select="m1:dob"/> -->
						<!-- </xsl:attribute> -->
					<!-- </input>                     -->
                   <!-- </div> -->
                <!-- <div class="tdStyle1 tdscheduleagridcrdcol1">Foreign ID No:<br /> -->
                  <!-- <div class="fakeBox fakeBox5"> -->
                             <!-- <xsl:value-of -->
                                <!-- select="m1:baseInformation/m1:foreignBusIdNo" /> -->
                         <!-- <span> -->
                        <!-- <xsl:text>&#160;</xsl:text> -->
                       <!-- </span> -->
                       <!-- </div>   -->
                <!-- </div> -->
              </div>
			  <div style="clear:both;"></div>
            </div>			
          </div>
		   
         </xsl:for-each>
        </div>
      
</xsl:template>

</xsl:stylesheet>