﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 4 templates -->
	
<xsl:template name="Item4" >
	<h3><em>Employees </em> </h3>
	<xsl:call-template
					name="Employees" />
	<h3><em>Clients </em> </h3>
	<xsl:call-template
					name="TypesOfClients" />
	<xsl:call-template
					name="SolicitationsofPersons" />
	<h3><em>Compensation Arrangements</em> </h3>
	<xsl:call-template
					name="CompensationArrangements" />

	<h3><em>Applicant's Business Relating to Municipal Securities </em> </h3>
	<xsl:call-template
					name="AppliBusMUSecurities" />
</xsl:template>

<xsl:template name="Employees">
<p><em>If the applicant is organized as a sole proprietorship, include the sole proprietor as an employee. </em> </p>
<h4>A. Number of <em>Employees</em>:</h4>
<div class="tableStyle" style="margin-left:0; margin-right:0;"> 
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"> Approximate number of <em>employees</em>  of applicant.  
      Include full- and part-time <em>employees</em>,  but do not include clerical, administrative, or support workers (or workers performing similar functions): (If none, enter a zero.):</div>
    <div class="tdStyle1 tditem10col2">	
		<input
					type="text"
					name="text49"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:numberOfEmployees)" />
				</xsl:attribute>
				</input>
      </div>  
  <div style="clear:both;"></div>
  </div>
  <h4>B. <em>Municipal Advisory Activities</em>:</h4> 
  <div class="tableStyle" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"> Approximately how many of these <em>employees</em>  engage in <em>municipal advisory activities</em>? 
      <em>(Include such employees even if they perform other functions in addition to engaging in municipal advisory activities.)</em> If none, enter a zero.
      </div>
    <div class="tdStyle1 tditem10col2">	
		<input
					type="text"
					name="text50"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:employeesEngagedInMAA)" />
				</xsl:attribute>
				</input>
    
    </div> 
  <div style="clear:both;"></div>
</div>
<h4>C. Registered Representatives</h4>
     <div class="tableStyle" style="margin-left:0; margin-right:0;"> 
		
			<div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) Approximately how many of the <em>employees</em> who are included in the response to part B are registered representatives of a broker-dealer? If none, enter a zero.
			</div>
		<div class="tdStyle1 tditem10col2">	    
			<input
						type="text"
						name="text3"
						readonly="1">
						<xsl:attribute
							name="value">
					<xsl:value-of
							select="string(m1:maaEmployeesRegBD)" />
					</xsl:attribute>
					</input>    
		</div>
		
  <div style="clear:both;"></div>
  <div class="tableStyle" style="margin-left:0; margin-right:0;"> 
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) Approximately how many are <em>investment adviser</em> representatives? If none, enter a zero.</div>
    <div class="tdStyle1 tditem10col2">		
			<input
					type="text"
					name="text2"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:maaRegIA)" />
				</xsl:attribute>
				</input>    
    </div>
  </div>
  <div style="clear:both;"></div>
  </div>
  <div style="clear:both;"></div>
     <h4><b>D. Firms and Other <em>Persons</em> that <em>Solicit</em> on Behalf of the Applicant</b></h4>
<!-- <p>Approximately how many firms and other <em>persons</em> who are not employed by the applicant and who are not otherwise <em>associated persons</em> of the applicant <em>solicit clients</em> on the applicant's behalf? (If none, enter a zero.  Count a firm only once; do not count each of the firm’s employees that solicits on the applicant’s behalf.)</p> -->
<div class="tableStyle" style="margin-left:0; margin-right:0;">
	
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">Approximately how many firms and other <em>persons</em> who are not employed by the applicant and who are not otherwise 
    <em>associated persons</em> of the applicant <em>solicit clients</em> on the applicant's behalf? (If none, enter a zero. 
    Count a firm only once; do not count each of the firm’s <em>employees</em> that <em>solicits</em> on the applicant’s behalf.)
</div>
    <div class="tdStyle1 tditem10col2">	
			<input
					type="text"
					name="text48"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:numberOfSolicitingFirms)" />
				</xsl:attribute>
				</input>
    
    
    </div>

  <div style="clear:both;"></div>
	
  	<div class="tdStyle1 tdLabelStyleBgcolor tditem41col">
  	Please list the names of these firms and other <em>persons</em> on <span style="text-decoration: underline; font-weight: bold;">Section 4-D of Schedule D</span>.
  	</div>
  
  <div style="clear:both;"></div>
</div>
<h4>E. <em>Employees</em> Also Acting as <em>Affiliates</em> of the Applicant</h4>
<div class="tableStyle" style="margin-left:0; margin-right:0;">  
    <div class="tdStyle1 tdLabelStyle tditem10col1" >(1) Does the applicant have any <em>employees</em>  that also do business independently on the applicant's behalf as <em>affiliates</em> of the applicant?
	</div>
    <div class="tdStyle1 tditem10col2">
	            <xsl:choose>
					<xsl:when test="(count(m1:controls/m1:independentBusinessEmployee) &gt; 0)">
						<xsl:choose>
							<xsl:when test="(string(m1:controls/m1:independentBusinessEmployee) ='Y')">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />YES
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
							</xsl:when>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="(string(m1:controls/m1:independentBusinessEmployee) ='N')">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
								<img src="Images/radio-checked.jpg" alt="radio button checked" />NO
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
					</xsl:otherwise>
				</xsl:choose>
	</div>
	<div style="clear:both;"></div>
 </div>
  <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none; margin-top:1px;">  
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1" style="border-bottom:none; margin-top:1px;">(2) Total number of such <em>employees</em>:</div> 
    <div class="tdStyle1 tditem10col2" style="border-bottom:none; margin-top:1px;">	
			<input
					type="text"
					name="text5"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:numberOfIndBusinessEmployees) " />
				</xsl:attribute>
				</input>
    
      </div>
	  <div style="clear:both;"></div>
  </div>
 
  
  <div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none; margin-top:1px;"> 
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3) List the names of these <em>employees</em> on 
    <span style="text-decoration: underline; font-weight: bold;">Section 4-E of Schedule D</span>.</div>
    </div>
	<div style="clear:both;"></div>

</xsl:template>

<xsl:template name="TypesOfClients">
	<h4>F. Types of <em>Clients</em></h4>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">Approximately how many <em>clients</em> did the applicant serve in the context of its 
    <em>municipal advisory activities</em>  during its most-recently completed fiscal year? 
    (If none, enter a zero and check box 5 below).</div>
    <div class="tdStyle1 tditem10col2">	
			<input
					type="text"
					name="text6"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:clientsServedAsMA)" />
				</xsl:attribute>
				</input>
    
    </div>
  
  <div style="clear:both;"></div>
</div>
<p>The applicant has the following types of <em>clients:</em> </p>
<p>Check all that apply.</p>

<p>    
  
	  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfClients/m1:typesOfClients[m1:clientTypes='Municipal Entities']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
   
  (1) <em>Municipal Entities</em> <br/>

	  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfClients/m1:typesOfClients[m1:clientTypes='Non-profit organizations']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (2) Non-profit organizations (<em>e.g.</em>, 501(c)(3) organizations) who are <em>obligated persons</em>  <br/>
 
   
	  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfClients/m1:typesOfClients[m1:clientTypes='Corporations or other businesses']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (3) Corporations or other businesses not listed above who are <em>obligated persons</em> <br/>
 
  
	<xsl:choose>
						<xsl:when
							test="count(m1:typesOfClients/m1:typesOfClients[m1:clientTypes='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (4) Other: (specify)
	  <xsl:choose>
		  <xsl:when
							test="count(m1:typesOfClients/m1:typesOfClients[m1:clientTypes='Other']) &gt; 0 ">
						      <textarea name="text"  cols="45" rows="5">     
				<xsl:value-of	select="string(m1:typesOfClients/m1:typesOfClientsOther)" />
    </textarea>				
			</xsl:when>
			<xsl:otherwise><input	type="text" 	name="text" 	readonly="1"	size="70"/> </xsl:otherwise>
		</xsl:choose>
		
  <br/>
  
   
	<xsl:choose>
						<xsl:when
							test="count(m1:typesOfClients/m1:typesOfClients[m1:clientTypes='Not Applicable']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (5) Not applicable - applicant engages only in <em>solicitation</em>; does not serve <em>clients</em>  in the context of its <em>municipal advisory activities</em></p>
</xsl:template>

<xsl:template name="SolicitationsofPersons">
	<h4>G. <em>Solicitations</em> Of <em>Municipal Entities</em> and <em>Obligated Persons</em></h4>
    <p>Approximately how many <em>municipal entities</em> and <em>obligated persons</em> 
	were <em>solicited</em> by the applicant on behalf of a third-party during its 
	most-recently completed fiscal year? <em>(If the applicant solicits its 
	clients in addition to serving these clients in the context of its municipal 
	advisory activities, the clients should be counted in the response to this Part G 
	even if counted in Part F.) </em></p>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) <em>Municipal Entities</em>:      <p>If none, enter a zero. </p></div>
    <div class="tdStyle1 tditem10col2">		    
			<input
					type="text"
					name="text7"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:numberOfSolicitedME)" />
				</xsl:attribute>
				</input>
    </div>
<div style="clear:both;"></div>	
  </div>
  
  <div class="tableStyle" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) <em>Obligated Persons</em>:
<p> If none, enter a zero</p></div>
    <div class="tdStyle1 tditem10col2">	    
			<input
					type="text"					
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:numberOfSolicitedOP)" />
				</xsl:attribute>
				</input>
      </div>	
<div style="clear:both;"></div>	  
  </div>
  
  <div class="tableStyle" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3) Total:</div>
    <div class="tdStyle1 tditem10col2">	
			<input
					type="text"					
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:totalNumberOfSolicitedMEAndOP)" />
				</xsl:attribute>
				</input>
    </div>
	 <div style="clear:both;"></div>
  </div>

<h4>H. Types of <em>Persons Solicited</em></h4>
<p>The applicant <em>solicits</em> the following types of <em>persons</em>:</p>
<p>Check all that apply.</p>
<p>
  
  
	 	<xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Public pension funds']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (1) Public pension funds  <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='529 Plans']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>

  (2) 529 Plans <br/>
   <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Local government investment pools']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (3) Local government investment pools <br/>
    <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='State government investment pools']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (4) State government investment pools <br/>
    <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Hospitals']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (5) Hospitals <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Colleges']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (6) Colleges  <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (7) Other: (specify)
   <xsl:choose>
		  <xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Other']) &gt; 0 ">
	<textarea name="text"  cols="45" rows="5">     
				<xsl:value-of	select="string(m1:typesOfSolicitedPersons/m1:spOtherDescription)" />
    </textarea>		
			</xsl:when>
			<xsl:otherwise><input	type="text" 	name="text" 	readonly="1"	size="70"/> </xsl:otherwise>
		</xsl:choose>
  <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:typesOfSolicitedPersons/m1:solicitationPersonTypes[m1:solicitationPersonTypes='Not Applicable']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (8) Not applicable &#8211; applicant only serves <em>clients;</em> does not engage in <em>solicitation</em> in the context of its<em> municipal advisory activities</em> </p>
</xsl:template>

<xsl:template name="CompensationArrangements">
<h4>I. Applicant is compensated for its advice to or on behalf of <em>municipal entities</em> 
or <em>obligated persons</em> with respect to <em>municipal financial products</em> 
or the issuance of municipal securities by:</h4>
<p>Check all that apply.</p>
<p>
    <xsl:choose>
						<xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Hourly Charges']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (1) Hourly <em>charges</em> <br/>
 <xsl:choose>
						<xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Fixed Fees']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (2) Fixed fees (not contingent on the issuance of municipal securities)<br/>
 <xsl:choose>
						<xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Contingent Fees']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (3) <em>Contingent fees</em> <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Subscription Fees']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (4) Subscription fees (for a newsletter or other publications)<br/>
   <xsl:choose>
						<xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (5) Other: (specify) 
     <xsl:choose>
		  <xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Other']) &gt; 0 ">
			      <textarea name="text"  cols="45" rows="5">     
				<xsl:value-of	select="string(m1:meOrOPCompensationTypes/m1:COMP_TYPE_OTHER_DESCRIPTION)" />
    </textarea>
			</xsl:when>
			<xsl:otherwise><input	type="text" 	name="text" 	readonly="1"	size="70"/> </xsl:otherwise>
		</xsl:choose>
  <br/>
    <xsl:choose>
						<xsl:when
							test="count(m1:meOrOPCompensationTypes/m1:compensationTypes[m1:compensationTypes='Not Applicable']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (6) Not applicable &#8211; applicant engages only in <em>solicitation</em>; does not serve <em>clients</em>  in the context of its <em>municipal advisory activities</em></p>

<h4>J. Applicant is compensated for its <em>solicitation</em> activities by:</h4>
<p>Check all that apply.</p>
<p>
  <xsl:choose>
						<xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Hourly Charges']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (1) Hourly <em>charges</em> <br/>
   <xsl:choose>
						<xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Fixed Fees']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (2) Fixed fees (not contingent on the success of <em>solicitations</em>) <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Contingent Fees']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (3) <em>Contingent fees</em> <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Subscription Fees']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (4) Subscription fees (for a newsletter or other publications) <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (5) Other: (specify) 
  <xsl:choose>
		  <xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Other']) &gt; 0 ">
	<textarea name="text"  cols="45" rows="5">     
				<xsl:value-of	select="string(m1:solicitationCompensationTypes/m1:COMP_TYPE_OTHER_DESCRIPTION)" />
    </textarea>		

			</xsl:when>
			<xsl:otherwise><input	type="text" 	name="text" 	readonly="1"	size="70"/> </xsl:otherwise>
		</xsl:choose>
  <br/>
  <xsl:choose>
						<xsl:when
							test="count(m1:solicitationCompensationTypes/m1:compensationTypes[m1:compensationTypes='Not Applicable']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
  (6) Not applicable; applicant only serves <em>clients</em>; does not engage in <em>solicitation</em> as part of its <em>municipal advisory activities</em> </p>
<h4></h4>

<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div class="tableStyle tablebottom" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1 tdLabelStyleBgcolor tditem41col"><h4>K. Does the applicant receive compensation, in the context of its 
    <em>municipal advisory activities</em>, from anyone other than <em>clients</em>?</h4> 
    </div>
	<div style="clear:both;"></div>	
   </div>
   
   <div class="tableStyle" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1  tditem41col">	
     <!--<span class="yesNo" style="padding-left: 10px;">    -->
	            <xsl:choose> 
	            <!-- this logic must be fixed to cover 3 states: 
	            	1) Yes is selected, 
	            	2) No is selected, and 
	            	3) neither Yes nor No is selected -->

					<!-- Old Logic	<xsl:when test="(count(m1:receiveCompensationForMAAFromOtherClientsExplanation) &gt; 0)">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
										<img src="Images/radio-checked.jpg" alt="radio button checked" />NO
									</xsl:otherwise>
					-->
					<!--  New and Correct Logic -->
									<xsl:when test="m1:controls/m1:receiveCompensationForMAAFromOtherClients = 'Y' or m1:controls/m1:receiveCompensationForMAAFromOtherClients = 'y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
									</xsl:when>
									
									<xsl:when test="m1:controls/m1:receiveCompensationForMAAFromOtherClients = 'N' or m1:controls/m1:receiveCompensationForMAAFromOtherClients = 'n'">
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
										<img src="Images/radio-checked.jpg" alt="radio button checked" />NO
									</xsl:when>

									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />NO
									</xsl:otherwise>
				</xsl:choose>
	<!--</span>    -->
      </div>
   	<div style="margin-left:0; margin-right:0;">	&#160;</div>
	<div style="clear:both;"></div>	
  </div>
  
  <div class="tableStyle" style="margin-left:0; margin-right:0;">
    <div class="tdStyle1 tdLabelStyleBgcolor tdTwoCol1"><em>If &quot;Yes&quot;, please explain:</em> </div>
    
    <div class="tdStyle1 tdTwoCol2">	
    <!-- 
    <textarea name="explain" id="explain" cols="45" rows="5">     
				<xsl:value-of	select="m1:receiveCompensationForMAAFromOtherClientsExplanation" />
    </textarea>
    -->
       <xsl:choose>
          <xsl:when
                test="count(m1:receiveCompensationForMAAFromOtherClientsExplanation)">
                <!--            
              <textarea name="text"  cols="45" rows="5">     
                <xsl:value-of   select="string(m1:engagedActivities/m1:eaTypeOtherDescription)" />
            </textarea>
            -->
            <div class="fakeBox fakeBox4">
                        <xsl:value-of select="m1:receiveCompensationForMAAFromOtherClientsExplanation" />
                         <span>
                             <xsl:text>&#160;</xsl:text>
                       </span>
                   </div>
            </xsl:when>
            <xsl:otherwise><input   type="text"     name="text"     readonly="1"    size="70"/> </xsl:otherwise>
        </xsl:choose>
    </div>
	<div style="clear:both;"></div>
  </div>
</div>

</xsl:template>

<xsl:template name="AppliBusMUSecurities">
	<h4>L. Applicant is engaged in the following types of activities:</h4>
<p>Check all that apply.</p>
<div style="clear:both;"></div>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
    <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice Insurance Of MS']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (1) Advice concerning the issuance of municipal securities (including, without limitation, 
  advice concerning the structure, timing, terms and other similar matters, such as the 
  preparation of feasibility studies, tax rate studies, appraisals and similar documents, 
  related to an offering of municipal securities)<br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
     <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice Investment Of Proceeds MS']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >		
  (2) Advice concerning the investment of the proceeds of municipal securities (including, 
  without limitation, advice concerning the structure, timing, terms and other similar 
  matters concerning such investments) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
      <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice ME Investments']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >		
  (3) Advice concerning municipal escrow investments (including, without limitation, advice concerning their structure, timing, terms and other similar matters) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
			<xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice ME Other Investments']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (4) Advice concerning the investment of other funds of a <em>municipal entity</em> (including, without limitation, advice concerning the structure, timing, terms and other similar matters concerning such investments) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1" >		
  <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice Guaranteed IC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >		
  (5)  Advice concerning <em>guaranteed investment contracts</em> (including, without limitation, advice concerning their structure, timing, terms and other similar matters) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1" >	
  <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice Use Of MD']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (6) Advice concerning the use of <em>municipal derivatives</em> (including, without limitation, advice concerning their structure, timing, terms and other similar matters) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
  <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Solicitation Of IAB']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (7) <em>Solicitation</em> of investment advisory business from a <em>municipal entity</em> or <em>obligated person</em> (including, without limitation, municipal pension plans) on behalf of an un<em>affiliated</em> broker, dealer, <em>municipal advisor</em> or <em>investment adviser</em> (<em>e.g.</em>, third party marketers, placement agents, <em>solicitors</em>, and finders) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
			<xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Solicitation Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (8) <em>Solicitation</em> of business other than investment advisory business from a <em>municipal entity</em> or <em>obligated person</em> on behalf of an un<em>affiliated</em> person or firm (<em>e.g.</em>, third party marketers, placement agents, <em>solicitors</em>, and finders) <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
  			<xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Advice On Selection']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (9) Advice or recommendations concerning the selection of other <em>municipal advisor</em>s or underwriters with respect to <em>municipal financial products</em> or the issuance of municipal securities <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
		  <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Brokerage Of MEI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (10) Brokerage of municipal escrow investments <br/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdscheduleacol1">	
		  <xsl:choose>
						<xsl:when
							test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Other']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
		</div>
		<div class="tdStyle1 tdscheduleacol2" >	
  (11) Other: (specify)
    <xsl:choose>
		  <xsl:when
				test="count(m1:engagedActivities/m1:engagedActivityTypes[m1:engagedActivityType='Other']) &gt; 0 ">
				<!-- 			
			  <textarea name="text"  cols="45" rows="5">     
				<xsl:value-of	select="string(m1:engagedActivities/m1:eaTypeOtherDescription)" />
            </textarea>
            -->
            <div class="fakeBox">
                        <xsl:value-of select="string(m1:engagedActivities/m1:eaTypeOtherDescription)" />
                         <span>
                             <xsl:text>&#160;</xsl:text>
                       </span>
                   </div>
			</xsl:when>
			<xsl:otherwise><input	type="text" 	name="text" 	readonly="1"	size="70"/> </xsl:otherwise>
		</xsl:choose>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div style="margin-left:0; margin-right:0;">	
		</div>
		<div style="margin-left:0; margin-right:0;">	
		</div>
	</div>
</div>
</xsl:template>
</xsl:stylesheet>