<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 10 templates -->
	
<xsl:template name="Item10" >
<p>The <em>SEC</em> is required by the Regulatory Flexibility Act to consider the 
   effect of its regulations on small entities. In order to do this, the 
   <em>SEC</em>  needs to determine whether you meet the Small Business Administration's 
   definition of &quot;small business&quot; for purposes of entities that provide 
   investment and related activities. Accordingly, answer &quot;Yes&quot; 
   or &quot;No,&quot; as appropriate, to the questions below:</p>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">A. Did the applicant have annual receipts of less than $7 million during its most recent fiscal year (or during the time the applicant has been in business, if it has not completed its first fiscal year in business)?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:hasAnnualReceiptsLessThan7Million = 'Y' or m1:hasAnnualReceiptsLessThan7Million  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:hasAnnualReceiptsLessThan7Million  = 'N' or m1:hasAnnualReceiptsLessThan7Million  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>         
    </div>
  </div>
  <div style="clear:both"></div>
</div>
<div class="tablemiddle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">B. Is the applicant <em>affiliated</em> with any business or organization that had annual receipts of $7 million or more during its most recent fiscal year (or during the time it has been in business, if it has not completed its first fiscal year in business)? </div>
    <div class="tdStyle1 tditem10col2" >
		<xsl:choose>
						<xsl:when
							test="m1:isAffiliatedWithReceiptsMoreThan7Million = 'Y' or m1:isAffiliatedWithReceiptsMoreThan7Million = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						<xsl:when
							test="m1:isAffiliatedWithReceiptsMoreThan7Million = 'N' or m1:isAffiliatedWithReceiptsMoreThan7Million = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
						</xsl:when>
						<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
			</xsl:choose>            
    </div>
  </div>
  <div style="clear:both"></div>
</div>
</xsl:template>

</xsl:stylesheet>