﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">

	<xsl:import href="util.xsl"/>
	
	<xsl:output
		method="html"
		indent="no"
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:template
		match="/">
		<html>
			<head>
				<link
					rel="stylesheet"
					type="text/css"
					href="css/MA_print.css" />
			</head>
			<body
				lang="en-US"
				text="#000000"
				bgcolor="#ffffff">
				<xsl:call-template
					name="header" />
				<xsl:apply-templates />
			</body>
		</html>
	</xsl:template>

	 <xsl:template
  name="header">
	<!--<div>
   <div id="header" style="display:table; margin-left:0px; margin-right:0;">
    <div style="display:table-row; margin-left:0; margin-right:0;">
     <div class="title" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">FORM MA</div>
     <div class="center" style="display:table-cell; margin-left:0; margin-right:0; width:50%;">
      UNITED STATES
      <br />
      SECURITIES AND EXCHANGE COMMISSION
      <br />
      Washington, D.C. 20549
     </div>
     <div class="title" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">OMB APPROVAL</div>
    </div>
    <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'MA'">
    <div style="display:table-row; margin-left:0; margin-right:0;">
     <div class="side"  style="display:table-cell; margin-left:0; margin-right:0; width:25%;">
      
      <p>APPLICATION FOR <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR BUSINESS ENTITIES</p>
     </div>
     <div style="display:table-cell; margin-left:0; margin-right:0; width:50%;">
     </div>
     <div class="side" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">
      <p>OMB Number:&#160;&#160;3235-0681</p>
       <hr></hr>
      <p>Estimated average burden hours per response:&#160;3.5</p>
     </div>
    </div>
    </xsl:if>
    
    <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'MA-A'">
    <div style="display:table-row; margin-left:0; margin-right:0;">
     <div class="side" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">
      
      <p>ANNUAL UPDATE OF <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR BUSINESS ENTITIES</p>
     </div>
     <div style="display:table-cell; margin-left:0; margin-right:0; width:50%;">
     </div>
     <div class="side" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">
      <p>OMB Number:&#160;&#160;3235-0681</p>
       <hr></hr>
      <p>Estimated average burden hours per response:&#160;1.5</p>
     </div>
    </div>
    </xsl:if>
    
    <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'MA/A'">
    <div style="display:table-row; margin-left:0; margin-right:0;">
     <div
      class="side" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">
      
      <p>AMENDMENT OF A PRIOR APPLICATION FOR <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR BUSINESS ENTITIES</p>
     </div>
     <div
      style="display:table-cell; margin-left:0; margin-right:0; width:50%;">
     </div>
     <div class="side" style="display:table-cell; margin-left:0; margin-right:0; width:25%;">
      <p>OMB Number:&#160;&#160;3235-0681</p>
       <hr></hr>
      <p>Estimated average burden hours per response:&#160;0.5</p>
     </div>
    </div>
    </xsl:if>
   </div>

   </div>-->
   
   
   <div class="contentwrapper">
   <div id="header">
   <div class="header1" style="margin-left:0; margin-right:0;">
    <div style="margin-left:0; margin-right:0;">
     <div class="title1" style="margin-left:0; margin-right:0;">FORM MA</div>
     <div class="center1" style="margin-right:0;">
      UNITED STATES
      <br />
      SECURITIES AND EXCHANGE COMMISSION
      <br />
      Washington, D.C. 20549
     </div>
     <div class="title2" style="margin-left:0; margin-right:0;">OMB APPROVAL</div>
    </div>
    <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'MA'">
    <div style="margin-left:0; margin-right:0;">
     <div class="side1" style="margin-left:0; margin-right:0;">
      
      <p>APPLICATION FOR <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR BUSINESS ENTITIES</p>
     </div>
     <div style="margin-left:0; margin-right:0;">
     </div>
     <div class="side2" style="margin-left:0; margin-right:0;">
      <p>OMB Number:&#160;&#160;3235-0681</p>
       <hr></hr>
      <p>Estimated average burden hours per response:&#160;3.5</p>
     </div>
    </div>
    </xsl:if>
    
    <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'MA-A'">
    <div style="margin-left:0; margin-right:0;">
     <div class="side1" style="margin-left:0; margin-right:0;">
      
      <p>ANNUAL UPDATE OF <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR BUSINESS ENTITIES</p>
     </div>
     <div style="margin-left:0; margin-right:0;">
     </div>
     <div class="side2" style="margin-left:0; margin-right:0;">
      <p>OMB Number:&#160;&#160;3235-0681</p>
       <hr></hr>
      <p>Estimated average burden hours per response:&#160;1.5</p>
     </div>
    </div>
    </xsl:if>
    
    <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'MA/A'">
    <div style="margin-left:0; margin-right:0;">
     <div class="side1" style="margin-left:0; margin-right:0;">
      
      <p>AMENDMENT OF A PRIOR APPLICATION FOR <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR BUSINESS ENTITIES</p>
     </div>
     <div style="margin-left:0; margin-right:0;">
     </div>
     <div class="side2" style="margin-left:0; margin-right:0;">
      <p>OMB Number:&#160;&#160;3235-0681</p>
       <hr></hr>
      <p>Estimated average burden hours per response:&#160;0.5</p>
     </div>
    </div>
    </xsl:if>
   </div>
   </div>
   </div>
 </xsl:template> 


	<xsl:template
		match="m1:edgarSubmission">
		<xsl:apply-templates
			select="m1:headerData/m1:filerInfo" />
		<!-- Start -->
		<div
			class="contentwrapper">
			
				<div
					class="content">
			<p><u style="border-bottom: 1px solid; line-height: 1.4em;">
			Please read the General Instructions for this form and other forms in the MA series, as well as its subsection, &quot;Specific Instructions for Certain Items in Form MA,&quot; 
			before completing this form.  All <em>italicized</em> terms herein are defined or described in the Glossary of Terms appended to the General Instructions.   
			</u></p>

				<h2>Part I </h2>
				
				  
				  <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">This form must be completed by <em>municipal advisors</em> that are organized entities, 
						including sole proprietors (referred to herein as <em>&quot;municipal advisory firms&quot; </em>or &quot;firms,&quot; 
						unless the context indicates otherwise).</div>							
							</div>
						<div style="clear:both"></div>
						</div>

				<h2>WARNING:</h2>
					<p>
					Complete this form truthfully.  False statements or omissions may result in denial of application, revocation of registration, 
					administrative or civil action, or criminal prosecution. Form MA must be amended promptly upon the occurrence of certain material events, 
					and updated at least annually, within 90 days of the end of the <em>municipal advisor</em>'s fiscal year, or, if a sole proprietor, the <em>municipal 										advisor</em>'s calendar year.  See <em>General Instruction 8</em>.  			
					</p>
					
					
					<h3><u>Type of Filing</u>:  </h3>
					<p>This is an:</p> 
					<p>Check the appropriate box.</p>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
					<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
							
						<xsl:choose>
							<xsl:when
								test="m1:headerData/m1:submissionType = 'MA'">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
					Initial application to register as a <em>municipal advisor</em> with the <em>SEC</em>.
				<br></br>
			
					<p>
					 <u>Execution Page</u>:  After completing this form, you must complete the Execution Page.
					</p>
				<br></br>

					<p>
					 <u>Supporting Documentation</u>:  If you are required to make reportable disclosures in the Disclosure Reporting
					Pages, you must attach the supporting documentation.
					</p>
				<br></br>

					<p>
					 <u><em>Non-Resident</em> Applicants</u>:  If you are a non-resident of the United States, 
					certain additional requirements must be met at the time of filing your application, <u><em><b>or processing of your application may be delayed</b></em></u>.  					See General Instruction 2.c. and subsection &quot;General Instructions to Form MA-NR&quot; of the General Instructions.
					</p>
				<br></br>
					</div>
					</div>
					
					<div style="clear:both"></div>	

					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
					<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
						<xsl:choose>
							<xsl:when
								test="m1:headerData/m1:submissionType = 'MA-A'">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
					<em>Annual update of municipal advisor</em>’s Form MA, for fiscal year ended 
					<input
						type="text"
						name="Email"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
								select="string(m1:formData/m1:fiscalYearEnd)" />
						</xsl:attribute>
					</input>
						, or, if a sole proprietor, for calendar year ended December 31, <input
						type="text"
						name="Email"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
								select="string(m1:formData/m1:calYearEnd)" />
						</xsl:attribute>
					</input>.
					
			
					
					<p>
					<br></br>
					<u>Execution Page</u>:  After completing this form, you must complete the Execution Page.
					</p>
					
					<br></br>

					
					<p>
					<u>Changes</u>:  Are there any changes in this <em>annual update</em> to information provided in the <em>municipal advisor</em>’s most recent Form MA, other than the updated Execution Page?  ⁪ 
					<span
						class="yesNo">
						<xsl:choose>
							<xsl:when test="m1:headerData/m1:submissionType = 'MA/A'
							 or m1:headerData/m1:submissionType = 'MA'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes 
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:when>
							<xsl:when test="m1:headerData/m1:submissionType = 'MA-A' and
							(m1:formData/m1:hasChanges = 'Y' or m1:formData/m1:hasChanges = 'y')">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No					
							</xsl:when>
							<xsl:when test="m1:headerData/m1:submissionType = 'MA-A' and
							(m1:formData/m1:hasChanges = 'N' or m1:formData/m1:hasChanges = 'n')">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
								<img src="Images/radio-checked.jpg" alt="radio button checked" />No													
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes 
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:otherwise>
							</xsl:choose>							
					</span>  
					</p>
					</div>
					</div>
					</div>
					<div style="clear:both"></div>	

					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
					<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
						<xsl:choose>
							<xsl:when
								test="m1:headerData/m1:submissionType = 'MA/A'">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						Amendment (other than <em>annual update</em>) to any part of the municipal advisor’s most recent Form MA.
			
					<p>
					<br></br>
					<u>Execution Pages</u>:  After completing this form, you must complete the Execution Page.
				
					</p>
					</div>
					</div>
					</div>
				<div style="clear:both"></div>	

				</div>

				</div>
			</div>
		<!-- End -->
		<xsl:apply-templates
			select="m1:formData" />
			<h1>Form MA 
		<br/> APPLICATION FOR MUNICIPAL ADVISOR REGISTRATION</h1>     
			<div class="form1">
				<xsl:call-template 			name="execution" />
			</div>
				<h1>SCHEDULE A<br/>Direct Owners and Executive Officers of the Applicant</h1>     
			<div class="form1">
				<xsl:call-template 			name="scheduleA" />
			</div>
			<h1>SCHEDULE B<br/>Indirect Owners of the Applicant</h1>

			<div class="form1">
				<xsl:call-template 			name="scheduleB" />
			</div>
			<br/>
			<xsl:if test="m1:headerData/m1:submissionType != 'MA'">
							
			<h1>SCHEDULE C <br/> Amendments to Schedules A and B</h1>
			<div class="form1">
				<xsl:call-template 			name="scheduleC" />
			</div>
			</xsl:if>
			<h1>SCHEDULE D</h1>

			<div class="form1">
						<xsl:call-template                                  name="scheduleD" />
						<p
                                      style="page-break-before: always" />
			</div>

		<h1>CRIMINAL ACTION DISCLOSURE REPORTING PAGE (MA)</h1>

			<div class="form1">
				<xsl:call-template 			name="criminalDisclosureDrp" />
			</div>
			<h1>REGULATORY ACTION DISCLOSURE REPORTING PAGE (MA)</h1>

			<div class="form1">
				<xsl:call-template 			name="regulatoryDisclosureDrp" />
			</div>
			<h1>CIVIL JUDICIAL ACTION DISCLOSURE REPORTING PAGE (MA)</h1>

			<div class="form1">
				<xsl:call-template 			name="judicialDisclosureDrp" />
			</div>
		
	</xsl:template>

	<xsl:template
		match="m1:headerData/m1:filerInfo">
		<div
			id="info">
			<div class="contentwrapper">
				<div class="content">
					<h1>Form MA Applicant's Information </h1>					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">CIK</div>
							<div class="tdstyle1max01sched tdmax01col2">
								<input
									type="text"
									name="CIK"
									readonly="1">
									<xsl:attribute
										name="value">
										<xsl:value-of
										select="string(ns2:filer/ns1:filerId)" />
									</xsl:attribute>
								</input>								
							</div>	
							</div>
						<div style="clear:both"></div>
						</div>
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">CCC</div>
							<div class="tdstyle1max01sched tdmax01col2">
								<input
									type="text"
									name="CCC"
									readonly="1">
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						</div>
						
										
					<h3>Submission Contact Information</h3>
					
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Contact Person for this Filing</div>
							<div class="tdstyle1max01sched tdmax01col2">
								<div class="fakeBox">
										<xsl:value-of
										select="string(ns2:contact/ns1:name)" />																		
									<span>
										   <xsl:text>&#160;</xsl:text>
										  </span>
										  </div>							
							</div>	
							</div>
						<div style="clear:both"></div>
						</div>
						
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Contact Phone</div>
							<div class="tdstyle1max01sched tdmax01col2">
								<input
									type="text"
									name="Contact Phone"
									readonly="1">
									<xsl:attribute
										name="value">
										<xsl:value-of
										select="string(ns2:contact/ns1:phoneNumber)" />
									</xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						</div>	
						
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Contact Email Address</div>
							<div class="tdstyle1max01sched tdmax01col2">
								<div class="fakeBox">
										<xsl:value-of
										select="string(ns2:contactEmail)" />
										<span>
										   <xsl:text>&#160;</xsl:text>
										  </span>
									</div>
							</div>
						</div>
						<div style="clear:both"></div>
						</div>	
						
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Contact Email Address</div>
							<div class="tdstyle1max01sched tdmax01col2">
								<div class="fakeBox">
										<xsl:value-of
										select="string(ns2:notifications/ns1:internetNotificationAddress)" />
										<span>
										   <xsl:text>&#160;</xsl:text>
										  </span>
									</div>
							</div>
						</div>
						<div style="clear:both"></div>
						</div>	
										
					</div>
					<!-- <h3>Notification Information</h3>
					<p>Notification will automatically be sent to the Login CIK,
						Submission Contact, and Primary Issuers. Specify additional
						addresses below.</p>
					<xsl:apply-templates
						select="ns2:notifications/ns1:internetNotificationAddress" /> -->
				
			</div>
		</div>
	</xsl:template>

	<!-- <xsl:template
		match="ns2:notifications/ns1:internetNotificationAddress">
		<table>
			<tr>
				<td
					class="label">Notification Email Address</td>
					<td>
						<div class="fakeBox">
						<xsl:value-of
							select="string(.)" />
							<span>
               <xsl:text>&#160;</xsl:text>
              </span>
              </div>
              </td>
			</tr>
		</table>
	</xsl:template> -->


	<!-- Form Data Template -->
	<xsl:template
		match="m1:formData">
			<div
				class="content">
				<h2>Item 1 Identifying Information</h2>
				<div
					class="form1">
					<h3>A. Full Legal Name of the Firm</h3>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<xsl:call-template
							name="FirmInfo" />
					</div>
					<h3>B. Doing-Business-As (DBA) Name</h3>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<xsl:call-template
							name="DBAName" />
					</div>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
                        <xsl:call-template
                            name="DBAName1" />
                    </div>
                    <div class="tableStyle" style="margin-left:0; margin-right:0;">
                        <xsl:call-template
                            name="DBAName2" />
                    </div>
                    <div class="tableStyle" style="margin-left:0; margin-right:0;">
                        <xsl:call-template
                            name="DBAName3" />
                    </div>
                    <div class="tableStyle" style="margin-left:0; margin-right:0;">
                        <xsl:call-template
                            name="DBAName4" />
                    </div>
					<h3>C. (1) IRS Employer Identification Number: 
				   <!-- 
					<table
						class="formTable">
						<tr>
						<td rowspan="2" class="label"></td>
						<td>
					 -->	 
							<input
								type="text"
								name="IRSId"
								readonly="1">
								<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(m1:irsNum)" />
							</xsl:attribute>
							</input>
					<!-- 
						</td>
						</tr>
                   </table>
                   -->					
                   </h3> 
                      <div class="tableStyle" style="margin-left:0; margin-right:0;">
						<xsl:call-template
							name="IRSId" />
                       </div>
					<h3>D. Registrations</h3>
					<xsl:call-template
						name="Registrations" />
					<h3>
						E.
						<em>Principal Office and Place of Business </em>
					</h3>
					<xsl:call-template
						name="PrincipalOffice" />
					<h3>F. Website</h3>
					<xsl:call-template
						name="Website" />
					<h3>
						G. If the applicant has a
						<em>Chief Compliance Officer, </em>
						provide his or her name and contact information
					</h3>
					<xsl:call-template
						name="ChiefComplianceOfficer" />
					<h3>H. Contact Person</h3>
					<xsl:call-template
						name="ContactPerson" />
					<h3>I. Location of Books and Records</h3>
					<xsl:call-template
						name="BooksandRecords" />
					<h3>J. <em>Foreign Financial Regulatory Authorities</em></h3>
					<xsl:call-template
						name="ForeignFRA" />
					<h3>K. Business <em>Affiliates</em> of the Applicant</h3>
					<xsl:call-template
						name="BusinessAffiliates" />
				</div>
				<h1>Item 2 Form of Organization </h1>
				<div
					class="form1">
					<h3>A. Applicant's form of organization</h3>
					<xsl:call-template
						name="Item2" />
				</div>
				<h1>Item 3 Successions</h1>
				<div class="form1">
				<xsl:call-template
						name="Item3" />
				</div>
				<h1>Item 4 Information About Applicant's Business </h1>      <div class="form1">

<p><em>Note: Instruction 2 of the Specific Instructions for Certain Items in Form MA included in the General Instructions provides guidance for newly formed municipal advisors completing this Item 4.</em></p>

					<xsl:call-template
						name="Item4" />
				</div>
				
					<h1>Item 5 Other Business Activities </h1>
					<div class="form1">
						<xsl:call-template
						name="Item5" />
					</div>
					
					<h1>Item 6 Financial Industry and Other Activities of <em>Associated Persons</em></h1>  
					<div class="form1">
					<xsl:call-template
						name="Item6" />
					
					</div>
					<h1>Item 7 Participation or Interest of Applicant, or of <em>Associated Persons</em> of Applicant, in <em>Municipal Advisory Client</em> or <em>Solicitee</em> Transactions </h1>   
					
					<div class="form1">
					<xsl:call-template
						name="Item7" />
				<h1>Item 8 Owners, Officers and Other <em>Control Persons</em> </h1>  
				<div class="form1">
					<xsl:call-template
						name="Item8" />
				 </div>
				 <h1>Item 9 Disclosure Information </h1>     
				<div class="form1"> <xsl:call-template
						name="Item9" /> 
				</div>
				<h1>Item 10 Small Businesses</h1>      
				<div class="form1">
					<xsl:call-template 			name="Item10" />
    			<p style="page-break-before: always" />
				</div>
						
					</div>
				
				
			</div>
	</xsl:template>

	<!-- Item 2 templates -->
	
	<xsl:template name="Item2" >
	<p>
		<em>If this is not an initial application, and the applicant’s form of organization 
		    has changed since the applicant’s most recent Form MA, see Instruction 8 of the 
			General Instructions.</em>
	</p>
	<p>
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:Corporation) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Corporation
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:Sole_Proprietorship) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Sole Proprietorship
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:LLP) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Limited Liability Partnership (LLP)
	</p>
	<p>
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:Partnership) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Partnership
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:LLC) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Limited Liability Company (LLC)
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:LP) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Limited Partnership (LP)
	</p>
	<p>
	<xsl:choose>
		<xsl:when
			test="count(m1:formOfOrganization/m1:formOrgType/m1:formOrgTypes/m1:Other) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
		</xsl:otherwise>
	</xsl:choose>
	Other (specify)
	<div class="fakeBox">
						<xsl:value-of
			select="string(m1:formOfOrganization/m1:formOrgOtherDescription)" />
					<span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
	</div>
	</p>
	<div
                    class="form1">
                    <h3>B. Month of Applicant's Annual Fiscal Year End</h3>
                </div>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(Sole proprietors are not required to complete this subpart B.)
        </div>
        <div class="tdstyle1max01sched tdmax01col2">
        <input
            type="text"
            name="Email"
            readonly="1">
            <xsl:attribute
                name="value">
                        <xsl:value-of
                select="string(m1:monthOfFiscalYearEnd)" />
                    </xsl:attribute>
        </input>
        </div>
        </div>   
	<div style="clear:both"></div>
	 </div>
	<h3>C. State, Other US Jurisdiction, or Foreign Jurisdiction Under Which Applicant is Organized</h3>
	<p>
		<em>If the applicant is a corporation or limited liability company,
			indicate the state or jurisdiction where the applicant is
			incorporated. If the applicant is a partnership, indicate the name of
			the state or jurisdiction under the laws of which the partnership was
			formed. If applicant is a sole proprietor, indicate the state or
			jurisdiction in which applicant resides. </em>
	</p>
	<p>
		<em>If this is not an initial application for registration, and the
			applicant's information has changed since the applicant's most recent
			Form MA, see General Instruction 8.</em>
	</p>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Enter the full name of the U.S. jurisdiction, or the full
				name, in English, of the foreign jurisdiction:</div>
			<div class="tdstyle1max01sched tdmax01col2">
				<input
					type="text"
					name="orgJur"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:organizedJurisdiction/ns1:stateOrCountry)" />
				</xsl:attribute>
				</input>
			</div>
		</div>
		<div style="clear:both"></div>
	</div>
	<br />
	<h3>D. 
	Date of Organization:
			
			<input
				type="text"
				name="Email"
				readonly="1">
				<xsl:attribute
					name="value">
							<xsl:value-of
					select="string(m1:dateOfOrganization)" />
						</xsl:attribute>
			</input>
	</h3>
    <br />
	<h3>E. Public Reporting Company</h3>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(1)
				Is the applicant a public reporting company under Sections 12 or
				15(d) of the Securities <em>Exchange Act</em> of 1934?
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
					<xsl:choose>
                       <xsl:when test="count(m1:isPrcApplicant) &gt; 0">
	                       <xsl:choose>
	                            <xsl:when
	                                test="string(m1:controls/m1:isSection12Or15ReportingCompany) = 'Y'">
	                                <img src="Images/radio-checked.jpg" alt="radio button checked" />Yes
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
	                            </xsl:when>
	                        </xsl:choose>
	                        <xsl:choose>
	                            <xsl:when
	                                test="string(m1:controls/m1:isSection12Or15ReportingCompany) = 'N'">
	                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
									<img src="Images/radio-checked.jpg" alt="radio button checked" />No
	                            </xsl:when>
	                        </xsl:choose>
                       </xsl:when>
                       <xsl:otherwise>
                           <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
                           <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No                  
                       </xsl:otherwise>
                    </xsl:choose>
			</div>
		</div>
		<div style="clear:both"></div>
		</div>
		<xsl:choose>
			<xsl:when test="string(m1:controls/m1:isSection12Or15ReportingCompany) = 'Y'">
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
								<div class="tableRow">
									<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(2)
						If &quot;Yes,&quot; provide applicant's CIK number
						<p>
							<em>(A CIK, or Central Index Key number, is assigned by the SEC to
								every public reporting company.) </em> 
						</p>
					</div>
					<div class="tdstyle1max01sched tdmax01col2">
						<input
						type="text"
						name="prcCIK"
						readonly="1">
						<xsl:attribute
							name="value">
									<xsl:value-of
							select="string(m1:prcCIK)" />
								</xsl:attribute>
					</input>
					</div>
				</div>
				<div style="clear:both"></div>
				</div>
		
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
					<div class="tableRow">
						<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Company Name</div>
				    	<div class="tdstyle1max01sched tdmax01col2">
						    <div class="fakeBox">
				            	<xsl:value-of
				                        select="string(m1:firmName)" />
				                 <span>
				                 	<xsl:text>&#160;</xsl:text>
				                 </span>
				            </div>
				  		</div>
					</div>
					<div style="clear:both"></div>
				</div>
			</xsl:when>
		</xsl:choose>

</xsl:template>



	<!-- Item 1 templates -->

	<xsl:template
		name="FirmInfo">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
					<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(1) Firm Name:</div>
						<div class="tdstyle1max01sched tdmax01col2">				
							<div class="fakeBox">
								<xsl:value-of
									select="string(m1:firmName)" />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
							</div>					
						</div>	
					</div>
				<div style="clear:both"></div>
				</div>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
					<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">
						Organization <em>CRD</em> No.,if any:
					</div>
						<div class="tdstyle1max01sched tdmax01col2">	
				<input
					type="text"
					name="CrdNo"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(m1:firmCrdNumber)" />
				</xsl:attribute>
				</input>
			</div>	
					</div>
				<div style="clear:both"></div>
				</div>
				
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
					<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> (2)	Sole Proprietor:  If the applicant is a sole proprietor, check here, and provide full last name, first name, middle name, and suffix, if any: </div>
			<div class="tdstyle1max01sched tdmax01col2">
				<xsl:choose>
					<xsl:when
						test="m1:controls/m1:isSolePropietor = 'Y' or m1:controls/m1:isSolePropietor  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
				
					</xsl:when>
					<xsl:when
						test="m1:controls/m1:isSolePropietor = 'N' or m1:controls/m1:isSolePropietor  = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						No
				
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
					</xsl:otherwise>
				</xsl:choose>
			</div>
					</div>
				<div style="clear:both"></div>
				</div>
		<xsl:apply-templates
			select="m1:soleProprietor" />
			
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
					<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> (3) Name Change: If full legal name has changed since the <em>municipal advisor</em>'s most recent Form MA, check here and provide the previous full legal name.</div>
			<div class="tdstyle1max01sched tdmax01col2">
				<xsl:choose>
					<xsl:when
						test="m1:controls/m1:hasNameChange = 'Y' or m1:controls/m1:hasNameChange  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
				
					</xsl:when>
					<xsl:when
						test="m1:controls/m1:hasNameChange = 'N' or m1:controls/m1:hasNameChange  = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						No
				
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
					</xsl:otherwise>
				</xsl:choose>
			</div>
			</div> 
			<div style="clear:both"></div>
		</div>
		
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
				<div class="tableRow">
					<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(specify)</div>
<div class="tdstyle1max01sched tdmax01col2">	
		<xsl:apply-templates
			select="m1:previousLegalName" />
		 </div>
        </div>
       <div style="clear:both"></div>
	   </div>
	</xsl:template>
    
	<!-- Sole Proprietor Template -->
	<xsl:template
		match="m1:soleProprietor">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">Enter all the letters of each name and do not use initials or
					other abbreviations. 
				If no middle name, enter NMN on that line.
			</div>
		</div>
		</div>
		<div style="clear:both"></div>
				
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Last Name</div>
							<div class="tdstyle1max01sched tdmax01col2">
							  <div class="fakeBox">
                <xsl:value-of
                    select="string(./m1:name/ns2:lastName)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
							
															
							</div>	
							</div>
						<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">First Name</div>
							<div class="tdstyle1max01sched tdmax01col2">
					
			
                <div class="fakeBox">
                    <xsl:value-of
                        select="string(./m1:name/ns2:firstName)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div> 
				
           </div>	
							</div>
						<div style="clear:both"></div>
		</div>
		
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Middle Name</div>
							<div class="tdstyle1max01sched tdmax01col2">
			
                <div class="fakeBox">
                    <xsl:value-of
                        select="string(./m1:name/ns2:middleName)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
             
            </div>
			</div>
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Suffix</div>
							<div class="tdstyle1max01sched tdmax01col2">
				<input
					type="text"
					name="ProprietorSuffix"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(./m1:name/ns2:suffix)" />
				</xsl:attribute>
				</input>
			</div>
			</div>
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">
				<p>Individual <em>CRD</em> No., if any: </p>
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
				<input
					type="text"
					name="ProprietorCrdNo"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(./m1:crdNumber)" />
				</xsl:attribute>
				</input>
			</div>
		</div>
		<div style="clear:both"></div>
		</div>
		
	</xsl:template>
   
	<!-- Previous Legal Name Template -->
	<xsl:template
		match="m1:previousLegalName">		
		
                <div class="fakeBox">                    
                    <xsl:value-of
                        select="string(.)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
           
	</xsl:template>


	<!-- DBAName Section Template -->

	<xsl:template
		name="DBAName">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(1)  If the name under which <em>municipal advisor-related</em> business is primarily conducted is different from Item 1-A., check here and provide the DBA name.</div>
			<div class="tdstyle1max01sched tdmax01col2">
				<xsl:choose>
					<xsl:when
						test="m1:controls/m1:hasDBAName = 'Y' or m1:controls/m1:hasDBAName  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
				
					</xsl:when>
					<xsl:when
						test="m1:controls/m1:hasDBAName = 'N' or m1:controls/m1:hasDBAName  = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						No
				
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</div>
		<div style="clear:both"></div>
		</div>
	</xsl:template>
	<xsl:template name="DBAName1">
		<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
			<xsl:apply-templates
				select="m1:dbaName" />
		</div>
	</xsl:template>
	<xsl:template name="DBAName2">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> (2) Previous DBA Name: If name under which <em>municipal advisor-related</em> business is primarily conducted has changed since the <em>municipal advisor</em>'s most recent Form MA, check here and provide the previous name	under which the <em>municipal advisor-related</em> business was primarily conducted.</div>
			<div class="tdstyle1max01sched tdmax01col2">
				<xsl:choose>
					<xsl:when
						test="m1:controls/m1:hasPreviousDBAName = 'Y' or m1:controls/m1:hasPreviousDBAName  = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
				
					</xsl:when>
					<xsl:when
						test="m1:controls/m1:hasPreviousDBAName = 'N' or m1:controls/m1:hasPreviousDBAName  = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
						No
				
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						No
					</xsl:otherwise>
				</xsl:choose>
			</div>
			 
		</div>
		<div style="clear:both"></div>
		</div>
	</xsl:template>
	<xsl:template name="DBAName3">
		<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
			<xsl:apply-templates
					select="m1:previousDbaName" />
		</div>
	</xsl:template>
	<xsl:template name="DBAName4">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(3) Additional Names: </div>
			<div class="tdstyle1max01sched tdmax01col2">
		</div>
		</div>
		<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(a) Is <em>municipal advisor-related</em> business conducted under any
					additional names? 
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:hasAdditionalDBANames = 'Y' or m1:controls/m1:hasAdditionalDBANames  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:hasAdditionalDBANames = 'N' or m1:controls/m1:hasAdditionalDBANames  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
				</div>
			</div>
			<div style="clear:both"></div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">(b)  List any additional names on <strong><u>Section 1-B of Schedule D</u></strong>.
				
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
		</div>
		</div>
		<div style="clear:both"></div>
		</div>
	</xsl:template>


	<!-- DBA name Template -->

	<xsl:template
		match="m1:dbaName">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">DBA name</div>		
							<div class="tdstyle1max01sched tdmax01col2">
		
		<div class="fakeBox">
		      <xsl:value-of
		          select="string(.)" />
		             <span>
		               <xsl:text>&#160;</xsl:text>
		              </span>
		  </div>
		  </div>
		  </div>
		  <div style="clear:both"></div>
		  </div>
	</xsl:template>


	<!-- Previous DBA Name Template -->
	<xsl:template
		match="m1:previousDbaName">		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Previous DBA Name
		</div>
		<div class="tdstyle1max01sched tdmax01col2">
        <div class="fakeBox">
              <xsl:value-of
                  select="string(.)" />
                     <span>
                       <xsl:text>&#160;</xsl:text>
                      </span>
          </div>
          </div></div>
		  <div style="clear:both"></div>
		  </div>
	</xsl:template>


	<!-- IRS ID Section Template -->

	<!-- <xsl:template -->
		<!-- name="IRSId"> -->
		
					<!-- <div class="tableStyle" style="margin-left:0; margin-right:0;">	 -->
						<!-- <div class="tableRow"> -->
							<!-- <div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> (2) If the applicant (such as a sole proprietor), has no employer identification number, provide the applicant’s social security number:	 -->
				<!-- </div> -->
				<!-- <div class="tdstyle1max01sched tdmax01col2">								 -->
			
				<!-- <input -->
					<!-- type="text" -->
					<!-- name="IRSId" -->
					<!-- readonly="1"> -->
					<!-- <xsl:attribute -->
						<!-- name="value"> -->
					<!-- <xsl:value-of -->
						<!-- select="string(m1:ssNum)" /> -->
				<!-- </xsl:attribute> -->
				<!-- </input>				 -->
			    <!-- </div> -->
			<!-- </div> -->
			<!-- <div style="clear:both"></div> -->
			<!-- </div> -->
			
			<!-- <div class="tableStyle" style="margin-left:0; margin-right:0;">	 -->
						<!-- <div class="tableRow"> -->
							<!-- <div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> The Social Security Number will not be included in publicly available versions of this registration form.</div> -->
							
			<!-- <div class="tdstyle1max01sched tdmax01col2">&#160;</div> -->
		 <!-- </div> -->
		
		 <!-- <div style="clear:both"></div> -->
					 <!-- </div> -->
			
					
	<!-- </xsl:template> -->


	<!-- Registrations Section Template -->

	<xsl:template
		name="Registrations">
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
					(1) <b>Form MA-T Registration:</b> Was the applicant previously registered
					on Form MA-T as a <em>municipal advisor</em>?
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:hasMATReg = 'Y' or m1:controls/m1:hasMATReg  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:hasMATReg = 'N' or m1:controls/m1:hasMATReg  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
				</div>
			</div>
			<div style="clear:both"></div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
					<p>If &quot;Yes&quot;, enter the <em>SEC</em> File No. MA-T:</p>
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<input
						type="text"
						name="maTFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:maTregistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>
				</div>
				<div style="clear:both"></div>
				</div>			
			
					(2) <b>Other Registrations:</b> Is the applicant registered as
					or with
					any of the following?
					<p>
						Check all that apply. For each registration box you checked, provide the requested file
						number(s).
						<em> An applicant firm should NOT provide the organization <em>CRD</em> number, or other specified number, of any of its organizational affiliates, or the individual <em>CRD</em> number of its officers, <em>employees</em>, or natural <em>person</em> affiliates.</em>
					</p>
				
						<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:maRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					<em>Municipal Advisor </em>
				</div>
				
					<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						<em>SEC</em>
						File No.:
					</div>
					<input
						type="text"
						name="maFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:maRegistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>
				</div>
				<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:msdRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Municipal Securities Dealer
				</div>
				<div class="tdStyle1 tdmax01col2 ">
					<div
						class="subLabel">
						<em>SEC</em>
						File No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:msdRegistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:bdRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Broker-Dealer   
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						<em>SEC</em>
						File No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:bdRegistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>
				</div>
				<div style="clear:both"></div>
				</div>
						
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					 
				</div>						
				
				<div class="tdstyle1max01sched tdmax01col2">
				<div
						class="subLabel">
						Organization
						<em>CRD</em>
						No.:
					</div>
					<input
						type="text"
						name="msdCRDNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:bdRegistration/ns2:crdNumber)" />
						</xsl:attribute>
					</input>
				</div>
				
				</div>
			<div style="clear:both"></div>
			</div>
		
						
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					<em>Investment Adviser</em>
				</div>
				</div>	
				<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<span
						style="margin-left:15px;">
						<xsl:choose>
							<xsl:when
								test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:secRegistration) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						<em>SEC</em>
						-Registered
					</span>
				</div>
			<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						<em>SEC</em>
						File No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:secRegistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					 
				</div>	
			
			<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						Organization
						<em>CRD</em>
						No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:secRegistration/ns2:crdNumber)" />
						</xsl:attribute>
					</input>

				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
				<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<span
						style="margin-left:15px;">
						<xsl:choose>
							<xsl:when
								test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:exemptAdvisor) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						Exempt Reporting Adviser
					</span>
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						<em>SEC</em>
						File No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:exemptAdvisor/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					 
				</div>	
			
			<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						Organization
						<em>CRD</em>
						No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:exemptAdvisor/ns2:crdNumber)" />
						</xsl:attribute>
					</input>

				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			
			
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<span
						style="margin-left:15px;">
						<xsl:choose>
							<xsl:when
								test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration) &gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						Registered in US State or Other US Jurisdiction 
					</span>
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						Organization <em>CRD</em>
						No.:
					</div>
					<input
						type="text"
						name="msdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration/ns2:crdNumber)" />
						</xsl:attribute>
					</input>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			</div>
		<p><u><em>Investment Adviser</em> Registration in a US State or Other US
			Jurisdiction</u>: If predecessor <em>municipal advisory firm</em> is registered in a US state or other
			jurisdiction as an <em>investment adviser</em>, enter the organization <em>CRD</em> Number above. In the table below,
			select each US state or jurisdiction in which the predecessor <em>municipal advisory firm</em> is so registered.</p>
		<p>
			<strong>Check All That Apply:</strong>
		</p>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<strong>
						<div
							class="subLabel">US State or Jurisdiction</div>
						(Code)
					</strong>
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<strong>
						<div
							class="subLabel">US State or Jurisdiction</div>
						(Code)
					</strong>
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
	  <xsl:choose>
 	   						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AL']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
		</xsl:choose>
						Alabama
					</div>
					(AL)
				</div>
				<div class="tdstyle1max01sched" style="width:50%; float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Montana
					</div>
					(MT)
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AK']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Alaska
					</div>
					(AK)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NE']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Nebraska
					</div>
					(NE)
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AZ']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Arizona
					</div>
					(AZ)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NV']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Nevada
					</div>
					(NV)
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='AR']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Arkansas
					</div>
					(AR)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NH']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New Hampshire
					</div>
					(NH)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='CA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						California
					</div>
					(CA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NJ']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New Jersey
					</div>
					(NJ)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='CO']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Colorado
					</div>
					(CO)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NM']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New Mexico
					</div>
					(NM)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='CT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Connecticut
					</div>
					(CT)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NY']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						New York
					</div>
					(NY)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='DE']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Delaware
					</div>
					(DE)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='NC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						North Carolina
					</div>
					(NC)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='DC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						District of Columbia
					</div>
					(DC)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='ND']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						North Dakota
					</div>
					(ND)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='FL']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Florida
					</div>
					(FL)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='OH']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Ohio
					</div>
					(OH)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='GA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Georgia
					</div>
					(GA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='OK']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Oklahoma
					</div>
					(OK)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='GU']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Guam
					</div>
					(GU)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='OR']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Oregon
					</div>
					(OR)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='HI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Hawaii
					</div>
					(HI)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='PA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Pennsylvania
					</div>
					(PA)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='ID']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Idaho
					</div>
					(ID)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='PR']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Puerto Rico
					</div>
					(PR)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='IL']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Illinois
					</div>
					(IL)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='RI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Rhode Island
					</div>
					(RI)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='IN']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Indiana
					</div>
					(IN)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='SC']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						South Carolina
					</div>
					(SC)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='IA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Iowa
					</div>
					(IA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='SD']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						South Dakota
					</div>
					(SD)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='KS']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Kansas
					</div>
					(KS)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='TN']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Tennessee
					</div>
					(TN)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='KY']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Kentucky
					</div>
					(KY)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='TX']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Texas
					</div>
					(TX)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='LA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Louisiana
					</div>
					(LA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='UT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Utah
					</div>
					(UT)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='ME']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Maine
					</div>
					(ME)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='VT']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Vermont
					</div>
					(VT)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MD']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Maryland
					</div>
					(MD)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='VI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Virgin Islands
					</div>
					(VI)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Massachusetts
					</div>
					(MA)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='VA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Virginia
					</div>
					(VA)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Michigan
					</div>
					(MI)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
			<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='WA']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Washington
					</div>
					(WA)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MN']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Minnesota
					</div>
					(MN)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='WI']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Wisconsin
					</div>
					(WI)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MS']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Mississippi
					</div>
					(MS)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='WV']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						West Virginia
					</div>
					(WV)
				</div>
			</div>
			<div class="trstylemax01sched" style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="tdstyle1max01sched" style="width:50%;">
					<div
						class="subLabel">
				<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:iaRegistration/ns2:nonExempt/ns2:stateRegistration[ns2:state='MO']) &gt; 0 ">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
								  
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
						
			</xsl:choose>
						Missouri
					</div>
					(MO)
				</div>
				<div class="tdstyle1max01sched" style="width:50%;float:right;margin-top:-30px">
				</div>
			</div>
		</div>
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Government Securities Broker-Dealer 
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">
						<em>SEC</em>
						File No.:
					</div>
					
					<input
						type="text"
						name="gsbdFileNumber"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				</div>					
					
					
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
				<div class="tableRow">
					<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">					 
					</div>	
					<div class="tdstyle1max01sched tdmax01col2">
					<div
						class="subLabel">Bank Identifier:</div>
						
					<div class="fakeBox" style="margin-left:205px;">
					      <xsl:value-of
					          select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:gsbdRegistration/ns2:bankId)" />
					             <span>
					               <xsl:text>&#160;</xsl:text>
					              </span>
					</div>
					</div>
				</div>
				<div style="clear:both"></div>
			</div>
			
			
					<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					Other
					<em>SEC</em>
					Registration <br></br>(Specify):
					
					</div>
					<div class="tdstyle1max01sched tdmax01col2">	
                    <div class="fakeBox">
                          <xsl:value-of
                              select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:description)" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                  </span>
                    </div>
					</div>
					
			</div>
			<div style="clear:both"></div>
			</div>
			
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;border-bottom:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					 
				</div>	
							<div class="tdstyle1max01sched tdmax01col2">	
										<div class="subLabel">
						<em>SEC</em>
						File No. (if any):
					</div>
					
					<input
						type="text"
						name="otherRegFileNo"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:fileNumber)" />
						</xsl:attribute>
					</input>
				
					
			</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">					 
				</div>	
				<div class="tdstyle1max01sched tdmax01col2">	
					<div
						class="subLabel">EDGAR CIK (if any):</div>
					
					<input
						type="text"
						name="otherRegCik"
						readonly="1">
						<xsl:attribute
							name="value">
							<xsl:value-of
							select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:otherRegistration/ns2:cik)" />
						</xsl:attribute>
					</input>
				</div>
						
						</div>
			
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-bottom:none">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">
					<xsl:choose>
						<xsl:when
							test="count(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration) &gt; 0">
							<img
								src="Images/box-checked.jpg" alt="checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img
								src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
						</xsl:otherwise>
					</xsl:choose>
					
					Another federal or state regulator(Specify):
					</div>
					<div class="tdstyle1max01sched tdmax01col2">	
                    <div class="fakeBox">
                          <xsl:value-of
                              select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration/ns2:description)" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                 </span>
                     </div> 
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;border-top:none;">	
						<div class="tableRow">
				<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="padding-left:5px;">					 
				</div>
									<div class="tdstyle1max01sched tdmax01col2">	
					<div
						class="subLabel">Registration No. (if any):</div>
						
										
                    <div class="fakeBox" style="margin-left:205px;">
                          <xsl:value-of
                              select="string(m1:registrations/m1:baseRegistrations/m1:baseRegistrations/ns2:anotherRegistration/ns2:registrationId)" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                  </span>
                      </div>
					</div>                    
				</div>			
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins"><b>(3) Additional Registrations:</b></div>
			
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(a) Does the applicant have any additional registrations that are not listed in subsection (2)?
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:additionalRegs = 'Y' or m1:controls/m1:additionalRegs  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:additionalRegs = 'N' or m1:controls/m1:additionalRegs  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(b)
						List any such additional registrations on<b><u> Section 1-D of Schedule D</u></b>.					
				</div>			
			</div>
			<div style="clear:both"></div>
		</div>
	</xsl:template>

	<xsl:template
		name="PrincipalOffice">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins"><b>(1) Address: <em>Do not use a P.O. Box.</em></b>
				</div>
				
				<div class="tdstyle1max01sched tdmax01col2">
				</div>
			</div>
			<div style="clear:both"></div>
			<xsl:apply-templates
				select="m1:principalOfficeAddress/m1:addressInfo" />	
				

			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins"><b>(2) Additional Offices:</b></div>
							
				<div class="tdstyle1max01sched tdmax01col2"></div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(a) Is <em>municipal advisor-related</em> business conducted at any
						office(s) other than applicant's principal office and place of
						business listed above?
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:additionalOffices = 'Y' or m1:controls/m1:additionalOffices  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:additionalOffices = 'N' or m1:controls/m1:additionalOffices  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			
				<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(b)
						If &quot;Yes,&quot; list the five largest such additional offices
						on
						<b><u>Section 1-E of Schedule D</u></b>.					
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
			</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
					<b>(3) Mailing Address:</b>
						Is the mailing address different from
						principal office and place of business address in Item 1-E(1)? 
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:mailingAddressDifferent = 'Y' or m1:mailingAddressDifferent  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:mailingAddressDifferent = 'N' or m1:mailingAddressDifferent  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">If &quot;Yes,&quot; complete this item.</div>
			</div>
			<div style="clear:both"></div>
			</div>
			<xsl:apply-templates
				select="m1:mailingAddress" />

		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
				Is this address a private residence? A private residential address will not be included in publicly available versions of this registration form.
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:mailingAddress/ns2:residentialAddressFlag = 'Y' or m1:mailingAddress/ns2:residentialAddressFlag  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:mailingAddress/ns2:residentialAddressFlag = 'N' or m1:mailingAddress/ns2:residentialAddressFlag  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>  
		
					</div>					
		</div>
		<div style="clear:both"></div>
		</div>
		</div>
	</xsl:template>

	<xsl:template
		match="m1:principalOfficeAddress/m1:addressInfo">
		<xsl:call-template
			name="addressInfo" />
			
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">
					Telephone Number at this location:
				</div>
				<div class="tdstyle1max01sched tdmax01col2">                 
					<div class="fakeBox">
					      <xsl:value-of
					          select="string(../m1:phoneNumber)" />
					             <span>
					               <xsl:text>&#160;</xsl:text>
					              </span>
					  </div>
                </div>
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">
					Fax Number (if any) at this location: 
				</div>
				<div class="tdstyle1max01sched tdmax01col2">                    
					<div class="fakeBox">
					      <xsl:value-of
					          select="string(../m1:faxNumber)" />
					             <span>
					               <xsl:text>&#160;</xsl:text>
					              </span>
					  </div>
                </div>
			</div>
		<div style="clear:both"></div>
		</div>
		
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins"><p>For non-US telephone and fax numbers, include country code with area code and local number.</p>
				</div>
				<div class="tdstyle1max01sched tdmax01col2"> </div>
			</div>	
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">
					Is this address a private residence? A private residential address will not be included in publicly available versions of this registration form.
				</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<span
						class="yesNo">
						<xsl:choose>
                         <xsl:when
                              test="./ns2:residentialAddressFlag = 'Y' or ./ns2:residentialAddressFlag  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="./ns2:residentialAddressFlag = 'N' or ./ns2:residentialAddressFlag  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>  
					</span>		
					</div>					
			</div>
		<div style="clear:both"></div>			
		</div>
	</xsl:template>


	<xsl:template
		match="m1:mailingAddress">
		<xsl:call-template
			name="addressInfo" />
	</xsl:template>


	<xsl:template
		name="addressInfo">
		
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Street Address 1:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./ns2:address/ns1:street1)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>				
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
           <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Street Address 2:</div>
               <div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./ns2:address/ns1:street2)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>
                </div>
            </div>	
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">City:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./ns2:address/ns1:city)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">State/Country:</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div class="fakeBox"> 
	                	<span >
	                    	<xsl:call-template name="stateDescription">
	                        	<xsl:with-param name="stateCode" select="string(./ns2:address/ns1:stateOrCountry)" />
	                        </xsl:call-template>
	                    </span>
	                    <span>
	                    	<xsl:text>&#160;</xsl:text>
	                    </span>
	                </div>				
				</div>				
			</div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Postal Code:</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div class="fakeBox">
                      <xsl:value-of
                          select="string(./ns2:address/ns1:zipCode)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>					
				</div>
			</div>	
			<div style="clear:both"></div>	
			 </div>	
	</xsl:template>

	<xsl:template
		name="Website">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">(1) Provide the address of the applicant's principal website (if any): 
			  </div>
			           
            </div>
			<div style="clear:both"></div>	
			 </div>
			 
            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(specify)
							</div>
			    
              <div class="tdstyle1max01sched tdmax01col2">
				<div class="fakeBox">
				      <xsl:value-of
				          select="string(m1:primaryWebAddress)" />
				             <span>
				               <xsl:text>&#160;</xsl:text>
				              </span>
				  </div>
               </div>             
            </div>
			<div style="clear:both"></div>	
			 </div>
			
<!-- //////////////// -->
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(2) Does the applicant have any additional websites? 
							</div>
				<div class="tdstyle1max01sched tdmax01col2">
						<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:hasAdditionalWebsites = 'Y' or m1:controls/m1:hasAdditionalWebsites  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:hasAdditionalWebsites = 'N' or m1:controls/m1:hasAdditionalWebsites  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>	
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(3) Total number of additional websites
                </div>
            </div>
			<div style="clear:both"></div>	
			</div>
			
            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(specify)
							</div>
                 <div class="tdstyle1max01sched tdmax01col2">
                <!--<div class="fakeBox">-->
                    <input
                    type="text"
                    name="additionalSitesCount"
                    readonly="1">
                    <xsl:attribute
                        name="value">
                            <xsl:value-of
                        select="string(m1:numberOfAdditionalWebSites)" />
                  </xsl:attribute>
                </input>
               <!--</div>-->
			   </div>
            </div>
			<div style="clear:both"></div>	
			</div>
			
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(4)  List all additional website addresses on <b><u>Section 1-F of Schedule D</u></b>.
				</div>
				
			</div>
			<div style="clear:both"></div>	
			</div>
	</xsl:template>

	<!-- Chief Compliance Officer -->
	<xsl:template
		name="ChiefComplianceOfficer">
		<p>Please note that the applicant must provide name and contact
			information for either a <em>Chief Compliance Officer</em> in Question 1.G.,
			or another contact <em>person</em> in Question 1.H below. Both may be
			provided.</p>
		<xsl:apply-templates
			select="m1:cco" />
	</xsl:template>


	<xsl:template
		match="m1:cco">
		<xsl:call-template
			name="m1:personType" />
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1"> 
                    <p> For non-US telephone and fax numbers, include country code
                        with area code and local number.</p>
                </div>
				 <div class="tdstyle1max01sched tdmax01col2"></div>
            </div>
			<div style="clear:both"></div>
			</div>			
			
            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> 
                   Telephone Number: 
                </div>
				
                <div class="tdstyle1max01sched tdmax01col2">                
					<div class="fakeBox">
					      <xsl:value-of
					          select="string(./m1:phoneNumber)" />
					             <span>
					               <xsl:text>&#160;</xsl:text>
					              </span>
					  </div>
                </div>  
					</div> 
			<div style="clear:both"></div>	
			</div>
			
             <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> Fax Number:</div>
                <div class="tdstyle1max01sched tdmax01col2">   
                    <div class="fakeBox">
                          <xsl:value-of
                              select="string(./m1:faxNumber)" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                  </span>
                      </div>
                </div>
            </div>    
			<div style="clear:both"></div>	
			</div>   			
            
          <xsl:apply-templates
						select="m1:address/ns2:residentialAddressFlag" />
              <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> E-mail Address of <em>Chief Compliance Officer:</em></div>
                <div class="tdstyle1max01sched tdmax01col2">  
                    <p>
                    <div class="fakeBox">
                          <xsl:value-of
                              select="string(./m1:email)" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                  </span>
                      </div>
                      </p>
                </div>
            </div>   
				<div style="clear:both"></div>	
				 </div>
            
	</xsl:template>

	<!-- Contact Person Section -->
	<xsl:template
		name="ContactPerson">
		<p>
			If a
			<em>person</em>
			other than the
			<em>Chief Compliance Officer</em>
			is authorized to receive information and respond to questions about
			this form, provide the name and contact information for that
			<em>person</em>
			:
		</p>
		<p>Please note that the applicant must provide name and contact
			information for either a <em>Chief Compliance Officer</em> in Question 1.G.,
			or another contact <em>person</em> in Question 1.H below. Both may be
			provided.</p>
		<xsl:apply-templates
			select="m1:contactPerson" />
	</xsl:template>

	<xsl:template
		match="m1:contactPerson">
		<xsl:call-template
			name="m1:personType" />
			 <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1"> 
                    <p>For non-US telephone and fax numbers, include country code
                        with area code and local number.</p>
                </div>
            </div>
			<div style="clear:both"></div>	
			 </div>
			 
          <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> 
                    Telephone Number: 
                </div>
               <div class="tdstyle1max01sched tdmax01col2">
					<div class="fakeBox">
					      <xsl:value-of
					          select="./m1:phoneNumber" />
					             <span>
					               <xsl:text>&#160;</xsl:text>
					              </span>
					  </div>
                </div>
            </div>
			<div style="clear:both"></div>
			 </div>
			 
            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Fax Number:</div>
                <div class="tdstyle1max01sched tdmax01col2">
                    <div class="fakeBox">
                          <xsl:value-of
                              select="./m1:faxNumber" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                  </span>
                      </div>
                </div>
            </div>
			<div style="clear:both"></div>	
			</div>
           <xsl:apply-templates
						select="m1:address/ns2:residentialAddressFlag" />
            
              <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> E-mail Address of Contact <em>Person</em>:</div>
                <div class="tdstyle1max01sched tdmax01col2">
                    <p>
                    <div class="fakeBox">
                          <xsl:value-of
                              select="./m1:email" />
                                 <span>
                                   <xsl:text>&#160;</xsl:text>
                                  </span>
                      </div>
                      </p>
                </div>
            </div>
			<div style="clear:both"></div>	
			</div>
	</xsl:template>

	<xsl:template
		name="m1:personType">
 
            <p>Enter all the letters of each name and not initials or other abbreviations.  If no middle name, enter NMN on that line.</p>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> Last Name:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:name/ns2:lastName)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">First Name:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:name/ns2:firstName)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>					
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Middle Name:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:name/ns2:middleName)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
<!--  		<tr>
				<td
					class="label">Suffix</td>
				<td>
					<input
						type="text"
						name="ContactSuffix"
						readonly="1">
						<xsl:attribute
							name="value">
						<xsl:value-of
							select="string(./m1:name/ns2:suffix)" />
						</xsl:attribute>
					</input>
				</td>
			</tr>
--> 
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="height:65px;">Other title(s), if any:</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<xsl:apply-templates
						select="./m1:titles/m1:title" />
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Street Address 1:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:address/ns2:address/ns1:street1)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>				
				</div>
			</div>
			<div style="clear:both"></div>
			</div>
			
           <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Street Address 2:</div>
                <div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:address/ns2:address/ns1:street2)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>
                </div>
            </div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">City:</div>
				<div class="tdstyle1max01sched tdmax01col2">
                <div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:address/ns2:address/ns1:city)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">State/Country:</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div class="fakeBox"> 
	                	<span >
	                    	<xsl:call-template name="stateDescription">
	                        	<xsl:with-param name="stateCode" select="string(./m1:address/ns2:address/ns1:stateOrCountry)" />
	                        </xsl:call-template>
	                    </span>
	                    <span>
	                    	<xsl:text>&#160;</xsl:text>
	                    </span>
	                </div>				
				</div>				
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">Postal Code:</div>
				<div class="tdstyle1max01sched tdmax01col2">
					<div class="fakeBox">
                      <xsl:value-of
                          select="string(./m1:address/ns2:address/ns1:zipCode)" />
                             <span>
                               <xsl:text>&#160;</xsl:text>
                              </span>
                  </div>					
				</div>
			</div>
			<div style="clear:both"></div>	
			</div>
			<!-- - 
			<tr>
				<td
					class="label">E-mail address of <em>Chief Compliance Officer</em></td>
				<td>
					<input
						type="text"
						name="ContactEmail"
						readonly="1">
						<xsl:attribute
							name="value">
						<xsl:value-of
							select="string(./m1:email)" />
						</xsl:attribute>
					</input>
				</td>
			</tr>
			<tr>
				<td
					class="label">Individual <em>CRD</em> Number (if any)
              </td>
				<td>
					<input
						type="text"
						name="ContactCRDNum"
						readonly="1">
						<xsl:attribute
							name="value">
						<xsl:value-of
							select="string(./m1:crdNumber)" />
						</xsl:attribute>
					</input>
				</td>
			</tr>
			-->
		
	</xsl:template>


	<xsl:template
		match="m1:titles/m1:title">
		<input
			type="text"
			name="ContactOtherTitles"
			readonly="1">
			<xsl:attribute
				name="value">
			<xsl:value-of
				select="string(.)" />
			</xsl:attribute>
		</input>
		<br />
		<br />
	</xsl:template>


	<!-- Books and Records Section -->
	<xsl:template
		name="BooksandRecords">
					<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(1) Does the applicant maintain, or intend to maintain, some
					or all of the books and records required to be kept under <em>MSRB</em>
					rules and <em>SEC</em> rules at a location other than the <em>principal office
					and place of business</em> address listed in Item 1-E?</div>
					<div class="tdstyle1max01sched tdmax01col2">		
					<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:hasBooksRecords = 'Y' or m1:controls/m1:hasBooksRecords  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:hasBooksRecords = 'N' or m1:controls/m1:hasBooksRecords  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                          </xsl:choose>
					</div>
				</div>
			
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(2) If &quot;Yes,&quot; list all such locations in 
					<strong><U>Section 1-I of Schedule D</U>.</strong>
				</div>
			</div>
			<div style="clear:both"></div>
			</div>			
		
	</xsl:template>

	<!-- Foreign Financial Regulatory Authority -->
	<xsl:template
		name="ForeignFRA">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(1) Is the applicant registered with a <em>foreign financial
					regulatory authority</em>? Answer &quot;no&quot; even if <em>affiliated</em> with
					a business that is registered with a <em>foreign financial regulatory
					authority</em>. </div>
				<div class="tdstyle1max01sched tdmax01col2">
					<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:isRegisteredFFRA = 'Y' or m1:controls/m1:isRegisteredFFRA  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:isRegisteredFFRA = 'N' or m1:controls/m1:isRegisteredFFRA  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                       </xsl:choose>					
				</div>
				
			</div>
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(2)
					If &quot;Yes,&quot; list all such registrations in
					<strong><u>Section 1-J of Schedule D</u></strong>.
				</div>
			</div>
			<div style="clear:both"></div>	
		</div>
	</xsl:template>


	<!-- Business Affiliates Section -->
	<xsl:template
		name="BusinessAffiliates">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(1) Is the applicant <em>affiliated</em> with any other domestic or
					foreign business entities?</div>
				
					<div class="tdstyle1max01sched tdmax01col2">
					<xsl:choose>
                         <xsl:when
                              test="m1:controls/m1:isAffiliatedOtherBus = 'Y' or m1:controls/m1:isAffiliatedOtherBus  = 'y'">
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                          
                            </xsl:when>
                            <xsl:when
                                test="m1:controls/m1:isAffiliatedOtherBus = 'N' or m1:controls/m1:isAffiliatedOtherBus  = 'n'">
                                    <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                                    <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                          
                            </xsl:when>
                            <xsl:otherwise>
                                <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
               </xsl:choose>					
				</div>
				</div>			
			<div style="clear:both"></div>	
			</div>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01col1">(2)
					If &quot;Yes,&quot; provide the names of all such <em>affiliates</em> and any
					applicable registrations in
					<strong><u>Section 1-K of Schedule D</u></strong>					.
				</div>
			</div>
			<div style="clear:both"></div>	
		</div>
	</xsl:template>

	<xsl:template
		match="m1:address/ns2:residentialAddressFlag">
		
		<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdmax01singlecol tdmax01textmargins">
				Is this address a private residence? A private residential address will not be included in publicly available versions of this registration form.
			</div>
			<div class="tdstyle1max01sched tdmax01col2">
					<xsl:if
						test=". = 'Y' or . = 'y'">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:if>
					<xsl:if
						test=". = 'N' or . = 'n'">
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:if>
					Yes
					<xsl:if
						test=". = 'Y' or . = 'y'">
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:if>
					<xsl:if
						test=". = 'N' or . = 'n'">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:if>
					No
			</div>
		</div>
		<div style="clear:both"></div>	
		</div>
	</xsl:template>
		
	
	<!-- Item 3 Templates -->
	<xsl:template name="Item3" >
		<h3>A. Is the applicant, at the time of this filing, succeeding to the
			business of a registered
			<em>municipal advisor</em>?</h3>
	<em>If this succession was previously reported on Form MA, do not
	report the succession again. Instead, check &quot;No.&quot; See
	Instruction 1 of the Specific Instructions for Form MA included in the General Instructions. </em>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1" style="height:20px;"> 
			</div>
    		<div class="tdstyle1max01sched tdmax01col2">
				<xsl:choose>
                 <xsl:when
                      test="m1:controls/m1:isSucceedingApplicant = 'Y' or m1:controls/m1:isSucceedingApplicant  = 'y'">
                            <img    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                            <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                                                  
                    </xsl:when>
                    <xsl:when
                        test="m1:controls/m1:isSucceedingApplicant = 'N' or m1:controls/m1:isSucceedingApplicant  = 'n'">
                            <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                            <img    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                                                  
                    </xsl:when>
                    <xsl:otherwise>
                        <img    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img     src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                    </xsl:otherwise>
               </xsl:choose>			
			</div>
  		</div>
		<div style="clear:both"></div>	
	</div>
	
  <div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1"> If &quot;Yes&quot; enter the Date of Succession:</div>
    	<div class="tdstyle1max01sched tdmax01col2">
	<input
		type="text"
		name="ContactCRDNum"
		readonly="1">
		<xsl:attribute
			name="value">
		<xsl:value-of
			select="string(m1:successionInfo/m1:dateOfSuccession)" />
		</xsl:attribute>
	</input>
    	</div>
  	</div>
	<div style="clear:both"></div>	
	</div>
	
	<h3>B. If &quot;Yes,&quot; in Item 3.A., complete <u>Section 3 of Schedule D.</u></h3>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">	
						<div class="tableRow">
							<div class="tdstyle1max01sched tdlabelstylebgcolormax01sched tdmax01col1">
	       If &quot;Yes,&quot; in Item 3.A., complete <b><u>Section 3 of Schedule D</u></b>.
	   </div>
	  <div class="tdstyle1max01sched tdmax01col2">&#160;</div>
	</div>
	<div style="clear:both"></div>	
	</div>
	</xsl:template>
	
	<xsl:template name="stateDescription">
         <xsl:param name="stateCode" />
                <xsl:choose>
                    <xsl:when test="$stateCode='AK'">
						ALASKA
					</xsl:when>
					<xsl:when test="$stateCode='AL'">
						ALABAMA
					</xsl:when>
					<xsl:when test="$stateCode='AR'">
						ARKANSAS
					 </xsl:when>
					<xsl:when test="$stateCode='AZ'">
						ARIZONA
					</xsl:when>
					<xsl:when test="$stateCode='CA'">
						CALIFORNIA
					</xsl:when>
					<xsl:when test="$stateCode='CO'">
						COLORADO
					</xsl:when>
					<xsl:when test="$stateCode='CT'">
						CONNECTICUT
					</xsl:when>
					<xsl:when test="$stateCode='DC'">
						DISTRICT OF COLUMBIA
					</xsl:when>
					<xsl:when test="$stateCode='DE'">
						DELAWARE
					</xsl:when>
					<xsl:when test="$stateCode='FL'">
						FLORIDA
					</xsl:when>
					<xsl:when test="$stateCode='GA'">
						GEORGIA
					 </xsl:when>
					<xsl:when test="$stateCode='HI'">
						HAWAII
					 </xsl:when>
					<xsl:when test="$stateCode='IA'">
						IOWA
					 </xsl:when>
					<xsl:when test="$stateCode='ID'">
						IDAHO
					 </xsl:when>
					<xsl:when test="$stateCode='IL'">
						ILLINOIS
					 </xsl:when>
					<xsl:when test="$stateCode='IN'">
						INDIANA
					 </xsl:when>
					<xsl:when test="$stateCode='KS'">
						KANSAS
					 </xsl:when>
					<xsl:when test="$stateCode='KY'">
						KENTUCKY
					 </xsl:when>
					<xsl:when test="$stateCode='LA'">
						LOUISIANA
					 </xsl:when>
					<xsl:when test="$stateCode='MA'">
						MASSACHUSETTS
					 </xsl:when>
					<xsl:when test="$stateCode='MD'">
						MARYLAND
					 </xsl:when>
					<xsl:when test="$stateCode='ME'">
						MAINE
					 </xsl:when>
					<xsl:when test="$stateCode='MI'">
						MICHIGAN
					 </xsl:when>
					<xsl:when test="$stateCode='MN'">
						MINNESOTA
					 </xsl:when>
					<xsl:when test="$stateCode='MO'">
						MISSOURI
					 </xsl:when>
					<xsl:when test="$stateCode='MS'">
						MISSISSIPPI
					 </xsl:when>
					<xsl:when test="$stateCode='MT'">
						MONTANA
					 </xsl:when>
					<xsl:when test="$stateCode='NC'">
						NORTH CAROLINA
					 </xsl:when>
					<xsl:when test="$stateCode='ND'">
						NORTH DAKOTA
					 </xsl:when>
					<xsl:when test="$stateCode='NE'">
						NEBRASKA
					 </xsl:when>
					<xsl:when test="$stateCode='NH'">
						NEW HAMPSHIRE
					 </xsl:when>
					<xsl:when test="$stateCode='NJ'">
						NEW JERSEY
					 </xsl:when>
					<xsl:when test="$stateCode='NM'">
						NEW MEXICO
					 </xsl:when>
					<xsl:when test="$stateCode='NV'">
						NEVADA
					 </xsl:when>
					<xsl:when test="$stateCode='NY'">
						NEW YORK
					 </xsl:when>
					<xsl:when test="$stateCode='OH'">
						OHIO
					 </xsl:when>
					<xsl:when test="$stateCode='OK'">
						OKLAHOMA
					 </xsl:when>
					<xsl:when test="$stateCode='OR'">
						OREGON
					 </xsl:when>
					<xsl:when test="$stateCode='PA'">
						PENNSYLVANIA
					 </xsl:when>
					<xsl:when test="$stateCode='RI'">
						RHODE ISLAND
					 </xsl:when>
					<xsl:when test="$stateCode='SC'">
						SOUTH CAROLINA
					 </xsl:when>
					<xsl:when test="$stateCode='SD'">
						SOUTH DAKOTA
					 </xsl:when>
					<xsl:when test="$stateCode='TN'">
						TENNESSEE
					 </xsl:when>
					<xsl:when test="$stateCode='TX'">
						TEXAS
					 </xsl:when>
					<xsl:when test="$stateCode='UT'">
						UTAH
					 </xsl:when>
					<xsl:when test="$stateCode='VA'">
						VIRGINIA
					 </xsl:when>
					<xsl:when test="$stateCode='VT'">
						VERMONT
					 </xsl:when>
					<xsl:when test="$stateCode='WA'">
						WASHINGTON
					 </xsl:when>
					<xsl:when test="$stateCode='WI'">
						WISCONSIN
					 </xsl:when>
					<xsl:when test="$stateCode='WV'">
						WEST VIRGINIA
                     </xsl:when>
					<xsl:when test="$stateCode='WY'">
						WYOMING
					 </xsl:when>
					<xsl:when test="$stateCode='X1'">
						UNITED STATES
					 </xsl:when>
					<xsl:when test="$stateCode='A0'">
						ALBERTA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A1'">
						BRITISH COLUMBIA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A2'">
						MANITOBA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A3'">
						NEW BRUNSWICK, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A4'">
						NEWFOUNDLAND, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A5'">
						NOVA SCOTIA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A6'">
						ONTARIO, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A7'">
						PRINCE EDWARD ISLAND, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A8'">
						QUEBEC, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A9'">
						SASKATCHEWAN, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='B0'">
						YUKON, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='Z4'">
						CANADA (FEDERAL LEVEL)
					 </xsl:when>
					<xsl:when test="$stateCode='1A'">
						ANGUILLA
					 </xsl:when>
					<xsl:when test="$stateCode='1B'">
						ARMENIA
					 </xsl:when>
					<xsl:when test="$stateCode='1C'">
						ARUBA
					 </xsl:when>
					<xsl:when test="$stateCode='1D'">
						AZERBAIJAN
					 </xsl:when>
					<xsl:when test="$stateCode='1E'">
						BOSNIA AND HERZEGOVINA
					 </xsl:when>
					<xsl:when test="$stateCode='1F'">
						BELARUS
					 </xsl:when>
					<xsl:when test="$stateCode='1G'">
						DJIBOUTI
					 </xsl:when>
					<xsl:when test="$stateCode='1H'">
						ESTONIA
					 </xsl:when>
					<xsl:when test="$stateCode='1J'">
						ERITREA
					 </xsl:when>
					<xsl:when test="$stateCode='1K'">
						MICRONESIA, FEDERATED STATES OF
					 </xsl:when>
					<xsl:when test="$stateCode='1L'">
						SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS
					 </xsl:when>
					<xsl:when test="$stateCode='1M'">
						CROATIA
					 </xsl:when>
					<xsl:when test="$stateCode='1N'">
						KYRGYZSTAN
					 </xsl:when>
					<xsl:when test="$stateCode='1P'">
						KAZAKSTAN
					 </xsl:when>
					<xsl:when test="$stateCode='1Q'">
						LITHUANIA
					 </xsl:when>
					<xsl:when test="$stateCode='1R'">
						LATVIA
					 </xsl:when>
					<xsl:when test="$stateCode='1S'">
						MOLDOVA, REPUBLIC OF
					 </xsl:when>
					<xsl:when test="$stateCode='1T'">
						MARSHALL ISLANDS
					 </xsl:when>
					<xsl:when test="$stateCode='1U'">
						MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF
					 </xsl:when>
					<xsl:when test="$stateCode='1V'">
						NORTHERN MARIANA ISLANDS
					 </xsl:when>
<xsl:when test="$stateCode='1W'">
NEW CALEDONIA
 </xsl:when>
<xsl:when test="$stateCode='1X'">
PALESTINIAN TERRITORY, OCCUPIED
 </xsl:when>
<xsl:when test="$stateCode='1Y'">
PALAU
 </xsl:when>
<xsl:when test="$stateCode='1Z'">
RUSSIAN FEDERATION
 </xsl:when>
<xsl:when test="$stateCode='2A'">
SLOVENIA
 </xsl:when>
<xsl:when test="$stateCode='2B'">
SLOVAKIA
 </xsl:when>
<xsl:when test="$stateCode='2C'">
FRENCH SOUTHERN TERRITORIES
 </xsl:when>
<xsl:when test="$stateCode='2D'">
TAJIKISTAN
 </xsl:when>
<xsl:when test="$stateCode='2E'">
TURKMENISTAN
 </xsl:when>
<xsl:when test="$stateCode='2G'">
TUVALU
 </xsl:when>
<xsl:when test="$stateCode='2H'">
UKRAINE
 </xsl:when>
<xsl:when test="$stateCode='2J'">
UNITED STATES MINOR OUTLYING ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='2K'">
UZBEKISTAN
 </xsl:when>
<xsl:when test="$stateCode='2L'">
VANUATU
 </xsl:when>
<xsl:when test="$stateCode='2M'">
GERMANY
 </xsl:when>
<xsl:when test="$stateCode='2N'">
CZECH REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='2P'">
MAYOTTE
 </xsl:when>
<xsl:when test="$stateCode='2Q'">
GEORGIA
 </xsl:when>
<xsl:when test="$stateCode='B1'">
BOTSWANA
 </xsl:when>
<xsl:when test="$stateCode='B2'">
AFGHANISTAN
 </xsl:when>
<xsl:when test="$stateCode='B3'">
ALBANIA
 </xsl:when>
<xsl:when test="$stateCode='B4'">
ALGERIA
 </xsl:when>
<xsl:when test="$stateCode='B5'">
AMERICAN SAMOA
 </xsl:when>
<xsl:when test="$stateCode='B6'">
ANDORRA
 </xsl:when>
<xsl:when test="$stateCode='B7'">
ANGOLA
 </xsl:when>
<xsl:when test="$stateCode='B8'">
ANTARCTICA
 </xsl:when>
<xsl:when test="$stateCode='B9'">
ANTIGUA AND BARBUDA
 </xsl:when>
<xsl:when test="$stateCode='C0'">
UNITED ARAB EMIRATES
 </xsl:when>
<xsl:when test="$stateCode='C1'">
ARGENTINA
 </xsl:when>
<xsl:when test="$stateCode='C3'">
AUSTRALIA
 </xsl:when>
<xsl:when test="$stateCode='C4'">
AUSTRIA
 </xsl:when>
<xsl:when test="$stateCode='C5'">
BAHAMAS
 </xsl:when>
<xsl:when test="$stateCode='C6'">
BAHRAIN
 </xsl:when>
<xsl:when test="$stateCode='C7'">
BANGLADESH
 </xsl:when>
<xsl:when test="$stateCode='C8'">
BARBADOS
 </xsl:when>
<xsl:when test="$stateCode='C9'">
BELGIUM
 </xsl:when>
<xsl:when test="$stateCode='D0'">
BERMUDA
 </xsl:when>
<xsl:when test="$stateCode='D1'">
BELIZE
 </xsl:when>
<xsl:when test="$stateCode='D2'">
BHUTAN
 </xsl:when>
<xsl:when test="$stateCode='D3'">
BOLIVIA
 </xsl:when>
<xsl:when test="$stateCode='D4'">
BOUVET ISLAND
 </xsl:when>
<xsl:when test="$stateCode='D5'">
BRAZIL
 </xsl:when>
<xsl:when test="$stateCode='D6'">
BRITISH INDIAN OCEAN TERRITORY
 </xsl:when>
<xsl:when test="$stateCode='D7'">
SOLOMON ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='D8'">
VIRGIN ISLANDS, BRITISH
 </xsl:when>
<xsl:when test="$stateCode='D9'">
BRUNEI DARUSSALAM
 </xsl:when>
<xsl:when test="$stateCode='E0'">
BULGARIA
 </xsl:when>
<xsl:when test="$stateCode='E1'">
MYANMAR
 </xsl:when>
<xsl:when test="$stateCode='E2'">
BURUNDI
 </xsl:when>
<xsl:when test="$stateCode='E3'">
CAMBODIA
 </xsl:when>
<xsl:when test="$stateCode='E4'">
CAMEROON
 </xsl:when>
<xsl:when test="$stateCode='E8'">
CAPE VERDE
 </xsl:when>
<xsl:when test="$stateCode='E9'">
CAYMAN ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='F0'">
CENTRAL AFRICAN REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='F1'">
SRI LANKA
 </xsl:when>
<xsl:when test="$stateCode='F2'">
CHAD
 </xsl:when>
<xsl:when test="$stateCode='F3'">
CHILE
 </xsl:when>
<xsl:when test="$stateCode='F4'">
CHINA
 </xsl:when>
<xsl:when test="$stateCode='F5'">
TAIWAN, PROVINCE OF CHINA
 </xsl:when>
<xsl:when test="$stateCode='F6'">
CHRISTMAS ISLAND
 </xsl:when>
<xsl:when test="$stateCode='F7'">
COCOS (KEELING) ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='F8'">
COLOMBIA
 </xsl:when>
<xsl:when test="$stateCode='F9'">
COMOROS
 </xsl:when>
<xsl:when test="$stateCode='G0'">
CONGO
 </xsl:when>
<xsl:when test="$stateCode='G1'">
COOK ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='G2'">
COSTA RICA
 </xsl:when>
<xsl:when test="$stateCode='G3'">
CUBA
 </xsl:when>
<xsl:when test="$stateCode='G4'">
CYPRUS
 </xsl:when>
<xsl:when test="$stateCode='G6'">
BENIN
 </xsl:when>
<xsl:when test="$stateCode='G7'">
DENMARK
 </xsl:when>
<xsl:when test="$stateCode='G8'">
DOMINICAN REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='G9'">
DOMINICA
 </xsl:when>
<xsl:when test="$stateCode='GU'">
GUAM
 </xsl:when>
<xsl:when test="$stateCode='H1'">
ECUADOR
 </xsl:when>
<xsl:when test="$stateCode='H2'">
EGYPT
 </xsl:when>
<xsl:when test="$stateCode='H3'">
EL SALVADOR
 </xsl:when>
<xsl:when test="$stateCode='H4'">
EQUATORIAL GUINEA
 </xsl:when>
<xsl:when test="$stateCode='H5'">
ETHIOPIA
 </xsl:when>
<xsl:when test="$stateCode='H6'">
FAROE ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='H7'">
FALKLAND ISLANDS (MALVINAS)
 </xsl:when>
<xsl:when test="$stateCode='H8'">
FIJI
 </xsl:when>
<xsl:when test="$stateCode='H9'">
FINLAND
 </xsl:when>
<xsl:when test="$stateCode='I0'">
FRANCE
 </xsl:when>
<xsl:when test="$stateCode='I3'">
FRENCH GUIANA
 </xsl:when>
<xsl:when test="$stateCode='I4'">
FRENCH POLYNESIA
 </xsl:when>
<xsl:when test="$stateCode='I5'">
GABON
 </xsl:when>
<xsl:when test="$stateCode='I6'">
GAMBIA
 </xsl:when>
<xsl:when test="$stateCode='J0'">
GHANA
 </xsl:when>
<xsl:when test="$stateCode='J1'">
GIBRALTAR
 </xsl:when>
<xsl:when test="$stateCode='J2'">
KIRIBATI
 </xsl:when>
<xsl:when test="$stateCode='J3'">
GREECE
 </xsl:when>
<xsl:when test="$stateCode='J4'">
GREENLAND
 </xsl:when>
<xsl:when test="$stateCode='J5'">
GRENADA
 </xsl:when>
<xsl:when test="$stateCode='J6'">
GUADELOUPE
 </xsl:when>
<xsl:when test="$stateCode='J8'">
GUATEMALA
 </xsl:when>
<xsl:when test="$stateCode='J9'">
GUINEA
 </xsl:when>
<xsl:when test="$stateCode='K0'">
GUYANA
 </xsl:when>
<xsl:when test="$stateCode='K1'">
HAITI
 </xsl:when>
<xsl:when test="$stateCode='K2'">
HONDURAS
 </xsl:when>
<xsl:when test="$stateCode='K3'">
HONG KONG
 </xsl:when>
<xsl:when test="$stateCode='K4'">
HEARD ISLAND AND MCDONALD ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='K5'">
HUNGARY
 </xsl:when>
<xsl:when test="$stateCode='K6'">
ICELAND
 </xsl:when>
<xsl:when test="$stateCode='K7'">
INDIA
 </xsl:when>
<xsl:when test="$stateCode='K8'">
INDONESIA
 </xsl:when>
<xsl:when test="$stateCode='K9'">
IRAN, ISLAMIC REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='L0'">
IRAQ
 </xsl:when>
<xsl:when test="$stateCode='L2'">
IRELAND
 </xsl:when>
<xsl:when test="$stateCode='L3'">
ISRAEL
 </xsl:when>
<xsl:when test="$stateCode='L6'">
ITALY
 </xsl:when>
<xsl:when test="$stateCode='L7'">
COTE D'IVOIRE
 </xsl:when>
<xsl:when test="$stateCode='L8'">
JAMAICA
 </xsl:when>
<xsl:when test="$stateCode='L9'">
SVALBARD AND JAN MAYEN
 </xsl:when>
<xsl:when test="$stateCode='M0'">
JAPAN
 </xsl:when>
<xsl:when test="$stateCode='M2'">
JORDAN
 </xsl:when>
<xsl:when test="$stateCode='M3'">
KENYA
 </xsl:when>
<xsl:when test="$stateCode='M4'">
KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='M5'">
KOREA, REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='M6'">
KUWAIT
 </xsl:when>
<xsl:when test="$stateCode='M7'">
LAO PEOPLE'S DEMOCRATIC REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='M8'">
LEBANON
 </xsl:when>
<xsl:when test="$stateCode='M9'">
LESOTHO
 </xsl:when>
<xsl:when test="$stateCode='N0'">
LIBERIA
 </xsl:when>
<xsl:when test="$stateCode='N1'">
LIBYAN ARAB JAMAHIRIYA
 </xsl:when>
<xsl:when test="$stateCode='N2'">
LIECHTENSTEIN
 </xsl:when>
<xsl:when test="$stateCode='N4'">
LUXEMBOURG
 </xsl:when>
<xsl:when test="$stateCode='N5'">
MACAU
 </xsl:when>
<xsl:when test="$stateCode='N6'">
MADAGASCAR
 </xsl:when>
<xsl:when test="$stateCode='N7'">
MALAWI
 </xsl:when>
<xsl:when test="$stateCode='N8'">
MALAYSIA
 </xsl:when>
<xsl:when test="$stateCode='N9'">
MALDIVES
 </xsl:when>
<xsl:when test="$stateCode='O0'">
MALI
 </xsl:when>
<xsl:when test="$stateCode='O1'">
MALTA
 </xsl:when>
<xsl:when test="$stateCode='O2'">
MARTINIQUE
 </xsl:when>
<xsl:when test="$stateCode='O3'">
MAURITANIA
 </xsl:when>
<xsl:when test="$stateCode='O4'">
MAURITIUS
 </xsl:when>
<xsl:when test="$stateCode='O5'">
MEXICO
 </xsl:when>
<xsl:when test="$stateCode='O9'">
MONACO
 </xsl:when>
<xsl:when test="$stateCode='P0'">
MONGOLIA
 </xsl:when>
<xsl:when test="$stateCode='P1'">
MONTSERRAT
 </xsl:when>
<xsl:when test="$stateCode='P2'">
MOROCCO
 </xsl:when>
<xsl:when test="$stateCode='P3'">
MOZAMBIQUE
 </xsl:when>
<xsl:when test="$stateCode='P4'">
OMAN
 </xsl:when>
<xsl:when test="$stateCode='P5'">
NAURU
 </xsl:when>
<xsl:when test="$stateCode='P6'">
NEPAL
 </xsl:when>
<xsl:when test="$stateCode='P7'">
NETHERLANDS
 </xsl:when>
<xsl:when test="$stateCode='P8'">
NETHERLANDS ANTILLES
 </xsl:when>
<xsl:when test="$stateCode='PR'">
PUERTO RICO
 </xsl:when>
<xsl:when test="$stateCode='Q1'">
VIET NAM
 </xsl:when>
<xsl:when test="$stateCode='Q2'">
NEW ZEALAND
 </xsl:when>
<xsl:when test="$stateCode='Q3'">
NICARAGUA
 </xsl:when>
<xsl:when test="$stateCode='Q4'">
NIGER
 </xsl:when>
<xsl:when test="$stateCode='Q5'">
NIGERIA
 </xsl:when>
<xsl:when test="$stateCode='Q6'">
NIUE
 </xsl:when>
<xsl:when test="$stateCode='Q7'">
NORFOLK ISLAND
 </xsl:when>
<xsl:when test="$stateCode='Q8'">
NORWAY
 </xsl:when>
<xsl:when test="$stateCode='R0'">
PAKISTAN
 </xsl:when>
<xsl:when test="$stateCode='R1'">
PANAMA
 </xsl:when>
<xsl:when test="$stateCode='R2'">
PAPUA NEW GUINEA
 </xsl:when>
<xsl:when test="$stateCode='R4'">
PARAGUAY
 </xsl:when>
<xsl:when test="$stateCode='R5'">
PERU
 </xsl:when>
<xsl:when test="$stateCode='R6'">
PHILIPPINES
 </xsl:when>
<xsl:when test="$stateCode='R8'">
PITCAIRN
 </xsl:when>
<xsl:when test="$stateCode='R9'">
POLAND
 </xsl:when>
<xsl:when test="$stateCode='S0'">
GUINEA-BISSAU
 </xsl:when>
<xsl:when test="$stateCode='S1'">
PORTUGAL
 </xsl:when>
<xsl:when test="$stateCode='S3'">
QATAR
 </xsl:when>
<xsl:when test="$stateCode='S4'">
REUNION
 </xsl:when>
<xsl:when test="$stateCode='S5'">
ROMANIA
 </xsl:when>
<xsl:when test="$stateCode='S6'">
RWANDA
 </xsl:when>
<xsl:when test="$stateCode='S8'">
SAN MARINO
 </xsl:when>
<xsl:when test="$stateCode='S9'">
SAO TOME AND PRINCIPE
 </xsl:when>
<xsl:when test="$stateCode='T0'">
SAUDI ARABIA
 </xsl:when>
<xsl:when test="$stateCode='T1'">
SENEGAL
 </xsl:when>
<xsl:when test="$stateCode='T2'">
SEYCHELLES
 </xsl:when>
<xsl:when test="$stateCode='T3'">
SOUTH AFRICA
 </xsl:when>
<xsl:when test="$stateCode='T6'">
NAMIBIA
 </xsl:when>
<xsl:when test="$stateCode='T7'">
YEMEN
 </xsl:when>
<xsl:when test="$stateCode='T8'">
SIERRA LEONE
 </xsl:when>
<xsl:when test="$stateCode='U0'">
SINGAPORE
 </xsl:when>
<xsl:when test="$stateCode='U1'">
SOMALIA
 </xsl:when>
<xsl:when test="$stateCode='U3'">
SPAIN
 </xsl:when>
<xsl:when test="$stateCode='U5'">
WESTERN SAHARA
 </xsl:when>
<xsl:when test="$stateCode='U7'">
SAINT KITTS AND NEVIS
 </xsl:when>
<xsl:when test="$stateCode='U8'">
SAINT HELENA
 </xsl:when>
<xsl:when test="$stateCode='U9'">
SAINT LUCIA
 </xsl:when>
<xsl:when test="$stateCode='V0'">
SAINT PIERRE AND MIQUELON
 </xsl:when>
<xsl:when test="$stateCode='V1'">
SAINT VINCENT AND THE GRENADINES
 </xsl:when>
<xsl:when test="$stateCode='V2'">
SUDAN
 </xsl:when>
<xsl:when test="$stateCode='V3'">
SURINAME
 </xsl:when>
<xsl:when test="$stateCode='V6'">
SWAZILAND
 </xsl:when>
<xsl:when test="$stateCode='V7'">
SWEDEN
 </xsl:when>
<xsl:when test="$stateCode='V8'">
SWITZERLAND
 </xsl:when>
<xsl:when test="$stateCode='V9'">
SYRIAN ARAB REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='VI'">
VIRGIN ISLANDS, U.S.
 </xsl:when>
<xsl:when test="$stateCode='W0'">
TANZANIA, UNITED REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='W1'">
THAILAND
 </xsl:when>
<xsl:when test="$stateCode='W2'">
TOGO
 </xsl:when>
<xsl:when test="$stateCode='W3'">
TOKELAU
 </xsl:when>
<xsl:when test="$stateCode='W4'">
TONGA
 </xsl:when>
<xsl:when test="$stateCode='W5'">
TRINIDAD AND TOBAGO
 </xsl:when>
<xsl:when test="$stateCode='W6'">
TUNISIA
 </xsl:when>
<xsl:when test="$stateCode='W7'">
TURKS AND CAICOS ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='W8'">
TURKEY
 </xsl:when>
<xsl:when test="$stateCode='W9'">
UGANDA
 </xsl:when>
<xsl:when test="$stateCode='X0'">
UNITED KINGDOM
 </xsl:when>
<xsl:when test="$stateCode='X2'">
BURKINA FASO
 </xsl:when>
<xsl:when test="$stateCode='X3'">
URUGUAY
 </xsl:when>
<xsl:when test="$stateCode='X4'">
HOLY SEE (VATICAN CITY STATE)
 </xsl:when>
<xsl:when test="$stateCode='X5'">
VENEZUELA
 </xsl:when>
<xsl:when test="$stateCode='X8'">
WALLIS AND FUTUNA
 </xsl:when>
<xsl:when test="$stateCode='Y0'">
SAMOA
 </xsl:when>
<xsl:when test="$stateCode='Y3'">
CONGO, THE DEMOCRATIC REPUBLIC OF THE
 </xsl:when>
<xsl:when test="$stateCode='Y4'">
ZAMBIA
 </xsl:when>
<xsl:when test="$stateCode='Y5'">
ZIMBABWE
 </xsl:when>
<xsl:when test="$stateCode='Y6'">
ALAND ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='Y7'">
GUERNSEY
 </xsl:when>
<xsl:when test="$stateCode='Y8'">
ISLE OF MAN
 </xsl:when>
<xsl:when test="$stateCode='Y9'">
JERSEY
 </xsl:when>
<xsl:when test="$stateCode='Z0'">
SAINT BARTHELEMY
 </xsl:when>
<xsl:when test="$stateCode='Z1'">
SAINT MARTIN
 </xsl:when>
<xsl:when test="$stateCode='Z2'">
SERBIA
 </xsl:when>
<xsl:when test="$stateCode='Z3'">
TIMOR-LESTE
 </xsl:when>
<xsl:when test="$stateCode='Z5'">
MONTENEGRO
 </xsl:when>
<xsl:when test="$stateCode='XX'">
Unknown
</xsl:when>
<xsl:when test="$stateCode='2F'">
EAST TIMOR
</xsl:when>
<xsl:when test="$stateCode='C2'">
ASHMORE &#38; CARTIER IS
</xsl:when>
<xsl:when test="$stateCode='E5'">
CANAL ZONE
</xsl:when>
<xsl:when test="$stateCode='E6'">
MONTREAL, CANADA
</xsl:when>
<xsl:when test="$stateCode='E7'">
CANTON/ENDERBURY IS
</xsl:when>
<xsl:when test="$stateCode='G5'">
CZECHOSLOVAKIA
</xsl:when>
<xsl:when test="$stateCode='I7'">
GAZA STRIP
</xsl:when>
<xsl:when test="$stateCode='I8'">
GERMANY (WEST)
</xsl:when>
<xsl:when test="$stateCode='I9'">
GERMANY, FED. REP.
</xsl:when>
<xsl:when test="$stateCode='L1'">
IRAQ-SAUDI
</xsl:when>
<xsl:when test="$stateCode='L4'">
ISRAEL-JORDAN
</xsl:when>
<xsl:when test="$stateCode='L5'">
ISRAEL-SYRIA
</xsl:when>
<xsl:when test="$stateCode='M1'">
JOHNSTON ATOLL
</xsl:when>
<xsl:when test="$stateCode='O6'">
MIDWAY ISLAND
</xsl:when>
<xsl:when test="$stateCode='Q9'">
PACIFIC ISLANDS TRU
</xsl:when>
<xsl:when test="$stateCode='R3'">
PARACEL ISLANDS
</xsl:when>
<xsl:when test="$stateCode='T4'">
SOUTHERN RHODESIA
</xsl:when>
<xsl:when test="$stateCode='U2'">
SOVIET UNION
</xsl:when>
<xsl:when test="$stateCode='U4'">
SPANISH NORTH AFRICA
</xsl:when>
<xsl:when test="$stateCode='U6'">
SPRATLY ISLAND
</xsl:when>
<xsl:when test="$stateCode='X7'">
WAKE ISLAND
</xsl:when>
<xsl:when test="$stateCode='X9'">
GERMANY (BERLIN)
</xsl:when>
<xsl:when test="$stateCode='Y2'">
YUGOSLAVIA
</xsl:when>
<xsl:otherwise><xsl:value-of select="$stateCode" /></xsl:otherwise>
</xsl:choose>
   </xsl:template>
	
	<xsl:include href="MA_item4.xsl" />
	<xsl:include href="MA_item5.xsl" />
	<xsl:include href="MA_item6.xsl" />
	<xsl:include href="MA_item7.xsl" />
	<xsl:include href="ma_item8.xsl" />
    <xsl:include href="ma_item9.xsl" />
	<xsl:include href="MA_item10.xsl" />
	<xsl:include href="MA_execution.xsl" />
	<xsl:include href="MA_schedA.xsl" />
	<xsl:include href="MA_schedB.xsl" />
	<xsl:include href="MA_schedC.xsl" />
	<xsl:include href="MA_schedD.xsl" />
	<xsl:include href="MA_criminal-drp.xsl" />
	<xsl:include href="MA_regulatory-drp.xsl" /> 
	<xsl:include href="MA_judicial-drp.xsl" /> 
</xsl:stylesheet>
	