<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">
	
	<xsl:template name="CustomerDrp"><link href="style.css" rel="stylesheet" type="text/css" />
		
		<xsl:for-each
			select="n2:drpInfo/ns4:customerComplaintDisclosure/ns4:customerComplaintDrp">
			<div id="maiDRPcust">
				<div class="content">

					<h1>CUSTOMER COMPLAINT / ARBITRATION / CIVIL LITIGATION DISCLOSURE
						REPORTING PAGE (MA-I)</h1>

					<p>
						This <b>Disclosure Reporting Page (DRP MA-I)</b> is an <span class="label">
						<xsl:choose>
							<xsl:when test="count(ns4:baseHeader/ns4:reponseType/m1:add)&gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>

									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
							</xsl:choose>
							<b>INITIAL</b> or
							<xsl:choose>
								<xsl:when test="count(ns4:baseHeader/ns4:reponseType/m1:amend) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>

									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
							</xsl:choose>
							<b>AMENDED</b>
						response to report details for affirmative response(s) to <b><em>Question(s) 6I</em></b> on Form MA-I.
					</span> </p>
					<p>Check the question(s) to which this DRP pertains:</p>
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
						<div class="tableRowNoBorder">
							<div class="tdscheduleagridcol1">
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:customerComplaintQuestions='6I(1)(a)'">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>

									6I(1)(a)
								</strong>								
							</div>
							<div class="tdscheduleagridcol1">
								<strong>

									<xsl:choose>
										<xsl:when test="ns4:customerComplaintQuestions='6I(2)(a)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>

									6I(2)(a)
								</strong>
							</div>
							<div class="tdscheduleagridcol1">
								<strong>

									<xsl:choose>
										<xsl:when test="ns4:customerComplaintQuestions='6I(2)(c)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>

									6I(2)(c)
								</strong>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRowNoBorder">
							<div class="tdscheduleagridcol1">
								<strong>

									<xsl:choose>
										<xsl:when test="ns4:customerComplaintQuestions='6I(1)(b)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>

									6I(1)(b)
								</strong>
							</div>
							<div class="tdscheduleagridcol1">
								<strong>

									<xsl:choose>
										<xsl:when test="ns4:customerComplaintQuestions='6I(2)(b)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>

									6I(2)(b)
								</strong>
							</div>
							<div class="tdscheduleagridcol1"></div>
						</div>
						<div style="clear:both;"></div>
					</div>
					<div class="tablebottom">
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1">Is this DRP an amendment that
								seeks to remove a previously filed DRP concerning the
								individual
								from the record?</div>

							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable='Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:when
										test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable='N'">

										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:when>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>						

						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">The reason the DRP should be
								removed is:</div>
							<div class="tdStyle1 tditem10col1100px">
								<p>

									<xsl:choose>
										<xsl:when
											test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered) &gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										</xsl:otherwise>
									</xsl:choose>
									The event or <em>proceeding</em> was resolved in the individual&#39;s favor<br />
									<br />
									<xsl:choose>
										<xsl:when
											test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError) &gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											The DRP was filed in error.
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											The DRP was filed in error.
										</xsl:otherwise>
									</xsl:choose>

								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						
						<div class="tableRow">
						  <div class="tdStyle1 tditem10col1100px"><br />
						  Explain the circumstances:<br>
						  </br>
						  </div>
						  <div class="tdStyle1 tditem10col2100px">
							   <textarea name="textarea4" id="textarea4" cols="52" rows="5">
							
							<xsl:value-of
									select="string(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError/m1:explainTheCircumstances)" />
									
								</textarea>
						  </div>
						  <div style="clear:both;"></div>
						</div>
					</div>
					<p>
						<strong><u>How to Report a Matter or a <em>Proceeding</em> on this DRP</u>:</strong>
						Use a separate DRP for each matter or
						<em>proceeding</em>. One matter may result in more than one affirmative answer to the
						above items. Use a single DRP to report details relating to a
						particular matter (<em>i.e.</em>, a customer complaint, arbitration,
						<em>CFTC</em>
						reparation, or civil litigation). If an event gives rise to
						separate <em>proceeding</em>s by more than one regulator or other
						authority,
						or other plaintiff, provide details for each <em>proceeding</em>
						on a
						separate DRP. Separate cases arising out of the same matter,
						and
						unrelated civil judicial actions, must be reported on separate
						DRPs; if they are later consolidated into a single civil judicial
						action, the consolidated action can be reported on one DRP.
					</p>
					<div class="mainDiv2">						
							<div class="tdStyle1 tditem10col1">
									<strong><u>DRP On File for This Event</u>
									:</strong>
								<u>
								Is an accurate and up-to-date DRP containing the information
								regarding the individual required by this DRP already on file (a)
								in the
								<em>IARD</em>
								or
								<em>CRD</em>
								system (with a Form ADV, BD, or U4), or (b) in the
								<em>SEC's</em>
								EDGAR system (with a Form MA or Form MA-I)?</u>
							</div>
							<div class="tditem10col2">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling or ns4:baseHeader/ns4:filingInfo/ns4:maFiling or ns4:baseHeader/ns4:filingInfo/ns4:matFiling or ns4:baseHeader/ns4:filingInfo/ns4:maiFiling">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>				
						<div style="clear:both;"></div>
					</div>
					<strong>
					<p>
						<u><em>Note: The filer may identify a DRP filed by the
							individual
							directly, or filed by another SEC-registrant about the
							individual
							as an associated person.</em></u>
					</p>
				<!-- 	<p>
						<em> Note 2: If a Form MA-T is on file that includes disclosures
							for this event, but does not include all the information required
							by this DRP, the disclosures on Form MA-T are not considered
							accurate and up-to-date.</em>
					</p> -->
					</strong>
					<p>
						<strong>If the answer is &quot;Yes,&quot;</strong> provide the applicable
							information indicated below that identifies where the DRP may be found.
					</p>
					
					<div class="mainDiv2" style="margin-left:0; margin-right:0;" >
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<strong> 1. Form ADV, BD, or U4 Filing:</strong>
								For a DRP filed on the
								<em>IARD</em>
								or
								<em>CRD</em>
								system with one of these forms, provide the following
								information:
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Name on Registration:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p><em>CRD</em> No.:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Disclosure Occurrence No.:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<strong> 2. Form MA Filing: </strong>
								For a DRP filed on EDGAR with a Form MA, provide the following
								information:
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Name on Registration:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>MA Registration Number:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate" />
			 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Accession number of the filing: </p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<strong> 3. Form MA-I Filing:</strong>
								For a DRP filed on EDGAR with a Form MA-I, provide the following
								information:
							</div>
							<div></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Name of Individual:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>MA-I File Number:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRowNoBorder">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>Accession number of the filing:</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
					</div>

					<p class="guidance">
						<strong>NOTE:
						The completion of all or any part of this form does not
						relieve
						the individual or any <em>municipal advisor</em> with which the individual is
						associated
						of the obligation to update any relevant Form MA or <em>IARD</em> or
						<em>CRD</em> records.
						</strong>
					</p>

					<p>
						<strong>
							<u>Disclosure Instructions and the Individual's Status:</u> You must indicate the individual's status in Items II and III below.
						</strong>
					</p>
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
						
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>I. All Matters: Items 1-6. Complete Items 1-6 for all
									matters, whether or not the individual is named as a party, including:</strong>
								<p>
									A. Customer complaints, arbitrations /
									<em>CFTC</em>
									reparations and civil litigation in which the individual is
									<u>not named </u>
									as a party, as well as,
								</p>
								<p>
									B. Arbitrations /
									<em>CFTC</em>
									reparations and civil litigation in which the individual
									<u>is named</u>
									as a party.
								</p>
							</div>
							<div style="clear:both;"></div>
						
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>
									II. If the individual is
									<u>not named</u>
									as a party,
									<u>check here </u>
									<xsl:choose>
                                    <xsl:when
                                        test="ns4:drpData/ns4:disclosureStatus/ns4:isNotNamedAsParty='N'">

                                        <img src="Images/box-checked.jpg" alt="checkbox checked"/>
                                    </xsl:when>
                                    <xsl:otherwise>

                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    </xsl:otherwise>
                                </xsl:choose>
									 And complete Items 7-11.
								</strong>
								<p>
									A. If the matter
									<em>involves</em>
									a customer complaint, or an arbitration /
									<em>CFTC</em>
									reparation or civil litigation in which the individual is not named as a
									party, complete Items 7-11 as appropriate.
								</p>
								<p>
									B. If a customer complaint has evolved into an arbitration /
									<em>CFTC</em>
									reparation or civil litigation,
								    amend the existing Disclosure Form by completing Items 9 and
									10.</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>
									III. If the individual
									<u>is named</u>
									as a party,
									<u>check here:</u>
									<xsl:choose>
									 <xsl:when
                                        test="ns4:drpData/ns4:disclosureStatus/ns4:isNamedAsParty">
                                        <img src="Images/box-checked.jpg" alt="checkbox checked"/>
                                    </xsl:when>
                                    
                                    <xsl:otherwise>

                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    </xsl:otherwise>
                                    </xsl:choose>
									 And check the appropriate boxes below:
								</strong>
								
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>
									<strong>
										A. Arbitration /
										<em>CFTC</em>
										Reparation:
									</strong>
								</p>
								<p>
									If the matter
									<em>involves</em>
									an arbitration /
									<em>CFTC</em>
									reparation in which the individual is a named party,
									<strong>
										<u>check here </u>
										<xsl:choose>
                                    <xsl:when
                                        test="ns4:drpData/ns4:disclosureStatus/ns4:isNamedAsParty/ns4:isInvolveArbitration='Y'">

                                        <img src="Images/box-checked.jpg" alt="checkbox checked"/>
                                    </xsl:when>
                                    <xsl:otherwise>

                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    </xsl:otherwise>
                                </xsl:choose>
										  And complete Items 12-16, as appropriate.
									</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>
									<strong>B. Civil Litigation:</strong>
									If the matter
									<em>involves</em>
									a civil litigation in which the individual is a named party,
									<strong>
										<u>check here </u>
										<xsl:choose>
                                    <xsl:when
                                        test="ns4:drpData/ns4:disclosureStatus/ns4:isNamedAsParty/ns4:isInvolveLitigation='Y'">

                                        <img src="Images/box-checked.jpg" alt="checkbox checked"/>
                                    </xsl:when>
                                    <xsl:otherwise>

                                        <img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    </xsl:otherwise>
                                </xsl:choose>
										 And complete Items 17-23.
									</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRowNoBorder">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>IV. Summary of the Circumstances: Item 24.</strong>
								<p>
									This is an optional space and applies to all event types (<u><em>i.e.</em></u>, 
									customer complaint, arbitration/<em>CFTC</em>
									reparation, civil litigation).
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
					</div>
					<p class="guidance"><strong>Complete Items 1-6 for all matters (<u><em>i.e.</em></u>, customer
						complaints, arbitrations/<em>CFTC</em> reparations, civil litigation).</strong></p>
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>1. Customer Name(s):</strong>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of select="ns4:drpData/ns4:customerName" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>2. A. Customer(s) State of Residence or domicile, if
									applicable</strong>
								:
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
							
                        
                    <xsl:call-template name="stateDescription">
                        <xsl:with-param name="stateCode" select="ns4:drpData/ns4:customerResidence" />
                     </xsl:call-template>
                
                 
             
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>B. Does/do the customer(s) have other state(s) of
									residence</strong> or domicile, if applicable?
									
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:customerOtherResidence ">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">If &quot;Yes,&quot; provide the information:</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of select="ns4:drpData/ns4:customerOtherResidence" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>3. Employing Firm:</strong>
								<p>
									Provide the full legal name of the individual's employing firm, if any,
									when activities occurred which led to the customer complaint, arbitration,
									<em>CFTC</em>
									reparation or civil litigation (if there was no such employing firm at that time, 
									enter &quot;None&quot;). 
									Enter the employing firm's MA and
									<em>CRD</em>
									registration numbers below, if any.
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<p>
									<strong>A. Employing Firm:</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:matterInformation/ns4:employingFirmInfo/ns4:name" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>B. <em>Municipal Advisor</em> Registration Number, if any: </strong>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of select="ns4:drpData/ns4:matterInformation/ns4:employingFirmInfo/ns4:registrationNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>C. <em>CRD</em> Number, if any: </strong>
							</div>
							<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2">
				<xsl:value-of
											select="ns4:drpData/ns4:matterInformation/ns4:employingFirmInfo/ns4:crdNumber" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1 tditem10col1100px">
								<strong>4. Product Type(s):</strong> (select all that apply)
							</div>
							<div style="clear:both;"></div>
						</div>					
						<div class="mainDiv2" style="margin-left:0; margin-right:0;">
							<div class="tableRow">
									<div class="mainDiv2" style="margin-left:0; margin-right:0;" border="0" cellspacing="8">
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='No Product'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													No Product
												
											</div>
											<div style="width:33%;"></div>
											<div style="width:33%;"></div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='AnnuityCharitable'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Annuity-Charitable
												
											</div>

											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Direct Investment(s) - DPP &amp; LP Interest(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Direct Investment-DPP &amp; LP Interest
												
											</div>


											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='OilAndGas'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Oil &amp; Gas
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Annuity(ies) - Fixed'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Annuity-Fixed
												
											</div>

											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='EquipmentLeasing'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Equipment Leasing
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Options'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Options
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Annuity(ies) - Variable'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Annuity-Variable
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Equity Listed (Common &amp; Preferred Stock)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Equity Listed (Common &amp; Preferred Stock)
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Penny Sock(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Penny Stock
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='BankingProduct'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Banking Product
													<br />
													(other than CD)
												
											</div>


											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Equity - OTC'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Equity-OTC
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='PrimeBankInstrument'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Prime Bank Instrument
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Futures - Commodity'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Futures-Commodity
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Promissory Note'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Promissory Note
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='CD(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													CD
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Futures - Financial'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Futures-Financial
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Real Estate Security'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Real Estate Security
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Commodity Option(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Commodity Option
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Index Option(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Index Option
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Security Futures'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Security Futures
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Asset Backed'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Debt-Asset Backed
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Insurance'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Insurance
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Security-based Swap'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Security-based Swap
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Corporate'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Debt-Corporate
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Investment Contract(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Investment Contract
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Swap'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Swap
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">													
												<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Government'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Debt-Government
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Money Market Fund(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Money Market Fund
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Unit Investment Trust(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Unit Investment Trust
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Municipal'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Debt-Municipal
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Mutual Fund(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Mutual Fund
												
											</div>
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Viatical Settlement'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Viatical Settlement
												
											</div>
											<div style="clear:both;"></div>
										</div>
										<div class="tableRow">
											<div class="tdStyle1 tdscheduleagridcol1">
												

													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Derivative(s)'">

															<img src="Images/box-checked.jpg" alt="checkbox checked"/>
														</xsl:when>
														<xsl:otherwise>

															<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>

													Derivative
												
											</div>
										</div>
										<div style="clear:both;"></div>
									</div>
							</div>
							<div style="clear:both;"></div>
						</div>
						
						
						<div class="tableRow">
						<div class="tdStyle1 tditem10col1">
						
									<strong>
										<xsl:choose>
											<xsl:when
                                            test="ns4:drpData/ns4:matterInformation/ns4:otherProductTypes">

												<img src="Images/box-checked.jpg" alt="checkbox checked"/>
											</xsl:when>
											<xsl:otherwise>

												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>

										Other Product Type?
									</strong>
									</div>
									<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">

									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:matterInformation/ns4:otherProductTypes">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											YES
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											NO
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											YES
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											NO
										</xsl:otherwise>
									</xsl:choose>
								</div>
								<div style="clear:both;"></div>
								</div>
								<div class="tableRow">
								<div class="tdStyle1 tditem10col1 tditem10col1100px">
									If “Yes,” describe each additional product type:      

								</div>
								<div class="tdStyle1 tditem10col1 tditem10col1100px tdCustomervalue2"> 
										<xsl:value-of
											select="ns4:drpData/ns4:matterInformation/ns4:otherProductTypes" />
								
						</div>
						<div style="clear:both;"></div>
						</div>

						
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1">
								<strong>5. Allegation(s):  </strong>
								<p>Describe the allegation(s) and provide a brief summary
								   of events related to the allegation(s), including dates when
								   activities leading to the allegation(s) occurred:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
							<!--
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:matterInformation/ns4:allegationsDescription" />
						    </xsl:call-template>
						    -->
					
									<xsl:value-of
										select="string(ns4:drpData/ns4:matterInformation/ns4:allegationsDescription)" />

							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>6. Alleged Compensatory Damage(s)</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<p>
								<div class="tdStyle1 tditem10col1100px">

									<strong>A. Do the allegations include any amount(s) for
										compensatory damage(s)?</strong>

								</div>
								<div class="tdStyle1 tditem10col2100px">
									<xsl:choose>
										<xsl:when test="ns4:drpData/ns4:damageInfo/ns4:damageAmount">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											YES
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											NO
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											YES
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											NO
										</xsl:otherwise>
									</xsl:choose>

								</div>
							</p>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							
								<div class="tdStyle1 tditem10col1100px">

									<strong>B. If &quot;Yes,&quot; indicate the amount:</strong>

								</div>

								<div class="tdStyle1 tditem10col2100px">
								<xsl:call-template name="format_to_dollar">
							        <xsl:with-param name="money" select="ns4:drpData/ns4:damageInfo/ns4:damageAmount" />
							    </xsl:call-template>
							    <!-- 
								$
								<input type="text" value="$" class="moneyField"
									readonly="1">
									<xsl:attribute name="value">
								<xsl:if test="ns4:drpData/ns4:damageInfo/ns4:damageAmount">
												<xsl:value-of select='format-number(ns4:drpData/ns4:damageInfo/ns4:damageAmount, "###,###.00")' />
							    </xsl:if>
							    </xsl:attribute>
							    </input>
									-->			
								</div>
								<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
								<div class="tdStyle1 tditem10col1100px">
								<p>
									<xsl:choose>
									
									<xsl:when test=" count(ns4:drpData/ns4:damageInfo/ns4:exact) &gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Exact
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Explanation
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Exact
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Explanation
										</xsl:otherwise>
										
									</xsl:choose>
									</p>
								</div>
							<div style="clear:both;"></div>
						</div>


						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p class="minutia">If not exact, provide explanation:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:damageInfo/ns4:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						
					
					<div class="tableRow">
					<div class="guidance">
						<strong>
						<p><U>If the Individual Is Not a Named Party:</U> If the matter <em>involves</em> a customer
							complaint, arbitration/<em>CFTC</em> reparation or civil litigation in
							which the individual is not named as a party, complete items 7-11 as
							appropriate.</p>
						<p><U>If the Individual Is a Named Party:</U> Report in Items 12-16, or 17-23, as
							appropriate, only arbitrations/<em>CFTC</em> reparations or civil
							litigation in which the individual is named as a party.</p>
						</strong>
					</div>
					<div style="clear:both;"></div>
					</div>
					
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>7. A. Is this an oral complaint?</strong>
							</div>
							<div class="tdStyle1 tditem10col2">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:isOralComplaint='Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. Is this a written complaint?</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:isWrittenComplaint='Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>
										C. Is this an arbitration/<em>CFTC</em>
										reparation or civil litigation?
									</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:arbitrationDetail/ns4:detail or ns4:drpData/ns4:arbitrationDetail/ns4:date">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>If &quot;Yes,&quot; provide:</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(1) Arbitration/reparation forum or court name: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
											select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:courtInfo/m1:name" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(2) Location of the Forum or Court:</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>Street Address: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
											select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:street1" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>City or County: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
											select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:city" />
				 
								 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>State / Country: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
							
						
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
						</xsl:call-template>
						
				</div>
						<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>Postal Code: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
											select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:courtInfo/m1:address/ns1:zipCode" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(3) Docket/Case Name: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
											select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:docketCaseName" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(4) Docket/Case Number: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of select="ns4:drpData/ns4:arbitrationDetail/ns4:detail/ns4:courtInfo/m1:docketOrCaseNo" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									(5) Filing  date of arbitration/<em>CFTC</em>
									reparation or civil litigation (MM/DD/YYYY):
								</p>
							</div>
							<div>
								<span class="label">
									<input name="input37" type="text" value="mm/dd/yyyy"
										class="dateField" readonly="1">
										<xsl:attribute name="value">
				<xsl:value-of select="ns4:drpData/ns4:filingDateArbitration" />
				</xsl:attribute>
									</input>
								</span>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>D. Date received by/served on firm</strong>
									(MM/DD/YYYY):
								</p>
							</div>
							<div>
								<input name="input36" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of select="ns4:drpData/ns4:arbitrationDetail/ns4:date/m1:date" />
				</xsl:attribute>
								</input>
								<xsl:choose>
								<xsl:when test=" count(ns4:drpData/ns4:arbitrationDetail/ns4:date/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If not exact, provide explanation: </p>
							</div>
							<div class="tdStyle1 tditem10col2100px tdCustomervalue2" style="margin-left:0; margin-right:0;"> 
									<xsl:value-of
										select="ns4:drpData/ns4:arbitrationDetail/ns4:date/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>8. Pending:  </strong>
								<p>
									Is the complaint, arbitration/<em>CFTC</em>
									reparation or civil litigation pending?
								</p>
							</div>
							<div class="tdStyle1 tditem10col2100px">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:finalStatus">
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>If &quot;No,&quot; complete item 9.</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>9. Final:</strong>
								<p>If the complaint, arbitration/<em>CFTC</em>
								reparation or civil litigation is not pending, provide status:
								</p>
							</div>
							<div style="clear:both;"></div>					
						<div>
						
							<div class="mainDiv2 tableRowNoBorder" style="margin-left:0; margin-right:0;">							
									<div>
										<xsl:choose>
											<xsl:when test="ns4:drpData/ns4:finalStatus='Closed/ No Action'">
												<img src="Images/radio-checked.jpg" alt="radio button checked"/>
												Closed/No Action

											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Closed/No Action

											</xsl:otherwise>
										</xsl:choose>

										<xsl:choose>
											<xsl:when test="ns4:drpData/ns4:finalStatus='Withdrawn'">
												<img src="Images/radio-checked.jpg" alt="radio button checked"/>
												Withdrawn  

											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Withdrawn  

											</xsl:otherwise>
										</xsl:choose>

										<xsl:choose>
											<xsl:when test="ns4:drpData/ns4:finalStatus='Denied'">
												<img src="Images/radio-checked.jpg" alt="radio button checked"/>
												Denied  

											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Denied

											</xsl:otherwise>
										</xsl:choose>

										<xsl:choose>
											<xsl:when test="ns4:drpData/ns4:finalStatus='Settled'">
												<img src="Images/radio-checked.jpg" alt="radio button checked"/>
												Settled

											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Settled

											</xsl:otherwise>
										</xsl:choose>

									</div>
							</div>
						<div class="mainDiv2 tableRowNoBorder" style="margin-left:0; margin-right:0;">							
								<div>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:finalStatus='Arbitration Award/Monetary Judgement(for claimants/plaintiffs)'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Arbitration Award/Monetary Judgment (for claimants/plaintiffs)

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Arbitration Award/Monetary Judgment (for claimants/plaintiffs)

										</xsl:otherwise>
									</xsl:choose>
								</div>							
						</div>
						<div class="mainDiv2 tableRowNoBorder" style="margin-left:0; margin-right:0;">							
								<div>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:finalStatus='Arbitration Award/Monetary Judgement(for respondents/defendants)'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Arbitration Award/Monetary Judgment (for respondents/defendants)

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Arbitration Award/Monetary Judgment (for respondents/defendants)

										</xsl:otherwise>
									</xsl:choose>
								</div>							
						</div>
						<div class="mainDiv2 tableRowNoBorder" style="margin-left:0; margin-right:0;">							
								<div>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:finalStatus='Evolved into Arbitration/CFTC reparation'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Evolved into Arbitration/<em>CFTC</em>
											reparation (the individual is a named party):
											<strong>Complete Items 12-16. </strong>

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Evolved into Arbitration/<em>CFTC</em>
											reparation (the individual is a named party):
											<strong>Complete Items 12-16. </strong>

										</xsl:otherwise>
									</xsl:choose>
								</div>							
						</div>
						<div class="mainDiv2 tableRowNoBorder" style="margin-left:0; margin-right:0;">							
								<div>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:finalStatus='Evolved into Civil litigation'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Evolved into Civil litigation (you are a named party):
											<strong>Complete Items 17-23.</strong>

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Evolved into Civil litigation (you are a named party):
											<strong>Complete Items 17-23.</strong>
										</xsl:otherwise>
									</xsl:choose>

								</div>
								<div style="clear:both;"></div>	
							</div>
						
						<div style="clear:both;"></div>	
						</div>
					
					</div>
					
					<div class="tableRow">
					
					<div class="guidance">
						<strong><p>
							Status:
						</p>
						<p><U>If the Individual Is Not a Named Party:</U> If the status is arbitration/<em>CFTC</em> 
						reparation in which the individual is not a named party, provide
							details in Item 7C. </p>
						<p><U>If the Individual Is a Named Party:</U> If the status is arbitration/<em>CFTC</em>
							reparation in which the individual is a named party, complete Items 12-16.
							If the status is civil litigation in which the individual is a named party,
							complete Items 17-23.</p>
						</strong>
					</div>
						<div style="clear:both;"></div>	
					</div>
					
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>10. Status Date</strong>
									(MM/DD/YYYY):
								</p>
							</div>
							<div class="tdStyle1 tditem10col2100px">
								<input name="input45" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of select="ns4:drpData/ns4:statusDate/m1:date" />
				</xsl:attribute>
								</input>
								<xsl:choose>
								<xsl:when test=" count(ns4:drpData/ns4:statusDate/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">If not exact, provide explanation:</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:statusDate/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>11. Settlement/Award/Monetary Judgment:</strong>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>A. Is there a Settlement/Award/Monetary Judgment?</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:judgementInfo/ns4:totalAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>If &quot;Yes,&quot; provide the details below.</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. Settlement/Award/Monetary Judgment Amount: </strong>
								</p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:judgementInfo/ns4:totalAmount" />
						    </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>C. Was the individual required to pay any portion of the total
										amount?   </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:judgementInfo/ns4:contributionAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>

							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; indicate:</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(1) The individual's contribution amount: </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:judgementInfo/ns4:contributionAmount" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(2) Was any portion waived?</p>
							</div>
						<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
								<xsl:when
										test="ns4:drpData/ns4:judgementInfo/ns4:amountInfo/ns4:reducedAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; how much? </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:judgementInfo/ns4:amountInfo/ns4:reducedAmount" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(3) Final Amount: </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:judgementInfo/ns4:amountInfo/ns4:totalFine" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(4) Was final amount paid in full? </p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:judgementInfo/ns4:amountInfo/ns4:paidStatus/ns4:paidInFullDate">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>


							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; date paid in full: </p>
							</div>
							<div>
								<input name="input47" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:judgementInfo/ns4:amountInfo/ns4:paidStatus/ns4:paidInFullDate" />
				</xsl:attribute>
								</input>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;No,&quot; explain the circumstances:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:judgementInfo/ns4:amountInfo/ns4:paidStatus/ns4:notPaidInfo/ns4:explanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
					<div class="tableRow"><div class="tdStyle1 tditem10col1100px">
					<p>If the matter <em>involves</em> an arbitration or <em>CFTC</em> reparation
						in which
						the individual is a named respondent, complete Items 12-16, as
						appropriate.</p>
						</div>
					</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>
									12. A. Arbitration/<em>CFTC</em>
									reparation claim filed with (
									<em>FINRA</em>
									, AAA,
									<em>CFTC</em>
									, etc.):
								</strong>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:claimFiledWith" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. Location of the Forum</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">Street Address: </div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:forumLocation/ns4:detail/ns4:courtInfo/m1:address/ns1:street1" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">City or County: </div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:forumLocation/ns4:detail/ns4:courtInfo/m1:address/ns1:city" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">State/Country: </div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode" select="ns4:drpData/ns4:forumLocation/ns4:detail/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
							</xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">Postal Code: </div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:forumLocation/ns4:detail/ns4:courtInfo/m1:address/ns1:zipCode" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>C. Docket/Case Name: </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:forumLocation/ns4:detail/ns4:docketCaseName" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>D. Docket/Case Number: </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
				<xsl:value-of
										select="ns4:drpData/ns4:forumLocation/ns4:detail/ns4:courtInfo/m1:docketOrCaseNo" />
				 
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>E. Date notice/process was served</strong>
									(MM/DD/YYYY):
								</p>
							</div>
							<div>
								<input name="input2" type="text" value="mm/dd/yyyy" class="dateField"
									readonly="1">

									<xsl:attribute name="value">
				<xsl:value-of select="ns4:drpData/ns4:forumLocation/ns4:date/m1:date" />
				</xsl:attribute>

								</input>
								<xsl:choose>
								<xsl:when test=" count(ns4:drpData/ns4:forumLocation/ns4:date/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If not exact, provide explanation: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:forumLocation/ns4:date/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>
									13. Pending: Is arbitration/<em>CFTC</em>
									reparation pending?
								</strong>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes">
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>If &quot;No,&quot; complete Items 14 and 15.</strong>
								</p>
							</div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>14. Final:</strong>
								If the arbitration/<em>CFTC</em>
								reparation is not pending, what was the disposition?
							</div>
							<div class="tdStyle1 tditem10col1100px">

								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Award to Applicant (Agent/Representative)'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Award to the Individual (Agent/Representative)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Award to the Individual (Agent/Representative)

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Award to Customer'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Award to Customer

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Award to Customer

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Denied'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Denied

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Denied

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Dismissed'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Dismissed

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Dismissed

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Judgement (other than monetary)'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Judgment (other than monetary)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Judgment (other than monetary)

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='No Action'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										No Action

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										No Action

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Settlement that includes a monetary payment to customer'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Settlement that includes a monetary payment to customer

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Settlement that includes a monetary payment to customer

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Settlement without a monetary payment to customer'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Settlement without a monetary payment to customer

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Settlement without a monetary payment to customer

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Withdrawn'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Withdrawn

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Withdrawn

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionType/ns4:dispositionTypes='Other'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Other (specify)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Other (specify)

									</xsl:otherwise>
								</xsl:choose>
								
								<div class="fakeBox">
									<xsl:value-of
										select="string(ns4:drpData/ns4:dispositionType/ns4:otherInfo/ns4:other)" />
										<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>15. Disposition Date</strong>
								(MM/DD/YYYY):
							</div>
							<div>
								<input name="input21" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
									<xsl:value-of
										select="ns4:drpData/ns4:dispositionType/ns4:otherInfo/ns4:dispositionDate/m1:date" />
									</xsl:attribute>

								</input>
								<xsl:choose>
								<xsl:when test=" count(ns4:drpData/ns4:dispositionType/ns4:otherInfo/ns4:dispositionDate/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If not exact, provide explanation:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:dispositionType/ns4:otherInfo/ns4:dispositionDate/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>16. Monetary Compensation Details
								<p>(If you checked &quot;Award to Customer,&quot; or
									&quot;Settlement that includes a monetary payment to
									customer&quot; in Item 14 or otherwise a payment of money must
									be made to the customer, provide the following information.)</p>
								</strong>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>A. Total Amount:</strong>
								</p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:totalAmount" />
						    </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. The Individual's Portion: Was the individual required to pay any portion
										of
										the total amount?   </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:contributionAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>C. If you answered &quot;Yes,&quot; to Item 16-B,
										indicate:</strong>
								</p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(1) The individual's contribution amount: </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:contributionAmount" />
						    </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(2) Was any portion waived?</p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:reducedAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; how much? </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:reducedAmount" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(3) Final Amount: </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:totalFine" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(4) Was final amount paid in full? </p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:paidStatus/ns4:paidInFullDate">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; date paid in full: </p>
							</div>
							<div>
								<input name="input51" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:paidStatus/ns4:paidInFullDate" />
				</xsl:attribute>
								</input>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;No,&quot; explain the circumstances:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:dispositionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:paidStatus/ns4:explanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
					
					<div class="tableRow">
					
					<p class="guidance" style="width:100%"> <strong>If the matter <em>involves</em> a civil litigation in which the individual is
					 a defendant, complete items 17-23.</strong></p>
					 
					 </div>
					 
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>
									17. Court in which case was filed 
									(<em>if brought in a foreign jurisdiction, provide all the
										information below in English</em>):
								</strong>
							</div>
							<div class="tdStyle1 tditem10col1100px">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:court='Federal Court'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Federal Court

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Federal Court

									</xsl:otherwise>
								</xsl:choose>
								 
								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:court='Military Court'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Military Court

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Military Court

									</xsl:otherwise>
								</xsl:choose>
								 
								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:court='State Court'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										State Court

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										State Court

									</xsl:otherwise>
								</xsl:choose>
								 
								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:court='Foreign Country Court'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Foreign Court

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Foreign Court

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:court='International Court'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										International Court

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										International Court

									</xsl:otherwise>
								</xsl:choose>

								<br />

								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:court='Other'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Other (specify)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Other (specify)

									</xsl:otherwise>
								</xsl:choose>
                                   
								
								<div class="fakeBox">
									<xsl:value-of
										select="string(ns4:drpData/ns4:dispositionInfo/ns4:courtInfo/m1:other)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>A. Name of the Court:</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:name" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. Location of the Court</strong>
								</p>
							</div>
							<div>
								<p></p>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>Street Address: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:street1" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>City or County:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:city" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>State/Country:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode" select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
								</xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>Postal Code:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:zipCode" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>C. Docket/Case Name:</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
									<xsl:value-of select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:docketCaseName" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>D. Docket/Case Number</strong>
									:
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of
												select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:docketOrCaseNo" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>18. Date received by/served on firm</strong>
								(MM/DD/YYYY):
							</div>
							<div>
								<p>
									<input name="input70" type="text" value="mm/dd/yyyy"
										class="dateField" readonly="1">
										<xsl:attribute name="value">
				<xsl:value-of
											select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:date/m1:date" />
				</xsl:attribute>
									</input>
								</p>
								<xsl:choose>
								 <xsl:when test=" count(ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:date/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If not exact, provide explanation:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:dispositionInfo/ns4:appealInfo/ns4:date/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>19. Current Status of the Civil Litigation:</strong>
							</div>
							<div>
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:baseHeader/ns4:status/ns3:pending='Pending'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Pending (Skip to Item 24.)

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Pending (Skip to Item 24.)

										</xsl:otherwise>
									</xsl:choose>

									<br />
								</strong>
								<strong>

									<xsl:choose>
										<xsl:when test="ns4:baseHeader/ns4:status/ns3:onAppeal='On Appeal'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											On Appeal (Complete Items 20-23; and consider Item 24.)

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											On Appeal (Complete Items 20-23; and consider Item 24.)

										</xsl:otherwise>
									</xsl:choose>

									<br />
								</strong>
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:baseHeader/ns4:status/ns3:final='Final'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Final (Complete Items 20-22; and Item 23 if applicable; and
											consider Item 24.)

										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Final (Complete Items 20-22; and Item 23 if applicable; and
											consider Item 24.)

										</xsl:otherwise>
									</xsl:choose>

								</strong>
								<div style="clear:both;"></div>
							</div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>20. Resolution:</strong>								 
							</div>
							<div class="tdStyle1 tditem10col1100px">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Denied'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Denied

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Denied

									</xsl:otherwise>
								</xsl:choose>
								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Dismissed'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Dismissed

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Dismissed

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Judgement (other than monetary)'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Judgment (other than monetary)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Judgment (other than monetary)

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Monetary Judgement to Applicant (Agent/Representative)'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Monetary Judgment to the Individual (Agent/Representative)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Monetary Judgment to the Individual (Agent/Representative)

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Monetary Judgement to Customer'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Monetary Judgment to Customer

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Monetary Judgment to Customer

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='No Action'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										No Action

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										No Action

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Settlement that includes a monetary payment to customer'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Settlement that includes a monetary payment to customer

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Settlement that includes a monetary payment to customer

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Settlement without a monetary payment to customer'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Settlement without a monetary payment to customer

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Settlement without a monetary payment to customer

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Withdrawn'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Withdrawn

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Withdrawn

									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionType/ns4:dispositionTypes='Other'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Other (specify)

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Other (specify)

									</xsl:otherwise>
								</xsl:choose>
								<div class="fakeBox">
									<xsl:value-of
										select="string(ns4:drpData/ns4:resolutionType/ns4:otherInfo/ns4:other)" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>	
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>21. Disposition Date</strong>
								(MM/DD/YYYY):
							</div>
							<div>
								<input name="input63" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:resolutionType/ns4:otherInfo/ns4:dispositionDate/m1:date" />
				</xsl:attribute>

								</input>
								<xsl:choose>
								<xsl:when test=" count(ns4:drpData/ns4:resolutionType/ns4:otherInfo/ns4:dispositionDate/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If not exact, provide explanation:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
									<xsl:value-of
										select="ns4:drpData/ns4:resolutionType/ns4:otherInfo/ns4:dispositionDate/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px"><strong>
								<p>
									22. Monetary Compensation Details 
								</p>
								<p>(If you checked &quot;Monetary Judgment to
									Customer&quot; or &quot;Settlement that includes a monetary
									payment to customer&quot; in Item 20, or otherwise a payment of
									money must be made to the customer, provide the following
									information.)</p>
							</strong></div>
							<div></div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>A. Total Amount:</strong>
								</p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:totalAmount" />
						    </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. Was the individual required to pay any portion
										of
										the total amount?   </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:contributionAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>C. If you answered &quot;Yes,&quot; to Item 22-B,
										indicate:</strong>
								</p>
							</div>
							<div></div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(1) The individual's contribution amount: </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:contributionAmount" />
						    </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(2) Was any portion waived?</p>
							</div>
							<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:reducedAmount">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; how much? </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:reducedAmount" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(3) Final Amount: </p>
							</div>
							<div>
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:totalFine" />
                            </xsl:call-template>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>(4) Was final amount paid in full? </p>
							</div>
						<div class="tdStyle1 tditem10col2" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:paidStatus/ns4:paidInFullDate">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
								</xsl:choose>

							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;Yes,&quot; date paid in full: </p>
							</div>
							<div>
								<input name="input61" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:paidStatus/ns4:paidInFullDate" />
				</xsl:attribute>

								</input>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If &quot;No,&quot; explain the circumstances:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:compensationDetail/ns4:amountInfo/ns4:paidStatus/ns4:explanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>23. On Appeal - Judicial Review: </strong>
								</p>
								<p>
									If the individual appealed, provide the following information.
									(If brought in a foreign jurisdiction, provide all the
										information below in English):
								</p>
							</div>
							<div></div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>A. Action Appealed to: </strong>
								</p>
								<p class="minutia">
									(<em>Provide the name of the federal, military, state, foreign,
										or international court to which the individual appealed</em>):
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:name" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>B. Location of the Court:</strong>
								</p>
							</div>
							<div></div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>Street Address:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:street1" />		
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>City or County:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of
											select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:city" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>State/Country: </p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
							<xsl:call-template name="stateDescription">
			                  <xsl:with-param name="stateCode" select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
			                </xsl:call-template>               
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>Postal Code:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of
											select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:address/ns1:zipCode" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>C. Docket/Case Name: </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of
											select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:docketCaseName" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>D. Docket/Case Number: </strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2">
								<xsl:value-of
											select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:detail/ns4:courtInfo/m1:docketOrCaseNo" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>E. Date Appeal filed</strong>
									(MM/DD/YYYY)
								</p>
							</div>
							<div>
								<input name="input60" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:date/m1:date" />
				</xsl:attribute>
								</input>
								<xsl:choose>
								<xsl:when test=" count(ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:date/m1:exact) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Exact
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Explanation
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Exact
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										Explanation
									</xsl:otherwise>
								</xsl:choose>
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>If not exact, provide explanation:</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:appealInfo/ns4:date/m1:explanationInfo/m1:provideExplanation" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<p>
									<strong>F. Appeal Details (including status):</strong>
								</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of select="ns4:drpData/ns4:appealDetail" />
							</div>
							<div style="clear:both;"></div>
						</div>
						<div class="tableRow">
							<div class="tdStyle1 tditem10col1100px">
								<strong>24. Summary of the Circumstances (Optional):</strong>
								<p>You may use this space to provide a
								 brief summary of the circumstances leading to the customer 
								 complaint, arbitration/<em>CFTC</em> reparation and/or civil litigation
								  as well as the current status or final disposition(s). The 
								  information must fit within the space provided.</p>
							</div>
							<div class="tdStyle1 tditem10col2 tdCustomervalue2"> 
									<xsl:value-of select="ns4:baseHeader/ns4:summary" />
							</div>
							<div style="clear:both;"></div>
						</div>
					</div>

				</div>
			</div>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>