﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma" xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">

	<xsl:template name="CivilDrp">
		<xsl:for-each
			select="n2:drpInfo/ns4:civilJudicialDisclosure/ns4:civilJudicialDrp">
			<link href="style.css" rel="stylesheet" type="text/css" />
			<div id="maiDRPciv">
				<div class="content">
					<h1>CIVIL JUDICIAL ACTION DISCLOSURE REPORTING PAGE (MA-I)</h1>
					
					<h2>CIVIL JUDICIAL ACTION DRP – PART 1</h2>

					<p>
						This
						<strong>Disclosure Reporting Page (DRP MA-I)</strong>
						is an
						<strong>
							<xsl:choose>
								<xsl:when test="count(ns4:baseHeader/ns4:reponseType/m1:add)&gt; 0">

									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>

									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
							</xsl:choose>
							INITIAL or
							<xsl:choose>
								<xsl:when test="count(ns4:baseHeader/ns4:reponseType/m1:amend)&gt; 0">

									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>

									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
							</xsl:choose>
							AMENDED
						</strong>
						response to report details for affirmative response(s) to
						<strong>
							<em>Question(s) 6H</em>
						</strong>
						on Form MA-I.
					</p>
					<p>Check the question(s) to which this DRP pertains:</p>							
					<!--<div class="mainDiv2" style="margin-left:0; margin-right:0;height:20px;">-->
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
					<div border="0">
						<div style="width:100%; display:flex;">
							<div class="fourcol">
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:civilJudicialQuestions='6H(1)(a)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6H(1)(a)
								</strong>
							</div>
							
							<div class="fourcol">
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:civilJudicialQuestions='6H(1)(b)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
										</xsl:otherwise>
									</xsl:choose>

									6H(1)(b)
								</strong>
							</div>
							
							<div class="fourcol">
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:civilJudicialQuestions='6H(1)(c)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
										</xsl:otherwise>
									</xsl:choose>

									6H(1)(c)
								</strong>
							</div>
							
							<div class="fourcol">
								<strong>
									<xsl:choose>
										<xsl:when test="ns4:civilJudicialQuestions='6H(2)'">

											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>

											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
										</xsl:otherwise>
									</xsl:choose>
									6H(2)
								</strong>
							</div>
							
							
						</div>	
						<div class="clear"></div>
					</div>
					</div>				
			<div class="clear mainDiv2" style="margin-left:0; margin-right:0;">							
			<div class="formTable3" style="margin-left:0; margin-right:0;">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="twocol ">
					Is this DRP an amendment that seeks to remove
								a previously filed DRP concerning the individual from the record?
				</div>
				<div class="twocol "> 						
					<xsl:choose>
						<xsl:when
							test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable='Y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							YES
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							NO
						</xsl:when>
						<xsl:when
							test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable='N'">

							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							YES
							<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							NO
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							YES
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							NO
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
			<div class="clear"></div>
			</div>
			<div class="clear formTable3" style="margin-left:0; margin-right:0;">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
			<!--<hr />-->
				<div class="twocol">
					The reason the DRP should be
								removed is:
				</div>
				<div class="twocol" style="padding-top:10px;"> 						
					<p>
									<xsl:choose>
										<xsl:when
											test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered) &gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											The event or <em>proceeding</em>
											was resolved in the individual's favor.
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											The event or <em>proceeding</em>
											was resolved in the individual's favor.
										</xsl:otherwise>
									</xsl:choose>
									<br />
									<xsl:choose>
										<xsl:when
											test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError) &gt; 0">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											The DRP was filed in error.
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											The DRP was filed in error.
										</xsl:otherwise>
									</xsl:choose>
								</p>
				</div>
			</div>  
			<div class="clear"></div>
			</div>
			<div class="formTable3" style="margin-left:0; margin-right:0;">
				<div class="label2_0" style="margin-left:0; margin-right:0;">
					<br />Explain the circumstances:<br></br>                                  
                    <textarea name="textarea4" id="textarea4" cols="52" rows="5">                                    
                                    <xsl:value-of
                                            select="string(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError/m1:explainTheCircumstances)" />                                    
                    </textarea>
				</div>
			</div>		
			</div>		
					
					<p>
						<strong>
							<u>How to Report an Event or <em>Proceeding</em> on a Civil Judicial
								Action DRP:</u>							
						</strong>
						Use a separate DRP for each event or
						<em>proceeding</em>
						. One event may result in more than one affirmative answer to Item
						6H. Separate cases arising out of the same event, and unrelated
						civil judicial actions, must be reported on separate DRPs; if they
						are later consolidated into a single civil judicial action, the
						consolidated action can be reported on one DRP.
					</p>
					
					<!--<div class="mainDiv2" style="margin-left:0; margin-right:0;height:150px;">-->
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>
									<u>DRP On File for This Event:</u>									
							</strong>
								<u>Is an accurate and up-to-date DRP containing the information
								regarding the individual required by this DRP already on file (a)
								in the
								<em>IARD</em>
								or
								<em>CRD</em>
								system (with a Form ADV, BD, or U4), or (b) in the
								<em>SEC's</em>
								EDGAR system (with a Form MA or Form MA-I)?</u>
						</div>
						<div class="twocol">
							<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling or ns4:baseHeader/ns4:filingInfo/ns4:maFiling or ns4:baseHeader/ns4:filingInfo/ns4:matFiling or ns4:baseHeader/ns4:filingInfo/ns4:maiFiling">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
					<div class="clear"></div>
					</div>
					</div>
					
					<p>
						<em><u>Note: The filer may identify a DRP filed by the
							individual directly, or filed by another SEC-registrant about the
							individual as an associated person.</u></em>
					</p>
					<!--<p>
						<em>Note 2: If a Form MA-T is on file that includes disclosures
							for this event, but does not include all the information required
							by this DRP, the disclosures on Form MA-T are not considered
							accurate and up-to-date.</em>
					</p> -->
					<p>
						<strong>If the answer is &quot;Yes,&quot; provide the applicable
							information indicated below that identifies where the DRP may be found.</strong>
					</p>
									
					<!--<div class="mainDiv2" style="margin-left:0; margin-right:0;height:700px;">-->
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName">

										<img src="Images/box-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<strong>1. Form ADV, BD, or U4 Filing:</strong>&#160;&#160;
								For a DRP filed on the
								<em>IARD</em>
								or
								<em>CRD</em>
								system with one of these forms, provide the following
								information:
						</div>						
					</div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							<p>Name on Registration:</p>
						</div>
						<div class="twocol value2" > 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							<p><em>CRD</em> No.:</p>
						</div>
						<div class="twocol value2" >						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber" />
						</div>
					</div>
					
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							<p>Disclosure Occurrence No.:</p>
						</div>
						<div class="twocol value2" > 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber" />
						</div>
					</div>
					
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<strong>2. Form MA Filing:</strong>&#160;&#160;
								For a DRP filed on EDGAR with a Form MA, provide the following
								information:
						</div>						
					</div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Name on Registration:</p>
						</div>
						<div class="twocol value2" > 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>MA Registration Number:</p>
						</div>
						<div class="twocol value2" > 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
						</div>
						<div class="twocol value2" style="margin-left:0; margin-right:0;"> 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Accession number of the filing:</p>
						</div>
						<div class="twocol value2" > 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Accession number of the filing:</p>
						</div>
						<div class="twocol value2" style="margin-left:0; margin-right:0;"> 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<strong> 3. Form MA-I Filing:</strong>&#160;&#160;
								For a DRP filed on EDGAR with a Form MA-I, provide the following
								information:
						</div>
					</div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Name of Individual:</p>
						</div>
						<div class="twocol value2" > 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>MA-I File Number:</p>
						</div>
						<div class="twocol value2" style="margin-left:0; margin-right:0;"> 						
							<xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber" />
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
						</div>
						<div class="twocol"> 						
							<input name="input16" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
										<xsl:value-of
											select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate" />
										</xsl:attribute>
							</input>
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Accession number of the filing:</p>
						</div>
						<div class="twocol value2" style="margin-left:0; margin-right:0;"> 						
							<xsl:value-of select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber" />
						</div>
					</div>	
						<div class="clear"></div>					
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<p class="guidance">
						<!-- <strong>No</strong> -->	
						<strong>NOTE: The completion of all or any part of this form does not
						relieve the individual or any <em>municipal advisor</em> with which the individual is
						associated of the obligation to update any relevant Form MA or <em>IARD</em> or
						<em>CRD</em> records.</strong>
					</p>
					<h2>CIVIL JUDICIAL ACTION DRP – PART 2</h2>
					<p>
						<strong>1. Court Action initiated by: </strong>
					</p>
					
					<!--<div class="mainDiv2" style="margin-left:0; margin-right:0;height:3600px;">-->
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<strong>A. Select the Appropriate Item(s).</strong>
								<p class="minutia">Check all that apply.</p>
						</div>
						<div> 						
							&#160;
						</div>
					</div>
					<div class="threecol">
						<div style="width:100%; display:flex;">
							<div>
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:initiatedBy/m1:initiator='SEC'">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<em>SEC</em>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='State'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								State
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='Foreign Financial Regulatory Authority'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<em>Foreign Financial Regulatory Authority</em>
							</div>
						</div>						
					</div>

					<div class="threecol">
						<div style="width:100%; display:flex;">
							<div>
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:initiatedBy/m1:initiator='CFTC'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<em>CFTC</em>
							</div>
							<div>
								<xsl:choose>
									<xsl:when test="ns4:drpData/ns4:initiatedBy/m1:initiator='SRO'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<em> SRO</em>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='Municipal Advisory Firm'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<em>Municipal Advisory Firm</em>
							</div>
						</div>						
					</div>
					<div class="threecol">
						<div style="width:100%; display:flex;">
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='Other Federal Authority'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Other Federal Authority
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='Commodities Exchange'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Commodities Exchange
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='Private Plantiff'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Private Plaintiff
							</div>
						</div>						
					
					
						<div style="width:100%; display:flex;">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:initiatedBy/m1:initiator='Other'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Other: (specify)
								<div class="fakeBox" style="width:200px;">
								   <xsl:value-of
									select="ns4:drpData/ns4:initiatedBy/m1:other" />
									   <span>
										<xsl:text>&#160;</xsl:text>
									   </span>
								 </div>
						</div>		
					
					</div>
					<div class="clear"></div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" style="margin-left:0; margin-right:0;">
								<p>
									<strong>B. Plaintiff(s): </strong>
								</p>
								<p class="minutia">
									<strong>
										Enter the full name(s) of the plaintiff(s), unless only
										<em>SEC</em>
										and/or
										<em>CFTC</em>
										is/are checked above.
									</strong>
								</p>
								<p class="minutia">
									For a
									<em>foreign financial regulatory authority</em>,
									please provide the full name in English.
								</p>
						</div>
						<div class="twocol"> 	
							<textarea name="textarea4" id="textarea4" rows="5" cols="52"/>	
							
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" style="margin-left:0; margin-right:0;">
								<p>Were all plaintiffs fully identified in the space provided?</p>
						</div>
						<div class="twocol"> 						
							<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:plantiffsInformation/ns4:isPlantiffsIdentified= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:plantiffsInformation/ns4:isPlantiffsIdentified = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								NO
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div >
								<br />
								<strong>2. Defendant(s):</strong>
						</div>
						<!--<hr />-->
						<div>
							<br />
						</div>
					</div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" style="margin-left:0; margin-right:0;">
							<strong>A. Enter the full name(s) of the defendant(s). </strong>
								 For foreign defendant(s), please provide the full name(s) in
								English:
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:defendantInformation/ns4:defendantName" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" style="margin-left:0; margin-right:0;">
							<strong>B. Is the individual a named defendant?</strong>
						</div>
						<div class="twocol">
							<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:defendantInformation/ns4:isADefendant= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:defendantInformation/ns4:isADefendant = 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								NO
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" style="margin-left:0; margin-right:0;">
							If &quot;No,&quot; describe how this action involves
								the individual:
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:defendantInformation/ns4:involementInformation" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<br />
								<strong>3. Sanction(s) or Relief Sought</strong>
								<p class="minutia">(check appropriate items):</p>
						</div>						
					</div>
					<div class="threecol">
						<div style="width:100%; display:flex;">
							<div >
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='BarPermanent'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Bar (Permanent)
							</div>
							<div >
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Exemption'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Exemption
							</div>
							<div >
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Requalification'">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Requalification
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='BarTemporary'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Bar (Temporary/Time <span style="padding-left: 25px;">Limited)</span>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Expulsion'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Expulsion 
							</div>
							<div >
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Rescission'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Rescission
							</div>
							<div >
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Cease and Desist'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Cease and Desist
							</div>
						</div>
					</div>
					<div class="threecol">
						<div style="width:100%; display:flex;">
							
							
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Injunction'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Injunction
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Restitution'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Restitution
							</div>
						
					
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Censure'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Censure
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Money Damage(s) (Private/Civil Complaint)'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Money Damage(s)<br /> <span style="padding-left: 25px;">(Private/Civil Complaint)</span>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Restraining Order'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Restraining <em>Order</em>
							</div>

					
						
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='CivilAdminPenaltyFine'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Civil and Administrative <span style="padding-left: 25px;">Penalty(ies)/Fine(s)</span>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Revocation'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Revocation
							</div>
						</div>
					</div>
					<div class="threecol">
						<div style="width:100%; display:flex;">
							
							
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Denial'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Denial
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Prohibition'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Prohibition
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Suspension'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Suspension
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Disgorgement'">

										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								Disgorgement
							</div>
						
					
					
						
							<div>
								<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Reprimand'">

														<img src="Images/box-checked.jpg" alt="checkbox checked"/>
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
													</xsl:otherwise>
												</xsl:choose>
												Reprimand
							</div>
							<div>
								<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Undertaking'">

														<img src="Images/box-checked.jpg" alt="checkbox checked"/>
													</xsl:when>
													<xsl:otherwise>

														<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Undertaking
							</div>							
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief='Other'">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Other Sanction(s) or Relief Sought: (specify)
								</strong>
						</div>
						<div class="twocol value2">
							<xsl:value-of select="ns4:drpData/ns4:sactionsReliefSought/ns4:other" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							
								<strong>4. A. Filing Date of Court Action</strong> (MM/DD/YYYY):
								<input name="input28" type="text" value="mm/dd/yyyy"
										class="dateField" readonly="1">
										<xsl:attribute name="value">
											<xsl:value-of select="ns4:drpData/ns4:filingDateCourtAction/m1:date" />
										</xsl:attribute>
									</input>
						</div>
						<div class="twocol">
							
								
									
									<xsl:choose>
										<xsl:when test="ns4:drpData/ns4:filingDateCourtAction/m1:exact='Exact'">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Exact
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Explanation
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Exact
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Explanation
										</xsl:otherwise>
									</xsl:choose>
								
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							If not exact, provide explanation:
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:filingDateCourtAction/m1:explanationInfo/m1:provideExplanation" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" >
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							<strong>B. Date Notice/Process was served</strong> (MM/DD/YYYY):
						
						
							<input name="input29" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
									<xsl:value-of
															select="ns4:drpData/ns4:notificationServedInformation/m1:date" />
									</xsl:attribute>
													</input>
													</div>
													<div class="twocol">
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:notificationServedInformation/m1:exact='Exact'">
															<img src="Images/radio-checked.jpg" alt="radio button checked"/>
															Exact
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
															Explanation
														</xsl:when>
														<xsl:otherwise>
															<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
															Exact
															<img src="Images/radio-checked.jpg" alt="radio button checked"/>
															Explanation
														</xsl:otherwise>
													</xsl:choose>
													</div>
						
						
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							If not exact, provide explanation:
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:notificationServedInformation/m1:explanationInfo/m1:provideExplanation" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" >
							<strong>5. Formal Action Was Brought In</strong>
								<p class="minutia">
									
									(<em>If brought in a foreign jurisdiction, provide all the
										information below in English</em>):
								</p>
								<p class="minutia">Check the appropriate box.</p>
						</div>
						<div class="twocol">
							<xsl:choose>
								<xsl:when
									test="ns4:drpData/ns4:courtInfo/m1:court='Federal Court'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Federal Court

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Federal Court

								</xsl:otherwise>
							</xsl:choose>
							 
							<br />
							<xsl:choose>
								<xsl:when
									test="ns4:drpData/ns4:courtInfo/m1:court='Military Court'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Military Court

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Military Court

								</xsl:otherwise>
							</xsl:choose>
							 
							<br />
							<xsl:choose>
								<xsl:when test="ns4:drpData/ns4:courtInfo/m1:court='State Court'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									State Court

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									State Court

								</xsl:otherwise>
							</xsl:choose>
							 
							<br />
							<xsl:choose>
								<xsl:when
									test="ns4:drpData/ns4:courtInfo/m1:court='Foreign Country Court'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Foreign Court

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Foreign Court

								</xsl:otherwise>
							</xsl:choose>

							<br />
							<xsl:choose>
								<xsl:when
									test="ns4:drpData/ns4:courtInfo/m1:court='International Court'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									International Court

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									International Court

								</xsl:otherwise>
							</xsl:choose>

							<br />

							<xsl:choose>
								<xsl:when test="ns4:drpData/ns4:courtInfo/m1:court='Other'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Other :

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Other : (specify)

								</xsl:otherwise>
							</xsl:choose>							
							<div class="fakeBox">
								<xsl:value-of
									select="ns4:drpData/ns4:courtInfo/m1:other" />
							 <span>
							<xsl:text>&#160;</xsl:text>
							</span>
							</div>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>A. Name of the Court:</strong>
							</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:courtInfo/m1:name" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol" >
							<p>
								<strong>B. Location of the Court</strong>
							</p>
						</div>
						<div class="twocol value">							
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Street Address: </p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:courtInfo/m1:address/ns1:street1" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>City or County: </p>
						</div>
						<div class="twocol value2">	
							<span >
                                <xsl:call-template name="stateDescription">
                                    <xsl:with-param name="stateCode" select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:courtInfo/m1:address/ns1:city" />
                                 </xsl:call-template>
                             </span>
                             <span>
                             <xsl:text>&#160;</xsl:text>
                             </span>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>State/Country: </p>
						</div>
						<div class="twocol value2">	
							<span >
                                <xsl:call-template name="stateDescription">
                                    <xsl:with-param name="stateCode" select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
                                 </xsl:call-template>
                             </span>
                             <span>
                             <xsl:text>&#160;</xsl:text>
                             </span>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Postal Code: </p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:courtInfo/m1:address/ns1:zipCode" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p><strong>C. Docket/Case Name: </strong></p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:docketCaseName" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
									<strong>D. Docket/Case Number: </strong>
								</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:courtInformation/ns4:courtInfo/m1:docketOrCaseNo" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<strong>6. Employing Firm:</strong>&#160;&#160;
								<p class="minutia">
									Provide the full legal name of the individual's employing firm, if any, when the
									activity occurred which led to the civil judicial action (if there
									was no such employing firm at that time, enter
									&quot;None&quot;). Enter the employing firm's MA and
									<em>CRD</em>
									registration numbers below, if any.
								</p>
						</div>						
					</div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>A. Employing Firm:</strong>
							</p>
						</div>
						<div class="twocolvalue2">	
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:employingFirmInfo/ns4:name" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
									<strong>B. <em>Municipal Advisor</em> Registration Number, if any: </strong>
								</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:employingFirmInfo/ns4:registrationNumber" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
								<p>
									<strong>C. <em>CRD</em> Number, if any: </strong>
								</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:employingFirmInfo/ns4:crdNumber" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<br /><strong>7. A. Principal Product Type</strong>
								<p class="minutia">(check appropriate item):</p>
						</div>						
					</div>
					<div class="threecol">
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='No Product']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								No Product
							</div>
							
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='AnnuityCharitable']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Annuity &#8211; Charitable
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Direct Investment(s) - DPP &amp; LP Interest(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Direct Investment &#8211; DPP <span style="padding-left:25px;">&amp; LP Interest</span>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='OilAndGas']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Oil &amp; Gas
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Annuity(ies) - Fixed']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Annuity &#8211; Fixed  
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='EquipmentLeasing']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Equipment Leasing
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Options']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Options
							</div>
						
				
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Annuity(ies) - Variable']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Annuity &#8211; Variable
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Equity Listed (Common &amp; Preferred Stock)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Equity Listed (Common <span style="padding-left:25px;">&amp; Preferred Stock)</span>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Penny Sock(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Penny Stock
							</div>
						
					
					
						
							<div>
								<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='BankingProduct']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Banking Product (other <span style="padding-left:25px;">than CD)</span>
							</div>
							
						
					
					</div>
					<div class="threecol">
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Equity - OTC']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Equity OTC
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='PrimeBankInstrument']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Prime Bank Instrument
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Futures - Commodity']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Futures &#8211; Commodity
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Promissory Note']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Promissory Note
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='CD(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								CD
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Futures - Financial']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Futures &#8211; Financial  
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Real Estate Security']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Real Estate Security
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Commodity Option(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Commodity Option
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Index Option(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Index Option
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Security Futures']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Security Futures
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Debt - Asset Backed']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt &#8211; Asset Backed
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Insurance']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Insurance
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Security-based Swap']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Security-based Swap
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Debt - Corporate']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt &#8211; Corporate
							</div>
						
					
					</div>
					<div class="threecol">
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Investment Contract(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Investment Contract
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Swap']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Swap
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Debt - Government']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt &#8211; Government 
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Money Market Fund(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Money Market Fund
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Unit Investment Trust(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Unit Investment Trust
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Debt - Municipal']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Debt &#8211; Municipal
							</div>
						
					
					
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Mutual Fund(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Mutual Fund 
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Viatical Settlement']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Viatical Settlement
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Derivative(s)']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Derivative
							</div>
						
					
							<div style="width:100%;">
								<strong>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes[ns4:product='Other']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Other Principal Product <span style="padding-left:25px;">Type:</span>
								</strong>
								(specify)<br />
							</div>
							<div class="value2" style="padding-left:25px;">
								<xsl:value-of
									  select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:productOther)" />
								 <span>
								<xsl:text>&#160;</xsl:text>
							   </span>
						   </div>							
						
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>B. Other Product Types?</strong>
						</div>
						<div class="twocol">	
							<xsl:choose>
								<xsl:when
									test="ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:otherProductTypes">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									NO
								</xsl:when>
								<xsl:otherwise>

									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									YES
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									NO
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;Yes,&quot; describe each additional product type: (specify)</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:otherProductTypes)" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>8. Allegations:</strong>&#160;&#160;
								<p class="minutia">Describe the allegations related to this civil
									action. (The response must fit within the space provided.)</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:matterInformation/ns4:allegationsDescription)" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>9. Current Status:  </strong>
						</div>
						<div class="twocol">	
							<xsl:choose>
									<xsl:when test="ns4:baseHeader/ns4:status/ns3:pending">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
										Pending  
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										Pending
									</xsl:otherwise>
								</xsl:choose>

								<br />
								<xsl:choose>
									<xsl:when test="ns4:baseHeader/ns4:status/ns3:onAppeal">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
										On Appeal  
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										On Appeal
									</xsl:otherwise>
								</xsl:choose>
								<br />
								<xsl:choose>
									<xsl:when test="ns4:baseHeader/ns4:status/ns3:final">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
										Final 
									</xsl:when>
									<xsl:otherwise>

										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										Final
									</xsl:otherwise>
								</xsl:choose>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>10. Pending: </strong>&#160;
								<span class="minutia">
									<strong>If you checked &quot;Pending&quot; in Item 9, provide
										the following information:</strong>
								</span>
						</div>						
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>A. Date Served:</strong>&#160;&#160;
								<span class="minutia">The date that notice or other process 
								was served (MM/DD/YYYY):</span>
							</p>
						</div>
						<div class="twocol">	
							<div border="0">
								<div style="width:100%; display:flex;">
									<div>
										<input name="input28" type="text" value="mm/dd/yyyy"
											class="dateField" readonly="1">
											<xsl:attribute name="value">
												<xsl:value-of
													select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:servedInformation/m1:date)" />
											</xsl:attribute>
										</input>
									</div>
									<div>
										<xsl:choose>
											<xsl:when
												test="ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:servedInformation/m1:exact='Exact'">
												<img src="Images/radio-checked.jpg" alt="radio button checked"/>
												Exact
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Explanation
											</xsl:when>
											<xsl:when
												test="ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:servedInformation/m1:explanationInfo/m1:explanation='Explanation'">
												 <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Exact
												<img src="Images/radio-checked.jpg" alt="radio button checked"/>
												Explanation
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Exact
												<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
												Explanation
											</xsl:otherwise>
										</xsl:choose>
									</div>
									
								</div>
							</div>
								
								
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If not exact, provide explanation:</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:servedInformation/m1:explanationInfo/m1:provideExplanation)" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>B. Limitation or Restrictions: </strong>
								Are there any limitations or restrictions currently in effect?
								 
							</p>
						</div>
						<div class="twocol">	
							<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions= 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								NO
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If the answer is &quot;Yes,&quot; provide details:</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:pendingInformation/ns4:limitationsRestrictions/ns4:details)" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div>
							<strong>11. On Appeal &#8211; Judicial Review: </strong>&#160;&#160;
								<span class="minutia">If the individual appealed, provide the following information.
									(<em>If brought in a foreign jurisdiction, provide all the
										information below in English.</em>):</span>
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>A. Action Appealed to: </strong>
							</p>
							<p>
								(<em>Provide the name of the federal, state, foreign, or
									international court
									to whom the individual appealed.</em>)
							</p>
						</div>
						<div class="twocol value2">	
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:name" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>B. Location of the Court</strong>
							</p>
						</div>
						<div class="twocol value">							
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Street Address: </p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:street1" />
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:street2" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>City or County: </p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:city" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>State/Country: </p>
						</div>
						<div class="twocol value2">
							<span >
                                <xsl:call-template name="stateDescription">
                                    <xsl:with-param name="stateCode" select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
                                 </xsl:call-template>
                             </span>
                             <span>
                             <xsl:text>&#160;</xsl:text>
                             </span>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>Postal Code: </p>
						</div>
						<div class="twocol value2">
								<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:zipCode" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>C. Docket/Case Name: </strong>
							</p>
						</div>
						<div class="twocol value2">
								<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:docketCaseName" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>D. Docket/Case Number: </strong>
							</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
											select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:docketOrCaseNo" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>E. Date Appeal filed (MM/DD/YYYY)</strong>:									
							</p>
						</div>
						<div class="twocol">
								<input name="input28" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
										<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:dateInformation/m1:date" />
									</xsl:attribute>
								</input>
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:dateInformation/m1:exact)&gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Exact</label>
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:dateInformation/m1:explanationInfo/m1:explanation) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Explanation</label>
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If not exact, provide explanation:</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:dateInformation/m1:explanationInfo/m1:provideExplanation)" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>F. Appeal Details (including status):</strong>
							</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:details)" />
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>G. Limitation or Restrictions: </strong>
								Are there any limitations or restrictions currently in effect
								while on appeal?
							</p>
						</div>
						<div class="twocol">
							<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions= 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								NO
						</div>
					</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If the answer is &quot;Yes,&quot; provide details:</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:appealInformation/ns4:limitationsRestrictions/ns4:details)" />
						</div>
					</div>	
					</div>
					</div>
					<div class="clear"></div>
					
					<div class="guidance">
						<p>If you checked &quot;Final&quot; or &quot;On Appeal&quot; in
							Item 9, complete Items 12 through 14.
						<br />
							For Pending Actions, skip to Item 15.
							<br />
						</p>
					</div>
					
					<!--<div class="mainDiv2" style="margin-left:0; margin-right:0;height:3900px;">-->
					<div class="mainDiv2" style="margin-left:0; margin-right:0;">
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<br /><strong>12. A. Resolution: </strong>&#160;How was the action resolved?
								<p class="minutia">									
									<em>Check all the applicable boxes that reflect the most recent 
									resolution of the action by a court, whether or not any part of 
									the resolution is on appeal.  If any part of the resolution is on appeal, 
									identify in Item 12-B which part is currently on appeal. </em>
								</p>
						</div>						
					</div>
					<div class="threecol">
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Consent']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Consent 
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Judgement Rendered']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Judgment Rendered  
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Settled']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Settled
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Decision']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Decision
							</div>
						
					</div>
						<div class="threecol">
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Stipulation and Consent']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Stipulation and Consent
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Withdrawn']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Withdrawn
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Decision And Order of Offer Settlement']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Decision &amp;
								<em>Order</em>
								of Offer of Settlement
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Opinion']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Opinion
							</div>
							
							
						</div>
					
					<div class="threecol">
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Dismissed']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Dismissed
							</div>
							<div style="width:33%;">
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Order']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								<em>Order</em>
							</div>
							<div style="width:34%;">
								<p></p>
							</div>
						
					
					
						
							<div style="width:100%;">
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Other']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Other: (specify)
								<div class="fakeBox">
								   <xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:otherDescription" />
								 <span>
									<xsl:text>&#160;</xsl:text>
								</span>
							   </div>
							</div>
							
						
					
					</div>
					<div class="clear"></div>
					<div class="twocol">
						<div style="width:100%; display:flex;">
							<div style="width:100%;">
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:resolutionInfo[ns4:resolutionTypes='Appealed']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Appealed
								<div style="margin-left: 20px;">
									<p>
										<xsl:choose>
											<xsl:when
												test=" count(ns4:drpData/ns4:resolutionInfo[ns4:appealType='Affirmed']) &gt; 0">
												<img src="Images/box-checked.jpg" alt="checkbox checked"/>
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Affirmed
									</p>
									<p>
										<xsl:choose>
											<xsl:when
												test=" count(ns4:drpData/ns4:resolutionInfo[ns4:appealType='Vacated Nunc Pro Tunc / ab initio']) &gt; 0">
												<img src="Images/box-checked.jpg" alt="checkbox checked"/>
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Vacated Nunc Pro Tunc/ab initio
									</p>
									<p>
										<xsl:choose>
											<xsl:when
												test=" count(ns4:drpData/ns4:resolutionInfo[ns4:appealType='Vacated &amp; Returned For Further Action']) &gt; 0">
												<img src="Images/box-checked.jpg" alt="checkbox checked"/>
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Vacated &amp; Returned For Further Action
									</p>
									<p>
										<xsl:choose>
											<xsl:when
												test=" count(ns4:drpData/ns4:resolutionInfo[ns4:appealType='Vacated / Final']) &gt; 0">
												<img src="Images/box-checked.jpg" alt="checkbox checked"/>
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Vacated/Final
									</p>
									<p>
										<xsl:choose>
											<xsl:when
												test=" count(ns4:drpData/ns4:resolutionInfo[ns4:appealType='Other']) &gt; 0">
												<img src="Images/box-checked.jpg" alt="checkbox checked"/>
											</xsl:when>
											<xsl:otherwise>
												<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Other:									
										<div class="fakeBox">
										   <xsl:value-of
												select="string(ns4:drpData/ns4:resolutionInfo/ns4:appealOther)" />
										 <span>
										<xsl:text>&#160;</xsl:text>
									   </span>
									   </div>
									</p>
								</div>
							</div>							
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>B. Explanation:</strong>
							</p>
							<p class="minutia">
								 
								<em>If more than one box in Item 12-A. is checked, or Other is checked, or Item 12-A. 
								otherwise does not adequately summarize the type of resolution, provide an explanation.  
								For example, if the individual appealed all or part of a resolution by the regulator or court, 
								indicate what is being appealed.</em>
							</p>
						</div>
						<div class="twocol value2">							
							<xsl:value-of
							select="string(ns4:drpData/ns4:resolutionInfo/ns4:explanantion)" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->					
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>
									C.
									<em>Order</em>:
									 
								</strong>
							</p>
							<p class="minutia">
								<strong>If
								<em>Order</em>
								is checked above in Item 12-A,</strong> does the
								<em>order</em>
								constitute a final
								<em>order</em>
								based on violations of any laws or regulations that prohibit
								fraudulent, or deceptive conduct?
							</p>
						</div>
						<div class="twocol">							
							<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionInfo/ns4:isFinalOrder= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionInfo/ns4:isFinalOrder= 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO
						</div>
					</div></div>	
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
						<strong>13. Resolution Date</strong> (MM/DD/YYYY):&#160;&#160;								
						<p class="minutia">
							(<em>For a resolution that is being appealed in part, the date
								to be provided should be the date on which the regulator or
								court provided its resolution.</em>)
						</p>
						
						
							<input name="input39" type="text" value="mm/dd/yyyy"
								class="dateField" readonly="1">
								<xsl:attribute name="value">
									<xsl:value-of
											select="ns4:drpData/ns4:resolutionInfo/ns4:resolutionDate/m1:date" />
								</xsl:attribute>
							</input>
							</div>
							<div class="twocol">
							<xsl:choose>
								<xsl:when
									test="count(ns4:drpData/ns4:resolutionInfo/ns4:resolutionDate/m1:exact)&gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							<label>Exact</label>
							<xsl:choose>
								<xsl:when
									test="count(ns4:drpData/ns4:resolutionInfo/ns4:resolutionDate/m1:explanationInfo/m1:explanation) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							<label>Explanation</label>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->					
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If not exact, provide explanation:</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:resolutionInfo/ns4:resolutionDate/m1:explanationInfo/m1:provideExplanation" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->	
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>14. Resolution Detail</strong>
						</div>
						<div class="clear"></div>
					<!--<hr />-->
					</div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>
									A. Sanction(s): Was/were any Sanction(s)
									<em>Ordered</em>
									or Relief Granted?
								</strong>
							</p>
						</div>
						<div class="twocol">
							<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:sactionsReliefSought/ns4:sanctionRelief)">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO, none were <em>ordered</em> or granted.

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button checked" />
										YES
										<img src="Images/radio-checked.jpg" alt="radio button unchecked" />
										NO, none were <em>ordered</em> or granted.
									</xsl:otherwise>
								</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div style="margin-left:0; margin-right:0;">
							<p>
								<strong>B.
									If &quot;Yes,&quot; check each individual sanction
									<em>ordered</em> and/or relief granted below:
								</strong>
							</p>
							<p class="minutia"></p>
						</div>
						<div>
							&#160;
						</div>
					</div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div class="threecol">						
							
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='BarPermanent']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Bar (Permanent)
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Exemption']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Exemption
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Requalification']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Requalification
								</div>
							
						
											
							
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='BarTemporary']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Bar (Temporary/Time <span style="padding-left:25px;">Limited)</span>
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Expulsion']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Expulsion
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Rescission']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Rescission
								</div>
							
						
					
											
							
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Cease and Desist']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Cease and Desist
								</div>
					</div>
					<div class="threecol">			
						<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Injunction']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Injunction
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Restitution']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Restitution*
								</div>
							
					
											
							
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Censure']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Censure  
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='MoneyDamages']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Money Damage(s) <span style="padding-left:21px;">(Private/Civil Complaint)<span style="padding-left:21px;">*</span></span>
								</div>
								<div>
									<xsl:choose>
										<xsl:when
											test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Restraining']) &gt; 0">
											<img src="Images/box-checked.jpg" alt="checkbox checked"/>
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Restraining <em>Order</em>
								</div>
													
					
					
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='CivilAdminPenaltyFine']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Civil/Administrative <span style="padding-left:25px;">Penalty(ies)/Fine(s)*</span>
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Revocation']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Revocation
							</div>
					</div>
					<div class="threecol">
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Denial']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Denial  
							</div>
						
					
					
						
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Prohibition']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Prohibition
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Suspension']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Suspension
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Disgorgement']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Disgorgement*
							</div>
						
					
					
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Reprimand']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Reprimand 
							</div>
							<div>
								<xsl:choose>
									<xsl:when
										test=" count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered[ns4:saction='Undertaking']) &gt; 0">
										<img src="Images/box-checked.jpg" alt="checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Undertaking
							</div>
												
						
					</div>
					</div>
					<div class="clear"></div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>* Monetary Sanction(s):</strong>
								Were one or more sanctions
								<em>ordered</em> that require a monetary payment?
							</p>
						</div>
						<div class="twocol">
							<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:amountOrdered) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										YES
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										NO
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										YES
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										NO
									</xsl:otherwise>
							</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;Yes,&quot; enter the total amount <em>ordered</em>:
								</p>
						</div>
						<div class="twocol">
							<xsl:call-template name="format_to_dollar">
						        <xsl:with-param name="money" select="ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:amountOrdered" />
						    </xsl:call-template>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								<strong>
									Other Sanctions <em>Ordered</em> or Relief Granted
								(<em>list each such additional sanction or relief</em>):
								</strong>
							</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:otherExplanation)" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div >
							<strong>C. Sanction Detail</strong>
								<p class="minutia">Provide the details of the following specific
									sanctions, if checked above in Item 14-B.</p>
								<strong>(1) Barred, <em>Enjoined</em>, or Suspended: </strong>
								<p>
									If you selected one or more of these sanctions in Item 14-B. 
									above, provide the corresponding information.
								</p>
								<strong>(a) Barred</strong>
						</div>					
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(i) Duration (length of time): </p>
						</div>
						<div class="twocol">
							<xsl:choose>
										<xsl:when test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:permanent">
											<img src="Images/radio-checked.jpg" alt="radio button checked"/>
											Permanent (not limited by length of time).
											<br />
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Temporary/Time Limited.

										</xsl:when>
										<xsl:when test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime">
                                           <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
                                            Permanent (not limited by length of time).
                                            <br />
                                            <img src="Images/radio-checked.jpg" alt="radio button checked"/>
                                            Temporary/Time Limited.

                                        </xsl:when>
										<xsl:otherwise>
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Permanent (not limited by length of time).
											<br />
											<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
											Temporary/Time Limited.
										</xsl:otherwise>
									</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="fourcol">
							Specify the:  
						</div>
						<div class="fourcol">
							Days
							<input name="input78" type="text" readonly="1">
								<xsl:attribute name="value">
								<xsl:value-of
								select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime/m1:days)" />
								</xsl:attribute>
							</input>
						</div>
						<div class="fourcol">
							Months
							<input name="input79" type="text" readonly="1">
								<xsl:attribute name="value">
								<xsl:value-of
								select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime/m1:months)" />
								</xsl:attribute>
							</input>
						</div>
						<div class="fourcol">
							Years
							<input name="input80" type="text" readonly="1">
								<xsl:attribute name="value">
								<xsl:value-of
								select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime/m1:years)" />
								</xsl:attribute>
							</input>
						</div>
												
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(ii) Start Date (MM/DD/YYYY):</p>
						
						
							
							<input name="input77" type="text" value="mm/dd/yyyy"
							class="dateField" readonly="1">
								<xsl:attribute name="value">
								<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:startDate/m1:date)" />
								</xsl:attribute>
							</input>
							</div>
							<div class="twocol">
							<xsl:choose>
							<xsl:when test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:startDate/m1:exact)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
							</xsl:choose>
							<label>Exact</label>
							<xsl:choose>
							<xsl:when
								test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:startDate/m1:explanationInfo/m1:explanation) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
							</xsl:otherwise>
							</xsl:choose>
							<label>Explanation</label>
							
							</div>
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iii) End Date (MM/DD/YYYY):</p>
						
						
							
								<input name="input81" type="text" value="mm/dd/yyyy"
									class="dateField">
									<xsl:attribute name="value">
									<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:endDate/m1:date)" />
									 </xsl:attribute>
								</input>
								</div>
								<div class="twocol">
								<xsl:choose>
									<xsl:when test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:endDate/m1:exact)&gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Exact</label>
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:endDate/m1:explanationInfo/m1:explanation) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Explanation</label>
							
							</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol" style="margin-left:0; margin-right:0;">
							<p>(iv) Description: Provide remaining details, including any
								explanation boxes checked above, and the registration
								capacities affected (General Securities Principal, Financial
								Operations Principal, etc.):</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:barred/ns4:description)" />
						</div>
					</div>
					</div>
					
						<!-- 
								<div class="guidance">
									If, in the above action, the individual received one or more bars from
									registration capacities, associations, and / or other
									activities, and the terms specify different time periods,
									<br />
									<div style="text-align: center;">report the additional details below:</div>
								</div>
						-->
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<br /><br />
								<strong>(b) <em>Enjoined</em></strong>
						</div>						
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(i) Duration (length of time): </p>
						</div>
						<div class="twocol">
							<xsl:choose>
								<xsl:when test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:permanent">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									Permanent (not limited by length of time).
									<br />
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									Temporary/Time Limited.

								</xsl:when>
								<xsl:when test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime">
								   <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									Permanent (not limited by length of time).
									<br />
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									Temporary/Time Limited.

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									Permanent (not limited by length of time).
									<br />
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									Temporary/Time Limited.
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="threecol">
							Specify the:  Days
							<input name="input" type="text" readonly="1">
								<xsl:attribute name="value">
									<xsl:value-of
									select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime/m1:days)" />
							  </xsl:attribute>
							</input>
						</div>
						<div class="threecol">
							Months
							<input name="input" type="text" readonly="1">
								<xsl:attribute name="value">
									 <xsl:value-of
									select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime/m1:months)" />
							   </xsl:attribute>
							</input>
						</div>
						<div class="threecol">		
							Years
							<input name="input" type="text" readonly="1">
								<xsl:attribute name="value">
									 <xsl:value-of
									select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime/m1:years)" />
						  </xsl:attribute>
							</input>
						</div>						
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(ii) Start Date (MM/DD/YYYY):</p>
						
						
							
								<input name="input" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
									<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:startDate/m1:date)" />
								</xsl:attribute>
								</input>
							</div>
							<div class="twocol">
								<xsl:choose>
									<xsl:when test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:startDate/m1:exact)&gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Exact</label>
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:startDate/m1:explanationInfo/m1:explanation) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Explanation</label>
							
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iii) End Date (MM/DD/YYYY):</p>
						
						
							
								<input name="input" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
									<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:endDate/m1:date)" />
									 </xsl:attribute>
								</input>
								</div>
								<div class="twocol">
								<xsl:choose>
									<xsl:when test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:endDate/m1:exact)&gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Exact</label>
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:endDate/m1:explanationInfo/m1:explanation) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
								<label>Explanation</label>
							
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iv) Description: 
							<span class="minutia">Provide remaining details, including any explanation
								boxes checked above, and the registration capacities affected
								(General Securities Principal, Financial Operations Principal,
								etc.): </span></p>
						</div>
						<div class="twocol value2">
							<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:enjoined/ns4:description)" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<br /><br />
								<strong>(c) Suspended</strong>
						</div>						
					</div>
					<div class="clear"></div>
					<!--<hr />-->					
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(i) Duration (length of time): </p>
						</div>
						<div class="twocol">
							<xsl:choose>
								<xsl:when test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:permanent">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Permanent (not limited by length of time).
									<br />
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Temporary/Time Limited.

								</xsl:when>
								<xsl:when test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime">
								   <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Permanent (not limited by length of time).
									<br />
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									Temporary/Time Limited.

								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Permanent (not limited by length of time).
									<br />
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									Temporary/Time Limited.
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="fourcol">
						Specify the:
						</div>
						<div class="fourcol">
							Days
							<input name="input2" type="text" readonly="1">
								<xsl:attribute name="value">
									<xsl:value-of
											select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime/m1:days)" />
								</xsl:attribute>
							</input>
							</div>
							<div class="fourcol">
							Months
							<input name="input2" type="text" readonly="1">
								<xsl:attribute name="value">
							<xsl:value-of
									select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime/m1:months)" />
							</xsl:attribute>
							</input>
							</div>
							<div class="fourcol">
							Years
							<input name="input2" type="text" readonly="1">
								<xsl:attribute name="value">
							<xsl:value-of
									select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime/m1:years)" />
							</xsl:attribute>
							</input>
							</div>					
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(ii) Start Date:</p>
						
						
							
								<input name="input2" type="text" value="mm/dd/yyyy"
								class="dateField" readonly="1">
								<xsl:attribute name="value">
								<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:startDate/m1:date)" />
								</xsl:attribute>
								</input>
								</div>
								<div class="twocol">
								<xsl:choose>
								<xsl:when test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:startDate/m1:exact)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
								</xsl:choose>
								<label>Exact</label>
								<xsl:choose>
								<xsl:when
								test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:startDate/m1:explanationInfo/m1:explanation) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
								</xsl:otherwise>
								</xsl:choose>
								<label>Explanation</label>
							
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iii) End Date</p>
						
						
							
								<input name="input2" type="text" value="mm/dd/yyyy"
								class="dateField" readonly="1">
								<xsl:attribute name="value">
								<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:endDate/m1:date)" />
								</xsl:attribute>
								</input>
								</div>
								<div class="twocol">
								<xsl:choose>
								<xsl:when test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:endDate/m1:exact)&gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
								</xsl:choose>
								<label>Exact</label>
								<xsl:choose>
								<xsl:when
									test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:endDate/m1:explanationInfo/m1:explanation) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
								</xsl:choose>
								<label>Explanation</label>
							
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iv) Description: </p>
							<p class="minutia">Provide remaining details, including any explanation
								boxes checked above, and the registration capacities affected
								(General Securities Principal, Financial Operations Principal,
								etc.):</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:suspended/ns4:description)" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							
							<strong>(2) Requalification:  </strong>
							Was requalification by examination, retraining, or other process
							a condition of a sanction?
						</div>
						<div class="twocol">
							<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:isReqaulificationRequired= 'Y'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:isReqaulificationRequired= 'N'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />

									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								NO
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div>
								If the individual received in the above one or 
								more requalifications from registration capacities, associations, 
								and/or other activities, and the terms specify different 
								time periods, report each in a separate entry.
						</div>						
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								(a) Length of time given to requalify, retrain, or
									complete other process:
							</p>
						</div>						
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:noTimePeriodSpecified) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked"/>
										No time period is specified.<br />
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Time period is specified:
									</xsl:when>
									<xsl:when
                                        test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime) &gt; 0">
                                        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
                                        No time period is specified.<br />
                                         <img src="Images/radio-checked.jpg" alt="radio button checked"/>
                                        Time period is specified:
                                    </xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										No time period is specified.<br />
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
										Time period is specified:
									</xsl:otherwise>
								</xsl:choose>

								&#160;&#160;Days
								<input name="input24" type="text" readonly="1" size="10">
									<xsl:attribute name="value">
										<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime/m1:days)" />
		 							</xsl:attribute>
		 						</input>
		 						
								&#160;&#160;&#160;&#160;Months
								<input name="input24" type="text" readonly="1" size="10">
									<xsl:attribute name="value">
				                <xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime/m1:days)" />
		                              </xsl:attribute>
								</input>

								&#160;&#160;&#160;&#160;Years
								<input name="input60" type="text" readonly="1" size="10">
									<xsl:attribute name="value">
				                    <xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime/m1:years)" />
			                         </xsl:attribute>
								</input>
						</div>
						
					</div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(b) Type of examination, retraining, or other process
									required:</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:typeRequired)" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(c) Was the condition satisfied?</p>
						</div>
						<div class="twocol">
							<xsl:choose>
								<xsl:when
									test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:satisfied/ns4:satisfied) &gt; 0">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									NO
								</xsl:when>
								<xsl:when
									test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:notSatisfied/ns4:satisfied) &gt; 0">
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									YES
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									NO
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button checked" />
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									NO
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;Yes,&quot; provide the date (MM/DD/YYYY): </p>
						</div>
						<div class="twocl">							
							<span class="label">
								<input name="input4" type="text" value="mm/dd/yyyy"
									class="dateField" readonly="1">
									<xsl:attribute name="value">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:satisfied/ns4:satisfiedDate)" />
							</xsl:attribute>
								</input>
							</span>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;No,&quot; explain the circumstances:</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="string(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:notSatisfied/ns4:explanation)" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="label1_0" style="margin-left:0; margin-right:0;">
							<strong>3) Monetary Sanction(s): </strong>
								If you indicated in Item 14-B above that one or more monetary
								sanctions were <em>ordered</em>,
								provide the following information.
						</div>						
					</div>
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								(a) Total Amount <em>Ordered</em>:
							</p>
						</div>
						<div class="twocol">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:totalAmountOrdered" />
                            </xsl:call-template>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								(b) Portion levied against the individual:
							</p>
						</div>
						<div>							
						</div>
					</div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>
								(i) Amount <em>Ordered</em>:
							</p>
						</div>
						<div class="twocol">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:amountOrdered" />
                            </xsl:call-template>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(ii) Was any portion waived?</p>
						</div>
						<div class="twocol">
							<xsl:choose>
								<xsl:when
									test="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:waivedPortion">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									NO
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									YES
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									NO
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;Yes,&quot; how much? </p>
						</div>
						<div class="twocol">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:waivedPortion" />
                            </xsl:call-template>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iii) Final Amount: </p>
						</div>
						<div class="twocol">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:finalAmount" />
                            </xsl:call-template>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>(iv) Was final amount paid in full? </p>
						</div>
						<div class="twocol">
							<xsl:choose>
								<xsl:when
									test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:paidInFull/ns4:amountPaidInFull) &gt; 0 ">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									NO
								</xsl:when>
								<xsl:when
									test="count(ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:notPaidInFull/ns4:amountNotPaidInFull) &gt; 0 ">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/>
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									NO
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									YES
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>
									NO
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;Yes,&quot; date paid in full: </p>
						</div>
						<div class="twocol">
							<span class="label">
							<input name="input6" type="text" value="mm/dd/yyyy"
								class="dateField" readonly="1">
								<xsl:attribute name="value">
							<xsl:value-of
									select="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:paidInFull/ns4:paidDate" />
							</xsl:attribute>
							</input>
							</span>
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<p>If &quot;No,&quot; explain the circumstances:</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of
										select="ns4:drpData/ns4:civilJudicialInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:notPaidInFull/ns4:explanation" />
						</div>
					</div></div>
					<div class="clear"></div>
					<!--<hr />-->
					<div class="formTable3" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div class="twocol">
							<strong>15. Summary of Circumstances (Optional):</strong>
								<p class="minutia">You may use this space to provide a brief summary of
									the circumstances leading to the action, allegation(s),
									finding(s) and disposition(s), if any. Include any relevant
									information on the current action status, and on any terms,
									conditions, and dates not already provided above, and any other
									relevant information. The information must fit within the
									space provided.</p>
						</div>
						<div class="twocol value2">
							<xsl:value-of select="ns4:baseHeader/ns4:summary" />
						</div>
					</div></div>
					</div>
					<div class="clear"></div>
					
					
					
					
					
					
					
		
				
				
				
				</div>
			</div>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>