<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:n1="http://www.sec.gov/edgar/mawfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:state="http://www.sec.gov/edgar/statecodes">
	
	<xsl:import href="util.xsl"/>
	
	<xsl:output
		method="html"
		indent="no"
		encoding="UTF-8"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />
	<xsl:variable name="fieldWidth">25</xsl:variable>
	<xsl:template
		match="/">
		<html
			xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<meta
					http-equiv="Content-Type"
					content="text/html; charset=utf-8" />
				<title>MA-W Print</title>
				<link
					href="css/MAW_print.css"
					rel="stylesheet"
					type="text/css"
					media="all" />
			</head>
			<body
				lang="en-US"
				text="#000000"
				bgcolor="#ffffff">
				<xsl:call-template
					name="header" />
				<xsl:apply-templates />
			</body>
		</html>
	</xsl:template>

	<!-- Header -->
	<xsl:template
		name="header">
		<div
			id="MAW"
			style="width:650px; margin:20px 20px">
			<div>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div style="width:100%;margin-left:0; margin-right:0;">
							<h1
								class="center">
								FORM MA-W
								<br />
								Notice of Withdrawal from Registration as a <em>Municipal Advisor</em>
							</h1>
						</div>
					</div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0; margin-top:15px;">
						<div style="margin-left:0; margin-right:0; width:19%;">
							<span
								class="secLogo">
								<img
									src="Images/secLogo.jpg"
									alt="SEC seal." />
							</span>
						</div>
						<div style="margin-left:150px; margin-top:-100px; margin-right:0; width:56%;">
							<h2
								class="center">
								UNITED STATES
								<br />
								SECURITIES AND EXCHANGE COMMISSION
								<br />
								Washington, D.C. 20549
							</h2>
						</div>
						<div style="margin-left:0; margin-right:-40px; width:25%; float:right; margin-top:-90px;">
							<div
								id="OMB">
								<div						
									id="OMB"
									class="table">
									<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
									<div style="width:100%; margin-left:0; margin-right:0; height:22px;" class="th">
										OMB APPROVAL
										</div>
									</div>
									<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
										<div style="width:100%; margin-left:0; margin-right:0; margin-top:2px; margin-bottom:1px;" class="td">
											<p> 
											OMB Number:
										
											3235-0681</p></div>
									</div>
									<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
										     <div style="width:100%; margin-left:0; margin-right:0; margin-top:1px; margin-bottom:1px;" class="td">                             
											<p>Estimated average burden hours per response: &#160;0.5 </p>
											</div>
								
									
									</div>
								</div>
							</div>
						</div>
					</div>
					<div style="clear:both;"></div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div style="width:100%; margin-left:0; margin-right:0;"><hr size="2px" style="background-color:#000"></hr></div>
					</div>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div style="width:100%; margin-left:0; margin-right:0;">						
						  <em>Please refer to the General Instructions for forms in the MA series 
						   before completing this form.  All italicized terms herein are defined 
						   or described in the Glossary of Terms appended to the General Instructions.
						   </em>
						</div>
					</div>
					<br/>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div style="width:100%; margin-left:0; margin-right:0;">A <em>municipal advisor</em> must complete this Form MA-W to
							withdraw its <em>municipal advisor</em> registration with the <em>SEC</em>. 
							
							<!--Form
							MA-W must be filed by both <em>municipal advisor</em>s that are organized
							entities (including sole proprietors, and each hereinafter a
							&quot;<em>municipal advisory firm</em>&quot;) and natural <em>persons</em> that are
							<em>municipal advisor</em>s (including sole proprietors, and each
							hereinafter a &quot;<em>natural person municipal advisor</em>&quot;).-->
							</div>
					</div>
					<br/>
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
						<div style="width:100%;margin-left:0; margin-right:0;">
							<strong>WARNING:</strong>
<!-- 						</td> -->
<!-- 					</tr> -->
<!-- 					<tr> -->
<!-- 						<td -->
<!-- 							colspan="4"> -->
							Complete this form truthfully.  False statements or omissions may
							result in administrative or civil action or criminal
							prosecution. 
							<!--All
							<em>italicized</em>
							terms are defined or described in the Glossary to this Form.-->
						</div>
					</div>
				</div>
			</div>
		</div>

	</xsl:template>

	<!-- Edgar Submission Template -->
	<xsl:template
		match="n1:edgarSubmission">
		<xsl:apply-templates
			select="n1:headerData" />
		<xsl:apply-templates
			select="n1:formData" />
	</xsl:template>


	<!-- Header Data Template -->
	<xsl:template
		match="n1:headerData">
		<div
			id="MAWheaderdata"
			style="width:650px; margin:20px 20px">
			<xsl:apply-templates
				select="n1:filerInfo" />
		</div>
	</xsl:template>

	<!-- FilerInfo Template -->
	<xsl:template
		match="n1:filerInfo">
		<div
			id="filerInfo">
			<h3>Filer Information</h3>
			<ul
				class="hii">
				<li>
					<input
						name=""
						type="text" readonly="1"
						size="12" style="color:#000080; ">
						<xsl:attribute
							name="value">
										<xsl:value-of
							select="string(ns2:filer/ns1:filerId)" />
									</xsl:attribute>
					</input>
					<br />
					Filer CIK:
				</li>
				<li
					class="dented">
					<input
						name=""
						 type="text" readonly="1">						
					</input>
					<br />
					Filer CCC:
				</li>
				<li
					class="dented">
					<input
						name=""
						 type="text" readonly="1" style="color:#000080; ">
						<xsl:attribute
							name="value">
										<xsl:value-of
							select="string(ns2:filer/ns1:filerFileNumber)" />
									</xsl:attribute>
					</input>
					<br />
					File Number:
				</li>
			</ul>
			<h3>Contact Information</h3>
			
			<div class="tableStyle" style="margin-left:0; margin-right:0; border:0;"> 
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; valign:bottom; padding-left:40px; color:#000080;">				
						<br></br><xsl:value-of
								select="string(ns2:contact/ns1:name)" />					 
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">				
					<hr  size="1" style="noshade;"></hr>
					Name:
					</div>
				</div>
				
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">									
					<br></br>	<xsl:value-of
								select="string(ns2:contact/ns1:phoneNumber)" />					
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">				
					<hr></hr>
					Phone:
					</div>
				</div>
				
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<br></br><xsl:value-of
								select="string(ns2:contactEmail)" />					
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">				
					<hr></hr>
					Email Address:
					</div>
				</div>
			</div>
		 
			<h3>Notification Information</h3>
				
			<div class="indent"><p style="margin:0;">Notification will automatically be sent to the Login CIK,
				Submission Contact, and Primary Issuers. Specify additional
				addresses below.</p></div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:15px;">		
					<hr></hr>
					Notification Email Address:
					<xsl:apply-templates select="ns2:notifications/ns1:internetNotificationAddress" />
					</div>
				</div>
		
		</div>

	</xsl:template>
<!-- notification  email Template -->

    <xsl:template
        match="ns2:notifications/ns1:internetNotificationAddress">
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; color:#000080;">
						<xsl:value-of
								select="string(.)"/><hr></hr>
					</div>
				</div> 
				</div> 
    </xsl:template>
    
    
	<!-- Form Data Template -->
	<xsl:template
		match="n1:formData">
		<div
			id="MAW"
			style="width:650px; margin:20px 20px">

			<xsl:call-template
				name="Item1" />

			<xsl:apply-templates
				select="./n1:contactPersonInfo" />

			<xsl:call-template
				name="MoneyOwedtoClients" />

			<xsl:call-template
				name="ContractAssignments" />

			<xsl:call-template
				name="JudgmentsandLiens" />

			<xsl:call-template
				name="Item6" />

			<xsl:call-template
				name="Item7" />

			<xsl:call-template
				name="executionPage" />

			<xsl:call-template
				name="Item4NewContractAssignment" />

			<xsl:call-template
				name="Item6BooksAndRecords" />
						
			<xsl:apply-templates
				select="./n1:statementOfFinancials" />
		</div>
	</xsl:template>

	<!-- Item 1 Identifying Information -->
	<xsl:template
		name="Item1">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<h3>Item 1 Identifying Information</h3>
				</div>
				<div class="indent">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; height:20px;width:20px; float:left;">A.</div>
					<div style="margin-left:0; margin-right:0; ">Full Legal Name: <em>The name entered here must be the same as the name entered on
					the registrant's most recent Form MA. Do not report a
					name change on this Form MA-W.</em>
						</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;"> 
				<div style="width:100%; margin-left:0; margin-right:0;">
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div style="margin-left:0; margin-right:0; width:100%; valign:bottom;  padding-top:15px; color:#000080;">				
								<xsl:value-of
								select="./n1:fullLegalName" />					
							</div>
						</div>
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div style="margin-left:0; margin-right:0; width:100%;  padding-top:1px;">
								<hr></hr>
							</div>
						</div>
					</div>
				</div>
				</div>
				<br/>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; height:20px;width:20px; float:left;">B.</div>
					<div style="margin-left:0; margin-right:0; "><em>SEC</em> File Number
						<input
					name=""
					type="text" readonly="1"
					id="" style="color:#000080; ">
					<xsl:attribute
						name="value">
								<xsl:value-of
						select="./n1:fileNumber" />
							</xsl:attribute>
						</input>
					</div>
				</div>
				</div>
			</div>		
	</xsl:template>

	<!-- Item 2 Contact Information -->
	<xsl:template
		match="n1:contactPersonInfo">
		<p
			style="page-break-before: always" />
		<h3>
			Item 2 Contact Person (for
			<em>Municipal Advisory</em>
			Firms)
		</h3>
		<ul
			class="hii">
			<li>
				<em>The registrant's contact person must be a principal or employee
					(not outside counsel) of the municipal advisor authorized to
					receive
					information and respond to questions about this Form MA-W. </em>
			</li>
		</ul>
		<ul
			class="hii">
			<li
				class="qOne">Name, title, and contact information:</li>
		</ul>
		
		<div class="tableStyle indent" style="margin-left:0; margin-right:0;"> 
			<!-- 	<tr>
					<td valign="bottom" style="padding-left:40px;color:#000080; ">				
						<br></br><xsl:value-of
								select="concat(./n1:nameAddressPhone/n1:individualName/ns2:lastName,' ',./n1:nameAddressPhone/n1:individualName/ns2:middleName,'. ',./n1:nameAddressPhone/n1:individualName/ns2:firstName)" />					 
					</td>
				</tr>
				<tr>
				<td style="padding-left:40px; padding-top:1px;" >
					<hr  size="1" style="noshade;"></hr>
					Name
					</td>
				</tr> -->
				
			  <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
	            <div class="value threecol" style="margin-left:0; margin-right:0; padding-top:1px; color:#000080;"> 
					<xsl:value-of select="./n1:nameAddressPhone/n1:individualName/ns2:lastName"/>&#160;
					<hr size="1" style="noshade;"></hr>
				</div>
				<div class="value threecol" style="margin-left:0; margin-right:0; padding-top:1px; color:#000080;"> 
					<xsl:value-of select="./n1:nameAddressPhone/n1:individualName/ns2:firstName"/>&#160;
					<hr  size="1" style="noshade;"></hr>
				</div>
				 <div class="value threecol" style="margin-left:0; margin-right:0; padding-top:1px; color:#000080;"> 
					<xsl:value-of select="./n1:nameAddressPhone/n1:individualName/ns2:middleName"/>&#160;
					<hr  size="1" style="noshade;"></hr>
	            </div> 
	          </div>
	          <div style="clear:both;">
		           <div class="label threecol" style="margin-left:0; margin-right:0;  padding-top:1px;">Last Name:
				   </div>
		           <div class="label threecol" style="margin-left:0; margin-right:0; ">First Name:
				   </div>
		           <div class="label threecol" style="margin-left:0; margin-right:0;">Middle Name:
				   </div>
	          </div>
	        
	        <br/>
			<div class="clear value threecol" style="margin-left:0; margin-right:0; padding-top:10px; color:#000080;"> 
					<xsl:value-of select="./n1:title"/>
					<hr size="1" style="noshade;"></hr>
			</div>
			<div style="clear:both;">
		           <div class="label threecol" style="margin-left:0; margin-right:0;  padding-top:1px;">Title</div>
			</div>
			
			</div>
			
			
			<br />
	        
			<div class="clear"></div>
			<div class="indent tableStyle" style="margin-left:0; margin-right:0;">	
				<div style="width:100%; display:flex; margin-left:0; margin-right:0; padding-top:20px;">
					<div class="twocol">	
						<xsl:value-of select="./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:street1" />&#160;
						<hr size="1" style="noshade;"></hr>	
					</div>
					<div class="twocol">	
					   	<xsl:value-of select="./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:street2" />&#160;
                   		<hr size="1" style="noshade;"></hr>
               		</div>
				</div>
				<div class="clear"/>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol">Street Address 1:</div>
					<div class="twocol">Street Address 2:</div>
				</div>
				<div class="clear"/>
			</div>
				<br></br>
				<div class="indent tableStyle" style="padding-top:20px;"> 	
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="threecol">				
						<xsl:value-of select="./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:city" />&#160;				
					</div>
					<div class="threecol">				
						<!-- <xsl:value-of select="./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:stateOrCountry" /> -->
						     <span >
			                    <xsl:call-template name="stateDescription">
			                        <xsl:with-param name="stateCode" select="string(./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:stateOrCountry)"/>
			                     </xsl:call-template>
	                 		</span>
			                 <span>
			                 	<xsl:text>&#160;</xsl:text>
			                 </span>
	              		
					</div>
					<div class="threecol">
						<xsl:value-of select="./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:zipCode" />&#160;				
					</div>
				</div>
				<div class="clear">
					<div class="threecol"><hr></hr>City:</div>
					<div class="threecol"><hr></hr>State/Country:</div>
					<div class="threecol"><hr></hr> Postal Code:</div>
				</div>
			</div>
			<br/>
			<div class="tableStyle indent" style="margin-left:0; margin-right:0; padding-top:40px;"> 
				
				
				<div class="twocol"><xsl:value-of select="./n1:nameAddressPhone/n1:phoneNumber" />&#160;</div>	
				<div class="twocol"><xsl:value-of select="./n1:email" />&#160;</div>
				<div class="clear">
				<div class="twocol"><hr></hr>Telephone Number:</div>	
				<div class="twocol"><hr></hr>Email Address:</div>
				</div>
			 </div>
	<div class="clear"></div>
	</xsl:template>

	<!-- Item 3 MoneyOwedtoClients -->
	<xsl:template
		name="MoneyOwedtoClients">
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<h3>Item 3  Money Owed to <em>Clients</em></h3>
				</div>
				<div class="indent">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%;"><p style="margin:0;">Has the registrant:</p></div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="moneyowecol1">A.</div>
					<div class="twocol" >
					  Received any pre-paid <em>municipal advisory</em> fees for
				      <em>municipal advisory activities</em>, including pre-paid services and 
				      subscription fees for publications, that have not been delivered?
					</div>
					<div class="twocol" style="margin-left:20px;"><xsl:apply-templates
						select="./n1:isReceivedAnyPrepaidFee" />
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="clear"></div>
					<div class="moneyowecol1" >&#160;</div>
					<div class="twocol" style="padding-top:10px;">
						If "Yes," what is the amount owed for these pre-paid services
						(including subscriptions)?
					</div>
					<div class="threecol shortDollar" style="padding-top:10px;margin-left:20px;">
						 <xsl:call-template name="format_to_dollar">
                        	<xsl:with-param name="money" select="./n1:amountOwedForPreppaidServices" />
                         </xsl:call-template>						
					</div>
				</div>
				<div class="clear" style="padding-top:10px;"></div>
					<div class="moneyowecol1">B.</div>
					<div class="twocol">Borrowed any money from
						<em>clients</em>
						that has not been repaid?
					</div>
					<div class="threecol" style="margin-left:20px;"><xsl:apply-templates
						select="./n1:isBorrowedNotRepaid" />
					</div>
				
				<div class="clear"></div>
					<div class="moneyowecol1" >&#160;</div>
					<div class="twocol" style="padding-top:10px;">
						If "Yes," what is the amount owed for these borrowed funds?
					</div>
					<div class="threecol shortDollar" style="padding-top:10px;margin-left:20px;">
						<xsl:call-template name="format_to_dollar">
                        	<xsl:with-param name="money" select="./n1:amountOwedFromBorrowedFunds" />
                        </xsl:call-template>						
					</div>
				</div>
				<div class="clear"></div>
		</div>
	</xsl:template>

<!-- Applying template for "Item 3A" -->
	<xsl:template
		match="n1:isReceivedAnyPrepaidFee">
		<xsl:call-template
			name="BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<!-- Applying template for "Item 3B" -->
	<xsl:template
		match="n1:isBorrowedNotRepaid">
		<xsl:call-template
			name="BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>



	<!-- Item 4 Advisory Contract Assignmnets -->
	<xsl:template name="ContractAssignments">

		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<h3>Item 4 Advisory Contract Assignments</h3>
			</div>
			<div class="indent">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="twocol">
					Has the registrant assigned any contracts to another <em>person</em>
					that engages in <em>municipal advisory activities</em>?
				</div>
				<div class="twocol2">
					<xsl:apply-templates
					select="./n1:isAdvisoryContract" />
				</div>
			</div>
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="clear"></div>
				<div class="twocol" style="padding-top:10px;">
					If "Yes", list on Section 4 of Schedule W1 each <em>person</em> to whom
					the registrant has assigned any such <em>municipal advisory</em> contracts
					and provide the requested information.
				</div>
				
			</div>
		</div><div class="clear"></div>
		</div>
		<p
			style="page-break-before: always" />
	</xsl:template>
	
	<xsl:template
		match="n1:isAdvisoryContract">
		<xsl:call-template
			name="BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- Item 5 Judgments and Liens -->
	<xsl:template
		name="JudgmentsandLiens">
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<h3>Item 5 Judgments and Liens</h3>
				</div>
				<div class="indent">
					
					<div class="twocol">
						Are there any unsatisfied judgments or liens against the
						registrant?
					</div>
					<div class="twocol2">
						<xsl:apply-templates
						select="./n1:isUnsatisfiedJudgementsOrLiens" />
					</div>
				</div>
			</div>
		<div class="clear"></div>
	</xsl:template>

	<!-- Item 6 - Books and records -->
	<xsl:template
		name="Item6">
		<h3> Item 6 Books and Records</h3>
		
		<p
			align="justify">
			<em>NOTE: Rule 15Ba1-8 under the Exchange Act requires a municipal
				advisor to preserve its books and records after the municipal
				advisor ceases to conduct or discontinues business as a municipal
				advisor. </em>
		</p>
		<p
			align="justify">
			Provide in Schedule W1 the name and address of each <em>person</em> who has or
			will have custody or possession of the
			<em>municipal advisor</em>'s
			books and records and each location at which any of such books and
			records are or will be kept.
		</p>

	</xsl:template>

	<!-- Item 7 - Statement of Financial Condition -->
	<xsl:template
		name="Item7">
		<h3>Item 7 Statement of Financial Condition</h3>
		<p
			align="justify">If registrant answered "Yes" to Item 3A, Item 3B, or Item 5,
			complete Schedule W2, disclosing the nature and amount of the
			registrant's assets and liabilities and net worth as of the last day
			of the month prior to the filing of this Form MA-W.</p>
		<p
			style="page-break-before: always" />
	</xsl:template>


	<!-- Execution Page -->
	<xsl:template
		name="executionPage">
		<br/>
		<h2> Execution </h2>		
		<!--<h3>
			For a
			<em>Natural Person Municipal Advisor</em>
			other than a sole proprietor:
		</h3>
		<p
			align="justify">I, the undersigned, certify, under penalty of perjury under the
			laws of the United States of America, that the information and
			statements made in this Form MA-W, including exhibits and any other
			information submitted, are true and complete. I understand that if
			any information contained in this Form MA-W is different from the
			information contained on a Form MA-I, the information on this Form
			MA-W will replace the corresponding entry on the Form MA-I.  </p>
			
		<table  border="0" style="table-layout:fixed; width:650px"> 
			<tr>
					<td  style="word-wrap:break-word;width:350px;padding-bottom:10px;color:#000080; ">				
						<xsl:value-of
								select="./n1:execution/n1:naturalPersonMuncipal/ns1:signature" />					
					</td>
					<td style="word-wrap:break-word;width:200px;padding-bottom:10px;color:#000080; ">				
						<xsl:value-of
								select="./n1:execution/n1:naturalPersonMuncipal/ns1:date" />
					</td> 
			</tr>
			<tr>
					<td  style="padding-top:1px;" >
						<hr></hr>
						Signature:
					</td>
					<td style="padding-top:1px;" >
						<hr></hr>
						Date: 
					</td>
			</tr>
			<br/>
				<tr>
					<td  style="word-wrap:break-word;width:350px;padding-bottom:10px;color:#000080; ">				
						<xsl:value-of
								select="./n1:execution/n1:naturalPersonMuncipal/ns1:signerName" />					
					</td>
					<td style="word-wrap:break-word;width:300px;padding-bottom:10px;color:#000080; ">				
						<xsl:value-of
								select="./n1:execution/n1:naturalPersonMuncipal/ns1:title" />
					</td> 
			</tr>
			<tr>
					<td  style="padding-top:1px;" >
						<hr></hr>
						Printed Name: 
					</td>
					<td style="padding-top:1px;" >
						<hr></hr>
						Title: 
					</td>
			</tr>
	</table>	
	-->
		<h3>For a Sole Proprietor:</h3>
		<p
			align="justify">
			I, the undersigned, certify, under penalty of perjury under the
			laws
			of the United States of America, that the information and statements
			made in this Form MA-W, including exhibits and any other
			information
			submitted, are true. I further certify that the books
			and records of my
			<em>municipal advisor-related</em>
			business will be preserved and available for inspection as required
			by law, and that all information submitted on my most recent Form
			MA
			and Form MA-I is accurate and complete as of this date. I understand
			that if any information contained in this Form MA-W is different
			from
			the information contained on my Form MA and Form MA-I, the
			information on this Form MA-W will replace the corresponding entry on
			my Form MA and Form MA-I. Finally, I authorize any person having
			custody or possession of these books and records to make them
			available to authorized regulatory representatives.
		</p>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-bottom:10px; color:#000080;">
						<xsl:value-of
								select="./n1:execution/n1:soleProprietor/ns1:signature" />&#160;										
					</div>
					<div class="twocol" style="margin-left:0; margin-right:0;word-wrap:break-word; padding-bottom:10px; color:#000080;">				
							<xsl:value-of
								select="./n1:execution/n1:soleProprietor/ns1:date" />&#160;
					</div> 
			</div>
			<div style="clear:both;"/>
			
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Signature:
					</div>
					<div class="twocol2" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Date: 
					</div>
			</div>
			<div style="clear:both;"/>
			
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-top:5px; padding-bottom:10px; color:#000080;">				
						<xsl:value-of
								select="./n1:execution/n1:soleProprietor/ns1:signerName" />&#160;
					</div>
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-top:5px; padding-bottom:10px; color:#000080;">				
						<xsl:value-of
								select="./n1:execution/n1:soleProprietor/ns1:title" />&#160;
					</div> 
			</div>
			<div style="clear:both;"/>
			
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Printed Name: 
					</div>
					<div class="twocol2" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Title: 
					</div>
			</div>
			<div style="clear:both;"/>
	</div>	
		
		<p
			align="justify">
			<h3>
				For a
				<em>Municipal Advisory Firm:</em>
			</h3>
		</p>
		<p
			align="justify">
			I, the undersigned, have signed this Form MA-W on behalf of, and
			with
			the authority of, the
			<em>municipal advisor</em>
			withdrawing its registration.  The advisor and I both certify,
			under
			penalty of perjury under the laws of the United States of America,
			that the information and statements made in this Form MA-W, including
			exhibits and any other information submitted, are true. 
			I further certify that the
			<em>municipal advisor’s</em>
			books and records will be preserved and available for inspection as
			required by law, and that all information submitted on the
			<em>municipal advisor</em>
			’s most recent Form MA is accurate and complete as of this date. 
			The
			<em>municipal advisor</em>
			and I understand that if any information contained in this Form
			MA-W
			is different from the information contained on Form MA, the
			information on this Form MA-W will replace the corresponding entry
			on
			the
			<em>municipal advisor</em>
			’s Form MA.  Finally, I authorize any
			<em>person</em>
			having custodyor possession of these books and records to make them
			available to authorized regulatory representatives.
		</p>

		<div class="tableStyle" style="margin-left:0; margin-right:0;"> 
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-bottom:10px; color:#000080;">				
						<xsl:value-of
								select="./n1:execution/n1:muncipalAdvisoryFirm/ns1:signature" />&#160;					
					</div>
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-bottom:10px; color:#000080;">				
						<xsl:value-of
								select="./n1:execution/n1:muncipalAdvisoryFirm/ns1:date" />&#160;
					</div> 
			</div>
			<div style="clear:both;"/>
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Signature:
					</div>
					<div class="twocol2" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Date: 
					</div>
			</div>
			<div style="clear:both;"/>
			<br/>
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-top:5px; padding-bottom:10px; color:#000080;">				
						<xsl:value-of
								select="./n1:execution/n1:muncipalAdvisoryFirm/ns1:signerName" />&#160;					
					</div>
					<div class="twocol" style="margin-left:0; margin-right:0; word-wrap:break-word; padding-top:5px; padding-bottom:10px; color:#000080;">				
						<xsl:value-of
								select="./n1:execution/n1:muncipalAdvisoryFirm/ns1:title" />&#160;
					</div> 
			</div>
			<div style="clear:both;"/>
			
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Printed Name: 
					</div>
					<div class="twocol2" style="margin-left:0; margin-right:0; padding-top:1px;">
						<hr></hr>
						Title: 
					</div>
			</div>
			<div style="clear:both;"/>
	</div>	
		<p
			style="page-break-before: always" />
	</xsl:template>


	<!-- Item 4 New Advisory Contract assignment -->
	<xsl:template
		name="Item4NewContractAssignment">		

		<xsl:if
			test="(count(n1:advisoryContractAssignments/n1:advisoryContract) &gt; 0) or (count(n1:booksAndRecords/n1:personLocation) &gt; 0) ">
			
			<h2>FORM MA-W: Schedule W1</h2>
			<p
				align="justify">Certain items in Form MA-W may require additional information
				on
				this Schedule W1. Use this Schedule W1 to report details for
				items
				listed below. Report only new information or changes/updates
				to
				previously submitted information. Do not repeat previously
				submitted
				information.</p>
				
			<xsl:if
			test="n1:isAdvisoryContract = 'Y'">
			<h3>SECTION 4: Advisory Contract Assignments</h3>
			<p
				align="justify">
				Check here if this section is being completed:
		
				<xsl:choose>
					<xsl:when
						test="n1:isAdvisoryContract = 'Y' ">
						<img
							src="Images/box-checked.jpg" alt="checkbox checked" />

					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
					</xsl:otherwise>

				</xsl:choose>
			</p>
			
			<p
				align="justify">Complete the following information for each <em>person</em> to whom the
				registrant has assigned any advisory contract to provide <em>municipal advisor-related</em> 
				services. Complete a separate Schedule W1 for each <em>person</em> to whom the registrant 
				has assigned such a contract.</p>
			<xsl:for-each
			select="n1:advisoryContractAssignments/n1:advisoryContract">
			<ul
				class="hii">
				<li
					class="qOne"><b><xsl:value-of select="concat('&#xA;', position(), '. ')"/>
						Name and business address of the <em>person</em> to whom such contracts were assigned:</b></li>
			</ul>
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div class="twocol">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<xsl:value-of
								select="./n1:name" />					
					</div>
				</div>
				<div class="clear">
				<div class="twocol">
					<hr></hr>
					Full Name:
					</div>
				</div>
			</div>	
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<!-- <tr>
					<td style="padding-left:40px;color:#000080; ">				
						<br> </br><xsl:value-of
								select="concat(./n1:addressInfo/ns2:address/ns1:street1,' ',./n1:addressInfo/ns2:address/ns1:street2)" />					
					</td>
				</tr>
				<tr>
				<td style="padding-left:40px; padding-top:1px;" >
					<hr></hr>
					Number and Street
					</td>
				</tr> -->
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px; color:#000080;">
						<xsl:value-of select="./n1:addressInfo/ns2:address/ns1:street1"/>&#160;
						<hr  size="1" style="noshade;"></hr>	
					</div>
					<div style="margin-left:0; margin-right:0; width:100%; padding-top:1px; color:#000080;">
					   	<xsl:value-of select="./n1:addressInfo/ns2:address/ns1:street2"/>&#160;
					   	<hr  size="1" style="noshade;"></hr>
                  	</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">	
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">Street Address 1:</div>
					<div style="margin-left:0; margin-right:0; width:100%; padding-top:1px;">Street Address 2:</div>
				</div>
			</div>
			<br/>
			<div class="tableStyle" style="margin-left:0; margin-right:0;">	
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px; color:#000080; word-wrap:break-word;">
					<xsl:value-of
								select="./n1:addressInfo/ns2:address/ns1:city" />&#160;					
					</div>
					<div style="margin-left:0; margin-right:0; width:100%; padding-top:1px; color:#000080; word-wrap:break-word;">
						<!-- <xsl:value-of select="./n1:addressInfo/ns2:address/ns1:stateOrCountry" /> -->
						  <span >
			                    <xsl:call-template name="stateDescription">
			                        <xsl:with-param name="stateCode" select="string(./n1:addressInfo/ns2:address/ns1:stateOrCountry)"/>
			                     </xsl:call-template>
	                 		</span>
			                 <span>
			                 	<xsl:text>&#160;</xsl:text>
			                 </span>
					</div>
					<div style="margin-left:0; margin-right:0; width:100%; padding-top:1px; color:#000080; word-wrap:break-word;">				
						<xsl:value-of
								select="./n1:addressInfo/ns2:address/ns1:zipCode" />&#160;					
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;"><hr></hr>City:</div>
					<div style="margin-left:0; margin-right:0; width:100%; padding-top:1px;"><hr></hr>State/Country:</div>
					<div style="margin-left:0; margin-right:0; width:100%; padding-top:1px;"><hr></hr>Postal Code:</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<br> </br><xsl:value-of select="./n1:phoneNumber" />					
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">
					<hr></hr>
					Telephone Number:
					</div>
				</div>
			</div>
			<ul
				class="hvv">
				<li
					class="qOne">
					<xsl:text>&#160;</xsl:text>Is this address a private residence?
				</li>

				<li
					class="yesNo">
					<xsl:apply-templates
						select="./n1:addressInfo/ns2:residentialAddressFlag" />
					
				</li>
			</ul>
		</xsl:for-each>
		</xsl:if>
		</xsl:if>
		<p
			style="page-break-before: always" />
	</xsl:template>
	
	<xsl:template
		match="n1:addressInfo/ns2:residentialAddressFlag">
		<xsl:call-template
			name="BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- Item 6 Books And Records New Custodian -->
	<xsl:template
		name="Item6BooksAndRecords">		

	  <xsl:if
			test="count(n1:booksAndRecords/n1:personLocation) > 0 ">
			
			<h3>SECTION 6  Books and Records</h3>
			
			<xsl:for-each
			select="n1:booksAndRecords/n1:personLocation">
				<p>
				Complete the following information for each
				<em>person
				</em>
				that has or will have custody or possession of any of the registrant's books and records.
				A separate Schedule W1 must be completed for each
				<em>person </em>. If the same <em>person</em>
				has or will have custody of any such books and
				records at more than one location, a separate Schedule W1 must be
				completed for this <em>person</em> for each such location.
			</p>		
			
			<p
				align="justify">
				<strong>
					<em>Person</em>
					with Custody:
				</strong>
			</p>
			
			
			<ul
				class="hii">
				<li
					class="qOne">Name and business address of the <em>person</em> with custody or possession of books and records:
					</li>
			</ul>
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<xsl:value-of
								select="./n1:personInfo/n1:name" />					
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">
					<hr></hr>
					Name:
					</div>
				</div>
				</div>
				<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<!-- <tr>
					<td style="padding-left:40px;color:#000080; ">				
						<br> </br><xsl:value-of
								select="concat(./n1:personInfo/n1:addressInfo/ns2:address/ns1:street1,' ',./n1:personInfo/n1:addressInfo/ns2:address/ns1:street2)" />					
					</td>
				</tr>
				<tr>
				<td style="padding-left:40px; padding-top:1px;" >
					<hr></hr>
					Number and Street
					</td>
				</tr> -->
				<div class="indent" style="padding-top:20px;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div class="twocol">
						<xsl:value-of select="./n1:personInfo/n1:addressInfo/ns2:address/ns1:street1" />&#160;
						<hr  size="1" style="noshade;"></hr>	
					</div>
					<div class="twocol">
					   	<xsl:value-of select="./n1:personInfo/n1:addressInfo/ns2:address/ns1:street2" />&#160;
                    	<hr  size="1" style="noshade;"></hr>
                  	</div>
				</div>
				<div class="clear">	
					<div class="twocol">Street Address 1:</div>
					<div class="twocol">Street Address 2:</div>
				</div>
			
				
					<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<br></br><xsl:value-of
								select="./n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:city" />					
					</div>
				</div>
				</div>
			</div>
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="indent" style="padding-top:20px;">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="threecol">
					<xsl:value-of select="./n1:personInfo/n1:addressInfo/ns2:address/ns1:city" />&#160;					
				</div>
				<div class="threecol">				
					<!-- <xsl:value-of select="./n1:personInfo/n1:addressInfo/ns2:address/ns1:stateOrCountry" /> -->
					<span >
	                    <xsl:call-template name="stateDescription">
	                        <xsl:with-param name="stateCode" select="string(./n1:personInfo/n1:addressInfo/ns2:address/ns1:stateOrCountry)"/>
	                     </xsl:call-template>
                		</span>
	                 <span>
	                 	<xsl:text>&#160;</xsl:text>
	                 </span>
				</div>
				<div class="threecol">				
					<xsl:value-of select="./n1:personInfo/n1:addressInfo/ns2:address/ns1:zipCode" />&#160;					
				</div>
			</div>
			<div class="clear">
				<div class="threecol"><hr></hr>City:</div>
				<div class="threecol"><hr></hr>State/Country:</div>
				<div class="threecol"><hr></hr>Postal Code:</div>
			</div>
			</div>
			
			<div class="tableStyle" style="padding-top:20px;">	
				<div class="twocol">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<br> </br><xsl:value-of
								select="./n1:personInfo/n1:phoneNumber" />					
					</div>
				</div>
				<div class="clear twocol" >
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">
					<hr></hr>
					Telephone Number:
					</div>
				</div>
			</div>
			
			<div class="clear" style="padding-top:20px;"></div>
			<div class="tableStyle indent" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:5%;"></div>
					<div style="margin-left:0; margin-right:0; width:70%;">Is this address a private residence?</div>
					<div style="margin-left:0; margin-right:0; width:25%; align:right;">
							<xsl:if
								test="./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'Y' or ./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:if>
							<xsl:if
								test="./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'N' or ./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'n'">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:if>
							Yes
							<xsl:if
								test="./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'Y' or ./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'y'">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:if>
							<xsl:if
								test="./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'N' or ./n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag = 'n'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:if>
							No	
					</div>
				</div>
			</div>
			</div>
			
			<p
				align="justify">
				<strong>Location of Books and Records: </strong>
			</p>
			<!--
			<p
				align="justify">
				Complete the following information for the location where the books
				and records of which the person listed in this Section 6 of this
				Schedule has or will have custody or possession. A separate Schedule
				W1 must be completed for each location at which the registrant's
				records are or will be kept. If any other
				<em>person</em>
				has or
				will have custody or possession of any of the books and records
				at
				the location described below, a separate Schedule W1 must be
				completed listing this location and each other
				<em>person</em>
				that
				has or will have custody of the registrant's books and records.
			</p>
			
			<ul
				class="hii">
				<li
					class="qOne">Name and business address of the person to
					whom advisory
					contracts were assigned:</li>
			</ul>
			-->
			<div class="tableStyle" style="margin-left:0; margin-right:0;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<xsl:value-of
								select="./n1:locationInfo/n1:nameAddressPhone/n1:name" />					
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:40px;">
					<hr></hr>
					Name of Location, if any:
					</div>
				</div>
				</div>
				<br/>
				<div class="tableStyle indent" style="margin-left:0; margin-right:0;">	
				<!-- <tr>
					<td style="padding-left:40px;color:#000080; ">				
						<br> </br><xsl:value-of
								select="concat(./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:street1,' ',./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:street2)" />					
					</td>
				</tr>
				<tr>
				<td style="padding-left:40px; padding-top:1px;" >
					<hr></hr>
					Number and Street
					</td>
				</tr> -->
				
				<div>
					<div class="twocol">
						<xsl:value-of select="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:street1" />&#160;
						<hr  size="1" style="noshade;"></hr>	
					</div>
					<div class="twocol">
					   	<xsl:value-of select="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:street2" />&#160;
                    	<hr  size="1" style="noshade;"></hr>
                  	</div>
				</div>
				<div class="clear">	
					<div class="twocol">Street Address 1:</div>
					<div class="twocol">Street Address 2:</div>
				</div>
			</div>
			<br/>
			<div class="tableStyle indent" style="margin-left:0; margin-right:0;">
				<div class="clear" style="padding-top:20px;">
					<div class="threecol">				
						<xsl:value-of select="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:city" />&#160;				
					</div>
					<div class="threecol">				
						<!-- <xsl:value-of select="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:stateOrCountry" /> -->
					<span >
	                    <xsl:call-template name="stateDescription">
	                        <xsl:with-param name="stateCode" select="string(./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:stateOrCountry)"/>
	                     </xsl:call-template>
                		</span>
	                 <span>
	                 	<xsl:text>&#160;</xsl:text>
	                 </span>
					</div>
					<div class="threecol">				
						<xsl:value-of select="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:address/ns1:zipCode" />&#160;					
					</div>
				</div>
				<div class="clear">
					<div class="threecol"><hr></hr>City:</div>
					<div class="threecol"><hr></hr>State/Country:</div>
					<div class="threecol"><hr></hr>Postal Code:</div>
				</div> 
			</div>	
			<div class="tableStyle" style="padding-top:20px;">	
				<div class="twocol">
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; color:#000080;">				
						<br> </br><xsl:value-of
								select="./n1:locationInfo/n1:nameAddressPhone/n1:phoneNumber" />					
					</div>
				</div>
				<div class="clear twocol" >
					<div style="margin-left:0; margin-right:0; width:100%; padding-left:40px; padding-top:1px;">
					<hr></hr>
					Telephone Number:
					</div>
				</div>
			</div>
			
			<div class="tableStyle clear indent" style="padding-top:20px;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:5%;"></div>
					<div style="margin-left:0; margin-right:0; width:70%;">Is this address a private residence?</div>
					<div style="margin-left:0; margin-right:0; width:25%; align:right;">
							<xsl:text>  </xsl:text>					
							<xsl:if
								test="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'Y' or ./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'y'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:if>
							<xsl:if
								test="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'N' or ./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'n'">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:if>
							Yes
							<xsl:if
								test="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'Y' or ./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'y'">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:if>
							<xsl:if
								test="./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'N' or ./n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag = 'n'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:if>
							No
					</div>
				</div>
			</div>
			
			<div class="tableStyle indent" style="padding-top:20px;">
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:5%;"></div>
					<div style="margin-left:0; margin-right:0; width:95%;">Briefly describe the books and records kept at
							this location.
					</div>
				</div>
				<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
					<div style="margin-left:0; margin-right:0; width:5%;"></div>
					<div style="margin-left:0; margin-right:0; width:95%; align:justify;">				
						<p style="color:#000080; ">
							<xsl:value-of
							select="./n1:locationInfo/n1:description" />					
						</p>
					</div>
				</div>
			</div>
		</xsl:for-each>
		
		</xsl:if>
		
	</xsl:template>

	<!-- Item 7 StatementOfFinancials -->
	<xsl:template
		match="n1:statementOfFinancials">
		<h2>FORM MA-W: Schedule W2</h2>
		<p
			align="justify">If the registrant answered "Yes" to Item 3A, 3B, or 5 of Form
			MA-W,
			complete this Schedule W2. This balance sheet must be prepared
			in
			accordance with generally accepted accounting principles, but
			need
			not
			be audited.</p>
		<h3>SECTION 7 Statement of Financial Condition</h3>
		<h4>I. Assets</h4>
		<ul
			class="hvv">
			<li
				class="qOne">
				<xsl:text>&#160;</xsl:text><u>Current Assets</u>
			</li>
			<li
				class="qTwo">Cash</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:currentAssets/n1:cash" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Securities at Market</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:currentAssets/n1:securitiesAtMarket" />
                </xsl:call-template>								
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Non-Marketable Securities</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:currentAssets/n1:nonMarketableSecurities" />
                </xsl:call-template>								
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo"></li>
			<li
				class="qTwo">Other Current Assets</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:currentAssets/n1:otherCurrentAssets" />
                </xsl:call-template>								
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">
				<strong>Total Current Assets</strong>
			</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:currentAssets/n1:totalCurrentAssets" />
                </xsl:call-template>					
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qOne">
				<xsl:text>&#160;</xsl:text><u>Fixed Assets</u>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Total Fixed Assets</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:totalFixedAsset" />
                </xsl:call-template>					
			</li>
		</ul>

		<ul
			class="hvv">
			<li
				class="qTwo">
				<strong>TOTAL ASSETS</strong>
			</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:assetInfo/n1:totalAsset" />
                </xsl:call-template>
			</li>
		</ul>
		<h4>II. Liabilities &#38; Shareholders' Equity</h4>
		<ul
			class="hvv">
			<li
				class="qOne">
				<u><xsl:text>&#160;</xsl:text>Current Liabilities</u>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Prepaid Advisory Fees</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:currentLiabilties/n1:prepaidAdvisoryFees" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">
				Short-Term Loans from
				<em>Clients</em>
			</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:currentLiabilties/n1:shortTermLoansFromClients" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Other Short-Term Loans</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:currentLiabilties/n1:otherShortTermLoans" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Other Current Liabilities</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:currentLiabilties/n1:otherCurrentLiabilities" />
                </xsl:call-template>
				
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">
				<strong>Total Current Liabilities</strong>
			</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:currentLiabilties/n1:totalCurrentLiabilities" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qOne">
				<u><xsl:text>&#160;</xsl:text>Fixed Liabilities</u>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">
				Long-Term Debt Owed to
				<em>Clients</em>
			</li>

			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:fixedLiabilities/n1:longTermDebtOwed" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Other Long-Term Debt</li>
			
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:fixedLiabilities/n1:otherLongTermDebt" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">Other Long-Term Liabilities</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:fixedLiabilities/n1:otherLongTermLiabilities" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">
				<strong>Total Fixed Liabilities</strong>
			</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:fixedLiabilities/n1:totalFixedLiabilities" />
                </xsl:call-template>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qOne">
				<u>Shareholders' Equity</u>
			</li>
		</ul>
		<ul
			class="hvv">
			<li
				class="qTwo">
				<strong>Total Shareholders' Equity (or Deficit)</strong>
			</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:totalShareholdersEquity" />
                </xsl:call-template>
			</li>
		</ul>

		<ul
			class="hvv">
			<li
				class="qTwo">
			TOTAL LIABILITIES AND SHAREHOLDERS' EQUITY
			</li>
			<li style="color:#000080;" class="shortDollar">
				<xsl:call-template name="format_to_dollar">
                   	<xsl:with-param name="money" select="./n1:liabiltyAndSharholdersEquityInfo/n1:totalLiabiltiesAndShareholdersEquity" />
                </xsl:call-template>
			</li>
		</ul>
	</xsl:template>

	<!-- Apply Templates for Yes or No -->

	<!-- Applying template for "Item 5" -->
	<xsl:template
		match="n1:isUnsatisfiedJudgementsOrLiens">
		<xsl:call-template
			name="BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<!-- Applying template for "Item 6/Person Info" -->

	<xsl:template
		match="n1:personInfo/n1:addressInfo/ns2:residentialAddressFlag">
		<xsl:call-template
			name="BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>


	<!-- Applying template for "Item 6/Location Info" -->

	<xsl:template
		match="n1:locationInfo/n1:nameAddressPhone/n1:addressInfo/ns2:residentialAddressFlag">
		<xsl:call-template
			name="Item6BooleanOutput">
			<xsl:with-param
				name="value">
				<xsl:value-of
					select="."></xsl:value-of>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- Boolean OutPut Template For Yes or No selection For Item 5 -->
	<xsl:template
		name="BooleanOutput">
		<xsl:param
			name="value" />
		<!--<div class="tableStyle" style="margin-left:0; margin-right:0;">
	     <div style="width:100%; display:flex; margin-left:0; margin-right:0;">-->
	     <div class="yesNo75">
	     		<xsl:if
				test=". = 'Y' or . = 'y'">
				<img
					src="Images/radio-checked.jpg" alt="radio button checked" />
			</xsl:if>
			<xsl:if
				test=". = 'N' or . = 'n'">
				<img
					src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			</xsl:if>
			Yes
	     	</div>
			<div class="yesNo75">
				<xsl:if
					test=". = 'Y' or . = 'y'">
					<img
						src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:if>
				<xsl:if
					test=". = 'N' or . = 'n'">
					<img
						src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:if>
				No
			</div>	     
	     <!--</div>
	 </div>-->
	</xsl:template>
	
	<xsl:template
		name="Item6BooleanOutput">
		<xsl:param
			name="value" />
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
	     <div style="width:100%; display:flex; margin-left:0; margin-right:0;">
	     	<div class="yesNo" style="margin-left:0; margin-right:0; width:50%;">
	     		<xsl:if
				test=". = 'Y' or . = 'y'">
				<img
					src="Images/radio-checked.jpg" alt="radio button checked" />
			</xsl:if>
			<xsl:if
				test=". = 'N' or . = 'n'">
				<img
					src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			</xsl:if>
			Yes
	     	</div>
	     	<div class="yesNo" style="margin-left:0; margin-right:0; width:50%;">
				<xsl:if
					test=". = 'Y' or . = 'y'">
					<img
						src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:if>
				<xsl:if
					test=". = 'N' or . = 'n'">
					<img
						src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:if>
				No
			</div>
	     </div>
	 </div>
</xsl:template>
   
<xsl:template name="stateDescription">
         <xsl:param name="stateCode" />
                <xsl:choose>
                    <xsl:when test="$stateCode='AK'">
						ALASKA
					</xsl:when>
					<xsl:when test="$stateCode='AL'">
						ALABAMA
					</xsl:when>
					<xsl:when test="$stateCode='AR'">
						ARKANSAS
					 </xsl:when>
					<xsl:when test="$stateCode='AZ'">
						ARIZONA
					</xsl:when>
					<xsl:when test="$stateCode='CA'">
						CALIFORNIA
					</xsl:when>
					<xsl:when test="$stateCode='CO'">
						COLORADO
					</xsl:when>
					<xsl:when test="$stateCode='CT'">
						CONNECTICUT
					</xsl:when>
					<xsl:when test="$stateCode='DC'">
						DISTRICT OF COLUMBIA
					</xsl:when>
					<xsl:when test="$stateCode='DE'">
						DELAWARE
					</xsl:when>
					<xsl:when test="$stateCode='FL'">
						FLORIDA
					</xsl:when>
					<xsl:when test="$stateCode='GA'">
						GEORGIA
					 </xsl:when>
					<xsl:when test="$stateCode='HI'">
						HAWAII
					 </xsl:when>
					<xsl:when test="$stateCode='IA'">
						IOWA
					 </xsl:when>
					<xsl:when test="$stateCode='ID'">
						IDAHO
					 </xsl:when>
					<xsl:when test="$stateCode='IL'">
						ILLINOIS
					 </xsl:when>
					<xsl:when test="$stateCode='IN'">
						INDIANA
					 </xsl:when>
					<xsl:when test="$stateCode='KS'">
						KANSAS
					 </xsl:when>
					<xsl:when test="$stateCode='KY'">
						KENTUCKY
					 </xsl:when>
					<xsl:when test="$stateCode='LA'">
						LOUISIANA
					 </xsl:when>
					<xsl:when test="$stateCode='MA'">
						MASSACHUSETTS
					 </xsl:when>
					<xsl:when test="$stateCode='MD'">
						MARYLAND
					 </xsl:when>
					<xsl:when test="$stateCode='ME'">
						MAINE
					 </xsl:when>
					<xsl:when test="$stateCode='MI'">
						MICHIGAN
					 </xsl:when>
					<xsl:when test="$stateCode='MN'">
						MINNESOTA
					 </xsl:when>
					<xsl:when test="$stateCode='MO'">
						MISSOURI
					 </xsl:when>
					<xsl:when test="$stateCode='MS'">
						MISSISSIPPI
					 </xsl:when>
					<xsl:when test="$stateCode='MT'">
						MONTANA
					 </xsl:when>
					<xsl:when test="$stateCode='NC'">
						NORTH CAROLINA
					 </xsl:when>
					<xsl:when test="$stateCode='ND'">
						NORTH DAKOTA
					 </xsl:when>
					<xsl:when test="$stateCode='NE'">
						NEBRASKA
					 </xsl:when>
					<xsl:when test="$stateCode='NH'">
						NEW HAMPSHIRE
					 </xsl:when>
					<xsl:when test="$stateCode='NJ'">
						NEW JERSEY
					 </xsl:when>
					<xsl:when test="$stateCode='NM'">
						NEW MEXICO
					 </xsl:when>
					<xsl:when test="$stateCode='NV'">
						NEVADA
					 </xsl:when>
					<xsl:when test="$stateCode='NY'">
						NEW YORK
					 </xsl:when>
					<xsl:when test="$stateCode='OH'">
						OHIO
					 </xsl:when>
					<xsl:when test="$stateCode='OK'">
						OKLAHOMA
					 </xsl:when>
					<xsl:when test="$stateCode='OR'">
						OREGON
					 </xsl:when>
					<xsl:when test="$stateCode='PA'">
						PENNSYLVANIA
					 </xsl:when>
					<xsl:when test="$stateCode='RI'">
						RHODE ISLAND
					 </xsl:when>
					<xsl:when test="$stateCode='SC'">
						SOUTH CAROLINA
					 </xsl:when>
					<xsl:when test="$stateCode='SD'">
						SOUTH DAKOTA
					 </xsl:when>
					<xsl:when test="$stateCode='TN'">
						TENNESSEE
					 </xsl:when>
					<xsl:when test="$stateCode='TX'">
						TEXAS
					 </xsl:when>
					<xsl:when test="$stateCode='UT'">
						UTAH
					 </xsl:when>
					<xsl:when test="$stateCode='VA'">
						VIRGINIA
					 </xsl:when>
					<xsl:when test="$stateCode='VT'">
						VERMONT
					 </xsl:when>
					<xsl:when test="$stateCode='WA'">
						WASHINGTON
					 </xsl:when>
					<xsl:when test="$stateCode='WI'">
						WISCONSIN
					 </xsl:when>
					<xsl:when test="$stateCode='WV'">
						WEST VIRGINIA
                     </xsl:when>
					<xsl:when test="$stateCode='WY'">
						WYOMING
					 </xsl:when>
					<xsl:when test="$stateCode='X1'">
						UNITED STATES
					 </xsl:when>
					<xsl:when test="$stateCode='A0'">
						ALBERTA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A1'">
						BRITISH COLUMBIA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A2'">
						MANITOBA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A3'">
						NEW BRUNSWICK, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A4'">
						NEWFOUNDLAND, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A5'">
						NOVA SCOTIA, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A6'">
						ONTARIO, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A7'">
						PRINCE EDWARD ISLAND, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A8'">
						QUEBEC, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='A9'">
						SASKATCHEWAN, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='B0'">
						YUKON, CANADA
					 </xsl:when>
					<xsl:when test="$stateCode='Z4'">
						CANADA (FEDERAL LEVEL)
					 </xsl:when>
					<xsl:when test="$stateCode='1A'">
						ANGUILLA
					 </xsl:when>
					<xsl:when test="$stateCode='1B'">
						ARMENIA
					 </xsl:when>
					<xsl:when test="$stateCode='1C'">
						ARUBA
					 </xsl:when>
					<xsl:when test="$stateCode='1D'">
						AZERBAIJAN
					 </xsl:when>
					<xsl:when test="$stateCode='1E'">
						BOSNIA AND HERZEGOVINA
					 </xsl:when>
					<xsl:when test="$stateCode='1F'">
						BELARUS
					 </xsl:when>
					<xsl:when test="$stateCode='1G'">
						DJIBOUTI
					 </xsl:when>
					<xsl:when test="$stateCode='1H'">
						ESTONIA
					 </xsl:when>
					<xsl:when test="$stateCode='1J'">
						ERITREA
					 </xsl:when>
					<xsl:when test="$stateCode='1K'">
						MICRONESIA, FEDERATED STATES OF
					 </xsl:when>
					<xsl:when test="$stateCode='1L'">
						SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS
					 </xsl:when>
					<xsl:when test="$stateCode='1M'">
						CROATIA
					 </xsl:when>
					<xsl:when test="$stateCode='1N'">
						KYRGYZSTAN
					 </xsl:when>
					<xsl:when test="$stateCode='1P'">
						KAZAKSTAN
					 </xsl:when>
					<xsl:when test="$stateCode='1Q'">
						LITHUANIA
					 </xsl:when>
					<xsl:when test="$stateCode='1R'">
						LATVIA
					 </xsl:when>
					<xsl:when test="$stateCode='1S'">
						MOLDOVA, REPUBLIC OF
					 </xsl:when>
					<xsl:when test="$stateCode='1T'">
						MARSHALL ISLANDS
					 </xsl:when>
					<xsl:when test="$stateCode='1U'">
						MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF
					 </xsl:when>
					<xsl:when test="$stateCode='1V'">
						NORTHERN MARIANA ISLANDS
					 </xsl:when>
<xsl:when test="$stateCode='1W'">
NEW CALEDONIA
 </xsl:when>
<xsl:when test="$stateCode='1X'">
PALESTINIAN TERRITORY, OCCUPIED
 </xsl:when>
<xsl:when test="$stateCode='1Y'">
PALAU
 </xsl:when>
<xsl:when test="$stateCode='1Z'">
RUSSIAN FEDERATION
 </xsl:when>
<xsl:when test="$stateCode='2A'">
SLOVENIA
 </xsl:when>
<xsl:when test="$stateCode='2B'">
SLOVAKIA
 </xsl:when>
<xsl:when test="$stateCode='2C'">
FRENCH SOUTHERN TERRITORIES
 </xsl:when>
<xsl:when test="$stateCode='2D'">
TAJIKISTAN
 </xsl:when>
<xsl:when test="$stateCode='2E'">
TURKMENISTAN
 </xsl:when>
<xsl:when test="$stateCode='2G'">
TUVALU
 </xsl:when>
<xsl:when test="$stateCode='2H'">
UKRAINE
 </xsl:when>
<xsl:when test="$stateCode='2J'">
UNITED STATES MINOR OUTLYING ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='2K'">
UZBEKISTAN
 </xsl:when>
<xsl:when test="$stateCode='2L'">
VANUATU
 </xsl:when>
<xsl:when test="$stateCode='2M'">
GERMANY
 </xsl:when>
<xsl:when test="$stateCode='2N'">
CZECH REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='2P'">
MAYOTTE
 </xsl:when>
<xsl:when test="$stateCode='2Q'">
GEORGIA
 </xsl:when>
<xsl:when test="$stateCode='B1'">
BOTSWANA
 </xsl:when>
<xsl:when test="$stateCode='B2'">
AFGHANISTAN
 </xsl:when>
<xsl:when test="$stateCode='B3'">
ALBANIA
 </xsl:when>
<xsl:when test="$stateCode='B4'">
ALGERIA
 </xsl:when>
<xsl:when test="$stateCode='B5'">
AMERICAN SAMOA
 </xsl:when>
<xsl:when test="$stateCode='B6'">
ANDORRA
 </xsl:when>
<xsl:when test="$stateCode='B7'">
ANGOLA
 </xsl:when>
<xsl:when test="$stateCode='B8'">
ANTARCTICA
 </xsl:when>
<xsl:when test="$stateCode='B9'">
ANTIGUA AND BARBUDA
 </xsl:when>
<xsl:when test="$stateCode='C0'">
UNITED ARAB EMIRATES
 </xsl:when>
<xsl:when test="$stateCode='C1'">
ARGENTINA
 </xsl:when>
<xsl:when test="$stateCode='C3'">
AUSTRALIA
 </xsl:when>
<xsl:when test="$stateCode='C4'">
AUSTRIA
 </xsl:when>
<xsl:when test="$stateCode='C5'">
BAHAMAS
 </xsl:when>
<xsl:when test="$stateCode='C6'">
BAHRAIN
 </xsl:when>
<xsl:when test="$stateCode='C7'">
BANGLADESH
 </xsl:when>
<xsl:when test="$stateCode='C8'">
BARBADOS
 </xsl:when>
<xsl:when test="$stateCode='C9'">
BELGIUM
 </xsl:when>
<xsl:when test="$stateCode='D0'">
BERMUDA
 </xsl:when>
<xsl:when test="$stateCode='D1'">
BELIZE
 </xsl:when>
<xsl:when test="$stateCode='D2'">
BHUTAN
 </xsl:when>
<xsl:when test="$stateCode='D3'">
BOLIVIA
 </xsl:when>
<xsl:when test="$stateCode='D4'">
BOUVET ISLAND
 </xsl:when>
<xsl:when test="$stateCode='D5'">
BRAZIL
 </xsl:when>
<xsl:when test="$stateCode='D6'">
BRITISH INDIAN OCEAN TERRITORY
 </xsl:when>
<xsl:when test="$stateCode='D7'">
SOLOMON ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='D8'">
VIRGIN ISLANDS, BRITISH
 </xsl:when>
<xsl:when test="$stateCode='D9'">
BRUNEI DARUSSALAM
 </xsl:when>
<xsl:when test="$stateCode='E0'">
BULGARIA
 </xsl:when>
<xsl:when test="$stateCode='E1'">
MYANMAR
 </xsl:when>
<xsl:when test="$stateCode='E2'">
BURUNDI
 </xsl:when>
<xsl:when test="$stateCode='E3'">
CAMBODIA
 </xsl:when>
<xsl:when test="$stateCode='E4'">
CAMEROON
 </xsl:when>
<xsl:when test="$stateCode='E8'">
CAPE VERDE
 </xsl:when>
<xsl:when test="$stateCode='E9'">
CAYMAN ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='F0'">
CENTRAL AFRICAN REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='F1'">
SRI LANKA
 </xsl:when>
<xsl:when test="$stateCode='F2'">
CHAD
 </xsl:when>
<xsl:when test="$stateCode='F3'">
CHILE
 </xsl:when>
<xsl:when test="$stateCode='F4'">
CHINA
 </xsl:when>
<xsl:when test="$stateCode='F5'">
TAIWAN, PROVINCE OF CHINA
 </xsl:when>
<xsl:when test="$stateCode='F6'">
CHRISTMAS ISLAND
 </xsl:when>
<xsl:when test="$stateCode='F7'">
COCOS (KEELING) ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='F8'">
COLOMBIA
 </xsl:when>
<xsl:when test="$stateCode='F9'">
COMOROS
 </xsl:when>
<xsl:when test="$stateCode='G0'">
CONGO
 </xsl:when>
<xsl:when test="$stateCode='G1'">
COOK ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='G2'">
COSTA RICA
 </xsl:when>
<xsl:when test="$stateCode='G3'">
CUBA
 </xsl:when>
<xsl:when test="$stateCode='G4'">
CYPRUS
 </xsl:when>
<xsl:when test="$stateCode='G6'">
BENIN
 </xsl:when>
<xsl:when test="$stateCode='G7'">
DENMARK
 </xsl:when>
<xsl:when test="$stateCode='G8'">
DOMINICAN REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='G9'">
DOMINICA
 </xsl:when>
<xsl:when test="$stateCode='GU'">
GUAM
 </xsl:when>
<xsl:when test="$stateCode='H1'">
ECUADOR
 </xsl:when>
<xsl:when test="$stateCode='H2'">
EGYPT
 </xsl:when>
<xsl:when test="$stateCode='H3'">
EL SALVADOR
 </xsl:when>
<xsl:when test="$stateCode='H4'">
EQUATORIAL GUINEA
 </xsl:when>
<xsl:when test="$stateCode='H5'">
ETHIOPIA
 </xsl:when>
<xsl:when test="$stateCode='H6'">
FAROE ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='H7'">
FALKLAND ISLANDS (MALVINAS)
 </xsl:when>
<xsl:when test="$stateCode='H8'">
FIJI
 </xsl:when>
<xsl:when test="$stateCode='H9'">
FINLAND
 </xsl:when>
<xsl:when test="$stateCode='I0'">
FRANCE
 </xsl:when>
<xsl:when test="$stateCode='I3'">
FRENCH GUIANA
 </xsl:when>
<xsl:when test="$stateCode='I4'">
FRENCH POLYNESIA
 </xsl:when>
<xsl:when test="$stateCode='I5'">
GABON
 </xsl:when>
<xsl:when test="$stateCode='I6'">
GAMBIA
 </xsl:when>
<xsl:when test="$stateCode='J0'">
GHANA
 </xsl:when>
<xsl:when test="$stateCode='J1'">
GIBRALTAR
 </xsl:when>
<xsl:when test="$stateCode='J2'">
KIRIBATI
 </xsl:when>
<xsl:when test="$stateCode='J3'">
GREECE
 </xsl:when>
<xsl:when test="$stateCode='J4'">
GREENLAND
 </xsl:when>
<xsl:when test="$stateCode='J5'">
GRENADA
 </xsl:when>
<xsl:when test="$stateCode='J6'">
GUADELOUPE
 </xsl:when>
<xsl:when test="$stateCode='J8'">
GUATEMALA
 </xsl:when>
<xsl:when test="$stateCode='J9'">
GUINEA
 </xsl:when>
<xsl:when test="$stateCode='K0'">
GUYANA
 </xsl:when>
<xsl:when test="$stateCode='K1'">
HAITI
 </xsl:when>
<xsl:when test="$stateCode='K2'">
HONDURAS
 </xsl:when>
<xsl:when test="$stateCode='K3'">
HONG KONG
 </xsl:when>
<xsl:when test="$stateCode='K4'">
HEARD ISLAND AND MCDONALD ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='K5'">
HUNGARY
 </xsl:when>
<xsl:when test="$stateCode='K6'">
ICELAND
 </xsl:when>
<xsl:when test="$stateCode='K7'">
INDIA
 </xsl:when>
<xsl:when test="$stateCode='K8'">
INDONESIA
 </xsl:when>
<xsl:when test="$stateCode='K9'">
IRAN, ISLAMIC REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='L0'">
IRAQ
 </xsl:when>
<xsl:when test="$stateCode='L2'">
IRELAND
 </xsl:when>
<xsl:when test="$stateCode='L3'">
ISRAEL
 </xsl:when>
<xsl:when test="$stateCode='L6'">
ITALY
 </xsl:when>
<xsl:when test="$stateCode='L7'">
COTE D'IVOIRE
 </xsl:when>
<xsl:when test="$stateCode='L8'">
JAMAICA
 </xsl:when>
<xsl:when test="$stateCode='L9'">
SVALBARD AND JAN MAYEN
 </xsl:when>
<xsl:when test="$stateCode='M0'">
JAPAN
 </xsl:when>
<xsl:when test="$stateCode='M2'">
JORDAN
 </xsl:when>
<xsl:when test="$stateCode='M3'">
KENYA
 </xsl:when>
<xsl:when test="$stateCode='M4'">
KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='M5'">
KOREA, REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='M6'">
KUWAIT
 </xsl:when>
<xsl:when test="$stateCode='M7'">
LAO PEOPLE'S DEMOCRATIC REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='M8'">
LEBANON
 </xsl:when>
<xsl:when test="$stateCode='M9'">
LESOTHO
 </xsl:when>
<xsl:when test="$stateCode='N0'">
LIBERIA
 </xsl:when>
<xsl:when test="$stateCode='N1'">
LIBYAN ARAB JAMAHIRIYA
 </xsl:when>
<xsl:when test="$stateCode='N2'">
LIECHTENSTEIN
 </xsl:when>
<xsl:when test="$stateCode='N4'">
LUXEMBOURG
 </xsl:when>
<xsl:when test="$stateCode='N5'">
MACAU
 </xsl:when>
<xsl:when test="$stateCode='N6'">
MADAGASCAR
 </xsl:when>
<xsl:when test="$stateCode='N7'">
MALAWI
 </xsl:when>
<xsl:when test="$stateCode='N8'">
MALAYSIA
 </xsl:when>
<xsl:when test="$stateCode='N9'">
MALDIVES
 </xsl:when>
<xsl:when test="$stateCode='O0'">
MALI
 </xsl:when>
<xsl:when test="$stateCode='O1'">
MALTA
 </xsl:when>
<xsl:when test="$stateCode='O2'">
MARTINIQUE
 </xsl:when>
<xsl:when test="$stateCode='O3'">
MAURITANIA
 </xsl:when>
<xsl:when test="$stateCode='O4'">
MAURITIUS
 </xsl:when>
<xsl:when test="$stateCode='O5'">
MEXICO
 </xsl:when>
<xsl:when test="$stateCode='O9'">
MONACO
 </xsl:when>
<xsl:when test="$stateCode='P0'">
MONGOLIA
 </xsl:when>
<xsl:when test="$stateCode='P1'">
MONTSERRAT
 </xsl:when>
<xsl:when test="$stateCode='P2'">
MOROCCO
 </xsl:when>
<xsl:when test="$stateCode='P3'">
MOZAMBIQUE
 </xsl:when>
<xsl:when test="$stateCode='P4'">
OMAN
 </xsl:when>
<xsl:when test="$stateCode='P5'">
NAURU
 </xsl:when>
<xsl:when test="$stateCode='P6'">
NEPAL
 </xsl:when>
<xsl:when test="$stateCode='P7'">
NETHERLANDS
 </xsl:when>
<xsl:when test="$stateCode='P8'">
NETHERLANDS ANTILLES
 </xsl:when>
<xsl:when test="$stateCode='PR'">
PUERTO RICO
 </xsl:when>
<xsl:when test="$stateCode='Q1'">
VIET NAM
 </xsl:when>
<xsl:when test="$stateCode='Q2'">
NEW ZEALAND
 </xsl:when>
<xsl:when test="$stateCode='Q3'">
NICARAGUA
 </xsl:when>
<xsl:when test="$stateCode='Q4'">
NIGER
 </xsl:when>
<xsl:when test="$stateCode='Q5'">
NIGERIA
 </xsl:when>
<xsl:when test="$stateCode='Q6'">
NIUE
 </xsl:when>
<xsl:when test="$stateCode='Q7'">
NORFOLK ISLAND
 </xsl:when>
<xsl:when test="$stateCode='Q8'">
NORWAY
 </xsl:when>
<xsl:when test="$stateCode='R0'">
PAKISTAN
 </xsl:when>
<xsl:when test="$stateCode='R1'">
PANAMA
 </xsl:when>
<xsl:when test="$stateCode='R2'">
PAPUA NEW GUINEA
 </xsl:when>
<xsl:when test="$stateCode='R4'">
PARAGUAY
 </xsl:when>
<xsl:when test="$stateCode='R5'">
PERU
 </xsl:when>
<xsl:when test="$stateCode='R6'">
PHILIPPINES
 </xsl:when>
<xsl:when test="$stateCode='R8'">
PITCAIRN
 </xsl:when>
<xsl:when test="$stateCode='R9'">
POLAND
 </xsl:when>
<xsl:when test="$stateCode='S0'">
GUINEA-BISSAU
 </xsl:when>
<xsl:when test="$stateCode='S1'">
PORTUGAL
 </xsl:when>
<xsl:when test="$stateCode='S3'">
QATAR
 </xsl:when>
<xsl:when test="$stateCode='S4'">
REUNION
 </xsl:when>
<xsl:when test="$stateCode='S5'">
ROMANIA
 </xsl:when>
<xsl:when test="$stateCode='S6'">
RWANDA
 </xsl:when>
<xsl:when test="$stateCode='S8'">
SAN MARINO
 </xsl:when>
<xsl:when test="$stateCode='S9'">
SAO TOME AND PRINCIPE
 </xsl:when>
<xsl:when test="$stateCode='T0'">
SAUDI ARABIA
 </xsl:when>
<xsl:when test="$stateCode='T1'">
SENEGAL
 </xsl:when>
<xsl:when test="$stateCode='T2'">
SEYCHELLES
 </xsl:when>
<xsl:when test="$stateCode='T3'">
SOUTH AFRICA
 </xsl:when>
<xsl:when test="$stateCode='T6'">
NAMIBIA
 </xsl:when>
<xsl:when test="$stateCode='T7'">
YEMEN
 </xsl:when>
<xsl:when test="$stateCode='T8'">
SIERRA LEONE
 </xsl:when>
<xsl:when test="$stateCode='U0'">
SINGAPORE
 </xsl:when>
<xsl:when test="$stateCode='U1'">
SOMALIA
 </xsl:when>
<xsl:when test="$stateCode='U3'">
SPAIN
 </xsl:when>
<xsl:when test="$stateCode='U5'">
WESTERN SAHARA
 </xsl:when>
<xsl:when test="$stateCode='U7'">
SAINT KITTS AND NEVIS
 </xsl:when>
<xsl:when test="$stateCode='U8'">
SAINT HELENA
 </xsl:when>
<xsl:when test="$stateCode='U9'">
SAINT LUCIA
 </xsl:when>
<xsl:when test="$stateCode='V0'">
SAINT PIERRE AND MIQUELON
 </xsl:when>
<xsl:when test="$stateCode='V1'">
SAINT VINCENT AND THE GRENADINES
 </xsl:when>
<xsl:when test="$stateCode='V2'">
SUDAN
 </xsl:when>
<xsl:when test="$stateCode='V3'">
SURINAME
 </xsl:when>
<xsl:when test="$stateCode='V6'">
SWAZILAND
 </xsl:when>
<xsl:when test="$stateCode='V7'">
SWEDEN
 </xsl:when>
<xsl:when test="$stateCode='V8'">
SWITZERLAND
 </xsl:when>
<xsl:when test="$stateCode='V9'">
SYRIAN ARAB REPUBLIC
 </xsl:when>
<xsl:when test="$stateCode='VI'">
VIRGIN ISLANDS, U.S.
 </xsl:when>
<xsl:when test="$stateCode='W0'">
TANZANIA, UNITED REPUBLIC OF
 </xsl:when>
<xsl:when test="$stateCode='W1'">
THAILAND
 </xsl:when>
<xsl:when test="$stateCode='W2'">
TOGO
 </xsl:when>
<xsl:when test="$stateCode='W3'">
TOKELAU
 </xsl:when>
<xsl:when test="$stateCode='W4'">
TONGA
 </xsl:when>
<xsl:when test="$stateCode='W5'">
TRINIDAD AND TOBAGO
 </xsl:when>
<xsl:when test="$stateCode='W6'">
TUNISIA
 </xsl:when>
<xsl:when test="$stateCode='W7'">
TURKS AND CAICOS ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='W8'">
TURKEY
 </xsl:when>
<xsl:when test="$stateCode='W9'">
UGANDA
 </xsl:when>
<xsl:when test="$stateCode='X0'">
UNITED KINGDOM
 </xsl:when>
<xsl:when test="$stateCode='X2'">
BURKINA FASO
 </xsl:when>
<xsl:when test="$stateCode='X3'">
URUGUAY
 </xsl:when>
<xsl:when test="$stateCode='X4'">
HOLY SEE (VATICAN CITY STATE)
 </xsl:when>
<xsl:when test="$stateCode='X5'">
VENEZUELA
 </xsl:when>
<xsl:when test="$stateCode='X8'">
WALLIS AND FUTUNA
 </xsl:when>
<xsl:when test="$stateCode='Y0'">
SAMOA
 </xsl:when>
<xsl:when test="$stateCode='Y3'">
CONGO, THE DEMOCRATIC REPUBLIC OF THE
 </xsl:when>
<xsl:when test="$stateCode='Y4'">
ZAMBIA
 </xsl:when>
<xsl:when test="$stateCode='Y5'">
ZIMBABWE
 </xsl:when>
<xsl:when test="$stateCode='Y6'">
ALAND ISLANDS
 </xsl:when>
<xsl:when test="$stateCode='Y7'">
GUERNSEY
 </xsl:when>
<xsl:when test="$stateCode='Y8'">
ISLE OF MAN
 </xsl:when>
<xsl:when test="$stateCode='Y9'">
JERSEY
 </xsl:when>
<xsl:when test="$stateCode='Z0'">
SAINT BARTHELEMY
 </xsl:when>
<xsl:when test="$stateCode='Z1'">
SAINT MARTIN
 </xsl:when>
<xsl:when test="$stateCode='Z2'">
SERBIA
 </xsl:when>
<xsl:when test="$stateCode='Z3'">
TIMOR-LESTE
 </xsl:when>
<xsl:when test="$stateCode='Z5'">
MONTENEGRO
 </xsl:when>
<xsl:when test="$stateCode='XX'">
Unknown
</xsl:when>
<xsl:when test="$stateCode='2F'">
EAST TIMOR
</xsl:when>
<xsl:when test="$stateCode='C2'">
ASHMORE &#38; CARTIER IS
</xsl:when>
<xsl:when test="$stateCode='E5'">
CANAL ZONE
</xsl:when>
<xsl:when test="$stateCode='E6'">
MONTREAL, CANADA
</xsl:when>
<xsl:when test="$stateCode='E7'">
CANTON/ENDERBURY IS
</xsl:when>
<xsl:when test="$stateCode='G5'">
CZECHOSLOVAKIA
</xsl:when>
<xsl:when test="$stateCode='I7'">
GAZA STRIP
</xsl:when>
<xsl:when test="$stateCode='I8'">
GERMANY (WEST)
</xsl:when>
<xsl:when test="$stateCode='I9'">
GERMANY, FED. REP.
</xsl:when>
<xsl:when test="$stateCode='L1'">
IRAQ-SAUDI
</xsl:when>
<xsl:when test="$stateCode='L4'">
ISRAEL-JORDAN
</xsl:when>
<xsl:when test="$stateCode='L5'">
ISRAEL-SYRIA
</xsl:when>
<xsl:when test="$stateCode='M1'">
JOHNSTON ATOLL
</xsl:when>
<xsl:when test="$stateCode='O6'">
MIDWAY ISLAND
</xsl:when>
<xsl:when test="$stateCode='Q9'">
PACIFIC ISLANDS TRU
</xsl:when>
<xsl:when test="$stateCode='R3'">
PARACEL ISLANDS
</xsl:when>
<xsl:when test="$stateCode='T4'">
SOUTHERN RHODESIA
</xsl:when>
<xsl:when test="$stateCode='U2'">
SOVIET UNION
</xsl:when>
<xsl:when test="$stateCode='U4'">
SPANISH NORTH AFRICA
</xsl:when>
<xsl:when test="$stateCode='U6'">
SPRATLY ISLAND
</xsl:when>
<xsl:when test="$stateCode='X7'">
WAKE ISLAND
</xsl:when>
<xsl:when test="$stateCode='X9'">
GERMANY (BERLIN)
</xsl:when>
<xsl:when test="$stateCode='Y2'">
YUGOSLAVIA
</xsl:when>
<xsl:otherwise><xsl:value-of select="$stateCode" /></xsl:otherwise>
</xsl:choose>
   </xsl:template>
</xsl:stylesheet>