<?xml version="1.0" encoding="UTF-8"?><!-- DWXMLSource="Sample.xml" -->
<!DOCTYPE xsl:stylesheet  [<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   
   <xsl:import href="util.xsl"/>
	
	<xsl:output
		method="html"
		indent="no"
		encoding="UTF-8"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:template
		match="/">
		<html>
			<head>
				<link
					rel="stylesheet"
					type="text/css"
					href="css/MAI_print.css" />
			</head>
			<body>

				<xsl:call-template
					name="header" />
				<xsl:apply-templates />

			</body>

		</html>
	</xsl:template>


	<xsl:template
		name="header">
		<div
			class="contentwrapper">
			<div
				id="header" style="margin-left:0; margin-right:0;">
			<div class="header1" style="margin-left:0; margin-right:0;">
				<div style="margin-left:0; margin-right:0;">
					<xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I'">
					<div
						class="title1" style="margin-left:0; margin-right:0;">FORM MA-I</div>
				</xsl:if>
				
				<xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I-A'">
					<div
						class="title1" style="margin-left:0; margin-right:0;">FORM MA-I-A</div>
				</xsl:if>
				
				<xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I/A'">
				<div
						class="title1" style="margin-left:0; margin-right:0;">FORM MA-I/A</div>
				</xsl:if>
					<div
						class="center1" style="margin-right:0;">
						UNITED STATES
						<br />
						SECURITIES AND EXCHANGE COMMISSION
						<br />
						Washington, D.C. 20549
					</div>
					<div
						class="title2" style="margin-left:0; margin-right:0;">OMB APPROVAL</div>
				</div>
				
			<xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I'">
				<div style="margin-left:0; margin-right:0;">
					<div
						class="side1" style="margin-left:0; margin-right:0;">
						
						<p>APPLICATION FOR <em>MUNICIPAL ADVISOR</em> REGISTRATION FOR NATURAL PERSONS</p>
					</div>
					<div
						class="side2" style="margin-left:0; margin-right:0;">
						<p>OMB Number:&#160;&#160;3235-0681</p>
						 <hr></hr>
						<p>Estimated average burden hours per response:&#160;3.0</p>
					</div>
				</div>
				</xsl:if>
				
				<xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I-A'">
				<div style="margin-left:0; margin-right:0;">
					<div
						class="side1" style="margin-left:0; margin-right:0;">
						
						<p><em>MUNICIPAL ADVISOR</em>’S ANNUAL SELF-CERTIFICATION FOR NATURAL PERSONS</p>
					</div>
				<div
						class="side2" style="margin-left:0; margin-right:0;">
						<p>OMB Number:&#160;&#160;3235-0681</p>
						 <hr></hr>
						<p>Estimated average burden hours per response:&#160;0.5</p>
					</div>
				</div>
				</xsl:if>
				
				<xsl:if test="n2:edgarSubmission/n2:headerData/n2:submissionType = 'MA-I/A'">
				<div style="margin-left:0; margin-right:0;">
					<div
						class="side1" style="margin-left:0; margin-right:0;">
						
						<p>AMENDMENT TO THE <em>MUNICIPAL ADVISOR</em>’S MOST RECENT FORM MA-I</p>
					</div>
					<div
						class="side2" style="margin-left:0; margin-right:0;">
						<p>OMB Number:&#160;&#160;3235-0681</p>
						 <hr></hr>
						<p>Estimated average burden hours per response:&#160;0.5</p>
					</div>
				</div>
				</xsl:if>
			</div>
			</div>
		</div>
	</xsl:template>	
	
		<xsl:template
		match="n2:edgarSubmission">
		<xsl:apply-templates
			select="n2:headerData/n2:filerInfo" />
			<div class="contentwrapper">
    <div class="content">
    <h3>PART 1</h3>
            <div class="formDescription">
                <div>
                <div class="form1">
                    This form must be completed by 
                    
                    <p>Every <em>municipal advisory firm</em> 
                     applying for registration or registered as a <em>municipal advisor</em> on Form MA, to provide information regarding each <em>natural person</em> who is an <em>associated person</em> of the firm and engages in <em>municipal advisory activities</em> on the firm's behalf (for purposes of Form MA-I, the &quot;individual&quot;); and
                    </p>
                    <p>Every <em>natural person</em> (sole proprietor) applying for registration as a <em>municipal advisor</em> on Form MA, to provide additional personal information. </p>
                </div>
                </div>
                <div>
                   <h2> WARNING</h2>
                    <p style="font-weight: normal;">
                        Complete this form truthfully.  False statements or omissions may
                        result in denial of a <em>municipal advisor's</em> application, revocation or
                        suspension of such registration, or criminal prosecution.  
                        Form MA-I must be amended promptly whenever
                        any information previously provided becomes inaccurate.  See
                        General Instruction 9. 
                    </p>
                    <h3><u>Type of Filing</u>:</h3>
					This is an (check the appropriate box):                    
                </div>
        </div>    
	<div class="mainDiv2" style="margin-left:0; margin-right:0;">
		<div style="margin-left:0; margin-right:0;"><div class="label40" style="margin-left:0; margin-right:0;">
			<xsl:choose>
				<xsl:when
					test="n2:headerData/n2:submissionType = 'MA-I'">
					<img
						src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img
						src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>
			Initial Form MA-I
			<br></br>
			</div>
			</div>
			<div style="margin-left:0; margin-right:0;">		
			<div class="label40" style="margin-left:0; margin-right:0;"><u>Execution Pages</u>:  
              Before submitting this form, you must complete the Execution Page.
			</div>
		</div>
		<div style="margin-left:0; margin-right:0;">
			<div class="label40" style="margin-left:0; margin-right:0;"><u>Supporting Documentation</u>:  
              If you are required to make reportable disclosures in the Disclosure Reporting Pages, you must attach the supporting documentation.
			</div>
		</div>
		<div style="margin-left:0; margin-right:0;">
			<div class="label40" style="margin-left:0; margin-right:0;"><u><em>Non-Resident</em> Individuals</u>:  
              If the individual is a <em>non-resident</em>
                        of the United States, you must attach a completed Form MA-NR signed by 
                        the individual to
                        this Form MA-I at the time of initial filing of Form MA-I. See the General
                        Instructions.
			</div>
		</div>		
		<br></br>
		<xsl:choose>
				
			<xsl:when test="n2:headerData/n2:submissionType = 'MA-I/A' and not(n2:formData/n2:isIndividual)">
			
				<div>
			<div class="content label40" style="margin-left:0; margin-right:0;">
					<img
						src="Images/box-checked.jpg" alt="checkbox checked" />
			
			Amendment to the most recent Form MA-I
			<br></br>
			</div>		
		</div>
		<br></br>
		<div style="margin-left:0; margin-right:0;">
			<div class="content label40" style="margin-left:0; margin-right:0;">
			
					<img
						src="Images/box-greyed.jpg" alt="disabled checkbox" />
				
			Amendment to indicate that the individual is no longer an <em>associated person</em> of 
			the <em>municipal advisory firm </em>or no longer engages in <em>municipal advisory activities</em> on its behalf.
			<em> (If you check this box, complete only Item 1-A and Item 7 below.)</em>
			<br></br>
			</div>		
		</div>				
			</xsl:when>			
			<xsl:otherwise>
				<div style="margin-left:0; margin-right:0;">
			<div class="content label40" style="margin-left:0; margin-right:0;">
			<xsl:choose>
				<xsl:when
					test="n2:headerData/n2:submissionType = 'MA-I/A' and n2:formData/n2:isIndividual = 'N'">
					<img
						src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img
						src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>
			Amendment to the most recent Form MA-I
			<br></br>
			</div>		
		</div>
		<br></br>
		<div style="margin-left:0; margin-right:0;">
			<div class="content label40" style="margin-left:0; margin-right:0;">
			<xsl:choose>
				<xsl:when
					test="n2:formData/n2:isIndividual = 'Y'">
					<img
						src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img
						src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
				</xsl:otherwise>
			</xsl:choose>
			Amendment to indicate that the individual is no longer an <em>associated person</em> of 
			the <em>municipal advisory firm </em>or no longer engages in <em>municipal advisory activities</em> on its behalf.
			<em> (If you check this box, complete only Item 1-A and Item 7 below.)</em>
			<br></br>
			</div>		
		</div>
		</xsl:otherwise>
		
		</xsl:choose>		
				
	</div>
      </div></div>
		<xsl:apply-templates
			select="n2:formData" />
	</xsl:template>

	<xsl:template
		match="n2:headerData/n2:filerInfo">
		<div
			id="info">
			<div
				class="contentwrapper">
				<div class="content">
					<h1>Form MA-I Applicant's Information </h1>
					<div class="mainDiv2" style="margin-left:0; margin-right:0;height:70px;">
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div class="twocol">Filer's CIK:
								</div>
							<div class="twocol value2" style="margin-left:0; margin-right:0;">
								 
										<xsl:value-of
										select="string(ns2:filer/ns1:filerId)" />
									 
							</div>
						</div>
						<div class="clear"></div>
						
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div class="twocol">Filer's CCC:
								</div>
							<div class="twocol value2" style="margin-left:0; margin-right:0;"> 
							
							</div>
						</div>
						
					</div>
					<div class="clear"></div>
					<h3>Submission Contact Information</h3>
					<div class="mainDiv2" style="margin-left:0; margin-right:0;height:100px;">
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div class="twocol">Name:
								</div>
							<div class="twocol value2" style="margin-left:0; margin-right:0;">
								<xsl:value-of
									select="string(ns2:contact/ns1:name)" />
							</div>
						</div>
						<div class="clear"></div>
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div class="twocol">Phone:
								</div>
							<div
								class="twocol value2" style="margin-left:0; margin-right:0;">
								<xsl:value-of
									select="string(ns2:contact/ns1:phoneNumber)" />
							</div>
						</div>
						<div class="clear"></div>
						<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
							<div class="twocol">Email Address:
								</div>
							<div class="twocol value2" style="margin-left:0; margin-right:0;">
								<xsl:value-of
									select="string(ns2:contactEmail)" />
							</div>
						</div>
					</div>
					<div class="clear"></div>
					<h3>Notification Information</h3>
					<p>Notification will automatically be sent to the Login CIK,
						Submission Contact, and Primary Issuers. Specify additional
						addresses below.</p>
					<xsl:apply-templates
						select="ns2:notifications/ns1:internetNotificationAddress" />
					<p>
                    Please read the General Instructions for this form and other forms in the MA series, as well as its subsection, &quot;Specific Instructions for Form MA-I,&quot; before completing this form.  All italicized terms herein are defined or described in the Glossary of Terms appended to the General Instructions.
                    </p>
				</div>
			</div>
		</div>
	</xsl:template>


	<xsl:template
		match="ns2:notifications/ns1:internetNotificationAddress">
		<div class="mainDiv2" style="margin-left:0; margin-right:0;height:32px;">
			<div style="width:100%; display:flex; margin-left:0; margin-right:0;">
				<div class="twocol">Email Address:
					</div>
				<div class="twocol value2" style="margin-left:0; margin-right:0;">
					 
						<xsl:value-of
							select="string(.)" />
					 
				 
				</div>
			</div>
		</div>
		<div class="clear"></div>
	</xsl:template>

	<!-- Form Data Template -->
	<xsl:template
		match="n2:formData">
		 <xsl:call-template
					name="Item1" />
							 <xsl:call-template
					name="Item2" />
							 <xsl:call-template
					name="Item3" />
							 <xsl:call-template
					name="Item4" />
					<xsl:call-template
					name="Item5" />
					 <xsl:call-template
					name="Item6" />
					 <xsl:call-template
					name="Item7" />
					 <xsl:call-template
					name="criminalDisclosureDrp" />		
					 <xsl:call-template
					name="RegActDisDrp" />		
					 <xsl:call-template
					name="INVESTIGATION_DRP" />		
						 <xsl:call-template
					name="TerminationDrp" />		
							
							 <xsl:call-template
					name="JUDGMENT_LIEN_DRP" />					 
					
						 <xsl:call-template
					name="CivilDrp" />		
					<xsl:call-template
					name="CustomerDrp" />
							
												
		
		</xsl:template>
<xsl:include href="MA_State_Codes.xsl" />
<xsl:include href="MAI_item1.xsl" />
<xsl:include href="MAI_item2.xsl"/>
<xsl:include href="MAI_item3.xsl" />
<xsl:include href="MAI_item4.xsl" />
<xsl:include href="MAI_item5.xsl" />
<xsl:include href="MAI_item6.xsl" />
<xsl:include href="MAI_item7.xsl" />
<xsl:include href="MAI_Customer_DRP.xsl" />
<xsl:include href="MAI_JUD_LIEN_DISC.xsl" />
<xsl:include href="MA-I_Reg_Act_Clsr_DRP.xsl" />
<xsl:include href="MAI_Termination_DRP.xsl" />
<xsl:include href="MAI_INVESTIGATION_DRP.xsl" />
<xsl:include href="MAI_criminal-drp.xsl" />
<xsl:include href="MAI_Civil_DRP.xsl" />

</xsl:stylesheet>
	