<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Schedule C templates -->
	
<xsl:template name="scheduleC" >
 <div class="guidance"> <a class="head" href="#" onclick="showHide('helpschedb');return false;"></a>
          <div id="helpschedb" class="deets">
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">1.</div>
                <div class="tdStyle1 tdscheduleacol2"><b>Use Schedule C only to amend information requested on either Schedule A or Schedule B.</b>  Refer to instructions in Schedule A and Schedule B, which also apply for this Schedule C.</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">2.</div>
                <div class="tdStyle1 tdscheduleacol2"><b>In the Type of Amendment column, indicate &quot;A&quot; (addition), &quot;D&quot; (deletion), or &quot;C&quot; (change in information about the same <em>person</em>).</b></div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleacol1">3.</div>
                <div class="tdStyle1 tdscheduleacol2"><b>Ownership Codes are:</b>
                  <div class="tableStyle" style="margin-left:0; margin-right:0;">
				  <div class="tableRow">
                    
					  <div class="tdStyle" style="margin-left:0; margin-right:0;padding-left:18px;">
					  <li>NA - less than 5%</li>
					  <li>A - 5% but less than 10%</li>
					  <li>B - 10% but less than 25%</li>
                      <li>C - 25% but less than 50%</li>
                      <li>D - 50% but less than 75%</li>
                      <li>E - 75% or more</li>
                      <li>F - Other (general partner, trustee, or elected member)</li>
                      </div>
                    </div>
                  </div>				  
				  </div>
				  <div style="clear:both;"></div>
              </div>
            </div>
			
            <p class="right"><a href="#" onclick="hide('helpschedb');return false;"></a></p>
          </div>
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle1 tdscheduleaonly1col" >4. &#160;&#160;&#160;&#160;<b>List below all changes to Schedule A:</b></div>
          </div>
		  <div style="clear:both;"></div>
        </div>
        <div class="scheduleBox hide" id="schedCa1entry">
          <h2><b>Schedule A-1: Direct Owners of Applicant - Business Entities</b></h2>
           <xsl:for-each select="m1:formData/m1:scheduleC/m1:directBusinesses/m1:business">
          <div class="newRecord hide" id="newschedA1">
         	<h3>Entry</h3>
          	<div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                 <div class="tdStyle" style="margin-left:0; margin-right:0;">BUSINESS ENTITY FULL LEGAL NAME:<br/>
					<div class="fakeBox">
	                <xsl:value-of
	                    select="m1:baseInformation/m1:name"/>
	                <span>
	                    <xsl:text>&#160;</xsl:text>
	                </span>
                    </div>
                  </div>
              </div>
            </div>
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle1" style="margin-left:0; margin-right:0;">DE/FE:                  
                  <span
						class="label">
						<xsl:choose>
							<xsl:when test="count(m1:baseInformation/m1:deFeNp/m1:de) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						DE
						<xsl:choose>
							<xsl:when test="count(m1:baseInformation/m1:deFeNp/m1:fe) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						 FE
					</span>
                  </div>
              </div>
            </div>
         
	         <div class="tableStyle" style="margin-left:0; margin-right:0;">
	          <div class="tableRow">
	            <div class="padded tdStyle" style="margin-left:0; margin-right:0;">Type of Amendment: </div>
	          </div>
	          <div class="tableRow">
	           <div class="tdStyle" style="margin-left:0; margin-right:0;">
		  			<xsl:choose>
							<xsl:when
								test="count(m1:type/ns2:add) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						A (addition)
						<xsl:choose>
							<xsl:when test="count(m1:type/ns2:delete) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						D (deletion)
						<xsl:choose>
							<xsl:when
								test="count(m1:type/ns2:amend) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
							C (change in information)						
					</div>
	          </div>
	        </div>
             <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Title or Status:<br/>
                <!-- 
                    <input 	type="text" 	name="title2" 		readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:titleStatus"/>
						</xsl:attribute>
					</input>
					-->
					<div class="fakeBox">
                    <xsl:value-of
                        select="m1:baseInformation/m1:baseInformation/m1:titleStatus"/>
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                    </div>
                  </div>
               </div>
             </div>     
             <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Date Title or Status Acquired: 
                   <input 	type="text" 	name="title date2" class="dateField"		readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:statusAcquired"/>
						</xsl:attribute>
					</input>
                 </div>
              </div>
              </div>
              
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Ownership Code:</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
	                  <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='NA']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
	                 NA-less than 5%
                 </div>
                 <div class="tdStyle1 tdscheduleagridcol1">
                 	<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='A']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                 	 A-5% but less than 10%
                </div>
                <div class="tdStyle1 tdscheduleagridcol1">
	                 <xsl:choose>
							<xsl:when
								test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='B']) &gt; 0 ">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
					</xsl:choose>
                 	 B-10% but less than 25%
                 </div>
				<div style="clear:both;"></div>
                
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1"> 
                	<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  C - 25% but less than 50%
                </div>
                <div class="tdStyle1 tdscheduleagridcol1"> 
	                <xsl:choose>
							<xsl:when
								test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
					</xsl:choose>
	                  D-50% but less than 75%
	           </div>
	           <div class="tdStyle1 tdscheduleagridcol1">
               		<xsl:choose>
                        <xsl:when
                            test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                        </xsl:when>
                        <xsl:otherwise>
                     	   <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                   	</xsl:choose>
                  	E-75% or more
           		</div>
				<div style="clear:both;"></div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1"><xsl:choose>
                        <xsl:when
                            test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='F']) &gt; 0 ">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                        </xsl:when>
                        <xsl:otherwise>
                        	<img  src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                      </xsl:choose>
                  	F - Other (general partner, trustee, or elected manager) 
                 </div>
              </div>
			  <div style="clear:both;"></div>
             </div>			 
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
	              <div class="tableRow">
	                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;"><em>Control person</em>:
	                     <xsl:choose>                
	                		<xsl:when
								test="m1:baseInformation/m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInformation/m1:baseInformation/m1:isControPerson  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
							</xsl:when>
							 <xsl:when
								test="m1:baseInformation/m1:baseInformation/m1:isControPerson = 'N' or m1:baseInformation/m1:baseInformation/m1:isControPerson  = 'n'">
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
							</xsl:when>
							<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO</xsl:otherwise>
						</xsl:choose>
			          </div>
	              </div>
	              <div class="tableRow">
	                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;">PR:
	                	  <xsl:choose>                
	                		<xsl:when
								test="m1:baseInformation/m1:controPersonPR = 'Y' or m1:baseInformation/m1:controPersonPR  = 'y'">
									<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
							</xsl:when>
							 <xsl:when
								test="m1:baseInformation/m1:controPersonPR = 'N' or m1:baseInformation/m1:controPersonPR  = 'n'">
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
							</xsl:when>
							<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO</xsl:otherwise>
						</xsl:choose>
	               </div>
	              </div>
	            </div>
             <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle lavel" style="margin-left:0; margin-right:0; height:21px;">Organization <em>CRD</em> No. (If None: IRS Tax No., EIN, or Foreign Business No.)</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1"><em>CRD</em> No.:                  
                       <input 	type="text" name="CRD3" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                 </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">IRS Tax No.:
                    
                     <input type="text" name="irs tax no2" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:irsNum"/>
						</xsl:attribute>
					</input>
                 </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">EIN.:
                <!--                     
                     <input 	type="text" 	name="employer id no2" 		readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:empIDNumber"/>
						</xsl:attribute>
					</input>
					-->
					<div class="fakeBox">
	                    <xsl:value-of
	                        select="m1:baseInformation/m1:empIDNumber"/>
	                    <span>
	                        <xsl:text>&#160;</xsl:text>
	                    </span>
                    </div>
                 </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">Foreign Bus. No.:
                    <!-- 
                     <input 	type="text" 	name="employer id no3" 		readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:foreignBusIdNo"/>
						</xsl:attribute>
					</input>
					-->
					<div class="fakeBox">
                        <xsl:value-of
                            select="m1:baseInformation/m1:baseInformation/m1:foreignBusIdNo"/>
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
                 </div>
              </div>
			  <div style="clear:both;"></div>
            </div>
             <!-- table class="formTable"> 
              <tr >
                <td  colspan="2">Entity in which Interest is Owned: 
              <div class="fakeBox">
                    <xsl:value-of
                        select="m1:baseInformation/m1:baseInformation/m1:titleStatus"/>
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                    </div>
                 </div>
              </div>
            </div-->
            
          </div>
           </xsl:for-each>
        </div>
         <div class="scheduleBox hide" id="schedCa2entry">
          <h2><b>Schedule A-2: Direct Owners and Executive Officers of Applicant – Natural Persons</b></h2>
    	<xsl:for-each select="m1:formData/m1:scheduleC/m1:directPersons/m1:person">
          <div class="newRecord hide" id="newschedA2">
           <h3><xsl:value-of select="m1:type"/> Entry</h3>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">NATURAL PERSON FULL LEGAL NAME</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Enter all the letters of each name and not initials or other abbreviations.  If no middle name, enter NMN on that line.</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1">Last Name: <br/>
                   <input type="text" name="textfield3" readonly="1" size="75">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:name/ns2:lastName"/>
						</xsl:attribute>
					</input>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">First Name:
                    <input type="text" name="textfield3" readonly="1" size="75">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:name/ns2:firstName"/>
						</xsl:attribute>
					</input>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1"> Middle Name: <br/><input type="text" name="textfield3" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:name/ns2:middleName"/>
						</xsl:attribute>
					</input>
                 </div>
				 <div style="clear:both;"></div>
              </div>
            </div>
             <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle padded" style="margin-left:0; margin-right:0;">Type of Amendment: </div>
          </div>
          <div class="tableRow">
           <div class="tdStyle" style="margin-left:0; margin-right:0;">
    			<xsl:choose>
							<xsl:when
								test="count(m1:type/ns2:add) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						A (addition)
						<xsl:choose>
							<xsl:when test="count(m1:type/ns2:delete) &gt; 0">
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						D (deletion)
						<xsl:choose>
							<xsl:when
								test="count(m1:type/ns2:amend) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
										<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						C (change in information)						
				</div>
          </div>
        </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Title or Status: <br/>
                	 <!-- input type="text" name="title date" class="dateField"	readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:titleStatus"/>
						</xsl:attribute>
					</input-->
					<div class="fakeBox">
                     <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:titleStatus"/>                         
                     	<span>
                       		 <xsl:text>&#160;</xsl:text>
                         </span>
                     </div>  
                 </div>
               </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
               <div class="tableRow">   
               	 <div class="tdStyle" style="margin-left:0; margin-right:0;">Date Title or Status Acquired: 
                	<input type="text" name="title date" class="dateField"	readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:statusAcquired"/> 
						</xsl:attribute>
					</input>
                 </div>
              </div>
              </div>
              <div class="tableStyle" style="margin-left:0; margin-right:0;">
              	<div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Ownership Code:</div>
                </div> 
                <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                  <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='NA']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  	NA - less than 5%
                </div>
                 <div class="tdStyle1 tdscheduleagridcol1">
                	<xsl:choose>
						<xsl:when test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='A']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  	A - 5% but less than 10%
                </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                 <xsl:choose>
						<xsl:when test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='B']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
				</xsl:choose>
                  B - 10% but less than 25%</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                	<xsl:choose>
						<xsl:when test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
            	      C - 25% but less than 50%
            	 </div>
            	  <div class="tdStyle1 tdscheduleagridcol1"> 
                	<xsl:choose>
						<xsl:when test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                	D - 50% but less than 75%
               	</div>      
                <div class="tdStyle1 tdscheduleagridcol1">
                	<xsl:choose>
                        <xsl:when test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                        </xsl:when>
                        <xsl:otherwise>
                        	<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                      </xsl:choose>
                  	E - 75% or more
                </div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                	<xsl:choose>
                        <xsl:when test="count(m1:baseInformation/m1:baseInformation[m1:ownershipCode='F']) &gt; 0 ">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
                        </xsl:when>
                        <xsl:otherwise>
                        	<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                        </xsl:otherwise>
                      </xsl:choose>
                  		F - Other (general partner, trustee, or elected manager) 
                 </div>
              </div>
			  <div style="clear:both;"></div>
            </div> 
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
            	<div class="tableRow">
                 <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;"><em>Control Person</em>:
                     <xsl:choose>                
                		<xsl:when
							test="m1:baseInformation/m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInformation/m1:baseInformation/m1:isControPerson  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> NO
						</xsl:when>
						 <xsl:when
							test="m1:baseInformation/m1:baseInformation/m1:isControPerson = 'N' or m1:baseInformation/m1:baseInformation/m1:isControPerson  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> NO
						</xsl:otherwise>
					</xsl:choose>
                  </div>
              	</div>
            </div>             
              
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;">Individual <em>CRD</em> No. (If none: enter 0000000):</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1"><em>CRD</em> No.: <br/>                 
                       <input type="text"	name="CRD8" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                </div>
              </div>
			  <div style="clear:both;"></div>
            </div>
	        <div class="tableStyle" style="margin-left:0; margin-right:0;">
	          <div class="tableRow">
	            <div class="padded tdStyle" style="margin-left:0; margin-right:0;">5. <strong>List below all changes to Schedule B:</strong></div>
	          </div>
	        </div>  
           
               
          </div>
         </xsl:for-each>
        </div>
        <div class="scheduleBox hide" id="schedCb1entry">
          <h2>Schedule B-1: Indirect Owners of Applicant - Business Entities</h2>
          <xsl:for-each select="m1:formData/m1:scheduleC/m1:indirectBusinesses/m1:business">
          <div class="newRecord hide" id="newschedB1">
           <h3><xsl:value-of select="m1:type"/> Entry</h3>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <!-- td height="40"> 
                	<input type="text" name="Business Entity Full Legal Name2" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:name"/>
						</xsl:attribute>
					</input>
                </div-->
                <div class="tdStyle" style="margin-left:0; margin-right:0;">BUSINESS ENTITY FULL LEGAL NAME: <br/>
                <div class="fakeBox">
                             <xsl:value-of
                                select="m1:baseInformation/m1:baseInfo/m1:name"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
               	</div>
               	</div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">DE/FE:                  
                  	<span
						class="label">
						<xsl:choose>
							<xsl:when test="count(m1:baseInformation/m1:baseInfo/m1:deFeNp/m1:de) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						DE
						<xsl:choose>
							<xsl:when test="count(m1:baseInformation/m1:baseInfo/m1:deFeNp/m1:fe) &gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
								src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						FE
					</span>
                  </div>
              </div>
            </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="tdStyle padded" style="margin-left:0; margin-right:0;">Type of Amendment: </div>
          </div>
          <div class="tableRow">
           <div class="tdStyle" style="margin-left:0; margin-right:0;">
    			<xsl:choose>
					<xsl:when
						test="count(m1:type/ns2:add) &gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				A (addition)
				<xsl:choose>
					<xsl:when test="count(m1:type/ns2:delete) &gt; 0">
							<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				D (deletion)
				<xsl:choose>
					<xsl:when
						test="count(m1:type/ns2:amend) &gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
								<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				C (change in information)						
			</div>
          </div>
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
        	<div class="tableRow">
        	    <div class="tdStyle" style="margin-left:0; margin-right:0;">Entity in which Interest is Owned: <br/>
                       <!-- input type="text" name="textfield4" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:owningEntity"/>
						</xsl:attribute>
					</input-->
					
					<div class="fakeBox">
                             <xsl:value-of select="m1:baseInformation/m1:owningEntity"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                    </div>
                 </div>
              </div>        	
        </div>
        
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Status: 
                	<!-- input 	type="text" 	name="title2" 		readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:titleStatus"/>
						</xsl:attribute>
					</input-->
                  	<div class="fakeBox">
                             <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:titleStatus"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                    </div>
                 </div>
                 </div>
                 </div>
               <div class="tableStyle" style="margin-left:0; margin-right:0;">
                 <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Date Title or Status Acquired:
                 <input type="text" name="title date2" class="dateField" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:statusAcquired"/>
						</xsl:attribute>
					</input>
                </div>
              </div>
             
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
            	<div class="tableRow">
            		<div class="tdStyle" style="margin-left:0; margin-right:0;">Ownership Code:</div>
            	</div>
               <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
    	            <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
					</xsl:choose>
        	          C-25% but less than 50%
        	   </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                 	<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  D-50% but less than 75%
                </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                	 <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  E-75% or more
               	</div>
              <div style="clear:both;"></div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
                	<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='F']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  	F-Other (general partner, trustee, or elected manager)
                </div>
                
              </div>
			  <div style="clear:both;"></div>
            </div>
			<div style="clear:both;"></div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;"><em>Control Person</em>:
                	    <xsl:choose>                
                			<xsl:when
							test="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'y'">
							<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
						</xsl:when>
						 <xsl:when
							test="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson = 'N' or m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO</xsl:otherwise>
					</xsl:choose>
               </div>
              </div>
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;">PR:
                	<xsl:choose>                
                		<xsl:when
							test="m1:baseInformation/m1:baseInfo/m1:controPersonPR = 'Y' or m1:baseInformation/m1:baseInfo/m1:controPersonPR  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
						</xsl:when>
						 <xsl:when
							test="m1:baseInformation/m1:baseInfo/m1:controPersonPR = 'N' or m1:baseInformation/m1:baseInfo/m1:controPersonPR  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO</xsl:otherwise>
					</xsl:choose>
                </div>
              </div>
            </div>           
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Organization <em>CRD</em> No. (If None: IRS Tax No., EIN, or Foreign Business No.):</div>
              </div>
             <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1" style="width:150px;">Organization <em>CRD</em> No.:<br/>                 
                       <input type="text" name="CRD3" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1" >IRS Tax No.:<br/>
                     <input type="text" name="irs tax no2" readonly="1">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:irsNum"/>
						</xsl:attribute>
					</input>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">EIN:<br/>                    
                    <div class="fakeBox">
                             <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:empIDNumber"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>  
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">Foreign Bus. No.:<br/>
                     <div class="fakeBox">
                             <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:foreignBusIdNo"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>  
                </div>
				<div style="clear:both;"></div>
              </div>
			  
            </div>
          </div>
          </xsl:for-each>
        </div>
        <div class="scheduleBox hide" id="schedCb2entry">
          <h2><b>Schedule B-2: Indirect Owners of Applicant - Natural  Persons</b></h2>
           <xsl:for-each select="m1:formData/m1:scheduleC/m1:indirectPersons/m1:person">
          <div class="newRecord hide" id="newschedB2">
           <h3><xsl:value-of select="m1:type"/> Entry</h3>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">NATURAL PERSON FULL LEGAL NAME</div>
              </div>
               <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Enter all the letters of each name and not initials or other abbreviations.  If no middle name, enter NMN on that line.</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1">Last Name: <br/>
                	 <input type="text" name="textfield3" readonly="1" size="50">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:name/ns2:lastName"/>
						</xsl:attribute>
					</input>
                </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">First Name: <br/>
                   <input type="text" name="textfield6" readonly="1" size="50">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:name/ns2:firstName"/>
						</xsl:attribute>
					</input>
                 </div>
                <div class="tdStyle1 tdscheduleagridcrdcol1">Middle Name: <br/>
                	<input type="text" name="textfield7" readonly="1" size="30">
						<xsl:attribute 	name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:name/ns2:middleName"/>
						</xsl:attribute>
					</input>
                
                  </div>
              </div>
            </div>
			<div style="clear:both;"></div>
             <div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
            <div class="padded tdStyle" style="margin-left:0; margin-right:0;">Type of Amendment: </div>
          </div>
          <div class="tableRow">
           <div class="tdStyle" style="margin-left:0; margin-right:0;">
    			<xsl:choose>
					<xsl:when
						test="count(m1:type/ns2:add) &gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				A (addition)
				<xsl:choose>
					<xsl:when test="count(m1:type/ns2:delete) &gt; 0">
							<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				D (deletion)
				<xsl:choose>
					<xsl:when
						test="count(m1:type/ns2:amend) &gt; 0">
						<img
							src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
								<img
							src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				C (change in information)						
			</div>
          </div>
        </div>
        <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;"> Entity in which Interest is Owned: <br/>
                  <div class="fakeBox">
                             <xsl:value-of select="m1:baseInformation/m1:owningEntity"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                    </div> 
                </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Status: <br/>
                	<div class="fakeBox">
                             <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:titleStatus"/>
                         <span>
                        <xsl:text>&#160;</xsl:text>
                       </span>
                       </div>  
                	 <!-- input 	type="text" 	name="title date" 	class="dateField"	readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:titleStatus"/>
						</xsl:attribute>
					</input-->
                </div>
               </div>
               </div>
               <div class="tableStyle" style="margin-left:0; margin-right:0;">
               <div class="tableRow"> 
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Date Title or Status Acquired: 
                	<input 	type="text" 	name="title date" 	class="dateField"	readonly="1">
						<xsl:attribute 			name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:statusAcquired"/> 
						</xsl:attribute>
					</input>
                 </div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow"><div class="tdStyle" style="margin-left:0; margin-right:0;">Ownership Code: </div></div>	
             <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcol1">
    	            <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='C']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
					</xsl:choose>
        	          C-25% but less than 50%
        	   </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                 	<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='D']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  D-50% but less than 75%
                </div>
                <div class="tdStyle1 tdscheduleagridcol1">
                	 <xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='E']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  E-75% or more
               	</div>
              </div>
			  <div style="clear:both;"></div>
              <div class="tableRow">
                <div class="padded tdStyle" style="margin-left:0; margin-right:0;"> 
                	<xsl:choose>
						<xsl:when
							test="count(m1:baseInformation/m1:baseInfo/m1:baseInformation[m1:ownershipCode='F']) &gt; 0 ">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />
						</xsl:when>
						<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
						</xsl:otherwise>
					</xsl:choose>
                  	F-Other (general partner, trustee, or elected manager)
                </div>
                <div class="tdStyle" style="margin-left:0; margin-right:0;"></div>
              </div>
            </div>
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdYesNoStyle" style="margin-left:0; margin-right:0;"><em>Control Person</em>:
						<xsl:choose>                
	               			<xsl:when
								test="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson = 'Y' or m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked"/> YES<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO
						</xsl:when>
						 <xsl:when
								test="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson = 'N' or m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:isControPerson  = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> YES<img src="Images/radio-checked.jpg" alt="radio button checked"/> NO
						</xsl:when>
						<xsl:otherwise><img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>YES <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> NO</xsl:otherwise>
					</xsl:choose>
	               
              	</div>
              </div>
            </div>
            
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">Individual <em>CRD</em> No. (If none: enter 0000000):</div>
              </div>
              <div class="tableRow">
                <div class="tdStyle1 tdscheduleagridcrdcol1" ><em>CRD</em> No.: <br/>                 
                       <input type="text" name="CRD8" readonly="1">
						<xsl:attribute name="value">
							 <xsl:value-of select="m1:baseInformation/m1:baseInfo/m1:baseInformation/m1:crdNumber"/>
						</xsl:attribute>
					</input>
                </div>
              </div>
			   <div style="clear:both;"></div>
            </div>
          
            
            <!-- table class="formTable">
              <div class="tableRow">
                <td><strong>Is the Owner or Executive Officer:</strong></div>
              </div>
              <div class="tableRow">
                <div class="tdStyle" style="margin-left:0; margin-right:0;">
                	<span
						class="label">
						<xsl:choose>
							<xsl:when 	test="m1:baseInformation/m1:baseInfo/m1:deFeNp='de'">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						DE - Domestic Entity 
						<xsl:choose>
							<xsl:when
								test="m1:baseInformation/m1:baseInfo/m1:deFeNp ='fe'">
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose>
						 FE - Entity incorporated or  domiciled in a foreign country
					</span>
                  </div>
              </div>
            </div--> 
            
          </div>
          </xsl:for-each>
        </div>
</xsl:template>

</xsl:stylesheet>