﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
<xsl:template name="judicialDisclosureDrp" >

<div id="drpRegulatory">

  <div class="contentwrapper">
    <div class="content">      
  <xsl:for-each select="m1:formData/m1:drpInfo/ns3:civilJudicialDisclosure/ns3:civilJudicialDrp">
      <div class="form1">
        <div class="formDescription">

<p>
<strong>GENERAL INSTRUCTIONS</strong>
<p>
This <b>Disclosure Reporting Page (DRP MA)</b> is an
    <span
		class="label">
			<xsl:choose>
				<xsl:when
					test="count(ns3:baseHeader/ns3:reponseType/m1:add)&gt; 0">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:otherwise>
			</xsl:choose> 
			<b>INITIAL</b> <b><em> OR </em></b>
			<xsl:choose>
				<xsl:when
					test="count(ns3:baseHeader/ns3:reponseType/m1:amend) &gt; 0">
					<img src="Images/radio-checked.jpg" alt="radio button checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
				</xsl:otherwise>
			</xsl:choose> 
			<b>AMENDED</b>
	</span>
    response to report details for an affirmative response used to report details for affirmative responses to Items 9-H. of Form MA.
 </p>
<br/>
<p>
Check item(s) being responded to:
</p>
<p>
	<xsl:choose>
		<xsl:when
			test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-H1a'])&gt; 0">
			<img
				src="Images/box-checked.jpg" alt="checkbox checked" />
		</xsl:when>
		<xsl:otherwise>
			<img
				src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
		</xsl:otherwise>
	</xsl:choose> <b>9-H(1)(a)</b>  <xsl:choose>
		<xsl:when
			test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-H1b'])&gt; 0">
			<img
				src="Images/box-checked.jpg" alt="checkbox checked" />
		</xsl:when>
		<xsl:otherwise>
			<img
				src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
		</xsl:otherwise>
	</xsl:choose> <b>9-H(1)(b)</b>        <xsl:choose>
		<xsl:when
			test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-H1c'])&gt; 0">
			<img
				src="Images/box-checked.jpg" alt="checkbox checked" />
		</xsl:when>
		<xsl:otherwise>
			<img
				src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
		</xsl:otherwise>
	</xsl:choose>  <b>9-H(1)(c)</b>        <xsl:choose>
		<xsl:when
			test="count(ns3:headerData/ns3:respondingTo[ns3:responseQuestion='9-H2'])&gt; 0">
			<img
				src="Images/box-checked.jpg" alt="checkbox checked" />
		</xsl:when>
		<xsl:otherwise>
			<img
				src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
		</xsl:otherwise>
	</xsl:choose>  <b>9-H(2)</b>  
</p>
<br/>
<p><b><u>How to Report an Event or Proceeding on a Civil Judicial Action DRP: </u></b>   
Use a separate DRP for each event or <em>proceeding</em>.  The same event or <em>proceeding</em> may be 
reported for more than one <em>person</em> or entity using one DRP.  One event may result in more 
than one affirmative answer to Item 9-H.  Separate cases arising out of the same event, 
and unrelated civil judicial actions, must be reported on separate DRPs;  if they are later 
consolidated into a single civil judicial action, the consolidated action can be reported on one DRP.  
</p>

</p>

<br/>
<h1>CIVIL JUDICIAL ACTION DRP PART I </h1>
<p>Check all that apply, except where noted:  </p>


 <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
            
              <div class="tdStyle1" ><b>A.    The <i>person</i>(s) or entity(ies) for
whom this DRP is being filed is (are) the:   </b>    </div>
            </div>
            <div class="tableRow">
              <div class="tdStyle1" >
				  <xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicant)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>              
                Applicant (the <em>municipal advisory firm</em>)</div>
            </div>
            <div class="tableRow">
            
              <div class="tdStyle1" > <xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicantAndAP)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>          
                Applicant and one or more <em>of the applicant's associated person(s)</em></div>
            </div>
            <div class="tableRow">
             
              <div class="tdStyle" ><xsl:choose>
							<xsl:when
								test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:ap)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
                One or more of applicant's <em>associated person(s)</em></div>
            </div>
        </div>

<p>1.     <b><u>Applicant</u></b> </p>
 <div class="tableStyle" style="margin-left:0; margin-right:0;">           
            <div class="tableRow noborder">             
              <div class="tdStyle1 tditem10col1">
		(a) Is this DRP an amendment filed for the applicant that seeks to remove a previously filed DRP concerning the applicant from the record?</div>
              <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="count(ns3:applicantInfo/ns3:drpRemoveReason)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
                Yes<xsl:choose>
							<xsl:when
								test="count(ns3:applicantInfo/ns3:drpRemoveReason)&gt; 0">
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
							
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose>    
                No</div>
            </div>
			<div style="clear:both"></div>
			<div class="tableRow" id="crimRow1b">
              <div class="tdStyle1">              
			  (b) If &quot;Yes,&quot; the reason the DRP should be removed is:</div>
            </div>
            <div class="tableRow" id="crimRow1ba">             
             
              <div class="tdStyle1"><xsl:choose>
							<xsl:when
								test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isRegistered)&gt; 0">
								                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
The applicant is registered or applying for registration and the event or <em>proceeding</em> was resolved in the applicant's favor.</div>
            </div>
            <div class="tableRow" id="crimRow1bb">           
            
              <div class="tdStyle1"><xsl:choose>
							<xsl:when
								test="count(ns3:applicantInfo/ns3:drpRemoveReason/n2:isFiledError)&gt; 0">
								                            <img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
				The DRP was filed in error. </div>
            </div>
            <div class="tableRow">
			<div class="tdStyle1">                            
            Explain the circumstances:
                                       
              <!-- 
                 <textarea name="textarea4" id="textarea4" cols="64" rows="6" readonly="1">
				
				<xsl:value-of
						select="string(ns3:applicantInfo/ns3:header/ns3:drpRemoveReason/n2:isFiledError/n2:explainTheCircumstances)" />
						
				
              </textarea>
              -->
              <div class="fakeBox">
					<xsl:value-of
						select="string(ns3:applicantInfo/ns3:drpRemoveReason/n2:isFiledError/n2:explainTheCircumstances)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>
              </div>
            </div>
          </div>
		  
		  
<p>2.     <b><u>Associated Person(s)</u></b> </p>

 <div class="tableStyle" style="margin-left:0; margin-right:0;">           
            <div class="tableRow">             
              <div class="tdStyle1 tditem10col1">
			            (a) Does this DRP concern one or more <em>associated person</em>s?</div>
              <div class="tdStyle1 tditem10col2"><xsl:choose>
							<xsl:when
								test="count(ns3:apInfo/ns3:associatedPerson)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>    
                Yes<xsl:choose>
							<xsl:when
								test="count(ns3:apInfo/ns3:associatedPerson)&gt; 0">
									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:when>
							<xsl:otherwise>
							
									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:otherwise>
						</xsl:choose>    
                No</div>
            </div>
  			<div style="clear:both"></div>

		<div class="tableRow" id="BBB">             
			<div class="tdStyle1">                                  (i)    Indicate the total number of such <em>associated person</em>(s): 
              <input name="textfield24" type="text" class="tinyField" id="textfield30" >
              <xsl:choose>
                    <xsl:when test="count(ns3:apInfo/ns3:associatedPerson) &gt; 0" >
                        <xsl:attribute name="value">
                              <xsl:value-of select="count(ns3:apInfo/ns3:associatedPerson)" />
                        </xsl:attribute>
                    </xsl:when>
                     <xsl:otherwise>
                           <xsl:attribute name="value">
                               <xsl:value-of select="." />
                            </xsl:attribute>
                        </xsl:otherwise>
                      </xsl:choose>
                </input>
            </div>
        </div>
		
		<div class="tableRow">
			<div class="tdStyle1">              (b)	Identify each such associated firm and/or natural person in the space below:
			</div>
		</div>
		<div class="tableRow" id="crimRow1ba">
			<div class="tdStyle1">               <xsl:choose>
					<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose> <b>Firm</b>
			</div>
		</div>
		<div class="tableRow" id="crimfirm22">
			<div class="tdStyle1">
				<label for="firm name">                            Full name of the <em>associated person</em>:</label><br/>
				<!-- 
				<input 	type="text" 	name="firm name" 	readonly="1">
					<xsl:attribute name="value">
						<xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)" />
					</xsl:attribute>
				</input>
				-->
				<div class="fakeBox">               <xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)" />
                        <span>               <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
			</div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">               The <em>associated person</em> is: </div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1 tdjudicialdrpcol1">               <xsl:choose>
					<xsl:when test="ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:isSECRegistered = 'Y' and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose> registered with the <em>SEC</em>
			</div>
			
			<div class="tdStyle1 tdjudicialdrpcol1" id="crimsecReg22">
<!-- 				<tr class="hide" id="crimsecReg22"> -->
				<em>SEC</em> Registration No.
			  <xsl:choose>
                    <xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
					    <input 	type="text" 	name="crimsecRegno22" 	readonly="1">
						<xsl:attribute name="value">
							<xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:secRegistrationNumber)" />
						</xsl:attribute>
					</input>
				</xsl:when>
                 <xsl:otherwise>
                      <input    type="text"     name="crimsecRegno22"   readonly="1">
                         <xsl:attribute name="value">
                             <xsl:value-of select="." />
                        </xsl:attribute>
                     </input>
                  </xsl:otherwise>
               </xsl:choose>   
			</div>
			<div style="clear:both"></div>
			</div>
			
			<div class="tableRow">
			<div class="tdStyle1 tdjudicialdrpcol1" id="crimsecReg22">               <xsl:choose>
					<xsl:when test="ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:isSECRegistered = 'N' and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>   
				<label for="Associated Person2">not registered with the <em>SEC</em></label>
			</div>
			
			<div class="tdStyle1 tdjudicialdrpcol1" id="crimsecReg22"><em>CRD</em> No., if any
				<xsl:choose>
                    <xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
                        <input  type="text"     name="crd22"   readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:crdNumber)" />
                        </xsl:attribute>
                    </input>
                </xsl:when>
                 <xsl:otherwise>
                      <input    type="text"     name="crd22"   readonly="1">
                         <xsl:attribute name="value">
                             <xsl:value-of select="." />
                        </xsl:attribute>
                     </input>
                  </xsl:otherwise>
               </xsl:choose>   
			</div>
			<div style="clear:both"></div>
		</div>
		
		<div class="tableRow">
			<div class="tdStyle1 tditem10col1">               Is this DRP an amendment that seeks to remove a previously filed DRP concerning this  <em>associated person?</em></div>
			<div class="tdStyle1 tditem10col2">
				<xsl:choose>
					<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
						<img src="Images/radio-checked.jpg" alt="radio button checked" />No
					</xsl:otherwise>
				</xsl:choose>   
			</div>
		</div>
		<div style="clear:both"></div>

		<div class="tableRow">
			<div class="tdStyle1">               If &quot;Yes,&quot; the reason the DRP should be removed is:</div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">               <xsl:choose>
					<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:apNotAssociated)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose> The <em>associated person(s)</em> is no longer associated with the advisor.</div>
		</div>
		<div class="tableRow">
					<div class="tdStyle1">               <xsl:choose>
							<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:eventResolved)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> The event or <em>proceeding</em> was resolved in the <em>associated person</em>'s favor
					</div>
                </div>
                <!--
                <div class="tableRow">
					<div class="tdStyle1">
						<xsl:choose>
							<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:eventOccurTenYearsAgo)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> The event or <em>proceeding</em> occurred more than ten years ago.
					</div>
                </div>
                -->
                <div class="tableRow">
					<div class="tdStyle1">               <xsl:choose>
							<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:isFiledError)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> The DRP was filed in error. Explain the circumstances:</div>
                </div>
                <div class="tableRow" id="crimexplain22">
					<div class="tdStyle1">
						<div class="fakeBox">
                            <xsl:choose>
                                <xsl:when
                                    test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
                                    <xsl:value-of
                                        select="string(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:isFiledError/n2:explainTheCircumstances)" /> 
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
					</div>
				</div>
				<!-- 
				<tr class="hide" id="crimexplain22">
					<div class="tdStyle1">Provide the information for each additional firm below: <br/>
                        <div class="fakeBox">
                            <xsl:choose>
                                <xsl:when
                                    test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:firmInfo)&gt; 0">
                                    <xsl:value-of
                                        select="string(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" /> 
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
					</div>
				</div>
				-->
	</div>
	
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow" id="crimRow1bb">           
			<div class="tdStyle1">               <xsl:choose>
					<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose> <b>Natural person</b>
			</div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">               Full name of the <em>associated person:</em></div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">               Enter all the letters of each name and not initials or other abbreviations. If no middle name, enter NMN on that line.</div>
		</div>

		<div class="tableRow" id="crimnp22">
			<div class="tdStyle1 tdscheduleagridcol1">
				<input type="text" name="firstName" readonly="1">
					<xsl:attribute name="value">
						<xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo/ns2:firstName)" />
					</xsl:attribute>
				</input><br />First Name
			</div>
			<div class="tdStyle1 tdscheduleagridcol1">
				<input type="text" name="middleName" readonly="1">               <xsl:attribute name="value">
						<xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo/ns2:middleName)" />
					</xsl:attribute>
				</input><br />Middle Name
			</div>
			<div class="tdStyle1 tdscheduleagridcol1">
				<input type="text" name="lastName" readonly="1">
					<xsl:attribute name="value">
						<xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo/ns2:lastName)" />
					</xsl:attribute>
				</input><br />Last Name
			</div>
			<div class="tdStyle1 tdscheduleagridcol1">
				<input type="text" 	name="suffix01" readonly="1">
					<xsl:attribute name="value">
						<xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo/ns2:suffix)" />
					</xsl:attribute>
				</input><br />Suffix
			</div>
		</div>
		<div style="clear:both"></div>
	</div>

	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1">The <em>associated person</em> is: </div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1 tdjudicialdrpcol1">               <xsl:choose>
					<xsl:when test="ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:isSECRegistered = 'Y' and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose> registered with the <em>SEC</em>
			</div>
			<div class="tdStyle1 tdjudicialdrpcol1"><em>SEC</em> Registration No.
				<xsl:choose>
                    <xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
                        <input  type="text"     name="crimsecRegno22"   readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:secRegistrationNumber)" />
                        </xsl:attribute>
                    </input>
                </xsl:when>
                 <xsl:otherwise>
                      <input    type="text"     name="crimsecRegno22"   readonly="1">
                         <xsl:attribute name="value">
                             <xsl:value-of select="." />
                        </xsl:attribute>
                     </input>
                  </xsl:otherwise>
               </xsl:choose>   
			</div>
		</div>
			<div style="clear:both"></div>
		<div class="tableRow">
			<div class="tdStyle1 tdjudicialdrpcol1">               <xsl:choose>
					<xsl:when test="ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:isSECRegistered = 'N' and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
                        <img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose>not registered with the <em>SEC</em>
			</div>
			<div class="tdStyle1 tdjudicialdrpcol1"><em>CRD</em> No., if any:
					<xsl:choose>
                    <xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
                        <input  type="text"     name="crd22"   readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:apInfo/ns3:associatedPerson/ns3:registrationInfo/ns3:crdNumber)" />
                        </xsl:attribute>
                    </input>
                </xsl:when>
                 <xsl:otherwise>
                      <input    type="text"     name="crd22"   readonly="1">
                         <xsl:attribute name="value">
                             <xsl:value-of select="." />
                        </xsl:attribute>
                     </input>
                  </xsl:otherwise>
               </xsl:choose>   
			</div>
		</div>
		<div style="clear:both"></div>
	</div>
	<div class="tableStyle" style="margin-left:0; margin-right:0;">
		<div class="tableRow">
			<div class="tdStyle1 tditem10col1">               Is this DRP an amendment that seeks to remove a previously filed DRP concerning this <em>associated person</em>?
			</div>
			<div class="tdStyle1 tditem10col2">               <xsl:choose>
						<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
							<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes
							<img src="Images/radio-checked.jpg" alt="radio button checked" />No
						</xsl:otherwise>
					</xsl:choose>   
			</div>
		</div>
		<div style="clear:both"></div>

		<div class="tableRow">
			<div class="tdStyle1">               If &quot;Yes,&quot; the reason the DRP should be removed is:</div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">               <xsl:choose>
					<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:apNotAssociated)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
					</xsl:otherwise>
				</xsl:choose> The <em>associated person(s)</em> is no longer associated with the advisor.
			</div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">               <xsl:choose>
							<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:eventResolved)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> The event or <em>proceeding</em> was resolved in the <em>associated person</em>'s favor
					</div>
         </div>
                <!-- 
        <div class="tableRow">
			<div class="tdStyle1">
						<xsl:choose>
							<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:eventOccurTenYearsAgo)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> The event or <em>proceeding</em> occurred more than ten years ago.
					</div>
                </div>
                 -->
        <div class="tableRow">
         	<div class="tdStyle1">               <xsl:choose>
							<xsl:when test="count(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:isFiledError)&gt; 0 and count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose> The DRP was filed in error. 
			</div>
		</div>
		<div class="tableRow">
			<div class="tdStyle1">              Explain the circumstances: </div>
		</div>
                		
		<div class="tableRow" id="crimexplain22">
			<div class="tdStyle1">
				<div class="fakeBox">
					<xsl:choose>
						<xsl:when
							test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
							<xsl:value-of
								select="string(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" /> 
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</xsl:when>
						<xsl:otherwise>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</div>
		</div>
									
				<!-- 
                <tr class="hide" id="crimexplain22">
					<div class="tdStyle1"><b>Provide the information for each additional natural person below:</b>
						<div class="fakeBox">
                            <xsl:choose>
                                <xsl:when
                                    test="count(ns3:apInfo/ns3:associatedPerson/ns3:apType/ns3:naturalPersonInfo)&gt; 0">
                                    <xsl:value-of
                                        select="string(ns3:apInfo/ns3:associatedPerson/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" />
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                </xsl:when>
                                <xsl:otherwise>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
					</div>
				</div>
            -->
	</div>
  <!-- 
<p><u><b>B. DRP filed elsewhere for this event:</b>  Is an accurate and up-to-date DRP containing the information regarding the applicant or <em>associated person</em> required by this DRP already on file (a) in the IARD or CRD system (with a Form ADV, BD, or U4), (b) in the <em>SEC’s</em> EDGAR system (with a Form MA or Form MA-I)?</u>

<br/><br/>
         
 			<div class="tdStyle1">               <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling)&gt; 0">
								<img
									src="Images/radio-checked.jpg" alt="radio button checked" />Yes	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes	<img
									src="Images/radio-checked.jpg" alt="radio button checked" />No
							</xsl:otherwise>
						</xsl:choose>   
              </div>
</p>
-->
  <div class="form1">               <xsl:for-each select="ns3:applicantInfo">
           
        <div class="dented hide" id="crimdrpDisclosure22">
          <h3><u>Applicant</u></h3> 
         <br />
         <br />
         <u><b>B. DRP filed elsewhere for this event:</b></u>
         <br />
         <br />
         <div class="tableStyle" style="margin-left:0; margin-right:0;">
            
            <div class="tableRow noborder">
				<div class="tdStyle1 tditem10col1">
					<u>Is an accurate and up-to-date DRP containing the information regarding the applicant or <em>associated person</em> required by this DRP already on file (a) in the IARD or CRD system (with a Form ADV, BD, or U4), (b) in the <em>SEC’s</em> EDGAR system (with a Form MA or Form MA-I)?</u></div>
				<div class="tdStyle1 tditem10col2">
					<xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />Yes    
                                    <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />No
                            </xsl:otherwise>
                        </xsl:choose>   
				</div>
            </div><div style="clear:both"></div>
          </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">              
              <div class="tdStyle1"><b>If the answer is &quot;Yes&quot;, provide the applicable information indicated below that identifies where the DRP may be found. </b></div>
            </div>
            <div class="tableRow">
              
             <div class="tdStyle1 checkbox"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing) &gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
									<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label> 1. Form ADV, BD, or U4 Filing</label></div>
            </div>
            <div class="tableRow">
             
              <div class="tdStyle1 checkbox"><xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling)&gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> 2. Form MA Filing</label></div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label> 3. Form MA-I  Filing</label></div>
            </div>
            <div class="tableRow">
            <!--  
              <div class="tdStyle1"><xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling)&gt; 0 ">
										<img
									src="Images/box-checked.jpg" />
							</xsl:when>
							<xsl:otherwise>
							<img
									src="Images/box-unchecked.jpg" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> 4. Form MA-T Filing</label></div>-->
            </div>
            </div>
          <div class="tableStyle hide" id="advFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1"><h3>1. Form ADV, BD, or U4 Filing:</h3></div>
              </div>
            <div class="tableRow">              
              <div class="tdStyle1"> For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information:</div>
              </div>
            <div class="tableRow">       
              <div class="tdStyle1">Name on Registration:
              <!--  
              <input 	type="text" 	name="regisName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:name)" />
							</xsl:attribute>
						</input>
						-->
						<div class="fakeBox">
						<xsl:value-of
							select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:name)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
				</div>
                                                       
                </div>
                <div class="tdStyle1"></div>
              </div>
            <div class="tableRow">              
              <div class="tdStyle1 tdscheduleagridcol1"><em>CRD</em> No. 
                <input 	type="text" 	name="iard2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:crdNumber)" />
							</xsl:attribute>
						</input>
                </div>
              <div class="tdStyle1 tdscheduleagridcol1">Disclosure Occurrence No. 
              <!-- 
              <input 	type="text" 	name="occurNo2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:disclosureNumber)" />
							</xsl:attribute>
						</input>
			  -->
			  <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:disclosureNumber)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
                </div>
              
              </div>
			  <div style="clear:both"></div>
            </div>
          <div class="tableStyle hide" id="maFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1"><h3>2. Form MA Filing:</h3></div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">For a DRP filed on EDGAR with a Form MA, provide the following information:</div>
            </div>
            <div class="tableRow">              
              <div class="tdStyle1">Name on Registration:
              <!--  
                <input 	type="text" 	name="regName001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:name)" />
							</xsl:attribute>
						</input>
			  -->
			  <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:name)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
              </div>
            </div>
            <div class="tableRow">              
              <div class="tdStyle1">MA Registration Number: 
                 <input 	type="text" 	name="matReg001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                </div>
            </div>
			<div class="tableRow">
              <div class="tdStyle1">Date of Filing that contains the DRP (MM/DD/YYYY): 
                  <input 	type="text" 	name="dateoffiling2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
            </div>
			<div class="tableRow">
              <div class="tdStyle1">Accession number of the filing: 
                 <input 	type="text" 	name="accessNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
            </div>
          <div class="tableStyle hide" id="maiFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1"><h3>3. Form MA-I Filing:</h3></div>
            </div>
            <div class="tableRow">
             
              <div class="tdStyle1">For a DRP filed on EDGAR with a Form MA-I, provide the following information:</div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">Name on Registration:
              <!--  
               <input 	type="text" 	name="regName" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox">
				<xsl:value-of
				    	select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:name)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
		      	</div>
                </div>
            </div>
            <div class="tableRow">
              <div class="tdStyle1">MA-I Registration Number: 
                 <input 	type="text" 	name="maiReg" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                 </div>
				 </div>
				 <div class="tableRow">
              <div class="tdStyle1">Date of Filing that contains the DRP (MM/DD/YYYY): 
                <input 	type="text" 	name="dateoffiling3" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
			<div class="tableRow">
              <div class="tdStyle1">Accession number of the filing: 
                 <input 	type="text" 	name="accessNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:accessionNumber)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
            </div>
          <!--  <table class="formTable hide" id="matFilingcrim">
            <div class="tableRow">
              <div class="tdStyle1"><h3>4. Form MA-T Filing:</h3></div>
            </div>
            
            <div class="tableRow">
              <div class="tdStyle1">For a disclosure filed on the <em>SEC</em> website with a Form MA-T, provide the following information identifying the disclosure on the <em>SEC</em> website at:  <a href="https://tts.sec.gov/MATR/index.html"> https://tts.sec.gov/MATR/index.html:</a></div>
			</div>
            
            <div class="tableRow">
              <div class="tdStyle1">Name on Registration: -->
              <!-- 
                <input 	type="text" 	name="regName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:name)" />
							</xsl:attribute>
						</input>
			  -->
			  <!-- <div class="fakeBox">
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:name)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                </div>
                </div>
            </div>
            <div class="tableRow">
              <div class="tdStyle1">MA-T Registration Number: 
               <input 	type="text" 	name="matReg2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                </div>
			</div>
			<div class="tableRow">
              <div class="tdStyle1">Date of Filing that contains the DRP (MM/DD/YYYY): 
                <input 	type="text" 	name="dateoffiling4" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:date)" />
							</xsl:attribute>
						</input>
                </div>
            </div>
            </div>-->
 </div></xsl:for-each><br></br>

       <xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
   
        <div class="dented hide" >
          <h3><u>Associated Person(s)</u></h3> 
         <br />
         <br />
         <u><b>B. DRP filed elsewhere for this event:</b></u>
         <br />
         <br />
            <div class="tableStyle" style="margin-left:0; margin-right:0;">
            
            <div class="tableRow"> <div class="tdStyle1 tditem10col1">  <u>Is an accurate and up-to-date DRP containing the information regarding the applicant or <em>associated person</em> required by this DRP already on file (a) in the IARD or CRD system (with a Form ADV, BD, or U4), (b) in the <em>SEC’s</em> EDGAR system (with a Form MA or Form MA-I)?</u></div>
            <div class="tdStyle1 tditem10col2">
            <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling)&gt; 0 or count(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling)&gt; 0">
                                <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />Yes    
                                    <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  
                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />No
                            </xsl:otherwise>
                        </xsl:choose>   
                 </div>
              </div>
			  <div style="clear:both"></div>
     </div>
          <div class="tableStyle" style="margin-left:0; margin-right:0;">
            <div class="tableRow">              
              <div class="tdStyle crap" style="margin-left:0; margin-right:0; width:100%;"><b>Provide the applicable information indicated below that identifies where the DRP may be found.</b> </div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing) &gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
									<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label> 1. Form ADV, BD, or U4 Filing</label></div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1"><xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling)&gt; 0 ">
										
									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> 2. Form MA Filing</label></div>
            </div>
            <div class="tableRow">
             
              <div class="tdStyle1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>   
                <label> 3. Form MA-I  Filing</label></div>
            </div>
            <!--  
            <div class="tableRow">
              <div class="tdStyle1"><xsl:choose>
						<xsl:when
								test=" count(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling)&gt; 0 ">
										<img
									src="Images/box-checked.jpg" />
							</xsl:when>
							<xsl:otherwise>
							<img
									src="Images/box-unchecked.jpg" />
									
							</xsl:otherwise>
						</xsl:choose>   
                <label> 4. Form MA-T Filing</label></div>
            </div>-->
            </div>
          <div class="tableStyle hide" id="advFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1"><h3>1. Form ADV, BD, or U4 Filing:</h3></div>
              </div>
            <div class="tableRow">
              
              <div class="tdStyle1"> For a DRP filed on the <em>IARD</em> or <em>CRD</em> system with one of these forms, provide the following information:</div>
              </div>
            <div class="tableRow">
             
              <div class="tdStyle1">Name on Registration: 
              <!-- 
              <input 	type="text" 	name="regisName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:name)" />
							</xsl:attribute>
						</input>
				 -->
				<div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:name)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>
                </div>
              </div>
            <div class="tableRow">
              
              <div class="tdStyle1 tdscheduleagridcol1"><em>CRD</em> No. 
                <input 	type="text" 	name="iard2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:crdNumber)" />
							</xsl:attribute>
						</input>
                </div>
              <div class="tdStyle1 tdjudicialdrpcol1">Disclosure Occurrence No. 
              <!-- 
                <input 	type="text" 	name="occurNo2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:disclosureNumber)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:advBDU4Filing/n2:disclosureNumber)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
                </div>
              
              </div>
			  <div style="clear:both"></div>
            </div>
          <div class="tableStyle hide" id="maFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1"><h3>2. Form MA Filing:</h3></div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">For a DRP filed on EDGAR with a Form MA, provide the following information:</div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">Name on Registration: 
              <!-- 
                <input 	type="text" 	name="regName001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:name)" />
							</xsl:attribute>
					</input>
			   -->
			   <div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:name)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
                 </div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">MA Registration Number: 
                 <input 	type="text" 	name="matReg001" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                </div>
				</div>
				<div class="tableRow">
              <div class="tdStyle1">Date of Filing that contains the DRP (MM/DD/YYYY): 
                  <input 	type="text" 	name="dateoffiling2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                
                </div>
				</div>
				<div class="tableRow">
              <div class="tdStyle1">Accession number of the filing: 
                 <input 	type="text" 	name="accessNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
						</input>
                </div>
            </div>
            </div>
          <div class="tableStyle hide" id="maiFilingcrim" style="margin-left:0; margin-right:0;">
            <div class="tableRow">
              <div class="tdStyle1"><h3>3. Form MA-I Filing:</h3></div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">For a DRP filed on EDGAR with a Form MA-I, provide the following information:</div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">Name on Registration:
              <!--  
               <input 	type="text" 	name="regName" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				<div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:name)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
                </div>
            </div>
            <div class="tableRow">
              
              <div class="tdStyle1">MA-I Registration Number: 
                 <input 	type="text" 	name="maiReg" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                </div>
              <div class="tdStyle1">Date of Filing that contains the DRP (MM/DD/YYYY): 
                <input 	type="text" 	name="dateoffiling3" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maiFiling/n2:drpDate)" />
							</xsl:attribute>
						</input>
                </div>
              
            </div>
				<div class="tableRow">
              <div class="tdStyle1">Accession number of the filing: 
                 <input 	type="text" 	name="accessNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:maFiling/n2:accessionNumber)" />
							</xsl:attribute>
						</input>
                </div>
            </div>

            </div>
         <!-- <table class="formTable hide" >
            <div class="tableRow">
              <div class="tdStyle1"><h3>4. Form MA-T Filing:</h3></div>
            </div>
            <div class="tableRow">
			
              <div class="tdStyle1">For a disclosure filed on the <em>SEC</em> website with a Form MA-T, provide the following information identifying the disclosure on the <em>SEC</em> website at:  <a href="https://tts.sec.gov/MATR/index.html">https://tts.sec.gov/MATR/index.html:</a></div>

			</div>
            <div class="tableRow"> 
              <div class="tdStyle1">-->
              <!-- 
                <input 	type="text" 	name="regName2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:name)" />
							</xsl:attribute>
						</input>
				-->
				 <!-- <div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:name)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>
                <br />
                Name on Registration </div>
            </div>
            <div class="tableRow">
            
              <div class="tdStyle1">
               <input 	type="text" 	name="matReg2" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:regNumber)" />
							</xsl:attribute>
						</input>
                <br />
                MA-T Registration Number </div>
              <div class="tdStyle1">
                <input 	type="text" 	name="dateoffiling4" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:filedDisclosre/ns3:matFiling/n2:date)" />
							</xsl:attribute>
						</input>
                <br />
                Date of Filing that contains the disclosure</div>
              
            </div>
            </div>--> 
 </div></xsl:for-each>
 <!--         <p class="minutia"><b>If the answer is "Yes," no other information on this DRP (other than set forth above) must be provided.</b>  </p>
        <p><b>If the answer is “No,” complete Part 2 below.</b></p>
  -->
 </div>

<style>
	p.mabox
	{
		border-style:solid;
		border-width:1px;
		text-align:center;
		padding:5px 10px;
	}
</style>

<div class="tableStyle" style="margin-left:0; margin-right:0;">
	<div class="tableRow">
		<div class="tdStyle1">
			<p class="mabox">
				<b>NOTE: The completion of all or any part of this form does not relieve the <em>municipal advisor</em> or </b>
				<br/>
				<b><em>associated person</em> of its obligation to update its <em>IARD</em> or <em>CRD</em> records.</b>
			</p>
		</div>
	</div>
</div>

<div >

  <h1  >CIVIL JUDICIAL ACTION DRP - PART 2 </h1>

</div>
<!-- <xsl:for-each select="ns3:applicantInfo/ns3:drpInfo"> -->
<xsl:for-each select="ns3:applicantInfo">
<p><b>1.     Court Action was initiated by:   <br/><br/>A. Select the Appropriate Item(s).  (Check all that apply.) </b></p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='SEC'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   <em>SEC</em>
		</div>
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='State'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   State
		</div>
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Foreign Financial Regulatory Authority'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>		
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   <em>Foreign Financial Regulatory Authority</em>
		</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='CFTC'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   <em>CFTC</em>
		</div>
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='SRO'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   <em>SRO</em>
		</div>
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Municipal Advisory Firm'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>    <em>Municipal Advisory Firm</em>
		</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Other Federal Authority'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   Other Federal Authority
		</div>
		<div class="tdStyle1 tdjudicialdrpcol1">
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Commodities Exchange'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>   Commodities Exchange 
		</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> 
			<xsl:choose>
				<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Private Plantiff'])&gt; 0">
					<img src="Images/box-checked.jpg" alt="checkbox checked" />
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				</xsl:otherwise>
			</xsl:choose>  Private Plaintiff 
		</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1">
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Other'])&gt; 0">

			<img src="Images/box-checked.jpg" alt="checkbox checked" />
			Other:
			<!-- <input type="text" name="text49" readonly="1"> <xsl:attribute name="value"> 
				<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy/n2:other)" 
				/> </xsl:attribute> </input> -->
			<div class="fakeBox">
				<xsl:value-of
					select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy/n2:other)" />
				<span>
					<xsl:text>&#160;</xsl:text>
				</span>
			</div>
			</xsl:when>
			<xsl:otherwise>

				<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
				Other:
				<input type="text" name="text49" readonly="1">
				</input>
			</xsl:otherwise>
		</xsl:choose>
		</div>
		<div class="tdStyle1">
		</div>

    </div>
</div>

<p>
<b>B.	Plaintiff(s):  Enter the full name(s) of the plaintiff(s), unless only <em>SEC</em> and/or <em>CFTC</em> is/are checked above. </b> For a <em>foreign financial regulatory authority,</em> please provide the full name in English. 
</p>

<p>
<!-- 
<textarea name="textarea4"  cols="64" rows="6" readonly="1">
				  
				<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation/n2:plantiffName)" />
				
              </textarea>
    -->
<div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation/n2:plantiffName)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
 </p>

<div class="tableRow">
	<div class="tdStyle1 tditem10col1">Were all plaintiffs fully identified in the space provided?</div>  
	<div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when
					test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation[n2:isMissingPlantiffs='Y'])&gt; 0">

						<img
						src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img
						src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
				</xsl:when>
				<xsl:when
					test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation[n2:isMissingPlantiffs='N'])&gt; 0">

						<img
						src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
						src="Images/radio-checked.jpg" alt="radio button checked" /> No
				</xsl:when>
				<xsl:otherwise>
			
					<img
						src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
						src="Images/radio-unchecked.jpg" alt="radio button unchecked" />  No
				</xsl:otherwise>
		</xsl:choose>
	</div>
</div>
<div style="clear:both"></div>
<br />
<p><b>2.  Defendant(s): </b>
<br />						
<p>
<b>A.	Enter the full name(s) of the defendant(s). </b> For <em>foreign defendant(s),</em> please provide the full name in English. 
</p>
<p>						  <!-- >
						            <textarea name="textarea4"  cols="64" rows="6" readonly="1">
				  
							<xsl:value-of
									select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:defendantName)" />
							
			              </textarea>
			              -->
			              <div class="fakeBox">
			                    <xsl:value-of
			                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:defendantName)" />
			                    <span>
			                        <xsl:text>&#160;</xsl:text>
			                    </span>
			                </div>
                     						
</p>
<p><b>            B.	Are you a named defendant?   </b>

		<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation[n2:isADefendant='Y'])&gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:when>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation[n2:isADefendant='N'])&gt; 0">

									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
									src="Images/radio-checked.jpg" alt="radio button checked" /> No
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />  No
							</xsl:otherwise>
		</xsl:choose> 
</p><br />
If “No,” describe how this action involves you:
						<br/><br/>
						<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation[n2:isADefendant='N'])&gt; 0">
								<!-- 
					 <textarea name="textarea4"  cols="64" rows="6" readonly="1">
				  
				<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:involementInformation)" />
				
              </textarea> 
              -->
                 <div class="fakeBox">
                                <xsl:value-of
                                   select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:involementInformation)" />
                                <span>
                                    <xsl:text>&#160;</xsl:text>
                                </span>
                            </div>
              </xsl:when>
              <xsl:otherwise> 
             
               <textarea name="textarea5"  cols="64" rows="6" readonly="1"></textarea>
               
              </xsl:otherwise>
              </xsl:choose>
						
					</p>	

<p><b>3.   Sanction(s) or Relief Sought  </b> (check appropriate items):</p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">
<div class="tableRow">
	<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='BarPermanent'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Bar (Permanent)</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1">
		
		<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Exemption'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exemption </div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Rescission'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Rescission</div>
		
						</div>
	<div style="clear:both"></div>

	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='BarTemporary'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Bar (Temporary / Time Limited) </div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Expulsion'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Expulsion</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Restitution'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Restitution</div>
						
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Cease and Desist'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Cease and Desist </div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Injunction'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Injunction</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Restraining Order'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Restraining <em>Order</em></div>
		
	</div>
		<div style="clear:both"></div>

		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Censure'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Censure</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Money Damage(s) (Private/Civil Complaint)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Money Damage(s) (Private/Civil Complaint)</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1">
						
						<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Requalification'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Requalification 
 </div>
		
	
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='CivilAdminPenaltyFine'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Civil and Administrative Penalty(ies)/Fine(s)</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Prohibition'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Prohibition</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Revocation'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Revocation</div>
		
		
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Denial'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Denial</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Reprimand'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Reprimand</div>
							<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Suspension'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Suspension</div>
						
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">
		
		<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Disgorgement'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Disgorgement</div>
					<div class="tdStyle1 tdjudicialdrpcol1"></div>
					<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Undertaking'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Undertaking</div>
	</div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1" style="float:left; width: 90%">
	<xsl:choose>
		<xsl:when
			test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Other'])&gt; 0">

			<img src="Images/box-checked.jpg" alt="checkbox checked" />
			<b>Other Sanction(s) or Relief Sought:</b>
			<br />
			<br />
			<!-- <textarea name="textarea" cols="64" rows="6" readonly="1"> <xsl:value-of 
				select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought/ns3:otherSanctions)" 
				/> </textarea> -->
			<div class="fakeBox">
				<xsl:value-of
					select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought/n2:other)" />
				<span>
					<xsl:text>&#160;</xsl:text>
				</span>
			</div>
		</xsl:when>
		<xsl:otherwise>

			<img src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
			<b>Other Sanction(s) or Relief Sought:</b>
			<br />
			<br />

			<textarea name="textarea" cols="64" rows="6" readonly="1">

			</textarea>
		</xsl:otherwise>
	</xsl:choose>

</div>
	<div class="tdStyle1 tdscheduleagridcol1"></div>

                                        </div>
<div style="clear:both"></div>
                                    </div>

<p><b>4.    A.	Filing Date of Court Action</b> (MM/DD/YYYY):       
		<input 	type="text" 	readonly="1">
			<xsl:attribute name="value">
				<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:date)" />
			</xsl:attribute>
		</input>
		<br/>            
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:exact)&gt; 0">
				<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
			</xsl:otherwise>
		</xsl:choose>Exact        
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:explanationInfo)&gt; 0">
				<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
			</xsl:otherwise>
		</xsl:choose>Explanation
</p>

<p>        If not exact, provide explanation:  </p>

<p>
<!-- 
           <textarea name="textarea" cols="64" rows="6" readonly="1">         
					
							
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:filingDate/n2:explanationInfo/n2:provideExplanation)" />
							</textarea>
	-->
		<div class="fakeBox">
			<xsl:value-of
				select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:explanationInfo/n2:provideExplanation)" />
			<span>
				<xsl:text>&#160;</xsl:text>
			</span>
	   </div>
</p>

<p><b>    B.	Date Notice/Process was served </b> (MM/DD/YYYY):
		<input 	type="text" 	readonly="1">
			<xsl:attribute name="value">
				<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:date)" />
			</xsl:attribute>
		</input>
		<br/>            
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:exact)&gt; 0">
				<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
			</xsl:otherwise>
		</xsl:choose>Exact        
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:explanationInfo)&gt; 0">
				<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
			</xsl:otherwise>
		</xsl:choose>Explanation
</p>

<p>        If not exact, provide explanation:  </p>

<p>
<!-- 
           <textarea name="textarea" cols="64" rows="6" readonly="1">         
					
							
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:explanationInfo/n2:provideExplanation)" />
							</textarea>
	-->
	<div class="fakeBox">
            <xsl:value-of
                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:explanationInfo/n2:provideExplanation)" />
            <span>
                <xsl:text>&#160;</xsl:text>
            </span>
       </div>
</p>

<p><b>5.     Formal
Action was brought in </b><em>(If brought in a foreign jurisdiction, provide all the information below in English):</em>   </p>
        <b>Check the applicable box:</b>
        <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:fedCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Federal Court
						 <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:milCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Military Court
						 <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:stateCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> State Court  
						 <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:foreignCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Foreign Court  
						 <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:intnlCourt)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> International Court <br/><br/>
						
					          <xsl:choose>
							<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)&gt; 0">
								<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Other :
						<!-- 
						<input  	type="text" 	name="text49" 	readonly="1"> 	
						<xsl:attribute 		name="value"> 
						<xsl:value-of 		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)" />
                </xsl:attribute>
                    </input>
                    -->
                    <div class="fakeBox">
              
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
			<br/><br/>
			<b>          A.	Name of the Court: </b>
			<!-- 
			<input  	type="text" 		readonly="1"> 	<xsl:attribute 		name="value"> 
				<xsl:value-of 		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
				</xsl:attribute>
			</input>
			-->
			<div class="fakeBox">
			              
			                <xsl:value-of
			                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
			                <span>
			                    <xsl:text>&#160;</xsl:text>
			                </span>
			            </div>
			<br/><br/>
		  <!-- <b>          B.	Location of the Court</b><br/><br/>
		<div class="tableStyle" style="margin-left:0; margin-right:0;">
			<div class="tableRow">
				<div class="tdStyle1 tdjudicialdrpcol1">Street Address:</div>
				<div class="tdStyle1 tdjudicialdrpcol1">
					<input 	type="text" 	name="firm name" 	readonly="1"	size="60">
						<xsl:attribute name="value">
							<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street1)" />
						</xsl:attribute>
					</input>
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 tdjudicialdrpcol1">City or County:</div>
                <div class="tdStyle1 tdjudicialdrpcol1">
					<input 	type="text" 	name="firm name" 	readonly="1"	size="45">
						<xsl:attribute name="value">
							<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:city)" />
						</xsl:attribute>
					</input>
				</div>  
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 tdjudicialdrpcol1">State/Country:</div>-->
				<b>       B.	Location of the Court:  </b><br/><br/>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">

						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">Street Address:</div>
							<div class="tdStyle1 tdjudicialdrpcol1" style="width: 400px">
								<input 	type="text" 	name="RegulatororStreetAddress" 	readonly="1" size="60">
								<xsl:attribute name="value">
									<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street1)" />
								</xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">City or County:</div>
							<div class="tdStyle1 tdjudicialdrpcol1">
								<input 	type="text" 	name="RegulatororCityorCounty" 	readonly="1"   size="45">
								<xsl:attribute name="value">
								<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:city)" />
								</xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">State/Country:</div>
                <div class="tdStyle1 tdjudicialdrpcol1">
                        <!--   
                        <input 	type="text" 	name="firm name" 	readonly="1"   size="60">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
							</xsl:attribute>
						</input>  
						-->
					<div class="fakeBox" style="margin-left: 0px;"> 
                        <span >
	                    <xsl:call-template name="stateDescription">
	                        <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
	                     </xsl:call-template>
			                 </span>
			                 <span>
			                 <xsl:text>&#160;</xsl:text>
			                 </span>
			        </div>
						
				</div>
			</div>
			<div style="clear:both"></div>
			<div class="tableRow">
				<div class="tdStyle1 tdjudicialdrpcol1">Zip Code:</div>
                <div class="tdStyle1 tdjudicialdrpcol1"> <input 	type="text" 	name="firm name" 	readonly="1"   size="30">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:zipCode)" />
							</xsl:attribute>
						</input>
				</div>
			</div>
			<div style="clear:both"></div>
        </div>
        <p>
               <p>
               <b> C. Docket/Case Number:</b></p>
               <div class="tableStyle" style="margin-left:0; margin-right:0;">
                 <div class="tableRow">
		            <div class="tdStyle1">
		            <!-- 
		            <input 	type="text" 	name="firm name" readonly="1">
									<xsl:attribute
											name="value">
									<xsl:value-of
										select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
									</xsl:attribute>
								</input> 
								-->
								<div class="fakeBox">
		                          
		                            <xsl:value-of
		                                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
		                            <span>
		                                <xsl:text>&#160;</xsl:text>
		                            </span>
		                        </div>
						</div>		
		        </div>
		  </div>
		<br />
		<br />
		</p>
		<p><b>6.     A. 
		Principal Product Type  (check appropriate item): </b></p>


<div class="tableStyle" style="margin-left:0; margin-right:0;">
<div class="tableRow">
	<div class="tdStyle1">         
	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='No Product'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>No Product</div>
</div>
<div class="tableRow">
	<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='AnnuityCharitable'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Annuity – Charitable</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Direct Investment(s) - DPP &amp; LP Interest(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Direct Investment – DPP &amp; LP Interest</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='OilAndGas'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Oil &amp; Gas</div></div>
	<div style="clear:both"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Annuity(ies) - Fixed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Annuity – Fixed</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='EquipmentLeasing'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Equipment Leasing</div>
						<div class="tdStyle1 tdjudicialdrpcol1">
						
						<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Options'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Options 
 </div>
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Annuity(ies) - Variable'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Annuity – Variable</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Equity Listed (Common &amp; Preferred Stock)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Equity Listed (Common &amp; Preferred Stock)</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Penny Sock(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Penny Stock</div>
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='BankingProduct'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Banking Product (other than CD) </div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Equity - OTC'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Equity OTC</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='PrimeBankInstrument'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Prime Bank Instrument</div>
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='CD(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>CD</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Futures - Commodity'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Futures – Commodity</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Promissory Note'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Promissory Note</div>
	</div>
	
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Commodity Option(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Commodity Option</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Futures - Financial'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Futures – Financial</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Real Estate Security'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Real Estate Security</div>
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Asset Backed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Debt – Asset Backed</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Index Option(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Index Option</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Security Futures'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Security Futures</div>
	</div>
	
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Corporate'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Debt – Corporate</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Insurance'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Insurance</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Security-based Swap'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Security-based Swap</div>
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Government'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Debt – Government</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Investment Contract(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Investment Contract</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Swap'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Swap</div>
	</div>
	<div style="clear:both"></div>
	
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Municipal'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Debt – Municipal</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Money Market Fund(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Money Market Fund</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Unit Investment Trust(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Unit Investment Trust</div>
	</div>
	
	<div style="clear:both"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Derivative(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Derivative</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Mutual Fund(s)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Mutual Fund</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Viatical Settlement'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Viatical Settlement</div>
	</div>
	<div style="clear:both"></div>
	
	
	
	<div class="tableRow">
		<div class="tdStyle1">          <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Other'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" /> <b>Other Principal Product Type:</b><br />
						          <!-- 
						            <textarea name="textarea" cols="64" rows="6" readonly="1">         
					
							
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes/n2:productOther)" />
							</textarea>
							-->
							<div class="fakeBox">
						            <xsl:value-of
						                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes/n2:productOther)" />
						            <span>
						                <xsl:text>&#160;</xsl:text>
						            </span>
						       </div>
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> <b>Other Principal Product Type:</b>  <br/>
						
						            <textarea name="textarea" cols="64" rows="6" readonly="1">                 
					
							</textarea>
							</xsl:otherwise>
						</xsl:choose>

</div><div class="tdStyle1"></div>

	</div>
	<div style="clear:both"></div>
</div>
                                                         
<br/>


   <b>       B.  Other Product Types?    </b>
					<xsl:choose>
						<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes) &gt; 0">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						<!-- 
						<xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes='N'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
						</xsl:when>
						-->
						<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
						</xsl:otherwise>
					</xsl:choose>
 
<p>      
         If &quot;Yes,&quot; describe each additional product
  type :      </p>



<p>
<!-- 
               <textarea name="textarea" cols="64" rows="6" readonly="1">         
					
							
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes)" />
							</textarea>
	-->
	<div class="fakeBox">
		<xsl:value-of
			select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes)" />
		<span>
			<xsl:text>&#160;</xsl:text>
		</span>
	</div>
</p>

<p><b>7.  Allegations: </b>  :   Describe the allegations related to this civil action.  (The response must fit within
the space provided.)</p>



<p>
<!-- 
            <textarea name="textarea40" id="textarea40" cols="64" rows="6" readonly="1">
<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:allegationsDescription)" />  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:allegationsDescription)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>

<p><b>8.  Current Status:</b>   
		<xsl:choose>  
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:status/n1:pending)&gt; 0">
				<img src="Images/radio-checked.jpg" alt="radio button checked" />
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />	
			</xsl:otherwise>
		</xsl:choose> Pending
		<xsl:choose>  
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:status/n1:onAppeal)&gt; 0">
				<img src="Images/radio-checked.jpg" alt="radio button checked" />
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			</xsl:otherwise>
		</xsl:choose> On Appeal
		<xsl:choose>  
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:status/n1:final)&gt; 0">
				<img src="Images/radio-checked.jpg" alt="radio button checked" />
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
			</xsl:otherwise>
		</xsl:choose> Final
</p>
<br />

<p><b>9.  Pending:  If you checked Item 8 Pending, provide the following information. </b> </p>
<p><b>       A. Date Served: </b> The date that notice or other process was served (MM/DD/YYYY): 
		<input 	type="text" 	readonly="1">
			<xsl:attribute name="value">
				<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:date)" />
			</xsl:attribute>
		</input>
		<br/>            
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:exact)&gt; 0">
				<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
			</xsl:otherwise>
		</xsl:choose>Exact        
		<xsl:choose>
			<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo)&gt; 0">
				<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
			</xsl:otherwise>
		</xsl:choose>Explanation 
</p>

<p>          If not exact, provide explanation:  </p>
<p>
<!-- 
            <textarea name="textarea26" id="textarea26" cols="64" rows="6" readonly="1">
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/n2:servedInformation/n2:explanationInfo/n2:provideExplanation)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo/n2:provideExplanation)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>

<b>       B.	Limitation or Restrictions:  </b> Are there any limitations or restrictions currently in effect?	
<xsl:choose>
	<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:limitationsRestrictions) &gt; 0">
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
	</xsl:when>
	<!-- 
	<xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/n2:limitationsRestrictions='N'">
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
	</xsl:when>
	-->
	<xsl:otherwise>
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
	</xsl:otherwise>
</xsl:choose>

<p>          If the answer is “Yes,” provide details:  </p>
<p>
<!-- 
            <textarea name="textarea27" cols="64" rows="6" readonly="1">
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/n2:limitationsRestrictions/n2:details)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:limitationsRestrictions)" /> 
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>
<br />

<p><b>10.	On Appeal – Judicial Review: </b> If you appealed, provide the following information.   
<em>(If brought in a foreign jurisdiction, provide all the information below in English):</em>  

<br/><br/>
<b>       A. Action Appealed to: </b> <em>(Provide the name of the federal, state, foreign, or international court to whom you appealed:)</em> 
<br/><br/>
<!-- 
           <input 	type="text" 	name="NameofRegulatororCourt" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:appealBroughtInInformation/n2:name)" />
							</xsl:attribute>
						</input>
	               -->
					<div class="fakeBox">
						<xsl:value-of
							select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:name)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
						<br/><br/>
						<b>       B.	Location of the Court:  </b><br/><br/>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">

						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">Street Address:</div>
							<div class="tdStyle1 tdjudicialdrpcol1" style="width: 400px">
								<input 	type="text" 	name="RegulatororStreetAddress" 	readonly="1" size="60">
								<xsl:attribute name="value">
									<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street1)" />
								</xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">City or County:</div>
							<div class="tdStyle1 tdjudicialdrpcol1">
								<input 	type="text" 	name="RegulatororCityorCounty" 	readonly="1"   size="45">
								<xsl:attribute name="value">
								<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:city)" />
								</xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">State/Country:</div>
							<!--   
							<input 	type="text" 	name="RegulatororStateOrCountry" 	readonly="1"   size="60">
								<xsl:attribute
										name="value">
								<xsl:value-of
									select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:stateOrCountry)" />
								</xsl:attribute>
							</input>
							-->
							<div class="tdStyle1 tdjudicialdrpcol1"><div class="fakeBox" style="margin-left: 0px;"> 
								<span >
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:stateOrCountry)" />
								 </xsl:call-template>
								</span>
								 <span>
								 <xsl:text>&#160;</xsl:text>
								 </span></div>
							</div>  
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">Zip Code:</div>
							<div class="tdStyle1 tdjudicialdrpcol1"><input 	type="text" 	name="RegulatororZipCode" 	readonly="1"  size="30">
								<xsl:attribute name="value">
								<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:zipCode)" />
								</xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
					</div>
 </p>


<p><b>
       C.	 Docket/Case Name:  </b> 
   <!--  
    <input 	type="text" 	name="RegulatororDocketCaseName" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:docketName)" />
							</xsl:attribute>
						</input>
						-->
						<div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:docketName)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
						<br/>
						
	<b>       D.	 Docket/Case Number:</b> 
	<!-- 
	      <input 	type="text" 	name="RegulatorordocketOrCaseNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:docketOrCaseNo)" />
							</xsl:attribute>
						</input>
			-->
			<div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:docketOrCaseNo)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
						<br/>
	<b>       E.	Date Appeal filed </b>(MM/DD/YYYY):  <input 	type="text" 	name="RegulatorordocketOrCaseNo" 	readonly="1">
							<xsl:attribute
									name="value">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:dateInformation/n2:date)" />
							</xsl:attribute>
						</input>
						
						<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:dateInformation/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:dateInformation/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation 
						
						<p>         If not exact, provide explanation:   </p>
<p>
<!-- >
           <textarea name="RegulatorprovideExplanation" cols="64" rows="6" readonly="1">
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:dateInformation/n2:explanationInfo/n2:provideExplanation)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:dateInformation/n2:explanationInfo/n2:provideExplanation)" /> 
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>

<b>       F.	Appeal Details (including status): </b><br/><br/>
<!-- 
           <textarea name="RegulatorAppealDetails" cols="64" rows="6" readonly="1">
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:details)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
                        <xsl:value-of
                          select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:details)" />    
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
  <br/>

  <b>        G.	Limitation or Restrictions:  </b> Are there any limitations or restrictions currently in effect while on appeal?  
<xsl:choose>
	<xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:limitationsRestrictions='Y'">
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
	</xsl:when>
	<xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:limitationsRestrictions='N'">
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
	</xsl:when>
	<xsl:otherwise>
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
	</xsl:otherwise>
</xsl:choose>
<br/>
						         If the answer is “Yes,” provide details:<br/>
						<!-- 
					         	<textarea name="RegulatorlimitationsRestrictionsDetails" cols="64" rows="6" readonly="1">
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:limitationsRestrictions/n2:details)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:limitationsRestrictions/n2:details)" />   
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>

</p>

<p>
<b>If you checked Item 8 Final or On Appeal, complete Items 11 through 14. For Pending Actions, skip to Item 14.</b>
</p><br />

<p><b>11.  A.    Resolution: </b>  How was the action resolved?  <em>Check all the applicable boxes that reflect the most recent</em> 
resolution of the action by a court, whether or not any part of the resolution is on appeal. If any part of
the resolution is on appeal, identify in Item 11-B which part is currently on appeal.</p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">

	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1">       	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Consent'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Consent</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Judgement Rendered'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Judgment Rendered</div>
		
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Stipulation and Consent'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Stipulation and Consent</div>
	</div>
	<div style="clear:both"></div>
		<div class="tableRow">
		
		<div class="tdStyle1 tdjudicialdrpcol1">       	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Decision</div>
						
							<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Opinion'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Opinion</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Withdrawn'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Withdrawn</div>
	</div>
		<div style="clear:both"></div>

		<div class="tableRow">
		
		
  <div class="tdStyle1 tdjudicialdrpcol1">       	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision &amp; Order of Offer of Settlement'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Decision &amp; <em>Order</em> of Offer of Settlement</div>		<div class="tdStyle1 tdjudicialdrpcol1">
		<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Order'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose><em>Order</em></div><div class="tdStyle1 tdjudicialdrpcol1"></div> </div>
			<div style="clear:both"></div>

						<div class="tableRow">
							<div class="tdStyle1 tdjudicialdrpcol1">       	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Dismissed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Dismissed</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Settled'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Settled</div>
						<div class="tdStyle1 tdjudicialdrpcol1"></div>
						</div>
			<div style="clear:both"></div>

						<div class="tableRow">
							
		<div class="tdStyle1 tdjudicialdrpcol1">       	 <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Other'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Other:
						 <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Other'])&gt; 0">
                        <!-- 
                        <input
					type="text"
					name="judgementOther"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:judgementOther) " />
				</xsl:attribute>
				</input>
				-->
				<div class="tdStyle1"><div class="fakeBox">
              
                <xsl:value-of
                       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:judgementOther) " />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div></div>						
						</xsl:when>
							<xsl:otherwise>
								<input
					type="text"
					name="judgementOther"
					readonly="1">	</input>
					</xsl:otherwise>
						</xsl:choose>	
						</div>
	</div>
		<div style="clear:both"></div>

			
		<div class="tableRow">
		<div class="tdStyle1">       	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Appealed </div>
	</div>
	<div class="tableRow">
		<div class="tdStyle1">
           
             
                  <div class="tableStyle" style="margin-left:0; margin-right:0;">

	<div class="tableRow">
		<div class="tdStyle1">              		<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Affirmed'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Affirmed</div></div><div class="tableRow">
		<div class="tdStyle1">       	      	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated Nunc Pro Tunc / ab initio'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox checked" />
							</xsl:otherwise>
						</xsl:choose>Vacated Nunc Pro Tunc / ab initio</div></div><div class="tableRow">
		<div class="tdStyle1">              		 <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated &amp; Returned For Further Action'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox checked" />
							</xsl:otherwise>
						</xsl:choose>Vacated &amp; Returned For Further Action </div></div><div class="tableRow">
						
					<div class="tdStyle1">              	 <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated / Final'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox checked" />
							</xsl:otherwise>
						</xsl:choose>Vacated / Final  </div></div><div class="tableRow">
							
						
					<div class="tdStyle1">           	   	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Other'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Other:
			  	<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Other'])&gt; 0">			
     		         <!-- 
     		         <input
						type="text"
						name="appealJudgementOther"
						readonly="1">
						<xsl:attribute
							name="value">
						<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:appealJudgementOther) " />
						</xsl:attribute>
				    </input>
				    -->	
				    <p>
					   <div class="fakeBox">
	                        <xsl:value-of
	                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:appealJudgementOther) " />
	                        <span>
	                            <xsl:text>&#160;</xsl:text>
	                        </span>
	                    </div> 
                   </p> 		
				</xsl:when>
					<xsl:otherwise>	
						<input
						type="text"
						name="appealJudgementOther"
						readonly="1"></input>	
					</xsl:otherwise>
						</xsl:choose>				
						</div>
	           </div></div>
             
            	
		</div>
	</div>

</div>
<br />




<p><b>B.    Explanation: </b>
<em>If more than one checked box in Item 11-A is checked or Item 11-A otherwise does not adequately summarize the type of resolution, provide an explanation.  For example, if you appealed all or part of a resolution by the regulator or court, indicate what is being appealed.</em></p>



<p>
<!-- 
             	 <textarea name="textarea25" id="textarea25" cols="64" rows="6" readonly="1">
  
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:explanation)" />      
  </textarea>
  -->
	<div class="fakeBox">
		<xsl:value-of
			select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:explanation)" />
		<span>
			<xsl:text>&#160;</xsl:text>
		</span>
	</div> 
</p>

<p><b>C.    <em>Order:</em> </b> If <em>Order</em> is checked above in Item 11-A, does the <em>order</em> constitute a final <em>order</em> based on violations of any laws or regulations that prohibit fraudulent, or deceptive conduct?     
	<xsl:choose>
						<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder='Y'">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:when>
								<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder='N'">

									<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 	<img
									src="Images/radio-checked.jpg" alt="radio button checked" /> No
							</xsl:when>
							<xsl:otherwise>
							<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 	<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:otherwise>
						</xsl:choose>
</p>
<br />

<p><b>12.  Resolution Date </b>(MM/DD/YYYY): 	
     <input
					type="text"
					name="resolutionInformationDate"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:date) " />
				</xsl:attribute>
				</input>  
			
				
					<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact     
						   <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation 
							<p>			<em>(For a resolution that is being appealed in part, the date to be provided should be the date on which the regulator or court provided its resolution.)</em>   </p>	
						<p>If not exact, provide explanation:   </p>
<p>
<!-- 
  <textarea name="resolutionDateprovideExplanation" cols="64" rows="6" readonly="1">
      <xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:explanationInfo/n2:provideExplanation)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:explanationInfo/n2:provideExplanation)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
				
 </p>



</p>
<br />


<b>13.  Resolution Detail  </b>


<p><b>A. Sanction(s): Was/were any Sanction(s) <em>Ordered</em> or Relief Granted? </b>

					<xsl:choose>
						<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'Y'">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes 
 
<xsl:choose>
						<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'N'">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
 No, none were <em>ordered</em>, or granted.      

</p>



<p><b>B.   If “Yes,” check each individual sanction <em>ordered</em> and/or relief granted below:      </b>   


<p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">

<div class="tableRow">
	<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='BarPermanent'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Bar (Permanent)</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Exemption'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exemption</div>
						
							<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Rescission'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Rescission</div>
	
						</div>
	<div style="clear:both;"></div>
	<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='BarTemporary'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Bar (Temporary / Time Limited)  </div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Expulsion'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Expulsion</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Restitution'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Restitution*	</div>
						
	</div>
	<div style="clear:both;"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Cease and Desist'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Cease and Desist</div>
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Injunction'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose> Injunction</div>
						
							<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Restraining Order'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Restraining <em>Order</em></div>
		
	</div>
	<div style="clear:both;"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Censure'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Censure </div>
						
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Money Damage(s) (Private/Civil Complaint)'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Money Damage(s) (Private/Civil Complaint)*</div>
						
						<div class="tdStyle1 tdjudicialdrpcol1">
						
						<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Requalification'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Requalification 
 </div>
 
	
	</div>
	<div style="clear:both;"></div>
		<div class="tableRow">
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='CivilAdminPenaltyFine'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Civil and Administrative Penalty(ies)/Monetary Fine(s)*</div>
						
							<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Prohibition'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Prohibition</div>
	<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Revocation'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Revocation</div>
		
	</div>
	<div style="clear:both;"></div>
	
		<div class="tableRow">
		
		<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Denial'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Denial</div>
						<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Reprimand'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Reprimand</div>
							<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Suspension'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Suspension</div>
		
			</div>
			<div style="clear:both;"></div>
			<div class="tableRow">
				
			<div class="tdStyle1 tdjudicialdrpcol1"><xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Disgorgement'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Disgorgement*</div>
		<div class="tdStyle1 tdjudicialdrpcol1"> </div>
		
		<div class="tdStyle1 tdjudicialdrpcol1"> <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Undertaking'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Undertaking</div>
	</div>
	<div style="clear:both;"></div>
		
</div>



</p>


 </p>
<!-- 5588 -->
<p><b>&#8226; Monetary Sanction(s):
</b>  Were one or more sanctions ordered that require a monetary payment?  
<xsl:choose>
	<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) &gt; 0">
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
	</xsl:when>
	<!-- 
	<xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered='N'">
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
	</xsl:when>
	-->
	<xsl:otherwise>
		<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
		<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
	</xsl:otherwise>
</xsl:choose>

<p>                         If &quot;Yes,&quot; enter the total amount ordered: 
	<xsl:call-template name="format_to_dollar">
   		<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
   	</xsl:call-template>
	<!-- $<input
					type="text"
					name="sanctiontotalAmountOrdered"
					readonly="1">
					<xsl:attribute
						name="value">
				<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)" />
				</xsl:attribute>
				</input> --> </p>
 </p>



<p> 

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Other'])&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>
<b>Other Sanctions <em>Ordered</em> or Relief Granted: (list each such additional sanction or relief)</b></p>

<p>
<xsl:choose>
	<xsl:when
		test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Other'])&gt; 0">
	<!-- <textarea name="otherSanctions" id="otherSanctions" cols="64" rows="6" 
		readonly="1"> <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions/ns3:otherSanctions)" 
		/> </textarea> -->
		
	  <div class="fakeBox">
		<xsl:value-of
			select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions/n2:other)" />
		<span>
			<xsl:text>&#160;</xsl:text>
		</span>
	</div>
  </xsl:when>
  <xsl:otherwise>
    <textarea name="otherSanctions" id="otherSanctions" cols="64" rows="6" readonly="1"></textarea>
  </xsl:otherwise>
  </xsl:choose>
</p>

<p><br/>
</p>
<p><b>C.    Sanction Detail</b> (Provide the details of the following specific sanctions, if checked above in Item 13-B.)

<p> <b>(1)  Barred, <em>Enjoined</em>, or Suspended. </b> 
If you checked one or more of these sanctions in Item 13-B. above, check the
applicable box(es) below and provide the corresponding information.  </p>

<p>        <b>(a)  Barred</b>   </p>
<p>               (i)	Duration (length of time):<br/><br/>

                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Permanent (not limited by length of time).  <br/><br/>
                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Temporary / Time Limited.  Specify the:  

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Days 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Months 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                                               <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Years 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>

</p>



<p>               (ii)	Start Date (MM/DD/YYYY):   

<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation <br/><br/>

	                 If not exact, provide explanation:
					<br />
					<!--                  
					<textarea name="textarea22" id="textarea22" cols="64" rows="6"
						readonly="1">
						<xsl:value-of
							select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:barred/n2:startDate/n2:explanationInfo/n2:providExplanation)" />
					</textarea>
					-->
					<div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo/n2:providExplanation)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>
</p>



<p>               (iii)	End Date   (MM/DD/YYYY):   

<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/n2:endDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation <br/><br/>

	                 If not exact, provide explanation:
						<br />
						<!--                  
						<textarea name="barredEndDateExplantaion" cols="64" rows="6"
							readonly="1">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:barred/n2:endDate/n2:explanationInfo/n2:providExplanation)" />
						</textarea>
						-->
						<div class="fakeBox">
	                    <xsl:value-of
	                       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo/n2:providExplanation)" />
	                    <span>
	                        <xsl:text>&#160;</xsl:text>
	                    </span>
	                </div>
</p>


<p>               (iv) Description:  Provide remaining details and the registration capacities affected <br/>
                                   (General Securities Principal, Financial Operations Principal, etc.).  If none, enter “None”:
</p>
    <!--   
				<textarea name="barreddescription" cols="64" rows="6"
					readonly="1">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:barred/n2:description)" />
				</textarea>
				-->
				<div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:description)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>

<br/>

<p class="mabox">
	<b>
		If the applicant or an <em>associated person</em> received in the above action one or more bars<br/>
		from registration capacities, associations, and/or other activities; and the terms specify<br/>
		different time periods; report the additional details below: 
	</b>
</p>

<p>        <b>(b)  <em>Enjoined</em></b>      </p>
<p>               (i)	Duration (length of time):<br/><br/>

                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Permanent (not limited by length of time).  <br/><br/>
                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Temporary / Time Limited.  Specify the:  

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Days 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Months 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                                               <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Years 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>

</p>
</p>


<p>               (ii)	Start Date (MM/DD/YYYY):   

<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation <br/><br/>

	                 If not exact, provide explanation:
					<br />
					 <!--                 
					<textarea name="textarea22" id="textarea22" cols="64" rows="6"
						readonly="1">
						<xsl:value-of
							select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:enjoined/n2:startDate/n2:explanationInfo/n2:providExplanation)" />
					</textarea>
					-->
		          <div class="fakeBox">
                        <xsl:value-of
                          select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>



<p>               (iii)	End Date   (MM/DD/YYYY):   

<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation <br/><br/>

	                 If not exact, provide explanation:
					<br />
					<!--                
					<textarea name="enjoinedEndDateExplantaion" cols="64" rows="6"
						readonly="1">
						<xsl:value-of
							select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:enjoined/n2:endDate/n2:explanationInfo/n2:providExplanation)" />
					</textarea>
					-->
					<div class="fakeBox">
                        <xsl:value-of
                          select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>


<p>               (iv) Description:  Provide remaining details and the registration capacities affected <br/>
                                   (General Securities Principal, Financial Operations Principal, etc.).  If none, enter “None”:<br/>
</p>

                 <!-- 
     	     	   <textarea name="enjoineddescription"
					cols="64" rows="6" readonly="1">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:enjoined/n2:description)" />
				</textarea>
                -->
				<div class="fakeBox">
					<xsl:value-of
						select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:description)" />
					<span>
						<xsl:text>&#160;</xsl:text>
					</span>
				</div>

<p class="mabox">
<b>
	If the applicant or an <em>associated person</em> received in the above action one or more injunctions<br/>
	from registration capacities, associations, and/or other activities; and the terms specify<br/>
	different time periods; report the additional details below:
</b>
</p>

<p>        <b>(c)  Suspended</b>    </p>
<p>             If the applicant or an <em>associated person</em> in the above action one or more bars from registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry.</p>
<p>               (i)	Duration (length of time):<br/><br/>

                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Permanent (not limited by length of time).  <br/><br/>
                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Temporary / Time Limited.  Specify the:  

                        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Days 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Months 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                                               <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Years 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>

</p>



<p>               (ii)	Start Date (MM/DD/YYYY):   

<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation <br/><br/>

	                 If not exact, provide explanation:
						<br />
						<!--                  
						<textarea name="textarea22" cols="64" rows="6" readonly="1">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:suspended/n2:startDate/n2:explanationInfo/n2:providExplanation)" />
						</textarea>
						-->
						<div class="fakeBox">
	                    <xsl:value-of
	                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo/n2:providExplanation)" />
	                    <span>
	                        <xsl:text>&#160;</xsl:text>
	                    </span>
	                </div>
</p>



<p>               (iii)	End Date   (MM/DD/YYYY):   

<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:exact)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Exact        <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Explanation <br/><br/>

	                 If not exact, provide explanation:
						<br />
						<!--                  
						<textarea name="suspendedEndDateExplantaion" cols="64" rows="6"
							readonly="1">
							<xsl:value-of
								select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:suspended/n2:endDate/n2:explanationInfo/n2:providExplanation)" />
						</textarea>
					-->
					<div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>


<p>               (iv) Description:  Provide remaining details and the registration capacities affected <br/>
                                   (General Securities Principal, Financial Operations Principal, etc.).  If none, enter “None”:
</p>

	<!--                      
	<textarea name="suspendeddescription" cols="64" rows="6"
		readonly="1">
		<xsl:value-of
			select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:suspended/n2:description)" />
	</textarea>
    -->
   <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:description)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div> 

<p class="mabox">
	<b>
		If the applicant or an <em>associated person</em> received in the above action one or more suspensions<br/>
		from registration capacities, associations, and/or other activities; and the terms specify<br/>
		different time periods; report the additional details below:
	</b>
</p>
<!-- Starting here -->
<p><b>(2)   Requalification:</b>   
<br></br><br></br>
            Was requalification by examination, retraining, or other process a condition of a sanction? 

<br></br><br></br>              	             	             	 <xsl:choose>
						<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'Y'">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>Yes
	  <xsl:choose>
						<xsl:when
								test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'N'">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>No
<br></br><br></br>
           If the applicant or an <em>associated person</em> received in the above action one or more requalifications in connection with registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry. 		   

  </p>



<p>If &quot;Yes,&quot; provide: </p>

<p>  (a)	Length of time given to requalify, retrain, or complete other process:<br/>

                   <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:permanent)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>No time period is specified.     <br/><br/>
                  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Time period is specified:    

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Days 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Months 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                       <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

									<img
									src="Images/box-checked.jpg" alt="checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
							</xsl:otherwise>
						</xsl:choose>Years 
						<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>



 </p>



<p>(b)	Type of examination, retraining, or other process required:   <br/><br/>
<!-- 
<textarea name="textarea19" cols="64" rows="6" readonly="1">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:requalificationDetails/n2:typeRequired)" />
</textarea>
-->
     <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:typeRequired)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>



<p> (c)  Was the condition satisfied?     
	<xsl:choose>
		<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied) &gt; 0">
			<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes 
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
		</xsl:when>
		<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied) &gt; 0">
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes 
			<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
		</xsl:when>
		<xsl:otherwise>
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes 
			<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
		</xsl:otherwise>
	</xsl:choose>
						<p>             (1)   If &quot;Yes,&quot; provide the date (MM/DD/YYYY):  <input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied)" />
</xsl:attribute>
</input>
						</p>
						<p>             (2)   If &quot;No,&quot; explain the circumstances:   </p>

<p>
<!-- 
               <textarea name="textarea18" id="textarea18"
				cols="64" rows="6" readonly="1">
			
				<xsl:value-of
					select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:requalificationDetails/n2:conditionState/n2:notSatisfied/n2:explanation)" />
			</textarea>
 -->
	 <div class="fakeBox">
		<xsl:value-of
			select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:notSatisfied)" />
		<span>
			<xsl:text>&#160;</xsl:text>
		</span>
	</div> 
</p>

						
	  </p>

<p class="mabox">
	<b>
		If the applicant or an <em>associated person</em> received in the above action one or more<br/>
		requalifications from registration capacities, associations, and/or other activities;<br/>
		and the terms specify different time periods; use the drop down box to report the additional details.
	</b>
</p>

<p><b>(3)   Monetary Sanction(s): </b> If you indicated in Item 13.B above that one or more monetary sanctions were ordered, provide the following information.</p>

<p> (a) Total Amount Ordered:  


    <xsl:call-template name="format_to_dollar">
    	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
    </xsl:call-template>
</p>

<p> (b) Portion levied against:  </p>
		    <xsl:choose>
				<xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered &gt; 0 ">
					<img src="Images/box-checked.jpg" alt="checkbox checked"/>
				</xsl:when>
				<xsl:otherwise>
					<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
				</xsl:otherwise>
			</xsl:choose> 
			<b>Applicant</b>
				<p>    
					(i) Amount Ordered:
					<xsl:call-template name="format_to_dollar">
				    	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered" />
				    </xsl:call-template>
				</p>
				<p>    
					(ii) Was any portion waived?  
					<xsl:choose>
						<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0">
							<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
							<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
						</xsl:otherwise>
					</xsl:choose><br/>    
				    If “Yes,” how much?      
				
					<xsl:call-template name="format_to_dollar">
				    	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion" />
				    </xsl:call-template>
					
				</p>
				<p>    
					(iii) Final Amount:  
					 
					<xsl:call-template name="format_to_dollar">
				    	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount" />
				    </xsl:call-template>
				   
				</p>
				<p>    
					(iv) Was final amount paid in full?    
					<xsl:choose>
						<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied) &gt; 0">
							<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						<xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied) &gt; 0">
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                            <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
                        </xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
					</xsl:choose>
				</p>
				<p>    
				    If &quot;Yes,&quot; date paid in full (MM/DD/YYYY)
					<input type="text" name="text49" readonly="1">
						<xsl:attribute name="value">
							<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied)" />
						</xsl:attribute>
					</input>
				</p>
				<p>    
				    If &quot;No,&quot; explain the circumstances:
					<p>
					<div class="fakeBox">
				        <xsl:value-of
				            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied)" />
				        <span>
				            <xsl:text>&#160;</xsl:text>
				        </span>
				    </div> 
					</p>
				</p>

<xsl:choose>
	<xsl:when
		test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicant)&gt; 0">
			<img src="Images/box-checked.jpg"  alt="checkbox checked"/>
	</xsl:when>
	<xsl:otherwise>
			<img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
	</xsl:otherwise>
</xsl:choose> <b><em>Associated Person</em></b>


<p>  (i) Amount Ordered:                   $<input
	type="text"
	name="text49"
	readonly="1">
</input>   </p>

<p>  (ii) Was any portion waived?  <xsl:choose>
						<xsl:when
								test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:waivedPortion) &gt; 0">

									<img
									src="Images/radio-checked.jpg" alt="radio button checked" />Yes <img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
							</xsl:when>
							<xsl:otherwise>
						
								<img
									src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img
									src="Images/radio-checked.jpg" alt="radio button checked" />No
							</xsl:otherwise>
						</xsl:choose>            


If “Yes,” how much?      $<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:waivedPortion)" />
</xsl:attribute>
</input> 
 </p>
 
<p>  (iii) Final Amount:                         $<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:finalAmount)" />
</xsl:attribute>
</input>   </p>

<p>  (iv) Was final amount paid in full?    
					<xsl:choose>
						<xsl:when
							test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:satisfied/n2:satisfied='Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:when>
						<xsl:when
							test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:satisfied/n2:satisfied='N'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
						</xsl:when>
						<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
					</xsl:choose>
</p>

<p>      If &quot;Yes,&quot; date paid in full (MM/DD/YYYY):
<input
	type="text"
	name="text49"
	readonly="1">
	<xsl:attribute
		name="value">
	<xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:satisfied/n2:satisfiedDate)" />
	</xsl:attribute>
</input>
</p>
<p>     If &quot;No,&quot; explain the circumstances:

<p>
<!-- 
      <textarea name="textarea17"  cols="64" rows="6" readonly="1">
    <xsl:value-of
		select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:notSatisfied/n2:explanation)" />
  </textarea>
 -->
	 <div class="fakeBox">
		<xsl:value-of
			select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:notSatisfied/n2:explanation)" />
		<span>
			<xsl:text>&#160;</xsl:text>
		</span>
	</div> 
</p>

</p>

<p>
<b>Provide the information for each additional associated person below:</b><br/>
<!-- 
	<textarea name="textarea" cols="64" rows="6" readonly="1">                 
		<xsl:value-of select="string(ns3:header/ns3:baseInformation/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" />
	</textarea>
-->
<div class="fakeBox">
        <xsl:value-of
            select="string(ns3:header/ns3:baseInformation/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>

<p><b>14.  Summary of Circumstances:</b> 
Use this space to provide a brief summary of the circumstances 
leading to the action, allegation(s), finding(s) and disposition(s), 
if any.  Include any relevant information on the current action 
status, and on any terms, conditions, and dates not already provided 
above, and any other relevant information.  The information must fit 
within the space provided.
</p>

<p>
<!-- 	<textarea  cols="64" rows="6" readonly="1">
		<xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:summary)" />
	</textarea>
-->
 <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:summary)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>

</xsl:for-each>
<!-- <h3>Associated Persons</h3> -->
<xsl:for-each select="ns3:apInfo/ns3:associatedPerson">
<p><b>1.     Court Action was initiated by:   <br/><br/>A. Select the Appropriate Item(s).  (Check all that apply.) </b></p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">
<div class="tableRow">
    <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='SEC'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   <em>SEC</em></div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='State'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   State</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Foreign Financial Regulatory Authority'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   <em>Foreign Financial Regulatory Authority</em></div></div>
    <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='CFTC'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   <em>CFTC</em></div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='SRO'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   <em>SRO</em></div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Municipal Advisory Firm'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    <em>Municipal Advisory Firm</em> 
                            </xsl:otherwise>
                        </xsl:choose>    </div>
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Other Federal Authority'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   Other Federal Authority</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Commodities Exchange'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   Commodities Exchange </div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Private Plantiff'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>  Private Plaintiff </div>
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy[n2:initiator='Other'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" /> Other:
                                    <!--  
                                     <input
									    type="text"
									    name="text49"
									    readonly="1">
									    <xsl:attribute
									        name="value">
									<xsl:value-of
									        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy/n2:other)" />
									</xsl:attribute>
									</input>
								-->
								<div class="fakeBox">
					                <xsl:value-of
					                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedBy/n2:other)" />
					                <span>
					                    <xsl:text>&#160;</xsl:text>
					                </span>
					            </div>
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> Other: <input
    type="text"
    name="text49"
    readonly="1">   
</input>
                            </xsl:otherwise>
                        </xsl:choose>    </div>
        <div class="tdStyle1"> </div>
        
    </div>
</div>

<p>
<b>B.   Plaintiff(s):  Enter the full name(s) of the plaintiff(s), unless only <em>SEC</em> and/or <em>CFTC</em> is/are checked above. </b> For a <em>foreign financial regulatory authority,</em> please provide the full name in English. 
</p>

<p>
<!-- 
<textarea name="textarea4"  cols="64" rows="6" readonly="1">
                  
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation/n2:plantiffName)" />
                
              </textarea>
    -->
<div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation/n2:plantiffName)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
 </p>


Were all plaintiffs fully identified in the space provided?  

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation[n2:isMissingPlantiffs='Y'])&gt; 0">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:when>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:plantiffsInformation[n2:isMissingPlantiffs='N'])&gt; 0">

                                    <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />  No
                            </xsl:otherwise>
                        </xsl:choose> 
                        
                        <p><b>2.  Defendant(s): </b>
                        
                        <p>
                        <b>          A. Enter the full name(s) of the defendant(s). </b>  For foreign defendant(s), please provide the full name(s) in English:
                          <br/><br/>
                          <!-- >
                                    <textarea name="textarea4"  cols="64" rows="6" readonly="1">
                  
                            <xsl:value-of
                                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:defendantName)" />
                            
                          </textarea>
                          -->
                          <div class="fakeBox">
                                <xsl:value-of
                                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:defendantName)" />
                                <span>
                                    <xsl:text>&#160;</xsl:text>
                                </span>
                            </div>
                                            
                        </p>
                        <p>
                        
                                                
                        </p> <b>  B.    Are you a named defendant?   </b>
                              <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation[n2:isADefendant='Y'])&gt; 0">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:when>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation[n2:isADefendant='N'])&gt; 0">

                                    <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />  No
                            </xsl:otherwise>
                        </xsl:choose> If “No,” describe how this action involves you:
                        <br/><br/>
                        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation[n2:isADefendant='N'])&gt; 0">
                                <!-- 
                     <textarea name="textarea4"  cols="64" rows="6" readonly="1">
                  
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:involementInformation)" />
                
              </textarea> 
              -->
                 <div class="fakeBox">
                                <xsl:value-of
                                   select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:defendantInformation/n2:involementInformation)" />
                                <span>
                                    <xsl:text>&#160;</xsl:text>
                                </span>
                            </div>
              </xsl:when>
              <xsl:otherwise> 
             
               <textarea name="textarea5"  cols="64" rows="6" readonly="1"></textarea>
               
              </xsl:otherwise>
              </xsl:choose>
                        
                        </p>

<p><b>3.   Sanction(s) or Relief Sought  </b> (check appropriate items):</p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">
<div class="tableRow">
    <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='BarPermanent'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Bar (Permanent)</div>
                        
                        <div class="tdStyle1">
        
        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Exemption'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exemption </div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Rescission'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Rescission</div>
        
                        </div>
    <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='BarTemporary'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Bar (Temporary / Time Limited) </div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Expulsion'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Expulsion</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Restitution'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Restitution</div>
                        
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Cease and Desist'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Cease and Desist </div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Injunction'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Injunction</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Restraining Order'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Restraining <em>Order</em></div>
        
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Censure'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Censure</div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Money Damage(s) (Private/Civil Complaint)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Money Damage(s) (Private/Civil Complaint)</div>
                        
                        <div class="tdStyle1">
                        
                        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Requalification'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Requalification 
 </div>
        
    
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='CivilAdminPenaltyFine'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Civil and Administrative Penalty(ies)/Fine(s)</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Prohibition'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Prohibition</div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Revocation'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Revocation</div>
        
        
    </div>
    <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Denial'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Denial</div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Reprimand'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Reprimand</div>
                            <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Suspension'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Suspension</div>
                        
    </div>
    <div class="tableRow">
        <div class="tdStyle1">
        
        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Disgorgement'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Disgorgement</div>
                    <div class="tdStyle1"></div>
                    <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Undertaking'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Undertaking</div>
    </div>
    <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought[n2:sanctionRelief='Other'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" /> <b>Other Sanction(s) or Relief Sought:</b> <br/><br/>
                        <!-- 
                          <textarea name="textarea" cols="64" rows="6" readonly="1">         
                    
                            
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought/ns3:otherSanctions)" />
                            </textarea>
                            -->
                            <div class="fakeBox">
                                <xsl:value-of
                                  select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:sanctionsReliefSought/n2:other)" />
                                <span>
                                    <xsl:text>&#160;</xsl:text>
                                </span>
                            </div>
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> <b>Other Sanction(s) or Relief Sought:</b> <br/><br/>
                        
                          <textarea name="textarea" cols="64" rows="6" readonly="1">                 
                    
                            </textarea>
                            </xsl:otherwise>
                        </xsl:choose>

</div><div class="tdStyle1"></div>

    </div>
</div>

<p><b>4.    A.  Filing Date of Court Action</b> (MM/DD/YYYY):       
        <input  type="text"     readonly="1">
            <xsl:attribute name="value">
                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:date)" />
            </xsl:attribute>
        </input>
        <br/>            
        <xsl:choose>
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:exact)&gt; 0">
                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
            </xsl:otherwise>
        </xsl:choose>Exact        
        <xsl:choose>
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:explanationInfo)&gt; 0">
                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
            </xsl:otherwise>
        </xsl:choose>Explanation
			</p>
			
			<p>        If not exact, provide explanation:  </p>
			
			<p>
			<!-- 
			           <textarea name="textarea" cols="64" rows="6" readonly="1">         
			                    
			                            
			                            <xsl:value-of
			                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:filingDate/n2:explanationInfo/n2:provideExplanation)" />
			                            </textarea>
			    -->
        <div class="fakeBox">
            <xsl:value-of
                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:statusDateInfo/n2:explanationInfo/n2:provideExplanation)" />
            <span>
                <xsl:text>&#160;</xsl:text>
            </span>
       </div>
</p>


<p><b>    B.    Date Notice/Process was served </b> (MM/DD/YYYY):
        <input  type="text"     readonly="1">
            <xsl:attribute name="value">
                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:date)" />
            </xsl:attribute>
        </input>
        <br/>            
        <xsl:choose>
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:exact)&gt; 0">
                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
            </xsl:otherwise>
        </xsl:choose>Exact        
        <xsl:choose>
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:explanationInfo)&gt; 0">
                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
            </xsl:otherwise>
        </xsl:choose>Explanation
</p>

<p>        If not exact, provide explanation:  </p>

<p>
<!-- 
           <textarea name="textarea" cols="64" rows="6" readonly="1">         
                    
                            
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:explanationInfo/n2:provideExplanation)" />
                            </textarea>
    -->
    <div class="fakeBox">
            <xsl:value-of
                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:notificationServedInformation/n2:explanationInfo/n2:provideExplanation)" />
            <span>
                <xsl:text>&#160;</xsl:text>
            </span>
       </div>
</p>


<p><b>5.     Formal
Action was brought in </b><em>(If brought in a foreign jurisdiction, provide all the information below in English):</em>   </p>
<p>
        <b>Check the applicable box:</b></p>
<p>          <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:fedCourt)&gt; 0">
                                <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Federal Court
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:milCourt)&gt; 0">
                                <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Military Court
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:stateCourt)&gt; 0">
                                <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> State Court  
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:foreignCourt)&gt; 0">
                                <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Foreign Court  
                         <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:intnlCourt)&gt; 0">
                                <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> International Court <br/><br/>
                        
                              <xsl:choose>
                            <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:civilJudicialCourt/ns3:other)&gt; 0">
                                <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Other :
                       <!-- 
                        <input      type="text"     name="text49"   readonly="1">   
                        <xsl:attribute      name="value"> 
                        <xsl:value-of       select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)" />
                </xsl:attribute>
                    </input>
                    -->
                    <div class="fakeBox">
              
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:courtBroughIn/ns3:other)" />
                <span>
                    <xsl:text>&#160;</xsl:text>
                </span>
            </div>
<br/><br/>
</p>

<b>          A. Name of the Court: </b>
                <div class="fakeBox">
                          
                            <xsl:value-of
                                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:name)" />
                            <span>
                                <xsl:text>&#160;</xsl:text>
                            </span>
                        </div>
            <br/><br/>
<b>          B. Location of the Court<br/><br/></b>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
          <div class="tableRow">
          <div class="tdStyle1">
          Street Address:  </div>
            <div class="tdStyle1"><input  type="text"     name="firm name"    readonly="1"    size="60">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:street1)" />
                            </xsl:attribute>
                        </input> 
                        </div>
                        </div>
                        <div class="tableRow">
                        <div class="tdStyle1">
                          City or County:  
                            </div>
                            <div class="tdStyle1"><input  type="text"     name="firm name"    readonly="1"    size="45">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:city)" />
                            </xsl:attribute>
                        </input>
                        </div>  
                        </div>
                        <div class="tableRow">
                        <div class="tdStyle1">
                         State/Country:</div>
                        <div class="tdStyle1">
                        <!--   
                        <input  type="text"     name="firm name"    readonly="1"   size="60">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
                            </xsl:attribute>
                        </input>  
                        -->
                        <div class="fakeBox"> 
                        <span >
                        <xsl:call-template name="stateDescription">
                            <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:stateOrCountry)" />
                         </xsl:call-template>
                             </span>
                             <span>
                             <xsl:text>&#160;</xsl:text>
                             </span>
                          </div>
                        <br/><br/>
                        </div>
                        </div>
                        <div class="tableRow">
                        <div class="tdStyle1">
                        Zip Code:  
                        </div>
                        <div class="tdStyle1"> <input     type="text"     name="firm name"    readonly="1"   size="30">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:address/ns1:zipCode)" />
                            </xsl:attribute>
                        </input>
                        </div>
                        <br/>
                        <br/>
                   </div>
               </div>
               <p>
               <p>
               <b> C. Docket/Case Number:</b></p>
               <div class="tableStyle" style="margin-left:0; margin-right:0;">
                 <div class="tableRow">
                  <div class="tdStyle1"> </div>
                    <div class="tdStyle1">
                    <!-- 
                    <input  type="text"     name="firm name" readonly="1">
                                    <xsl:attribute
                                            name="value">
                                    <xsl:value-of
                                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
                                    </xsl:attribute>
                                </input> 
                                -->
                                <div class="fakeBox">
                                  
                                    <xsl:value-of
                                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:chargesBroughtIn/n2:docketOrCaseNo)" />
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                                </div>
                        </div>       
                </div>
          </div>
        <br />
        <br />
        </p>
    
<p><b>6.     A. 
Principal Product Type  (check appropriate item): </b></p>


<div class="tableStyle" style="margin-left:0; margin-right:0;">
<div class="tableRow">
    <div class="tdStyle1">         
    <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='No Product'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>No Product 
    
    </div>
</div>
<div class="tableRow">
    <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='AnnuityCharitable'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Annuity – Charitable</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Direct Investment(s) - DPP &amp; LP Interest(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Direct Investment – DPP &amp; LP Interest</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='OilAndGas'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Oil &amp; Gas</div></div>
    <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Annuity(ies) - Fixed'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Annuity – Fixed </div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='EquipmentLeasing'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Equipment Leasing</div>
                        <div class="tdStyle1">
                        
                        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Options'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Options 
 </div>
    </div>
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Annuity(ies) - Variable'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Annuity – Variable</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Equity Listed (Common &amp; Preferred Stock)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Equity Listed (Common &amp; Preferred Stock)</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Penny Sock(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Penny Stock</div>
    </div>
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='BankingProduct'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Banking Product <br/>(other than CD) </div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Equity - OTC'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Equity OTC</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='PrimeBankInstrument'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Prime Bank Instrument</div>
    </div>
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='CD(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>CD</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Futures - Commodity'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Futures – Commodity</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Promissory Note'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Promissory Note</div>
    </div>
    
    
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Commodity Option(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Commodity Option</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Futures - Financial'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Futures – Financial</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Real Estate Security'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Real Estate Security</div>
    </div>
    
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Asset Backed'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Debt – Asset Backed</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Index Option(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Index Option</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Security Futures'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Security Futures</div>
    </div>
    
    
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Corporate'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Debt – Corporate</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Insurance'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Insurance</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Security-based Swap'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Security-based Swap</div>
    </div>
    
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Government'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Debt – Government</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Investment Contract(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Investment Contract</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Swap'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Swap</div>
    </div>
    
    
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Debt - Municipal'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Debt – Municipal</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Money Market Fund(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Money Market Fund</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Unit Investment Trust(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Unit Investment Trust</div>
    </div>
    
    
        <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Derivative(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Derivative</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Mutual Fund(s)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Mutual Fund</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Viatical Settlement'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Viatical Settlement</div>
    </div>
    
    
    
    
    <div class="tableRow">
        <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes[n2:product='Other'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" /> <b>Other Principal Product Type:</b>  <br/><br/>
                                  <!-- 
                                    <textarea name="textarea" cols="64" rows="6" readonly="1">         
                    
                            
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes/n2:productOther)" />
                            </textarea>
                            -->
                            <div class="fakeBox">
                                    <xsl:value-of
                                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:principalProductTypes/n2:productOther)" />
                                    <span>
                                        <xsl:text>&#160;</xsl:text>
                                    </span>
                               </div>
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" /> <b>Other Principal Product Type:</b>  <br/><br/>
                        
                                    <textarea name="textarea" cols="64" rows="6" readonly="1">                 
                    
                            </textarea>
                            </xsl:otherwise>
                        </xsl:choose>

</div><div class="tdStyle1"></div>

    </div>
</div>
                                                         
<br/>


   <b>       B.  Other Product Types?    </b>
                    <xsl:choose>
                        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes) &gt; 0">
                                <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                        </xsl:when>
                        <!-- 
                        <xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes='N'">
                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
                                <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
                        </xsl:when>
                        -->
                        <xsl:otherwise>
                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
                                 <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
                        </xsl:otherwise>
                    </xsl:choose>
 
<p>      
         If &quot;Yes,&quot; describe each additional product
  type :      </p>



<p>
<!-- 
               <textarea name="textarea" cols="64" rows="6" readonly="1">         
                    
                            
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes)" />
                            </textarea>
    -->
    <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:otherProductTypes)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>

<p><b>7.  Allegations: </b>  :   Describe the allegations related to this civil action.  (The response must fit within
the space provided.)</p>



<p>
<!-- 
            <textarea name="textarea40" id="textarea40" cols="64" rows="6" readonly="1">
<xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:allegationsDescription)" />  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:allegationsDescription)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>

<p><b>8.     Current Status:</b>   
        <xsl:choose>  
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:status/n1:pending)&gt; 0">
                <img src="Images/radio-checked.jpg" alt="radio button checked" />
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />    
            </xsl:otherwise>
        </xsl:choose> Pending
        <xsl:choose>  
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:status/n1:onAppeal)&gt; 0">
                <img src="Images/radio-checked.jpg" alt="radio button checked" />
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
            </xsl:otherwise>
        </xsl:choose> On Appeal
        <xsl:choose>  
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:status/n1:final)&gt; 0">
                <img src="Images/radio-checked.jpg" alt="radio button checked" />
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
            </xsl:otherwise>
        </xsl:choose> Final
</p>

<p><b>9.    Pending:  If you checked Item 8 Pending, provide the following information. </b> </p>
<p><b>       A. Date Served: </b> The date that notice or other process was served (MM/DD/YYYY): 
        <input  type="text"     readonly="1">
            <xsl:attribute name="value">
                <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:date)" />
            </xsl:attribute>
        </input>
        <br/>            
        <xsl:choose>
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:exact)&gt; 0">
                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
            </xsl:otherwise>
        </xsl:choose>Exact        
        <xsl:choose>
            <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo)&gt; 0">
                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
            </xsl:when>
            <xsl:otherwise>
                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
            </xsl:otherwise>
        </xsl:choose>Explanation 
</p>

<p>          If not exact, provide explanation:  </p>
<p>
<!-- 
            <textarea name="textarea26" id="textarea26" cols="64" rows="6" readonly="1">
      <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/n2:servedInformation/n2:explanationInfo/n2:provideExplanation)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:servedInformation/n2:explanationInfo/n2:provideExplanation)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>
<b>       B.    Limitation or Restrictions:  </b> Are there any limitations or restrictions currently in effect?    
<xsl:choose>
    <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:limitationsRestrictions) &gt; 0">
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
    </xsl:when>
    <!-- 
    <xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/n2:limitationsRestrictions='N'">
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
    </xsl:when>
    -->
    <xsl:otherwise>
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
    </xsl:otherwise>
</xsl:choose>

<p>          If the answer is “Yes,” provide details:  </p>
<p>
<!-- 
            <textarea name="textarea27" cols="64" rows="6" readonly="1">
      <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/n2:limitationsRestrictions/n2:details)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:pendingInformation/ns3:limitationsRestrictions)" /> 
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
</p>

<p><b>10.   On Appeal – Judicial Review: </b> If you appealed, provide the following information.   
<em>(If brought in a foreign jurisdiction, provide all the information below in English):</em>  

<br/><br/>
<b>       A. Action Appealed to: </b> <em>(Provide the name of the federal, state, foreign, or international court to whom you appealed:)</em> 
<br/><br/>
<!-- 
           <input   type="text"     name="NameofRegulatororCourt"   readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:appealBroughtInInformation/n2:name)" />
                            </xsl:attribute>
                        </input>
                   -->
                    <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:name)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
                        <br/><br/>
                        <b>       B.    Location of the Court:  </b><br/><br/>
                                 Street Address: <input     type="text"     name="RegulatororStreetAddress"     readonly="1" size="60">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:street1)" />
                            </xsl:attribute>
                        </input><br/><br/>
                        
                                 City or County:  <input    type="text"     name="RegulatororCityorCounty"  readonly="1"   size="45">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:city)" />
                            </xsl:attribute>
                        </input> 
                        <br />
                        <div class="tableStyle" style="margin-left:0; margin-right:0;">
                        <div class="tableRow"><div class="tdStyle1">
                        State/Country: </div>
                        <div class="tdStyle1">
                        <!-- 
                         <input     type="text"     name="RegulatororStateOrCountry"    readonly="1"   size="60">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:stateOrCountry)" />
                            </xsl:attribute>
                        </input>  
                        -->
                        <div class="fakeBox"> 
                        <span >
                    <xsl:call-template name="stateDescription">
                        <xsl:with-param name="stateCode" select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:stateOrCountry)" />
                     </xsl:call-template>
                 </span>
                 <span>
                 <xsl:text>&#160;</xsl:text>
                 </span>
              </div>
                        <br/><br/>
                        </div> 
                        </div>
                        </div>
                        
                                 Zip Code: <input   type="text"     name="RegulatororZipCode"   readonly="1"  size="30">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:appealBroughtInInformation/n2:address/ns1:zipCode)" />
                            </xsl:attribute>
                        </input>
 </p>


<p><b>
       C.    Docket/Case Name:  </b> 
   <!--  
    <input  type="text"     name="RegulatororDocketCaseName"    readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:docketName)" />
                            </xsl:attribute>
                        </input>
                        -->
                        <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:docketName)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
                        <br/><br/>
                        
    <b>       D.     Docket/Case Number:</b> 
    <!-- 
          <input    type="text"     name="RegulatorordocketOrCaseNo"    readonly="1">
                            <xsl:attribute
                                    name="value">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:docketOrCaseNo)" />
                            </xsl:attribute>
                        </input>
            -->
            <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation//ns3:appealBroughtInInformation/n2:docketOrCaseNo)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
                        <br/><br/>
    <b>       E.    Date Appeal filed </b>(MM/DD/YYYY): 
    <input type="text" name="RegulatorordocketOrCaseNo"
                                            readonly="1">
                                            <xsl:attribute name="value">
                            <xsl:value-of
                                                select="string(ns3:drpInfo/ns3:dateInformation/n2:date)" />
                            </xsl:attribute>
                                        </input>

                                        <xsl:choose>
                                            <xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:dateInformation/n2:exact)&gt; 0">

                                                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
                                            </xsl:when>
                                            <xsl:otherwise>

                                                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        Exact        
                                        <xsl:choose>
                                            <xsl:when
                                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:dateInformation/n2:explanationInfo)&gt; 0">

                                                <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
                                            </xsl:when>
                                            <xsl:otherwise>

                                                <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        Explanation 

                                        <p>         If not exact, provide explanation:   </p>
                                        <p>
                                            <!-- >          <textarea name="RegulatorprovideExplanation" cols="64" 
                                                rows="6" readonly="1"> <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:dateInformation/n2:explanationInfo/n2:provideExplanation)" 
                                                /> </textarea> -->
                                            <div class="fakeBox">
                                                <xsl:value-of
                                                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:dateInformation/n2:explanationInfo/n2:provideExplanation)" />
                                                <span>
                                                    <xsl:text>&#160;</xsl:text>
                                                </span>
                                            </div>
                                        </p>

<b>       F.    Appeal Details (including status): </b><br/><br/>
<!-- 
           <textarea name="RegulatorAppealDetails" cols="64" rows="6" readonly="1">
      <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:details)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
                        <xsl:value-of
                          select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:details)" />    
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
  <br/><br/>

  <b>        G. Limitation or Restrictions:  </b> Are there any limitations or restrictions currently in effect while on appeal?  
<xsl:choose>
    <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:limitationsRestrictions) &gt; 0">
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
    </xsl:when>
    <!-- 
    <xsl:when test="ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/ns3:limitationsRestrictions='N'">
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
    </xsl:when>
    -->
    <xsl:otherwise>
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
         <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
    </xsl:otherwise>
</xsl:choose>
<br/><br/>
                                 If the answer is “Yes,” provide details:<br/>
                        <!-- 
                                <textarea name="RegulatorlimitationsRestrictionsDetails" cols="64" rows="6" readonly="1">
      <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:limitationsRestrictions/n2:details)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:appealInformation/n2:limitationsRestrictions/n2:details)" />   
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>

</p>

<p>
<b>If you checked Item 8 Final or On Appeal, complete Items 11 through 14. For Pending Actions, skip to Item 14.</b>
</p>

<p><b>11.  A.    Resolution: </b>  How was the action resolved?  <em>Check all the applicable boxes that reflect the most recent</em> 
resolution of the action by a court, whether or not any part of the resolution is on appeal. If any part of
the resolution is on appeal, identify in Item 11-B which part is currently on appeal.</p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">

    <div class="tableRow">
        <div class="tdStyle1">        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Consent'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Consent</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Judgement Rendered'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Judgment Rendered</div>
        
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Stipulation and Consent'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Stipulation and Consent</div>
    </div>
    
        <div class="tableRow">
        
        <div class="tdStyle1">        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Decision</div>
                        
                            <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Opinion'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Opinion</div>
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Withdrawn'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Withdrawn</div>
    </div>
    
        <div class="tableRow">
        
        
  <div class="tdStyle1">          <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Decision &amp; Order of Offer of Settlement'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Decision &amp; <em>Order</em> of Offer of Settlement</div>      <div class="tdStyle1">
        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Order'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose><em>Order</em></div><div class="tdStyle1"></div> </div>
                        
                        <div class="tableRow">
                            <div class="tdStyle1">        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Dismissed'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Dismissed</div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Settled'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Settled</div>
                        <div class="tdStyle1"></div>
                        </div>
                        <div class="tableRow">
                            
        <div class="tdStyle1">         <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Other'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Other:
                         <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Other'])&gt; 0">
<input
                    type="text"
                    name="judgementOther"
                    readonly="1">
                    <xsl:attribute
                        name="value">
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:judgementOther) " />
                </xsl:attribute>
                </input>                        
                        </xsl:when>
                            <xsl:otherwise>
                                <input
                    type="text"
                    name="judgementOther"
                    readonly="1">   </input>
                    </xsl:otherwise>
                        </xsl:choose>   
                        </div> <div class="tdStyle1"></div>
    </div>
    
            
        <div class="tableRow">
        <div class="tdStyle1">        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Appealed </div>
        <div class="tdStyle1"></div>
        <div class="tdStyle1"> </div>
    </div>
    <div class="tableRow">
        <div class="tdStyle1">
           
             
                  <div class="tableStyle" style="margin-left:0; margin-right:0;">

    <div class="tableRow">
        <div class="tdStyle1">                   <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Affirmed'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Affirmed</div></div><div class="tableRow">
        <div class="tdStyle1">                   <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated Nunc Pro Tunc / ab initio'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Vacated Nunc Pro Tunc / ab initio</div></div><div class="tableRow">
        <div class="tdStyle1">                    <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated &amp; Returned For Further Action'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Vacated &amp; Returned For Further Action </div></div><div class="tableRow">
                        
                    <div class="tdStyle1">                <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Vacated / Final'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Vacated / Final  </div></div><div class="tableRow">
                            
                        
                    <div class="tdStyle1">                   <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Other'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Other:
                <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:judgement='Appealed'])&gt; 0 and count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types[ns3:appealJudgement='Other'])&gt; 0">          
                     <!-- 
                     <input
                        type="text"
                        name="appealJudgementOther"
                        readonly="1">
                        <xsl:attribute
                            name="value">
                        <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:appealJudgementOther) " />
                        </xsl:attribute>
                    </input>
                    --> 
                    <p>
                       <div class="fakeBox">
                            <xsl:value-of
                               select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:appealJudgementOther) " />
                            <span>
                                <xsl:text>&#160;</xsl:text>
                            </span>
                        </div> 
                   </p>         
                </xsl:when>
                    <xsl:otherwise> 
                        <input
                        type="text"
                        name="appealJudgementOther"
                        readonly="1"></input>   
                    </xsl:otherwise>
                        </xsl:choose>               
                        </div>
               </div></div>
             
                
        </div>
    </div>

</div>





<p><b>B.    Explanation: </b>
<em>If more than one checked box in Item 11-A is checked or Item 11-A otherwise does not adequately summarize the type of resolution, provide an explanation.  For example, if you appealed all or part of a resolution by the regulator or court, indicate what is being appealed.</em></p>



<p>
<!-- 
                 <textarea name="textarea25" id="textarea25" cols="64" rows="6" readonly="1">
  
      <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:explanation)" />      
  </textarea>
  -->
    <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:explanation)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>

<p><b>C.    <em>Order:</em> </b> If <em>Order</em> is checked above in Item 11-A, does the <em>order</em> constitute a final <em>order</em> based on violations of any laws or regulations that prohibit fraudulent, or deceptive conduct?     
    <xsl:choose>
                        <xsl:when
                                test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder='Y'">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" /> Yes   <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:when>
                                <xsl:when
                                test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:types/ns3:isFinalOrder='N'">

                                    <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes     <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" /> No
                            </xsl:when>
                            <xsl:otherwise>
                            <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes     <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:otherwise>
                        </xsl:choose>
</p>


<p><b>12.  Resolution Date </b>(MM/DD/YYYY):    
     <input
                    type="text"
                    name="resolutionInformationDate"
                    readonly="1">
                    <xsl:attribute
                        name="value">
                <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:date) " />
                </xsl:attribute>
                </input>  
            
                
                    <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact     
                           <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation 
                            <p>         <em>(For a resolution that is being appealed in part, the date to be provided should be the date on which the regulator or court provided its resolution.)</em>   </p>  
                        <p>If not exact, provide explanation:   </p>
<p>
<!-- 
  <textarea name="resolutionDateprovideExplanation" cols="64" rows="6" readonly="1">
      <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:explanationInfo/n2:provideExplanation)" />    
  
  </textarea>
  -->
  <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:date/n2:explanationInfo/n2:provideExplanation)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
                
 </p>



</p>



<b>13.  Resolution Detail  </b>


<p><b>A. Sanction(s): Was/were any Sanction(s) <em>Ordered</em> or Relief Granted? </b>

                    <xsl:choose>
                        <xsl:when
                                test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'Y'">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Yes 
 
<xsl:choose>
                        <xsl:when
                                test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionsOrdered = 'N'">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>
 No, none were <em>ordered</em>, or granted.      

</p>



<p><b>B.   If “Yes,” check each individual sanction <em>ordered</em> and/or relief granted below:      </b>   


<p>

<div class="tableStyle" style="margin-left:0; margin-right:0;">

<div class="tableRow">
    <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='BarPermanent'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Bar (Permanent)</div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Exemption'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exemption</div>
                        
                            <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Rescission'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Rescission</div>
    
                        </div>
    <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='BarTemporary'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Bar (Temporary / Time Limited)  </div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Expulsion'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Expulsion</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Restitution'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Restitution*   </div>
                        
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Cease and Desist'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Cease and Desist</div>
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Injunction'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose> Injunction</div>
                        
                            <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Restraining Order'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Restraining <em>Order</em></div>
        
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Censure'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Censure </div>
                        
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Money Damage(s) (Private/Civil Complaint)'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Money Damage(s) (Private/Civil Complaint)*</div>
                        
                        <div class="tdStyle1">
                        
                        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Requalification'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Requalification 
 </div>
 
    
    </div>
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='CivilAdminPenaltyFine'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Civil and Administrative Penalty(ies)/Monetary Fine(s)*</div>
                        
                            <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Prohibition'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Prohibition</div>
    <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Revocation'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Revocation</div>
        
    </div>
    
    
        <div class="tableRow">
        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Denial'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Denial</div>
                        <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Reprimand'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Reprimand</div>
                            <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Suspension'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Suspension</div>
        
            </div><div class="tableRow">
                
            <div class="tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Disgorgement'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Disgorgement*</div>
        <div class="tdStyle1"> </div>
        
        <div class="tdStyle1"> <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Undertaking'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Undertaking</div>
    </div>
    
        
</div>



</p>


 </p>
<!-- Starting -->
<p><b>&#8226; Monetary Sanction(s):
</b>  Were one or more sanctions ordered that require a monetary payment?  
<xsl:choose>
    <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered) &gt; 0">
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes 
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
    </xsl:when>
    <xsl:otherwise>
        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes 
        <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
    </xsl:otherwise>
</xsl:choose>

<p>                         If &quot;Yes,&quot; enter the total amount ordered: 
    <xsl:call-template name="format_to_dollar">
    	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered" />
    </xsl:call-template>
 </p>
 </p>



<p> 

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Other'])&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>
<b>Other Sanctions <em>Ordered</em> or Relief Granted: (list each such additional sanction or relief)</b></p>

<p>
<xsl:choose>
    <xsl:when
        test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions[n2:sanctionRelief='Other'])&gt; 0">
    <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctions/n2:other)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div>
  </xsl:when>
  <xsl:otherwise>
    <textarea name="otherSanctions" id="otherSanctions" cols="64" rows="6" readonly="1"></textarea>
  </xsl:otherwise>
  </xsl:choose>
</p>

<p><br/>
</p>
<p><b>C.    Sanction Detail</b> (Provide the details of the following specific sanctions, if checked above in Item 13-B.)

<p> <b>(1)  Barred, <em>Enjoined</em>, or Suspended. </b> 
If you checked one or more of these sanctions in Item 13-B. above, check the
applicable box(es) below and provide the corresponding information.  </p>

<p>        <b>(a)  Barred</b>   </p>
<p>               (i)   Duration (length of time):<br/><br/>

                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Permanent (not limited by length of time).  <br/><br/>
                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Temporary / Time Limited.  Specify the:  

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Days 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Months 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                                               <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Years 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>

</p>



<p>               (ii)  Start Date (MM/DD/YYYY):   

<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation <br/><br/>

                     If not exact, provide explanation:
                    <br />
                    <!--                  
                    <textarea name="textarea22" id="textarea22" cols="64" rows="6"
                        readonly="1">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:barred/n2:startDate/n2:explanationInfo/n2:providExplanation)" />
                    </textarea>
                    -->
                    <div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:startDate/n2:explanationInfo/n2:providExplanation)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>
</p>



<p>               (iii) End Date   (MM/DD/YYYY):   

<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/n2:endDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation <br/><br/>

                     If not exact, provide explanation:
                        <br />
                        <!--                  
                        <textarea name="barredEndDateExplantaion" cols="64" rows="6"
                            readonly="1">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:barred/n2:endDate/n2:explanationInfo/n2:providExplanation)" />
                        </textarea>
                        -->
                        <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:endDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>


<p>               (iv) Description:  Provide remaining details and the registration capacities affected <br/>
                                   (General Securities Principal, Financial Operations Principal, etc.).  If none, enter “None”:
</p>
    <!--   
                <textarea name="barreddescription" cols="64" rows="6"
                    readonly="1">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:barred/n2:description)" />
                </textarea>
                -->
                <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:barred/ns3:description)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>

<br/>

<p class="mabox">
    <b>
        If the applicant or an associated person received in the above action one or more bars<br/>
        from registration capacities, associations, and/or other activities; and the terms specify<br/>
        different time periods; report the additional details below: 
    </b>
</p>

<p>        <b>(b)  <em>Enjoined</em></b>      </p>
<p>               (i)   Duration (length of time):<br/><br/>

                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Permanent (not limited by length of time).  <br/><br/>
                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Temporary / Time Limited.  Specify the:  

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Days 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Months 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                                               <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Years 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>

</p>
</p>


<p>               (ii)  Start Date (MM/DD/YYYY):   

<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation <br/><br/>

                     If not exact, provide explanation:
                    <br />
                     <!--                 
                    <textarea name="textarea22" id="textarea22" cols="64" rows="6"
                        readonly="1">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:enjoined/n2:startDate/n2:explanationInfo/n2:providExplanation)" />
                    </textarea>
                    -->
                  <div class="fakeBox">
                        <xsl:value-of
                          select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:startDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>



<p>               (iii) End Date   (MM/DD/YYYY):   

<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation <br/><br/>

                     If not exact, provide explanation:
                    <br />
                    <!--                
                    <textarea name="enjoinedEndDateExplantaion" cols="64" rows="6"
                        readonly="1">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:enjoined/n2:endDate/n2:explanationInfo/n2:providExplanation)" />
                    </textarea>
                    -->
                    <div class="fakeBox">
                        <xsl:value-of
                          select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:endDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>


<p>               (iv) Description:  Provide remaining details and the registration capacities affected <br/>
                                   (General Securities Principal, Financial Operations Principal, etc.).  If none, enter “None”:<br/>
</p>

                 <!-- 
                   <textarea name="enjoineddescription"
                    cols="64" rows="6" readonly="1">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:enjoined/n2:description)" />
                </textarea>
                -->
                <div class="fakeBox">
                    <xsl:value-of
                        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:enjoined/ns3:description)" />
                    <span>
                        <xsl:text>&#160;</xsl:text>
                    </span>
                </div>

<p class="mabox">
<b>
    If the applicant or an <em>associated person</em> received in the above action one or more injunctions<br/>
    from registration capacities, associations, and/or other activities; and the terms specify<br/>
    different time periods; report the additional details below:
</b>
</p>

<p>        <b>(c)  Suspended</b>    </p>
<p>             If the applicant or an <em>associated person</em> in the above action one or more bars from registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry.</p>
<p>               (i)   Duration (length of time):<br/><br/>

                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:permanent)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Permanent (not limited by length of time).  <br/><br/>
                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Temporary / Time Limited.  Specify the:  

                        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Days 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Months 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                                               <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Years 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:duration/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>

</p>



<p>               (ii)  Start Date (MM/DD/YYYY):   

<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation <br/><br/>

                     If not exact, provide explanation:
                        <br />
                        <!--                  
                        <textarea name="textarea22" cols="64" rows="6" readonly="1">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:suspended/n2:startDate/n2:explanationInfo/n2:providExplanation)" />
                        </textarea>
                        -->
                        <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:startDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>



<p>               (iii) End Date   (MM/DD/YYYY):   

<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:date)" />
</xsl:attribute>
</input>

  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:exact)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Exact        <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Explanation <br/><br/>

                     If not exact, provide explanation:
                        <br />
                        <!--                  
                        <textarea name="suspendedEndDateExplantaion" cols="64" rows="6"
                            readonly="1">
                            <xsl:value-of
                                select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:suspended/n2:endDate/n2:explanationInfo/n2:providExplanation)" />
                        </textarea>
                    -->
                    <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:endDate/n2:explanationInfo/n2:providExplanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div>
</p>


<p>               (iv) Description:  Provide remaining details and the registration capacities affected <br/>
                                   (General Securities Principal, Financial Operations Principal, etc.).  If none, enter “None”:
</p>

    <!--                      
    <textarea name="suspendeddescription" cols="64" rows="6"
        readonly="1">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:suspended/n2:description)" />
    </textarea>
    -->
   <div class="fakeBox">
                        <xsl:value-of
                           select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:suspended/ns3:description)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div> 

<p class="mabox">
    <b>
        If the applicant or an <em>associated person</em> received in the above action one or more suspensions<br/>
        from registration capacities, associations, and/or other activities; and the terms specify<br/>
        different time periods; report the additional details below:
    </b>
</p>

<!-- <p><b>(2)   Requalification:</b>    -->
<p><b>(2)   Requalification:</b>   
<br></br><br></br>
            Was requalification by examination, retraining, or other process a condition of a sanction? 

<br></br><br></br>                                                   <xsl:choose>
                        <xsl:when
                                test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'Y'">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Yes
      <xsl:choose>
                        <xsl:when
                                test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:isReqaulificationRequired = 'N'">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>No
<br></br><br></br>
           If the applicant or an <em>associated person</em> received in the above action one or more requalifications in connection with registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry. 		   

  </p>



<p>If &quot;Yes,&quot; provide: </p>

<p>  (a)    Length of time given to requalify, retrain, or complete other process:<br/>

                   <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:permanent)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>No time period is specified.     <br/><br/>
                  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Time period is specified:    

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Days 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:days)" />
</xsl:attribute>
</input>

<xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Months 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:months)" />
</xsl:attribute>
</input>
<br/>
                                                                       <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>Years 
                        <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:timeToReqaulifyRetrain/n2:durationType/n2:limited/n2:durationTime/n2:years)" />
</xsl:attribute>
</input>



 </p>



<p>(b)  Type of examination, retraining, or other process required:   <br/><br/>
<!-- 
<textarea name="textarea19" cols="64" rows="6" readonly="1">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:requalificationDetails/n2:typeRequired)" />
</textarea>
-->
     <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:typeRequired)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>



<p> (c)  Was the condition satisfied?     
    <xsl:choose>
        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied) &gt; 0">
            <img src="Images/radio-checked.jpg" alt="radio button checked" />Yes 
            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
        </xsl:when>
        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied) &gt; 0">
            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes 
            <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
        </xsl:when>
        <xsl:otherwise>
            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes 
            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />No
        </xsl:otherwise>
    </xsl:choose>
                        <p>             (1)   If &quot;Yes,&quot; provide the date (MM/DD/YYYY):  <input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:satisfied)" />
</xsl:attribute>
</input>
                        </p>
                        <p>             (2)   If &quot;No,&quot; explain the circumstances:   </p>

<p>
<!-- 
               <textarea name="textarea18" id="textarea18"
                cols="64" rows="6" readonly="1">
            
                <xsl:value-of
                    select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:requalificationDetails/n2:conditionState/n2:notSatisfied/n2:explanation)" />
            </textarea>
 -->
     <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:requalificationDetails/ns3:conditionState/ns3:notSatisfied)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>

                        
      </p>

<p class="mabox">
    <b>
        If the applicant or an <em>associated person</em> received in the above action one or more<br/>
        requalifications from registration capacities, associations, and/or other activities;<br/>
        and the terms specify different time periods; use the drop down box to report the additional details.
    </b>
</p>

<p><b>(3)   Monetary Sanction(s): </b> If you indicated in Item 13.B above that one or more monetary sanctions were ordered, provide the following information.</p>

<p> (a) Total Amount Ordered:  $<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
<xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)" />
</xsl:attribute>
</input> </p>

<p> (b) Portion levied against:  </p>
            <xsl:choose>
                <xsl:when test="count(ns3:headerData/ns3:baseHeader/ns3:drpFor/n2:applicant)&gt; 0">
                    <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
                </xsl:when>
                <xsl:otherwise>
                    <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
                </xsl:otherwise>
            </xsl:choose> 
            <b>Applicant</b>
                <p>    
                    (i) Amount Ordered:                   $
                    <input type="text" name="text49" readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered)" />
                        </xsl:attribute>
                    </input>
                </p>
                <p>    
                    (ii) Was any portion waived?  
                    <xsl:choose>
                        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                        </xsl:when>
                        <xsl:otherwise>
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                            <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
                        </xsl:otherwise>
                    </xsl:choose><br/>    
                    If “Yes,” how much?      $
                    <input type="text" name="text49" readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:waivedPortion)" />
                        </xsl:attribute>
                    </input>
                </p>
                <p>    
                    (iii) Final Amount:                         $
                    <input type="text" name="text49" readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:finalAmount)" />
                        </xsl:attribute>
                    </input>
                </p>
                <p>    
                    (iv) Was final amount paid in full?    
                    <xsl:choose>
                        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:satisfied/n2:satisfied) &gt; 0">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                        </xsl:when>
                        <xsl:otherwise>
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                        </xsl:otherwise>
                    </xsl:choose>
                </p>
                <p>    
                    If &quot;Yes,&quot; date paid in full (MM/DD/YYYY)
                    <input type="text" name="text49" readonly="1">
                        <xsl:attribute name="value">
                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:satisfied/n2:satisfiedDate)" />
                        </xsl:attribute>
                    </input>
                </p>
                <p>    
                    If &quot;No,&quot; explain the circumstances:
                    <p>
                    <!-- 
                        <textarea name="textarea17" cols="64" rows="6" readonly="1">
                            <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:notSatisfied/n2:explanation)" />
                        </textarea>
                    -->
                    <div class="fakeBox">
                        <xsl:value-of
                            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:initiatedDRP/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/n2:monetarySanctions/n2:paymentState/n2:notSatisfied/n2:explanation)" />
                        <span>
                            <xsl:text>&#160;</xsl:text>
                        </span>
                    </div> 
                    </p>
                </p>

<xsl:choose>
    <xsl:when
        test="ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:totalAmountOrdered &gt; 0 ">
            <img src="Images/box-checked.jpg"  alt="checkbox checked"/>
    </xsl:when>
    <xsl:otherwise>
            <img src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
    </xsl:otherwise>
</xsl:choose> <b><em>Associated Person</em></b>


<p>  (i) Amount Ordered:                   

	<xsl:call-template name="format_to_dollar">
    	<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:amountOrdered" />
    </xsl:call-template>
      
</p>

<p>  (ii) Was any portion waived?  <xsl:choose>
                        <xsl:when
                                test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) &gt; 0">

                                    <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />Yes <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes <img
                                    src="Images/radio-checked.jpg" alt="radio button checked" />No
                            </xsl:otherwise>
                        </xsl:choose>            


If “Yes,” how much?      
	<xsl:choose>
         <xsl:when
            test="number(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion) = number(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion)">
           
      <xsl:call-template name="format_to_dollar">
    		<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:waivedPortion" />
      </xsl:call-template>
         </xsl:when>
        <xsl:otherwise>
                <input     type="text"     name="court type"   readonly="1"></input>
         </xsl:otherwise>
   
    </xsl:choose>
	</p>
 
<p>  (iii) Final Amount:                         

	<xsl:call-template name="format_to_dollar">
		<xsl:with-param name="money" select="./ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:finalAmount" />
    </xsl:call-template>
</p>

<p>  (iv) Was final amount paid in full?    
                    <xsl:choose>
                        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied) &gt; 0">
                            <img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                        </xsl:when>
                        <xsl:when test="count(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied) &gt; 0">
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                            <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
                        </xsl:when>
                        <xsl:otherwise>
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> Yes
                            <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
                        </xsl:otherwise>
                    </xsl:choose>
</p>

<p>      If &quot;Yes,&quot; date paid in full (MM/DD/YYYY):
<input
    type="text"
    name="text49"
    readonly="1">
    <xsl:attribute
        name="value">
    <xsl:value-of
        select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:satisfied)" />
    </xsl:attribute>
</input>
</p>
<p>     If &quot;No,&quot; explain the circumstances:

<p>
<div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:resolutionInformation/ns3:details/ns3:sanctionDetails/ns3:monetarySanctions/ns3:paymentState/ns3:notSatisfied)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>

</p>

<p>
<b>Provide the information for each additional <em>associated person</em> below:</b><br/>
<div class="fakeBox">
        <xsl:value-of
            select="string(ns3:header/ns3:baseInformation/ns3:drpRemovalInformation/ns3:isFiledError/ns3:explainTheCircumstances)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>

<p><b>14.  Summary of Circumstances:</b> 
Use this space to provide a brief summary of the circumstances 
leading to the action, allegation(s), finding(s) and disposition(s), 
if any.  Include any relevant information on the current action 
status, and on any terms, conditions, and dates not already provided 
above, and any other relevant information.  The information must fit 
within the space provided.
</p>

<p>
<!--    <textarea  cols="64" rows="6" readonly="1">
        <xsl:value-of select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:summary)" />
    </textarea>
-->
 <div class="fakeBox">
        <xsl:value-of
            select="string(ns3:drpInfo/ns3:detailedDisclosure/ns3:baseInformation/n2:summary)" />
        <span>
            <xsl:text>&#160;</xsl:text>
        </span>
    </div> 
</p>
</xsl:for-each>


</div>
</div>
</xsl:for-each>
</div>
</div>
 
</div>
</xsl:template>
 </xsl:stylesheet>