<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:ns3="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:ns4="http://www.sec.gov/edgar/mai_drp"
	xmlns:n2="http://www.sec.gov/edgar/maifiler">


	<!-- Regulator Action Closure templates -->

	<xsl:template
		name="RegActDisDrp"><link
			href="style.css"
			rel="stylesheet"
			type="text/css" />

		
		<div
			id="maiDRPreg">
			<div
				class="content">
				<xsl:for-each
					select="n2:drpInfo/ns4:regulatoryDisclosure/ns4:regulatoryDrp">

					<h1>REGULATORY ACTION DISCLOSURE REPORTING PAGE (MA-I)</h1>
					<h1>REGULATORY ACTION DRP - PART 1</h1>
					<p>
                       This <strong>Disclosure Reporting Page (DRP MA-I)</strong>
                        is an
                                    <span class="label">
                                        <xsl:choose>
                                            <xsl:when
                                                test="count(ns4:baseHeader/ns4:reponseType/m1:add)&gt; 0">
                                                <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <b>
                                            INITIAL </b>
                                            <em>OR</em>
                                       
                                        <xsl:choose>
                                            <xsl:when
                                                test="count(ns4:baseHeader/ns4:reponseType/m1:amend) &gt; 0">
                                                <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <b>AMENDED</b>
                                    </span>
                                    response to report details for affirmative response(s) to
                        <strong>
                            <em>Question(s) 6C, 6D, 6E, 6F and 6G(1)</em>
                        </strong> on Form MA-I.
                      </p>
					<p>Check the question(s) to which this DRP pertains:</p>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									 
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(1)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked"  />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(1)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									 
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(1)(a)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(1)(a)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(1)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(1)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6F'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6F
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6G(1)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6G(1)
								</strong>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(2)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(2)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(1)(b)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(1)(b)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(2)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(2)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(3)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(3)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(1)(c)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(1)(c)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(3)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(3)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(4)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(4)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(1)(d)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(1)(d)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(4)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(4)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(5)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(5)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(1)(e)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(1)(e)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(5)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(5)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(6)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(6)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(2)(a)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(2)(a)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(6)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(6)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(7)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(7)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6D(2)(b)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6D(2)(b)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6E(7)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6E(7)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdFiveCol">
								<strong>
									<xsl:choose>
										<xsl:when
											test="ns4:regulatoryQuestions='6C(8)'">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									6C(8)
								</strong>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
							<div class="tdStyle1 tdFiveCol">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
					</div>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">Is this DRP an amendment that
								seeks to remove a previously filed DRP concerning the individual
								from
								the record?</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'Y'">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO
									</xsl:when>
									<xsl:when
										test="ns4:baseHeader/ns4:drpRemovalInfo/ns4:isDrpRemovable = 'N'">

										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										YES
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										NO
									</xsl:when>
									<xsl:otherwise>
                                        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
                                    </xsl:otherwise>
								</xsl:choose>
							</div>
						</div>
						<div style="clear:both"></div>

						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								If &quot;Yes,&quot; the reason the DRP should be removed
								is:</div>
							<div class="tdStyle1 tdTwoCol2">
								<p>
									<label>
										<xsl:choose>
											<xsl:when
												test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isRegistered) &gt; 0">
												<img
													src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
									</label>
									The event or
									<em>proceeding</em>
									was resolved in the individual's favor
									<br />
									<xsl:choose>
										<xsl:when
											test="count(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError) &gt; 0">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									The DRP was filed in error.
								</p>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
                            <div class="tdStyle1"><br />
                                  Explain the circumstances:<br></br>
                                                              <textarea name="textarea4" id="textarea4" cols="52" rows="5">
                                    
                                    <xsl:value-of
                                            select="string(ns4:baseHeader/ns4:drpRemovalInfo/ns4:drpRemoveReason/ns4:isFiledError/m1:explainTheCircumstances)" />
                                    
                                  </textarea></div>
                          </div>
					</div>
					<p>
						<strong>
							<u>How to Report an Event or <em>Proceeding</em> on a Regulatory Action
								DRP</u>
							: 
						</strong>
						Use a separate DRP for each event or
						<em>proceeding</em>
						. One event may result in more than one affirmative answer to the
						above items. If an event gives rise to actions by more than one
						regulator, provide details for each action on a separate DRP.
					</p>
					
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div>
							 <div class="tdStyle1 tditem10col1">
								<strong>
									<u>DRP On File for This Event</u>
									:
								</strong>
								Is an accurate and up-to-date DRP containing the information regarding the individual required by this DRP already on file  (a)
								in the
								<em>IARD</em>
								or
								<em>CRD</em>
								system (with a Form ADV, BD, or U4), or (b) in the
								<em>SEC's</em>
								EDGAR system (with a Form MA or Form MA-I)?
							</div> 
							<div class="tdStyle1 tditem10col2">
								<label>
									<xsl:choose>
										<xsl:when
											test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									<strong>Yes</strong>
								</label>
								<xsl:text>&#160;</xsl:text>
								<label>
									<xsl:choose>
										<xsl:when
											test="count(ns4:drpData/ns4:initiatedBy/m1:initiator) &gt; 0">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									<strong>No</strong>
								</label>
							</div>
						</div>
						<div style="clear:both"></div>
					</div>
					<p>
						<em>Note: The filer may identify a DRP filed by the
							individual
							directly, or filed by another SEC registrant about the
							individual
							as an associated person.</em>
					</p>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
					 
             <div class="tableRow">
             <div class="tdStyle1">
             <xsl:choose>
                            <xsl:when
                                test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling)  &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling) &gt; 0 or count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling) &gt; 0">
                                            Provide the applicable information indicated below that identifies where the DRP may be found.
 
                               </xsl:when>
                                  <xsl:otherwise>
                                    
                                   </xsl:otherwise>
             </xsl:choose>
             </div>
             </div> 
			 <div class="tableRow">
              <div class="checkbox tdStyle1">
			  <xsl:choose>
                        <xsl:when
                                test="count(ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling) &gt; 0 ">
                                        
                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                    <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   
                <label> 1. Form ADV, BD, or U4 Filing</label></div>
            </div>
            <div class="tableRow">
             
              <div class="checkbox tdStyle1"><xsl:choose>
                        <xsl:when
                                test=" count(ns4:baseHeader/ns4:filingInfo/ns4:maFiling)&gt; 0 ">
                                        
                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                    
                            </xsl:otherwise>
                        </xsl:choose>   
                <label> 2. Form MA Filing</label></div>
            </div>
            <div class="tableRow">
              
              <div class="checkbox tdStyle1"><xsl:choose>
                        <xsl:when
                                test="count(ns4:baseHeader/ns4:filingInfo/ns4:maiFiling)&gt; 0">

                                    <img
                                    src="Images/box-checked.jpg" alt="checkbox checked" />
                            </xsl:when>
                            <xsl:otherwise>
                        
                                <img
                                    src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                            </xsl:otherwise>
                        </xsl:choose>   
                <label> 3. Form MA-I  Filing</label></div>
            </div>
           
						<div class="tableRow">
							<div class="tdStyle1">
								<strong>1. Form ADV, BD, or U4 Filing:</strong>
								For a DRP filed on the
								<em>IARD</em>
								or
								<em>CRD</em>
								system with one of these forms, provide the following
								information:
							</div>
							<div>
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Name on Registration:</p>
							</div>
							 <div class="tdStyle1 tdTwoCol2Textbox">
							     
									<xsl:value-of
										  select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:filingName" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p><em>CRD</em> No.:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
                
                                    <xsl:value-of
                                        select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:crdNumber" />
                            </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Disclosure Occurrence No:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">

                                    <xsl:value-of
                                        select="ns4:baseHeader/ns4:filingInfo/ns4:formADVBDFiling/ns4:disclosureNumber" />
                            </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1">
								<strong>2. Form MA Filing: </strong>
								For a DRP filed on EDGAR with a Form MA, provide the following
								information:
							</div>
							<div>
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Name on Registration:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
						
                                    <xsl:value-of
                                          select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingName" />
       
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>MA Registration Number:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
						   

                                    <xsl:value-of
                                        select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:registrationNumber" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
							</div>
							<div>
								<input
									name="input9"
									type="text" readonly="1"
									value="mm/dd/yyyy"
									class="dateField">
									<xsl:attribute
										name="value">
				                 <xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:filingDate" />
				               </xsl:attribute>
								</input>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Accession number of the filing: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
							
				                 <xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maFiling/ns4:accessionNumber" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1">
								<strong>3. Form MA-I Filing:</strong>
								For a DRP filed on EDGAR with a Form MA-I, provide the following
								information:
							</div>
							<div>
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Name of Individual:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
                                    <xsl:value-of
                                          select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingName" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>MA-I File Number:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
                                    <xsl:value-of
                                       select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:registrationNumber" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Date of filing that contains the DRP (MM/DD/YYYY):</p>
							</div>
							<div>
							
				                 <input
                                    name="filingDate"
                                    type="text" readonly="1"
                                    value="mm/dd/yyyy"
                                    class="filingDate">
                                    <xsl:attribute
                                        name="value">
                                 <xsl:value-of
                                        select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:filingDate" />
                                 </xsl:attribute>
                                </input>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Accession number of the filing:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
				                 <xsl:value-of
										select="ns4:baseHeader/ns4:filingInfo/ns4:maiFiling/ns4:accessionNumber" />
				             
							</div>
						</div>
						<div style="clear:both"></div>
						
					</div>
					
					<p
						class="guidance">
						<strong>NOTE: The completion of all or any part of this form does not
						relieve
						the individual or any <em>municipal advisor</em> with which the individual is
						associated
						of the obligation to update any relevant Form MA or <em>IARD</em> or
						<em>CRD</em> records.</strong>
					</p>
					<h1>REGULATORY ACTION DRP - PART 2</h1>
					<p>
						<strong>1. Regulatory Action was initiated by:</strong>
					</p>
					<p>Other Federal Authority</p>

					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdTwoCol1">
								<strong>A. Select the Appropriate Item.</strong>
								<p>Select only one box below. A separate Regulatory Action
									DRP is required for each such regulator or other authority.</p>
							</div>
							<div class="tdTwoCol1">
								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
												<em>
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:sec">
															<img
																src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img
																src="Images/box-unchecked.jpg"  alt="checkbox unchecked"/>
														</xsl:otherwise>
													</xsl:choose>
													<em>SEC</em>
												</em>
										</div>
										<div class="tdStyle1 tdThreeCol">
												<em>
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:state">
															<img
																src="Images/box-checked.jpg"  alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img
																src="Images/box-unchecked.jpg" alt="checkbox unchecked"/>
														</xsl:otherwise>
													</xsl:choose>
												</em>
												State
										</div>
										<div class="tdStyle1 tdThreeCol">
												<em>
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:foreignFRA">
															<img
																src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img
																src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													<em>Foreign Financial Regulatory Authority</em>
												</em>
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:cftc">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>CFTC</em>
										</div>
										<div class="tdStyle1 tdThreeCol">
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:sro">
														<img
															src="Images/box-checked.jpg"  alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em> SRO</em>
										</div>
										<div class="tdStyle1 tdThreeCol">
											&#160;
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1">
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:federalBankingAgency">
														<img
															src="Images/box-checked.jpg"  alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"    alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												<em>Federal Banking Agency</em>  
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1">
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:nationalCUAdmin">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												National Credit Union Administration
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1">
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:initiatedBy/m1:initiator/m1:otherFederalAuthority">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other Federal Authority
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									<div class="tdStyle1">
									   <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:initiatedBy/m1:other">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Other:
                                                <br/>
                                                (specify)
                                                </div>
                                              </div>
											  <div style="clear:both"></div>
											  <br></br>
											<div class="value2" style="width:90%;">
                                               <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:initiatedBy/m1:other">
                                                    <div>
                                                    <xsl:value-of select="ns4:drpData/ns4:initiatedBy/m1:other" />
                                                        <span>
                                                            <xsl:text>&#160;</xsl:text>
                                                        </span>
                                                   </div> 
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                       
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </div>
								</div>
							</div>
							
						</div>
						<div style="clear:both"></div>
						</div>
						
						
						<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>B. Full name of the individual regulator (if not fully
									identified in Item 1</strong>
								-
								<strong>A.) or other authority that initiated the action.</strong>
								<p
									class="minutia">
									For a
									<em>foreign financial regulatory authority</em>, please provide the full name in English.
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
                                    <xsl:value-of
                                          select="ns4:drpData/ns4:initiatedBy/m1:name" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>2. Sanction(s) Sought </strong>
								<p
									class="minutia">(select all that apply):</p>
								<p
									class="minutia">
									<xsl:text>&#160;</xsl:text>
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
							<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='BarPermanent'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Permanent)
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Disgorgement'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>Disgorgement  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Restitution'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Restitution
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='BarTemporary'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Temporary/Time Limited)  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Expulsion'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Expulsion  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Requalification'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Requalification
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Cease and Desist'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"  alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Cease and Desist
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Injunction'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Injunction  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Revocation'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Revocation
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Censure'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Censure  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Prohibition'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prohibition  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Suspension'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Suspension  
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='CivilAdminPenaltyFine'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Civil and Administrative Penalty(ies)/Fine(s)  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Reprimand'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Reprimand  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Undertaking'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Undertaking
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:sactionsSought/ns4:saction='Denial'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Denial  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:sactionsSought/ns4:saction='Rescission'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Rescission
                                            
                                        </div>
                                        <div class="tdStyle1 tdThreeCol"><xsl:text>&#160;</xsl:text></div>
                                        </div>
										<div style="clear:both"></div>
                                        <div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											<p>
												<strong>
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:sactionsSought/ns4:saction='Other'">
															<img
																src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img
																src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													Other Sanction(s) Sought
												</strong>
												<p>
													(list each such additional sanction):</p>
												<!--    <br/> -->
													(specify)
											</p>
											
		                                </div>
		                                </div>
										<div style="clear:both"></div>
		                                <div class="tableRow">
		                                <div class="value2" style="width:90%;">
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:sactionsSought/ns4:saction='Other'">
	
												<div>
												<xsl:value-of select="ns4:drpData/ns4:sactionsSought/ns4:otherExplanation" />
													<span>
														<xsl:text>&#160;</xsl:text>
													</span>
											   </div> 
												</xsl:when>
												<xsl:otherwise>
													 
												</xsl:otherwise>
											</xsl:choose>
										</div>
									</div>
									<div style="clear:both"></div>
								</div>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>3. Date Initiated</strong>(MM/DD/YYYY): 
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<input
									name="input64"
									type="text" readonly="1"
									value="mm/dd/yyyy"
									class="dateField">
									<xsl:attribute
										name="value">
				                 					<xsl:value-of
										select="ns4:drpData/ns4:dateInitiated/m1:date" />
				               				</xsl:attribute>
								</input>

								<label>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:dateInitiated/m1:exact ">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Exact
								</label>
								<xsl:text>&#160;</xsl:text>
								<label>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:dateInitiated/m1:explanationInfo/m1:explanation">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Explanation
								</label>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">If not exact, provide explanation:</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
				                 					<xsl:value-of
										select="ns4:drpData/ns4:dateInitiated/m1:explanationInfo/m1:provideExplanation" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>4. Regulatory Action was brought in</strong>
								<p
									class="minutia">
									(<em>if brought in a foreign jurisdiction, provide all the
										information below in English</em>):
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>A. Name of the Administrative <em>Proceeding</em>, <em>Commission</em>/Agency Hearing, or Other Regulatory <em>Proceeding</em> or Forum:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
							
                                    <xsl:value-of
                                          select="ns4:drpData/ns4:regulatoryInfo/ns4:regulatoryBroughtInInformation/ns4:courtInfo/m1:name" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>B. Location of the <em>Proceeding</em>/Hearing:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Street Address: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:regulatoryBroughtInInformation/ns4:courtInfo/m1:address/ns1:street1" />
				               			 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>City or County: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:regulatoryBroughtInInformation/ns4:courtInfo/m1:address/ns1:city" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>State/Country: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
							
				            
			                 <span >
			                    <xsl:call-template name="stateDescription">
			                        <xsl:with-param name="stateCode" select="ns4:drpData/ns4:regulatoryInfo/ns4:regulatoryBroughtInInformation/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
			                     </xsl:call-template>
			                 </span>
			                 <span>
			                 <xsl:text>&#160;</xsl:text>
			                 </span>
             	 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Postal Code: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:regulatoryBroughtInInformation/ns4:courtInfo/m1:address/ns1:zipCode" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>C. Docket/Case Number:</strong>
								 
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:regulatoryBroughtInInformation/ns4:courtInfo/m1:docketOrCaseNo" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>5. Employing Firm:</strong>
								 
								<p>Provide the full legal name of the individual's employing firm, if any, when the
									activity occurred which led to the regulatory action (if there
									was no such employing firm at that time, enter
									&quot;None&quot;). Enter the employing firm's MA and
									<em>CRD</em> registration numbers, if any.
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>A. Employing Firm:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
                                    <xsl:value-of
                                         select="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:employingFirmInfo/ns4:name" />				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>B. <em>Municipal Advisor</em> Registration Number, if any:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:employingFirmInfo/ns4:registrationNumber" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>C. <em>CRD</em> Number, if any:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:employingFirmInfo/ns4:crdNumber" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>6. A. Principal Product Type</strong>
								<p>Check the appropriate item.</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='No Product'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												No Product
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											<xsl:text>&#160;</xsl:text>
										</div>
										<div class="tdStyle1 tdThreeCol">
											<xsl:text>&#160;</xsl:text>
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='AnnuityCharitable'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity-Charitable
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Direct Investment(s) - DPP &amp; LP Interest(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Direct Investment-DPP &amp; LP Interest
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='OilAndGas'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Oil &amp; Gas
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Annuity(ies) - Fixed'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity-Fixed  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='EquipmentLeasing'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equipment Leasing
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Options'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Options
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Annuity(ies) - Variable'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Annuity-Variable
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Equity Listed (Common &amp; Preferred Stock)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equity Listed (Common &amp; Preferred Stock)  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Penny Sock(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Penny Stock
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='BankingProduct'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Banking Product
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Equity - OTC'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Equity-OTC
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='PrimeBankInstrument'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prime Bank Instrument (other than CD)
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">

<div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='CD(s)'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                CD
                                            
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Futures - Commodity'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Futures-Commodity
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Promissory Note'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Promissory Note
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
								
										<div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Commodity Option(s)'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Commodity Option
                                            
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Futures - Financial'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Futures-Financial  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Real Estate Security'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Real Estate Security
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									
										<div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Asset Backed'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Debt-Asset Backed
                                            
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Index Option(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Index Option
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Security Futures'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Security Futures
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									
										  <div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Corporate'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Debt-Corporate  
                                            
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Insurance'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Insurance
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Security-based Swap'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Security-based Swap
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									
										<div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Government'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Debt-Government     
                                            
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Investment Contract(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Investment Contract
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Swap'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Swap
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									
										<div class="tdStyle1 tdThreeCol">
                                            
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Debt - Municipal'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Debt-Municipal  
                                            
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Money Market Fund(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Money Market Fund
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Unit Investment Trust(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Unit Investment Trust
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									
										<div class="tdStyle1 tdThreeCol">
                                                <xsl:choose>
                                                    <xsl:when
                                                        test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Derivative(s)'">
                                                        <img
                                                            src="Images/box-checked.jpg" alt="checkbox checked" />
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <img
                                                            src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                                Derivative
                                        </div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Mutual Fund(s)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Mutual Fund  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Viatical Settlement'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Viatical Settlement
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
									
										<div class="tdStyle1">
											<strong>
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Other'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other Principal Product Type:
											</strong>
										</div>	
									</div>
									<div style="clear:both"></div>									
											<div class="tableRow">(specify)<br />
											
                                           </div>
                                        <div class="tableRow">
											<div class="value2" style="width:90%; margin-left:0; margin-right:0;"> 
										
                                           <xsl:choose>
                                                    <xsl:when
                                                       test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:product='Other'">
                                                    <div>
                                                    <xsl:value-of select="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:principalProductTypes/ns4:productOther" />
                                                        <span>
                                                            <xsl:text>&#160;</xsl:text>
                                                        </span>
                                                   </div> 
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                         
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                           </div>
										</div>
									
								</div>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>B. Other Product Types?</strong> 
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<label>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:otherProductTypes">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									<strong>Yes</strong>
								</label>
								<xsl:text>&#160;</xsl:text>
								<label>
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:otherProductTypes">
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:otherwise>
									</xsl:choose>
									<strong>No</strong>
								</label>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">If &quot;Yes,&quot; describe each additional product type:</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
								   <xsl:value-of
								       select="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:otherProductTypes" />
								    </div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>7. Allegations:</strong>
								 Describe the allegations related to this regulatory action.
								(The response must fit within the space provided.)
								<br />
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
                                   <xsl:value-of
                                       select="ns4:drpData/ns4:regulatoryInfo/ns4:matterInformation/ns4:allegationsDescription" />
                                   </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>8. Current Status:</strong>
								 
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<label>
									<xsl:choose>
										<xsl:when
											test="ns4:baseHeader/ns4:status/ns3:pending">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Pending
								</label>
								<xsl:text>&#160;</xsl:text>
								<label>
									 
									<xsl:choose>
										<xsl:when
											test="ns4:baseHeader/ns4:status/ns3:onAppeal">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									On Appeal
								</label>
								<xsl:text>&#160;</xsl:text>
								<label>
									 
									<xsl:choose>
										<xsl:when
											test="ns4:baseHeader/ns4:status/ns3:final">
											<img
												src="Images/box-checked.jpg" alt="checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Final
								</label>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>9. Pending: If you checked &quot;Pending&quot; in Item
									8,
									provide the following information.</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>A. Date Served:</strong>
								<p>The date that notice or other process was served (MM/DD/YYYY):</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<p>
									<span
										class="label">
										<input
											name="input72"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
				                 					<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:servedInformation/m1:date" />
				               				</xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:servedInformation/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:servedInformation/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</p>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">If not exact, provide explanation:</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
								   <xsl:value-of
								        select="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:servedInformation/m1:explanationInfo" />
						      </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>B. Limitation or Restrictions: </strong>
								Are there any limitations or restrictions currently in effect?
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions='Y'">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO
									</xsl:when>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions='N'">

										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										YES
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										NO
									</xsl:when>
                                    <xsl:otherwise>
                                       <img
                                            src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                        <img
                                             src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
                                    </xsl:otherwise>
								</xsl:choose>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">If the answer is &quot;Yes,&quot; provide details:</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
									<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:pendingInformation/ns4:limitationsRestrictions/ns4:details" />
							</div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>10. On Appeal - Administrative or Judicial Review of the
									Regulatory Action: </strong>
								If you appealed, provide the following information.
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>A. Name of Regulator or Court Action Appealed To</strong>
								<p
									class="minutia">Provide the name of the US regulator (i.e., the <em>SEC</em>, an
									<em>SRO</em>, other), federal court, state court or state regulator, or
									a
									foreign or international court or regulator to whom the individual appealed. If brought in a foreign jurisdiction, provide all the
									information below in English.</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
							   <xsl:value-of
							        select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:name" />
							    </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>
									B. Location of the Regulator or Judicial Court to Whom
									the individual Appealed:
						</strong>
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Street Address: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:street1" />
				               				 
							</div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>City or County: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:city" />
				               			 
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>State/Country: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 							
							<span >
                                <xsl:call-template name="stateDescription">
                                    <xsl:with-param name="stateCode" select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:stateOrCountry" />
                                 </xsl:call-template>
                             </span>
                             <span>
                             <xsl:text>&#160;</xsl:text>
                             </span>
				               			 
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>Postal Code: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:address/ns1:zipCode" />
				               				 
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>C. Docket/Case Name: </strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:docketCaseName" />
				               				 
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>D. Docket/Case Number: </strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
				                 					<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:appealBroughtInInformation/ns4:courtInfo/m1:docketOrCaseNo" />
				               				 
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>E. Date Appeal filed (MM/DD/YYYY):</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<span
									class="label">
									<input
										name="input82"
										type="text" readonly="1"
										value="mm/dd/yyyy"
										class="dateField">
										<xsl:attribute
											name="value">
				                 					<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:dateInformation/m1:date" />
				               				</xsl:attribute>
									</input>

									<label>
										<xsl:choose>
											<xsl:when
												test="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:dateInformation/m1:exact">
												<img
													src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact
									</label>
									<xsl:text>&#160;</xsl:text>
									<label>
										<xsl:choose>
											<xsl:when
												test="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:dateInformation/m1:explanationInfo">
												<img
													src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation
									</label>
								</span>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">If not exact, provide explanation:</div>
							<div class="tdStyle1 tdTwoCol2Textbox">  
									<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:dateInformation/m1:explanationInfo" />
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<strong>F. Appeal Details (including status):</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">  
	                               <xsl:value-of
									       select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:details" />
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								G.
								<strong>Limitation or Restrictions</strong>
								<p>Are there any limitations or restrictions currently in
									effect while on appeal?</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions='Y'">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO
									</xsl:when>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:limitationsRestrictions/ns4:hasLimitationsOrRestrictions='N'">

										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										YES
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										NO
									</xsl:when>
									<xsl:otherwise>
                                       <img
                                            src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                        <img
                                             src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
                                    </xsl:otherwise>
								</xsl:choose>
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">If the answer is &quot;Yes,&quot; provide details:</div>
							<div class="tdStyle1 tdTwoCol2Textbox">  
							  <xsl:value-of
									 select="ns4:drpData/ns4:regulatoryInfo/ns4:appealInformation/ns4:limitationsRestrictions/ns4:details" />
						  </div>
						</div><div style="clear:both"></div>
					</div>
					<div
						class="guidance">
						If you checked &quot;Final&quot; or &quot;On Appeal&quot; in Item
						8, complete Items 11 through 13, and
						<br />
						consider Item 14. For actions that are &quot;Pending,&quot; skip
						to Item 14.
					</div>
					<div class="tableStyle" style="margin-left:0; margin-right:0;">
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>11. A. Resolution: </strong>
								How was the matter resolved?
								<p
									class="minutia"> Check all the applicable boxes that reflect the most
									recent resolution of the matter by a regulator or a court,
									whether or not any part of the resolution is on appeal. If any
									part of the resolution is on appeal, identify in Item 11-B
									which
									part is currently on appeal. </p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Acceptance Waiver &amp; Consent (AWC)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Acceptance Waiver &amp; Consent (AWC)
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Dismissed'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Dismissed
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Stipulation and Consent'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Stipulation and Consent
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Consent'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Consent   
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Judgement Rendered'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Judgment Rendered   
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Withdrawn'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Withdrawn
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Decision'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg"   alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Decision     
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<em>
													<xsl:choose>
														<xsl:when
															test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Order'">
															<img
																src="Images/box-checked.jpg" alt="checkbox checked" />
														</xsl:when>
														<xsl:otherwise>
															<img
																src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
														</xsl:otherwise>
													</xsl:choose>
													Order
												</em>
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Other (requires explanation)'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Other (requires explanation)
											
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Decision &amp; Order of Offer Settlement'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Decision &amp;
												<em>Order</em>
												of Offer of Settlement     
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Settled'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Settled
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											<xsl:text>&#160;</xsl:text>
										</div>
									</div>
									<div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:resolutionMatterInfo/ns4:type ='Appealed'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Appealed
											
											<div class="tableStyle" style="margin-left:0; margin-right:0;">
												<div class="tableRow">
													<div class="tdStyle1">
														  
															<xsl:choose>
																<xsl:when
																	test="ns4:drpData/ns4:resolutionMatterInfo/ns4:appealType ='Affirmed'">
																	<img
																		src="Images/box-checked.jpg" alt="checkbox checked" />
																</xsl:when>
																<xsl:otherwise>
																	<img
																		src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
																</xsl:otherwise>
															</xsl:choose>
														
														Affirmed
														
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
														<xsl:choose>
															<xsl:when
																test="ns4:drpData/ns4:resolutionMatterInfo/ns4:appealType ='Vacated Nunc Pro Tunc / ab initio'">
																<img
																	src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img
																	src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Vacated Nunc Pro Tunc/ab initio
											
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
													
														<xsl:choose>
															<xsl:when
																test="ns4:drpData/ns4:resolutionMatterInfo/ns4:appealType ='Vacated  &amp; Returned For Further Action'">
																<img
																	src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img
																	src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Vacated &amp; Returned For Further Action
														
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
													
														<xsl:choose>
															<xsl:when
																test="ns4:drpData/ns4:resolutionMatterInfo/ns4:appealType ='Vacated / Final'">
																<img
																	src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img
																	src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Vacated/Final
														
													</div>
												</div>
												<div class="tableRow">
													<div class="tdStyle1">
													
														<xsl:choose>
															<xsl:when
																test="ns4:drpData/ns4:resolutionMatterInfo/ns4:appealType ='Other (requires explanation)'">
																<img
																	src="Images/box-checked.jpg" alt="checkbox checked" />
															</xsl:when>
															<xsl:otherwise>
																<img
																	src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
															</xsl:otherwise>
														</xsl:choose>
														Other (requires explanation)
														
													</div>
												</div>
											</div>
										</div>
									</div>
									<div style="clear:both"></div>
								</div>
							</div>
						</div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>B. Explanation</strong>
								<p
									class="minutia">If more than one box in Item 11-A. is checked, or
									Other is checked, or Item 11-A. otherwise does not adequately
									summarize the type of resolution, provide an explanation. For
									example, if the individual appealed all or part of a resolution by the
									regulator or court, indicate what is being appealed.</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
                                <xsl:value-of
                                      select="ns4:drpData/ns4:resolutionMatterInfo/ns4:explanation" />
                            </div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>
									C.
									<em>Order:</em>
								</strong>
								<p><strong>
									If
									<em>Order</em>
									is checked above in Item 11-A.,</strong> does the
									<em>order</em>
									constitute a final
									<em>order</em>
									based on violations of any laws or regulations that prohibit
									fraudulent, or deceptive conduct?
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:resolutionMatterInfo/ns4:isFinalOrder='Y'">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO
									</xsl:when>
									<xsl:when
										test="ns4:drpData/ns4:resolutionMatterInfo/ns4:isFinalOrder='N'">

										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										YES
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										NO
									</xsl:when>
									<xsl:otherwise>
                                               <img
                                            src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                        <img
                                            src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
                                            </xsl:otherwise>
								</xsl:choose>
							</div>
						</div>
						<div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>12. Resolution Date</strong> (MM/DD/YYYY):
								<p
									class="minutia">(For a resolution that is being appealed in part, the date
									to be provided should be the date on which the regulator
									(reviewing a decision by an <em>SRO</em> or an Administrative Law Judge)
									or a court provided its resolution.)</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<span
									class="label">

									<input
										name="input75"
										type="text" readonly="1"
										value="mm/dd/yyyy"
										class="dateField">
										<xsl:attribute
											name="value">
								<xsl:value-of
											select="ns4:drpData/ns4:resolutionMatterInfo/ns4:resolutionDate/m1:date" />
		  									 </xsl:attribute>
									</input>


									<label>
										<xsl:choose>
											<xsl:when
												test="ns4:drpData/ns4:resolutionMatterInfo/ns4:resolutionDate/m1:exact">
												<img
													src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Exact
									</label>
									<xsl:text>&#160;</xsl:text>
									<label>
										<xsl:choose>
											<xsl:when
												test="ns4:drpData/ns4:resolutionMatterInfo/ns4:resolutionDate/m1:explanationInfo">
												<img
													src="Images/radio-checked.jpg" alt="radio button checked" />
											</xsl:when>
											<xsl:otherwise>
												<img
													src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
											</xsl:otherwise>
										</xsl:choose>
										Explanation
									</label>
								</span>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">If not exact, provide explanation:</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
                                    <xsl:value-of
                                               select="ns4:drpData/ns4:resolutionMatterInfo/ns4:resolutionDate/m1:explanationInfo" />
                             </div>
						</div>
						<div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>13. Resolution Detail:</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>
									A. Sanction(s): Was / were any Sanction(s)
									<em>Ordered</em>
									?
								</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction) &gt; 0">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction) &gt; 0">
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:otherwise>
								</xsl:choose>
								No, none were
								<em>ordered</em>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>B.
									If &quot;Yes,&quot; check each individual sanction below that
									was
									<em>ordered</em>
									:  
								</strong>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<div class="tableStyle" style="margin-left:0; margin-right:0;">
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='BarPermanent'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>

												Bar (Permanent)
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Disgorgement'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Disgorgement*
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Restitution'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Restitution*
											
										</div>
									</div><div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='BarTemporary'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Bar (Temporary/Time Limited)  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Expulsion'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Expulsion  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Requalification'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Requalification
											
										</div>
									</div><div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Cease and Desist'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Cease and Desist  
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												 
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Injunction'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Injunction
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Revocation'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Revocation
											
										</div>
									</div><div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Censure'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Censure
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Prohibition'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Prohibition
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Suspension'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Suspension
											
										</div>
									</div><div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='CivilAdminPenaltyFine'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Civil and Administrative Penalty(ies)/Fine(s)*
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Reprimand'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Reprimand
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Undertaking'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Undertaking
											
										</div>
									</div><div style="clear:both"></div>
									<div class="tableRow">
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Denial'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Denial
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											
												<xsl:choose>
													<xsl:when
														test="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:saction='Rescission'">
														<img
															src="Images/box-checked.jpg" alt="checkbox checked" />
													</xsl:when>
													<xsl:otherwise>
														<img
															src="Images/box-unchecked.jpg" alt="checkbox unchecked" />
													</xsl:otherwise>
												</xsl:choose>
												Rescission
											
										</div>
										<div class="tdStyle1 tdThreeCol">
											<xsl:text>&#160;</xsl:text>
										</div>
									</div><div style="clear:both"></div>
								</div>
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>* Monetary Sanction(s)</strong>
								<p
									class="minutia">
									Were one or more sanctions
									<em>ordered</em>
									that required a monetary payment?
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<label>
									<xsl:choose>
										<xsl:when
											test="count(ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:amountOrdered) &gt; 0">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									YES
									<xsl:choose>
										<xsl:when
											test="count(ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:amountOrdered)&gt; 0">
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:otherwise>
									</xsl:choose>
									NO
								</label>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">If
								&quot;Yes,&quot; enter the total amount
								<em>ordered</em>
								:
							</div>
							<div class="tdStyle1 tdTwoCol2">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="./ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:amountOrdered" />
                            </xsl:call-template>
                            
							</div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1Label">
								<b>
									Other Sanction(s)
									<em>Ordered</em>
									(<em>list each such additional sanction</em>):
								</b>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
									<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:resolutionDetail/ns4:sactionsOrdered/ns4:otherExplanation" />
							</div>
						</div><div style="clear:both"></div>


						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>C. Sanction Detail (Provide the details of the following specific sanctions,
                                    if checked above in Item 13-B.)</strong>
                                    <br />
                                    <br />
								<strong>(1) Barred, <em>Enjoined</em>, or Suspended: </strong>
								<p class="minutia">
									<strong> </strong>
									If you selected one or more of these sanctions in Item 13-B.
									above, provide the
									corresponding information.
								</p>

								<p>
									<strong>(a) Barred</strong>
								</p>
								
								<p>
			                        If the individual in the above action one or more bars from registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry.
			                    </p>
								
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(i) Duration (length of time): </p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:permanent">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Permanent (not limited by length of time).
									<br />
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Temporary / Time Limited.
								</div>
							</div>
							<div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Specify the</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
                                </div>
                                </div><div style="clear:both"></div>
                                <div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
                                    <p>Days</p>
                                </div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input78"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
								<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime/m1:days" />
		  				 </xsl:attribute>
									</input>
									<xsl:text>&#160;</xsl:text>
									<xsl:text>&#160;</xsl:text>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Months</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input79"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
							<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime/m1:months" />
		  				 </xsl:attribute>
									</input>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Years</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input80"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
				<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:duration/ns4:durationType/ns4:durationTime/m1:years" />
		   </xsl:attribute>
									</input>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(ii) Start Date (MM/DD/YYYY):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<span
										class="label">
										<input
											name="input77"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
											<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:startDate/m1:date" />
		  								 </xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:startDate/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:startDate/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</div>
							</div><div style="clear:both"></div>
							
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(iii) End Date (MM/DD/YYYY):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<span
										class="label">
										<input
											name="input81"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
											<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:endDate/m1:date" />
		  								 </xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:endDate/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:endDate/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</div>
							</div>		<div style="clear:both"></div>					
							<div>
								<div class="tdStyle1 tdTwoCol1">
									<p>(iv) Description: Provide remaining details, including any
										explanation boxes checked above, and the registration
										capacities
										affected (General Securities Principal, Financial
										Operations
										Principal, etc.):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2Textbox">
								     <xsl:value-of
                                                select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:barred/ns4:description" />
                                </div>
							</div><div style="clear:both"></div>
							
							<div>
								<div class="tdStyle1 tdTwoCol1">
									<strong>(b) <em>Enjoined</em></strong>
									                    <p>
                        If the individual received in the above action one or more injunctions from registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry.
                    </p>
									
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<xsl:text>&#160;</xsl:text>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(i) Duration (length of time): </p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:permanent">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Permanent (not limited by length of time).
									<br />
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Temporary / Time Limited.
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
                                <div class="tdStyle1 tdTwoCol1">
                                    <p>Specify the</p>
                                </div>
                                <div class="tdStyle1 tdTwoCol2">
                                <xsl:text>&#160;</xsl:text>
                                </div>
                                </div><div style="clear:both"></div>
							    <div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Days</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input78"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
								<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime/m1:days" />
		  				 </xsl:attribute>
									</input>
									<xsl:text>&#160;</xsl:text>
									<xsl:text>&#160;</xsl:text>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Months</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input79"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
							<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime/m1:months" />
		  				 </xsl:attribute>
									</input>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Years</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input80"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
				<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:duration/ns4:durationType/ns4:durationTime/m1:years" />
		   </xsl:attribute>
									</input>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(ii) Start Date (MM/DD/YYYY):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<span
										class="label">
										<input
											name="input77"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
											<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:startDate/m1:date" />
		  								 </xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:startDate/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:startDate/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</div>
							</div><div style="clear:both"></div>
							
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(iii) End Date (MM/DD/YYYY):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<span
										class="label">
										<input
											name="input81"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
											<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:endDate/m1:date" />
		  								 </xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:endDate/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:endDate/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</div>
							</div><div style="clear:both"></div>
							
							<div>
								<div class="tdStyle1 tdTwoCol1">
									<p>(iv) Description: Provide remaining details, including any
										explanation boxes checked above, and the registration
										capacities
										affected (General Securities Principal, Financial
										Operations
										Principal, etc.):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2Textbox"> 
                                        <xsl:value-of
                                              select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:enjoined/ns4:description" />
								</div>
							</div><div style="clear:both"></div>
							
							<div>
								<div class="tdStyle1 tdTwoCol1">
									<strong>(c) Suspended</strong>
									                    <p>
                        If the individual received in the above action one or more suspensions from registration capacities, associations, and/or other activities, and the terms specify different time periods, report each in a separate entry.
                    </p>
									
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<xsl:text>&#160;</xsl:text>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(i) Duration (length of time): </p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:permanent">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Permanent (not limited by length of time).
									<br />
									<xsl:choose>
										<xsl:when
											test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime">
											<img
												src="Images/radio-checked.jpg" alt="radio button checked" />
										</xsl:when>
										<xsl:otherwise>
											<img
												src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										</xsl:otherwise>
									</xsl:choose>
									Temporary / Time Limited.
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
                                <div class="tdStyle1 tdTwoCol1">
                                    <p>Specify the</p>
                                </div>
                                <div class="tdStyle1 tdTwoCol2">
                                <xsl:text>&#160;</xsl:text>
                                </div>
                             </div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Days</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input78"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
								<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime/m1:days" />
		  				 </xsl:attribute>
									</input>
									<xsl:text>&#160;</xsl:text>
									<xsl:text>&#160;</xsl:text>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Months</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input79"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
							<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime/m1:months" />
		  				 </xsl:attribute>
									</input>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>Years</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<input
										name="input80"
										type="text"
										readonly="1">
										<xsl:attribute
											name="value">
				<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:duration/ns4:durationType/ns4:durationTime/m1:years" />
		   </xsl:attribute>
									</input>
								</div>
							</div><div style="clear:both"></div>
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(ii) Start Date (MM/DD/YYYY):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<span
										class="label">
										<input
											name="input77"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
											<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:startDate/m1:date" />
		  								 </xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:startDate/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:startDate/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</div>
							</div><div style="clear:both"></div>
							
							<div class="tableRow">
								<div class="tdStyle1 tdTwoCol1">
									<p>(iii) End Date (MM/DD/YYYY):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2">
									<span
										class="label">
										<input
											name="input81"
											type="text" readonly="1"
											value="mm/dd/yyyy"
											class="dateField">
											<xsl:attribute
												name="value">
											<xsl:value-of
												select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:endDate/m1:date" />
		  								 </xsl:attribute>
										</input>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:endDate/m1:exact">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Exact
										</label>
										<xsl:text>&#160;</xsl:text>
										<label>
											<xsl:choose>
												<xsl:when
													test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:endDate/m1:explanationInfo">
													<img
														src="Images/radio-checked.jpg" alt="radio button checked" />
												</xsl:when>
												<xsl:otherwise>
													<img
														src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
												</xsl:otherwise>
											</xsl:choose>
											Explanation
										</label>
									</span>
								</div>
							</div><div style="clear:both"></div>
							
							<div>
								<div class="tdStyle1 tdTwoCol1">
									<p>(iv) Description: Provide remaining details, including any
										explanation boxes checked above, and the registration
										capacities
										affected (General Securities Principal, Financial
										Operations
										Principal, etc.):</p>
								</div>
								<div class="tdStyle1 tdTwoCol2Textbox"> 
			                         <xsl:value-of
                                             select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:suspended/ns4:description" />
								</div>
							</div><div style="clear:both"></div>
							

						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<strong>(2) Requalification:  </strong>
			       
                    </div></div><div style="clear:both"></div>
                    <div class="tableRow">
					<div class="tdStyle1 tdTwoCol1Label">
								Was requalification by examination, retraining, or other process
								a condition of a sanction?
								
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:isReqaulificationRequired='Y'">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO
									</xsl:when>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:isReqaulificationRequired='N'">

										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										YES
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										NO
									</xsl:when>
									<xsl:otherwise>
                                       <img
                                            src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                        <img
                                             src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
                                    </xsl:otherwise>
								</xsl:choose>
							</div>
						</div><div style="clear:both"></div>
						
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>
									<strong>(a) Length of time given to requalify, retrain, or
										complete other process:</strong>
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:noTimePeriodSpecified">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								No time period is specified.
								<br />
								<xsl:choose>
									<xsl:when
										test="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								Time period is specified:
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">Days</div>
							<div class="tdStyle1 tdTwoCol2"> 
								<input
									name="input24"
									type="text"
									readonly="1">
									<xsl:attribute
										name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime/m1:days" />
		   </xsl:attribute>
								</input>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>Months</p>
							</div>
							<div class="tdStyle1 tdTwoCol2"> 
								<input
									name="input25"
									type="text"
									readonly="1">
									<xsl:attribute
										name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime/m1:months" />
		   </xsl:attribute>
								</input>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>Years</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<input
									name="input60"
									type="text"
									readonly="1">
									<xsl:attribute
										name="value">
				<xsl:value-of
										select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:timeToReqaulifyRetrain/ns4:durationTime/m1:years" />
		   </xsl:attribute>
								</input>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>(b) Type of examination, retraining, or other process
									required:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
							     <xsl:value-of
                                              select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:typeRequired" />
                            </div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>(c) Was the condition satisfied?</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:satisfied/ns4:satisfied) &gt; 0">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										YES
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										NO
									</xsl:when>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:notSatisfied/ns4:satisfied) &gt; 0">

										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
										YES
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
										NO
									</xsl:when>
									
								</xsl:choose>

							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>If &quot;Yes,&quot; provide the date (MM/DD/YYYY): </p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<span
									class="label">
									<input
										name="input4"
										type="text" readonly="1"
										value="mm/dd/yyyy"
										class="dateField">
										<xsl:attribute
											name="value">
				<xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:satisfied/ns4:satisfiedDate" />
		   </xsl:attribute>
									</input>
								</span>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>If &quot;No,&quot; explain the circumstances:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
							<xsl:value-of
                                              select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:requalificationDetails/ns4:conditionState/ns4:notSatisfied/ns4:explanation" />
                             </div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>(3) Monetary Sanction(s): </strong>
								If you indicated in Item 13B above that one or more monetary
								sanctions were ordered, provide the following information.
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:text>&#160;</xsl:text>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>
									(a) Total Amount Ordered:
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:totalAmountOrdered" />
                             </xsl:call-template>
                             
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>
									(b) Portion levied against the individual:
									<strong></strong>
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2"> 
								<xsl:text>&#160;</xsl:text>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>
									(i) Amount
									<em>Ordered</em>
									:
								</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:amountOrdered" />
                             </xsl:call-template>
                             
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>(ii) Was any portion waived?</p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:waivedPortion) &gt; 0">
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								YES
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:waivedPortion) &gt; 0">
										<img
											src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:when>
									<xsl:otherwise>
										<img
											src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:otherwise>
								</xsl:choose>
								NO
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>If &quot;Yes,&quot; how much? </p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:waivedPortion" />
                             </xsl:call-template>
                             
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>(iii) Final Amount: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2"> 
							<xsl:call-template name="format_to_dollar">
                                <xsl:with-param name="money" select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:finalAmount" />
                             </xsl:call-template>
                             
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>(iv) Was final amount paid in full? </p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<xsl:choose>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:paidInFull/ns4:amountPaidInFull) &gt; 0">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
                                        YES
                                        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
											                             
									</xsl:when>
									<xsl:when
										test="count(ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:notPaidInFull/ns4:amountNotPaidInFull) &gt; 0">
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                         <img src="Images/radio-checked.jpg" alt="radio button checked" />
                                        NO
									</xsl:when>
									<xsl:otherwise>
                                        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        YES
                                        <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
                                        NO
                                    </xsl:otherwise>
								</xsl:choose>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1">
								<p>If &quot;Yes,&quot; date paid in full: </p>
							</div>
							<div class="tdStyle1 tdTwoCol2">
								<span
									class="label">
									<input
										name="input6"
										type="text" readonly="1"
										value="mm/dd/yyyy"
										class="dateField">
										<xsl:attribute
											name="value">
				                        <xsl:value-of
											select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:paidInFull/ns4:paidDate" />
		                                </xsl:attribute>
									</input>
								</span>
							</div>
						</div><div style="clear:both"></div>
						<div class="tableRow">
							<div class="tdStyle1 tdTwoCol1Label">
								<p>If &quot;No,&quot; explain the circumstances:</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox"> 
							    <xsl:value-of
                                              select="ns4:drpData/ns4:regulatoryInfo/ns4:sanctionDetails/ns4:monetarySanctions/ns4:paymentState/ns4:notPaidInFull/ns4:explanation" />
                               </div>
						</div><div style="clear:both"></div>
						<div>
							<div class="tdStyle1 tdTwoCol1">
								<strong>14. Summary of Circumstances (Optional):</strong>
								<p
									class="minutia">You may use this space to provide a brief summary of the
									circumstances leading to the action, allegation(s), finding(s)
									and disposition(s), if any. Include any relevant information on
									the current action status, and on any terms, conditions, and
									dates not already provided above, and any other relevant
									information. The information must fit within the space
									provided.</p>
							</div>
							<div class="tdStyle1 tdTwoCol2Textbox">
							<xsl:value-of
                                              select="ns4:baseHeader/ns4:summary" />
                                 </div>
						</div><div style="clear:both"></div>
					</div>
				</xsl:for-each>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>