<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>

<xsl:stylesheet 
    version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:m1="http://www.sec.gov/edgar/atsn"
	
	xmlns:com="http://www.sec.gov/edgar/common"
    xmlns:acom="http://www.sec.gov/edgar/atsncommon">
	
	
	
	<xsl:template name="PartIV">
	   
	   
	       <h4>
			    Provide the following information of the Person at <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> prepared to respond to questions for this submission: 
		   </h4>
		
		           <xsl:call-template name="ContactInfo"/> 
		   <br/>
	   
	   
	       <h4>
			    Primary Street Address of the NMS Stock ATS:
		   </h4>
		
		           <xsl:call-template name="PrimaryAddress"/>  
		   <br/>
	   
	       <h4>
		      	Mailing Address of the NMS Stock ATS (if different):
		   </h4>
		
		           <xsl:call-template name="MailingAddress"/> 
		   <br/>
		  
		
		          <xsl:call-template name="NMS-Stock-ATS-Info" /> 
		   <br/>
	
	</xsl:template>
	
	
	
	
	
	
	<xsl:template name="ContactInfo">
	
	 <table role="presentation" >
           
			<tr>
				 <td  class="label">First Name:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partFour/acom:txPart4ContactFirstName)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				 </td>
			</tr>
			
			<tr>
				 <td  class="label">Last Name:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partFour/acom:txPart4ContactLastName)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				 </td>
			</tr>
			
			<tr>
				 <td  class="label">Title:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partFour/acom:txPart4ContactTitle)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				 </td>
			</tr>
			
			<tr>
				 <td  class="label">E-Mail:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partFour/acom:txPart4ContactEmail)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				 </td>
			</tr>
			
				<tr>
				 <td  class="label">Telephone:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox2">
							 <xsl:value-of
								  select="string(m1:partFour/acom:txPart4ContactTelephone)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				 </td>
			</tr>
			
		</table>
	
	</xsl:template>
	
	<!--   END ContactInfo template-->
	
	
	
	
	<xsl:template name="PrimaryAddress">
	
	    <table role="presentation">
			<tr>
				<td class="label">Street 1 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partFour/acom:part4PrimaryAddr/acom:street1)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Street 2 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partFour/acom:part4PrimaryAddr/acom:street2)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">City </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partFour/acom:part4PrimaryAddr/acom:city)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Zip
					</td>
				<td>

					<div align="left">
						<div class="fakeBox2">
							<xsl:value-of
								select="string(m1:partFour/acom:part4PrimaryAddr/acom:zip)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</div>

				</td>
			</tr>
			
			<tr>
				<td class="label">State</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="string(m1:partFour/acom:part4PrimaryAddr/acom:state)" />
						</xsl:call-template>
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</td>
			</tr>
			
	    </table>

	</xsl:template>
	
	
	
	<!--  END PrimayAddress template -->
	
	
	
	
	
	<xsl:template name="MailingAddress">
	
	
	
	<table role="presentation">
			<tr>
				<td class="label">Street 1 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partFour/acom:part4MailingAddr/acom:street1)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Street 2 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partFour/acom:part4MailingAddr/acom:street2)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">City </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partFour/acom:part4MailingAddr/acom:city)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Zip
					</td>
				<td>

					<div align="left">
						<div class="fakeBox2">
							<xsl:value-of
								select="string(m1:partFour/acom:part4MailingAddr/acom:zip)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</div>

				</td>
			</tr>
			
			<tr>
				<td class="label">State</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="string(m1:partFour/acom:part4MailingAddr/acom:state)" />
						</xsl:call-template>
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</td>
			</tr>
			
			
			
	    </table>
	

	</xsl:template>
	
	
	<!--  END Mailing Address template -->
	
	
	
	
	<xsl:template name="NMS-Stock-ATS-Info">
	
	   <table role="presentation">
	   
	       <tr>
	          <div class="information">
	             <p>
	      
                 The 
                 <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> consents that service of any civil action brought by, or notice of any proceeding before, 
                  the SEC or a self-regulatory organization in connection with the alternative trading system's activities may be given by
                  registered or certified mail to the contact employee at the primary street address or mailing address (if different) of the NMS Stock ATS,
                  or via email,
                  and the addresses provided on this Form ATS-N. 
                  The undersigned, being first duly sworn, 
                  deposes and says that he/she has executed this form on behalf of, 
                  and with the authority of, said alternative trading system. 
                  The undersigned and  <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> represent that the information and statements contained herein,
                  including exhibits, schedules, or other documents attached hereto, 
                  and other information filed herewith, all of which are made a part hereof, 
                   are current, true, and complete. 
	       
	              </p>
	    
	           </div>
	       </tr>
	       
	       <tr>
				<td class="label">Date:</td>
				<td>
					
						<div class="fakeBox2">
							<xsl:value-of select="m1:partFour/acom:txAsOfDate" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					
				</td>
			</tr>
			
			 <tr>
				<td class="label"><xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose>:</td>
				<td>
					
						<div class="fakeBox">
							<xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					
				</td>
			</tr>
			
			<tr>
				<td class="label">By:</td>
				<td>
					
						<div class="fakeBox">
							<xsl:value-of select="string(m1:partFour/acom:txSignatureName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					
				</td>
			</tr>
			
			 <tr>
				<td class="label">Title:</td>
				<td>
					
						<div class="fakeBox">
							<xsl:value-of select="string(m1:partFour/acom:txSignatureTitle)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					
				</td>
			</tr>
	     
	   </table>
	
	</xsl:template>
	
	
	<!--  END NMS-Stock-ATS-Info template -->
	
	

</xsl:stylesheet>