<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>

<xsl:stylesheet 
version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:m2="http://www.sec.gov/edgar/atsncw"
   
	xmlns:com="http://www.sec.gov/edgar/common"
	
   xmlns:acom="http://www.sec.gov/edgar/atsncommon">

<xsl:import href="util.xsl"/>

<xsl:output
		method="html"
		indent="no"
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />
		
		 <xsl:variable name = "submissionType" select = "m2:edgarSubmission/m2:headerData/m2:submissionType" />
  
	<xsl:template match="/">
  	
  	
  	  	<html>
			<head>
				 <link rel="stylesheet" type="text/css" href="css/ATSN_print.css" />
				
				
			</head>

			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				
				<xsl:call-template name="header" />
				<xsl:call-template name="headerData" />
				<xsl:call-template name="formData" />
				
				
					
			</body>
		</html>
	
	</xsl:template>
	
	     <xsl:template name="schemaVersion" match="m2:edgarSubmission/m2:schemaVersion">
		<div style="display:none">
			schemaVersion:
				<xsl:value-of select="m2:edgarSubmission/m2:schemaVersion" />
		</div>
	  </xsl:template>
	
	
	
	
	
	 <xsl:template name="header">
	 
      	 <div class="contentwrapper">
  
             <table role="presentation"  id="header">
			   <tr>
                        <div class="boxed">
                                THE SECURITIES AND EXCHANGE COMMISSION HAS NOT PASSED UPON THE MERITS OR ACCURACY OF<br/> THE DISCLOSURES IN THIS FILING.
                        </div>
               </tr>
               <tr>
                   <td class="title">Form ATS-N Filer Information</td>
                   <td rowspan="2" class="center">
                        United States Securities and Exchange Commission
                        <br />
                     
                        Washington, DC
                        <br />
                       
                        FORM ATS-N
                        <br />
                       
                        Intentional Misstatements or Omissions of Facts May Constitute
                        <br />
                       
                        Criminal Violations
                        <br />
                       
                        See 18 U.S.C.1001 and 15 U.S.C. 78ff(a)
                  </td>
                  <td class="title">OMB APPROVAL</td>
              </tr>
          
        
              <tr>
              
               <xsl:if test="m2:edgarSubmission/m2:headerData/m2:submissionType = 'ATS-N-C'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Notice of Cessation (Rule 304(a)(3))
                    </p>
                 </td>
              </xsl:if>
              
               <xsl:if test="m2:edgarSubmission/m2:headerData/m2:submissionType = 'ATS-N-W'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Withdrawal of Form ATS-N filing 
                    </p>
                 </td>
              </xsl:if>
    
                  <td class="side" style="text-align: center;">
                    <p>OMB Number:&#160;&#160;3235-0763</p>
                     <hr></hr>
                   <p>Estimated average burden hours per response:&#160;127.4</p>
                    <hr></hr>
                    <p>Estimated average burden hours per amendment:&#160;9</p>
                    <hr></hr>
                    <p>Estimated average burden hours per cessation:&#160;2</p>
                    <hr></hr>
                   <p>OMB Expiration Date:&#160;09/30/2021</p> 
                 </td>
             </tr>
       
   
         
    
   </table>
   
   </div> <!-- contentwrapper -->
   
 </xsl:template> 
 <!-- Header Template END -->
 
 
 <!--  Filer Information Template START -->
	 
	 <xsl:template name="headerData" >
	   
	   <div id="info">
	      <div class="contentwrapper">
				<div class="content"> 
	                 <h1><xsl:value-of select ="m2:edgarSubmission/m2:headerData/m2:submissionType"/>: Filer Information</h1>
	                 
	                 
	                     <!-- Filer -->
	                    <table role="presentation" class="filerInformation" >
						   <tr>
						    	<td class="label">Filer CIK</td>
							    <td>
								      <div class="fakeBox2">
									     <xsl:value-of
				                             select="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:filer/m2:filerCredentials/com:cik)" />
									       <span>
										       <xsl:text>&#160;</xsl:text>
									       </span>
							         </div>

							   </td>
						   </tr>
						   <tr>
							   <td class="label">Filer CCC</td>
							   <td>
							   
							     <xsl:choose>
							         <xsl:when  test="count(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:filer/m2:filerCredentials/com:ccc) &gt; 0"> 
								        <div class="fakeBox2">
								           
										     ********
								     	  <span>
										      <xsl:text>&#160;</xsl:text>
								         </span>
								           
								        </div>
                                    </xsl:when> 
                                    <xsl:otherwise>
                                 
                                       <div class="fakeBox2">
                                         <span>
										      <xsl:text>&#160;</xsl:text>
								         </span>
                                       </div>
                                    </xsl:otherwise>
                                 </xsl:choose> 
							   
							  </td>
					     </tr>
				 
                         <tr>
					           <td class="label">MPID of the NMS Stock ATS:</td>
						        <td>
							          <div class="fakeBox2">
								         <xsl:value-of select="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:filer/m2:MPID)"/>
										<span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							          </div>
						      </td>
				        </tr>
				        
				         <tr>
					           <td class="label">Accession Number of Filing Withdrawn</td>
						        <td>
							          <div class="fakeBox2">
								         <xsl:value-of select="string(m2:edgarSubmission/m2:headerData/m2:accessionNumber)"/>
										<span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							          </div>
						      </td>
				        </tr>
                     
                     </table>
                     
           <table role="presentation" class="filerInformation">
                     
             <xsl:choose>    
             
                        <xsl:when test="string-length(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:filer/m2:NMSStockATSName)&gt; 0">
                          <tr>     
                              
                             <td colspan="2">
                                 <table style="table-layout: auto;">
                             	     <tr> 				         
							            <td style="white-space: nowrap;"> 
							                <span class="fakeBox4">
								                  <xsl:value-of select ="m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:filer/m2:NMSStockATSName"/>
										      
							                </span>
							         
							            </td>
							            <td style="width:100%">
							                 
					                             <span>is making this filing pursuant to the Rule 304 under the Securities Exchange Act of 1934</span> 
					              
					              
						                </td>
				                    </tr>
				               </table>
				           </td>  
				       </tr>      
                     </xsl:when>
                     <xsl:otherwise>
                        <tr>     
                              
                              <td>
						        
							           <span class="fakeBox4">
								           <xsl:value-of select ="m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:filer/m2:NMSStockATSName"/>
										  <span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							         </span>
							
				                <span>
				              	
					             is making this filing pursuant to the Rule 304 under the Securities Exchange Act of 1934
					           
					             </span>
						    </td>
				         </tr>
                     
                     </xsl:otherwise>
                       
              
             </xsl:choose>
			  </table>		  
	                  
                   
                   <table role="presentation" class="filerInformation" >
	                  
	             
	                <xsl:if test="m2:edgarSubmission/m2:headerData/m2:submissionType= 'ATS-N-C'">
				     <tr>
				           <td class="label">Date the NMS Stock ATS will cease to operate:</td>
						   <td>
							  <div class="fakeBox2">
								  <xsl:value-of select="string(m2:edgarSubmission/m2:headerData/m2:dateCeaseToOperate)"/>
										<span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							  </div>
						  </td>
				   
				      </tr>
	               </xsl:if> 
                        
                       
                 
				 </table  >
	          
	              
	            
	              <table  role="presentation" >
	            
	               
	                    <tr>
	                  
	                          <td class="label">
							            	Is this a LIVE or TEST Filing?
					          </td>
					          <td>
								    <span class="yesNo">
									   <xsl:choose>
										     <xsl:when test="count(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:liveTestFlag) &gt; 0">
									               <xsl:choose>
											              <xsl:when test="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:liveTestFlag) = 'LIVE'">
												            	<img src="Images/radio-checked.jpg" alt="Radio button checked" />
													                LIVE
													            <img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
												                	TEST
												           </xsl:when>
											       </xsl:choose>
									               <xsl:choose>
											               <xsl:when test="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:liveTestFlag) = 'TEST'">
												             	<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
													                LIVE
													            <img src="Images/radio-checked.jpg" alt="Radio button checked" />
												                 	TEST
												           </xsl:when>
											      </xsl:choose>
										     </xsl:when>
									        <xsl:otherwise>
											                   <img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
											                        LIVE
											                   <img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										                         	TEST
									        </xsl:otherwise>
									</xsl:choose>
								</span>
					    	</td>
	              
	                    </tr>
	                    
	                     <tr>
	                        <td class="label">
	                              Is this an electronic copy of an official filing submitted in paper format in connection with a hardship exemption?
	                        </td>
	                        <td>
	                                <xsl:choose>
									       <xsl:when
										            test="m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:flags/acom:confirmingCopyFlag = 'true'">
										                     <img src="Images/box-checked.jpg" alt="Checkbox checked" />
									       </xsl:when>
								           <xsl:otherwise>
										                     <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									       </xsl:otherwise>
							       </xsl:choose>
	                      
	                        </td>
	                   </tr>   
	                    
	                    
	                           
	                     <xsl:if	test="m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:flags/acom:confirmingCopyFlag = 'true'">
					  <tr>
							<td class="label">Confirming Copy File Number</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:flags/acom:confirmingCopyFileNumber" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</td>
					  </tr>
						 </xsl:if>
	                    
	                    
	                    
	               
	               
	             
	                    
	                    
	                    
	                    
	                    
	        
	          </table>
	            
	            <!-- contact -->
	          
	            <table  role="presentation" >
	                  <tr>
	                       
	                            <h4>Submission Contact Information</h4>
	                      
	                  </tr>
	            
	                  <tr>
							<td class="label">Name</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:contact/acom:contactName)" />
									   <span>
									    	<xsl:text>&#160;</xsl:text>
									   </span>
								</div>
							</td>
					 </tr>
					 <tr>
							<td class="label">Phone Number</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of
										select="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:contact/acom:contactPhoneNumber)" />
								      <span>
										   <xsl:text>&#160;</xsl:text>
									 </span>
								</div>

							</td>
					 </tr>
					 <tr>
							<td class="label">E-Mail Address</td>
							<td>
								<div class="fakeBox">
								   <xsl:value-of
										 select="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:contact/acom:contactEmailAddress)" />
									 <span>
										   <xsl:text>&#160;</xsl:text>
									 </span>
								</div>
							</td>
					</tr>
				</table>
				
	   
				
				<!-- Notifications -->
				
				
				  <table  role="presentation" >
				  
				      <tr>
	                        
	                            <h4>Notification Information</h4>
	                       
	                  </tr>
				  
				
				      <tr>
						   <td class="label">
								Notify via Filing Website only?
						   </td>
						   <td>
								 <xsl:choose>
									 <xsl:when
										  test="string(m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:flags/acom:overrideInternetFlag) = 'true'">
										        <img src="Images/box-checked.jpg" alt="Checkbox checked" />

									 </xsl:when>
									<xsl:otherwise>
										        <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
						   </td>
				     </tr>
				</table>
				
				    
	         <xsl:for-each
				 select="m2:edgarSubmission/m2:headerData/m2:filerInfo/m2:notifications/acom:notificationEmailAddress">
			   <table role="presentation" >
				   <tr>
					       <td class="label">Notification E-mail Address</td>
						   <td>
							  <div class="fakeBox">
								  <xsl:value-of select="." />
										<span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							  </div>
						  </td>
				  </tr>
			  </table>
		    </xsl:for-each>
		    
		    
		    
		    
		    
				 </div> <!-- content close here-->
				 </div> <!-- contentwrapper-->
				 </div><!-- div info-->
				 
	  </xsl:template>
	           
	        <!--   End of filer information page-->   
	        
	        
   
	        
	        
	        <!--  FormData Template start-->
	         
      <xsl:template name="formData" >
	         
	   
	           
	        <!--  Real Form DATA -->
	         
	              <div class="content">
	              
	                <div class="label">
	                
	        
	                    
    
	                      
	                      
	              
	                      
	             </div> <!-- label div -->
	           </div> <!-- div content -->
	    
	   
	  </xsl:template>
	      <!--  end Form data template -->
	       

	  
	  
	  
	  
	  <xsl:template name="condYesNoRadio">
			<xsl:param name="yesElement" />
			<xsl:param name="noElement" />
		<span class="yesNo">
						<xsl:choose>
							<xsl:when test="count($yesElement) &gt; 0 or count($noElement) &gt; 0">
								<xsl:choose>
									<xsl:when
										test="string($yesElement) = 'Y'">
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										Yes
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										No
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when
										test="string($noElement) = 'N'">
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										Yes
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										No
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								Yes
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								No
							</xsl:otherwise>
						</xsl:choose>
					</span>

			</xsl:template>
	
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  	<xsl:template name="yesNoRadio">
			<xsl:param name="yesNoElement" />
		<span class="yesNo">
						<xsl:choose>
							<xsl:when
								test="count($yesNoElement) &gt; 0">
								<xsl:choose>
									<xsl:when
										test="string($yesNoElement) = 'Y'">
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										Yes
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										No
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when
										test="string($yesNoElement) = 'N'">
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										Yes
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										No
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								Yes
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								No
							</xsl:otherwise>
						</xsl:choose>
					</span>

			</xsl:template>
	  
	  
	  
	  
	  
	  
	     
	       

   <xsl:include href="ATSN_CW_partIV.xsl" />
  
   <xsl:include href="iso_State_Codes.xsl" />
   
	
	
	
</xsl:stylesheet>