<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>

<xsl:stylesheet 
    version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:m1="http://www.sec.gov/edgar/atsn"
	
	xmlns:com="http://www.sec.gov/edgar/common"
    xmlns:acom="http://www.sec.gov/edgar/atsncommon">
	
	
	<xsl:template name ="PartIII">
	
	
	                      <br/>
	                           <h4>Item 1: <u>Types of ATS Subscribers</u></h4>
	                          <!--  call item1 template here -->  
	                            <xsl:call-template name="item1_partIII"/>
	                      <br/>      
	                           <h4>Item 2: <u>Eligibility for ATS Services</u></h4>
	                               
	                             <!--  call item2 template here -->
	                             <xsl:call-template name="item2_partIII"/>  
	                      <br/>        
	                           <h4>Item 3: <u>Exclusion from ATS Services</u></h4>
	                              
	                             <!--  call item3 template here --> 
	                             <xsl:call-template name="item3_partIII"/>   
	                      <br/>        
	                           <h4>Item 4: <u>Hours of Operation</u></h4>
	                                 
	                            <!--  call item4 template here --> 
	                            <xsl:call-template name="item4_partIII"/>     
	                                  
	                      <br/>        
	                           <h4>Item 5: <u>Means of Entry</u></h4>
	                            
	                            <!--  call item5 template here -->
	                            <xsl:call-template name="item5_partIII"/>  
	                               
	                      <br/>     
	                           <h4>Item 6: <u>Connectivity and Co-location</u></h4>
	                            
	                           <!--  call item6 template here --> 
	                           <xsl:call-template name="item6_partIII"/>  
	                                              
	                      <br/> 
	                           <h4>Item 7: <u>Order Types and Attributes</u></h4>
	                            
	                          <!--  call item7 template here --> 
	                          <xsl:call-template name="item7_partIII"/> 
	                            
	                      <br/>       
	                           <h4>Item 8: <u>Order Sizes</u></h4>
	                            
	                          <!--  call item8 template here -->
	                          <xsl:call-template name="item8_partIII"/>   
	                               
	                      <br/>      
	                           <h4>Item 9: <u>Conditional Orders and Indications of Interest</u></h4>
	                           
	                           <!--  call item9 template here -->
	                           <xsl:call-template name="item9_partIII"/> 
	                                  
	                      <br/>       
	                           <h4>Item 10: <u>Opening and Reopening</u></h4>
	                            
	                           <!--  call item10 template here -->
	                           <xsl:call-template name="item10_partIII"/> 
	                            
	                      <br/>       
	                           <h4>Item 11: <u>Trading Services, Facilities and Rules</u></h4>
	                           
	                           <!--  call item11 template here -->
	                           <xsl:call-template name="item11_partIII"/> 
	                               
	                      <br/>       
	                           <h4>Item 12: <u>Liquidity Providers</u></h4>
	                           
                               <!--  call item12 template here -->
                               <xsl:call-template name="item12_partIII"/> 
                                        
	                      <br/>      
	                           <h4>Item 13: <u>Segmentation; Notice</u></h4>
	                           
	                          <!--  call item13 template here -->
	                          <xsl:call-template name="item13_partIII"/> 
	                               
	                      <br/>     
	                           <h4>Item 14: <u>Counter-Party Selection</u></h4>
	                         
	                         <!--  call item14 template here -->
	                         <xsl:call-template name="item14_partIII"/> 
	                         
	                      <br/>              
	                           <h4>Item 15: <u>Display</u></h4>
	                            
	                          <!--  call item15 template here -->  
	                          <xsl:call-template name="item15_partIII"/>      
	                      <br/>    
	                           <h4>Item 16: <u>Routing</u></h4>
	                            
	                          <!--  call item16 template here -->
	                          <xsl:call-template name="item16_partIII"/>   
	                                                  
	                      <br/>      
	                           <h4>Item 17: <u>Closing</u></h4>
	                             
	                          <!--  call item17 template here --> 
	                          <xsl:call-template name="item17_partIII"/>    
	                              
	                      <br/>     
	                           <h4>Item 18: <u>Trading Outside of Regular Trading Hours</u></h4>
	                            
	                           <!--  call item18 template here -->
	                           <xsl:call-template name="item18_partIII"/> 
	                            
	                              
	                      <br/>     
	                           <h4>Item 19: <u>Fees</u></h4>
	                             
	                          <!--  call item19 template here --> 
	                          <xsl:call-template name="item19_partIII"/>   
	                                
	                      <br/>     
	                            <h4>Item 20: <u>Suspension of Trading</u></h4>
	                             
	                          <!--  call item20 template here --> 
	                          <xsl:call-template name="item20_partIII"/>  
	                             
	                              
	                      <br/>    
	                            <h4>Item 21: <u>Trade Reporting</u></h4>
	                            
	                          <!--  call item21 template here -->
	                          <xsl:call-template name="item21_partIII"/>   
	                             
	                      <br/>    
	                            <h4>Item 22: <u>Clearance and Settlement</u></h4>
	                             
	                          <!--  call item22 template here -->   
	                           <xsl:call-template name="item22_partIII"/>       
	                      <br/>   
	                            <h4>Item 23: <u>Market Data</u></h4>
	                             
	                          <!--  call item23 template here --> 
	                            <xsl:call-template name="item23_partIII"/>
	                             
	                      <br/>
	                            <h4>Item 24: <u>Order Display and Execution Access</u></h4>
	                           
	                          <!--  call item24 template here -->
	                          <xsl:call-template name="item24_partIII"/> 
	                             
	                      <br/>  
	                            <h4>Item 25: <u>Fair Access</u></h4>
	                          
	                          <!--  call item25 template here -->
	                          <xsl:call-template name="item25_partIII"/> 
	                          
	                      <br/>  
	                            <h4>Item 26: <u>Aggregate Platform Data</u></h4>
	                           
	                          <!--  call item26 template here --> 
	                          <xsl:call-template name="item26_partIII"/>      
	                      <br/>
	
	
	</xsl:template>
	
	
	<!--  template item1 -->
	<xsl:template name="item1_partIII">
	    
	    <table role="presentation">
	       
	         <tr>
	                  
	              <td class="label">
						 Select the type(s) of Subscribers that can use the NMS Stock ATS services:
				  </td>
					          
			      <td>
                              <xsl:choose>
						            <xsl:when
							              test="m1:partThree/m1:taPart3Item1SubscriberType = 'Investment Companies'">
							                <img
								                   src="Images/box-checked.jpg"
								                   alt="Checkbox checked" />
						            </xsl:when>
						      <xsl:otherwise>
							                <img
								                   src="Images/box-unchecked.jpg"
								                   alt="Checkbox not checked" />
						     </xsl:otherwise>
					         </xsl:choose>
					                  &#160; Investment Companies  &#160;<br/>
					         <xsl:choose>
						           <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Retail Investors'">
							               <img
								                   src="Images/box-checked.jpg"
								                   alt="Checkbox checked" />
						           </xsl:when>
						     <xsl:otherwise>
							               <img
								                   src="Images/box-unchecked.jpg"
						 		                   alt="Checkbox not checked" />
						     </xsl:otherwise>
					         </xsl:choose>
					                 &#160; Retail Investors  &#160;<br/>
					        <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Issuers'">
							               <img
								                   src="Images/box-checked.jpg"
								                   alt="Checkbox checked" />
					          	</xsl:when>
						    <xsl:otherwise>
							              <img
								                   src="Images/box-unchecked.jpg"
								                   alt="Checkbox not checked" />
						   </xsl:otherwise>
					       </xsl:choose>
					                &#160; Issuers &#160;<br/>
					       <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Brokers'">
							             <img
								                    src="Images/box-checked.jpg"
								                    alt="Checkbox checked" />
						         </xsl:when>
						   <xsl:otherwise>
							             <img
								                    src="Images/box-unchecked.jpg"
								                    alt="Checkbox not checked" />
					       	</xsl:otherwise>
					       </xsl:choose>
					                &#160; Brokers &#160;<br/>
					       <xsl:choose>
						          <xsl:when
							              test="m1:partThree/m1:taPart3Item1SubscriberType = 'NMS Stock ATSs'">
							            <img
								                     src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						          </xsl:when>
						   <xsl:otherwise>
							            <img
							                    	 src="Images/box-unchecked.jpg"
								                     alt="Checkbox not checked" />
						 </xsl:otherwise>
				     	 </xsl:choose>
					              &#160; NMS Stock ATSs  &#160;<br/>
						 <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Asset Managers'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Asset Managers &#160;<br/>
					             
					   <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Principal Trading Firms'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Principal Trading Firms &#160;<br/>
					             
					    <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Hedge Funds'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Hedge Funds &#160;<br/>
					             
					             
					    <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Market Makers'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Market Makers &#160;<br/>
					             
					    
					     <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Banks'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Banks &#160;<br/>   
					             
					             
					    <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Dealers'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Dealers &#160;<br/>   
					             
					    <xsl:choose>
						         <xsl:when
							             test="m1:partThree/m1:taPart3Item1SubscriberType = 'Other'">
							             <img
								                      src="Images/box-checked.jpg"
								                       alt="Checkbox checked" />
						         </xsl:when>
						 <xsl:otherwise>
							             <img
								                      src="Images/box-unchecked.jpg"
								                      alt="Checkbox not checked" />
						</xsl:otherwise>
					    </xsl:choose>
					             &#160; Other &#160;<br/>       
					             
					             
					             
			     </td>
			   
			   
			          
		   </tr>
		        
		     <xsl:choose>
			        <xsl:when
							 test="m1:partThree/m1:taPart3Item1SubscriberType = 'Other'"> 
		   
		   <tr>
		         <td class="label">
                            If other, identify the type(s) of subscriber.
                 </td> 
		   	     <td>
						 <div class="fakeBox3">
							 <xsl:value-of select="string(m1:partThree/m1:taPart3Item1OtherSubscrbrDtls)" />
								      <span>
									         <xsl:text>&#160;</xsl:text>
								      </span>
						 </div>
                 </td> 
		   
		   </tr>
				     </xsl:when>
		     </xsl:choose>  		    
						
	   </table>
	    
	</xsl:template>
	               <!--  template item1 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item2_partIII">
	  
	   <table role="presentation">
	  
	       <tr>
				<td class="label">
				     a. Does the NMS Stock ATS require Subscribers to be registered broker-dealers?
				</td>
				<td>
					<xsl:call-template name="yesNoRadio">
						<xsl:with-param name="yesNoElement"
							select="m1:partThree/m1:rbPart3Item2aRegisteredBD" />
					</xsl:call-template>
				</td>
			</tr>
			 <tr>
	               <td class="label">
	                   b. Are there any other conditions that the NMS Stock ATS requires a Person to satisfy before accessing the ATS services?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item2bIsThereOtherConditions" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item2bSummaryOfConditions/@rbPart3Item2bIsThereOtherConditions" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	           
	            <!--  check b is Y -->
	           <xsl:choose>
		          <xsl:when    
						test="string(m1:partThree/m1:part3Item2bSummaryOfConditions/@rbPart3Item2bIsThereOtherConditions) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, list and provide a summary of the conditions.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item2bSummaryOfConditions/m1:taPart3Item2bSummaryOfCndtns)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			</tr>
			<tr> 
			      <td class="label">
					  c. If yes to Item 2(b), are the conditions required to be identified in Item 2(b) the same for all Persons?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item2bSummaryOfConditions/m1:part3Item2cSummaryOfConditions/@rbPart3Item2cIsConditionsSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item2bSummaryOfConditions/m1:rbPart3Item2cIsConditionsSameForAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			             <!--  check c is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item2bSummaryOfConditions/m1:part3Item2cSummaryOfConditions/@rbPart3Item2cIsConditionsSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and describe any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item2bSummaryOfConditions/m1:part3Item2cSummaryOfConditions/m1:taPart3Item2cSummaryOfDifferences" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check c is N END-->
	              </xsl:when>
	          </xsl:choose>
	          <!--  check b is Y END-->
	    
	        <tr>
	             <td class="label">
				     d. Does the NMS Stock ATS require Subscribers to enter a written agreement to use the ATS services?
				 </td>
				 <td>
					<xsl:call-template name="yesNoRadio">
						<xsl:with-param name="yesNoElement"
							select="m1:partThree/m1:rbPart3Item2dIsThereWrittenAgreement"/>
					</xsl:call-template>
				 </td>
	       </tr>
	  </table>
	
	</xsl:template>
	
		           <!--  template item2 End -->
	<!-- ********************************************************** -->
	
	
	<xsl:template name="item3_partIII">
	
	  <table role="presentation">
	  
	       <tr>
	               <td class="label">
	                   a. Can the NMS Stock ATS exclude, in whole or in part, any Subscriber from the ATS services?    	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item3aIsExcludeSubscriber" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/@rbPart3Item3aIsExcludeSubscriber" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/@rbPart3Item3aIsExcludeSubscriber) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, list and provide a summary of the conditions for excluding, in whole or in part, a Subscriber from the ATS services.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/m1:taPart3Item3aExcludngSumryDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	      </tr>
	       <tr> 
			      <td class="label">
					  b. If yes to Item 3(a), are the conditions required to be identified in Item 3(a) the same for all Subscribers?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/m1:part3Item3bSummaryOfConditions/@rbPart3Item3bIsCondtnsSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/m1:rbPart3Item3bIsCondtnsSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/m1:part3Item3bSummaryOfConditions/@rbPart3Item3bIsCondtnsSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item3aSumryOfExcludngCondtns/m1:part3Item3bSummaryOfConditions/m1:taPart3Item3bSummaryOfDifferences" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	  
	  </table>
	
	</xsl:template>
	
	               <!--  template item3 End -->
	<!-- ********************************************************** -->
	
	
	<xsl:template name="item4_partIII">
	  <table role="presentation">
	        <tr>
	               <td class="label">
	                   a. Provide the days and hours of operation of the NMS Stock ATS, including the times when orders or trading interest can be entered on the ATS, and any hours of operation outside of regular trading hours.  
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item4aHrsOfOperation)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	        </tr>
	        <tr> 
			      <td class="label">
					   b. Are the hours of operations the same for all Subscribers and the Broker-Dealer Operator?    
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item4bSumryOfHrsOfOperation/@rbPart3Item4bIsHrsOfOperationsame" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item4bIsHrsOfOperationsame" />
				      </xsl:call-template>
				  </td>     
		    </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item4bSumryOfHrsOfOperation/@rbPart3Item4bIsHrsOfOperationsame) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item4bSumryOfHrsOfOperation/m1:taPart3Item4bSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	  </table>
	</xsl:template>
	
	                    <!--  template item4 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item5_partIII">
	  <table role="presentation">
	  
	        <tr>
	               <td class="label">
	                   a. Does the NMS Stock ATS permit orders and trading interest to be entered directly into the ATS (<u>e.g.,</u> via Financial Information eXchange ("FIX") protocol, Binary)?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item5aIsPermitOrdrTradng" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item5aProtocolDetails/@rbPart3Item5aIsPermitOrdrTradng" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        
	    <!-- check a Y -->   
	   <xsl:choose>
		  <xsl:when
						test="string(m1:partThree/m1:part3Item5aProtocolDetails/@rbPart3Item5aIsPermitOrdrTradng) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, explain the protocol that can be used to directly enter orders and trading interest into the ATS.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item5aProtocolDetails/m1:taPart3Item5aProtocolused)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			      </td>
			</tr>
			<tr> 
			      <td class="label">
				 	 b. If yes to Item 5(a), are the protocols required to be identified in Item 5(a) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item5aProtocolDetails/m1:part3Item5bProtocolDetails/@rbPart3Item5bIsProtclsameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item5aProtocolDetails/m1:rbPart3Item5bIsProtclsameForAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			            <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item5aProtocolDetails/m1:part3Item5bProtocolDetails/@rbPart3Item5bIsProtclsameForAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item5aProtocolDetails/m1:part3Item5bProtocolDetails/m1:taPart3Item5aProtocolSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			          <!--  check b is N  END-->
	  
	  
	      </xsl:when>
	   </xsl:choose>
	   <!-- check a Y END--> 
	     
	        <tr>
	              <td class="label">
	                   c. Are there any other means for entering orders and trading interest into the NMS Stock ATS (<u>e.g.,</u> smart order router, algorithm, order management system, sales desk)?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item5cIsAnyOtherMeans" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item5cOthrDtls/@rbPart3Item5cIsAnyOtherMeans" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        
	          <!--  check c is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item5cOthrDtls/@rbPart3Item5cIsAnyOtherMeans) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, identify and explain the other means for entering orders and trading interest, indicate whether the means are provided through the Broker-Dealer Operator, either by itself or through a third-party contracting with the Broker-Dealer Operator, or through an Affiliate of the Broker-Dealer Operator, and list and provide a summary of the terms and conditions for entering orders or trading interest into the ATS through these means.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item5cOthrDtls/m1:taPart3Item5cOthrMeansDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			</tr>
			<tr>
	               <td class="label">
	                   d. If yes to Item 5(c), are the terms and conditions required to be identified in Item 5(c) the same for all Subscribers and the Broker-Dealer Operator?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:part3Item5cOthrDtls/m1:part3Item5dTnCDetails/@rbPart3Item5dIsTnCSameForAll" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item5cOthrDtls/m1:rbPart3Item5dIsTnCSameForAll" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	                     <!--  check d is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item5cOthrDtls/m1:part3Item5dTnCDetails/@rbPart3Item5dIsTnCSameForAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item5cOthrDtls/m1:part3Item5dTnCDetails/m1:taPart3Item5dTnCSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check d is N END-->
	      
	             </xsl:when>
	          </xsl:choose>
	         <!--  check c is Y END-->
	  
	  </table>
	 </xsl:template>
	              <!--  template item5 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item6_partIII">
	  <table role="presentation">
	     
	      <tr>
	              <td class="label">
	                   a. Does the NMS Stock ATS offer co-location and related services (e.g., cabinets and equipment, cross-connects)?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item6aIsCoLocRltdSrvcsOfrd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item6aProtocolDetails/@rbPart3Item6aIsCoLocRltdSrvcsOfrd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item6aProtocolDetails/@rbPart3Item6aIsCoLocRltdSrvcsOfrd) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, provide a summary of the terms and conditions for co-location and related services, including the speed and connection (e.g., fiber, copper) options offered.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item6aProtocolDetails/m1:taPart3Item6aCoLocRltdSrvcsDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
		   </tr>
		   <tr> 
			      <td class="label">
					   b. If yes to Item (6)(a), are the terms and conditions required to be identified in Item 6(a) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item6aProtocolDetails/m1:part3Item6bTNCDetails/@rbPart3Item6bIsTNCsameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item6aProtocolDetails/m1:rbPart3Item6bIsTNCsameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
		  
		                  <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item6aProtocolDetails/m1:part3Item6bTNCDetails/@rbPart3Item6bIsTNCsameForAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item6aProtocolDetails/m1:part3Item6bTNCDetails/m1:taPart3Item6bTNCSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			            <!--  check b is N  END-->
			
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END-->
	         
	        <tr> 
			      <td class="label">
					  c. Does the NMS Stock ATS offer any other means besides co-location and related services required to be explained in this Item 6(a) to increase the speed of communication with the ATS?   
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:rbPart3Item6cIsAnyOtherMeans" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item6cOthrDetails/@rbPart3Item6cIsAnyOtherMeans" />
				      </xsl:call-template>
				  </td>     
		    </tr>
		     
		      <!--  check c is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item6cOthrDetails/@rbPart3Item6cIsAnyOtherMeans) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, explain the means to increase the speed of communication with the ATS and provide a summary of the terms and conditions for its use.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item6cOthrDetails/m1:taPart3Item6cSpeedMeansDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			      </td>
			</tr>
			<tr>
	               <td class="label">
	                   d. If yes to Item 6(c), are the terms and conditions required to be identified in Item 6(c) the same for all Subscribers and the Broker-Dealer Operator?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:part3Item6cOthrDetails/m1:part3Item6dTnCDetails/@rbPart3Item6dIsTnCSameForAll" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item6cOthrDetails/m1:rbPart3Item6dIsTnCSameForAll" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	                     <!--  check d is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item6cOthrDetails/m1:part3Item6dTnCDetails/@rbPart3Item6dIsTnCSameForAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item6cOthrDetails/m1:part3Item6dTnCDetails/m1:taPart3Item6dTnCSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check d is N END-->
	      
	             </xsl:when>
	          </xsl:choose>
	         <!--  check c is Y END-->
		     
		   <tr>
	              <td class="label">
	                   e. Does the NMS Stock ATS offer any means to reduce the speed of communication with the ATS (<u>e.g.,</u> speed bumps)?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item6eIsAnyRducdSpOfCom" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item6eRducdSpeedDetails/@rbPart3Item6eIsAnyRducdSpOfCom" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	       
	           <!--  check e is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item6eRducdSpeedDetails/@rbPart3Item6eIsAnyRducdSpOfCom) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, explain the methods to reduce the speed of communication with the ATS and provide a summary of the terms and conditions for its use.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item6eRducdSpeedDetails/m1:taPart3Item6eRducdSpeedMeansDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			      </td>
		   </tr>
		   <tr>
	              <td class="label">
	                   f. If yes to Item 6(e), are the terms and conditions required to be identified in Item 6(e) the same for all Subscribers and the Broker-Dealer Operator?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:part3Item6eRducdSpeedDetails/m1:part3Item6fTnCDetails/@rbPart3Item6fIsTnCSameForAll" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item6eRducdSpeedDetails/m1:rbPart3Item6fIsTnCSameForAll" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	       
	                      <!--  check f is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item6eRducdSpeedDetails/m1:part3Item6fTnCDetails/@rbPart3Item6fIsTnCSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item6eRducdSpeedDetails/m1:part3Item6fTnCDetails/m1:taPart3Item6fTnCSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>			
			            <!--  check f is N END-->  
	               </xsl:when>
	            </xsl:choose>
	            <!--  check e is Y END-->
	  </table>
    </xsl:template>
	               <!--  template item6 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item7_partIII">
	 <table role="presentation">
	       <tr>   
	           <td class="label">
	                a. Identify and explain each order type offered by the NMS Stock ATS.  In your explanation, include the following:<br/><br/>
	                i. priority, including the order type's priority upon order entry and any subsequent change to priority (if applicable); whether and when the order type can receive a new time stamp; the order type's priority vis-à-vis other orders on the book due to changes in the NBBO or other reference price; and any instance in which the order type could lose execution priority to a later arriving order at the same price;<br/><br/>
	                ii. conditions, including any price conditions (<u>e.g.,</u> how price conditions affect the rank and price at which it can be executed; conditions on the display or non-display of an order; or conditions on executability and routability);<br/><br/>   
	                iii. order types designed not to remove liquidity (<u>e.g.,</u> post-only orders), including what occurs when such order is marketable against trading interest on the NMS Stock ATS when received;<br/><br/>
	                iv. order types that adjust their price as changes to the order book occur (e.g., price sliding orders or pegged orders) or have a discretionary range, including an order's rank and price upon order entry and whether such prices or rank may change based on the NBBO or other market conditions when using such order type; when the order type is executable and at what price the execution would occur; whether the price at which the order type can be executed ever changes; and if the order type can operate in different ways, the default operation of the order type;<br/><br/>
	                v. whether an order type is eligible for routing to other Trading Centers;<br/><br/>
	                vi. the time-in-force instructions that can be used or not used with each order type;<br/><br/>
	                vii. the circumstances under which order types may be combined with another order type, modified, replaced, canceled, rejected, or removed from the NMS Stock ATS; and<br/><br/>
	                viii. the availability of order types across all forms of connectivity to the NMS Stock ATS and differences, if any, in the availability of an order type across those forms of connectivity.
	           
	             </td>
	             <td>

					    <div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:taPart3Item7AOrdrTypExplain" />
							    	<span>
								    	<xsl:text>&#160;</xsl:text>
								   </span>
					    </div>

				 </td> 
	     </tr>  
	          
	     
	     <tr> 
			      <td class="label">
					  b. Are the terms and conditions for each order type and attribute the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item7bTnCDetails/@rbPart3Item7bIsTnCSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item7bIsTnCSameForAll" />
				      </xsl:call-template>
				  </td>     
		 </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item7bTnCDetails/@rbPart3Item7bIsTnCSameForAll) = 'N'">
		 <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item7bTnCDetails/m1:taPart3Item7bTnCSumryDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		 </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
			            
			            
      </table>
     </xsl:template>
                     <!--  template item7 End -->
	<!-- ********************************************************** -->	
	 
	 <xsl:template name="item8_partIII">
	   <table role="presentation">
	   
	       <tr>
	               <td class="label">
	                   a. Does the NMS Stock ATS require minimum or maximum sizes for orders or trading interest?    	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item8aIsMinOrMaxSizeReqd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item8aSizeReqrmnts/@rbPart3Item8aIsMinOrMaxSizeReqd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item8aSizeReqrmnts/@rbPart3Item8aIsMinOrMaxSizeReqd) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, specify any minimum or maximum order or trading interest size requirements and any related handling procedures.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item8aSizeReqrmnts/m1:taPart3Item8aOtiSizeReqrmns)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	      </tr>
	       <tr> 
			      <td class="label">
					  b. If yes to Item 8(a), are the requirements and procedures required to be identified in Item 8(a) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item8aSizeReqrmnts/m1:part3Item8bReqProcDetails/@rbPart3Item8bIsReqProcSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item8aSizeReqrmnts/m1:rbPart3Item8bIsReqProcSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item8aSizeReqrmnts/m1:part3Item8bReqProcDetails/@rbPart3Item8bIsReqProcSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item8aSizeReqrmnts/m1:part3Item8bReqProcDetails/m1:taPart3Item8bDiffrncsInOtiReqrmnts" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	         
	         
	         <tr>
	               <td class="label">
	                   c. Does the NMS Stock ATS accept or execute odd-lot orders?   	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item8cIsOddLotsAcptdExecutd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item8cOddltOrdrReqs/@rbPart3Item8cIsOddLotsAcptdExecutd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check c is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item8cOddltOrdrReqs/@rbPart3Item8cIsOddLotsAcptdExecutd) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, specify any odd-lot order requirements and related handling procedures (<u>e.g.,</u> odd-lot treated the same as round lot).  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item8cOddltOrdrReqs/m1:taPart3Item8cOddLtOrdrReqsnProcdurs)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	      </tr>
	       <tr> 
			      <td class="label">
					  d. If yes to Item 8(c), are the requirements and procedures required to be identified in Item 8(c) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item8cOddltOrdrReqs/m1:part3Item8dOddLtOrdrReqsnProcdurDtls/@rbPart3Item8dIsReqsProcdurSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item8cOddltOrdrReqs/m1:rbPart3Item8dIsReqsProcdurSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check d is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item8cOddltOrdrReqs/m1:part3Item8dOddLtOrdrReqsnProcdurDtls/@rbPart3Item8dIsReqsProcdurSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item8cOddltOrdrReqs/m1:part3Item8dOddLtOrdrReqsnProcdurDtls/m1:taPart3Item8dReqProcdurDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check c is Y END -->
	         
	         
	       <tr>
	               <td class="label">
	                   e. Does the NMS Stock ATS accept or execute mixed-lot orders?    	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item8eIsMixLotOrdrsAcptdExecutd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item8eMixltOrdrDetails/@rbPart3Item8eIsMixLotOrdrsAcptdExecutd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check e is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item8eMixltOrdrDetails/@rbPart3Item8eIsMixLotOrdrsAcptdExecutd) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, specify any mixed lot order requirements and related handling procedures (e.g., mixed lot treated the same as round lot).  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item8eMixltOrdrDetails/m1:taPart3Item8eMixltOrdrReqsProcDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	      </tr>
	       <tr> 
			      <td class="label">
					  f. If yes, to Item 8(e), are the requirements and procedures required to be identified in 8(e) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item8eMixltOrdrDetails/m1:part3Item8fRPDetails/@rbPart3Item8fIsRecProcSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item8eMixltOrdrDetails/m1:rbPart3Item8fIsRecProcSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check f is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item8eMixltOrdrDetails/m1:part3Item8fRPDetails/@rbPart3Item8fIsRecProcSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item8eMixltOrdrDetails/m1:part3Item8fRPDetails/m1:taPart3Item8fReqProcDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check f is N END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check e is Y END -->

	   </table>
	 </xsl:template>
                     <!--  template item8 End -->
	<!-- ********************************************************** -->		    
	
	
	<xsl:template name="item9_partIII">
	   <table role="presentation"> 
	   
	       <tr>
	               <td class="label">
	                   a. Does the NMS Stock ATS send or receive any messages indicating trading interest (e.g., IOIs, actionable IOIs, or conditional orders)?  	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item9aIsAnyMsgToIndicTI" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item9aMsgDtls/@rbPart3Item9aIsAnyMsgToIndicTI" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item9aMsgDtls/@rbPart3Item9aIsAnyMsgToIndicTI) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, identify and explain the use of the messages, including information contained in messages (<u>e.g.,</u> price or size minimums), how the message is transmitted (<u>e.g.,</u> order management system, smart order router, FIX), when the message is transmitted (<u>e.g.,</u> automatically by the ATS, or upon the sender's request), the type of Persons that receive the message (<u>e.g.,</u> Subscribers, Trading Centers), responses to conditional orders or IOIs (<u>e.g.,</u> submission to firm-up conditional orders), and the conditions under which the message might result in an execution in the ATS (<u>e.g.,</u> response time parameters, interaction, and matching).   
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item9aMsgDtls/m1:taPart3Item9aMsgUsgDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	       </tr>
	       
	       
	         
	       <tr> 
	       
			      <td class="label">
					  b. If yes to Item 9(a), are the terms and conditions governing conditional orders and indications of interest the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item9bMsgDtls/@rbPart3Item9bIsIndIntrstSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item9bIsIndIntrstSameForAll" />
				      </xsl:call-template>
				  </td>     
		  </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item9bMsgDtls/@rbPart3Item9bIsIndIntrstSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item9bMsgDtls/m1:taPart3Item9bMsgUsgDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	        
	        
	            </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	       
	        
 
	   </table>
	</xsl:template>
	                 <!--  template item9 End -->
	<!-- ********************************************************** -->		
	
	
	<xsl:template name="item10_partIII">
	   <table role="presentation">
	       <tr>
	               <td class="label">
	                   a. Explain how the NMS Stock ATS opens or re-opens for trading, including when and how orders and trading interest are priced, prioritized, matched, and executed, and identify any order types allowed prior to the start of regular trading hours or following a stoppage of trading in a security during regular trading hours.
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item10aOpenReOpenDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	        </tr>
	        <tr> 
			      <td class="label">
					  b. Are the processes and procedures governing opening and re-opening the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item10bOpnReOpnProcDtls/@rbPart3Item10bIsOpnReopnSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item10bIsOpnReopnSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item10bOpnReOpnProcDtls/@rbPart3Item10bIsOpnReopnSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item10bOpnReOpnProcDtls/m1:taPart3Item10bOpnReOpenDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	         
	       <tr>
	              <td class="label">
	                   c. Explain how unexecuted orders and trading interest are handled at the time the NMS Stock  ATS begins regular trading at the start of regular trading hours or following a stoppage of trading in a security during regular trading hours.  
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item10cUnexeOrdrTIDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	       </tr>
	       <tr> 
			      <td class="label">
					  d. Are the processes or procedures governing unexecuted orders and trading at the time the NMS Stock ATS begins regular trading at the start of regular trading hours, or following a stoppage of trading in a security during regular trading hours, the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item10dDiffDtls/@rbPart3Item10dIsAnyDifBtwnExeProcTrdHrs" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item10dIsAnyDifBtwnExeProcTrdHrs" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			       <!--  check d is N -->
			       <xsl:choose>
			             <xsl:when test="string(m1:partThree/m1:part3Item10dDiffDtls/@rbPart3Item10dIsAnyDifBtwnExeProcTrdHrs) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item10dDiffDtls/m1:taPart3Item10dDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			             </xsl:when>
			       </xsl:choose>
			       <!--  check d is N END-->
	   
	        <tr>
	              <td class="label">
	                   e. Are there any differences between pre-opening executions, executions following a stoppage of trading in a security during regular trading hours, and/or executions during regular trading hours?  	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item10eIsAnyDifBtwnPreOpExecFlwngStpg" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item10eDiffDtls/@rbPart3Item10eIsAnyDifBtwnPreOpExecFlwngStpg" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	              <!--  check e is Y -->
	              <xsl:choose>
		                 <xsl:when
						          test="string(m1:partThree/m1:part3Item10eDiffDtls/@rbPart3Item10eIsAnyDifBtwnPreOpExecFlwngStpg) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, identify and explain the differences.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item10eDiffDtls/m1:taPart3Item10eDiffDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	       </tr>
	                    </xsl:when>
	             </xsl:choose>
	           <!--  check e is Y END -->
	  </table>
    </xsl:template>
                    <!--  template item10 End -->
	<!-- ********************************************************** -->	
	
	<xsl:template name="item11_partIII">
	    
	  <table role="presentation">
	       <tr>
	              <td class="label">
	                   a. Provide a summary of the structure of the NMS Stock ATS marketplace (<u>e.g.,</u> crossing system, auction market, limit order matching book) and explain the means and facilities for bringing together the orders of multiple buyers and sellers on the NMS Stock ATS.
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item11aStrucOfNmsStk)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	       </tr>
	       <tr> 
			      <td class="label">
					  b. Are the means and facilities required to be identified in Item 11(a) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item11bMeansFeciltsDtls/@rbPart3Item11bIsMeansFeciltsSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item11bIsMeansFeciltsSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item11bMeansFeciltsDtls/@rbPart3Item11bIsMeansFeciltsSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item11bMeansFeciltsDtls/m1:taPart3Item11bMeansFeciltsDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	    
	       <tr>
	              <td class="label">
	                   c. Explain the established, non-discretionary rules and procedures of the NMS Stock ATS, including order interaction rules for the priority, pricing methodologies, allocation, matching, and execution of orders and trading interest, and other procedures governing trading, such as price improvement functionality, price protection mechanisms, short sales, locked-crossed markets, the handling of execution errors, and the time-stamping of orders and executions.
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item11cRulsProcsOfNmsStk)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	       </tr>
	       
	       <tr> 
			      <td class="label">
					  d. Are the established, non-discretionary rules and procedures required to be identified in Item 11(c) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item11dDiffDtls/@rbPart3Item11dIsProcsRulsSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item11dIsProcsRulsSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check d is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item11dDiffDtls/@rbPart3Item11dIsProcsRulsSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item11dDiffDtls/m1:taPart3Item11dDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check d is N END-->
	   
	    </table>
	</xsl:template>
	          <!--  template item11 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item12_partIII">
	    
	   <table role="presentation">
	  
	       <tr>
	              <td class="label">
	                   Are there any formal or informal arrangements with any Subscriber or the Broker-Dealer Operator to provide orders, or trading interest to the NMS Stock ATS (<u>e.g.,</u> undertaking to buy or sell continuously, or to meet specified thresholds of trading or quoting activity)?  	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item12aIsAnyFrmlInfrmlArngmnts" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item12aArngmntDtls/@rbPart3Item12aIsAnyFrmlInfrmlArngmnts" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	              <!--  check a is Y -->
	              <xsl:choose>
		                 <xsl:when
						          test="string(m1:partThree/m1:part3Item12aArngmntDtls/@rbPart3Item12aIsAnyFrmlInfrmlArngmnts) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, describe the arrangement, including the terms and conditions.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item12aArngmntDtls/m1:taPart3Item12aArngmntTCDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	       </tr>
	                    </xsl:when>
	             </xsl:choose>
	           <!--  check a is Y END -->
	  
	   </table>
    </xsl:template>
	  
		          <!--  template item12 End -->
<!-- ********************************************************** -->	

	
	<xsl:template name="item13_partIII">
	    
	   <table role="presentation">
	   
	       <tr>
	              <td class="label">
	                   a. Are orders and trading interest in the NMS Stock ATS segmented into categories, classifications, tiers, or levels (<u>e.g.,</u> segmented by type of participant, order size, duration, source, or nature of trading activity)?     	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item13aIsOrdrTiSegmntd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item13aSegmntDtls/@rbPart3Item13aIsOrdrTiSegmntd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item13aSegmntDtls/@rbPart3Item13aIsOrdrTiSegmntd) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, explain the segmentation procedures, including (i) a description for how orders and trading interest are segmented; (ii) identify and describe any categories, classification, tiers, or levels and the types of orders and trading interest that are included in each; (iii) provide a summary of the parameters for each segmented category and length of time each segmented category is in effect; (iv) any procedures for overriding a determination of segmented category; and (v) how segmentation can affect order interaction.   
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item13aSegmntDtls/m1:taPart3Item13aSegProcdurDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	       </tr>
	       <tr> 
			      <td class="label">
					  b. If yes to Item 13(a), is the segmentation of orders and trading interest the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13bSegmntDtls/@rbPart3Item13bIsSegmntatnSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item13aSegmntDtls/m1:rbPart3Item13bIsSegmntatnSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13bSegmntDtls/@rbPart3Item13bIsSegmntatnSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13bSegmntDtls/m1:taPart3Item13bSegDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	         
	       <tr>
				<td class="label">
				     c. Does the NMS Stock ATS identify orders or trading interest entered by a customer of a broker-dealer on the NMS Stock ATS as a customer order?
				</td>
				<td>
					<xsl:call-template name="yesNoRadio">
						<xsl:with-param name="yesNoElement"
							select="m1:partThree/m1:rbPart3Item13cIsCustmrOrdr" />
					</xsl:call-template>
				</td>
		  </tr>
	   
	        <!--  check a is Y -->
	         <xsl:choose>
		         <xsl:when
						test="string(m1:partThree/m1:part3Item13aSegmntDtls/@rbPart3Item13aIsOrdrTiSegmntd) = 'Y'">
         
	       <tr> 
			      <td class="label">
					  d. If yes to Item 13(a), does the NMS Stock ATS disclose to any Person the designated segmented category, classification, tier, or level of orders and trading interest?  
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item13aSegmntDtls/m1:rbPart3Item13dIsSegCatgDisclosd" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/@rbPart3Item13dIsSegCatgDisclosd" />
				      </xsl:call-template>
				  </td>     
		   </tr>
		              <!--  check d is Y-->
		              <xsl:choose>
		                 <xsl:when
					           	     test="string(m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/@rbPart3Item13dIsSegCatgDisclosd) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, provide a summary of the content of the disclosure, when and how the disclosure is communicated, who receives it, and whether and how such designation can be contested.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/m1:taPart3Item13dDsclosrContntDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	       </tr>
	      <tr> 
			      <td class="label">
					  e. If yes to Item 13(d), are the disclosures required to be identified in 13(d) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/m1:part3Item13eArngmntDtls/@rbPart3Item13eIsDsclosrSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/m1:rbPart3Item13eIsDsclosrSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
		                                  <!--  check e is N -->
			                              <xsl:choose>
			                                 <xsl:when test="string(m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/m1:part3Item13eArngmntDtls/@rbPart3Item13eIsDsclosrSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item13aSegmntDtls/m1:part3Item13dDsclrContntDtls/m1:part3Item13eArngmntDtls/m1:taPart3Item13eDsclosrDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                               </xsl:when>
			                            </xsl:choose>
			                            <!--  check e is N END-->
		   
		                  </xsl:when>
		               </xsl:choose>
		               <!--  check d is Y END-->
		                   
		         </xsl:when>
		     </xsl:choose>
	        <!--  check a is Y END-->
	 
	   </table>
    </xsl:template>
	
               <!--  template item13 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item14_partIII">
	    
	   <table role="presentation">
	   
	      <tr>
	               <td class="label">
	                   a. Can orders or trading interest be designated to interact or not interact with certain orders or trading interest in the NMS Stock ATS (<u>e.g.,</u> designated to execute against a specific Subscriber's orders or trading interest or prevent a Subscriber's order from executing against itself)?  	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item14aIsDsgToIntrctOrNot" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/@rbPart3Item14aIsDsgToIntrctOrNot" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/@rbPart3Item14aIsDsgToIntrctOrNot) = 'Y'">
           <tr>
				  <td class="label">
				        If yes, explain the counter-party selection procedures, including how counter-parties can be selected, and whether the designations affect the interaction and priority of trading interest in the ATS.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/m1:taPart3Item14aCntrPrtyDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
	       </tr>
	       <tr> 
			      <td class="label">
					  b. If yes to Item 14(a), are the procedures for counter-party selection required to be identified in Item 14(a) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/m1:part3Item14bSelectDtls/@rbPart3Item14bIsSelectnSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/m1:rbPart3Item14bIsSelectnSameForAll" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/m1:part3Item14bSelectDtls/@rbPart3Item14bIsSelectnSameForAll) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item14aCntrPrtySelectnDtls/m1:part3Item14bSelectDtls/m1:taPart3Item14bSelectnDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is N END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	   
	   
	   </table>
	</xsl:template>
	          <!--  template item14 End -->
<!-- ********************************************************** -->	



    <xsl:template name="item15_partIII">
	    
	   <table role="presentation">
	      <tr>
				<td class="label">
				     a. Does the NMS Stock ATS operate as an Electronic Communication Network as defined in Rule 600(b)(23) of Regulation NMS?
				</td>
				<td>
					<xsl:call-template name="yesNoRadio">
						<xsl:with-param name="yesNoElement"
							select="m1:partThree/m1:rbPart3Item15aIsElectrncCommu" />
					</xsl:call-template>
				</td>
		 </tr>
		 
		  <tr>
	               <td class="label">
	                   b. Are Subscriber orders and trading interest bound for or resting in the NMS Stock ATS displayed or made known to any Person (not including those employees of the NMS Stock ATS who are operating the system)?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item15bIsSubScrbOrdBnd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item15bSubSctbDtls/@rbPart3Item15bIsSubScrbOrdBnd" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        
	    <!-- check b Y -->   
	   <xsl:choose>
		  <xsl:when
						test="string(m1:partThree/m1:part3Item15bSubSctbDtls/@rbPart3Item15bIsSubScrbOrdBnd) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, explain the display procedures, including how and when Subscriber orders and trading interest are displayed, how long orders and trading interest are displayed, what information about orders and trading interest is displayed, and the functionality of the Broker-Dealer Operator and types of market participants that receive the displayed information.  
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item15bSubSctbDtls/m1:taPart3Item15bSubscrBndDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			      </td>
			</tr>
			<tr> 
			      <td class="label">
				 	  c. If yes to Item 15(b), are the display procedures required to be identified in 15(b) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item15bSubSctbDtls/m1:part3Item15cDsplyProcDtls/@rbPart3Item15cIsDsplyProcSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item15bSubSctbDtls/m1:rbPart3Item15cIsDsplyProcSameForAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			            <!--  check c is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item15bSubSctbDtls/m1:part3Item15cDsplyProcDtls/@rbPart3Item15cIsDsplyProcSameForAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item15bSubSctbDtls/m1:part3Item15cDsplyProcDtls/m1:taPart3Item5cDsplyProcDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			          <!--  check c is N  END-->
	  
	  
	      </xsl:when>
	   </xsl:choose>
	   <!-- check b Y END--> 
	  </table>
	</xsl:template>
	   
	          <!--  template item15 End -->
<!-- ********************************************************** -->	


    <xsl:template name="item16_partIII">
	
	  <table role="presentation">
	  
	       <tr>
	              <td class="label">
	                   a. Can orders and trading interest in the NMS Stock ATS be routed to a destination outside the NMS Stock ATS?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item16aIsInstRoutd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item16aAffirInstrDtls/@rbPart3Item16aIsInstRoutd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item16aAffirInstrDtls/@rbPart3Item16aIsInstRoutd) = 'Y'">
         
	       <tr> 
			      <td class="label">
					  b. If yes to Item 16(a), must affirmative instructions from a Subscriber be obtained before its orders or trading interest can be routed from the NMS Stock ATS?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item16aAffirInstrDtls/m1:rbPart3Item16bIsRoutdBefrInstr" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item16aAffirInstrDtls/m1:part3Item16bAffirmInstrDtls/@rbPart3Item16bIsRoutdBefrInstr" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is Y -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item16aAffirInstrDtls/m1:part3Item16bAffirmInstrDtls/@rbPart3Item16bIsRoutdBefrInstr) = 'Y'">
		   <tr>	                      
			      <td class="label">
			                  If yes, describe the affirmative instruction and explain how the affirmative instruction is obtained.  If no, explain when orders in the NMS Stock ATS can be routed from the ATS (<u>e.g.,</u> at the discretion of the Broker-Dealer Operator).
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item16aAffirInstrDtls/m1:part3Item16bAffirmInstrDtls/m1:taPart3Item16bAffirmInstrDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is Y END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	         
	 </table>
	</xsl:template>
		        <!--  template item16 End -->
<!-- ********************************************************** -->	


   <xsl:template name="item17_partIII">
	    
	 <table role="presentation">
	    
	      	 <tr>
	               <td class="label">
	                   a. Are there any differences between how orders and trading interest are treated on the NMS Stock ATS during the close and how orders and trading interest are treated during regular trading hours?   
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item17aIsDiffBtwnOrdTITrtmnt" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item17aAffirInstrDtls/@rbPart3Item17aIsDiffBtwnOrdTITrtmnt" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item17aAffirInstrDtls/@rbPart3Item17aIsDiffBtwnOrdTITrtmnt) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, identify and explain the differences as compared to the information provided in the relevant Part III Items of this form.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:part3Item17aAffirInstrDtls/m1:taPart3Item17aTrtmntDiffDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
			</tr>
			 </xsl:when>
			     </xsl:choose>
	             <!--  check a is Y END-->
	             
	        <tr> 
			      <td class="label">
				 	  b. Is the treatment of orders and trading interest during the close the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item17bTrtmntDtls/@rbPart3Item17bIsTrtmntSameForAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item17bIsTrtmntSameForAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			            <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item17bTrtmntDtls/@rbPart3Item17bIsTrtmntSameForAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item17bTrtmntDtls/m1:taPart3Item17bDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			          <!--  check b is N  END-->                                   
	    
	  </table>
    </xsl:template>
	    
		        <!--  template item17 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item18_partIII">
	    
	  <table role="presentation">
	  
	        <tr>
	               <td class="label">
	                   a. Does the NMS Stock ATS conduct trading outside of its regular trading hours?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item18aIsOutsdeTrdingHrs" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item18aTrdingHrDtls/@rbPart3Item18aIsOutsdeTrdingHrs" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        
	    <!-- check a Y -->   
	   <xsl:choose>
		  <xsl:when
						test="string(m1:partThree/m1:part3Item18aTrdingHrDtls/@rbPart3Item18aIsOutsdeTrdingHrs) = 'Y'">
             <tr>
			      <td class="label">
				 	 b. If yes to Item 18(a), are there any differences between trading outside of regular trading hours and trading during regular trading hours in the NMS Stock ATS? 
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item18aTrdingHrDtls/m1:rbPart3Item18bIsAnyDiffInTrdingOutSdHrs" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item18aTrdingHrDtls/m1:part3Item18bOutsdHrsDiffDtls/@rbPart3Item18bIsAnyDiffInTrdingOutSdHrs" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			            <!--  check b is Y -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item18aTrdingHrDtls/m1:part3Item18bOutsdHrsDiffDtls/@rbPart3Item18bIsAnyDiffInTrdingOutSdHrs) = 'Y'">
		    <tr>	                      
			      <td class="label">
			                  If yes, identify and explain the differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item18aTrdingHrDtls/m1:part3Item18bOutsdHrsDiffDtls/m1:taPart3Item18bDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			           <!--  check b is Y END-->
	        <tr>
			      <td class="label">
				 	  c. If yes to Item 18(a), is the treatment of orders and trading interest outside of regular trading hours the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item18aTrdingHrDtls/m1:part3Item18cOutsdHrstrtmntDtls/@rbPart3Item18cIsTrtedDiffOutsdHrs" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item18aTrdingHrDtls/m1:rbPart3Item18cIsTrtedDiffOutsdHrs" />
				      </xsl:call-template>
				  </td>     
			</tr>
			             <!--  check c is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item18aTrdingHrDtls/m1:part3Item18cOutsdHrstrtmntDtls/@rbPart3Item18cIsTrtedDiffOutsdHrs) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item18aTrdingHrDtls/m1:part3Item18cOutsdHrstrtmntDtls/m1:taPart3Item18cTrtmntDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			           <!--  check c is N END-->                                    
	  
	      </xsl:when>
	   </xsl:choose>
	   <!-- check a Y END-->
	 
	  </table>
   </xsl:template>
			        <!--  template item18 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item19_partIII">
	    
	    <table role="presentation">
	         <tr>
	               <td class="label">
	                   a. Identify and describe any fees or charges for use of the NMS Stock ATS services, including the type of fees (<u>e.g.,</u> subscription, connectivity), the structure of the fees (<u>e.g.,</u> fixed, volume-based, transaction-based), variables that impact the fees (<u>e.g.,</u> types of securities traded, block orders, form of connectivity to the ATS), differentiation among types of Subscribers (<u>e.g.,</u> broker-dealers, institutional investors, retail) and range of fees (<u>e.g.,</u> high and low).
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item19aSrvcUsgFees)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	         </tr>
	          <tr>
	               <td class="label">
	                   b. Identify and describe any fees or charges for use of the NMS Stock ATS services that are bundled with the Subscriber's use of non-ATS services or products offered by the Broker-Dealer Operator or its Affiliates, including a summary of the bundled services and products, the structure of the fee, variables that impact the fee, differentiation among types of Subscribers, and range of fees.
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item19bBundldSrvcUsgFees)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	         </tr>
	          <tr>
	               <td class="label">
	                   c. Identify and describe any rebate or discount of fees or charges required to be identified in Items 19(a) and 19(b), including the type of rebate or discount, structure of the rebate or discount, variables that impact the rebate or discount, differentiation among types of Subscribers, and range of rebate or discount.
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item19cRbtDiscOfFees)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	              </td>
	         </tr>
	        
	   </table>
	    
	</xsl:template>
	
				      <!--  template item19 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item20_partIII">
	    
	  <table role="presentation">
	  
	        <tr>
	               <td class="label">
	                   a. Explain any procedures for suspending or stopping trading on the NMS Stock ATS, including the suspension of trading in individual NMS stocks.  
	                </td>   
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item20aSuspndProcdur)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	               </td>
	        </tr>
	         <tr> 
			      <td class="label">
				 	  b. Are the procedures for suspending or stopping trading the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item20bSuspndProcdurDiffDtls/@rbPart3Item20bIsSuspndProcdurSameFrAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item20bIsSuspndProcdurSameFrAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			            <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item20bSuspndProcdurDiffDtls/@rbPart3Item20bIsSuspndProcdurSameFrAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item20bSuspndProcdurDiffDtls/m1:taPart3Item20bDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			          <!--  check b is N  END--> 
 
	  </table>
	</xsl:template>
	  
					   <!--  template item20 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item21_partIII">
	    
	  <table role="presentation">
	        <tr>
	              <td class="label">
	                   a. Explain any procedures and material arrangements for reporting transactions on the NMS Stock ATS, including where an ATS reports transactions and under what circumstances.  
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item21aMtrlArngmntDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	               </td>
	        </tr>
	        <tr>
			      <td class="label">
				 	  b. Are the procedures and material arrangements for reporting transactions on the NMS Stock ATS the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item21bMtrlArngmntDiffDtls/@rbPart3Item21bIsMtrlArngmtSameFrAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item21bIsMtrlArngmtSameFrAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item21bMtrlArngmntDiffDtls/@rbPart3Item21bIsMtrlArngmtSameFrAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item21bMtrlArngmntDiffDtls/m1:taPart3Item21bDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			           <!--  check b is N END--> 
	
	  
	  </table>
   </xsl:template>
	  
					 <!--  template item21 End -->
<!-- ********************************************************** -->	
	
	
	
	
	<xsl:template name="item22_partIII">
	    
	  <table role="presentation">
	        <tr>
	              <td class="label">
	                   a. Describe any procedures and material arrangements undertaken to facilitate the clearance and settlement of transactions on the NMS Stock ATS (<u>e.g.,</u> whether the ATS becomes a counterparty, whether it submits trades to a registered clearing agency, or whether it requires Subscribers to have arrangements with a clearing firm).
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item22aMtrlArngmntDtls)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	               </td>
	        </tr>
	        <tr>
			      <td class="label">
				 	  b. Are the procedures and material arrangements undertaken to facilitate the clearance and settlement of transactions on the NMS Stock ATS the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item22bMtrlArngmntDiffDtls/@rbPart3Item22bIsMtrlArngmtSameFrAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item22bIsMtrlArngmtSameFrAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item22bMtrlArngmntDiffDtls/@rbPart3Item22bIsMtrlArngmtSameFrAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item22bMtrlArngmntDiffDtls/m1:taPart3Item22bDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			           <!--  check b is N END--> 
	
	  
	  </table>
   </xsl:template>
	
	
						 <!--  template item22 End -->
<!-- ********************************************************** -->	
	
	
	
	
	
	<xsl:template name="item23_partIII">
	    
	  <table role="presentation">
	        <tr>
	              <td class="label">
	                   a. Identify the sources of market data used by the NMS Stock ATS (<u>e.g.,</u> proprietary feed from a national securities exchange, feed from the securities information processor ("SIP")), and how the ATS uses market data from these sources to provide the services that it offers, including how the ATS uses market data to determine the NBBO and protected quotes, and display, price, prioritize, execute, and remove orders and trading interest on the ATS.    
	              </td>
	              <td>
	                     <div class="fakeBox3">
								<xsl:value-of select="string(m1:partThree/m1:taPart3Item23aMrktDatSrc)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						 </div>
	               </td>
	        </tr>
	        <tr>
			      <td class="label">
				 	  b. Are the sources of market data and how the NMS Stock ATS uses market data for the services that it offers the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item23bMrktSrcDiffDtls/@rbPart3Item23bIsSrcSameFrAll" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:rbPart3Item23bIsSrcSameFrAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			             <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item23bMrktSrcDiffDtls/@rbPart3Item23bIsSrcSameFrAll) = 'N'">
		    <tr>	                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item23bMrktSrcDiffDtls/m1:taPart3Item23bDiffDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                      </xsl:when>
			            </xsl:choose>			
			           <!--  check b is N END--> 
	
	  
	  </table>
   </xsl:template>
	
	
							 <!--  template item23 End -->
<!-- ********************************************************** -->	
	
	
	
	
		
	<xsl:template name="item24_partIII">
	
	  <table role="presentation">
	  
	       <tr>
	               <td class="label">
	                   a. Has the NMS Stock ATS displayed Subscriber orders to any Person (other than NMS Stock ATS employees) and had an average daily share volume of 5% or more in that NMS stock as reported by an effective transaction reporting plan or disseminated through an automated quotation system during four of the preceding six calendar months?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item24aIsSubScrbrOrdr" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/@rbPart3Item24aIsSubScrbrOrdr" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/@rbPart3Item24aIsSubScrbrOrdr) = 'Y'">
         
	       <tr> 
			      <td class="label">
					  b. If yes to Item 24(a), is the NMS Stock ATS required to comply with Rule 301(b)(3)(ii) of Regulation ATS?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/m1:rbPart3Item24bIsCmplyRule301" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/m1:part3Item24bSubScrbrOrdrDtls/@rbPart3Item24bIsCmplyRule301" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is Y -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/m1:part3Item24bSubScrbrOrdrDtls/@rbPart3Item24bIsCmplyRule301) = 'Y'">
		   <tr>	                      
			      <td class="label">
				              If yes,
			                   <br/>
			                   <br/>
			                  i. Provide the ticker symbol for each such NMS stock displayed during each of the last 6 calendar months;
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/m1:part3Item24bSubScrbrOrdrDtls/m1:taPart3Item24biTickrSymbol" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
		   
		    <tr>	                      
			      <td class="label">
			                  ii. Explain how the ATS displays such orders on a national securities exchange or through a national securities association; and
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/m1:part3Item24bSubScrbrOrdrDtls/m1:taPart3Item24biiDsplyOnNsa" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
		   
		   <tr>	                      
			      <td class="label">
			                  iii. Explain how the ATS provides access to such orders displayed in the national market system equivalent to the access to other orders displayed on that national securities exchange or through a national securities association pursuant to Rule 301(b)(iii) of Regulation ATS.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item24aSubScrbrOrdrDtls/m1:part3Item24bSubScrbrOrdrDtls/m1:taPart3Item24biiIAcesToOrdrInNms" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
		   
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is Y END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	  
	  </table>
	
	</xsl:template>
	
	
					 <!--  template item24 End -->
<!-- ********************************************************** -->	
	
	
	
		
	<xsl:template name="item25_partIII">
	
	  <table role="presentation">
	  
	       <tr>
	               <td class="label">
	                   a. Has the NMS Stock ATS executed 5% or more of the average daily trading volume in an NMS stock as reported by an effective transaction reporting plan or disseminated through an automated quotation system during four of the preceding six calendar months?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item25aIsAvgDlyTradinVolExcd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/@rbPart3Item25aIsAvgDlyTradinVolExcd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/@rbPart3Item25aIsAvgDlyTradinVolExcd) = 'Y'">
         
	       <tr> 
			      <td class="label">
					  b. If yes to Item 25(a), is the NMS Stock ATS required to comply with Rule 301(b)(5)(ii) of Regulation ATS?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/m1:rbPart3Item25bIsCmplyRule301" />
						 <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/m1:part3Item25bAccessDtls/@rbPart3Item25bIsCmplyRule301" />
				      </xsl:call-template>
				  </td>     
		   </tr>
			
			             <!--  check b is Y -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/m1:part3Item25bAccessDtls/@rbPart3Item25bIsCmplyRule301) = 'Y'">
		   <tr>	                      
			      <td class="label">
				               If yes,
			                   <br/>
			                   <br/>
			                  i. Provide the ticker symbol for each such NMS stock during each of the last 6 calendar months; and
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/m1:part3Item25bAccessDtls/m1:taPart3Item25biTickrSymbol" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
		   
		    <tr>	                      
			      <td class="label">
			                  ii. Describe the written standards for granting access to trading on the ATS pursuant to Rule 301(b)(5)(ii)(A) of Regulation ATS. 
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partThree/m1:part3Item25aSubScrbrOrdrDtls/m1:part3Item25bAccessDtls/m1:taPart3Item25biiDWrtnStndrds" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
		   
		 
		   
			                      </xsl:when>
			            </xsl:choose>
			            <!--  check b is Y END-->
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	  
	  </table>
	
	</xsl:template>
	
					 <!--  template item25 End -->
<!-- ********************************************************** -->	
	
	
	<xsl:template name="item26_partIII">
	
	  <table role="presentation">
	  
	       <tr>
	               <td class="label">
	                   Does the NMS Stock ATS publish or otherwise provide to one or more Subscribers aggregate platform-wide order flow and execution statistics of the ATS that are not otherwise required disclosures under Rule 605 of Regulation NMS?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partThree/m1:rbPart3Item26IsOrdrFloExecStatsPublshd" />
						    <xsl:with-param name="yesElement" select="m1:partThree/m1:part3Item26PlatFrmData/@rbPart3Item26IsOrdrFloExecStatsPublshd" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	       
	       </table>
	       
	      <table role="presentation">
	           
	            <!--  check a is Y -->
	           <xsl:choose>
		          <xsl:when
						test="string(m1:partThree/m1:part3Item26PlatFrmData/@rbPart3Item26IsOrdrFloExecStatsPublshd) = 'Y'">
         
         
	       <tr> 
	       
	       
	       
	     
			   <div class="information">
			       <p>
				   <br/>
	               If yes,
			        <br/>
			        <br/>
				      i. Attach, as Exhibit 4, the most recent disclosure of aggregate platform-wide order flow and execution statistics of the ATS that are not otherwise required disclosures under Rule 605 of Regulation NMS and that the ATS provided to one or more Subscribers as of the end of each calendar quarter.
				      <br/><br/>
		
				         Attach / Remove / View Exhibit 4
				       <br/><br/> 
				        <xsl:choose>
					        <xsl:when test="string(m1:partThree/m1:part3Item26PlatFrmData/m1:cbPart3Item26iInfoRqstdUndrExbt4AvlblAtWebst)= 'true'">
						          <img src="Images/box-checked.jpg" alt="Checkbox checked" />
					        </xsl:when>
				            <xsl:otherwise>
						           <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
					        </xsl:otherwise>
				       </xsl:choose>
				         Select if, in lieu of filing, <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> certifies that the information requested under Exhibit 4 is available at the website provided in Part I, Item 6 of this form and is accurate as of the date of this filing. &#160;&#160;&#160;&#160;
				      						
				       <br/>					
			       </p>
		       </div>  
		       
		       
		       
		   </tr>
			
			  <tr> 
			   <div class="information">
			       <p>
				      ii. Attach, as Exhibit 5, a list and explanation of the categories or metrics for the aggregate platform-wide order flow and execution statistics provided as Exhibit 4 and explain the criteria or methodology used to calculate aggregate platform-wide order flow and execution statistics. 
				      <br/><br/>
		
				         Attach / Remove / View Exhibit 5
				       <br/><br/> 
				        <xsl:choose>
					        <xsl:when test="string(m1:partThree/m1:part3Item26PlatFrmData/m1:cbPart3Item26iiInfoRqstdUndrExbt5AvlblAtWebst) = 'true'">
						          <img src="Images/box-checked.jpg" alt="Checkbox checked" />
					        </xsl:when>
				            <xsl:otherwise>
						           <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
					        </xsl:otherwise>
				       </xsl:choose>
				         Select if, in lieu of filing, <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> certifies that the information requested 
                                   under Exhibit 5 is available at the website provided in Part I, Item 6 of this form and is accurate as of the date of this filing.  &#160;&#160;&#160;&#160;
				      						
				       <br/>					
			       </p>
		       </div>  
		   </tr>
			       
	  
	             </xsl:when>
	         </xsl:choose>
	         <!--  check a is Y END -->
	  
	  </table>
	
	</xsl:template>
	
	
					 <!--  template item26 End -->
<!-- ********************************************************** -->	
	
	
</xsl:stylesheet>