<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>

<xsl:stylesheet 
    version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:m1="http://www.sec.gov/edgar/atsn"
	
	xmlns:com="http://www.sec.gov/edgar/common"
    xmlns:acom="http://www.sec.gov/edgar/atsncommon">
	
	
	
	 <xsl:template name="PartII">
	
  <br/>
	<h4>Item 1: <u>Broker-Dealer Operator Trading Activities on the ATS</u></h4>
		<!--  call item1 template here -->
		<xsl:call-template name="item1_partII"/>
  <br/>		
		<h4>Item 2: <u>Affiliates Trading Activities on the ATS</u></h4>
		<!--  call item2 template here -->
		<xsl:call-template name="item2_partII"/>
  <br/>
		<h4>Item 3: <u>Order Interaction with Broker-Dealer Operator; Affiliates</u></h4>
		<!--  call item3 template here -->
		<xsl:call-template name="item3_partII"/>
  <br/>
		<h4>Item 4: <u>Arrangements with Trading Centers</u></h4>
		<!--  call item4 template here -->
		<xsl:call-template name="item4_partII"/>
  <br/>
		<h4>Item 5: <u>Other Products and Services</u></h4>
		<!--  call item5 template here -->
		<xsl:call-template name="item5_partII"/>
  <br/>
		<h4>Item 6: <u>Activities of Service Providers</u></h4>
		<!--  call item6 template here -->
		<xsl:call-template name="item6_partII"/>
  <br/>
		<h4>Item 7: <u>Protection of Confidential Trading Information</u></h4>
		<!--  call item7 template here -->
		<xsl:call-template name="item7_partII"/>
  <br/>
	</xsl:template>
	
	
	
	
	<!--  template item1 -->
	
	<xsl:template name="item1_partII">
	    <table role="presentation">
	         <tr>
	               <td class="label">
	                  a. Are business units of the Broker-Dealer Operator permitted to enter or direct the entry of orders and trading interest (e.g., quotes, conditional orders, or indications of interest) into the NMS Stock ATS?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item1aArePermittedToEnterInterest" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/@rbPart2Item1aArePermittedToEnterInterest" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        
	    <!-- check a Y -->   
	   <xsl:choose>
		  <xsl:when
						test="string(m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/@rbPart2Item1aArePermittedToEnterInterest) = 'Y'">
			
			
					
						
            <tr>
				  <td class="label">
				        If yes, name and describe each type of business unit of the Broker-Dealer Operator that enters or directs the entry of orders and trading interest into the ATS (<u>e.g.,</u> NMS Stock ATS, type of trading desks, market maker, sales or client desk) and, for each business unit, provide the applicable MPID and list the capacity of its orders and trading interest (e.g., principal, agency, riskless principal).
				  </td>
				  
			  
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:taPart2Item1aUnitNamesEnterInterest)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			
			    
			</tr>
			
			
			
			<tr> 
			      <td class="label">
							b. If yes to Item 1(a), are the services that the NMS Stock ATS offers and provides to the business units required to be identified in Item 1(a) the same for all Subscribers?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:part2Item1bAreSevicesSametoAllSubscribers/@rbPart2Item1bAreSevicesSametoAllSubscribers" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:rbPart2Item1bAreSevicesSametoAllSubscribers" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			            <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:part2Item1bAreSevicesSametoAllSubscribers/@rbPart2Item1bAreSevicesSametoAllSubscribers) = 'N'">
		   <tr>	                      
			      <td class="label">
			                  If no, explain any differences in response to the applicable Item number in Part III of this form, as required, and list the applicable Item number here.  If there are differences that are not applicable to Part III, explain those differences here.
				  </td>
				  
				  
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:part2Item1bAreSevicesSametoAllSubscribers/m1:taPart2Item2bExplainDiff" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
				 
		   </tr>
			                      </xsl:when>
			            </xsl:choose>			
			          <!--  check b is N  END-->
		
			   <!-- continue c part check a response -->
			<tr>   
			    
			      <td class="label">
						     c. Are there any formal or informal arrangements with any of the business units required to be identified in Item 1(a) to provide orders or trading interest to the NMS Stock ATS (<u>e.g.,</u> undertaking to buy or sell continuously, or to meet specified thresholds of trading or quoting activity)?
				  </td>
				  <td>
					    <xsl:call-template name="condYesNoRadio">
					        	<xsl:with-param name="noElement" select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:rbPart2Item1cAreThereArrangements" />
						        <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:part2Item1cAreThereArrangements/@rbPart2Item1cAreThereArrangements" />
					    </xsl:call-template>
			      </td>
			</tr> 
			   
			          <!--  check c is Y -->
		                <xsl:choose>
					            <xsl:when
						                  test="string(m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:part2Item1cAreThereArrangements/@rbPart2Item1cAreThereArrangements) = 'Y'">
			<tr>
				                  
		          <td class="label">
			      
			                If yes, identify the business unit and respond to the request in Part III, Item 12 of this form.     
			        
			      </td>
			      <td>
			               <div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item1aArePermittedToEnterInterest/m1:part2Item1cAreThereArrangements/m1:taPart2Item1cUnitsWithArrangements" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						   </div>
			      </td>
			    
			</tr>    
			                   </xsl:when>
			            </xsl:choose>
			            <!--  check c is Y END-->
			
		  </xsl:when>
	     </xsl:choose>
	     <!--check a is Y END -->
	     
	         <!--  section d is not related to a -->
	        <tr>
			     <td class="label">
					        d. Can orders and trading interest in the NMS Stock ATS be routed to a Trading Center operated or controlled by the Broker-Dealer Operator?
				 </td>
				 <td>
					   <xsl:call-template name="yesNoRadio">
						   <xsl:with-param name="yesNoElement"
						          	select="m1:partTwo/m1:rbPart2Item1dCanOATInterestBeRouted" />
					   </xsl:call-template>
				 </td>
		  </tr> 
		  
		              <xsl:choose>
					            <xsl:when
						                  test="string(m1:partTwo/m1:rbPart2Item1dCanOATInterestBeRouted) = 'Y'">
			<tr>
				 <td class="label">
				    If yes, respond to request in Part III, Item 16 of this form.                  
		          
			    </td> 
			 
			</tr>    
			                   </xsl:when>
			            </xsl:choose>
		  
		  
		  
		  
		  
		  
	   </table>
	
    </xsl:template>
	<!--  template item1 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item2_partII">
	  <table role="presentation">
	
	       <tr>
	         
	              <td class="label">
	                   a. Are Affiliates of the Broker-Dealer Operator permitted to enter or direct the entry of orders and trading interest into the NMS Stock ATS?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item2aAreAfflPermittedToEnterInterest" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/@rbPart2Item2aAreAfflPermittedToEnterInterest" />
				    	</xsl:call-template>
	           </td>
	       </tr>
	  
	  <!--  check A is Y -->     
	   <xsl:choose>
		 <xsl:when
						test="string(m1:partTwo/m1:affiliatesPermittedToEnterInterest/@rbPart2Item2aAreAfflPermittedToEnterInterest) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, name and describe each type of Affiliate that enters or directs the entry of orders and trading interest into the ATS (<u>e.g.,</u> broker-dealer, NMS Stock ATS, investment company, hedge fund, market maker, principal trading firm), and, for each Affiliate, provide the applicable MPID and list the capacity of its orders and trading interest (e.g., principal, agency, riskless principal).
				    
				  </td>
				  <td>
						    
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:taPart2Item2aAfflThatEnterInterest)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
				  </td>
		   </tr>
	
	       	<tr> 
			      <td class="label">
							
							b. If yes, to Item 2(a), are the services that the NMS Stock ATS offers and provides to the Affiliates required to be identified in Item 2(a) the same for all Subscribers?
			     </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:part2Item2bAreSevicestoAfflSametoSubscribers/@rbPart2Item2bAreSevicestoAfflSametoSubscribers" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:rbPart2Item2bAreSevicestoAfflSametoSubscribers" />
				      </xsl:call-template>
			  </td>     
		   </tr>
		   
			              <!--  check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:part2Item2bAreSevicestoAfflSametoSubscribers/@rbPart2Item2bAreSevicestoAfflSametoSubscribers) = 'N'">
			<tr>       
			      <td class="label">
			                  If no, explain any differences in response to the applicable Item number in Part III of this form, as required, and list the applicable Item number here.  If there are differences that are not applicable to Part III, explain those differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:part2Item2bAreSevicestoAfflSametoSubscribers/m1:taPart2Item2bExplainDiff" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
			</tr>
			                      </xsl:when>
			            </xsl:choose>			
			             <!--  check b is N END-->
		
			
			   <!-- continue c part check a response -->
			<tr>    
			      <td class="label">
						     c. Are there any formal or informal arrangements with an Affiliate required to be  identified in Item 2(a) to provide orders or trading interest to the NMS Stock ATS (<u>e.g.,</u> undertaking to buy or sell continuously, or to meet specified thresholds of trading or quoting activity)?
				  </td>
				  <td>
					    <xsl:call-template name="condYesNoRadio">
					        	<xsl:with-param name="noElement" select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:rbPart2Item2cAreThereArrangementsWithAffl" />
						        <xsl:with-param name="yesElement" select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:part2Item2cAnyFrmlInfrmlArrngmnts/@rbPart2Item2cAreThereArrangementsWithAffl" />
					    </xsl:call-template>
			      </td>
			</tr> 
			   
			          <!--  check  c is Y -->
		                <xsl:choose>
					             <xsl:when
						                  test="string(m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:part2Item2cAnyFrmlInfrmlArrngmnts/@rbPart2Item2cAreThereArrangementsWithAffl) = 'Y'">
		    <tr>          
			             
			      <td class="label">
			      
			                If yes, identify the Affiliate and respond to the request in Part III, Item 12 of this form.    
			      </td>
			      <td>
			               <div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:affiliatesPermittedToEnterInterest/m1:part2Item2cAnyFrmlInfrmlArrngmnts/m1:taPart2Item2cYesAfflteDtls" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						   </div>
			      </td>
			 </tr>     
			                 </xsl:when>
			            </xsl:choose>  
			            <!--  check  c is Y END-->
			
	    </xsl:when>
	  </xsl:choose>
	  <!--  check a is Y END -->
	  
	       <!--  section d is not related to a -->
	        <tr>
			     <td class="label">
					        d. Can orders and trading interest in the NMS Stock ATS be routed to a Trading Center operated or controlled by an Affiliate of the Broker-Dealer Operator?
				 </td>
				 <td>
					   <xsl:call-template name="yesNoRadio">
						   <xsl:with-param name="yesNoElement"
						          	select="m1:partTwo/m1:rbPart2Item2dCanOATIBeRoutedByAffl" />
					   </xsl:call-template>
				 </td>
		    </tr> 
		    
		             <xsl:choose>
					            <xsl:when
						                  test="string(m1:partTwo/m1:rbPart2Item2dCanOATIBeRoutedByAffl) = 'Y'">
			<tr>
				 <td class="label">
				    If yes, respond to the request in Part III, Item 16 of this form.                  
		          
			    </td> 
			 
			</tr>    
			                   </xsl:when>
			            </xsl:choose>
	 </table>
   </xsl:template>
	<!--  template item2 End -->
	
<!-- ********************************************************** -->
	
	
	
	
	<xsl:template name="item3_partII">
	
	   <table role="presentation">
	         <tr>
	              <td class="label">
	                  a. Can any Subscriber opt out from interacting with orders and trading interest of the Broker-Dealer Operator in the NMS Stock ATS?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item3aCanSubscrOptOutWithOATIOfBD" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfBD/@rbPart2Item3aCanSubscrOptOutWithOATIOfBD" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	   
	   <!--  check a is Y  -->     
	  <xsl:choose>
	     <xsl:when
				   test="string(m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfBD/@rbPart2Item3aCanSubscrOptOutWithOATIOfBD) = 'Y'">
			<tr>
			      <td class="label">
				        If yes, explain the opt-out process.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfBD/m1:taPart2Item3aExplianOptOut)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
		
			</tr>	   
	       
	     </xsl:when>
	  </xsl:choose> 
	  <!--  check a is Y END -->  
	  
	         <tr>
	              <td class="label">
	                  b. Can any Subscriber opt out from interacting with the orders and trading interest of an Affiliate of the Broker-Dealer Operator in the NMS Stock ATS?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item3aCanSubscrOptOutWithOATIOfAffl" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfAffl/@rbPart2Item3aCanSubscrOptOutWithOATIOfAffl" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	          
		          	    <!--  check b is Y -->
		                 <xsl:choose>
					            <xsl:when
						                  test="string(m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfAffl/@rbPart2Item3aCanSubscrOptOutWithOATIOfAffl) = 'Y'">
		     <tr>     
			             
			      <td class="label">
			      
			                If yes, explain the opt-out process.    
			      </td>
			      <td>
			               <div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfAffl/m1:taPart2Item3bExplianOptOut" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						   </div>
			      </td>
			  </tr>
			                 </xsl:when>
			            </xsl:choose>  
			          <!--  check b is Y END-->
	        
	        <xsl:choose>
					            <xsl:when
						                  test="string(m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfBD/@rbPart2Item3aCanSubscrOptOutWithOATIOfBD) = 'Y' or string(m1:partTwo/m1:part2Item3aCanSubscrOptOutWithOATIOfAffl/@rbPart2Item3aCanSubscrOptOutWithOATIOfAffl)='Y'" >  
	      
	                 
            <tr>
				  <td class="label">
						     c. If yes to Item 3(a) or 3(b), are the terms and conditions of the opt-out processes required to be identified in Item 3(a),  3(b), or both,  the same for all Subscribers?
				  </td>
				  <td>
					    <xsl:call-template name="condYesNoRadio">
					        	<xsl:with-param name="noElement" select="m1:partTwo/m1:part2Item3cAreOptOutSametoAllSubscribers/@rbPart2Item3cAreOptOutSametoAllSubscribers" />
						        <xsl:with-param name="yesElement" select="m1:partTwo/m1:rbPart2Item3cAreOptOutSametoAllSubscribers" />
					    </xsl:call-template>
			      </td>
		   </tr>
	        
			                     <!--  check c is N-->
			                       <xsl:choose>
			                             <xsl:when test="string(m1:partTwo/m1:part2Item3cAreOptOutSametoAllSubscribers/@rbPart2Item3cAreOptOutSametoAllSubscribers) = 'N'">
			<tr>                       
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item3cAreOptOutSametoAllSubscribers/m1:taPart2Item3cExplainDiff" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
		          </td> 
		    </tr>
			                           </xsl:when>
			                      </xsl:choose>			
		                        <!--  check c is N END-->
	                         </xsl:when>
	       </xsl:choose>                 
	              
        </table>
	
	</xsl:template>
	<!--  Item3 End -->
	<!-- ********************************************************** -->
	
	
	
	<xsl:template name="item4_partII">
	   
	   <table role="presentation">
	      
	        <tr>
	               <td class="label">
	                  a. Are there any formal or informal arrangements (<u>e.g.,</u> mutual, reciprocal, or preferential access arrangements) between the Broker-Dealer Operator and a Trading Center to access the NMS Stock ATS services (<u>e.g.,</u> arrangements to effect transactions or to submit, disseminate, or display orders and trading interest in the ATS)?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item4aAreThereArrangementsBtwBDAndTC" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/@rbPart2Item4aAreThereArrangementsBtwBDAndTC" />
				    	</xsl:call-template>
	              </td>
	       </tr>
	    
	    <!-- check a is Y  -->    
	     <xsl:choose>
		   <xsl:when
						test="string(m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/@rbPart2Item4aAreThereArrangementsBtwBDAndTC) = 'Y'">
             <tr>
				  <td class="label">
				        If yes, identify the Trading Center and the ATS services and provide a summary of the terms and conditions of the arrangement.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/m1:taPart2Item4aTDAndATSServices)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			      </td>
			</tr>
			<tr> 
			      <td class="label">
							b. If yes to Item 4(a), are there any formal or informal arrangements between an Affiliate of the Broker-Dealer Operator and a Trading Center to access the NMS Stock ATS services?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/m1:rbPart2Item4bAreThereArrangementsBtwAfflAndTC" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/m1:part2Item4bAreThereArrangementsBtwAfflAndTC/@rbPart2Item4bAreThereArrangementsBtwAfflAndTC" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			               <!-- check b is Y  --> 
			              <xsl:choose>
			                      <xsl:when test="string(m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/m1:part2Item4bAreThereArrangementsBtwAfflAndTC/@rbPart2Item4bAreThereArrangementsBtwAfflAndTC) = 'Y'">
			<tr>                      
			      <td class="label">
			                  If yes, identify the Trading Center and ATS services and provide a summary of the terms and conditions of the arrangement.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item4aAreThereArrangementsBtwBDAndTC/m1:part2Item4bAreThereArrangementsBtwAfflAndTC/m1:taPart2Item4bTDAndATSServices" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td>
		    </tr> 
			                      </xsl:when>
			             </xsl:choose>			
			             <!-- check b is Y END -->
			
		   </xsl:when>
		 </xsl:choose>
		<!-- check a is Y END -->   
		
	   </table>
	
	</xsl:template>
	
	<!--  Item4 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item5_partII">
	
	  <table role="presentation">
	        <tr>
	               <td class="label">
	                  a. Does the Broker-Dealer Operator offer Subscribers any products or services for the purpose of effecting transactions or submitting, disseminating, or displaying orders and trading interest in the NMS Stock ATS (<u>e.g.,</u> algorithmic trading products that send orders to the ATS, order management or order execution systems, data feeds regarding orders and trading interest in, or executions occurring on, the ATS)?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item5aDoesOfferProductsAndServices" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/@rbPart2Item5aDoesOfferProductsAndServices" />
				    	</xsl:call-template>
	              </td>
	        </tr> 
	    
	    <!-- check a is Y -->    
	    <xsl:choose>
		  <xsl:when
						test="string(m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/@rbPart2Item5aDoesOfferProductsAndServices) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, identify the products or services offered, provide a summary of the terms and conditions for use, and list here the applicable Item number in Part III of this form where the use of the product or service is explained. If there is no applicable Item in Part III, explain the use of the product or service with the ATS here.
				  </td>
				  
		
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/m1:taPart2Item5aProductsAndServices" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			
			</tr>
			<tr> 
			      <td class="label">
							b. If yes to Item 5(a), are the terms and conditions of the services or products required to be identified in Item 5(a) the same for all Subscribers and the Broker-Dealer Operator?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/m1:part2Item5bAreSevicesSametoAllSubscribersAndBD/@rbPart2Item5bAreSevicesSametoAllSubscribersAndBD" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/m1:rbPart2Item5bAreSevicesSametoAllSubscribersAndBD" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			               <!-- check b is N -->
			              <xsl:choose>
			                      <xsl:when test="string(m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/m1:part2Item5bAreSevicesSametoAllSubscribersAndBD/@rbPart2Item5bAreSevicesSametoAllSubscribersAndBD) = 'N'">
			<tr>                      
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item5aDoesOfferProductsAndServices/m1:part2Item5bAreSevicesSametoAllSubscribersAndBD/m1:taPart2Item5bExplainDiff" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		   </tr>
			                      </xsl:when>
			             </xsl:choose>
			             <!-- check b is N END -->			
			
			
		  </xsl:when>
	   </xsl:choose>
	   <!-- check a is Y END -->		
	   
	    	<tr> 
			      <td class="label">
							c. Does any Affiliate of the Broker-Dealer Operator offer Subscribers, the Broker-Dealer Operator, or both, any products or services for the purpose of effecting transactions or submitting, disseminating, or displaying orders or trading interest in the NMS Stock ATS?  
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:rbPart2Item5cDoesAfflOfferProductsAndServices" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/@rbPart2Item5cDoesAfflOfferProductsAndServices" />
				      </xsl:call-template>
				  </td>     
			</tr>
			       
			        <!-- check c is Y -->		
			        <xsl:choose>
			           <xsl:when test="string(m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/@rbPart2Item5cDoesAfflOfferProductsAndServices) = 'Y'">
			<tr>                      
			      <td class="label">
			                  If yes, identify the products or services offered, provide a summary of the terms and conditions for use, and list here the applicable Item number in Part III of this form where the use of the product or service is explained.  If there is no applicable item in Part III, explain the use of the product or service with the ATS here.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/m1:taPart2Item5cAfflProvidedProductsAndServices" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
			</tr>	 
			<tr>
			      <td class="label">
	                  d. If yes to Item 5(c), are the terms and conditions of the services or products required to be identified in Item 5(c) the same for all Subscribers and the Broker-Dealer Operator?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/m1:part2Item5dAreTCOfSevicesSametoAll/@rbPart2Item5dAreTCOfSevicesSametoAll" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/m1:rbPart2Item5dAreTCOfSevicesSametoAll" />
				    	</xsl:call-template>
	              </td>
			</tr> 
			
			                  <!-- check d is N -->	
			                  <xsl:choose>
			                     <xsl:when test="string(m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/m1:part2Item5dAreTCOfSevicesSametoAll/@rbPart2Item5dAreTCOfSevicesSametoAll) = 'N'">
			<tr>                     
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item5cDoesAfflOfferProductsAndServices/m1:part2Item5dAreTCOfSevicesSametoAll/m1:taPart2Item5dExplainDiff" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
			</tr>
			                     </xsl:when>
			                 </xsl:choose>			
			               <!-- check d is N END-->	
			     
			            </xsl:when>
			        </xsl:choose>
			        <!-- check c is Y -->				
	
	  </table>
</xsl:template>
	<!--  Item5 End -->
	<!-- ********************************************************** -->
	
	<xsl:template name="item6_partII">
	    <table role="presentation">
	         <tr>
	               <td class="label">
	                  a. Does any employee of the Broker-Dealer Operator or its Affiliate that services both the operations of the NMS Stock ATS and any other business unit or any Affiliate of the Broker-Dealer Operator ("shared employee") have access to confidential trading information on the NMS Stock ATS?	
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item6aDoesEmployeeAccessConfidentialInfo" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item6aDoesEmployeeAccessConfidentialInfo/@rbPart2Item6aDoesEmployeeAccessConfidentialInfo" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        <!-- Check a is Y -->
	        <xsl:choose>
		        <xsl:when
						test="string(m1:partTwo/m1:part2Item6aDoesEmployeeAccessConfidentialInfo/@rbPart2Item6aDoesEmployeeAccessConfidentialInfo) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, identify the business unit, Affiliate, or both that the shared employee services, and provide a summary of the role and responsibilities of the shared employee at the ATS and the business unit, Affiliate, or both that the shared employee services.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item6aDoesEmployeeAccessConfidentialInfo/m1:taPart2Item6aUnitAfflEmployeeServices)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			</tr>
			
	            </xsl:when>
	        </xsl:choose>
	        <!-- Check a is Y  END-->
	        
	        <tr>
	               <td class="label">
	                   b. Does any entity, other than the Broker-Dealer Operator, support the services or functionalities of the NMS Stock ATS ("service provider") that are required to be explained in Part III of this form?
	              </td>
	              <td>
	                    <xsl:call-template name="condYesNoRadio">
						    <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item6bDoesAnyEntitySupportServices" />
						    <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/@rbPart2Item6bDoesAnyEntitySupportServices" />
				    	</xsl:call-template>
	              </td>
	        </tr>
	        
	        <!-- check b is Y -->
	         <xsl:choose>
		       <xsl:when
						test="string(m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/@rbPart2Item6bDoesAnyEntitySupportServices) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, both identify the service provider and provide a summary of the role and responsibilities of the service provider in response to the applicable Item number in Part III of this form, as required. List the applicable Item number here.  If there are services or functionalities that are not applicable to Part III, identify the service provider, the services and functionalities, and also provide a summary of the role and responsibilities of the service provider here.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:taPart2Item6bServiceProvider)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
			</tr>
			<tr> 
			      <td class="label">
							c. If yes to Item 6(b), does the service provider, or any of its Affiliates, use the NMS Stock ATS services?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:rbPart2Item6cDoesServiceProviderUseATSServices" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/@rbPart2Item6cDoesServiceProviderUseATSServices" />
				      </xsl:call-template>
				  </td>     
			</tr>
			        <!-- check c is Y -->
			        <xsl:choose>
		               <xsl:when
						      test="string(m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/@rbPart2Item6cDoesServiceProviderUseATSServices) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, identify the service provider, or the Affiliate as applicable, and the ATS services that the service provider or its Affiliates use.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/m1:taPart2Item6cProviderAfflAndServicesUsed)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			     </td>
			</tr>
			<tr> 
			      <td class="label">
							d. If yes to Item 6(c), are the services that the NMS Stock ATS offers and provides to the entity required to be identified in Item 6(c) the same for all Subscribers?  
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/m1:part2Item6dAreATSSevicesSametoAll/@rbPart2Item6dAreATSSevicesSametoAll" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/m1:rbPart2Item6dAreATSSevicesSametoAll" />
				      </xsl:call-template>
				  </td>     
			</tr>
			
			             <!-- Check d is N -->
			              <xsl:choose>
			                    <xsl:when test="string(m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/m1:part2Item6dAreATSSevicesSametoAll/@rbPart2Item6dAreATSSevicesSametoAll) = 'N'">
			<tr>                    
			      <td class="label">
			                  If no, identify and explain any differences.
				  </td>
				  <td>

							<div class="fakeBox3">
								<xsl:value-of select="m1:partTwo/m1:part2Item6bDoesAnyEntitySupportServices/m1:part2Item6cDoesServiceProviderUseATSServices/m1:part2Item6dAreATSSevicesSametoAll/m1:taPart2Item6dExplainDiff" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>

				  </td> 
		    </tr>
			                    </xsl:when>
			            </xsl:choose>	
			             <!-- Check d is N  END-->		
			
			
			
			         </xsl:when>
			      </xsl:choose>
			       <!-- Check c is Y  END-->
			
			   </xsl:when>
			</xsl:choose>
			 <!-- Check b is Y  END-->
	        
	   </table>

	</xsl:template>
	
		<!--  template item6 End -->
	<!-- ********************************************************** -->
	
	
	
	
	
	
	
	<xsl:template name="item7_partII">
	   <table role="presentation">
	      
	      <tr>
	            <td class="label">
	                  a. Describe the written safeguards and written procedures to protect the confidential trading information of Subscribers to the NMS Stock ATS, including:
	              
	              <br/>
	              <br/>
	              
	                  i. written standards controlling employees of the ATS that trade for employees' accounts; and
	              <br/>
	              <br/>
	                  ii. written oversight procedures to ensure that the safeguards and procedures described above are implemented and followed.
	            
	            </td>
	            <td>
	                   <div class="fakeBox3">
							<xsl:value-of select="string(m1:partTwo/m1:taPart2Item7aDescrOfSafeGaurdsAndProcedures)" />
							 <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
					   </div>
	            </td>
	      </tr>
	      <tr>
	            <td class="label">
	                  b. Can a Subscriber consent to the disclosure of its confidential trading information to any Person (not including those employees of the NMS Stock ATS who are operating the system or responsible for its compliance with applicable rules)? 
	            </td>
	            <td>
	                    <xsl:call-template name="condYesNoRadio">
						     <xsl:with-param name="noElement" select="m1:partTwo/m1:rbPart2Item7bCanSubscriberConsentToDisclosure" />
						     <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/@rbPart2Item7bCanSubscriberConsentToDisclosure" />
				    	</xsl:call-template>
	            </td>
	      </tr>
	      
	       <!--  check b is Y -->    
	   <xsl:choose>
		  <xsl:when
				 test="string(m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/@rbPart2Item7bCanSubscriberConsentToDisclosure) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, explain how and under what conditions.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/m1:taPart2Item7bExplainHowAndConditions)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			</tr>
			<tr> 
			      <td class="label">
							c. If yes to Item 7(b), can a Subscriber withdraw consent to the disclosure of its confidential trading information to any Person (not including those employees of the NMS Stock ATS who are operating the system or responsible for its compliance with applicable rules)?
				  </td> 
				  <td>
				      <xsl:call-template name="condYesNoRadio">
					     <xsl:with-param name="noElement"	select="m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/m1:rbPart2Item7cCanSubscriberWithdrawConsent" />
						 <xsl:with-param name="yesElement" select="m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/m1:part2Item7cCanSubscriberWithdrawConsent/@rbPart2Item7cCanSubscriberWithdrawConsent" />
				      </xsl:call-template>
				  </td>     
			</tr>
			     <!--  check c is Y -->
			     <xsl:choose>
		             <xsl:when
						  test="string(m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/m1:part2Item7cCanSubscriberWithdrawConsent/@rbPart2Item7cCanSubscriberWithdrawConsent) = 'Y'">
            <tr>
				  <td class="label">
				        If yes, explain how and under what conditions.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:part2Item7bCanSubscriberConsentToDisclosure/m1:part2Item7cCanSubscriberWithdrawConsent/m1:taPart2Item7cExplainHowAndConditions)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			</tr>
			        </xsl:when>
			    </xsl:choose>
			  <!--  check c Y END-->
	      
	     </xsl:when>
	  </xsl:choose>    
	    <!-- check b Y END -->
	    
	        <tr>
				  <td class="label">
				        d. Provide a summary of the roles and responsibilities of any Persons that have access to confidential trading information, the confidential trading information that is accessible by them, and the basis for the access.
				  </td>
				  <td>
						    <div class="fakeBox3">
								<xsl:value-of select="string(m1:partTwo/m1:taPart2Item7dSummaryOfRolesRespOfPersons)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
			    </td>
			</tr>
	           
	   </table>
	</xsl:template>
	
		<!--  template item7 End -->
	<!-- ********************************************************** -->
		

	
	
	
	
</xsl:stylesheet>