<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet 

version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:m1="http://www.sec.gov/edgar/atsn"
	
	
	xmlns:com="http://www.sec.gov/edgar/common"
    xmlns:acom="http://www.sec.gov/edgar/atsncommon">

	
	<!-- part I , Item I template : Identifying Information-->
	 
	 <xsl:template name="PartI">
		<h3>
			Identifying Information

		</h3>
		<xsl:call-template name="IdentifyingInfo" />
	</xsl:template>
	
	<xsl:template name="IdentifyingInfo">
       
        <table role="presentation" >
        
        
          
		<tr>
	      <table role="presentation" >
			  <tr> 
				 <td  class="label">1. Is the organization, association, Person, group of Persons, or system filing the Form ATS-N a broker-dealer registered with the Commission?
				 </td>
				 <td>
				      <xsl:call-template name="yesNoRadio">
	                     	<xsl:with-param name="yesNoElement" select="m1:partOne/m1:rbPart1Item1IsBd" />
				      </xsl:call-template> 
					
				 </td>
			</tr> 
		  </table> 
		</tr>
		
		
		
	
		   
			<tr>
			
			<table role="presentation" >
			  <tr>
				 <td  class="label">2. Full name of registered broker-dealer of the NMS Stock ATS ("Broker-Dealer Operator") as stated on Form BD:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partOne/m1:txPart1Item2ATSName)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				</td>
				
				</tr>
			</table>	
				
			</tr>
			
		
		
		
		  
			
			
			<tr>
			
			      3. Full name(s) of NMS Stock ATS under which business is conducted, if different:
			      <br/>
			       <br/>
			       <xsl:for-each
			   	            select="m1:partOne/m1:atsNames/m1:atsName/@txPart1Item3ATSName">	
			   	          
			
			    <table role="presentation" >
			            
			   	   <tr>    
			   	            
			             <td class="label">
				            
				                    NMS Stock ATS Full Name Record: <xsl:value-of select="position()"></xsl:value-of>
				          </td>
				          <td>
						               <div class="fakeBox">
							                <xsl:value-of
								                   select="." />
							                   <span>
								                    <xsl:text>&#160;</xsl:text>
							                   </span>
						               </div>
					
					
				          </td>
				          
				    </tr>
				    
			 
			     </table>
				      </xsl:for-each>	
			</tr>
		 
	  
		
		
		
			
		   <tr>
			
			   
					4. Provide the SEC file number and CRD number of the Broker-Dealer Operator:
				 <br/>
			       <br/>
		  
		<table role="presentation" >    

			<tr>
				 <td  class="label">a. SEC File No.:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox2">
							 <xsl:value-of
								  select="string(m1:partOne/m1:txPart1Item4aBdFileNumber)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							  </span>
						</div>
					 </p>
					
				</td>
			</tr>
			<tr>
				 <td  class="label">b. CRD No.:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox2">
							 <xsl:value-of
								  select="string(m1:partOne/m1:txPart1Item4aBdCrdNumber)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							  </span>
						</div>
					 </p>
					
				</td>
			</tr>
	</table>
		</tr>

		
			
			
			
	<tr>
			
			    
					5. Provide the full name of the national securities association of the Broker-Dealer Operator, the effective date of the Broker-Dealer Operator's membership with the national securities association, and Market Participant Identifier ("MPID") of the NMS Stock ATS: 
				   <br/>
			       <br/>
			
	<table role="presentation" > 	
	
			<tr>
				 <td  class="label">a. National Securities Association:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partOne/m1:txPart1Item5aNsaFullName)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							  </span>
						</div>
					 </p>
					
				</td>
			</tr>
	
			<tr>
				 <td  class="label">b. Effective Date of Membership:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox2">
							 <xsl:value-of
								  select="string(m1:partOne/m1:part1Item5bEffectiveMembershipDate)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							  </span>
						</div>
					 </p>
					
				</td>
			</tr>
	
		
			<tr>
				 <td  class="label">c. MPID of the NMS Stock ATS:
				 </td>
				 <td>
				      <p>
						<div class="fakeBox2">
							 <xsl:value-of
								  select="string(m1:partOne/m1:txtPart1Item5cNmsStockMPID)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							  </span>
						</div>
					 </p>
					
				</td>
			</tr>
		</table>	
	</tr>
	
		
		
	   
			
	
			
		<tr>
				
				
					6. Provide, if any, the website URL of the NMS Stock ATS:
				      <br/>
			      
		  <table role="presentation" > 		
			 <tr>	
				 <td>
				      <p>
						<div class="fakeBox">
							 <xsl:value-of
								  select="string(m1:partOne/m1:txtPart1Item6uwebsite)" />
							  <span>
								 <xsl:text>&#160;</xsl:text>
							 </span>
						</div>
					 </p>
					
				</td>
			</tr>	
		</table>
		</tr>
			
			
		
			
			
			

	<tr>
			
			 
					7. Provide the primary, and if any, secondary, physical street address(es) of the NMS Stock ATS matching system:
			   
		      <br/>
			     
		<table role="presentation" >    
			 <tr>
				  <br/>
				  
					Primary Address
				
			</tr>
			<tr>
			      <xsl:call-template name="primaryAddress" />
			
			</tr>
		    
		    
		    <!--  Here we should add Secondary address ( we need to discuss that) -->
		    
		    
		    <tr>
				
					Secondary Address
				    <br/>
				    <br/>
			</tr>
			
			
			
			        <xsl:for-each select="m1:partOne/m1:part1Item7SecondarySiteRecords/m1:secondarySiteI7">
			<tr>
			             <xsl:call-template name="secondaryAddress" />
			              <br/>
				        <br/>
			</tr>
			
			        </xsl:for-each>
			
			      
			
			
	    </table>	
	  </tr>	
  
			
			
  	
		<tr>
				
					8. Attach as Exhibit 1, the most recently filed or amended Schedule A of Form BD for the Broker-Dealer Operator disclosing information related to direct owners and executive officers.
				
		</tr>
		<tr>
			    <td>
			        <p>
			            Attach / Remove / View Exhibit 1
			        </p>
			    </td>
		
		</tr>
		<tr>
			                <td>
								 <xsl:choose>
									 <xsl:when
										  test="string(m1:partOne/m1:cbPart1Item8Exhibit1atWebsite) = 'true'">
										        <img src="Images/box-checked.jpg" alt="Checkbox checked" />

									 </xsl:when>
									<xsl:otherwise>
										        <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
						   </td>
						   <td>
								Select if, in lieu of filing, <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> certifies that the information requested under this Exhibit is available at the website above and is accurate as of the date of this filing.
						   </td>
						 <br/>
				          <br/> 
		   </tr>
		   
		   
		  <tr>
				
					 9. Attach as Exhibit 2, the most recently filed or amended Schedule B of Form BD for the Broker-Dealer Operator disclosing information related to indirect owners.
				
		  </tr>
			<tr>
			    <td>
			        <p>
			            Attach / Remove / View Exhibit 2
			        </p>
			    </td>
		
			</tr>
			<tr>            
			                <td>
								 <xsl:choose>
									 <xsl:when
										  test="string(m1:partOne/m1:cbPart1Item9Exhibit2atWebsite) = 'true'">
										        <img src="Images/box-checked.jpg" alt="Checkbox checked" />

									 </xsl:when>
									<xsl:otherwise>
										        <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
						   </td>
						   <td>
								Select if, in lieu of filing, <xsl:choose>
                 <xsl:when test="count(m1:cover/m1:txNMSStockATSName) &gt; 0">
                     <xsl:value-of select="string(m1:cover/m1:txNMSStockATSName)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span></xsl:when><xsl:otherwise>{NMS Stock ATS}</xsl:otherwise></xsl:choose> certifies that the information requested under this Exhibit is available at the website above and is accurate as of the date of this filing.
						   </td>
					   <br/>
				       <br/>	   
		   </tr>
		   
		   <xsl:if test="$submissionType= 'ATS-N/MA' or $submissionType= 'ATS-N/OFA' or $submissionType= 'ATS-N/CA' or $submissionType= 'ATS-N/UA'">
		     <tr>
				
					 10. For filings made pursuant to Rule 304(a)(2)(i)(A) through (D) (<u>i.e.,</u> Form ATS-N Amendments), attach as Exhibit 3 a document marked to indicate changes to "yes" or "no" answers or additions to or deletions from any Item in Part I, II, and Part III, as applicable.  Do not include in Exhibit 3 Items that are not changing.
				
			</tr>
			<tr>
			    <td>
			        <p>
			            Attach / Remove / View Exhibit 3
			        </p>
			    </td>
		
			</tr>
			
			
		    </xsl:if> 
		   
		   
		   
		   
		   
		   
		
 	
      </table>
	
	</xsl:template>
	
	
	
	
	
	
	
	
		
	 <!-- Primary Address template -->
	 
	 
	<xsl:template name="primaryAddress">
		<table role="presentation">
			<tr>
				<td class="label">Street 1 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partOne/m1:part1Item7PrimarySite/acom:street1)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Street 2 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partOne/m1:part1Item7PrimarySite/acom:street2)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">City </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(m1:partOne/m1:part1Item7PrimarySite/acom:city)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Zip</td>
				<td>

					<div align="left">
						<div class="fakeBox2">
							<xsl:value-of
								select="string(m1:partOne/m1:part1Item7PrimarySite/acom:zip)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">State</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="string(m1:partOne/m1:part1Item7PrimarySite/acom:state)" />
						</xsl:call-template>
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</td>
			</tr>
			
		
	    </table>
	    
			
	</xsl:template>
	
	
	
	
	
		
	 <!-- Secondary Address template -->
	 
	<xsl:template name="secondaryAddress">
	
	
		<table role="presentation">
		
		
		
		    <tr>
					<td>
							Secondary NMS Address Record:
							<xsl:value-of select="position()"></xsl:value-of>
					</td>
		    </tr>
		
			<tr>
				<td class="label">Street 1 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(acom:street1)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Street 2 </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(acom:street2)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">City </td>
				<td>

					<div class="fakeBox">
						<xsl:value-of
							select="string(acom:city)" />
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">Zip</td>
				<td>

					<div align="left">
						<div class="fakeBox2">
							<xsl:value-of
								select="string(acom:zip)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</div>

				</td>
			</tr>
			<tr>
				<td class="label">State</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="string(acom:state)" />
						</xsl:call-template>
						<span>
							<xsl:text>&#160;</xsl:text>
						</span>
					</div>
				</td>
			</tr>
			
		
	    </table>
	    
			
	</xsl:template>
	
	

	
</xsl:stylesheet>