<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/atsn/cover"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p2="http://www.sec.gov/edgar/atsncommon">
	<xsl:output 
		method="html" 
		indent="no" 
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />
	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
				<style type="text/css">
					.fakeTextBox {
						border-top: 2px solid #999;
						border-right: 1px solid #ccc;
						border-bottom: 1px solid #ccc;
						border-left: 2px solid #999;
						padding: 2px;
						width: 800px;
						height: auto;
						min-width: 200px;
						min-height: 50px;
						word-wrap: break-word;
						font-size: 0.9em;
						color: blue;
					}
					.boxed {
	
    	               text-align:center;
	                   border:3px solid;
	                   padding:12px;
	                   border-color:gray;
	                   margin-top:30px;
	                   margin-bottom:20px;
	                   margin-left:220px;
	                   margin-right:220px;
	                   font-weight:bold
	                   }

				</style>				
			</head>
			<body lang="en-US" text="#000000" bgcolor="#dcdcdc">
				<xsl:call-template name="header" />
				<br/>
				<xsl:call-template name="content" />
			</body>
		</html>
	</xsl:template>
	<xsl:template name="header">
		
				
				<div class="contentwrapper">
					<table role="presentation" id="header">
					     <tr>
                             <div class="boxed">
                                   THE SECURITIES AND EXCHANGE COMMISSION HAS NOT PASSED UPON THE MERITS OR ACCURACY OF<br/> THE DISCLOSURE IN THIS FILING.
                            </div>
                        </tr>
					    
						<tr>
							<td class="title">ATS-N/MA</td>
							<td rowspan="2" class="center">
								United States Securities and Exchange Commision
								<br />
								Washington, DC
								<br />
								FORM ATS-N
								<br />
								<br/>
								Intentional Misstatements or Omissions of Facts May
								<br />
								Constitute Criminal Violations
								<br />
								See 18 U.S.C.1001 and 15 U.S.C. 78ff(a)
								<br/>
								<br/>
								COVER PAGE
								<br/>
							</td>
							<td class="title">OMB APPROVAL</td>
						</tr>
						<tr>
							<td class="side" style="text-align: center;">
								<p>
									<br />
									Material Amendment (Rule 304(a)(2)(i)(A))
									<br />
								</p>
							</td>
							<td width="25%" class="side">
								<p>OMB Number:&#160;&#160;3235-0763</p>
								<hr></hr>
								<p>Estimated average burden hours per response:&#160;127.4</p>
								<hr></hr>
								<p>Estimated average burden hours per amendment:&#160;9</p>
								<hr></hr>
								<p>Estimated average burden hours per cessation:&#160;2</p>
								<hr></hr>
								<p>OMB Expiration Date:&#160;09/30/2021</p> 
							</td>
						</tr>
					</table>
				</div>
		
	</xsl:template>

	<xsl:template name="content">
		<div id="info">
			<div class="contentwrapper">
				<div class="content">
					<table role="presentation">
						<tr>
							<td class="label">Type of Filing (select one)</td>
							<td />
						</tr>
						<tr>
							<td colspan="2">
								<table role="presentation" align="center" border="0" cellspacing="8" class="style2" width="100%">
									<tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Initial Form ATS-N (Rule 304(a)(1)(i)) (ATS-N)</xsl:text>
											</span>
										</td>
									</tr>
									<tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N/MA'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Material Amendment (Rule 304(a)(2)(i)(A)) (ATS-N/MA)</xsl:text>
											</span>
										</td>
									</tr>
									<tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N/UA'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Updating Amendment (Rule 304(a)(2)(i)(B)) (ATS-N/UA)</xsl:text>
											</span>
										</td>
									</tr>
									<tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N/CA'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Correcting Amendment (Rule 304(a)(2)(i)(C)) (ATS-CA)</xsl:text>
											</span>
										</td>
									</tr><tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N/OFA'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Order Display and Fair Access Amendment (Rule 304(a)(2)(i)(D)) (ATS-N/OFA)</xsl:text>
											</span>
										</td>
									</tr><tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N-C'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Notice of Cessation (Rule 304(a)(3)) (ATS-N-C)</xsl:text>
											</span>
										</td>
									</tr><tr>
										<td align="center" width="10px">
											<xsl:choose>
												<xsl:when test="string(p:edgarSubmission/p:submissionType) = 'ATS-N-W'">
													<img src="Images/box-checked.jpg" alt="Checkbox checked" />
												</xsl:when>
												<xsl:otherwise>
													<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td>
											<span>
												<xsl:text>Withdrawal of Form ATS-N filing (ATS-N-W)</xsl:text>
											</span>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td class="label">Does the NMS Stock ATS currently operate pursuant to a Form ATS?</td>
							<td>
								<xsl:choose>
									<xsl:when test="string(p:edgarSubmission/p:rbOperatesPursuantToFormATS) = 'Y'">
										<img src="Images/radio-checked.jpg" alt="Radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;Yes
								<xsl:choose>
									<xsl:when test="string(p:edgarSubmission/p:rbOperatesPursuantToFormATS) = 'N'">
										<img src="Images/radio-checked.jpg" alt="Radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;No
							</td>
						</tr>
						<tr>
							<td class="label">Provide the EDGAR accession number  for the Form ATS-N filing to be amended:</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="string(p:edgarSubmission/p:accessionNumber)" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Filer CIK</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="string(p:edgarSubmission/p:filerCredentials/p:filerCik)" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Filer CCC</td>
							<td>
								<div class="fakeBox2">				
									<xsl:value-of select="string(p:edgarSubmission/p:filerCredentials/p:filerCcc)" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">File No:</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="string(p:edgarSubmission/p:fileNumber)" />
								</div>
							</td>
						</tr>
						
						<xsl:if test="string-length(p:edgarSubmission/p:txNMSStockATSName) &gt; 0">
						<tr>
							<td colspan="2">
								<table style="table-layout: auto;">
									<tr>
										<td style="white-space: nowrap;">
											<span class="fakeBox2">
												<xsl:value-of select="string(p:edgarSubmission/p:txNMSStockATSName)" />
											</span>
										</td>
										<td style="width:100%">
											<span> is making this filing pursuant to Rule 304 under the Securities Exchange Act of 1934</span>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						</xsl:if>
						
						<tr>
							<td class="label">Statement about the Form ATS-N Amendment pursuant to Instruction A.7 (g) of this form.</td>
							<td>
								<div class="fakeTextBox">
									<xsl:value-of select="string(p:edgarSubmission/p:taStatementAboutAmendment)" />
								</div>
							</td>
						</tr>
						
						
						<tr>
							<td class="label">
								Is this a LIVE or TEST Filing?
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="count(p:edgarSubmission/p:liveTestFlag) &gt; 0">
										<xsl:choose>
											<xsl:when test="string(p:edgarSubmission/p:liveTestFlag) = 'LIVE'">
												<img src="Images/radio-checked.jpg"   alt="Radio button checked"   /> LIVE
												<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" /> TEST
											</xsl:when>
										</xsl:choose>
										<xsl:choose>
											<xsl:when test="string(p:edgarSubmission/p:liveTestFlag) = 'TEST'">
												<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" /> LIVE
												<img src="Images/radio-checked.jpg"   alt="Radio button checked"   /> TEST
											</xsl:when>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" /> LIVE
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" /> TEST
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="label">
								Is this an electronic copy of an official filing submitted in paper format in connection with a hardship exemption?
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="string(p:edgarSubmission/p:flags/p:confirmingCopyFlag) = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="label">Confirming Copy File Number</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="p:edgarSubmission/p:flags/p:confirmingCopyFileNumber"/>
								</div>								
							</td>
						</tr>
					</table>
					<xsl:if test="count(p:edgarSubmission/p:contact) &gt; 0">
						<h4>Submission Contact Information</h4>
						<table role="presentation">
							<tr>
								<td class="label">Name</td>
								<td>
									<div class="fakeBox">
										<xsl:value-of select="string(p:edgarSubmission/p:contact/p2:contactName)" />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
									</div>
								</td>
							</tr>
							<tr>
								<td class="label">Phone Number</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of
											select="string(p:edgarSubmission/p:contact/p2:contactPhoneNumber)" />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
									</div>
					
								</td>
							</tr>
							<tr>
								<td class="label">E-Mail Address</td>
								<td>
									<div class="fakeBox">
										<xsl:value-of
											select="string(p:edgarSubmission/p:contact/p2:contactEmailAddress)" />
										<span>
											<xsl:text>&#160;</xsl:text>
										</span>
									</div>
								</td>
							</tr>
						</table>
					</xsl:if>
					<xsl:if test="count(p:edgarSubmission/p:flags/p:overrideInternetFlag) &gt; 0">
						<h4>Notification Information</h4>
						<table role="presentation">
							<tr>
								<td class="label">Notify via Filing Website only?</td>
								<td>
									<xsl:choose>
										<xsl:when test="string(p:edgarSubmission/p:flags/p:overrideInternetFlag) = 'true'">
											<img src="Images/box-checked.jpg" alt="Checkbox checked" />
										</xsl:when>
										<xsl:otherwise>
											<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
										</xsl:otherwise>
									</xsl:choose>
								</td>
							</tr>
						</table>
					</xsl:if>
					<table role="presentation">
						<xsl:for-each select="p:edgarSubmission/p:notifications/p:notificationEmail">
							<tr>
								<td class="label">Notification E-mail Address</td>
								<td>
									<div class="fakeBox">
										<xsl:value-of select="." />
									</div>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>
</xsl:stylesheet>
