<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>

<xsl:stylesheet 
version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:m1="http://www.sec.gov/edgar/atsn"
	xmlns:com="http://www.sec.gov/edgar/common"
	
   xmlns:acom="http://www.sec.gov/edgar/atsncommon">

<xsl:import href="util.xsl"/>

<xsl:output
		method="html"
		indent="no"
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />
		
		 <xsl:variable name = "submissionType" select = "m1:edgarSubmission/m1:headerData/m1:submissionType" />
        
  
  	<xsl:template match="/">
  	
  	
  	  	<html>
			<head>
				 <link rel="stylesheet" type="text/css" href="css/ATSN_print.css" />
				
				
			</head>

			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				
				<xsl:call-template name="header" />
				
				
               
				
			    <xsl:call-template name="coverData" />
			
				<xsl:apply-templates>
					<xsl:with-param name="submissionType"
						select="string(m1:edgarSubmission/m1:headerData/m1:submissionType)" />
				</xsl:apply-templates>
				
				
				
				
			</body>
		</html>
	
	</xsl:template>
	
	
	   
	
	
     
     <xsl:template name="schemaVersion" match="m1:edgarSubmission/m1:schemaVersion">
		<div style="display:none">
			schemaVersion:
				<xsl:value-of select="m1:edgarSubmission/m1:schemaVersion" />
		</div>
	</xsl:template>

	
	
	<!-- Header Template START -->
	
	 <xsl:template name="header">
	   
      	 <div class="contentwrapper">
  
             <table role="presentation"  id="header">
			   <tr>
                       <div class="boxed">
                           THE SECURITIES AND EXCHANGE COMMISSION HAS NOT PASSED UPON THE MERITS OR ACCURACY OF<br/> THE DISCLOSURES IN THIS FILING.
                        </div>
               </tr>
               <tr>
                   <td class="title">Form ATS-N Filer Information</td>
                   <td rowspan="2" class="center">
                        United States Securities and Exchange Commission
                        <br />
                        Washington, DC
                        <br />
                        FORM ATS-N
                        <br />
                        Intentional Misstatements or Omissions of Facts May Constitute
                        <br />
                        Criminal Violations
                        <br />
                        See 18 U.S.C.1001 and 15 U.S.C. 78ff(a)
                  </td>
                  <td class="title">OMB APPROVAL</td>
              </tr>
          
        
              <tr>
              
              <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'ATS-N'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Initial Form ATS-N (Rule 304(a)(1)(i))
                    </p>
                 </td>
              </xsl:if>
              
               <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'ATS-N/MA'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Material Amendment (Rule 304(a)(2)(i)(A))
                    </p>
                 </td>
              </xsl:if>
              
              <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'ATS-N/UA'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Updating Amendment (Rule 304(a)(2)(i)(B))
                    </p>
                 </td>
              </xsl:if>
              
               <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'ATS-N/CA'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Correcting Amendment (Rule 304(a)(2)(i)(C))
                    </p>
                 </td>
              </xsl:if>
              
               <xsl:if test="m1:edgarSubmission/m1:headerData/m1:submissionType = 'ATS-N/OFA'">
                 <td class="side" style="text-align: center;">
                    <p>
                       <br />
                         <xsl:value-of select ="$submissionType"/> 
                       <br />
                        <br />
                         Order Display and Fair Access Amendment (Rule 304(a)(2)(i)(D))
                    </p>
                 </td>
              </xsl:if>
      
    
                 <td class="side" style="text-align: center;">
                    <p>OMB Number:&#160;&#160;3235-0763</p>
                     <hr></hr>
                   <p>Estimated average burden hours per response:&#160;127.4</p>
                    <hr></hr>
                    <p>Estimated average burden hours per amendment:&#160;9</p>
                    <hr></hr>
                    <p>Estimated average burden hours per cessation:&#160;2</p>
                    <hr></hr>
                   <p>OMB Expiration Date:&#160;09/30/2021</p> 
                 </td>
             </tr>
       
   
         
    
   </table>
   
   </div> <!-- contentwrapper -->
   
 </xsl:template> 
 <!-- Header Template END -->
 
 
 <!--  Filer Information Template START -->
	 

	 
	 
	 
	 
<xsl:template name="coverData">
	   
	   <div id="info">
	      <div class="contentwrapper">
				<div class="content"> 
	                 <h1><xsl:value-of select ="$submissionType"/>: Filer Information</h1>
	                
	                     <!-- Filer -->
	                    <table role="presentation"  >
						    <tr>
						    	<td class="label">Filer CIK</td>
							    <td>
								      <div class="fakeBox2">
									     <xsl:value-of
				                             select="string(m1:edgarSubmission/m1:headerData/m1:filerInfo/m1:filer/m1:filerCredentials/com:cik)" />
									       <span>
										       <xsl:text>&#160;</xsl:text>
									       </span>
							         </div>

							   </td>
						   </tr>
						   <tr>
							   <td class="label">Filer CCC</td>
							   <td>
								     <div class="fakeBox2">
									    
										     ********
								     	  <span>
										      <xsl:text>&#160;</xsl:text>
								         </span>
								    </div>

							  </td>
					      </tr>
				  <xsl:if test="$submissionType= 'ATS-N/MA' or $submissionType= 'ATS-N/OFA' or $submissionType= 'ATS-N/CA' or $submissionType= 'ATS-N/UA'">
                          
                       
                      
                          <tr>
						    	<td class="label">File No:</td>
							    <td>
								      <div class="fakeBox2">
									     <xsl:value-of
				                             select="string(m1:edgarSubmission/m1:headerData/m1:filerInfo/m1:filer/m1:fileNumber)" />
									       <span>
										       <xsl:text>&#160;</xsl:text>
									       </span>
							         </div>

							   </td>
						   </tr> 
                    
                         
                    </xsl:if>
              </table>     
              
              
         
       
            <table role="presentation">
                     
             <xsl:choose>    
             
                        <xsl:when test="string-length(m1:edgarSubmission/m1:formData/m1:cover/m1:txNMSStockATSName)&gt; 0">
                          <tr>     
                              
                             <td colspan="2">
                                 <table style="table-layout: auto;">
                             	     <tr> 				         
							            <td style="white-space: nowrap;"> 
							                <span class="fakeBox4">
								                  <xsl:value-of select ="m1:edgarSubmission/m1:formData/m1:cover/m1:txNMSStockATSName"/>
										      
							                </span>
							         
							            </td>
							            <td style="width:100%">
							                 
					                             <span>is making this filing pursuant to the Rule 304 under the Securities Exchange Act of 1934</span> 
					              
					              
						                </td>
				                    </tr>
				               </table>
				           </td>  
				       </tr>      
                     </xsl:when>
                     <xsl:otherwise>
                        <tr>     
                              
                              <td>
						        
							           <span class="fakeBox4">
								           <xsl:value-of select ="m1:edgarSubmission/m1:formData/m1:cover/m1:txNMSStockATSName"/>
										  <span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							         </span>
							
				                <span>
				              	
					             is making this filing pursuant to the Rule 304 under the Securities Exchange Act of 1934
					           
					             </span>
						    </td>
				         </tr>
                     
                     </xsl:otherwise>
                       
              
             </xsl:choose>
			  </table>		
			  
			  
			  
			  
			  <table role="presentation"  >
                    	         
                     	       <xsl:if test="$submissionType= 'ATS-N/MA' or $submissionType= 'ATS-N/OFA' or $submissionType= 'ATS-N/CA' or $submissionType= 'ATS-N/UA'">
				       <tr>
				               <td class="label">Statement about the Form ATS-N Amendment pursuant to Instruction A.7 (g) of this form.</td>
						       <td>
							           <div class="fakeBox">
								            <xsl:value-of select="string(m1:edgarSubmission/m1:formData/m1:cover/m1:taStatementAboutAmendment)"/>
										<span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							          </div>
						       </td>
				   
				       </tr>
	                           </xsl:if>   
				   
                    
                    
	
	              
	              </table>
	          </div>
	      </div>
	 </div>
	 </xsl:template>
	 
	<xsl:template name="headerData" match="m1:edgarSubmission/m1:headerData">
	          <div id="info">
	      <div class="contentwrapper">
				<div class="content">   
	                 <table role="presentation"  >
	                    <tr>
	                  
	                          <td class="label">
							            	Is this a LIVE or TEST Filing?
					          </td>
					          <td>
								    <span class="yesNo">
									   <xsl:choose>
										     <xsl:when test="count(m1:filerInfo/m1:liveTestFlag) &gt; 0">
									               <xsl:choose>
											              <xsl:when test="string(m1:filerInfo/m1:liveTestFlag) = 'LIVE'">
												            	<img src="Images/radio-checked.jpg" alt="Radio button checked" />
													                LIVE
													            <img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
												                	TEST
												           </xsl:when>
											       </xsl:choose>
									               <xsl:choose>
											               <xsl:when test="string(m1:filerInfo/m1:liveTestFlag) = 'TEST'">
												             	<img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
													                LIVE
													            <img src="Images/radio-checked.jpg" alt="Radio button checked" />
												                 	TEST
												           </xsl:when>
											      </xsl:choose>
										     </xsl:when>
									        <xsl:otherwise>
											                   <img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
											                        LIVE
											                   <img src="Images/radio-unchecked.jpg" alt="Radio button not checked" />
										                         	TEST
									        </xsl:otherwise>
									</xsl:choose>
								</span>
					    	</td>
	              
	                    </tr>
	                    
	                    
	                     <tr>
	                         <td class="label">
	                              Is this an electronic copy of an official filing submitted in paper format in connection with a hardship exemption?
	                         </td>
	                         <td>
	                                <xsl:choose>
									       <xsl:when
										            test="m1:filerInfo/m1:flags/acom:confirmingCopyFlag = 'true'">
										                     <img src="Images/box-checked.jpg" alt="Checkbox checked" />
									       </xsl:when>
								           <xsl:otherwise>
										                     <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									       </xsl:otherwise>
							       </xsl:choose>
	                      
	                         </td>
	                    </tr> 
	                    
	                         
	                         <xsl:if	test="m1:filerInfo/m1:flags/acom:confirmingCopyFlag = 'true'">
					    <tr>
						 	<td class="label">Confirming Copy File Number</td>
							 <td>
								<div class="fakeBox2">
									<xsl:value-of select="m1:filerInfo/m1:flags/acom:confirmingCopyFileNumber" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							 </td>
					   </tr>
						    </xsl:if>
	                    
	                   </table>  
	              
	         
	            <!-- contact -->
	          
	                <table role="presentation" >
	                  <tr>
	                      
	                            <h4>Submission Contact Information</h4>
	                       
	                  </tr>
	            
	                  <tr>
							<td class="label">Name</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="string(m1:filerInfo/m1:contact/acom:contactName)" />
									   <span>
									    	<xsl:text>&#160;</xsl:text>
									   </span>
								</div>
							</td>
					 </tr>
					 <tr>
							<td class="label">Phone Number</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of
										select="string(m1:filerInfo/m1:contact/acom:contactPhoneNumber)" />
								      <span>
										   <xsl:text>&#160;</xsl:text>
									 </span>
								</div>

							</td>
					 </tr>
					 <tr>
							<td class="label">E-Mail Address</td>
							<td>
								<div class="fakeBox">
								   <xsl:value-of
										 select="string(m1:filerInfo/m1:contact/acom:contactEmailAddress)" />
									 <span>
										   <xsl:text>&#160;</xsl:text>
									 </span>
								</div>
							</td>
					</tr>
				
				
	             </table>
				
				<!-- Notifications -->
				
			
			      <table role="presentation"  >
			        
			          <tr>
	                       
	                            <h4>Notification Information</h4>
	                       
	                  </tr>
			        
	                  <tr>
						   <td class="label">
								Notify via Filing Website only?
						   </td>
						   <td>
								 <xsl:choose>
									 <xsl:when
										  test="string(m1:filerInfo/m1:flags/acom:overrideInternetFlag) = 'true'">
										        <img src="Images/box-checked.jpg" alt="Checkbox checked" />

									 </xsl:when>
									<xsl:otherwise>
										        <img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
						   </td>
				     </tr>
			 
	            
	         <xsl:for-each
				 select="m1:filerInfo/m1:notifications/acom:notificationEmailAddress">
			  
				   <tr>
					       <td class="label">Notification E-mail Address</td>
						   <td>
							  <div class="fakeBox">
								  <xsl:value-of select="." />
										<span>
											 <xsl:text>&#160;</xsl:text>
										</span>
							  </div>
						  </td>
				  </tr>
			
		    </xsl:for-each>
		    
		  </table>
		    
		    
		    
				 </div> <!-- content close here-->
				 </div> <!-- contentwrapper-->
				 </div><!-- div info-->
				 
	  </xsl:template>
	           
	        <!--   End of filer information page-->   
	        
	    
	  
	        
	        
	        <!--  FormData Template start-->
	         
      <xsl:template name="formData" match="m1:edgarSubmission/m1:formData">
	         
	     
	 
	        <!--  Real Form DATA -->
	         
	              <div class="content">
	              
	                <div class="label">
	                
	        
	              
	                 <!--  PartI -->
	                 <xsl:if test="($submissionType='ATS-N') or ($submissionType= 'ATS-N/MA') or ($submissionType= 'ATS-N/OFA') or ($submissionType= 'ATS-N/CA') or ($submissionType= 'ATS-N/UA')">
	              
	                   <h1><xsl:value-of select ="$submissionType"/>: Part I: Identifying Information</h1>
	                  
	                      <div class="form1">
	                    
	                           
	                           <xsl:call-template name="PartI" /> 
	                     
	                      </div>
	                 </xsl:if>
	                 <!--  PartI End-->    
	                      
	                 <!--  PartII -->   
	                 
	                 <xsl:if test="($submissionType='ATS-N') or ($submissionType= 'ATS-N/MA') or ($submissionType= 'ATS-N/OFA') or ($submissionType= 'ATS-N/CA') or ($submissionType= 'ATS-N/UA')">
	                	
	                   <h1><xsl:value-of select ="$submissionType"/>: Part II: Activities of the Broker-Dealer Operator and its Affiliates</h1>
	         
	                      <div class="form1">
	                       
	                       
	                          <xsl:call-template name="PartII" /> 
	                          
	                      </div> <!--  Div form1 -->
	                       
	                 </xsl:if>       
	                   <!--  PartII End-->
	                   
	                   
	                   
	                   <!--  PartIII -->
	                   
	                  <xsl:if test="$submissionType='ATS-N' or $submissionType= 'ATS-N/MA' or $submissionType= 'ATS-N/OFA' or $submissionType= 'ATS-N/CA' or $submissionType= 'ATS-N/UA'">
	                   
	                   <h1><xsl:value-of select ="$submissionType"/>: Part III: Manner of Operations</h1>
	                       
	                      <div class="form1">
	                   
	                         
	                          <xsl:call-template name="PartIII" />       
	                       
	                      </div> <!-- div form1-->
	                   
	                  </xsl:if>
	                   <!--  Part III End -->
	                    
	                    
	                  <!--  Part IV -->
	                  <xsl:if test="count(m1:partFour) &gt; 0">
	                 <h1><xsl:value-of select ="$submissionType"/>: Part IV: Contact Information, Signature Block, and Consent to Service</h1>
	         
	                      <div class="form1">
	                        
	                         <xsl:call-template name="PartIV"/>
	                    
	                      </div>   <!-- div form1 End-->
	                    </xsl:if> 
	                 <!--  Part IV End-->    
	                      
	                      
	              
	                      
	             </div> <!-- label div -->
	           </div> <!-- div content -->
	    
	   
	  </xsl:template>
	      <!--  end Form data template -->
	       
	     
	     
	     
	    
	     <!--  Documents Template START -->
	  
	 <xsl:template name="documentsData" match="m1:edgarSubmission/m1:documents">
	 <div style="display:none;">
    <xsl:if test="$submissionType='ATS-N' or $submissionType= 'ATS-N/MA' or $submissionType= 'ATS-N/OFA' or $submissionType= 'ATS-N/CA' or $submissionType= 'ATS-N/UA'">   
	 
		  <div class="content">
	              
	            <div class="label">
	            
	           
	                
	                <h1><xsl:value-of select ="$submissionType"/>: Attachments</h1>
		
			         <div class="form1">
			
			              <xsl:call-template name="InvisibleDocumentsInfo"/>
			
			         </div>
			         
			 
			
			   </div>
		</div>
		
  </xsl:if>  
		</div>  
	 </xsl:template>	
	     
	   
	     
	     
	     <!--  Documents Template END -->
	       
	  
	  
	  
	  
	  <xsl:template name="condYesNoRadio">
			<xsl:param name="yesElement" />
			<xsl:param name="noElement" />
		<span class="yesNo">
						<xsl:choose>
							<xsl:when test="count($yesElement) &gt; 0 or count($noElement) &gt; 0">
								<xsl:choose>
									<xsl:when
										test="string($yesElement) = 'Y'">
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										Yes
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										No
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when
										test="string($noElement) = 'N'">
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										Yes
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										No
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								Yes
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								No
							</xsl:otherwise>
						</xsl:choose>
					</span>

			</xsl:template>
	
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  	<xsl:template name="yesNoRadio">
			<xsl:param name="yesNoElement" />
		<span class="yesNo">
						<xsl:choose>
							<xsl:when
								test="count($yesNoElement) &gt; 0">
								<xsl:choose>
									<xsl:when
										test="string($yesNoElement) = 'Y'">
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										Yes
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										No
									</xsl:when>
								</xsl:choose>
								<xsl:choose>
									<xsl:when
										test="string($yesNoElement) = 'N'">
										<img
											src="Images/radio-unchecked.jpg"
											alt="Radio button not checked" />
										Yes
										<img
											src="Images/radio-checked.jpg"
											alt="Radio button checked" />
										No
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								Yes
								<img
									src="Images/radio-unchecked.jpg"
									alt="Radio button not checked" />
								No
							</xsl:otherwise>
						</xsl:choose>
					</span>

			</xsl:template>
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	    
	    
	    
	    
	    
	
	     
	       
	   
   <xsl:include href="ATSN_partI.xsl" />
   <xsl:include href="ATSN_partII.xsl" />
   <xsl:include href="ATSN_partIII.xsl" />
   <xsl:include href="ATSN_partIV.xsl" />
   <xsl:include href="ATSN_documents.xsl"/>
   <xsl:include href="iso_State_Codes.xsl" />
   
	
</xsl:stylesheet>