<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenhfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="signature">		
		<h1><xsl:value-of select="$submissionType"/>: Signature</h1>
		<h4 class="warning" style="font-weight:normal">
			<b><font style="font-size:1.1em">Attention</font></b>
			<br/><br/>
			Intentional misstatements or omissions of facts constitute Federal Criminal Violations. 
			See 18 U.S.C. § 1001 and 15 U.S.C. § 78ff(a).
			<br/><br/>
			Intentional misstatements or omissions of facts may also result in civil fines and other 
			sanctions pursuant to Section 20 of the Securities Exchange Act of 1934.
			<br/><br/>
			The person signing this report represents hereby that all information contained in this 
			Form is true, correct and complete. It is understood that all information in this Form is 
			considered an integral part of this Form and that the submission of any amendment represents 
			that all unamended information remains true, correct and complete as previously filed.
		</h4>
		<table>
			<tr>
				<td class="label">
					Pursuant to the Securities Exchange Act of 1934, the undersigned has caused this 
					report to be signed on its behalf in the City of <em>{City}</em>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:signatureCity"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					and State of <em>{State}</em>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param 
								name="stateCode" 
								select="p:signatureState"/>
						</xsl:call-template>						
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					on the day of <em>{MM-DD-YYYY}</em>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:signatureDate"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Name of Broker-Dealer
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:nameOfBroker"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					Signature of Person Duly Authorized to Submit This Report
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:signatureOfDulyAuthorized"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Title of Person Duly Authorized to Submit This Report
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:signatureTitle"/>
					</div>
				</td>
			</tr>										
		</table>
	</xsl:template>
</xsl:stylesheet>