<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenhfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="part2_2">
		<h4 class="title1">II. FINANCIAL INSTRUMENTS WITH OFF-BALANCE SHEET 
			RISK AND WITH CONCENTRATION OF CREDIT RISK</h4>
		<div class="information">
			<p>
				(Provide notional or contractual amounts where appropriate, 
				or in the case of options, the values of the underlying instrument. 
				In the event a separate listing of a position or instrument is required 
				pursuant to the provisions of section 17h-1T, separately state such position.)
			</p>
		</div>				
		<table>
			<tr>
				<th><h4 class="titleNumber">A. Securities</h4></th>
				<th class="titleLong">Long</th>
				<th class="titleMiddle">(000's omitted)</th>
				<th class="titleShort">Short</th>
				<th>&#160;</th>
			</tr>
			<!-- 1. -->	
			<tr>
				<td class="label">
					1. When-issued securities
				</td>
				<td class="responseLong">&#160;</td>
				<td>&#160;</td>
				<td class="responseShort">&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(a) Gross commitments to purchase
					</blockquote>
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:issuedSecurities/p:grossCommitmentsToPurchaseLong"/>
					</div>
				</td>
				<td>
					[2000]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:issuedSecurities/p:grossCommitmentsToPurchaseShort"/>
					</div>				
				</td>		
				<td>
					[2005]
				</td>		
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(b) Gross commitments to sell
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:issuedSecurities/p:grossCommitmentsToSellLong"/>
					</div>
				</td>
				<td>
					[2010]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:issuedSecurities/p:grossCommitmentsToSellShort"/>
					</div>				
				</td>
				<td>
					[2015]
				</td>			
			</tr>
			<!-- 2. -->	
			<tr>
				<td class="label">
					2. Written stock option contracts:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
					(a) Market value, and the value of the underlying securities, of call contracts: 
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
							(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2020]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesListed/p:marketValueShort"/>
					</div>
				</td>
				<td>
					[2025]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying securities
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2030]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2035]
				</td>			
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesUnListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2040]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesUnListed/p:marketValueShort"/>
					</div>
				</td>
				<td>
					[2045]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2050]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueCallContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>	
				<td>
					[2055]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(b) Market value, and the value of the underlying securities, of put contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>					
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2060]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesListed/p:marketValueShort"/>
					</div>
				</td>	
				<td>
					[2065]
				</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2070]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2075]
				</td>					
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesUnListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2080]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesUnListed/p:marketValueShort"/>
					</div>
				</td>
				<td>
					[2085]
				</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2090]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValuePutContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2095]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(c) Market value, and the value of the underlying securities, of naked call contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2100]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesListed/p:marketValueShort"/>
					</div>
				</td>
				<td>
					[2105]
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2110]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2115]
				</td>			
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesUnListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2120]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesUnListed/p:marketValueShort"/>
					</div>
				</td>			
				<td>
					[2125]
				</td>	
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2130]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedCallContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2135]
				</td>					
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					(d) Market value, and the value of 
					the underlying securities, of naked put contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2140]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesListed/p:marketValueShort"/>
					</div>
				</td>
				<td>
					[2145]
				</td>			
			</tr>				
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2150]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2155]
				</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(A) Market value</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesUnListed/p:marketValueLong"/>
					</div>
				</td>
				<td>
					[2160]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesUnListed/p:marketValueShort"/>
					</div>
				</td>
				<td>
					[2165]
				</td>			
			</tr>				
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>(B) Value of underlying securities</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2170]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:writtenStockOptionContracts/p:marketValueNakedPutContractsSecuritiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>
				</td>		
				<td>
					[2175]
				</td>		
			</tr>
			<!-- 3. -->	
			<tr>
				<td class="label">
					3. Futures
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(a) U.S. Treasury and mortgage-backed securities futures
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:futures/p:usTreasuryMortgageBackedSecuritiesFuturesLong"/>
					</div>
				</td>
				<td>
					[2180]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:futures/p:usTreasuryMortgageBackedSecuritiesFuturesShort"/>
					</div>
				</td>	
				<td>
					[2185]
				</td>			
			</tr>
		</table>
		<table>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(b) Other futures
						</blockquote>
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
							(specify)
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:partTwoII/p:futures/p:otherFuturesDescription"/>
					</div>
				</td>
			</tr>
		</table>
		<table>
			<tr>
				<td class="label"></td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:futures/p:otherFuturesLong"/>
					</div>
				</td>
				<td style="width:101px">
					[2190]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:futures/p:otherFuturesShort"/>
					</div>
				</td>			
				<td>
					[2195]
				</td>					
			</tr>
			<!-- 4. -->	
			<tr>
				<td class="label">
					4. Forwards
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(a) U.S. Treasury and mortgage-backed securities
						</blockquote>
					</blockquote>
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:treasuryMortgageBackedSecurities/p:usTreasuryMortgageBackedSecuritiesLong"/>
					</div>
				</td>
				<td>
					[2200]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:treasuryMortgageBackedSecurities/p:usTreasuryMortgageBackedSecuritiesShort"/>
					</div>
				</td>
				<td>
					[2205]
				</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(i) Aggregate current cost of replacing contracts by
								 counterparty in which the Material Associated Person has a gain
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:treasuryMortgageBackedSecurities/p:usTreasuryMortgageBackedSecuritiesForwards/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>
				</td>
				<td>
					[2210]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:treasuryMortgageBackedSecurities/p:usTreasuryMortgageBackedSecuritiesForwards/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>
				</td>
				<td>
					[2215]
				</td>				
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(ii) Per counterparty breakdown where credit risk exceeds the Materiality Threshold (attach schedule).
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>			
			</tr>
		</table>
		<table>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								Attach / Remove / View Part II.I.15
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<th class="titleLong">&#160;</th>
				<th class="titleMiddle">&#160;</th>
				<th class="titleShort">&#160;</th>
				<th>&#160;</th>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(b) Other forwards
						</blockquote>
					</blockquote>
				</td>
				<td colspan="4">
					&#160;
				</td>		
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
							(specify)
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:partTwoII/p:otherForwards/p:otherForwardsDec"/>
					</div>
				</td>		
			</tr>
		</table>
		<table>
			<tr>
				<td class="label">
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:otherForwards/p:otherForwardsLong"/>
					</div>
				</td>
				<td style="width:101px">
					[2220]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:otherForwards/p:otherForwardsShort"/>
					</div>
				</td>
				<td>
					[2225]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(i) Aggregate current cost of replacing contracts by counterparty 
								in which the Material Associated Person has a gain
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:otherForwards/p:otherForwards/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>
				</td>
				<td>
					[2230]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:otherForwards/p:otherForwards/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>
				</td>
				<td>
					[2235]
				</td>					
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(ii) Per counterparty breakdown where credit 
								risk exceeds the Materiality Threshold (attach schedule).
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								Attach / Remove / View Part II.I.15
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
		</table>			
		<table>
			<tr>
				<th><h4 class="titleNumber">B. Interest Rate Swaps</h4></th>
				<th class="titleLong">&#160;</th>
				<th class="titleMiddle">&#160;</th>
				<th class="titleShort">&#160;</th>
				<th>&#160;</th>
			</tr>
			<!-- 1. -->	
			<tr>
				<td class="label">
					1. U.S. dollar denominated swaps:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>				
			<tr>
				<td class="label">
					<blockquote>
						(a) Total notional or contractual amount
					</blockquote>
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:usDollarDenominatedSwaps/p:totalNotionalContractualAmountLong"/>
					</div>
				</td>
				<td>
					[2240]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:usDollarDenominatedSwaps/p:totalNotionalContractualAmountShort"/>
					</div>
				</td>
				<td>
					[2245]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(b) Aggregate current cost of replacing contracts by 
						counterparty in which the Material Associated Person has a gain
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:usDollarDenominatedSwaps/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>
				</td>
				<td>
					[2250]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:usDollarDenominatedSwaps/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>
				</td>
				<td>
					[2255]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(c) Per counterparty breakdown where credit risk exceeds the Materiality Threshold (attach schedule).
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>
				<td>&#160;</td>					
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Attach / Remove / View Part II.I.15
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>	
				<td>&#160;</td>				
			</tr>					
			<!-- 2. -->	
			<tr>
				<td class="label">
					2. Cross currency swaps:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(a) Total notional or contractual amount
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:crossCurrentSwaps/p:totalNotionalContractualAmountLong"/>
					</div>
				</td>
				<td>
					[2260]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:crossCurrentSwaps/p:totalNotionalContractualAmountShort"/>
					</div>
				</td>
				<td>
					[2265]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(b) Aggregate current cost of replacing contracts by 
						counterparty in which the Material Associated Person has a gain
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:crossCurrentSwaps/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>
				</td>
				<td>
					[2270]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:crossCurrentSwaps/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>
				</td>
				<td>
					[2275]
				</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(c) Per counterparty breakdown where 
						credit risk exceeds the Materiality Threshold (attach schedule).
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Attach / Remove / View Part II.I.15
					</blockquote>					
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
		</table>
		<h4 class="titleNumber">C. Foreign exchange</h4>
		<table id="part2">	
			<tr>
				<td class="label">
					1. Swaps:
				</td>
				<th class="titleLong">&#160;</th>
				<th class="titleMiddle">&#160;</th>
				<th class="titleShort">&#160;</th>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(a) Total notional or contractual amount
					</blockquote>
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:foreignExchangeSwaps/p:totalNotionalContractualAmountLong"/>
					</div>
				</td>
				<td>
					[2280]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:foreignExchangeSwaps/p:totalNotionalContractualAmountShort"/>
					</div>				
				</td>		
				<td>
					[2285]
				</td>		
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(b) Aggregate current cost of replacing contracts by 
						counterparty in which the Material Associated Person has a gain
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:foreignExchangeSwaps/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>
				</td>
				<td>
					[2290]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:foreignExchangeSwaps/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>				
				</td>
				<td>
					[2295]
				</td>				
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(c) Per counterparty breakdown 
						where credit risk exceeds the Materiality Threshold (attach schedule).
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Attach / Remove / View Part II.II.C.1.(c)
					</blockquote>					
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>	
			</tr>
			<!-- 2. -->	
			<tr>
				<td class="label">
					2. Notional or contractual amounts of 
					commitments to purchase foreign currencies and U.S. dollar exchange:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
					(a) Futures
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:notionalCommitments/p:futuresLong"/>
					</div>				
				</td>
				<td>
					[2300]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:notionalCommitments/p:futuresShort"/>
					</div>					
				</td>
				<td>
					[2305]
				</td>	
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(b) Forwards
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:notionalCommitments/p:forwardsLong"/>
					</div>				
				</td>
				<td>
					[2310]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:notionalCommitments/p:forwardsShort"/>
					</div>					
				</td>	
				<td>
					[2315]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Aggregate current cost of replacing contracts by 
							counterparty in which the Material Associated Person has a gain
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:notionalCommitments/p:forwards/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>				
				</td>
				<td>
					[2320]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:notionalCommitments/p:forwards/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>					
				</td>
				<td>
					[2325]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Per counterparty breakdown where 
							credit risk exceeds the Materiality Threshold (attach schedule).
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Attach / Remove / View Part II.II.C.2.(b).(ii)
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<!-- 3. -->	
			<tr>
				<td class="label">
					3. Naked written option contracts:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						(a) Contractual value
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:nakedWrittenOptionContracts/p:contractualValueLong"/>
					</div>				
				</td>
				<td>
					[2330]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:nakedWrittenOptionContracts/p:contractualValueShort"/>
					</div>					
				</td>
				<td>
					[2335]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(b) Value of the underlying instruments
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:nakedWrittenOptionContracts/p:valueUnderlyingInstrumentsLong"/>
					</div>				
				</td>
				<td>
					[2340]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:nakedWrittenOptionContracts/p:valueUnderlyingInstrumentsShort"/>
					</div>					
				</td>	
				<td>
					[2345]
				</td>		
			</tr>
		</table>
		<h4 class="titleNumber">D. All other swap agreements (specify type)(attach schedule if necessary)</h4>
		<table id="part2">
			<tr>
				<td class="label">
					&#160;
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:partTwoII/p:allOtherSwapAgreements/p:otherSwapAgreementsDec"/>
					</div>				
				</td>
			</tr>								
		</table>
		<table>																			
			<!-- 1. -->
			<tr>
				<td class="label">	
					Attach / Remove / View Part II.II.D
				</td>
				<th class="titleLong">&#160;</th>
				<th class="titleMiddle">&#160;</th>
				<th class="titleShort">&#160;</th>
				<th>&#160;</th>
			</tr>	
			<tr>
				<td class="label">
					1. Total notional or contractual amount
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:allOtherSwapAgreements/p:allOtherSwapAgreements/p:totalNotionalContractualAmountLong"/>
					</div>				
				</td>
				<td>
					[2350]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:allOtherSwapAgreements/p:allOtherSwapAgreements/p:totalNotionalContractualAmountShort"/>
					</div>				
				</td>
				<td>
					[2355]
				</td>
			</tr>	
			<!-- 2. -->	
			<tr>
				<td class="label">
					2. Aggregate current cost of replacing contracts by counterparty 
					in which the Material Associated Person has a gain
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:allOtherSwapAgreements/p:allOtherSwapAgreements/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>				
				</td>
				<td>
					[2360]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:allOtherSwapAgreements/p:allOtherSwapAgreements/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>				
				</td>
				<td>
					[2365]
				</td>
			</tr>
			<tr>
				<td class="label">
					3. Per counterparty breakdown where credit 
					risk exceeds the Materiality Threshold (attach schedule).
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					Attach / Remove / View Part II.II.D
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>		
		</table>	
		<table id="part2">
			<tr>
				<th><h4 class="titleNumber">E. Commodities</h4></th>
				<th class="titleLong"></th>
				<th class="titleMiddle"></th>
				<th class="titleShort"></th>
				<th>&#160;</th>
			</tr>	
			<!-- 1. -->	
			<tr>
				<td class="label">
					1. Futures
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:commodities/p:futuresLong"/>
					</div>				
				</td>
				<td>
					[2370]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:commodities/p:futuresShort"/>
					</div>				
				</td>
				<td>
					[2375]
				</td>
			</tr>	
			<!-- 2. -->	
			<tr>
				<td class="label">
					2. Forwards
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:commodities/p:forwardsLong"/>
					</div>				
				</td>
				<td>
					[2380]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:commodities/p:forwardsShort"/>
					</div>				
				</td>
				<td>
					[2385]
				</td>
			</tr>	
			<tr>
				<td class="label">	
					<blockquote>
						(a) Aggregate current cost of replacing contracts by counterparty 
						in which the Material Associated Person has a gain
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:commodities/p:forwards/p:aggregateCostMaterialAssociatedPersonGainLong"/>
					</div>				
				</td>
				<td>
					[2390]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:commodities/p:forwards/p:aggregateCostMaterialAssociatedPersonGainShort"/>
					</div>				
				</td>
				<td>
					[2395]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(b) Per counterparty breakdown where credit risk 
						exceeds the Materiality Threshold (attach schedule).
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						Attach / Remove / View Part II.II.E.2.(b)
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<!-- 3. -->	
			<tr>
				<td class="label">
					3. Sold option contracts (e.g., options on 
					individual commodities and commodities indexes)
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(a) Market value, and the value of the
						 underlying instruments, of call contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>						
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2400]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2405]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2410]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2415]
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesUnListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2420]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesUnListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2425]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2430]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueCallContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2435]
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
							(b) Market value, and the value of the underlying instruments, of put contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2440]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2445]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2450]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2455]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesUnListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2460]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesUnListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2465]
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2470]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValuePutContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2475]
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
							(c) Market value, and the value of the underlying instruments, of naked call contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2480]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2485]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2490]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2495]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesUnListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2500]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesUnListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2505]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2510]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedcallContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2515]
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
							(d) Market value, and the value of the underlying instruments, of naked put contracts:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(i) Listed
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2530]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2525]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2520]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2535]
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							(ii) Unlisted
						</blockquote>
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(A) Market value
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesUnListed/p:marketValueLong"/>
					</div>					
				</td>
				<td>
					[2540]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesUnListed/p:marketValueShort"/>
					</div>					
				</td>
				<td>
					[2545]
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							<blockquote>
								(B) Value of underlying instruments
							</blockquote>
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesLong"/>
					</div>					
				</td>
				<td>
					[2550]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:soldOptionContractsCommodities/p:marketValueNakedPutContractsCommoditiesUnListed/p:valueOfUnderlyingSecuritiesShort"/>
					</div>					
				</td>
				<td>
					[2555]
				</td>
			</tr>																						
		</table>
		
		<h4 class="titleNumber">F. Loan commitments</h4>
		<table id="part2">
			<tr>
				<td class="label">
					1. Total amount
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:totalAmount"/>
					</div>					
				</td>
				<td>
					[2560]
				</td>
			</tr>
			<!-- 2. -->	
			<tr>
				<td class="label">
					2. Unused portion
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:unusedPortion"/>
					</div>					
				</td>
				<td>
					[2565]
				</td>
			</tr>
			<tr>
				<td></td>
				<td class="titleLong">(000's omitted)</td>
				<td></td>
			</tr>
		</table>
		
		<h4 class="titleNumber">G. Total standby, commercial and similar letters of credit or guarantees</h4>
		<table>
			<tr>
				<td class="label">&#160;</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:totalStandbyCommercialLettersOfCreditOrGuarantees"/>
					</div>				
				</td>
				<td>
					[2570]
				</td>
			</tr>
		</table>
		
		<h4 class="titleNumber">H. Assets sold with recourse</h4>
		<table>	
			<tr>
				<td class="label">&#160;</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:assetsSoldWithRecourse"/>
					</div>				
				</td>
				<td>
					[2575]
				</td>
			</tr>
		</table>
		
		<h4 class="titleNumber">I. Other off-balance sheet items</h4>
		<table>
			<tr>
				<td class="label">
					Note: This item has two data collection fields: 1) a text field for "(specify)" and 2) a numeric field for the amount.
				</td>
				<td class="responseLong"  colspan="4">
				</td>
				<td>
					&#160;
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(specify)
					</blockquote>
				</td>
				<td class="responseLong"  colspan="4">
					<div class="fakeBox3">
						<xsl:value-of select="p:partTwoII/p:otherOffBalanceSheetItemsDec"/>
					</div>				
				</td>
				<td>
					&#160;
				</td>
			</tr>
		</table>
		<table>		
			<tr>
				<td class="label">
					&#160;	
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoII/p:otherOffBalanceSheetItems"/>
					</div>				
				</td>
				<td>
					[2580]
				</td>
			</tr>
		</table>

		<h4 class="titleNumber">J. Summary of delta or similar analysis(if available)(attach analysis)</h4>
		<table>
			<tr>
				<td class="label">
					Attach / Remove / View Part II.II.J
				</td>
				<td>&#160;</td>
			</tr>
		</table>
		<h4 class="titleNumber">K. Provide a separate listing, by amount, of significant 
						concentrations of credit risk as defined in Statement of 
						Financial Accounting Standards No. 105 (attach schedule).</h4>
		<table>
			<tr>
				<td class="label">
					Attach / Remove / View Part II.II.K
				</td>
				<td>&#160;</td>
			</tr>																			
		</table>
	</xsl:template>
</xsl:stylesheet>