<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenhfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="part2_1" >
		<table >
			<tr >
				<td class="label" style="vertical-align:middle;text-align:center">
					<b>Material Associated Person</b>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:nameMaterialAssociatedPersonsInThisReport"/>
					</div>
				</td>
			</tr>
		</table>
		<h4 class="title1">I. AGGREGATE SECURITIES AND COMMODITIES POSITIONS</h4>
		<table>
			<tr>
				<th></th>
				<th class="titleLong">Long</th>
				<th class="titleMiddle">(000's omitted)</th>
				<th class="titleShort">Short</th>
				<th>&#160;</th>
			</tr>
			<!-- 1. -->
			<tr>
				<td class="label">
					1. U.S. Treasury securities
				</td>
				<td class="responseLong">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:usTreasurySecuritiesLong"/>
					</div>
				</td>
				<td>
					[1000]
				</td>
				<td class="responseShort">
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:usTreasurySecuritiesShort"/>
					</div>
				</td>
				<td>
					[1005]
				</td>
			</tr>
			<!-- 2. -->
			<tr>
				<td class="label">
					2. U.S.  Government agency
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:usGovernmentAgencyLong"/>
					</div>
				</td>
				<td>
					[1010]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:usGovernmentAgencyShort"/>
					</div>				
				</td>
				<td>
					[1015]
				</td>			
			</tr>
			<!-- 3. -->			
			<tr>
				<td class="label">
					3. Securities issued by states and political subdivisions in the U.S.
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:securitieIssuedByStatesLong"/>
					</div>
				</td>
				<td>
					[1020]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:securitieIssuedByStatesshort"/>
					</div>				
				</td>
				<td>
					[1025]
				</td>			
			</tr>
			<!-- 4. -->
			<tr>
				<td class="label">
					4. Foreign securities:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(a) Debt securities
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:foreignSecurities/p:debtSecuritiesLong"/>
					</div>
				</td>
				<td>
					[1030]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:foreignSecurities/p:debtSecuritiesShort"/>
					</div>				
				</td>
				<td>
					[1035]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(b) Equity securities
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:foreignSecurities/p:equitySecuritiesLong"/>
					</div>
				</td>
				<td>
					[1040]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:foreignSecurities/p:equitySecuritiesShort"/>
					</div>				
				</td>	
				<td>
					[1045]
				</td>				
			</tr>	
			<!-- 5. -->			
			<tr>
				<td class="label">
					5. Banker's acceptances
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:bankerAcceptancesLong"/>
					</div>
				</td>
				<td>
					[1050]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:bankerAcceptancesShort"/>
					</div>				
				</td>	
				<td>
					[1055]
				</td>				
			</tr>	
			<!-- 6. -->			
			<tr>
				<td class="label">
					6. Certificates of deposit
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:certificatesOfDepositLong"/>
					</div>
				</td>
				<td>
					[1060]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:certificatesOfDepositShort"/>
					</div>				
				</td>
				<td>
					[1065]
				</td>				
			</tr>
			<!-- 7. -->			
			<tr>
				<td class="label">
					7. Commercial paper
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:commercialPaperLong"/>
					</div>
				</td>
				<td>
					[1070]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:commercialPaperShort"/>
					</div>				
				</td>	
				<td>
					[1075]
				</td>				
			</tr>
			<!-- 8. -->			
			<tr>
				<td class="label">
					8. Corporate obligations 
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:corporateObligationsLong"/>
					</div>
				</td>
				<td>
					[1080]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:corporateObligationsShort"/>
					</div>				
				</td>	
				<td>
					[1085]
				</td>			
			</tr>	
			<!-- 9. -->			
			<tr>
				<td class="label">
					9. Stocks and warrants (other than arbitrage positions)  
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:stocksAndWarrantsLong"/>
					</div>
				</td>
				<td>
					[1090]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:stocksAndWarrantsShort"/>
					</div>				
				</td>	
				<td>
					[1095]
				</td>				
			</tr>	
			<!-- 10. -->
			<tr>
				<td class="label">
					10. Arbitrage:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(a) Index arbitrage and program trading
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:arbitrage/p:indexArbitrageAndProgramTradingLong"/>
					</div>
				</td>
				<td>
					[1100]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:arbitrage/p:indexArbitrageAndProgramTradingShort"/>
					</div>				
				</td>
				<td>
					[1105]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(b) Risk arbitrage
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:arbitrage/p:riskArbitrageLong"/>
					</div>
				</td>
				<td>
					[1110]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:arbitrage/p:riskArbitrageShort"/>
					</div>				
				</td>
				<td>
					[1115]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					(c) Other arbitrage
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:arbitrage/p:otherArbitrageLong"/>
					</div>
				</td>
				<td>
					[1120]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:arbitrage/p:otherArbitrageShort"/>
					</div>				
				</td>
				<td>
					[1125]
				</td>				
			</tr>
			<!-- 11. -->
			<tr>
				<td class="label">
					11. Options:
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr> <!-- 11. (a) -->
				<td class="label">
					<blockquote>
					(a) Market value of put options:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>(i) Listed</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValuePutOption/p:listedLong"/>
					</div>
				</td>
				<td>
					[1130]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValuePutOption/p:listedShort"/>
					</div>				
				</td>	
				<td>
					[1135]
				</td>				
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>(ii) Unlisted</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValuePutOption/p:unlistedLong"/>
					</div>
				</td>
				<td>
					[1140]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValuePutOption/p:unlistedShort"/>
					</div>				
				</td>
				<td>
					[1145]
				</td>				
			</tr>	
			<tr> <!-- 11.(b) -->
				<td class="label">
					<blockquote>
					(b) Market value of call options:
					</blockquote>
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>(i) Listed </blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValueCallOption/p:listedLong"/>
					</div>
				</td>
				<td>
					[1150]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValueCallOption/p:listedShort"/>
					</div>				
				</td>
				<td>
					[1155]
				</td>			
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>(ii) Unlisted</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValueCallOption/p:unlistedLong"/>
					</div>
				</td>
				<td>
					[1160]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:marketValueCallOption/p:unlistedShort"/>
					</div>				
				</td>	
				<td>
					[1165]
				</td>				
			</tr>	
			<!-- 12. -->			
			<tr>
				<td class="label">
					12. Spot commodities
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:spotCommoditiesLong"/>
					</div>
				</td>
				<td>
					[1170]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:spotCommoditiesShort"/>
					</div>				
				</td>
				<td>
					[1175]
				</td>				
			</tr>	
			<!-- 13. -->
			<tr>
				<td class="label">
					13. Investments with no ready market: 
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>
			</tr>
			<tr> <!-- 13. (a) -->
				<td class="label">
					<blockquote>
					(a) Equity 
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:investmentsWithNoReadyMarket/p:equityLong"/>
					</div>
				</td>
				<td>
					[1180]
				</td>	
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:investmentsWithNoReadyMarket/p:equityShort"/>
					</div>
				</td>
				<td>
					[1185]
				</td>
			</tr>
			<tr> <!-- 13. (b) -->
				<td class="label">
					<blockquote>
					 (b) Debt 
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:investmentsWithNoReadyMarket/p:debtLong"/>
					</div>
				</td>
				<td>
					[1190]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:investmentsWithNoReadyMarket/p:debtShort"/>
					</div>
				</td>
				<td>
					[1195]
				</td>
			</tr>
			<tr> <!-- 13. (c) -->
				<td class="label">
					<blockquote>
					 (c) Other (include limited partnership interests) 
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:investmentsWithNoReadyMarket/p:otherLimitedPartnershipInterestsLong"/>
					</div>
				</td>
				<td>
					[1200]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:investmentsWithNoReadyMarket/p:otherLimitedPartnershipInterestsShort"/>
					</div>
				</td>
				<td>
					[1205]
				</td>
			</tr>	
			<!-- 14. -->			
			<tr>
				<td class="label">
					14. Other securities or commodities
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:otherSecuritiesOrCommoditiesLong"/>
					</div>
				</td>
				<td>
					[1210]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:partTwoI/p:otherSecuritiesOrCommoditiesShort"/>
					</div>				
				</td>	
				<td>
					[1215]
				</td>			
			</tr>
			<!-- 15. -->
			<tr>
				<td class="label">
					15. Summary of delta or similar analysis(if available)(attach analysis)
				</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>
				<td>&#160;</td>				
			</tr>
			<tr>
				<td class="label">
					Attach / Remove / View Part II.I.15
				</td>
				<td>&#160;</td>
				<td>&#160;</td>
				<td>&#160;</td>	
				<td>&#160;</td>				
			</tr>			
		</table>
	</xsl:template>
</xsl:stylesheet>