<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenhfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="part1_page2">
		<h1><xsl:value-of select="$submissionType"/>: Part I (page 2)</h1>
		
		<h4 class="titleNumber">Item 1: Organizational Chart Reflecting Material Associated Persons and the Broker-Dealer</h4>
		
		<div class="information">
			<p>
				1. Provide a copy of the organizational chart maintained by the broker 
				or dealer pursuant to paragraph (a)(1)(i)of section 240.17h-1T.
				<br/><br/>
				2. The information provided pursuant to this Item should be included in 
				the first Form 17-H filed by the broker or dealer and in the year-end filing. 
				Quarterly updates should be provided only where a material change in the information 
				provided to the Commission has occurred.
				<br/><br/>
				Attach / Remove / View Item 1
				<br/><br/>
				No material changes have occurred since last filed. &#160;&#160;&#160;&#160;
				<xsl:choose>
					<xsl:when test="p:organizationalChartNoMaterialChangesSinceLastFiledFlag = 'true'">
						<img src="Images/box-checked.jpg" alt="Checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/box-unchecked.jpg" alt="Checkbox unchecked" />
					</xsl:otherwise>
				</xsl:choose>
				<br/>					
			</p>
		</div>
		
		<h4 class="titleNumber">Item 2: Risk Management And Other Policies</h4>	
		<div class="information">
			<p>
				1. Provide copies of the financing, capital adequacy, and risk management and 
				other policies, procedures or systems maintained by the broker-dealer pursuant 
				to paragraph (a)(1)(ii) of section 240.17h-1T.
				<br/><br/>
				2. The information provided pursuant to this Item should be included in the 
				first Form 17-H filed by the broker or dealer. Quarterly updates should be 
				provided only where a material change in the information provided to the Commission has occurred.
				<br/><br/>
				Attach / Remove / View Item 2
				<br/><br/> 
				No material changes have occurred since last filed. &#160;&#160;&#160;&#160;
				<xsl:choose>
					<xsl:when test="p:riskManagementAndOtherPoliciesSinceLastFiledFlag = 'true'">
						<img src="Images/box-checked.jpg" alt="Checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/box-unchecked.jpg" alt="Checkbox unchecked" />
					</xsl:otherwise>
				</xsl:choose>						
				<br/>					
			</p>
		</div>
				
		<h4 class="titleNumber">Item 3: Legal Proceedings</h4>	
		<div class="information">
			<p>
				1. Provide the description of any material pending legal or arbitration 
				proceedings maintained by the broker or dealer pursuant to paragraph (a)(1)(iii) of section 240.17h-1T.
				<br/><br/>
				2. The information provided pursuant to this Item should be included in the first Form 17-H filed with 
				the Commission. Quarterly updates should be provided only where a material change in the information 
				provided to the Commission has occurred.
				<br/><br/>
				Attach / Remove / View Item 3 
				<br/><br/>
				No material changes have occurred since last filed. &#160;&#160;&#160;&#160;
				<xsl:choose>
					<xsl:when test="p:legalProceedingsSinceLastFiledFlag = 'true'">
						<img src="Images/box-checked.jpg" alt="Checkbox checked" />
					</xsl:when>
					<xsl:otherwise>
						<img src="Images/box-unchecked.jpg" alt="Checkbox unchecked" />
					</xsl:otherwise>
				</xsl:choose>						
				<br/>
			</p>
		</div>
		
		<h4 class="titleNumber">Item 4: Financial Statements</h4>	
		<div class="information">
			<p>
				1. Provide the information required to be maintained by the broker or dealer pursuant 
				to paragraphs (a)(1)(iv)and (a)(1)(v) of section 240.17h-1T. The financial statements 
				may be presented on an unaudited basis. The statement of cash flows and the notes to 
				financial statements may be omitted for the consolidating financial statements. Entities 
				using accounting principles other than U.S. GAAP should indicate in a note the accounting 
				principles used.
				<br/><br/>
				2. The consolidating financial statements must be presented on a subsidiary basis and 
				shall indicate which subsidiaries are Material Associated Persons.
			</p>
		</div>										
	</xsl:template>
</xsl:stylesheet>