<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenhfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:import href="util.xsl" />
	
	<xsl:output 
		method="html" 
		indent="no" 
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<!-- variable: Submission Type  -->
	<xsl:variable name="submissionType" select="p:edgarSubmission/p:headerData/p:submissionType"/>

	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />	
				<style tyle="text/css">				
					.warning {
						font-weight:bold;   
						padding:10px; 
						margin:5px 0px;
						background-color:#ffffc0;
						border:2px solid #808000;
						color:#302000;
						font-size:0.9em;
					}
					/* informations */
					.information, .informationNoBorder {
						font-weight:lighter   
						padding:10px; 
						color:#302000;
						font-size:0.9em;
					}
					img {
						vertical-align:text-top;
					}
					.information {
						margin:5px 0px;
						border:2px solid #19aa34;
						background-color:#cbf7d3;
					}
					.informationNoBorder{
						margin:5px 0px; 
					}
					/* titles (order by font size)*/
					.title1, .title2, .title3, .titleNumber {
						font-family: Arial, Helvetica, sans-serif;
					    text-align: left;
					    line-height: 1.5;				
					}									
					.title1 { /* Largest title */
						margin: 10px 0px;
					    font-size: 1.2em;
					}
					.title2 { /* Second largest title */
						margin: 10px;
					    font-size: 1.1em;
					    font-style:italic;
					}	
					.title3 { /* Third largest title */
						margin: 10px 20px;
					    color: black;
					    font-size: 1.0em;
					    font-style:italic;
					}
					.titleNumber {
						margin: 10px 0px;
						line-height: 1.0;
					}
					.responseLong, .responseShort {
						align:center;
						width:10px;
					}
					.titleMiddle, .titleLong, .titleShort {
						font-weight:bold;
						vertical-align:middle;
					}
					.titleLong, .titleShort{
						text-align: center;
					}
					.titleMiddle {
						width:120px;
						font-size: 0.9em;
					}
					.fakeBox3, .fakeBox {
						width: 700px;
						position:relative;
					}
					.fakeBox {
						border-top: 2px solid #999;
					}
				</style>		
			</head>


			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				<div style="display:none">
					<xsl:value-of select="p:edgarSubmission/p:schemaVersion"/>
				</div>
				
				<xsl:apply-templates select="p:edgarSubmission/p:headerData/p:filerInfo"/>
				<xsl:apply-templates select="p:edgarSubmission/p:formData/p:partOnePageOne"/>
				<xsl:apply-templates select="p:edgarSubmission/p:formData/p:signatureInfo"/>
				<xsl:apply-templates select="p:edgarSubmission/p:formData/p:partOnePageTwo"/>
				<xsl:apply-templates select="p:edgarSubmission/p:formData/p:partTwoDrpInfo"/>
				
			</body>
		</html>
	</xsl:template>
	
	<!-- Header Template START -->
	
	<xsl:template name="headerData" match="p:edgarSubmission/p:headerData/p:filerInfo">
		<div class="contentwrapper">
			<table id="header">
				<tr>
					<td class="title">Form 17-H Filer Information</td>
					<td rowspan="2" class="center">
						UNITED STATES<br/>
						SECURITIES AND EXCHANGE COMMISSION<br />
						Washington, D.C. 20549<br /><br/>
						FORM 17-H<br />
						RISK ASSESSMENT REPORT FOR BROKERS AND DEALERS<br/>
					</td>
					<td class="title">OMB APPROVAL</td>
				</tr>	
				<tr>
					<td class="side" style="text-align: center;vertical-align:middle">
						<p>
							FORM <xsl:value-of select="$submissionType" />
						</p>
					</td>
					<td width="25%" class="side">
						<p>OMB Number:&#160;3235-0410</p>
						<hr></hr>
						<p>Estimated average burden hours per response:&#160;6.00</p>
					</td>
				</tr>
			</table>
		</div>	
	
		<div id="info">
			<div class="contentwrapper">
				<div class="content">
					<h1><xsl:value-of select="$submissionType"/>: Filer Information</h1>
					<table class="filerInformation">		
						<tr>
							<td class="label">Filer CIK</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="p:filer/p:filerCredentials/p:cik" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Filer CCC</td>
							<td>
								<div class="fakeBox2">				
									********
								</div>
							</td>
						</tr>				
						<tr>
							<td class="label">Is this a LIVE or TEST Filing?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:liveTestFlag = 'LIVE'">
										<img src="Images/radio-checked.jpg" alt="Live is checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Live is unchecked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;LIVE
								<xsl:choose>
									<xsl:when test="p:liveTestFlag = 'TEST'">
										<img src="Images/radio-checked.jpg" alt="Test is checked"/>
									</xsl:when>											
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Test is unchecked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;TEST
							</td>
						</tr>
						<tr>
							<td class="label">Would you like a Return Copy?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:returnCopyFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="label">Is this an electronic copy of an official filing submitted in paper format?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:confirmingCopyFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox unchecked"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<xsl:if test="p:flags/p:confirmingCopyFlag = 'true'">
							<tr>
								<td class="label">Confirming Copy File Number</td>
								<td>
									<div class="fakeBox2">
										<xsl:value-of select="p:filer/p:fileNumber"/>
									</div>
								</td>
							</tr>		
						</xsl:if>										
						<tr>
							<td>
								<h4>Submission Contact Information</h4>
							</td>
						</tr>
						<tr>
							<td class="label">Name</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:contact/p:contactName" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Phone</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="p:contact/p:contactPhoneNumber" />
								</div>
							</td>
						</tr>

						<tr>
							<td class="label">E-Mail Address</td>
							<td>			
								<div class="fakeBox">
									<xsl:value-of select="p:contact/p:contactEmailAddress" />
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<h4>Notification Information</h4>
							</td>
						</tr>					
						<tr>
							<td class="label">Notify via Filing Website only?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:overrideInternetFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox unchecked" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						
						<xsl:choose>
							<xsl:when test="count(p:notifications/p:notificationEmailAddress) &gt; 0">
								<xsl:for-each select="p:notifications/p:notificationEmailAddress">
									<tr>
										<td class="label">Notification E-mail Address</td>
										<td>
											<div class="fakeBox">
												<xsl:value-of select="." />
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td class="label">Notification E-mail Address</td>
									<td>
										<div class="fakeBox"></div>
									</td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>
	
	<xsl:template name="formData_part1_page1" match="p:edgarSubmission/p:formData/p:partOnePageOne">
		<xsl:call-template name="part1_page1"/>
	</xsl:template>

	<xsl:template name="formData_signature" match="p:edgarSubmission/p:formData/p:signatureInfo">
		<xsl:call-template name="signature"/>
	</xsl:template>	

	<xsl:template name="formData_part1_pag2" match="p:edgarSubmission/p:formData/p:partOnePageTwo">
		<xsl:call-template name="part1_page2"/>
	</xsl:template>
	
	<xsl:template name="formData_part2s" match="p:edgarSubmission/p:formData/p:partTwoDrpInfo">
		<h1><xsl:value-of select="$submissionType"/>: Part II</h1>
		<h4 class="title1">GENERAL INSTRUCTIONS FOR PART II OF THIS FORM</h4>
		<div class="information">
			<p>
				1. Provide the following information for each Material Associated Person as of 
				the end of the quarter. Indicate the name of each Material Associated Person in
				 a separate column or complete a separate Part II for each Material Associated Person. 
				 In the event a separate listing of a position, financial instrument or otherwise is 
				 required pursuant to any of the provisions of section 240.17h-1T, the broker or dealer 
				 should indicate as such in the appropriate section of this Part II. Where appropriate, 
				 indicate long and short positions separately. (Report amounts in thousands)
			</p>
		</div>
		<xsl:for-each select="p:partTwoDrp">
			<xsl:call-template name="part2_1"/>
			<xsl:call-template name="part2_2"/>
			<xsl:call-template name="part2_3"/>
			<xsl:call-template name="part2_4"/>
			<xsl:call-template name="part2_5"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="documentsData" match="p:edgarSubmission/p:documents">
		<div style="display:none;">	
			<xsl:call-template name="Documents"/>
		</div>
	</xsl:template>
	
	<xsl:include href="17H_Part1_Page1.xsl" />
	<xsl:include href="17H_Part1_Page2.xsl" />
	<xsl:include href="17H_Part2_1.xsl" />
	<xsl:include href="17H_Part2_2.xsl" />
	<xsl:include href="17H_Part2_3.xsl" />
	<xsl:include href="17H_Part2_4.xsl" />
	<xsl:include href="17H_Part2_5.xsl" />
	<xsl:include href="17H_Signature.xsl" />
	<xsl:include href="17H_documents.xsl" />
	<xsl:include href="SDR_State_Codes.xsl" />
</xsl:stylesheet>