<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/seventeenhfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="part1_page1" >
		<!-- Variables -->
		<xsl:variable name="part1_page1_quarterly">
			<xsl:for-each select="p:filingType">
				<xsl:if test="contains(. , 'Quarterly')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="part1_page1_annual">
			<xsl:for-each select="p:filingType">
				<xsl:if test="contains(. , 'Annual')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>	
		<xsl:variable name="part1_page1_amended">
			<xsl:for-each select="p:filingType">
				<xsl:if test="contains(. , 'Amended')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>	
			
		<h1><xsl:value-of select="$submissionType"/>: Part I</h1>
		<h4 class="titleNumber">Risk Assessment Reporting Requirements for Brokers and Dealers</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Name of Reporting Broker-Dealer [14]
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:nameReportingBrokerDealer"/>
					</div>
				</td>
			</tr>
		</table>
		
		<h4 class="titleNumber">Address of Principal Place of Business [18]</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Address 1
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:businessAddress"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Address 2
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:businessAddress2"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					City
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:city"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					State/Country
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param 
								name="stateCode" 
								select="p:stateOrCountry"/>
						</xsl:call-template>							
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Mailing Zip/ Postal Code
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:zipCode"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Firm I.D. No. [20]
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:firmId"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					For Period Beginning [22]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:beginningPeriod"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					and Ending [24]
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:endingPeriod"/>
					</div>
				</td>
			</tr>						
		</table>
		
		<h4 class="titleNumber">Filing Type: (Pre-populated by selecting the Type of Filing)</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Quarterly [26]
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($part1_page1_quarterly , 'Quarterly')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>					
				</td>
			</tr>
			<tr>
				<td class="label">
					Annual [28]
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($part1_page1_annual , 'Annual')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>				
				</td>
			</tr>	
			<tr>
				<td class="label">
					Amended [30]
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($part1_page1_amended , 'Amended')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked" />
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
						</xsl:otherwise>
					</xsl:choose>				
				</td>
			</tr>					
		</table>
		
		<h4 class="titleNumber">Contact Information regarding this Report [32]</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					First Name
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:firstName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Last Name
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:lastName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Telephone Number
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:phoneNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Email
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:emailAddress"/>
					</div>
				</td>
			</tr>		
			<xsl:choose>
				<xsl:when test="count(p:associatedMaterial/p:nameMaterialAssociatedPersonsInThisReport) &gt; 0">
					<xsl:for-each select="p:associatedMaterial/p:nameMaterialAssociatedPersonsInThisReport">
						<tr>
							<td class="label">
								Name(s) Of Material Associated Persons Contained in this Report [34]
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="."/>
								</div>
							</td>
						</tr>				
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td class="label">
							Name(s) Of Material Associated Persons Contained in this Report [34]
						</td>
						<td>
							<div class="fakeBox3"></div>
						</td>
					</tr>	
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td class="label">
					Would you like to add "Name(s) of Associated Broker-Dealer(s) not Filing (if applicable) [44]"?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:nameMaterialAssociatedBrokerDealersQuestion = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:nameMaterialAssociatedBrokerDealersQuestion = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p:nameMaterialAssociatedBrokerDealersQuestion = 'Y'">
				<xsl:for-each select="p:nameMaterialAssociatedBrokerDealersNotFiling">
					<tr>
						<td class="label">
							<blockquote>
								Name(s) of Associated Broker-Dealer(s) not Filing (if applicable) [44]
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="."/>
							</div>
						</td>
					</tr>				
				</xsl:for-each>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>