'''
Clean test files in dqcrt directory, replacing all non-ASCII characters with &#nnn; per EFM

'''
import os, io

TESTSDIR = r"c:\\dvlp\git\efm\conf\dqcrt\conf-2026"

for file in os.listdir(TESTSDIR):
    if file.endswith(".xml"):
        xmlIn = None
        xmlOut = []
        with io.open(TESTSDIR + os.sep + file, "r", encoding="utf-8") as fh:
            xmlIn = fh.read()
        if xmlIn:
            for c in xmlIn:
                if c > '\x7e':
                    xmlOut.append(f"&#{ord(c)};")
                else:
                    xmlOut.append(c)
            with io.open(TESTSDIR + os.sep + file, "w", encoding="utf-8") as fw:
                fw.write("".join(xmlOut))
            print(f"Cleaned {file}")
