#!/bin/bash

# Run FASB DQCRT taxonomy tests 
#
# Tests DQCRT/2026 against XBRL-US filings
#
# Assumes 8 core cpu to run in 5 hrs
#
# Results have been verified by XBRL-US against their databasee of results
#
# Requires arelle disclosure system efm-preview-dqcrt-testing
#
# Result report files merged by script mergeEFMDQC2020TestsOut.sh

ARELLECMDLINESRC=/xbrldata/team_sun_stars/arelle/Arelle-repo-reorg/arelleCmdLine.py
CACHE_DIR=/xbrldata/team_sun_stars/cache
PYTHON=python3.12
PLUGINS='EDGAR/render'
EFM_VAL=efm-pragmatic-nonblocking

rm -f out/DQCRT-2026-python-*

for f in $(seq 1 `ls DQCRT-2026-test-python-*.xml|wc -l`)
do
	TESTCASESROOT=DQCRT-2026-test-python-${f}.xml
	f2dig=$(printf "%02d" ${f})
	OUTPUTLOGFILE=out/DQCRT-2026-python-log-${f2dig}.log
	OUTPUTERRFILE=out/DQCRT-2026-python-err-${f2dig}.txt
	OUTPUTCSVFILE=out/DQCRT-2026-python-report-${f2dig}.csv
	TESTCASESINDEXFILE=$TESTCASESROOT

	$PYTHON $ARELLECMDLINESRC --file "$TESTCASESINDEXFILE" --noCertificateCheck --plugins $PLUGINS --disclosureSystem $EFM_VAL --validate --testcaseResultOptions match-any --csvTestReport "$OUTPUTCSVFILE" --testcaseResultsCaptureWarnings --xdgConfigHome $CACHE_DIR --logFile "$OUTPUTLOGFILE" &>  "$OUTPUTERRFILE" &
	echo "$! " >> out/DQCRT-2026-python-PIDs
done
