<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="tab5">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - <font style="font-weight:normal">Page 5</font></h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>		
		<h4 class="titleNumber">FINANCIAL DISCLOSURE</h4>
		<table role="presentation">	
			<tr>
				<td class="label">
					I. In the past ten years has the <em>applicant</em> or a <em>control affiliate</em> ever been a securities 
					firm or a futures firm, or a control affiliate of a securities firm or a futures firm that:
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(1)  Has been the subject of a bankruptcy petition?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:financialDisclosure/p:hasSubjectOfBankruptcy = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:financialDisclosure/p:hasSubjectOfBankruptcy = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(2)  Has had a trustee appointed or a direct payment procedure initiated 
						under the Securities Investor Protection Act?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:financialDisclosure/p:hasTrusteeAppointed = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:financialDisclosure/p:hasTrusteeAppointed = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>
		</table>
	
		<h4 class="titleNumber">15.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> registered with the Commission as an investment adviser or
					municipal securities advisor or with the CFTC as a commodity trading adviser?
				</td>
				<td>				
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isRegisteredWithCommission = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isRegisteredWithCommission = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				If "yes," provide all unique identification numbers assigned to the firm relating to this business on Schedule D, Page 1, Section II.			
			</p>
		</div>
		
		<h4 class="titleNumber">16.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Does <em>applicant</em> effect transactions in commodity futures, commodities or commodity 
					options as a broker for others or as a dealer for its own account?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isEffectTransactions = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isEffectTransactions = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				If "yes," provide all unique identification numbers assigned to the firm relating to this business on Schedule D, Page 1, Section II.			
			</p>
		</div>
		
		<table role="presentation">
			<tr>
				<td class="label">
					B. Does <em>applicant</em> engage in any other investment-related, non-securities business?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isEngagedInNonSecurity = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isEngagedInNonSecurity = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				If "yes," provide all unique identification numbers assigned to the firm relating to 
				this business and describe each other business briefly on Schedule D, Page 1, Section II.			
			</p>
		</div>		
		
		<h4 class="titleNumber">17.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> registered with a foreign financial regulatory authority?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isForeignRegulatory = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFive/p:isForeignRegulatory = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>
		</table>

		<div class="information">
			<p>
				If "yes," list all such registrations on Schedule F, Page 1, Section II.			
			</p>
		</div>			
		
	</xsl:template>
</xsl:stylesheet>