<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="tab4">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - <font style="font-weight:normal">Page 4</font></h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>		
		<h4 class="titleNumber">REGULATORY ACTION DISCLOSURE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					C. Has the U.S. Securities and Exchange Commission or the Commodity Futures Trading Commission ever:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1)  <em>Found</em> the <em>applicant</em> or a <em>control affiliate</em> to have made a false statement or omission?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isMadeFalseStatement = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isMadeFalseStatement = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(2)  <em>Found</em> the <em>applicant</em> or a <em>control affiliate</em> to have been involved in a violation of its regulations or statutes?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isViolatedRegulation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isViolatedRegulation = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(3)  <em>Found</em> the <em>applicant</em> or a <em>control affiliate</em> to have been a cause of an investment-related business
						having its authorization to do business denied, revoked, or restricted?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isCauseOfDenial = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isCauseOfDenial = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(4)  Entered an <em>order</em> against the <em>applicant</em> or a <em>control affiliate</em> in connection with 
						<em>investment-related</em> activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isOrderAgainst = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isOrderAgainst = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(5)  Imposed a civil money penalty on the <em>applicant</em> or a <em>control affiliate</em>, or ordered the 
						<em>applicant</em> or a <em>control affiliate</em> to cease and desist from any activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isImposedPenalty = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isImposedPenalty = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					D. Has any other federal regulatory agency, state regulatory agency, or <em>foreign financial regulatory authority</em>:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1)  Ever found the <em>applicant</em> or a <em>control affiliate</em> to have made a false statement or 
						omission or been dishonest, unfair, or unethical?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isUnethical = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isUnethical = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(2)  Ever found the <em>applicant</em> or a <em>control affiliate</em> to have been involved in a violation 
						of <em>investment-related</em> regulations or statutes?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInViolationOfRegulation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInViolationOfRegulation = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(3)  Ever <em>found</em> the <em>applicant</em> or a <em>control affiliate</em> to have been a cause of an <em>investment-related</em> 
						business having its authorization to do business denied, revoked, or restricted?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInCauseOfDenial = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInCauseOfDenial = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(4)  In the past ten years, entered an order against the <em>applicant</em> or a <em>control affiliate</em> in connection with
						an <em>investment-related</em> activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isOrderAgainstActivity = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isOrderAgainstActivity = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(5)  Ever denied, suspended, or revoked the <em>applicant</em>’s or a <em>control affiliate</em>’s registration or license or
						otherwise, by order, prevented it from associating with an <em>investment-related</em> business or restricted its activities?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isDeniedLicense = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isDeniedLicense = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					E. Has any <em>self-regulatory organization</em>:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1)  <em>found the applicant or a control affiliate</em> to have made a false statement or omission?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundMadeFalseStatement = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundMadeFalseStatement = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(2)  <em>found the applicant</em> or a <em>control affiliate</em> to have been involved in a violation of its rules 
						(other than a violation designated as a <em>"minor rule violation"</em> under a plan approved by the U.S. Securities and
						exchange Commission)?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInViolationOfRules = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInViolationOfRules = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					    (3)  <em>found the applicant or a control affiliate</em> to have been the cause of an <em>investment-related</em> business
						having its authorization to do business denied, suspended, revoked or restricted?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInCauseOfSuspension = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isFoundInCauseOfSuspension = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					    (4) Disciplined the <em>applicant</em> or a <em>control affiliate</em> by expelling or suspending it from membership, barring
						or suspending its association with other members, or otherwise restricting its activities?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isDisciplined = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isDisciplined = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					F. Has the <em>applicant</em>'s or a <em>control affiliate</em>'s authorization to act as an attorney, 
					accountant, or federal contractor ever been revoked or suspended?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isAuthorizedToActAttorney = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isAuthorizedToActAttorney = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					G. Is the <em>applicant</em> or a <em>control affiliate</em> now the subject of any regulatory <em>proceeding</em> 
					that could result in a "yes" answer to any part of 14C, D, or E?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isNamedInRegulatoryProceeding = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:regulatoryActionDisclosure/p:isNamedInRegulatoryProceeding = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		<h4 class="titleNumber">CIVIL JUDICIAL DISCLOSURE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					H. (1) Has any domestic or foreign civil judicial court:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
					    (a) In the past ten years, enjoined the <em>applicant</em> or a <em>control affiliate</em> in connection with 
						any investment-related activity?
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isEnjoined = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isEnjoined = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No				
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
					    (b) Ever <em>found</em> that the <em>applicant</em> or a <em>control affiliate</em> was involved in a violation of 
						<em>investment-related</em> statutes or regulations?
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isFoundInViolationOfRegulation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isFoundInViolationOfRegulation = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						(c)  Ever dismissed, pursuant to a settlement agreement, an <em>investment-related</em> civil judicial action
						brought against the <em>applicant</em> or <em>control affiliate</em> by a state or foreign <em>financial regulatory authority</em>?
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isDismissed = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isDismissed = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					(2) Is the <em>applicant</em> or a <em>control affiliate</em> now the subject of any civil judicial 
					<em>proceeding</em> that could result in a "yes" answer to any part of 14H(1)?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isNamedInCivilProceeding = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageFour/p:civilJudicialActionDisclosure/p:isNamedInCivilProceeding = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No		
				</td>
			</tr>
		</table>

	</xsl:template>
</xsl:stylesheet>