<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="tab3">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - <font style="font-weight:normal">Page 3</font></h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>		
		<h4 class="titleNumber">11.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does the <em>applicant</em> have any arrangement:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					A. With any other <em>person</em>, firm, or organization under which any books or records 
					of the <em>applicant</em> are kept, maintained, or audited by such other <em>person</em>, firm or organization?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isRecordsKept = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isRecordsKept = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>			
			<tr>
				<td class="label">
					B. Under which any other person, firm or organization executes, trades, custodies, clears or 
					settles on behalf of the applicant (including any <em>SRO</em> or swap execution facility in which the 
					applicant is a member)?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isOnBehalf = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isOnBehalf = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "Yes" to any part of Item 11, complete appropriate items on Schedule D, Page 1, Section IV.</em>
			</p>
		</div>	

		<h4 class="titleNumber">12.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does any <em>person</em> directly or indirectly:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					A. <em>Control</em> the management or policies of the <em>applicant</em> through agreement or otherwise?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isControlThroughAgreement = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isControlThroughAgreement = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>			
			<tr>
				<td class="label">
					B. Wholly or partially finance the business of the applicant? <br/><em>Do not answer 
					"Yes" to 12B if the person finances the business of the applicant through: 1) a 
					public offering of securities made pursuant to the Securities Act of 1933; or 2) 
					credit extended in the ordinary course of business by suppliers, banks, and others.</em>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isWhollyOrPartiallyFinance = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isWhollyOrPartiallyFinance = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "Yes" to any part of Item 12, complete appropriate items on Schedule D, Page 1, Section IV.</em>
			</p>
		</div>
		
		<h4 class="titleNumber">13.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Directly or indirectly, does the <em>applicant control</em>, is the <em>applicant controlled</em> by, or is 
					the <em>applicant</em> under common <em>control</em> with, any partnership, corporation, or other organization 
					that is engaged in the securities or investment advisory business?
				</td>
				<td>					
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isEngagedInSecurities = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isEngagedInSecurities = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "Yes" to item 13A, complete appropriate items on Schedule D, Page 2, Section V.</em>
			</p>
		</div>
		
		<table role="presentation">
			<tr>
				<td class="label">
					B. Directly or indirectly, is applicant controlled by any bank holding company or does 
					applicant control, is applicant controlled by, or is applicant under common control with 
					any bank (as defined in 15 U.S.C.78c(a)(6)) or any foreign bank?
				</td>
				<td>					
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isControlWithBank = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:isControlWithBank = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "Yes" to item 13B, complete appropriate items on Schedule D, Page 3, Section VI.</em>
			</p>
		</div>
			
		<h4 class="titleNumber">
			14.
		</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Use the appropriate DRP for providing details to "yes" answers to the questions in Item 14. 
					Refer to the Explanation of Terms section of Form SBSE Instructions for explanations of italicized terms.
				</td>
				<td></td>
			</tr>
		</table>	
		<h4 class="titleNumber">CRIMINAL DISCLOSURE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. In the past ten years has the <em>applicant</em> or a <em>control affiliate</em>:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1) Been convicted of or pled guilty or nolo contendere ("no contest") 
						in a domestic, foreign or military court to any <em>felony</em>?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isConvictedOfFelony = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isConvictedOfFelony = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						(2) Been charged with a <em>felony</em>?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isChargedWithFelony = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isChargedWithFelony = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No			
				</td>
			</tr>
			<tr>
				<td class="label">
					B. In the past ten years has the <em>applicant</em> or a <em>control affiliate</em>:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1)  Been convicted of or pled guilty or or nolo contendere ("no contest") in a domestic, foreign or military
						court to a <em>misdemeanor involving</em>: investments or an <em>investment-related</em> business, or any fraud, false statements 
						or omissions, wrongful taking of property, bribery, perjury, forgery, counterfeiting, extortion, or a conspiracy 
						to commit any of these offenses?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isConvictedMisdemeanor = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isConvictedMisdemeanor = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(2)  Been <em>charged with a misdemeanor</em> specified in 14B(1)?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isChargedMisdemeanor = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageThree/p:criminalDisclosure/p:isChargedMisdemeanor = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No				
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>