<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="tab2">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - <font style="font-weight:normal">Page 2</font></h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
				<b><u></u></b>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>		
		<h4 class="titleNumber">2.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The applicant is registering as a security-based swap dealer:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSwapDealer = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSwapDealer = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			
			<tr>
				<td class="label">
					B. The applicant is registering as a major security-based swap participant:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSwapParticipant = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSwapParticipant = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>			
			
			<xsl:if test="p:applicant/p:applicantDataPageTwo/p:isSwapParticipant = 'Y'">
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse_item2b_first">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:swapOptions/p:swapOption">
						<xsl:if test="contains(., 'swap position')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_item2b_second">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:swapOptions/p:swapOption">
						<xsl:if test="contains(., 'counterparty exposure')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_item2b_third">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:swapOptions/p:swapOption">
						<xsl:if test="contains(., 'capital position')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>			
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						<blockquote>
							Because it: (check all that apply):
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse_item2b_first , 'maintains')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;maintains a substantial security-based swap position<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_item2b_second , 'counterparty')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;has substantial counterparty exposure<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_item2b_third , 'capital')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;is highly leveraged to its capital position						
					</td>
				</tr>
			</xsl:if>
		</table>	
		
		<h4 class="titleNumber">3.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Is the <em>applicant</em> a foreign security-based swap dealer that intends to:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<ul>
							<li>
								work with the Commission and its primary regulator to have the 
								Commission determine whether the requirements of its primary 
								regulator's regulatory system are comparable to the Commission's
							</li>
						</ul>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isCommissionDetermine = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isCommissionDetermine = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<ul>
							<li>
								avail itself of a previously granted substituted compliance determination
							</li>
						</ul>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSelfDetermine = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSelfDetermine = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					with respect to the requirements of Section 15F of the Exchange 
					Act of 1934 and the rules and regulations thereunder?
				</td>
				<td></td>
			</tr>
			<xsl:if test="p:applicant/p:applicantDataPageTwo/p:isCommissionDetermine = 'Y'
						or p:applicant/p:applicantDataPageTwo/p:isSelfDetermine = 'Y'">
				<tr>
					<td class="label">
						B. If "yes" to either of the questions in Item 3.A. above, identify the foreign financial 
						regulatory authority that serves as the <em>applicant</em>'s primary regulator and for which the 
						Commission has made, or may make, a substituted compliance determination:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:applicant/p:applicantDataPageTwo/p:foreignFinancialRegulatory"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p:applicant/p:applicantDataPageTwo/p:isSelfDetermine = 'Y'">
				<tr>
					<td class="label">
						C. If the applicant is relying on a previously granted substituted compliance determination,
						please describe how the <em>applicant</em> satisfies any conditions the Commission may have placed on 
						such substituted compliance determination:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:applicant/p:applicantDataPageTwo/p:description3C"/>
						</div>
					</td>
				</tr>	
			</xsl:if>		
		</table>
		
		<h4 class="titleNumber">4.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does the applicant intend to compute capital or margin, or 
					price customer or proprietary positions, using mathematical models?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isUseMathModels = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isUseMathModels = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>
		
		<h4 class="titleNumber">5.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> subject to regulation by a prudential regulator, 
					as defined in Section 1a(39) of the Commodity Exchange Act.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSubjectToRegulator = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSubjectToRegulator = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>

			<xsl:if test="p:applicant/p:applicantDataPageTwo/p:isSubjectToRegulator = 'Y'">
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse_item5_first">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Reserve Board')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_item5_second">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Comptroller of the Currency')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_item5_third">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Deposit Insurance Corporation')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_item5_fourth">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Credit Administration')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_item5_fifth">
					<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Finance Agency')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>	
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						<blockquote>
							If "yes," identify the prudential regulator:
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse_item5_first , 'Federal Reserve Board')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Reserve Board<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_item5_second , 'Comptroller of the Currency')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Office of the Comptroller of the Currency<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_item5_third , 'Deposit Insurance Corporation')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Deposit Insurance Corporation<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_item5_fourth , 'Farm Credit')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Farm Credit Administration<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_item5_fifth , 'Housing Finance Agency')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Housing Finance Agency
					</td>
				</tr>
			</xsl:if>
		</table>	

		<h4 class="titleNumber">6.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> a U.S. branch of a non-resident entity?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isNonResidentEntity = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isNonResidentEntity = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No				
				</td>
			</tr>
			<xsl:if test="p:applicant/p:applicantDataPageTwo/p:isNonResidentEntity = 'Y'">
				<tr>
					<td class="label">
						<blockquote>
							If "yes," identify the non-resident entity and its location:
						</blockquote>
					</td>
					<td></td>
				</tr>
				
				<!-- If Yes, display the following: -->
				<xsl:for-each select="p:applicant/p:applicantDataPageTwo/p:nonResidentEntity">
					<tr>
						<td class="label">
							<blockquote>
								Entity Name:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Street Address 1:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:entityAddress/p1:street1"/>						
							</div>
						</td>
					</tr>
						<!-- Optional -->
						<tr>
							<td class="label">
								<blockquote>
									Street Address 2:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox">
								<xsl:value-of select="p:entityAddress/p1:street2"/>
								</div>
							</td>
						</tr>	
					<tr>
						<td class="label">
							<blockquote>
								City:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:entityAddress/p1:city"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								State/Country:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode" 
											select="p:entityAddress/p1:stateOrCountry"/>	
								</xsl:call-template>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								Zip + 4 Postal Code:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:entityAddress/p1:zipCode"/>
							</div>
						</td>
					</tr>
				</xsl:for-each>
			</xsl:if>
		</table>
		
		<h4 class="titleNumber">7.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Briefly describe the <em>applicant'</em>s business:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:applicant/p:applicantDataPageTwo/p:descriptionBusiness"/>
					</div>
				</td>
			</tr>
		</table>
	
		<h4 class="titleNumber">8.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Indicate legal status of the <em>applicant</em>:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:legalStatus = 'Corporation'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Corporation<br/>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:legalStatus = 'Partnership'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Partnership<br/>
					<xsl:choose>
						<xsl:when test="contains(p:applicant/p:applicantDataPageTwo/p:legalStatus, 'Limited Liability')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Limited Liability Company<br/>
					<xsl:choose>
						<xsl:when test="contains(p:applicant/p:applicantDataPageTwo/p:legalStatus, 'Other')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other (specify)
				</td>
			</tr>
			
			<xsl:if test="contains(p:applicant/p:applicantDataPageTwo/p:legalStatus, 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If "Other", please specify
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:applicant/p:applicantDataPageTwo/p:otherSpecify"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			
			<tr>
				<td class="label">
					B. Month <em>applicant</em>'s fiscal year ends:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'January'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;January<br/>	
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'February'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;February<br/>
					<xsl:choose>					
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'March'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;March<br/>					
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'April'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;April<br/>	
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'May'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;May<br/>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'June'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;June<br/>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'July'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;July<br/>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'August'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;August<br/>	
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'September'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;September<br/>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'October'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;October<br/>	
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'November'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;November<br/>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:monthApplicantFiscalEnds = 'December'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;December
				</td>
			</tr>
			<tr>
				<td class="label">
					C. Indicate date and place <em>applicant</em> obtained its legal status 
					(i.e., state or country where incorporated, where
					partnership agreement was filed, or where <em>applicant</em> entity was formed):
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						State of formation:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
							select="p:applicant/p:applicantDataPageTwo/p:stateOfFormation"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Country of formation:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="p:applicant/p:applicantDataPageTwo/p:countryOfFormation"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Date of formation:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageTwo/p:dateOfFormation"/>
					</div>
				</td>
			</tr>			
		</table>
		
		<div class="information">
			<p>
				<em>Schedule A and, if applicable, Schedule B must be completed as part of all initial applications.</em>
			</p>
		</div>
		<h4 class="titleNumber">9.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> at the time of this filing <em>succeeding</em> to the business of a currently registered SBS Entity?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSucceeding = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isSucceeding = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>			
		</table>
		
		<div class="information">
			<p>
				<em>If "Yes," complete appropriate items on Schedule D, Page 1, Section III.</em>
			</p>
		</div>		
		
		<h4 class="titleNumber">10.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does the <em>applicant</em> hold or maintain any funds or securities to 
					collateralize counterparty Transactions?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isHoldFunds = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:applicant/p:applicantDataPageTwo/p:isHoldFunds = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>