<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="tab1">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - <font style="font-weight:normal">Page 1</font></h1>
			
		<table role="presentation" id="ombHeaderTable">
			<tr>
				<td class="label" style="width:80%;padding:0px 0px 0px 315px;">			
					<div class="pageHeader" style="border:none;">
						<p id="pageHeaderTitle">
							FORM SBSE
						</p>
						<p id="pageHeaderDetail">
							Uniform Application for Security-based Swap Dealer and 
							<br/>
							Major Security-based Swap Participation Registration
						</p>
						<p id="pageHeaderQuestion">
							Date:&#160;
							<b><u></u></b>
							&#160;&#160;
							SEC Filer No:&#160;
							<b><u></u></b>
						</p>
					</div>		
				</td>
				<td class="label" style="width:20%;">
					<table role="presentation" id="header">
						<tr>
							<td class="title">OMB APPROVAL</td>
						</tr>	
						<tr>
							<td class="side" >
								<p>OMB Number:&#160;&#160;3235-AL05</p>
								<hr/>
								<p>Estimated average burden hours per response – initial: 42 hours</p>
								<hr/>
								<p>Estimated average burden hours per response – amendment: 1 hour</p>
								<hr/>
								<p>Estimated average additional burden hours for Schedule F – initial: 1.5 hours</p>
								<hr/>
								<p>Estimated average additional burden hours per response – amendment: 1.5 hours</p>
							</td>
						</tr>
					</table>				
				</td>
			</tr>
		</table>
				
		<div class="warning">
			<u>WARNING:</u>
			<font style="font-weight:lighter">
				Failure to keep this form current and to file accurate supplementary information on a timely basis, 
				or the failure to keep accurate books and records or otherwise to comply with the provisions of law 
				applying to the conduct of business as an SBS Entity, would violate the Federal securities laws and 
				may result in disciplinary, administrative, injunctive or criminal action.
			</font>
			<br/><br/>		
			<b>INTENTIONAL MISSTATEMENTS OR OMISSIONS OF FACTS MAY CONSTITUTE FEDERAL CRIMINAL VIOLATIONS. </b>
			<br/><br/>
			<font style="font-weight:lighter">
				<em>See</em> 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)
			</font>
		</div>
			
		<h4 class="titleNumber">1. Exact name, principal business address, mailing address, 
		if different, and telephone number of the <em>applicant</em>:</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Full name of the <em>applicant:</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:fullApplicantName"/>						
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					B. Tax Identification No.:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:taxIdentificationNo"/>						
					</div>
				</td>
			</tr>		
			
			<tr>
				<td class="label"><blockquote>Applicant's UIC # (if any):</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:applicantUic"/>
					</div>
				</td>
			</tr>
	
			<tr>
				<td class="label"><blockquote>Applicant's CIK #:</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:applicantCik"/>
					</div>
				</td>
			</tr>
	
			<tr>
				<td class="label">
					C (1). The <em>business name</em> under which the 
					<em>applicant</em> primarily conducts business, if different from 1A.
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:businessName"/>
					</div>
				</td>
			</tr>

			<tr>
				<td class="label"><blockquote>(2). List on Schedule D, Page 1, Section I any other 
				name by which the <em>applicant</em> conducts business and where it is used.</blockquote></td>
				<td></td>
			</tr>

			<tr>
				<td class="label">
					D. If this filing makes a name change on behalf of an <em>applicant</em>, enter the 
					new name and specify whether the change is to the <em>applicant's name</em> (1A) or to the 
					business name (1C):
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p:applicant/p:applicantDataPageOne/p:nameChangeType , 'applicantName')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose><em>Applicant's name</em> (1A)&#160;&#160;		
					<xsl:choose>
						<xsl:when test="contains(p:applicant/p:applicantDataPageOne/p:nameChangeType , 'businessName')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>Business name (1C)
				</td>
			</tr>
			
			<tr>
				<td class="label">
					Please check above.
				</td>
				<td>&#160;</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:changedName"/>					
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					E. <em>Applicant</em>'s Main Address: (Do not use a P.O. Box) 
				</td>
				<td></td>
			</tr>
			
			<tr>
				<td class="label"><blockquote>Street Address 1:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mainAddress/p1:street1"/>
					</div>
				</td>
			</tr>
		
			<tr>
				<td class="label"><blockquote>Street Address 2:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mainAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			
			<tr>
				<td class="label"><blockquote>City:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mainAddress/p1:city"/>
					</div>
				</td>
			</tr>			
						
			<tr>
				<td class="label"><blockquote>State/Province/Country:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param 
								name="stateCode" 
								select="p:applicant/p:applicantDataPageOne/p:mainAddress/p1:stateOrCountry"/>
						</xsl:call-template>					
					</div>						
				</td>
			</tr>
			
			<tr>
				<td class="label"><blockquote>Zip/ Postal Code:</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mainAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				Other business locations must be reported on Schedule E. Security-based swap dealers and major 
				security-based swap participants that do not reside in the United States of America shall designate 
				a U.S. agent for service of process on Schedule F.			
			</p>
		</div>
		
		<table role="presentation">	
			<tr>
				<td class="label">
					F. Mailing Address, if different:  
				</td>
			</tr>

			<tr>
				<td class="label"><blockquote>Street Address 1:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mailingAddress/p1:street1"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label"><blockquote>Street Address 2:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mailingAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			
			<tr>
				<td class="label"><blockquote>City:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mailingAddress/p1:city"/>
					</div>
				</td>
			</tr>			
						
			<tr>
				<td class="label"><blockquote>State/Province/Country:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param 
								name="stateCode" 
								select="p:applicant/p:applicantDataPageOne/p:mailingAddress/p1:stateOrCountry"/>
						</xsl:call-template>								
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label"><blockquote>Zip/ Postal Code:</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:mailingAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>			
		
			<tr>
				<td class="label">
					G. Business Telephone Number:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:businessTelephoneNumber"/>
					</div>
				</td>
			</tr>
				
			<tr>
				<td class="label">
					H. Website/URL:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:websiteUrl"/>					
					</div>
				</td>
			</tr>
		
			<tr>
				<td class="label">
					I. Contact Employee:
				</td>
				<td></td>
			</tr>
		
			<tr>
				<td class="label">
					<blockquote>
						Prefix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:contactEmployeeName/p1:prefix"/>					
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						First Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:contactEmployeeName/p1:firstName"/>				
					</div>
				</td>
			</tr>		

			<tr>
				<td class="label">
					<blockquote>
						Middle Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:contactEmployeeName/p1:middleName"/>					
					</div>
				</td>
			</tr>	

			<tr>
				<td class="label">
					<blockquote>
						Last Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:contactEmployeeName/p1:lastName"/>	
					</div>
				</td>
			</tr>
				
			<tr>
				<td class="label">
					<blockquote>
						Suffix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:contactEmployeeName/p1:suffix"/>	
					</div>
				</td>
			</tr>	
	
			<tr>
				<td class="label">
					<blockquote>
						Title:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:title"/>
					</div>
				</td>
			</tr>
	
			<tr>
				<td class="label">
					<blockquote>
						Phone:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:phone"/>
					</div>
				</td>
			</tr>	
	
			<tr>
				<td class="label">
					<blockquote>
						Email Address:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:contactEmployee/p:emailAddress"/>
					</div>
				</td>
			</tr>
	
			<tr>
				<td class="label">
					J. Chief Compliance Officer designated by the <em>applicant</em> 
					in accordance with Exchange Act Section 15F(k):
				</td>
				<td></td>
			</tr>
	
			<tr>
				<td class="label">
					<blockquote>
						Prefix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:officerName/p1:prefix"/>
					</div>
				</td>
			</tr>
	
			<tr>
				<td class="label">
					<blockquote>
						First Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:officerName/p1:firstName"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						Middle Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:officerName/p1:middleName"/>
					</div>
				</td>
			</tr>
	
			<tr>
				<td class="label">
					<blockquote>
						Last Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:officerName/p1:lastName"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						Suffix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:officerName/p1:suffix"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						Title:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:title"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						Phone:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:phone"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						E-Mail Address:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:applicant/p:applicantDataPageOne/p:chiefComplianceOfficer/p:emailAddress"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>