<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="scheduleE">
		<h1><xsl:value-of select="$submissionType"/>: Schedule E of Form SBSE <font style="font-weight:normal">Page 1</font></h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>	
		<div class="information">
			<p>
				<b>INSTRUCTIONS</b><br/><br/>
				<b>General:</b> Use this schedule to identify other business locations of the applicant. 
				Repeat Items 1-6 for each other business location. Each item must be completed unless 
				otherwise noted. Use additional copies of this schedule as necessary.
				<br/><br/>
				<b>Specific:</b><br/>
				Item 1. Specify only one box. Check “Add” when the applicant is filing the initial notice to 
				inform the Commission that it has opened another "Delete" when the applicant closes another business 
				location, and "Amendment" to indicate any other change to previously  filed information.
				<br/><br/>
				Item 2. Complete this item for all entries. Provide the date that the other business location 
				was opened (ADD), closed (DELETE), or the effective date of the change (AMENDMENT).
				<br/><br/>
				Item 3. Complete this item for all entries. A physical location must be included; 
				post office box designations alone are not sufficient.
				<br/><br/>
				Item 4. Complete this item only when the <em>applicant</em> changes the address 
				of an existing other business location.
				<br/><br/>
				Item 5. If the other business location occupies or shares space on premises within a 
				bank, or other financial institution, enter the name of the institution in the space provided.
				<br/><br/>
				Item 6. Complete this item for all entries. Enter the name of the associated person 
				who is responsible for the operations of, and is physically at, this location.
			</p>
		</div>
		<xsl:for-each select="p:scheduleE/p:scheduleEInfo">
			<table role="presentation">
				<tr>
					<td class="label">
						1. Check only one box:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:businessLocChangeOption = 'Add'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Add
						<xsl:choose>
							<xsl:when test="p:businessLocChangeOption = 'Delete'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Delete
						<xsl:choose>
							<xsl:when test="p:businessLocChangeOption = 'Amendment'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Amendment
					</td>
				</tr>
				<tr>
					<td class="label">
						2. Effective Date:  
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:effectiveDate"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						3. Street Address 1: 
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:applicantAddress/p1:street1"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>Street Address 2:</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:applicantAddress/p1:street2"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>City:</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:applicantAddress/p1:city"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>State/Country:</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
								select="p:applicantAddress/p1:stateOrCountry"/>
							</xsl:call-template>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>Zip + 4 Postal Code:</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:applicantAddress/p1:zipCode"/>
						</div>
					</td>
				</tr>
				<xsl:if test="contains($submissionType , '/A')">
					<tr>
						<td class="label">
							4. New Street Address 1: 
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:applicantNewAddress/p1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>New Street Address 2:</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:applicantNewAddress/p1:street2"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>New City:</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:applicantNewAddress/p1:city"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>New State/Country:</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
										<xsl:with-param name="stateCode"
										select="p:applicantNewAddress/p1:stateOrCountry"/>
									</xsl:call-template>					
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>New Zip + 4 Postal Code:</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:applicantNewAddress/p1:zipCode"/>
							</div>
						</td>
					</tr>
				</xsl:if>	
				<tr>
					<td class="label">
						Institution Name:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:institutionName"/>
						</div>
					</td>
				</tr>				
				<tr>
					<td class="label">
						Responsible Associated Person:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:associatedPerson"/>
						</div>
					</td>
				</tr>			
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>