<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="scheduleD">
		<h1><xsl:value-of select="$submissionType"/>: Schedule D of Form SBSE <font style="font-weight:lighter">Page 1</font></h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>	
		<xsl:call-template name="sbse_scheduleD_page1"/>
		<h1><xsl:value-of select="$submissionType"/>: Schedule D of Form SBSE <font style="font-weight:lighter">Page 2</font></h1>
				<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
				<b><u></u></b>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>	
		<xsl:call-template name="sbse_scheduleD_page2"/>	
		<h1><xsl:value-of select="$submissionType"/>: Schedule D of Form SBSE <font style="font-weight:lighter">Page 3</font></h1>
				<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
				<b><u></u></b>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>	
		<xsl:call-template name="sbse_scheduleD_page3"/>			
	</xsl:template>
	
	<xsl:template name="sbse_scheduleD_page1">
		<h4 class="title1">
			Use Schedule D Page 1 to report details for items listed below.
		</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					This is an INITIAL / AMENDED detail filing for the Form SBSE items checked below:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDOne/p:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDOne/p:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED
				</td>
			</tr>
		</table>
		
		<div id="twoHeaders">
			<h4 class="title1">Section I</h4>
			<h4 class="title2"><em>Other Business Names</em></h4>
		</div>
		<xsl:choose>
			<xsl:when test="count(p:scheduleD/p:scheduleDOne/p:sectionOne) &gt; 0">
				<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionOne">
					<table role="presentation">
						<tr>
							<td class="label">
								<em>(Check if Applicable)</em>
							</td>
							<td>
								<xsl:choose>
									<xsl:when test="contains(p:responseType, '1C')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;Item 1C(2)
							</td>
						</tr>
						<tr>
							<td class="label">
								List each of the "other" names and the state(s) or country(ies) in which they are used.
							</td>
							<td></td>
						</tr>
						<tr>
							<td class="label">
								<blockquote>
									Name
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p:otherName"/>
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">
								<blockquote>
									State/Country
								</blockquote>
							</td>
							<td>
								<div class="fakeBox">
								<xsl:call-template name="stateDescription">
										<xsl:with-param name="stateCode"
										select="p:stateCountry"/>
									</xsl:call-template>					
								</div>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table role="presentation">
					<tr>
						<td class="label">
							<em>(Check if Applicable)</em>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '1C')">
									<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 1C(2)
						</td>
					</tr>
					<tr>
						<td class="label">
							List each of the "other" names and the state(s) or country(ies) in which they are used.
						</td>
						<td></td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								State/Country
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
							</div>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:if test="count(p:scheduleD/p:scheduleDOne/p:sectionTwo) &gt; 0">
			<div id="twoHeaders">
				<h4 class="title1">Section II</h4>
				<h4 class="title2"><em>Other Business</em></h4>
			</div>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionTwo/p:registeredWithCommissionDetails/p:registeredWithCommission">
				<table role="presentation">
					<tr>
						<td class="label">
							<em>(Check if Applicable)</em>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '15')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 15&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '16A')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 16A&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '16B')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 16B					
						</td>
					</tr>
				</table>
				<div class="information">
					<p>
						<em>Applicant</em> must complete a separate Schedule D Page 1 for each affirmative response in this section.
					</p>
				</div>
				<table role="presentation">
					<tr>
						<td class="label">
							<em>Unique Identification Number(s):</em>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:uniqueIdentificationNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<em>Assigning Regulator(s)/Entity(s):</em>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:assigningRegulator"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Briefly describe any other investment-related, non-securities business. 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:description"/>
							</div>
						</td>
					</tr>
				</table>
			</xsl:for-each>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionTwo/p:effectTransactionsDetails/p:effectTransactions">
				<table role="presentation">
					<tr>
						<td class="label">
							<em>(Check if Applicable)</em>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '15')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 15&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '16A')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 16A&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '16B')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 16B					
						</td>
					</tr>
				</table>
				<div class="information">
					<p>
						<em>Applicant</em> must complete a separate Schedule D Page 1 for each affirmative response in this section.
					</p>
				</div>
				<table role="presentation">
					<tr>
						<td class="label">
							<em>Unique Identification Number(s):</em>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:uniqueIdentificationNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<em>Assigning Regulator(s)/Entity(s):</em>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:assigningRegulator"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Briefly describe any other investment-related, non-securities business. 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:description"/>
							</div>
						</td>
					</tr>
				</table>
			</xsl:for-each>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionTwo/p:engagedInNonSecurityDetails/p:engagedInNonSecurity">
				<table role="presentation">
					<tr>
						<td class="label">
							<em>(Check if Applicable)</em>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '15')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 15&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '16A')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 16A&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:responseType, '16B')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Item 16B					
						</td>
					</tr>
				</table>
				<div class="information">
					<p>
						<em>Applicant</em> must complete a separate Schedule D Page 1 for each affirmative response in this section.
					</p>
				</div>
				<table role="presentation">
					<tr>
						<td class="label">
							<em>Unique Identification Number(s):</em>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:uniqueIdentificationNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<em>Assigning Regulator(s)/Entity(s):</em>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:assigningRegulator"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Briefly describe any other investment-related, non-securities business. 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:description"/>
							</div>
						</td>
					</tr>
				</table>
			</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="p:applicant/p:applicantDataPageTwo/p:isSucceeding = 'Y'">
			<div id="twoHeaders">
				<h4 class="title1">Section III</h4>
				<h4 class="title2"><em>Successions</em></h4>
			</div>
			<table role="presentation">
				<tr>
					<td class="label">
						<em>(Check if Applicable)</em>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p:scheduleD/p:scheduleDOne/p:sectionThree/p:responseType, '9')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Item 9
					</td>
				</tr>
				<tr>
					<td class="label">
						<em>Date of Succession</em> MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:scheduleD/p:scheduleDOne/p:sectionThree/p:dateOfSuccession"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<em>Name of Predecessor</em>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:scheduleD/p:scheduleDOne/p:sectionThree/p:nameOfPredecessor"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						IRS Employer Number (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:scheduleD/p:scheduleDOne/p:sectionThree/p:irsEmployerNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						SEC File Number (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:scheduleD/p:scheduleDOne/p:sectionThree/p:secFileNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						UIC Number (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:scheduleD/p:scheduleDOne/p:sectionThree/p:uicNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Briefly describe details of the succession including any assets or liabilities not assumed by the successor. 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:scheduleD/p:scheduleDOne/p:sectionThree/p:description"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:if>
		
		<xsl:if test="count(p:scheduleD/p:scheduleDOne/p:sectionFour) &gt; 0">
			<div id="twoHeaders">
				<h4 class="title1">Section IV</h4>
				<h4 class="title2"><em>Record Maintenance Arrangements / Business Arrangements / Control Persons / Financings</em></h4>
			</div>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionFour/p:recordsKeptDetails/p:recordsKept">
				<xsl:call-template name="sbse_scheduleD_page1_sectionIV"/>
			</xsl:for-each>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionFour/p:onBehalfDetails/p:onBehalf">
				<xsl:call-template name="sbse_scheduleD_page1_sectionIV"/>
			</xsl:for-each>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionFour/p:controlThroughAgreementDetails/p:controlThroughAgreement">
				<xsl:call-template name="sbse_scheduleD_page1_sectionIV"/>
			</xsl:for-each>
			<xsl:for-each select="p:scheduleD/p:scheduleDOne/p:sectionFour/p:whollyOrPartiallyFinanceDetails/p:whollyOrPartiallyFinance">
				<xsl:call-template name="sbse_scheduleD_page1_sectionIV"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="sbse_scheduleD_page2">	
		<div class="information">
			<p>
				Use this Schedule D Page 2 to report details for Item 13A. Supply details for all partnerships, 
				corporations, organizations, institutions and individuals necessary to answer each item completely. 
				Use additional copies of Schedule D Page 2 if necessary.
				<br/><br/> 
				Use the "Effective Date" box to enter the Month, Day, and Year that the affiliation was effective 
				or the date of the most recent change in the affiliation.
			</p>
		</div>
		<table role="presentation">
			<tr>
				<td class="label">
					This is an INITIAL / AMENDED detail filing for the Form SBSE item 13A
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDTwo/p:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDTwo/p:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED
				</td>
			</tr>
			<tr>
				<td class="label">
					Directly or indirectly, does applicant control, is applicant controlled by, or is applicant under 
					common control with, any partnership, corporation, or other organization that is engaged in the 
					securities or investment advisory business?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDTwo/p:engagedInSecurities = '13A'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;13A
				</td>
			</tr>
		</table>
		
		<xsl:if test="p:applicant/p:applicantDataPageThree/p:isEngagedInSecurities = 'Y'">
			<xsl:for-each select="p:scheduleD/p:scheduleDTwo/p:sectionFive">
				<div id="twoHeaders">
					<h4 class="title1">Section V</h4>
					<h4 class="title2"><em>Complete this section for control issues relating to ITEM 13A only.</em></h4>
				</div>
				<table role="presentation">
					<tr>
						<td class="label">
							The details supplied relate to:
						</td>
						<td></td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Partnership, Corporation, or Organization Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:partnerCorpOrgName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								CRD Number (if any)
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:partnerCrdNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								UIC Number (if any)
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:partnerUicNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								<em>(check only one)</em> This Partnership, Corporation, or Organization
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="p:partnerCorpOrgType = 'controls applicant'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;<em>controls applicant</em><br/>
							<xsl:choose>
								<xsl:when test="p:partnerCorpOrgType = 'is controlled by applicant'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;is <em>controlled</em> by <em>applicant</em><br/>
							<xsl:choose>
								<xsl:when test="p:partnerCorpOrgType = 'under common control with applicant'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;under common <em>control</em> with <em>applicant</em>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<h4 class="titleNumber">
							Business Address <em>(Street, City, State/Country, Zip + 4 Postal Code)</em>
							</h4>
						</td>
					</tr>
					<tr>
						<td class="label">
							Street Address 1
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:partnerAddress/p1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Street Address 2
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:partnerAddress/p1:street2"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							City
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:partnerAddress/p1:city"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							State/Country
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode"
									select="p:partnerAddress/p1:stateOrCountry"/>
								</xsl:call-template>						
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Zip + 4 Postal Code
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:partnerAddress/p1:zipCode"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Effective Date    MM  DD YYYY
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:effectiveDate"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Termination Date    MM  DD YYYY
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:terminationDate"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Is Partnership, Corporation or Organization a foreign entity"
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="p:isForeignEntity = 'Y'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Yes
							<xsl:choose>
								<xsl:when test="p:isForeignEntity = 'N'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;No
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								If Yes, provide country of domicile or incorporation"
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode" select="p:countryOfDomicile"/>
								</xsl:call-template>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Check "Yes" or "No" for activities of this partnership Corporation, or organization:
						</td>
						<td></td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Security Activities:
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="p:isSecurityAct = 'Y'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Yes
							<xsl:choose>
								<xsl:when test="p:isSecurityAct = 'N'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;No
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Investment Advisory Activities:
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="p:isInvestmentAdvisoryAct = 'Y'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Yes
							<xsl:choose>
								<xsl:when test="p:isInvestmentAdvisoryAct = 'N'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;No
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Briefly describe the <em>control</em> relationship.
							</blockquote> 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:descriptionRelationship"/>
							</div>
						</td>
					</tr>
				</table>
				<div class="information">
					<p>
						If applicant has more than 3 organizations to report, complete additional Schedule D Page 2s.
					</p>
				</div>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="sbse_scheduleD_page3">	
		<div class="information">
			<p>
				Use Schedule D Page 3 to report details for Item 13B. Report only new information or 
				changes/updates to previously submitted details. Do not report previously submitted 
				information. Supply details for all partnerships, corporations, organizations, institutions 
				and individuals necessary to answer each item completely. Use additional copies of Schedule 
				D Page 3 if necessary.
				<br/><br/> 
				Use the "Effective Date" box to enter the Month, Day, and Year that 
				the affiliation was effective or the date of the most recent change in the affiliation. 
			</p>
		</div>
		<table role="presentation">
			<tr>
				<td class="label">
					This is an INITIAL / AMENDED detail filing for the Form SBSE item 13B
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDThree/p:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDThree/p:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED
				</td>
			</tr>
			<tr>
				<td class="label">
					Directly or indirectly, is applicant controlled by any bank holding company or does applicant 
					control, is applicant controlled by, or is applicant under common control with any bank 
					(as defined in 15 U.S.C. 78c(a)(6)) or any foreign bank? 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:scheduleD/p:scheduleDThree/p:controlWithBank = '13B'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;13B
				</td>
			</tr>
		</table>
		
		<xsl:if test="p:applicant/p:applicantDataPageThree/p:isControlWithBank = 'Y'">
			<xsl:for-each select="p:scheduleD/p:scheduleDThree/p:sectionSix">
				<div id="twoHeaders">
					<h4 class="title1">Section VI</h4>
					<h4 class="title2"><em>Complete this section for control issues relating to ITEM 13B only.</em></h4>
				</div>
				<table role="presentation">
					<tr>
						<td class="label">
							Provide the details for each organization or institution that <em>controls</em> the <em>applicant</em>, 
							including each organization or institution in the <em>applicant's</em> chain of ownership. The details supplied relate to:
						</td>
						<td></td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Financial Institution Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:financialInstitutionName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								CRD Number (if any)
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:crdNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								UIC Number (if any)
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:uicNumber"/>
							</div>
						</td>
					</tr>
					<!-- VARIABLES BEGIN -->
					<xsl:variable name="sbse_institutionType_1">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'bank holding')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_2">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'national bank')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_3">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'state member')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_4">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'state non-member')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_5">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'savings bank')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_6">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'credit union')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_7">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'foreign bank')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<xsl:variable name="sbse_institutionType_8">
						<xsl:for-each select="p:institutionType">
							<xsl:if test="contains(. , 'Other')">
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:variable>
					<!-- VARIABLES END -->
					<tr>
						<td class="label">
							<blockquote>
								Institution Type (<em>e.g., bank holding company, national bank, state member 
								bank of the Federal Reserve System, state non-member bank, savings bank or 
								association, credit union, foreign bank.</em>)
							</blockquote>
						</td>
						<td>
							<em>
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_1 , 'bank holding company')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;bank holding company<br/>
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_2 , 'national bank')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;national bank<br/>	
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_3 , 'state member')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;state member bank of the Federal Reserve System<br/>
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_4 , 'non')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;state non-member bank<br/>
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_5 , 'savings')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;savings bank or association<br/>
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_6 , 'credit')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;credit union<br/>	
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_7 , 'foreign')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;foreign bank<br/>
								<xsl:choose>
									<xsl:when test="contains($sbse_institutionType_8 , 'Other')">
										<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;Other (Specify)	
							</em>					
						</td>
					</tr>
					<xsl:if test="contains($sbse_institutionType_8 , 'Other')">
						<tr>
							<td class="label">
								<blockquote>
									<blockquote>
										If "Other", please specify
									</blockquote>
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p:otherSpecify"/>	
								</div>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td class="label">
							<blockquote>
								Effective Date MM DD YYYY
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:effectiveDate"/>	
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Termination Date MM DD YYYY
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:terminationDate"/>	
							</div>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<h4 class="titleNumber">
								Business Address <em>(Street, City, State/Country, Zip + 4 Postal Code)</em>
							</h4>
						</td>
					</tr>
					<tr>
						<td class="label">
							Street Address 1
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:institutionAddress/p1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Street Address 2
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:institutionAddress/p1:street2"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							City
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:institutionAddress/p1:city"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							State/Country
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode"
										select="p:institutionAddress/p1:stateOrCountry"/>
								</xsl:call-template>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Zip + 4 Postal Code
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:institutionAddress/p1:zipCode"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							If foreign, provide country of domicile or incorporation
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode"
										select="p:countryOfDomicile"/>
								</xsl:call-template>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Briefly describe the control relationship. 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:descriptionRelationship"/>
							</div>
						</td>
					</tr>
				</table>
				<div class="information">
					<p>
						If applicant has more than 4 organizations/institutions to report, complete additional Schedule D page 3s.
					</p>
				</div>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="sbse_scheduleD_page1_sectionIV">
		<table role="presentation">
			<tr>
				<td class="label">
					<em>(Check one)</em>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '11A')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 11A&#160;&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '11B')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 11B&#160;&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '12A')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 12A&#160;&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '12B')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 12B	
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Applicant must complete a separate Schedule D Page 1 for each affirmative response 
				in this section including any multiple responses to any item. Complete the “Effective 
				Date” box with the Month, Day and Year that the arrangement or agreement became effective. 
				When reporting a change or termination of an arrangement, enter the effective date of the change.
			</p>
		</div>
		<table role="presentation">
			<tr>
				<td class="label">
					Firm or Individual?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:firmOrIndividual = 'Firm'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm
					<xsl:choose>
						<xsl:when test="p:firmOrIndividual = 'Individual'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Individual			
				</td>
			</tr>
			<xsl:if test="p:firmOrIndividual = 'Firm'">
				<tr>
					<td class="label">
						Firm or Organization Name
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:firmOrOrganizationName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<h4 class="titleNumber">SEC File, CRD, NFA, IARD, UIC, foreign business No., and/or CIK Number (if any)</h4>
					</td>
				</tr>
				<tr>
					<td class="label">
						SEC File Number (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmSecFileNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						CRD (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmCrdNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						NFA (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmNfa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						IARD (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmIardNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						UIC (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmUic"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Foreign business No. (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmForeignBusinessNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						CIK Number (if any)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmCikNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<h4 class="titleNumber">Business Address <em>(Street, City, State/Country, Zip + 4 Postal Code)</em></h4>
					</td>
				</tr>
				<!-- for firm selection -->
				<tr>
					<td class="label">
						Street Address 1
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmAddress/p1:street1"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Street Address 2
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmAddress/p1:street2"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						City
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmAddress/p1:city"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						State/Country
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
								select="p:firmAddress/p1:stateOrCountry"/>
							</xsl:call-template>					
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Zip + 4 Postal Code
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmAddress/p1:zipCode"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Effective Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmEffectiveDate"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Termination Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmTerminationDate"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Briefly describe the nature of the arrangement with respect to books or records (ITEM 11A); the nature of the execution, 
						trading, custody, clearing or settlement arrangement (ITEM 11B);the nature of the control or agreement (ITEM 12A); or the method and amount of financing (ITEM 12B). 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:descriptionArrangement"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p:firmOrIndividual = 'Individual'">
				<tr>
					<td class="label">
						Individual Name
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>Prefix</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmContactEmployeeName/p1:prefix"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>First Name</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmContactEmployeeName/p1:firstName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>Middle Name</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmContactEmployeeName/p1:middleName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>Last Name</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmContactEmployeeName/p1:lastName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>Suffix</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmContactEmployeeName/p1:suffix"/>
						</div>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<h4 class="titleNumber">CRD, NFA, and/or IARD Number (if any)</h4>
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						CRD Number
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualCrdNo"/>
						</div>
					</td>
				</tr>		
				<tr>
					<td class="label">
						NFA Number
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualNfa"/>
						</div>
					</td>
				</tr>		
				<tr>
					<td class="label">
						IARD Number
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualIardNo"/>
						</div>
					</td>
				</tr>		
									
				<tr>
					<td colspan="2">
						<h4 class="titleNumber">Business Address (if applicable) <em>(Street, City, State/Country, Zip + 4 Postal Code)</em></h4>
					</td>
				</tr>		
				
				<tr>
					<td class="label">
						Street Address 1
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualAddress/p1:street1"/>
						</div>
					</td>
				</tr>		
				<tr>
					<td class="label">
						Street Address 2
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualAddress/p1:street2"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						City
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualAddress/p1:city"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						State/Country
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
								select="p:individualAddress/p1:stateOrCountry"/>
							</xsl:call-template>					
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Zip + 4 Postal Code
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualAddress/p1:zipCode"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Effective Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualEffectiveDate"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Termination Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualTerminationDate"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Briefly describe the nature of the arrangement with respect to books or records (ITEM 11A); the nature of the execution, 
						trading, custody, clearing or settlement arrangement (ITEM 11B);the nature of the control or agreement (ITEM 12A); or the method and amount of financing (ITEM 12B). 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:descriptionArrangement"/>
						</div>
					</td>
				</tr>
				<xsl:if test="contains(p:responseType, '12A')">
					<tr>
						<td class="label">
							For ITEM 12A ONLY - If the control person is an individual not presently registered through 
							CRD or IARD, describe prior investment-related experience (e.g., for each prior position - employer, job title, and dates of service). 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:descriptionExperience"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>