<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="scheduleB">
		<h1><xsl:value-of select="$submissionType"/>: Schedule B of FORM SBSE</h1>	
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>	
		<h4 class="title1">INDIRECT OWNERS (Answer for Form SBSE Item 8)</h4>
		<div class="informationNoBorder">
			<ul style="list-style-type:none;">
				<li>
					<br/>
					1. Use Schedule B to provide information on the <b>indirect</b> owners of the <em>applicant</em>.  
					Use Schedule A to provide information on <b>direct</b> owners. <b>Complete each column</b>.
				</li>
				<li>
					<br/>
					2. With respect to each owner listed on Schedule A, (except individual owners), list below:
					<ul style="list-style-type:none;">
						<li>
							<br/>
							(a) In the case of an owner that is a corporation, each of its shareholders that beneficially owns, 
							has the right to vote, or has the power to sell or direct the sale of, 25% or more of a class of a 
							voting security of that corporation. For purposes of this Schedule, a <em>person</em> beneficially owns any 
							securities (i) owned by his/her child, stepchild, grandchild, parent, stepparent, grandparent, spouse, 
							sibling, mother-in-law, father-in-law, son-in-law, daughter-in-law, brother-in-law, or sister-in-law, 
							sharing the same residence, or (ii) that he/she has the right to acquire, within 60 days, through the 
							exercise of any option, warrant or right to purchase the security.
						</li>
						<li>
							<br/>
							(b) In the case of an owner that is a partnership, <b><u>all</u></b> general partners, and those limited and special 
							partners that have the right to receive upon dissolution, or have contributed, 25% or more of the partnership's capital; and
						</li>
						<li>
							<br/>
							(c) In the case of an owner that is a trust, the trust and each trustee.
						</li>
						<li>
							<br/>
							(d) In the case of an owner that is a Limited Liability Company ("LLC"), (i) those members that have the 
							right to receive upon dissolution, or have contributed, 25% or more of the LLC's capital, and (ii) 
							if managed by elected managers, all elected managers.
						</li>
					</ul>
				</li>
				<li>
					<br/>
					3. Continue up the chain of ownership listing all 25% owners at each level. Once a public company (a company subject to Sections 12
					or 15(d) of the Securities Exchange Act of 1934) is reached, no ownership information further up the chain of ownership need be given.
				</li>
				<li>
					<br/>
					4. In the "DE/FE/I" column, enter "DE" if the owner is a domestic entity, or enter "FE" if owner 
					is an entity incorporated or domiciled in a foreign country, or enter "I" if the owner is an individual.
				</li>
				
				
				<li>
					<br/>
					5. Complete the "Status" column by status as partner, trustee, shareholder, etc., and if shareholder, 
					class of securities owned (if more than one is issued).
				</li>
				<li>
					<br/>
					6. Ownership codes are:			
					<br/><br/>
					<ul style="list-style-type:none">
						<li>C - 25% but less than 50%</li>
						<li>D - 50% but less than 75%</li>
						<li>E - 75% or more</li>
						<li>F – Other General Partners</li>
					</ul>
				</li>
				<li>
					<br/>
					7. (a) In the "Control Person" column, enter "Yes" if <em>person</em> has <em>control</em> as defined in the 
					instructions to this form, and enter "No" if the <em>person</em> does not have <em>control</em>. Note that under this 
					definition most executive officers and all 25% owners, general partners, and trustees would be <em>"control persons"</em>.
					<br/><br/>
					&#160;&#160;&#160;
					(b) In the "PR" column, enter "PR" if the owner is a public reporting company under Sections 12 or 15(d) 
					of the Securities Exchange Act of 1934.
				</li>
			</ul>
			<br/>
		</div>
		
		<xsl:for-each select="p:scheduleB/p:scheduleBInfo">
			<table role="presentation">
				<tr>
					<td class="label">
						Firm or Individual?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:firmOrIndividual = 'Firm'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Firm
						<xsl:choose>
							<xsl:when test="p:firmOrIndividual = 'Individual'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Individual						
					</td>
				</tr>
				<xsl:if test="p:firmOrIndividual = 'Firm'">
					<tr>
						<td class="label">
							<blockquote>
							FULL LEGAL NAME
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:fullLegalName"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="p:firmOrIndividual = 'Individual'">
					<tr>
						<td class="label">
							<blockquote>
							Owner Prefix
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:ownerName/p1:prefix"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
							Owner Last Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:ownerName/p1:lastName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
							Owner First Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:ownerName/p1:firstName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
							Owner Middle Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:ownerName/p1:middleName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
							Owner Suffix
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:ownerName/p1:suffix"/>
							</div>
						</td>
					</tr>
				</xsl:if>	
				<tr>
					<td class="label">
						Domestic Entity/Foreign Entity (entity organized, incorporated, or domiciled in a foreign country)/Individual:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p:entityType, 'DE')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;DE (Domestic Entity)&#160;&#160;
						<xsl:choose>
							<xsl:when test="contains(p:entityType, 'FE')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;FE (Foreign Entity)&#160;&#160;
						<xsl:choose>
							<xsl:when test="contains(p:entityType, 'I')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;I (Individual)					
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Entity in Which Interest is Owned
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:interestOwnedEntity"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Status
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:status"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Date Title or Status Acquired(MM/YYYY)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:dateTitleOrStatusAcquired"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Ownership Code
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'C'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;C-25% but less than 50%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'D'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;D-50% but less than 75%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'E'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;E-75% or more <br/>			
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'F'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;F-Other General Partners
					</td>
				</tr>
				<tr>
					<td class="label">
						Control Person
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:controlPerson = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p:controlPerson = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No						
					</td>
				</tr>
				<tr>
					<td class="label">
						PR
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:pr = 'PR'">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;PR
					</td>
				</tr>
			</table>

			<h4 class="titleNumber">CRD and/or IARD No. and/or foreign business No. If None, IRS Tax No.</h4>

			<table role="presentation">	
				<tr>
					<td class="label">
						CRD No
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:crdNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						IARD No
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:iardNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Foreign business No.
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:foreignBusinessNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						IRS Tax No.
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:irsTaxNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						UIC, if any
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:uic"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>