<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="scheduleA">
		<h1><xsl:value-of select="$submissionType"/>: Schedule A of FORM SBSE</h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;<u><b><xsl:value-of select="$applicantNameHeader"/></b></u>
			</p>
			<p id="pageHeaderDetail">
				Uniform Application for Security-based Swap Dealer and 
				<br/>
				Major Security-based Swap Participation Registration
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				<b><u></u></b>
				&#160;&#160;
				SEC Filer No:&#160;
				<b><u></u></b>
			</p>
		</div>	
		<h4 class="title1">DIRECT OWNERS AND EXECUTIVE OFFICERS(Answer for Form SBSE Item 8)</h4>
		<div class="informationNoBorder">
			<ul style="list-style-type:none;">
				<li>
					<br/>
					1. Use Schedule A to provide information on the <b>direct</b> owners and 
					executive officers of the applicant.  Use Schedule B to provide
					information on <b>indirect</b> owners. <b>Complete each column.</b>
				</li>
				<li>
					<br/>
					2. List below the names of:
					<ul style="list-style-type:none;">
						<li>
							<br/>
							(a) Each Chief Executive Officer, Chief Financial Officer, 
							Chief Operations Officer, Chief Legal Officer, Chief Compliance Officer,
							Director, and individuals with similar status or function;
						</li>
						<li>
							<br/>
							(b) <b>In the case of an <em>applicant</em> that is a corporation</b>, each shareholder that 
							directly owns 5% or more of a class of a voting security of the <em>applicant</em>, unless 
							the <em>applicant</em> is a public reporting company (a company subject to Sections 12 or 15(d) 
							of the Securities Exchange Act of 1934).
							Direct owners include any <em>person</em> that owns, beneficially owns, has the right to vote, 
							or has the power to sell or direct the sale of, 5% or more of a class of a voting security 
							of the <em>applicant</em>. For purposes of this Schedule, a <em>person</em> beneficially owns any securities 
							(i) owned by his/her child, stepchild, grandchild, parent, stepparent, grandparent, spouse, 
							sibling, mother-in-law, father-in-law, son-in- law, daughter-in-law, brother-in-law, or 
							sister-in-law, sharing the same residence, or (ii) that he/she has the right to acquire, within 60
							days, through the exercise of any option, warrant or right to purchase the security.
						</li>
						<li>
							<br/>
							(c) <b>In the case of an <em>applicant</em> that is a partnership, all</b> general partners, and 
							those limited and special partners that have the right to receive upon dissolution, or 
							have contributed, 5% or more of the partnership’s capital; and
						</li>
						<li>
							<br/>
							(d) <b>In the case of a trust</b> that directly owns 5% or more of a class of a voting security of the 
							<em>applicant</em>, or that has the right to receive upon dissolution, or has contributed, 5% or more of the 
							<em>applicant</em>’s capital, the trust and each trustee.
						</li>
						<li>
							<br/>
							(e) <b>In the case of an <em>applicant</em> that is a Limited Liability Company ("LLC")</b>, (i) those members 
							that have the right to receive upon dissolution, or have contributed, 5% or more of the LLC's capital, 
							and (ii) if managed by elected managers, all elected managers.
						</li>
					</ul>
				</li>
				<li>
					<br/>
					3. <b>Are there any indirect owners</b> of the applicant required to be reported on Schedule B?
					&#160;&#160;&#160;&#160;&#160;
					<div style="display:inline; background-color: #e0e0ff">
						<xsl:choose>
							<xsl:when test="p:scheduleA/p:isAnyIndirectOwners = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p:scheduleA/p:isAnyIndirectOwners = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No
					</div>
				</li>
				<li>
					<br/>
					4. <b>In the "DE/FE/I" column</b>, enter "DE" if the owner is a domestic entity, or enter "FE" if owner 
					is an entity incorporated or domiciled in a foreign country, or enter "I" if the owner is an individual.
				</li>
				<li>
					<br/>
					5. <b>Complete the "Title or Status"</b> column by entering board/management titles; status as partner, trustee, 
					sole proprietor, or shareholder; and for shareholders, the class of securities owned (if more than one is issued).
				</li>
				<li>
					<br/>
					6. <b>Ownership codes are:</b>			
					<br/><br/>
					<ul style="list-style-type:none">
						<li>NA - less than 5%	</li>
						<li>A - 5% but less than 10%</li>
						<li>B - 10% but less than 25%</li>
						<li>C - 25% but less than 50%</li>
						<li>D - 50% but less than 75%</li>
						<li>E - 75% or more</li>
					</ul>
				</li>
				<li>
					<br/>
					7. (a) <b>In the "Control Person" column</b>, enter "Yes" if <em>person</em> has <em>control</em> as defined in the 
					instructions to this form, and enter "No" if the <em>person</em> does not have <em>control</em>. Note that under this 
					definition most executive officers and all 25% owners, general partners, and trustees would be <em>"control persons"</em>.
					<br/><br/>
					&#160;&#160;&#160;
					(b) <b>In the "PR" column</b>, enter “PR” if the owner is a public reporting company under Sections 12 or 15(d) 
					of the Securities Exchange Act of 1934.
				</li>
			</ul>
			<br/>
		</div>
		<xsl:for-each select="p:scheduleA/p:scheduleAInfo">
			<table role="presentation">
				<tr>
					<td class="label">
						Firm or Individual?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:firmOrIndividual = 'Firm'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Firm
						<xsl:choose>
							<xsl:when test="p:firmOrIndividual = 'Individual'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Individual
					</td>
				</tr>
				<xsl:if test="p:firmOrIndividual = 'Firm'">
					<tr>
						<td class="label">
							<blockquote>
							FULL LEGAL NAME
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:fullLegalName"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				
				<xsl:if test="p:firmOrIndividual = 'Individual'">
					<tr>
						<td class="label">
							<blockquote>
							Prefix
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:individualName/p1:prefix"/>
							</div>
						</td>
					</tr>
					
					<tr>
						<td class="label">
							<blockquote>
							Last Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:individualName/p1:lastName"/>
							</div>
						</td>
					</tr>
					
					<tr>
						<td class="label">
							<blockquote>
							First Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:individualName/p1:firstName"/>
							</div>
						</td>
					</tr>
					
					<tr>
						<td class="label">
							<blockquote>
							Middle Name
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:individualName/p1:middleName"/>
							</div>
						</td>
					</tr>
				
					<tr>
						<td class="label">
							<blockquote>
							Suffix
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:individualName/p1:suffix"/>
							</div>
						</td>
					</tr>
				</xsl:if>	
				<tr>
					<td class="label">
						Domestic Entity/Foreign Entity (entity organized, incorporated, or domiciled in a foreign country)/Individual:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:entityType = 'DE'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;DE (Domestic Entity)&#160;&#160;
						<xsl:choose>
							<xsl:when test="p:entityType = 'FE'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;FE (Foreign Entity)&#160;&#160;
						<xsl:choose>
							<xsl:when test="p:entityType = 'I'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;I (Individual)
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Title or Status
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:titleOrStatus"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Date Title or Status Acquired(MM/YYYY)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:dateTitleOrStatusAcquired"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Ownership Code
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'NA'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;NA-less than 5% <br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'A'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;A-5% but less than 10%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'B'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;B-10% but less than 25% <br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'C'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;C-25% but less than 50% <br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'D'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;D-50% but less than 75% <br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'E'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;E-75% or more
					</td>
				</tr>

				<tr>
					<td class="label">
						Control Person
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:controlPerson = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p:controlPerson = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No						
					</td>
				</tr>

				<tr>
					<td class="label">
						PR
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:pr = 'PR'">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;PR
					</td>
				</tr>
			</table>
			
			<h4 class="titleNumber">
				CRD and/or IARD No. and/or foreign business No. If None, IRS Tax No.
			</h4>
			<table role="presentation">	
				<tr>
					<td class="label">
						CRD No
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:crdNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						IARD No
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:iardNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						Foreign business No.
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:foreignBusinessNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						IRS Tax No.
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:irsTaxNo"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						UIC, if any
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:uic"/>
						</div>
					</td>
				</tr>
				
				<tr>
					<td class="label">
						For individuals not presently registered through CRD or IARD, describe prior 
						<em>investment-related</em> experience (e.g., for each prior position - employer, job 
						title, and dates of service): 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:description"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>